/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fZoD
 */

package {
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
       public var bm:BitmapData;
       public var pic:Bitmap;
       public var miniMap:Bitmap;
       
       public var canvas:BitmapData = new BitmapData(200, 200, false, 0);
       
       public var maxAct:int = 128; 
       public var vecAct:Vector.<Actor> = new Vector.<Actor>(maxAct, false);
       
        public function FlashTest() {
            
            bm = new BitmapData(32,32,false, 0);
            pic = new Bitmap(canvas);
            addChild(pic);
            //pic.scaleY = 2;
            //pic.scaleX = 2;
            
            miniMap = new Bitmap(bm);
            miniMap.alpha = 0.5;
            miniMap.scaleX = 0.5;
            miniMap.scaleY = 0.5;
            addChild(miniMap);
            
            var r:Rectangle = new Rectangle();
            
            bm.fillRect(bm.rect, 0x888888);
            //bm.noise(23);
            
            var i:int;
            for (i =0; i < 48; i++)
            {
                r.x = Math.random()*64;
                r.y = Math.random()*64;
                r.width = 3+Math.random()*8;
                r.height = 3+Math.random()*8
                bm.fillRect(r,0);
            }//nexti
            
            
           // bm.fillRect(new Rectangle(0,63,64,1), 0x888888);
            
            drawMap(canvas, bm, 0,0 );
            
            cellw = 16;
            cellh = 16;
            icw = 1/cellw;
            ich = 1/cellh;
            
            ww = bm.width * cellw;
            wh = bm.height * cellh;
            
            var i:int;
            var a:Actor;
            
            for (i = 0; i < 32; i++)
            {
                a = new Actor();
                a.cx = Math.random() * ww;
                a.cy = Math.random() * wh;
                a.initGame(this);
                vecAct[i] = a;
            }//nexti
            
            
  
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);          
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);
        
        public function kdown(e:KeyboardEvent):void
        { vecKey[e.keyCode] = true; }
        
        public function kup(e:KeyboardEvent):void
        { vecKey[e.keyCode] = false; }
        
        public var camx:Number = 0;
        public var camy:Number = 0;
        public var cellw:Number = 16;
        public var cellh:Number = 16;
        public var icw:Number = 1/16;
        public var ich:Number = 1/16;
        public var ww:Number = 320; //worldwidth
        public var wh:Number = 240; //worldheight
        
        public function isWall(tx:Number, ty:Number):Boolean
        {
            var kx:int;
            var ky:int;
            
            if (tx < 0) { return true; }
            if (tx >= ww) { return true; }
            if (ty < 0) { return true; }
            if (ty >= wh) { return true;} 
            
            kx = Math.floor( tx * icw);
            ky = Math.floor( ty * ich);
            
          
            
            return (bm.getPixel(kx, ky) != 0);
        }//iswall
        
        
        public var pwx:Number = 200;
        public var pwy:Number = 200;
        
        public function onEnter(e:Event):void
        {
            
            
            if (vecKey[Keyboard.UP] ) { pwy -= 8; }
            if (vecKey[Keyboard.DOWN] ) { pwy += 8; }
            if (vecKey[Keyboard.LEFT] ) { pwx -= 8; }
            if (vecKey[Keyboard.RIGHT] ) { pwx += 8; }
            
            if (pwx < 100) { pwx = 100; }
            if (pwy < 100) { pwy = 100; }
            if (pwx > ww -100) { pwx = ww-100;}
            if (pwy > wh -100) { pwy = wh-100;}
            
            
            var mx:Number;
            var my:Number;
            var px:Number;
            var py:Number;
            
            px = pwx;
            py = pwy;
            
            //px = mouseX;
           // py = mouseY;
            
            camx = px - 100;
            camy = py - 100;
            
           if (camx < 0) { camx = 0;}
           if (camy < 0) { camy = 0; }
           if (camx > (ww-200)) { camx = ww-200;}
           if (camy > (wh-200)) { camy = wh-200;}
            
            mx = camx + pic.mouseX;
            my = camy + pic.mouseY;
            
            canvas.lock();
                canvas.fillRect(canvas.rect, 0);
                drawMap(canvas, bm, camx, camy);
            
               canvas.setPixel(px-camx, py-camy, 0xFFffFF);    
            
                //debug
                if (isWall(mx, my))
                {
                     canvas.fillRect(new Rectangle(mx-3-camx,my-camy-3,6,6),0xFFffFF);   
                }//endif
                
                var i:int;
                var num:int;
                var a:Actor;
                
                num = vecAct.length;
                
                for (i = 0; i < num; i++)
                {
                    a = vecAct[i];
                    if (a == null) { continue; }
                    a.update();
                    a.render(canvas, camx, camy);
                }//nexti
            
            canvas.unlock();
            
            
        }//onenter
        
        public var reg:BitmapData = new BitmapData(16,16,false,0);
        public var rrect:Rectangle = new Rectangle(0,0,16,16);
        public var pnt:Point =  new Point();
        public var mat:Matrix = new Matrix();
        public function drawMap(to:BitmapData, m:BitmapData, sx:Number, sy:Number):void
        {
            
            
            rrect.x = Math.floor(sx * icw);
            rrect.y = Math.floor(sy * ich);
            
            reg.fillRect(reg.rect, 0);
            reg.copyPixels(m, rrect, pnt);
            
            var ox:int;
            var oy:int;
            
            ox = (sx) % cellw;
            oy = (sy) % cellh;
            
            mat.identity();
            mat.scale(cellw, cellh);
            mat.translate(-ox, -oy);
            
            to.draw(reg, mat);
            
            
            /*
            mat.identity();
            mat.scale(cellw, cellh);
            mat.translate(-sx, -sy);
            
            to.draw(m, mat);
            */
            
            //to.draw(m);
        }//drawmap
        
        
    }//classend
}//package
import flash.geom.Rectangle;
import flash.display.BitmapData;

internal class Actor
{
    public var cx:Number = 0;
    public var cy:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var xrad:Number = 4;
    public var yrad:Number = 4;
    public var col:uint = 0xFFffFF;
    public var w:int = 0;
    public var ready:int = 0;
    public var flags:int = 0;
    public var spec:int = 0;
    public var team:int = 0;
    
    public var game:FlashTest;

    public function Actor()
    {
        
    }//ctor    
    
    public function initGame(game_:FlashTest):void
    {
     game = game_;
     init();   
    }//initgame
    
    public function init():void
    {
        
        
    }//init
    
    public function isOver(a:Actor):Boolean
    {
        if (cx + xrad < a.cx - a.xrad) { return false;}
        if (cx - xrad > a.cx + a.xrad) { return false; }
        if (cy + yrad < a.cy - a.yrad) { return false;}
        if (cy - yrad > a.cy + a.yrad) { return false; }
        
        return true;
    }//isover
    
    public static var sre:Rectangle = new Rectangle();
    public function render(to:BitmapData, sx:Number, sy:Number):void
    {
        sre.x = cx - xrad - sx;
        sre.y = cy - yrad - sy;
        sre.width = xrad*2;
        sre.height = yrad*2;
        
        to.fillRect(sre, col);
        
        
    }//render
    
    public function update():void
    {
        if (ready == 0)
        {
             if (game.isWall(cx,cy)) 
             {
                 cx = Math.random() * game.ww;
                 cy = Math.random() * game.wh;
                  return;
             }   
            ready = 1;
            
        }//endif
        
        
        vy += 0.2;
        
        var bGround:int;
        bGround = 0;
        
        if (game.isWall(cx,cy+yrad+1)) { bGround = 1; }
        
        if (bGround) { w += 1; }
        if (w >= 32)
        {
         w = 0;
         vx = (Math.random()-Math.random()) * 4;
         vy = -1 + (Math.random()-Math.random()) * -4;
         
         if (vx > 0 && game.isWall(cx+xrad+1, cy) ) { vx = -vx; }
         else if (vx < 0 && game.isWall(cx-xrad-1,cy) ) { vx = -vx; }   
        }//endif
        
        
        
        if (vy > 0 && game.isWall(cx,cy+yrad)) { vy = 0; }
        if (vy < 0 && game.isWall(cx,cy-yrad)) { vy = 0; }
        if (vx > 0 && game.isWall(cx+xrad,cy)) { vx = 0; }
        if (vx < 0 && game.isWall(cx-xrad,cy)) { vx = 0; }
        
        cx += vx;
        cy += vy;
        
        
        if (bGround && vy >= 0)
        {
            vx *= 0.91;
            if (game.isWall(cx,cy+yrad-1)) { cy -= 1; }
            if (game.isWall(cx,cy+yrad+1)==false) { cy += 1;} 
        }//endif
        
        
        
    }//update
    
    
};//actor

