/**
 * Copyright WeiChih_Lin ( http://wonderfl.net/user/WeiChih_Lin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fZiD
 */

package 
{
    import Math;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import flash.utils.Timer;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize; 
    import flash.system.System;
    
    
    /**
     * ...
     * @author Wei-Chih Lin
     *         E-mail : weichih25@gmail.com
     */
    [SWF(backgroundColor = "#000000", width = "600", height = "600", frameRate = "60")]
    public class Dots extends Sprite 
    {
        
        private const CIRCLE_SIZE:uint = 24;
        private const RADIUS:uint = 150;
        
        private var _spriteArray:Array;
        private var _mouseX:Number;
        private var _mouseY:Number;
        private var _timer:Timer = new Timer(30, Number.MAX_VALUE);
        private var _isPressed:Boolean = false;
        private var _lastTime:uint = getTimer();
        private var _infoTextField:TextField;
        private var _infoTextColor:uint = 0xFFDA22;
        private var _infoBgColor:uint = 0xE81633;
        private var _infoTransparent:Boolean = true;

       
        public function Dots():void 
        {
          
            _spriteArray = new Array(25);
            for (var x:int = 0 ; x < 25 ; x++) {
                _spriteArray[x] = new Array(25);
            }
            
            var delay:Number = 0.05;
            for ( var i:int = 0; i < 25 ; i++) {
                
                var colorUint:uint = 0;
                var r:int=0;
                var g:int=0;
                
                for ( var j:int = 0; j < 25 ; j++) {
                    
                    _spriteArray[j][i] = new CircleBotton() ;
                    addChild(_spriteArray[j][i].getSprite());
                    
                    _spriteArray[j][i].setPosX(i * CIRCLE_SIZE + CIRCLE_SIZE/2);
                    _spriteArray[j][i].setPosY(j * CIRCLE_SIZE + CIRCLE_SIZE/2);
                    _spriteArray[j][i].setHeight(CIRCLE_SIZE);
                    _spriteArray[j][i].setWidth(CIRCLE_SIZE);
                    r = 0xCC -int(0xCC / 25) * (j+1);
                    colorUint = r;
                    colorUint <<= 8;
                    g = 255 - int(50 / 25) * (j+1);
                    colorUint += g;
                    colorUint <<= 8;
                    _spriteArray[j][i].setColor(colorUint);
                    
                }
            }
            
            _timer.addEventListener(TimerEvent.TIMER, setMotions);
            _timer.start();
            fpsInfoInit();
            
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove); 
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
            
            
        }
        
        private function fpsInfoInit():void {
            _infoTextField = new TextField();
            _infoTextField.selectable = false;
            _infoTextField.background = _infoTransparent;
            _infoTextField.textColor = _infoTextColor;
            _infoTextField.backgroundColor = _infoBgColor;
            _infoTextField.autoSize = TextFieldAutoSize.LEFT;
            var format:TextFormat = new TextFormat();
            format.font = "Courier New";
            format.size = 16;
            format.bold = true;
            _infoTextField.setTextFormat(format);
            _infoTextField.defaultTextFormat = format;
            _infoTextField.text = "Loading...";
            addChild(_infoTextField);
            stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            _infoTextField.x = 20;
            _infoTextField.y = 10;
        }
        
        private function mouseMove(event:MouseEvent):void {
            _mouseX = event.stageX;
            _mouseY = event.stageY;
        }
        
        private function mouseDown(event:MouseEvent):void {
            _isPressed = true;
        }
        private function mouseUp(event:MouseEvent):void {
            _isPressed = false;
        }
        
        private function setMotions(event:TimerEvent):void {
            var mcPosX:Number;
            var mcPosY:Number;
            var distanceX:Number;
            var distanceY:Number;
            var distance:Number;
            var size:Number;
            
            for ( var i:int = 0; i < 25 ; i++) {
                for ( var j:int = 0; j < 25 ;j++) {
                    
                    size = _spriteArray[j][i].getWidth();
                    mcPosX = _spriteArray[j][i].getPosX();
                    mcPosY = _spriteArray[j][i].getPosY();
                    distanceX = mcPosX - _mouseX
                    distanceY = mcPosY - _mouseY;
                    
                    distance = Math.sqrt(Math.pow(distanceX,2)  +Math.pow(distanceY,2));
            
                    
                    if(_isPressed){
                        if (distance < RADIUS) {
                            if (size > 10) size -= (1 -distance / RADIUS) * 2.5; 
                        }else {
                            if (size < CIRCLE_SIZE) size += 1;
                        }
                    }else {
                            if (size < CIRCLE_SIZE) size += 1;
                    }
                    
                    _spriteArray[j][i].setWidth(size);
                    _spriteArray[j][i].setHeight(size);
                
                }
            }
        }
        
        private function enterFrameHandler(evt:Event):void {
            var currentTime:uint = getTimer();
            var deltaTime:uint = currentTime - _lastTime;
            var fps:Number = 1/ deltaTime * 1000;
            
            _infoTextField.text = "FPS: " + fps.toFixed(1);
            _infoTextField.appendText("\nMemory: " + Number(System.totalMemory / 1024 / 1024).toFixed(3) + "(M)");
            _lastTime = currentTime;
        }
    }
    
}

class CircleBotton {
    
        import flash.display.Sprite;
        
        private var _posX:Number;
        private var _posY:Number;
        private var _width:Number
        private var _height:Number;
        private var _sprite:Sprite;
        private var _color:uint;
        
        
        public function CircleBotton():void{
            _color = 0xffffff;
            _sprite = new Sprite();
            drawCircle();
        }
        
        private function drawCircle():void {
            _sprite.graphics.beginFill(_color);
            _sprite.graphics.drawCircle(0, 0, 20);
            _sprite.graphics.endFill();
        }
        
        public function clear():void {
            _sprite.graphics.clear();
        }
        
        public function getPosX():Number {
            return _posX;
        }
        public function getPosY():Number {
            return _posY;
        }
        
        public function getWidth():Number{
            return _width;
        }
        public function getHeight():Number{
            return _height;
        }
    
        public function getSprite():Sprite {
            return _sprite;
        }
        
        public function getColor():uint {
            return _color;
        }
        
        public function setColor(value:uint):void {
            _color = value;
            drawCircle();
        }
        
        public function setPosX(px:Number):void {
            _posX = px;
            _sprite.x = _posX;
        }
        
        public function setPosY(py:Number):void {
            _posY = py;
            _sprite.y = _posY;
        }
        
        public function setWidth(length:Number):void {
            _width = length;
            _sprite.width = _width;
        }
        public function setHeight(length:Number):void {
            _height = length;
            _sprite.height = _height;
        }
        
}