/**
 * Copyright hacker_l5ashgjg ( http://wonderfl.net/user/hacker_l5ashgjg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fZaq
 */

// forked from hacker_l5ashgjg's forked from: HSVClock forked from: ColorModeHSVSample
// forked from umhr's HSVClock forked from: ColorModeHSVSample
// forked from nutsu's ColorModeHSVSample
// see http://gihyo.jp/design/feature/01/frocessing/0002
/*
 * 
 * なんかこの本の表紙がきれいだなと思ったから。
 * http://www.amazon.co.jp/gp/product/4774123641/;
 * */
package 
{
	import flash.display.Sprite;
	import flash.geom.PerspectiveProjection;
	[SWF(width = 465, height = 465, backgroundColor = 0x000000)]
	public class Main extends Sprite 
	{
		public function Main():void 
		{
			this.transform.perspectiveProjection = new PerspectiveProjection();
			this.transform.perspectiveProjection.focalLength = 300;
			
			var cr:ColorRings = new ColorRings();
			cr.x = 465 / 2-30;
			cr.y = 465 / 2-30;
			cr.z = 0;
			cr.rotationX = -30;
			cr.rotationY = 50;
			addChild(cr);
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.ITween;
class ColorRings extends Sprite {
	private var _hColors:FullColors;
	private var _mColors:FullColors;
	private var _sColors:FullColors;
	private var _hours:int = 0;
	private var _minutes:int = 0;
	private var _seconds:int = 0;

	public function ColorRings() {
		_sColors = new FullColors(60,220,0.3);
		_sColors.z = 10;
		addChild(_sColors);
		
		_mColors = new FullColors(60,190,0.6);
		_mColors.z = 0;
		addChild(_mColors);
		
		_hColors = new FullColors(24,150,1);
		_hColors.z = -10;
		addChild(_hColors);
		
		this.addEventListener(Event.ENTER_FRAME, onEnter);
	}
	private function onEnter(event:Event):void {
		var date:Date = new Date();
		if (_hours != date.getHours()) {
			_hours = date.getHours();
			BetweenAS3.tween(_hColors, { rotation:_hours * (360/24) }, null, 12, Back.easeOut).play();
		}
		if (_minutes != date.getMinutes()) {
			_minutes = date.getMinutes();
			BetweenAS3.tween(_mColors, { rotation:_minutes * (360 / 60) }, null, _minutes?5:10, Back.easeOut).play();
		}
		if (_seconds != date.getSeconds()) {
			_seconds = date.getSeconds();
			BetweenAS3.tween(_sColors, { rotation:_seconds * (360 / 60) }, null, _seconds?0.3:0.9, _seconds?Back.easeOut:Quad.easeOut).play();
		}
	}
}


import frocessing.display.F5MovieClip2D;
class FullColors extends F5MovieClip2D {
	public function FullColors(n:int,r:Number,s:Number) {
		//線は描画しない
		this.noStroke();
		
		//HSVで色指定
		//値の範囲を,色相(0～n),彩度(0～1),明度(0～n)に指定
		this.colorMode( HSV, n, 1, n );
		
		for ( var i:int = 0; i < n; i++ ) {
			
			//塗りの指定
			this.fill( i, 1, n*s );
			
			//円の描画
			var cx:Number = Math.cos(Math.PI * 2 * i / n) * r;
			var cy:Number = Math.sin(Math.PI * 2 * i / n) * r;
			this.circle( 0.5*cx, 1.5*cy, r *1.5* 0.97 * Math.PI / n );
			this.circle( 0.5*cy, 1.5*cx, r *1.5* 0.97 * Math.PI / n );
			this.circle( 0.5*cy, 0.5*cx, r *1.5* 0.97 * Math.PI / n );
			this.scaleX = 0.66;
			this.scaleY = 0.66;
		}
	}
}