/**
 * Copyright sekiryou ( http://wonderfl.net/user/sekiryou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fYww
 */

// forked from Event's Human Clock
/**
* 指描時計
* @author Masayuki Komatsu / sekiryou.com
* http://twitter.com/sekiryou_com
*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.*;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    
    public class index extends Sprite {
        private const ZERO_POINT:Point = new Point(0, 0);
        private const RECT:Rectangle = new Rectangle(0, 0, 465, 465);
        private const CTF:ColorTransform = new ColorTransform(1, 1, 1, 0.95);;
        
        private var board:BitmapData = new BitmapData(465, 465, true, 0x00FFFFFF);
        private var hourCanvas:BitmapData = new BitmapData(465, 465, true, 0x00FFFFFF);
        private var minCanvas:BitmapData = new BitmapData(465, 465, true, 0x00FFFFFF);
        private var secCanvas:BitmapData = new BitmapData(465, 465, true, 0x00FFFFFF);
        private var efx:BitmapData = new BitmapData(465, 465, true, 0x00FFFFFF);
        private var expTime:int = 61;
        private var shimonBMD01:BitmapData
        private var shimonBMD02:BitmapData
        private var shimonBMD03:BitmapData
        private var shimonBMD04:BitmapData
        private var shimonBMD05:BitmapData
        private var shimonBMD:Vector.<BitmapData> = new Vector.<BitmapData>(5, false);
        private var mtrx:Matrix = new Matrix();
        
        public function index() {
            Wonderfl.capture_delay(60);
            var capture:Bitmap = new Bitmap(new BitmapData(465, 465, false, 0x000000));
            addChild(capture);
            
            init();
        }
        private function init():void {
            addChild(new Bitmap(efx));
            addChild(new Bitmap(board));
            addChild(new Bitmap(secCanvas));
            addChild(new Bitmap(minCanvas));
            addChild(new Bitmap(hourCanvas));
            
            shimonBMD[0] = new BitmapData(88, 162, true, 0x00000000);
            shimonBMD[0].setVector(shimonBMD[0].rect, shimonData01);
            shimonBMD[1] = new BitmapData(64, 99, true, 0x00000000);
            shimonBMD[1].setVector(shimonBMD[1].rect, shimonData02);
            shimonBMD[2] = new BitmapData(84, 144, true, 0x00000000);
            shimonBMD[2].setVector(shimonBMD[2].rect, shimonData03);
            shimonBMD[3] = new BitmapData(87, 158, true, 0x00000000);
            shimonBMD[3].setVector(shimonBMD[3].rect, shimonData04);
            shimonBMD[4] = new BitmapData(76, 104, true, 0x00000000);
            shimonBMD[4].setVector(shimonBMD[4].rect, shimonData05);
            
            for (var i:int = 0; i < 12; i++) {
                notch[i] = int(Math.random() * 5);
                notchAngle[i] = Math.random() * 360;
                notchCount[i] = 0;
                notchWaitCount[i] = 0;
            }
            count = 0;
            ptAngle = 0;
            addEventListener(Event.ENTER_FRAME, boardDesign);
            addEventListener(Event.ENTER_FRAME, update);
        }
        private var notch:Vector.<int> = new Vector.<int>(12, false);
        private var notchAngle:Vector.<Number> = new Vector.<Number>(12, false);
        private var notchCount:Vector.<Number> = new Vector.<Number>(12, false);
        private var notchWaitCount:Vector.<Number> = new Vector.<Number>(12, false);
        private var count:int;
        private var ptAngle:int;
        private function boardDesign(e:Event = null):void {
            const RADIUS:Number = 233;
            const DIV:int = 80;
            const WAIT:int = 15;
            var scale:Number = 0.4 + Math.random() * 0.12;
            
            if (ptAngle == 5 && count == 0) {
                var tmp:int = 4;
                mtrx.identity();
                mtrx.translate( -shimonBMD[tmp].width * 0.5, -shimonBMD[tmp].height * 0.5);
                mtrx.scale(0.6, 0.6);
                mtrx.rotate(Math.random() * 360);
                mtrx.translate(233, 233);
                board.draw(shimonBMD[tmp], mtrx, new ColorTransform(1, 1, 1, 1, 0x33, 0x66, 0xFF));
            }
        
            for (var i:int = 0; i < ptAngle; i++) {
                if ( i < 6) {
                    var angle:Number = ((i * 60 - 90) * Math.PI / 180);
                } else {
                    angle = ((i * 60 - 60) * Math.PI / 180);
                }
                if (notchWaitCount[i] == 0) {
                    mtrx.identity();
                    mtrx.translate( -shimonBMD[notch[i]].width * 0.5, -shimonBMD[notch[i]].height * 0.5);
                    mtrx.scale(scale, scale);
                    mtrx.rotate(notchAngle[i] + Math.random() * 0.1);
                    radius = RADIUS - RADIUS * (notchCount[i] / DIV);
                    mtrx.translate(Math.cos(angle) * radius + 233, Math.sin(angle) * radius + 233);
                    board.draw(shimonBMD[notch[i]], mtrx, new ColorTransform(1, 1, 1, 1, 0xFF, 0xFF, 0xFF));
                } else if (notchWaitCount[i] > WAIT) {
                    for (var j:int = 0; j < 8; j++) {
                        mtrx.identity();
                        mtrx.translate( -shimonBMD[notch[i]].width * 0.5, -shimonBMD[notch[i]].height * 0.5);
                        mtrx.scale(scale, scale);
                        mtrx.rotate(notchAngle[i] + Math.random() * 0.1);
                        var radius:Number = RADIUS - RADIUS * (notchCount[i] / DIV) / 4;
                        
                        if (notchCount[11] > DIV) {
                            removeEventListener(Event.ENTER_FRAME, boardDesign);
                            isBoardFirst = false;
                        } else {
                            mtrx.translate(Math.cos(angle) * radius + 233, Math.sin(angle) * radius + 233);
                            board.draw(shimonBMD[notch[i]], mtrx, new ColorTransform(1, 1, 1, (1 - (notchCount[i] / DIV)) * 0.08, 0xFF, 0xFF, 0xFF));
                        }
                        notchCount[i] += 1;
                    }
                }
                notchWaitCount[i] += 1;
            }
            
            if (ptAngle < 12) {
                count += 1;
                if (count > 12) {
                    ptAngle += 1;
                    count = 0;
                }
            }
        }
        private var minStamp:int = 0;
        private var minAngle:Number = 0;
        private var fpmAngle:Number = 0;
        private var minCount:int = 0;
        private var waitMinCount:int = 0;
        private function minUpdate(e:Event = null):void {
            const RADIUS:Number = 180;
            const DIV:int = 144;
            const WAIT:int = 30;
            var scale:Number = 0.4 + Math.random() * 0.12;
            
            if (waitMinCount == 0) {
                minCanvas.fillRect(RECT, 0x00000000);
                mtrx.identity();
                mtrx.translate( -shimonBMD[minStamp].width * 0.5, -shimonBMD[minStamp].height * 0.5);
                mtrx.scale(scale, scale);
                mtrx.rotate(fpmAngle);
                radius = RADIUS - RADIUS * (minCount / DIV);
                mtrx.translate(Math.cos(minAngle) * radius + 233, Math.sin(minAngle) * radius + 233);
                minCanvas.draw(shimonBMD[minStamp], mtrx, new ColorTransform(1, 1, 1, 1, 0x66, 0xCF, 0x66));
            } else if (waitMinCount > WAIT) {
                for (var i:int = 0; i < 8; i++) {
                    mtrx.identity();
                    mtrx.translate( -shimonBMD[minStamp].width * 0.5, -shimonBMD[minStamp].height * 0.5);
                    mtrx.scale(scale, scale);
                    mtrx.rotate(fpmAngle + Math.random() * 0.1);
                    var radius:Number = RADIUS - RADIUS * (minCount / DIV);
                    
                    if (minCount > DIV) {
                        removeEventListener(Event.ENTER_FRAME, minUpdate);
                    } else {
                        mtrx.translate(Math.cos(minAngle) * radius + 233, Math.sin(minAngle) * radius + 233);
                        minCanvas.draw(shimonBMD[minStamp], mtrx, new ColorTransform(1, 1, 1, (1 - (minCount / DIV)) * 0.11, 0x66, 0xCF, 0x66));
                    }
                    minCount += 1;
                }
            }
            waitMinCount += 1;
        }
        private var hourStamp:int = 0;
        private var hourAngle:Number = 0;
        private var fphAngle:Number = 0;
        private var hourCount:int = 0;
        private var waitHourCount:int = 0;
        private function hourUpdate(e:Event = null):void {
            const RADIUS:Number = 120;
            const DIV:int = 96;
            const WAIT:int = 30;
            var scale:Number = 0.4 + Math.random() * 0.12;
            
            if (waitHourCount == 0) {
                hourCanvas.fillRect(RECT, 0x00000000);
                mtrx.identity();
                mtrx.translate( -shimonBMD[hourStamp].width * 0.5, -shimonBMD[hourStamp].height * 0.5);
                mtrx.scale(scale, scale);
                mtrx.rotate(fphAngle);
                radius = RADIUS - RADIUS * (hourCount / DIV);
                mtrx.translate(Math.cos(hourAngle) * radius + 233, Math.sin(hourAngle) * radius + 233);
                hourCanvas.draw(shimonBMD[hourStamp], mtrx, new ColorTransform(1, 1, 1, 1, 0xC0, 0x00, 0x28));
            } else if (waitHourCount > WAIT) {
                for (var i:int = 0; i < 8; i++) {
                    mtrx.identity();
                    mtrx.translate( -shimonBMD[hourStamp].width * 0.5, -shimonBMD[hourStamp].height * 0.5);
                    mtrx.scale(scale, scale);
                    mtrx.rotate(fphAngle + Math.random() * 0.1);
                    var radius:Number = RADIUS - RADIUS * (hourCount / DIV);
                    
                    if (hourCount > DIV) {
                        removeEventListener(Event.ENTER_FRAME, hourUpdate);
                    } else {
                        mtrx.translate(Math.cos(hourAngle) * radius + 233, Math.sin(hourAngle) * radius + 233);
                        hourCanvas.draw(shimonBMD[hourStamp], mtrx, new ColorTransform(1, 1, 1, (1 - (hourCount / DIV)) * 0.11, 0xC0, 0x00, 0x28));
                    }
                    hourCount += 1;
                }
            }
            waitHourCount += 1;
        }
        private var isMinFirst:Boolean = true;
        private var isHourFirst:Boolean = true;
        private var isBoardFirst:Boolean = true;
        private function update(e:Event = null):void {
            var nowDate:Date = new Date();
            var hour:int = nowDate.getHours();
            var min:int = nowDate.getMinutes();
            var sec:int = nowDate.getSeconds();
            if (expTime != sec) {
                //boardUpdate
                if (sec % 30 == 0 && !isBoardFirst) {
                    isBoardFirst = false;
                    efx.copyPixels(board, RECT, ZERO_POINT, null, null, true);
                    board.fillRect(RECT, 0x00000000);
                    for (var i:int = 0; i < 12; i++) {
                        notch[i] = int(Math.random() * 5);
                        notchAngle[i] = Math.random() * 360;
                        notchCount[i] = 0;
                        notchWaitCount[i] = 0;
                    }
                    count = 0;
                    ptAngle = 0;
                    addEventListener(Event.ENTER_FRAME, boardDesign);
                }
                //minUpdate
                if (sec % 60 == 1 || (isMinFirst && sec < 56)) {
                    isMinFirst = false;
                    minCount = 0;
                    waitMinCount = 0;
                    minStamp = 4;
                    fpmAngle = Math.random() * 360;
                    minAngle = ((min * 6 - 90) * Math.PI / 180);
                    addEventListener(Event.ENTER_FRAME, minUpdate);
                }
                //hourUpdate
                if (sec % 60 == 0 || (isHourFirst && sec < 56)) {
                    isHourFirst = false;
                    hourCount = 0;
                    waitHourCount = 0;
                    hourStamp = 4;
                    fphAngle = Math.random() * 360;
                    hourAngle = ((hour * 30 + 30 * min / 60 - 90) * Math.PI / 180);
                    addEventListener(Event.ENTER_FRAME, hourUpdate);
                }
                
                if (sec == 0) {
                    efx.copyPixels(secCanvas, RECT, ZERO_POINT, null, null, true);
                    secCanvas.fillRect(RECT, 0x00000000);
                }
                //secUpdate
                mtrx.identity();
                var rnd:int = int(Math.random() * 5);
                mtrx.translate( -shimonBMD[rnd].width * 0.5, -shimonBMD[rnd].height * 0.5);
                mtrx.scale(0.5, 0.5);
                mtrx.rotate(Math.random() * 360);
                var radius:Number = 200;
                var angle:Number = ((sec * 6 - 90) * Math.PI / 180);
                mtrx.translate(Math.cos(angle) * radius + 233, Math.sin(angle) * radius + 233);
                secCanvas.draw(shimonBMD[rnd], mtrx, new ColorTransform(1, 1, 1, 1, 0xFF, 0x75, 0x15));
                expTime = sec;
            }
            
            efx.applyFilter(efx, RECT, ZERO_POINT, new BlurFilter(1.2, 1.2));
            efx.colorTransform(RECT, CTF);
        }
        private var shimonData01:Vector.<uint> = Vector.<uint>([
            0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,16777216,33554432,0,0,0,0,0,0,16777216,0,0,33554432,16777216,0,0,0,67108864,218103808,0,134217728,0,67108864,83886080,285212672,150994944,0,134217728,268435456,0,268435456,167772160,0,285212672,100663296,0,33554432,0,0,83886080,0,16777216,0,33554432,0,16777216,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,16777216,0,0,50331648,50331648,0,0,33554432,16777216,16777216,33554432,33554432,16777216,16777216,33554432,100663296,0,0,67108864,0,251658240,0,16777216,67108864,0,335544320,536870912,251658240,117440512,184549376,67108864,16777216,0,201326592,33554432,0,0,218103808,0,469762048,268435456,503316480,50331648,0,0,100663296,0,50331648,67108864,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,50331648,16777216,0,50331648,50331648,0,0,16777216,0,0,16777216,16777216,0,0,16777216,33554432,50331648,0,134217728,150994944,0,318767104,0,134217728,0,536870912,402653184,0,117440512,0,234881024,872415232,939524096,855638016,1728053248,1728053248,2130706432,1560281088,1929379840,1291845632,1023410176,503316480,150994944,0,50331648,0,134217728,0,0,0,67108864,50331648,0,50331648,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,16777216,0,33554432,83886080,33554432,33554432,134217728,33554432,0,0,0,16777216,0,16777216,67108864,0,150994944,33554432,0,33554432,67108864,973078528,167772160,0,16777216,0,33554432,218103808,587202560,805306368,973078528,1828716544,1426063360,385875968,570425344,201326592,167772160,285212672,0,50331648,33554432,83886080,0,134217728,0,0,0,100663296,100663296,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,0,0,83886080,117440512,50331648,134217728,419430400,100663296,50331648,16777216,16777216,33554432,50331648,83886080,150994944,352321536,0,134217728,218103808,83886080,285212672,83886080,0,134217728,201326592,469762048,671088640,1056964608,1224736768,33554432,134217728,16777216,0,0,0,83886080,301989888,167772160,184549376,1056964608,855638016,603979776,939524096,503316480,1442840576,1342177280,637534208,184549376,117440512,0,16777216,100663296,83886080,50331648,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,33554432,0,0,50331648,67108864,0,50331648,335544320,100663296,33554432,0,16777216,16777216,33554432,100663296,150994944,0,0,754974720,956301312,352321536,0,100663296,889192448,1644167168,1577058304,335544320,201326592,50331648,134217728,33554432,754974720,570425344,1543503872,1308622848,1543503872,2130706432,2130706432,2080374784,2063597568,1962934272,1140850688,335544320,0,83886080,973078528,1610612736,1174405120,788529152,654311424,301989888,100663296,0,0,134217728,167772160,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,50331648,83886080,33554432,0,0,0,0,50331648,33554432,0,0,0,16777216,16777216,50331648,100663296,67108864,234881024,352321536,0,0,67108864,452984832,335544320,100663296,234881024,0,0,150994944,570425344,1023410176,1811939328,1979711488,838860800,1258291200,1358954496,1375731712,67108864,0,218103808,50331648,218103808,0,0,0,0,0,100663296,0,50331648,33554432,100663296,67108864,0,16777216,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,100663296,83886080,0,50331648,117440512,33554432,0,16777216,0,0,33554432,50331648,50331648,67108864,100663296,318767104,167772160,100663296,50331648,0,536870912,134217728,201326592,603979776,889192448,1056964608,671088640,1207959552,889192448,1375731712,855638016,184549376,100663296,285212672,0,33554432,16777216,234881024,452984832,318767104,385875968,436207616,452984832,1207959552,1325400064,1795162112,1711276032,1040187392,637534208,50331648,0,33554432,134217728,167772160,0,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,50331648,100663296,83886080,134217728,33554432,0,83886080,0,83886080,50331648,67108864,134217728,33554432,117440512,0,67108864,352321536,184549376,100663296,855638016,771751936,520093696,184549376,1358954496,973078528,1409286144,1090519040,352321536,0,117440512,100663296,83886080,738197504,1728053248,989855744,1073741824,855638016,1476395008,1291845632,1711276032,1526726656,671088640,369098752,385875968,838860800,234881024,855638016,570425344,1644167168,603979776,1426063360,855638016,855638016,1543503872,570425344,0,83886080,0,150994944,134217728,0,0,67108864,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,83886080,150994944,150994944,0,0,83886080,16777216,16777216,0,0,0,134217728,184549376,33554432,16777216,301989888,301989888,218103808,335544320,0,117440512,234881024,234881024,83886080,50331648,0,385875968,822083584,536870912,1509949440,1476395008,2030043136,1526726656,1795162112,1744830464,1526726656,1929379840,1342177280,268435456,167772160,33554432,67108864,100663296,0,150994944,50331648,117440512,33554432,67108864,134217728,251658240,1811939328,2046820352,838860800,167772160,16777216,0,16777216,0,0,0,33554432,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,50331648,33554432,100663296,33554432,16777216,83886080,0,83886080,0,134217728,117440512,0,352321536,436207616,117440512,301989888,167772160,0,184549376,67108864,0,520093696,704643072,503316480,1543503872,889192448,1006632960,1728053248,1291845632,1694498816,1694498816,1040187392,1392508928,1107296256,117440512,268435456,16777216,67108864,83886080,822083584,973078528,369098752,1207959552,1560281088,1728053248,1778384896,1996488704,1207959552,134217728,134217728,0,0,33554432,83886080,0,0,83886080,134217728,50331648,83886080,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,33554432,0,0,117440512,117440512,50331648,100663296,0,0,218103808,486539264,402653184,452984832,150994944,0,251658240,0,0,150994944,352321536,855638016,1207959552,1593835520,1325400064,1342177280,1040187392,788529152,587202560,570425344,1107296256,100663296,0,0,469762048,100663296,268435456,1073741824,922746880,1157627904,1509949440,1224736768,385875968,385875968,553648128,939524096,1560281088,1459617792,654311424,33554432,33554432,1358954496,1996488704,989855744,268435456,268435456,419430400,100663296,16777216,0,50331648,0,0,16777216,83886080,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,0,67108864,234881024,100663296,0,150994944,251658240,234881024,738197504,1275068416,285212672,234881024,0,201326592,0,100663296,520093696,1694498816,1677721600,1124073472,973078528,889192448,167772160,637534208,0,67108864,251658240,16777216,218103808,855638016,1912602624,1795162112,1660944384,1912602624,1912602624,1711276032,1258291200,436207616,754974720,268435456,67108864,738197504,117440512,100663296,150994944,553648128,503316480,1442840576,1526726656,1258291200,2097152000,1962934272,1895825408,2130706432,1929379840,1778384896,1023410176,100663296,268435456,0,83886080,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,16777216,50331648,167772160,134217728,117440512,318767104,318767104,167772160,369098752,234881024,150994944,301989888,134217728,134217728,1006632960,1090519040,620756992,738197504,654311424,301989888,184549376,117440512,251658240,335544320,234881024,1124073472,1157627904,1577058304,1040187392,1895825408,1107296256,704643072,805306368,67108864,0,0,301989888,939524096,1409286144,1107296256,1006632960,1392508928,1493172224,1761607680,1526726656,1778384896,1795162112,1946157056,1073741824,117440512,385875968,150994944,335544320,268435456,0,352321536,687865856,671088640,1090519040,184549376,16777216,0,134217728,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,117440512,167772160,33554432,16777216,117440512,335544320,452984832,167772160,50331648,50331648,50331648,452984832,0,268435456,117440512,385875968,0,100663296,0,201326592,402653184,671088640,687865856,1325400064,1845493760,1996488704,1946157056,285212672,1744830464,1845493760,1392508928,872415232,251658240,587202560,1358954496,1308622848,939524096,1056964608,704643072,905969664,905969664,318767104,1325400064,1241513984,922746880,1409286144,973078528,520093696,0,0,268435456,385875968,201326592,134217728,0,721420288,0,301989888,0,100663296,0,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,117440512,335544320,218103808,0,0,335544320,486539264,100663296,83886080,117440512,570425344,385875968,268435456,369098752,469762048,134217728,218103808,738197504,1023410176,2046820352,1862270976,1509949440,838860800,704643072,134217728,520093696,0,16777216,1426063360,1375731712,1493172224,1610612736,1694498816,2046820352,922746880,1778384896,1124073472,67108864,503316480,989855744,469762048,419430400,369098752,285212672,671088640,754974720,469762048,1157627904,1409286144,1375731712,1879048192,1895825408,1577058304,1258291200,1308622848,1275068416,1056964608,1442840576,671088640,100663296,218103808,83886080,67108864,67108864,0,16777216,16777216,16777216,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,16777216,0,0,0,67108864,67108864,16777216,0,50331648,117440512,0,83886080,150994944,67108864,184549376,134217728,536870912,637534208,385875968,637534208,0,352321536,838860800,1761607680,754974720,939524096,1241513984,402653184,33554432,0,50331648,738197504,721420288,385875968,1375731712,1845493760,1778384896,1543503872,1577058304,369098752,67108864,0,0,0,67108864,956301312,1560281088,1358954496,1442840576,2097152000,1862270976,1845493760,1845493760,1476395008,1811939328,1744830464,1258291200,1409286144,838860800,805306368,1845493760,1610612736,1577058304,1593835520,1124073472,1291845632,1795162112,838860800,218103808,33554432,0,33554432,16777216,16777216,0,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,16777216,0,0,0,50331648,50331648,0,0,33554432,83886080,33554432,117440512,184549376,268435456,469762048,520093696,452984832,620756992,503316480,285212672,100663296,50331648,671088640,570425344,285212672,0,369098752,318767104,335544320,1207959552,1006632960,1308622848,1207959552,1442840576,1778384896,1660944384,1627389952,1358954496,1090519040,771751936,989855744,1728053248,1845493760,1828716544,855638016,352321536,0,0,100663296,0,385875968,0,1090519040,1543503872,1006632960,150994944,0,218103808,0,33554432,486539264,67108864,738197504,1459617792,1593835520,1375731712,1644167168,1375731712,83886080,0,100663296,33554432,16777216,16777216,0,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,33554432,33554432,0,83886080,134217728,50331648,0,0,352321536,620756992,486539264,855638016,0,419430400,16777216,318767104,0,754974720,201326592,234881024,603979776,1224736768,1526726656,973078528,1040187392,1442840576,2097152000,1610612736,973078528,754974720,1056964608,1291845632,1375731712,1627389952,1593835520,1358954496,1526726656,1862270976,1744830464,754974720,771751936,1140850688,1409286144,1509949440,1509949440,1241513984,1711276032,2080374784,1728053248,1744830464,2063597568,1728053248,1577058304,1342177280,1191182336,1644167168,704643072,0,0,83886080,0,218103808,1459617792,486539264,33554432,134217728,33554432,33554432,33554432,16777216,0,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,16777216,33554432,16777216,16777216,0,234881024,0,83886080,872415232,855638016,251658240,167772160,67108864,201326592,754974720,369098752,738197504,939524096,855638016,838860800,469762048,1291845632,1207959552,922746880,1224736768,771751936,285212672,1006632960,570425344,671088640,234881024,872415232,1207959552,838860800,1157627904,1275068416,721420288,1543503872,1409286144,234881024,83886080,16777216,620756992,704643072,385875968,486539264,1056964608,1275068416,687865856,822083584,939524096,318767104,402653184,855638016,939524096,1157627904,1140850688,2097152000,1241513984,1090519040,1459617792,268435456,134217728,603979776,1073741824,301989888,0,100663296,33554432,33554432,16777216,0,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,16777216,16777216,16777216,33554432,50331648,16777216,0,117440512,687865856,469762048,285212672,117440512,50331648,117440512,838860800,452984832,805306368,771751936,989855744,1258291200,939524096,570425344,117440512,201326592,50331648,503316480,301989888,738197504,1509949440,1040187392,1979711488,1811939328,1996488704,1761607680,1644167168,1761607680,1644167168,1526726656,1660944384,1493172224,1811939328,2063597568,1426063360,1291845632,855638016,721420288,620756992,318767104,671088640,486539264,67108864,134217728,67108864,0,16777216,352321536,721420288,520093696,788529152,1275068416,436207616,2030043136,973078528,83886080,452984832,2113929216,1426063360,117440512,50331648,33554432,33554432,16777216,16777216,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,16777216,16777216,16777216,50331648,100663296,469762048,419430400,536870912,520093696,117440512,570425344,754974720,822083584,385875968,922746880,805306368,637534208,1543503872,838860800,234881024,0,50331648,922746880,469762048,1795162112,1560281088,788529152,1610612736,1426063360,1778384896,1392508928,671088640,150994944,0,1006632960,1191182336,1006632960,1761607680,1392508928,0,738197504,872415232,536870912,637534208,1929379840,2097152000,1879048192,1761607680,1862270976,2063597568,2113929216,1946157056,1962934272,1476395008,1325400064,687865856,150994944,184549376,16777216,0,704643072,184549376,771751936,738197504,150994944,503316480,0,100663296,0,33554432,33554432,16777216,16777216,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,16777216,0,0,16777216,33554432,33554432,83886080,167772160,251658240,33554432,301989888,385875968,402653184,1560281088,1275068416,469762048,754974720,704643072,0,0,0,33554432,503316480,419430400,1224736768,1677721600,1392508928,1996488704,1275068416,2080374784,1962934272,1056964608,486539264,570425344,1023410176,922746880,603979776,1124073472,1291845632,1627389952,1627389952,1509949440,1375731712,905969664,754974720,335544320,637534208,838860800,16777216,0,201326592,704643072,654311424,1476395008,989855744,1308622848,1140850688,939524096,1191182336,1258291200,2080374784,1929379840,1694498816,419430400,234881024,1191182336,989855744,872415232,922746880,754974720,234881024,117440512,50331648,33554432,33554432,16777216,16777216,0,0,16777216,16777216,16777216,16777216,0,0,0,0,0,16777216,0,0,16777216,33554432,33554432,100663296,201326592,0,385875968,754974720,872415232,1224736768,1711276032,654311424,452984832,0,50331648,16777216,738197504,654311424,1426063360,1258291200,973078528,1728053248,1375731712,1493172224,536870912,50331648,520093696,150994944,889192448,1308622848,1325400064,1291845632,1442840576,1795162112,1711276032,1358954496,1291845632,1526726656,1275068416,1744830464,1409286144,1929379840,1845493760,1644167168,1224736768,788529152,822083584,419430400,218103808,352321536,0,0,0,83886080,553648128,1090519040,1275068416,1711276032,1795162112,1778384896,2030043136,1979711488,721420288,805306368,872415232,2130706432,1124073472,369098752,117440512,50331648,33554432,33554432,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,50331648,67108864,16777216,0,150994944,16777216,721420288,989855744,1023410176,1409286144,167772160,0,167772160,570425344,754974720,805306368,1174405120,738197504,1358954496,1040187392,1560281088,872415232,0,134217728,0,251658240,1191182336,1694498816,1459617792,1560281088,1711276032,1610612736,1644167168,1744830464,1476395008,1728053248,1459617792,1694498816,1660944384,1828716544,1308622848,452984832,1593835520,1828716544,1946157056,2080374784,771751936,1694498816,2097152000,2046820352,2030043136,1275068416,771751936,587202560,268435456,0,83886080,33554432,0,218103808,301989888,754974720,67108864,0,1174405120,1258291200,83886080,0,33554432,184549376,0,0,50331648,0,16777216,50331648,0,0,0,0,0,0,0,0,0,16777216,16777216,67108864,0,16777216,0,738197504,318767104,738197504,1107296256,570425344,134217728,0,33554432,1040187392,922746880,1476395008,520093696,1124073472,1409286144,587202560,218103808,402653184,0,452984832,889192448,1006632960,1375731712,1526726656,1761607680,1627389952,1526726656,1677721600,1358954496,1493172224,1677721600,1610612736,1577058304,1375731712,1509949440,1107296256,587202560,134217728,16777216,536870912,1459617792,0,0,0,50331648,134217728,83886080,1358954496,1946157056,2013265920,2030043136,1593835520,905969664,1778384896,1610612736,1526726656,805306368,939524096,754974720,16777216,285212672,1795162112,1795162112,1593835520,637534208,268435456,33554432,67108864,16777216,33554432,33554432,0,0,33554432,50331648,0,0,0,0,0,0,0,0,0,0,33554432,0,0,0,637534208,251658240,301989888,150994944,570425344,1006632960,301989888,922746880,520093696,1157627904,1191182336,704643072,889192448,503316480,0,0,822083584,1191182336,905969664,788529152,822083584,1879048192,1728053248,1560281088,1207959552,1694498816,1493172224,1224736768,1509949440,1442840576,1392508928,1644167168,1325400064,1426063360,1476395008,1442840576,1962934272,1979711488,1895825408,1879048192,1660944384,1207959552,1325400064,536870912,436207616,352321536,0,134217728,100663296,234881024,553648128,570425344,822083584,1728053248,1593835520,1241513984,1811939328,1895825408,1795162112,1409286144,1191182336,1644167168,2130706432,1677721600,1157627904,150994944,0,50331648,50331648,16777216,16777216,0,0,16777216,0,0,0,0,0,0,16777216,16777216,0,0,0,16777216,50331648,100663296,0,251658240,0,570425344,1224736768,1526726656,587202560,738197504,1593835520,603979776,0,0,100663296,234881024,503316480,1476395008,1358954496,922746880,1040187392,1325400064,184549376,201326592,0,452984832,1677721600,1476395008,1442840576,1795162112,1493172224,1493172224,1644167168,1459617792,1728053248,1442840576,1358954496,2013265920,1509949440,1526726656,1660944384,1627389952,1694498816,2080374784,1241513984,704643072,1124073472,1342177280,2063597568,1694498816,570425344,335544320,83886080,67108864,0,33554432,0,0,16777216,0,520093696,1325400064,721420288,0,0,2130706432,603979776,1056964608,134217728,201326592,67108864,0,50331648,50331648,0,0,0,0,0,0,0,16777216,16777216,16777216,67108864,0,0,50331648,33554432,150994944,67108864,822083584,1006632960,1090519040,1543503872,1140850688,117440512,134217728,0,469762048,738197504,687865856,1040187392,822083584,1124073472,1090519040,754974720,1023410176,738197504,436207616,301989888,838860800,1023410176,738197504,1258291200,1509949440,1744830464,1577058304,1610612736,1459617792,1627389952,1744830464,1224736768,1694498816,973078528,385875968,570425344,0,33554432,0,150994944,0,251658240,218103808,0,1107296256,1207959552,1644167168,2097152000,2080374784,1845493760,1593835520,1308622848,1140850688,872415232,1174405120,1509949440,1224736768,1610612736,1207959552,1442840576,1006632960,117440512,0,100663296,251658240,251658240,268435456,100663296,0,0,0,0,67108864,0,0,0,0,16777216,16777216,16777216,16777216,67108864,16777216,16777216,33554432,0,184549376,939524096,1342177280,1459617792,469762048,1124073472,50331648,50331648,553648128,922746880,1275068416,1107296256,1073741824,419430400,620756992,989855744,1761607680,922746880,1241513984,1593835520,1610612736,1358954496,1392508928,1140850688,989855744,2046820352,1426063360,1409286144,1560281088,905969664,1526726656,1493172224,1426063360,1392508928,1493172224,1627389952,1476395008,1560281088,1694498816,1677721600,1946157056,1627389952,402653184,452984832,520093696,234881024,83886080,0,0,0,369098752,335544320,1761607680,1308622848,1006632960,1157627904,1140850688,1476395008,1325400064,872415232,1308622848,1275068416,1610612736,1744830464,587202560,218103808,0,0,33554432,50331648,67108864,50331648,0,0,67108864,0,0,0,16777216,16777216,16777216,16777216,16777216,0,16777216,50331648,100663296,201326592,452984832,872415232,989855744,637534208,335544320,285212672,16777216,452984832,1224736768,1073741824,1191182336,1694498816,939524096,989855744,1056964608,855638016,0,452984832,1090519040,1811939328,1073741824,1392508928,1711276032,603979776,134217728,671088640,889192448,1342177280,1073741824,1073741824,1644167168,1375731712,1191182336,1442840576,1543503872,1593835520,1761607680,1677721600,1442840576,1728053248,1660944384,1929379840,822083584,1258291200,2063597568,905969664,1543503872,1711276032,1795162112,1325400064,402653184,83886080,0,939524096,1459617792,1526726656,905969664,1711276032,1644167168,0,486539264,1426063360,1493172224,1207959552,1207959552,1694498816,100663296,167772160,16777216,16777216,100663296,83886080,16777216,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,0,67108864,83886080,301989888,570425344,855638016,0,218103808,520093696,553648128,469762048,570425344,587202560,889192448,939524096,654311424,301989888,1073741824,436207616,738197504,452984832,318767104,536870912,1275068416,922746880,620756992,352321536,1006632960,838860800,1358954496,1476395008,1610612736,1560281088,452984832,1442840576,1778384896,1392508928,620756992,1124073472,1593835520,889192448,100663296,0,0,33554432,402653184,754974720,805306368,402653184,0,570425344,1107296256,922746880,1660944384,1426063360,1811939328,1560281088,1023410176,117440512,134217728,285212672,939524096,2097152000,1862270976,1476395008,1140850688,67108864,251658240,1392508928,1946157056,1778384896,1610612736,989855744,402653184,16777216,0,0,0,33554432,0,33554432,0,0,50331648,33554432,0,0,50331648,0,83886080,134217728,402653184,184549376,83886080,33554432,1258291200,738197504,939524096,922746880,1543503872,1442840576,285212672,50331648,184549376,654311424,956301312,536870912,889192448,939524096,788529152,855638016,889192448,1023410176,1660944384,1728053248,1073741824,1426063360,1107296256,1291845632,1728053248,1593835520,1191182336,1040187392,1593835520,1325400064,1795162112,1610612736,1610612736,1291845632,1895825408,1644167168,1375731712,1577058304,1795162112,1744830464,1207959552,687865856,822083584,620756992,0,83886080,771751936,1644167168,1275068416,2113929216,989855744,1275068416,1342177280,402653184,0,0,805306368,1879048192,1358954496,1543503872,385875968,285212672,0,2030043136,1174405120,1526726656,1879048192,285212672,83886080,0,83886080,0,0,33554432,16777216,0,33554432,33554432,0,0,33554432,33554432,0,67108864,16777216,0,285212672,1107296256,654311424,838860800,587202560,1191182336,318767104,117440512,50331648,1241513984,1728053248,1358954496,1124073472,520093696,1325400064,939524096,939524096,1845493760,738197504,1090519040,771751936,0,654311424,251658240,251658240,989855744,167772160,654311424,922746880,1258291200,1426063360,1476395008,1392508928,1107296256,1644167168,1476395008,1677721600,1862270976,1694498816,1946157056,1879048192,1828716544,1627389952,754974720,1879048192,1426063360,1426063360,1291845632,1744830464,1811939328,922746880,67108864,1006632960,1375731712,1912602624,1694498816,1728053248,704643072,0,16777216,989855744,1929379840,1828716544,1761607680,251658240,0,50331648,603979776,0,520093696,301989888,0,0,134217728,50331648,16777216,16777216,0,16777216,16777216,0,0,16777216,83886080,0,0,83886080,654311424,1275068416,2013265920,553648128,100663296,0,352321536,50331648,721420288,1258291200,1493172224,1426063360,1258291200,1073741824,1509949440,788529152,1073741824,1107296256,134217728,33554432,436207616,436207616,603979776,452984832,486539264,989855744,1191182336,469762048,1140850688,687865856,1493172224,1325400064,1593835520,1073741824,1258291200,1241513984,704643072,83886080,0,0,100663296,1224736768,1996488704,771751936,50331648,83886080,352321536,1056964608,1325400064,754974720,1962934272,1627389952,654311424,150994944,0,956301312,1795162112,1795162112,1828716544,2013265920,285212672,285212672,1862270976,1241513984,1744830464,1728053248,1509949440,738197504,67108864,16777216,218103808,117440512,0,0,0,33554432,33554432,16777216,0,16777216,16777216,33554432,16777216,16777216,0,150994944,285212672,822083584,1006632960,1073741824,838860800,0,419430400,822083584,822083584,738197504,1761607680,1207959552,1392508928,1375731712,838860800,771751936,0,738197504,1073741824,637534208,1325400064,1577058304,1744830464,1627389952,1509949440,1543503872,838860800,1979711488,1577058304,872415232,1509949440,1023410176,1493172224,1811939328,1677721600,1224736768,1862270976,1275068416,2080374784,2046820352,1879048192,1660944384,738197504,436207616,1107296256,1577058304,989855744,1426063360,1124073472,150994944,16777216,218103808,385875968,1962934272,1946157056,1694498816,419430400,0,385875968,1442840576,1962934272,1778384896,1845493760,1711276032,1459617792,1744830464,117440512,1275068416,1879048192,1828716544,2046820352,184549376,0,33554432,0,33554432,150994944,0,33554432,33554432,0,16777216,33554432,67108864,50331648,16777216,33554432,0,486539264,939524096,469762048,301989888,150994944,922746880,1409286144,1174405120,419430400,922746880,1308622848,1090519040,788529152,33554432,100663296,687865856,1241513984,1526726656,671088640,1191182336,1056964608,1543503872,1644167168,1140850688,1610612736,989855744,637534208,0,402653184,1476395008,788529152,83886080,402653184,486539264,788529152,1761607680,251658240,218103808,620756992,385875968,587202560,822083584,1711276032,1728053248,486539264,167772160,117440512,150994944,637534208,1912602624,1493172224,889192448,0,16777216,805306368,2046820352,1526726656,1728053248,369098752,0,150994944,637534208,1442840576,1543503872,1660944384,1241513984,0,117440512,184549376,1962934272,1811939328,1560281088,16777216,117440512,0,50331648,67108864,100663296,33554432,33554432,16777216,0,50331648,83886080,67108864,16777216,0,419430400,553648128,0,100663296,805306368,738197504,1493172224,520093696,989855744,1107296256,33554432,251658240,0,100663296,419430400,1660944384,1828716544,1660944384,1610612736,1275068416,1291845632,1577058304,1140850688,587202560,301989888,150994944,1291845632,1308622848,570425344,805306368,1224736768,905969664,1426063360,1627389952,1291845632,1191182336,1442840576,1090519040,1509949440,973078528,822083584,0,0,1308622848,1627389952,1744830464,956301312,402653184,553648128,150994944,33554432,1476395008,1929379840,2113929216,838860800,0,0,872415232,1610612736,1090519040,1577058304,536870912,0,553648128,1140850688,1224736768,1493172224,1929379840,1258291200,0,872415232,721420288,1560281088,2013265920,452984832,16777216,16777216,0,0,33554432,33554432,0,0,33554432,83886080,67108864,16777216,100663296,16777216,201326592,754974720,1694498816,1258291200,754974720,1577058304,872415232,0,83886080,0,251658240,1493172224,1962934272,1677721600,1509949440,1828716544,1358954496,0,889192448,1040187392,1191182336,1392508928,1409286144,1493172224,956301312,1275068416,889192448,1124073472,385875968,1174405120,1828716544,1275068416,1358954496,1426063360,1728053248,1459617792,1476395008,1258291200,1409286144,1677721600,2113929216,1912602624,1660944384,721420288,0,1543503872,1493172224,1526726656,1728053248,251658240,167772160,0,486539264,1979711488,1996488704,889192448,0,822083584,1375731712,1493172224,2113929216,1593835520,1543503872,67108864,1006632960,1895825408,1627389952,1744830464,1442840576,822083584,117440512,134217728,805306368,603979776,117440512,50331648,117440512,100663296,16777216,33554432,0,0,33554432,83886080,67108864,0,234881024,50331648,603979776,1879048192,1778384896,486539264,0,16777216,0,486539264,1157627904,1509949440,1677721600,1694498816,1174405120,1660944384,771751936,553648128,1308622848,1342177280,1409286144,1442840576,1090519040,973078528,1392508928,805306368,889192448,1509949440,1291845632,1191182336,1090519040,385875968,1258291200,452984832,587202560,1543503872,1090519040,285212672,0,0,1291845632,1543503872,1258291200,1728053248,1442840576,1912602624,1442840576,1342177280,33554432,268435456,1426063360,1879048192,1677721600,687865856,134217728,0,822083584,2113929216,1593835520,436207616,50331648,16777216,335544320,1342177280,1627389952,1593835520,1358954496,1560281088,1694498816,1308622848,1577058304,1476395008,1577058304,134217728,150994944,167772160,0,0,50331648,0,83886080,16777216,33554432,33554432,0,167772160,33554432,33554432,0,771751936,1090519040,1224736768,369098752,100663296,134217728,1325400064,1694498816,1660944384,469762048,1207959552,1610612736,1090519040,150994944,754974720,33554432,872415232,1509949440,1509949440,738197504,738197504,50331648,721420288,167772160,738197504,1258291200,503316480,738197504,1275068416,1358954496,1056964608,1342177280,1627389952,1627389952,1560281088,1476395008,1610612736,1610612736,1375731712,1493172224,1627389952,150994944,721420288,654311424,1191182336,1644167168,2097152000,1174405120,134217728,33554432,0,889192448,1526726656,1879048192,905969664,83886080,402653184,0,1744830464,1711276032,1375731712,1375731712,33554432,620756992,1879048192,1744830464,1325400064,1610612736,16777216,419430400,1593835520,1929379840,1845493760,1694498816,0,167772160,16777216,50331648,0,83886080,16777216,0,67108864,83886080,50331648,0,83886080,1023410176,1308622848,201326592,0,1358954496,1224736768,1526726656,1711276032,1040187392,1526726656,1291845632,184549376,83886080,855638016,738197504,956301312,1174405120,1291845632,1308622848,1157627904,520093696,0,1090519040,1392508928,1845493760,1040187392,1828716544,1224736768,1073741824,1392508928,1241513984,1090519040,1006632960,1124073472,1224736768,905969664,1476395008,1409286144,1392508928,1761607680,1593835520,1660944384,1845493760,1845493760,402653184,1560281088,1342177280,855638016,1728053248,1627389952,1476395008,637534208,67108864,201326592,1711276032,1358954496,1828716544,1644167168,536870912,83886080,402653184,1711276032,1711276032,1325400064,218103808,0,1073741824,1577058304,1308622848,989855744,285212672,100663296,520093696,1593835520,1811939328,536870912,0,33554432,0,134217728,16777216,33554432,0,16777216,50331648,50331648,100663296,50331648,1258291200,0,117440512,1795162112,1442840576,721420288,1593835520,1543503872,1526726656,872415232,117440512,905969664,486539264,1476395008,1241513984,1040187392,1459617792,385875968,251658240,637534208,637534208,939524096,1845493760,1073741824,385875968,33554432,1509949440,1073741824,838860800,754974720,805306368,1627389952,1879048192,1744830464,268435456,0,838860800,637534208,1174405120,369098752,301989888,1241513984,1728053248,1627389952,1593835520,939524096,1442840576,587202560,1409286144,1191182336,1224736768,1275068416,1040187392,570425344,0,268435456,1275068416,1409286144,1996488704,1711276032,218103808,0,939524096,2113929216,1677721600,1409286144,83886080,1275068416,1711276032,1711276032,1593835520,1090519040,419430400,687865856,2097152000,1677721600,83886080,0,134217728,0,16777216,167772160,0,0,100663296,0,50331648,1023410176,0,620756992,1610612736,1895825408,1459617792,1677721600,100663296,167772160,872415232,1224736768,1207959552,1476395008,1962934272,1677721600,939524096,1207959552,0,805306368,1577058304,1342177280,1241513984,1191182336,872415232,452984832,956301312,1023410176,1140850688,385875968,369098752,167772160,956301312,1493172224,1325400064,1342177280,1560281088,1258291200,1660944384,1560281088,771751936,1174405120,469762048,436207616,33554432,553648128,1711276032,1140850688,1409286144,1275068416,1426063360,301989888,0,872415232,1241513984,1761607680,1677721600,469762048,134217728,738197504,1879048192,1593835520,1862270976,1090519040,0,0,1811939328,1375731712,1342177280,1476395008,1325400064,1140850688,1660944384,1526726656,1593835520,33554432,16777216,805306368,1426063360,620756992,0,33554432,83886080,16777216,83886080,67108864,0,318767104,33554432,0,788529152,1744830464,1577058304,1426063360,352321536,0,402653184,905969664,1107296256,1895825408,2063597568,1946157056,1593835520,16777216,452984832,1174405120,1577058304,1711276032,1912602624,989855744,620756992,402653184,1157627904,1526726656,587202560,285212672,1174405120,654311424,1375731712,2080374784,1761607680,1493172224,1157627904,1275068416,1509949440,1526726656,1090519040,1694498816,1895825408,1191182336,973078528,1744830464,1426063360,536870912,1140850688,1023410176,1493172224,1509949440,889192448,1325400064,872415232,184549376,167772160,100663296,838860800,1426063360,1459617792,402653184,201326592,0,1258291200,1644167168,1526726656,654311424,0,1174405120,1442840576,1409286144,1476395008,1241513984,1543503872,1660944384,1577058304,1879048192,167772160,234881024,369098752,134217728,0,50331648,16777216,117440512,0,67108864,218103808,0,67108864,1929379840,1006632960,1627389952,620756992,167772160,754974720,1358954496,1627389952,1996488704,1996488704,603979776,1107296256,0,301989888,704643072,1912602624,1761607680,1224736768,587202560,33554432,0,1056964608,1258291200,469762048,167772160,721420288,1392508928,1778384896,1375731712,1258291200,989855744,1006632960,738197504,1073741824,1392508928,1258291200,0,1610612736,67108864,520093696,452984832,469762048,1258291200,1879048192,1291845632,1358954496,1694498816,436207616,33554432,1073741824,973078528,788529152,1157627904,1174405120,1040187392,184549376,419430400,822083584,1929379840,1426063360,268435456,251658240,0,1174405120,1476395008,1241513984,134217728,1493172224,1560281088,1241513984,1627389952,536870912,687865856,1459617792,1426063360,1577058304,671088640,33554432,117440512,150994944,0,16777216,100663296,0,0,184549376,0,637534208,1560281088,0,0,0,1409286144,2097152000,1879048192,1526726656,1040187392,50331648,0,369098752,989855744,1426063360,1459617792,805306368,50331648,117440512,0,352321536,1375731712,1577058304,922746880,754974720,1778384896,1610612736,1375731712,1140850688,939524096,1090519040,1090519040,922746880,905969664,1442840576,1258291200,1644167168,1308622848,1409286144,1090519040,1459617792,654311424,352321536,50331648,218103808,671088640,1493172224,1224736768,1644167168,1275068416,973078528,1207959552,654311424,1543503872,1392508928,1711276032,1291845632,654311424,0,1258291200,1761607680,1342177280,922746880,184549376,0,671088640,738197504,1073741824,1023410176,50331648,1040187392,1593835520,1577058304,1291845632,117440512,1409286144,1761607680,2130706432,67108864,0,117440512,50331648,83886080,0,33554432,0,67108864,201326592,1191182336,50331648,0,939524096,1660944384,2113929216,1409286144,0,150994944,385875968,671088640,1325400064,1862270976,1862270976,1509949440,301989888,150994944,469762048,838860800,2063597568,1207959552,788529152,1375731712,469762048,1023410176,838860800,1325400064,352321536,905969664,1056964608,771751936,1224736768,1191182336,1308622848,1056964608,939524096,1392508928,1207959552,1275068416,889192448,1191182336,1241513984,889192448,2046820352,905969664,16777216,553648128,939524096,838860800,1409286144,1694498816,1543503872,536870912,0,771751936,1375731712,1342177280,1342177280,654311424,16777216,536870912,2113929216,1660944384,1342177280,620756992,0,1124073472,1358954496,1224736768,587202560,33554432,1644167168,1224736768,1476395008,771751936,33554432,1426063360,1946157056,1124073472,234881024,0,33554432,0,0,0,0,0,805306368,150994944,150994944,1207959552,1996488704,1610612736,1459617792,0,738197504,1409286144,1023410176,1644167168,1627389952,788529152,100663296,234881024,0,1610612736,2046820352,1275068416,385875968,0,50331648,1358954496,1761607680,805306368,671088640,1409286144,1124073472,805306368,1107296256,1056964608,1308622848,687865856,738197504,1207959552,1627389952,1342177280,754974720,1694498816,1107296256,587202560,754974720,855638016,1056964608,1711276032,1644167168,1224736768,671088640,251658240,83886080,620756992,1761607680,1325400064,1375731712,855638016,0,855638016,1342177280,1174405120,1610612736,318767104,0,0,1090519040,1560281088,704643072,268435456,1442840576,771751936,939524096,318767104,469762048,872415232,1426063360,1275068416,1140850688,33554432,16777216,134217728,0,33554432,201326592,0,234881024,0,50331648,100663296,0,318767104,805306368,1157627904,117440512,117440512,100663296,922746880,1375731712,1258291200,1191182336,150994944,0,620756992,486539264,939524096,553648128,838860800,33554432,0,469762048,1392508928,1694498816,1694498816,1191182336,2046820352,1694498816,436207616,687865856,1543503872,889192448,738197504,889192448,419430400,704643072,1795162112,1157627904,1325400064,1426063360,1040187392,1275068416,989855744,855638016,117440512,251658240,0,536870912,1023410176,838860800,956301312,1342177280,184549376,134217728,335544320,1493172224,1577058304,989855744,771751936,100663296,469762048,1476395008,1426063360,1493172224,436207616,0,419430400,1191182336,1174405120,1694498816,1023410176,1291845632,1291845632,922746880,738197504,1493172224,1224736768,1577058304,1526726656,0,0,167772160,33554432,0,0,0,100663296,0,134217728,553648128,1308622848,973078528,0,33554432,989855744,1577058304,1191182336,721420288,889192448,50331648,50331648,335544320,1392508928,2063597568,553648128,0,0,1224736768,1862270976,1962934272,1342177280,1107296256,1677721600,1124073472,1442840576,0,83886080,1157627904,1493172224,1577058304,1308622848,1509949440,1543503872,1560281088,1107296256,1342177280,1392508928,989855744,1140850688,1560281088,1560281088,1711276032,1107296256,1677721600,1711276032,503316480,603979776,1291845632,721420288,620756992,1694498816,1459617792,721420288,671088640,855638016,1560281088,1358954496,1174405120,922746880,0,872415232,1660944384,2113929216,1543503872,0,671088640,1509949440,1157627904,1627389952,771751936,1275068416,1056964608,889192448,1627389952,1711276032,1023410176,1577058304,1660944384,201326592,16777216,0,184549376,100663296,0,0,167772160,0,687865856,50331648,0,973078528,1895825408,1442840576,989855744,486539264,83886080,0,486539264,1073741824,1509949440,637534208,402653184,0,805306368,1845493760,1828716544,1442840576,0,503316480,385875968,1224736768,1577058304,486539264,872415232,1728053248,1711276032,1073741824,1392508928,1426063360,1308622848,922746880,721420288,754974720,1493172224,1191182336,285212672,754974720,285212672,268435456,1577058304,855638016,1895825408,1140850688,1996488704,1157627904,1073741824,570425344,0,402653184,855638016,1375731712,1275068416,150994944,402653184,637534208,1207959552,1157627904,1140850688,184549376,603979776,956301312,1845493760,1979711488,822083584,0,1157627904,1677721600,687865856,1610612736,939524096,436207616,855638016,1325400064,134217728,922746880,2097152000,1526726656,50331648,0,33554432,0,0,100663296,0,134217728,0,33554432,1828716544,1862270976,1090519040,184549376,67108864,50331648,67108864,822083584,1560281088,939524096,117440512,100663296,1258291200,1644167168,1778384896,872415232,0,0,503316480,1560281088,1660944384,419430400,117440512,1660944384,1593835520,1493172224,1056964608,1660944384,218103808,1241513984,1291845632,1442840576,1476395008,1962934272,1342177280,1660944384,1392508928,1409286144,1627389952,1073741824,1358954496,0,16777216,50331648,402653184,721420288,1476395008,1677721600,1862270976,1191182336,0,335544320,1308622848,1828716544,620756992,83886080,268435456,872415232,1392508928,1493172224,771751936,318767104,335544320,1711276032,1325400064,838860800,33554432,855638016,1761607680,1191182336,1560281088,1459617792,1577058304,1426063360,956301312,0,805306368,2063597568,1409286144,67108864,318767104,67108864,0,0,33554432,0,234881024,2080374784,1509949440,285212672,0,67108864,973078528,1308622848,1174405120,1023410176,553648128,100663296,0,855638016,838860800,1543503872,855638016,167772160,1073741824,1912602624,1728053248,1124073472,335544320,1241513984,1644167168,1442840576,654311424,268435456,1241513984,1442840576,1325400064,1409286144,1275068416,1493172224,1493172224,1040187392,1275068416,1275068416,1342177280,1459617792,1224736768,1744830464,1224736768,1124073472,1325400064,1459617792,956301312,234881024,268435456,0,905969664,1459617792,1459617792,553648128,201326592,234881024,956301312,520093696,654311424,134217728,855638016,1342177280,1224736768,1577058304,0,134217728,771751936,1493172224,1140850688,0,939524096,1409286144,1392508928,1459617792,1560281088,1291845632,1375731712,1224736768,0,201326592,2046820352,838860800,100663296,0,0,100663296,33554432,285212672,2080374784,973078528,0,0,771751936,1526726656,1442840576,956301312,905969664,0,83886080,201326592,1258291200,1694498816,1342177280,134217728,352321536,1660944384,1627389952,738197504,553648128,738197504,1593835520,1862270976,1006632960,1040187392,704643072,1610612736,1761607680,872415232,1073741824,1543503872,184549376,1090519040,973078528,1744830464,419430400,1174405120,973078528,503316480,687865856,1140850688,419430400,301989888,805306368,1375731712,1593835520,1828716544,1660944384,855638016,218103808,738197504,855638016,1744830464,956301312,184549376,134217728,905969664,1291845632,570425344,1191182336,134217728,0,822083584,1325400064,637534208,218103808,0,1493172224,1644167168,1342177280,1275068416,721420288,1291845632,1342177280,0,1644167168,1056964608,1107296256,50331648,301989888,150994944,83886080,50331648,50331648,0,100663296,0,0,67108864,234881024,1174405120,1845493760,754974720,234881024,234881024,0,50331648,503316480,956301312,738197504,738197504,16777216,905969664,1308622848,1358954496,33554432,16777216,1174405120,1946157056,1375731712,553648128,721420288,889192448,1811939328,1308622848,1442840576,1073741824,83886080,251658240,654311424,771751936,1090519040,1476395008,1476395008,1174405120,1560281088,1459617792,1694498816,1610612736,402653184,167772160,553648128,201326592,536870912,0,905969664,1509949440,1358954496,1124073472,352321536,704643072,1392508928,754974720,603979776,0,553648128,771751936,872415232,1291845632,469762048,0,570425344,1442840576,872415232,838860800,1660944384,838860800,1124073472,1711276032,201326592,805306368,1728053248,754974720,301989888,1325400064,1862270976,1140850688,16777216,0,0,0,33554432,0,0,117440512,0,1476395008,1291845632,721420288,268435456,33554432,805306368,2046820352,218103808,150994944,1560281088,1073741824,637534208,100663296,1056964608,1879048192,637534208,201326592,1157627904,1862270976,1409286144,956301312,855638016,1426063360,1577058304,1459617792,100663296,369098752,1358954496,1459617792,1459617792,1862270976,1577058304,1660944384,1291845632,1526726656,1258291200,1426063360,1526726656,1157627904,1828716544,1593835520,1811939328,1593835520,1392508928,1191182336,1493172224,1023410176,687865856,352321536,184549376,1644167168,1560281088,16777216,0,1241513984,1191182336,1023410176,939524096,201326592,486539264,1090519040,671088640,671088640,1124073472,838860800,721420288,1191182336,1577058304,0,184549376,1543503872,603979776,0,822083584,1124073472,1325400064,335544320,1191182336,1342177280,469762048,0,83886080,16777216,83886080,0,150994944,0,1560281088,2046820352,553648128,0,150994944,1040187392,1358954496,1375731712,452984832,536870912,1593835520,603979776,251658240,1308622848,1879048192,654311424,436207616,1694498816,1610612736,1157627904,234881024,754974720,1509949440,1157627904,1291845632,1090519040,1543503872,1308622848,1577058304,1694498816,1577058304,1409286144,1342177280,1476395008,1291845632,1325400064,1962934272,1476395008,1392508928,1543503872,83886080,167772160,905969664,1258291200,1224736768,838860800,318767104,1358954496,1627389952,1442840576,905969664,1476395008,939524096,1476395008,1157627904,520093696,385875968,721420288,1895825408,553648128,234881024,33554432,603979776,1258291200,855638016,905969664,1056964608,134217728,704643072,1291845632,905969664,1442840576,1560281088,67108864,1543503872,1644167168,1107296256,1291845632,1526726656,1107296256,234881024,16777216,16777216,50331648,0,67108864,50331648,469762048,1191182336,100663296,50331648,738197504,1677721600,1342177280,553648128,0,301989888,1174405120,1157627904,0,973078528,1694498816,50331648,83886080,1358954496,1224736768,1056964608,218103808,1392508928,1795162112,771751936,1174405120,1342177280,1375731712,1308622848,1241513984,788529152,1040187392,1241513984,1342177280,1358954496,1224736768,1375731712,1174405120,1459617792,1392508928,1325400064,1694498816,1879048192,603979776,1107296256,1610612736,637534208,922746880,1040187392,603979776,0,1258291200,1409286144,1342177280,989855744,385875968,654311424,973078528,1426063360,50331648,369098752,117440512,1358954496,452984832,67108864,536870912,1191182336,419430400,1342177280,1459617792,1241513984,704643072,268435456,838860800,956301312,1224736768,1493172224,1107296256,1325400064,1040187392,1493172224,0,0,234881024,0,0,33554432,117440512,50331648,553648128,83886080,134217728,939524096,1493172224,1191182336,83886080,218103808,150994944,587202560,1358954496,201326592,1207959552,1593835520,0,452984832,939524096,1409286144,318767104,603979776,1509949440,1677721600,654311424,805306368,1459617792,1174405120,1426063360,654311424,1358954496,1677721600,1644167168,1375731712,1140850688,939524096,922746880,1308622848,1660944384,1711276032,1040187392,1509949440,1677721600,1056964608,1795162112,1694498816,1006632960,1375731712,0,134217728,1040187392,905969664,1124073472,1627389952,1275068416,1509949440,520093696,100663296,1107296256,1627389952,1040187392,335544320,301989888,33554432,503316480,1140850688,385875968,620756992,1174405120,1224736768,268435456,771751936,1006632960,1107296256,570425344,0,1342177280,1325400064,771751936,1241513984,1358954496,1342177280,1392508928,922746880,0,50331648,0,0,0,0,67108864,67108864,201326592,1207959552,1224736768,0,1124073472,939524096,1140850688,1577058304,150994944,855638016,1275068416,33554432,922746880,1610612736,1493172224,738197504,100663296,1627389952,1207959552,503316480,1325400064,1627389952,1342177280,1006632960,452984832,1627389952,1560281088,1795162112,687865856,1006632960,805306368,905969664,855638016,637534208,1711276032,1392508928,822083584,1711276032,1577058304,0,167772160,436207616,805306368,1627389952,905969664,922746880,167772160,536870912,687865856,1090519040,1543503872,1224736768,956301312,838860800,0,83886080,1258291200,1107296256,1090519040,150994944,0,469762048,973078528,587202560,0,889192448,1392508928,1358954496,503316480,1006632960,1543503872,1426063360,637534208,536870912,1543503872,570425344,1023410176,1442840576,1644167168,452984832,0,100663296,150994944,117440512,0,352321536,33554432,0,419430400,0,16777216,503316480,654311424,1291845632,1006632960,50331648,956301312,1409286144,201326592,553648128,1694498816,855638016,33554432,721420288,1660944384,1778384896,436207616,1174405120,1694498816,1258291200,150994944,687865856,1543503872,1308622848,1124073472,167772160,469762048,1543503872,872415232,1308622848,637534208,1845493760,1644167168,1459617792,1459617792,922746880,1644167168,1493172224,1577058304,973078528,150994944,184549376,385875968,1191182336,905969664,1426063360,822083584,1325400064,1476395008,1073741824,0,1610612736,1124073472,67108864,0,251658240,1107296256,1761607680,704643072,150994944,100663296,1056964608,1224736768,0,721420288,754974720,1191182336,973078528,218103808,1258291200,1358954496,16777216,1241513984,1979711488,721420288,385875968,654311424,738197504,0,50331648,0,50331648,100663296,0,67108864,134217728,33554432,201326592,603979776,1191182336,1090519040,352321536,16777216,805306368,1392508928,117440512,369098752,1912602624,1090519040,67108864,1174405120,1493172224,1476395008,805306368,1459617792,1744830464,738197504,1107296256,1090519040,1828716544,1610612736,805306368,1107296256,1593835520,1291845632,1459617792,805306368,1040187392,1275068416,671088640,1543503872,788529152,1090519040,1157627904,738197504,553648128,419430400,922746880,905969664,1392508928,788529152,436207616,603979776,1426063360,788529152,1476395008,1291845632,1895825408,822083584,436207616,1023410176,1191182336,1258291200,553648128,83886080,536870912,1124073472,1090519040,620756992,16777216,771751936,1342177280,268435456,0,1207959552,1258291200,452984832,134217728,536870912,1056964608,889192448,520093696,1493172224,1761607680,469762048,134217728,150994944,83886080,83886080,0,16777216,134217728,100663296,67108864,0,838860800,1375731712,1375731712,251658240,352321536,1660944384,1459617792,503316480,452984832,1593835520,1241513984,0,1073741824,1409286144,1543503872,419430400,1275068416,1426063360,469762048,1191182336,1476395008,1107296256,704643072,1191182336,1711276032,1392508928,754974720,402653184,654311424,1593835520,1325400064,1761607680,1577058304,1526726656,1291845632,1795162112,1543503872,1677721600,721420288,704643072,234881024,352321536,654311424,1090519040,1711276032,385875968,654311424,1040187392,1040187392,1644167168,67108864,1140850688,1157627904,0,637534208,1375731712,1275068416,1224736768,469762048,33554432,1023410176,1543503872,1157627904,184549376,33554432,1442840576,1073741824,0,536870912,1694498816,570425344,0,1358954496,939524096,83886080,469762048,1778384896,1879048192,369098752,16777216,0,50331648,67108864,167772160,167772160,536870912,83886080,754974720,1375731712,922746880,134217728,0,1677721600,1577058304,0,150994944,1493172224,1040187392,50331648,553648128,1409286144,1291845632,721420288,1577058304,1308622848,234881024,1358954496,1426063360,1325400064,234881024,620756992,1593835520,1426063360,872415232,939524096,1090519040,1392508928,1409286144,1375731712,1358954496,1593835520,637534208,1895825408,1677721600,1241513984,654311424,1124073472,973078528,1207959552,352321536,167772160,33554432,1761607680,1342177280,603979776,67108864,301989888,1493172224,1258291200,0,771751936,469762048,570425344,1056964608,184549376,419430400,1962934272,805306368,0,117440512,805306368,1023410176,872415232,0,1006632960,872415232,0,33554432,687865856,654311424,134217728,318767104,1124073472,452984832,0,1040187392,838860800,0,33554432,117440512,67108864,117440512,335544320,0,687865856,1073741824,1442840576,100663296,352321536,1778384896,1929379840,251658240,167772160,1107296256,1090519040,167772160,369098752,1644167168,1157627904,771751936,1342177280,1107296256,419430400,1325400064,1509949440,603979776,1660944384,1509949440,1392508928,905969664,1442840576,1744830464,1224736768,1358954496,973078528,285212672,687865856,2063597568,1107296256,1056964608,1140850688,1124073472,1258291200,385875968,738197504,805306368,922746880,1073741824,1006632960,352321536,285212672,520093696,1224736768,1811939328,939524096,1677721600,1577058304,1207959552,352321536,1207959552,704643072,1392508928,1107296256,419430400,754974720,1509949440,1711276032,1258291200,520093696,1224736768,1493172224,671088640,0,1811939328,1392508928,0,721420288,2063597568,671088640,33554432,989855744,1728053248,0,0,134217728,0,50331648,0,83886080,0,0,620756992,1744830464,1157627904,0,251658240,1560281088,1325400064,150994944,251658240,1023410176,1711276032,654311424,0,1426063360,1392508928,436207616,1392508928,1325400064,671088640,1174405120,1728053248,603979776,1526726656,1275068416,1409286144,1258291200,805306368,1493172224,1325400064,788529152,1526726656,1409286144,1258291200,1577058304,1224736768,1392508928,1509949440,1711276032,2080374784,1275068416,922746880,1509949440,419430400,301989888,16777216,452984832,1140850688,922746880,452984832,0,1459617792,1627389952,1291845632,1811939328,1090519040,989855744,1358954496,989855744,754974720,872415232,1224736768,385875968,352321536,352321536,1124073472,1124073472,218103808,486539264,2063597568,603979776,335544320,1509949440,436207616,452984832,838860800,1610612736,1124073472,721420288,1660944384,1845493760,603979776,117440512,0,201326592,50331648,0,16777216,117440512,973078528,1191182336,0,436207616,1140850688,1375731712,0,0,637534208,1593835520,587202560,50331648,503316480,1912602624,50331648,1275068416,1761607680,922746880,1006632960,1644167168,1090519040,1107296256,1610612736,1090519040,1056964608,905969664,1291845632,1258291200,1191182336,436207616,1409286144,1543503872,1543503872,1090519040,1308622848,1358954496,0,1325400064,838860800,0,234881024,1224736768,973078528,956301312,469762048,268435456,318767104,1224736768,1090519040,1006632960,822083584,553648128,1342177280,1375731712,687865856,117440512,301989888,1325400064,922746880,218103808,16777216,1174405120,1157627904,369098752,452984832,1358954496,1107296256,301989888,587202560,1879048192,1157627904,0,989855744,1543503872,201326592,1392508928,1325400064,301989888,83886080,1426063360,1560281088,150994944,134217728,50331648,16777216,0,67108864,520093696,939524096,0,385875968,1744830464,1610612736,671088640,218103808,1275068416,1526726656,469762048,150994944,301989888,1728053248,620756992,1207959552,1375731712,788529152,1191182336,1610612736,1459617792,1073741824,1426063360,687865856,1493172224,1023410176,1442840576,1308622848,855638016,654311424,1677721600,1694498816,889192448,855638016,956301312,1006632960,1342177280,1694498816,1325400064,1543503872,1811939328,1577058304,251658240,0,704643072,436207616,872415232,838860800,50331648,100663296,956301312,1224736768,956301312,922746880,1124073472,1442840576,1258291200,939524096,0,1426063360,1325400064,788529152,167772160,1191182336,1325400064,318767104,452984832,1291845632,1207959552,0,452984832,1107296256,67108864,620756992,1124073472,1577058304,654311424,1241513984,1224736768,0,889192448,1677721600,973078528,0,167772160,0,436207616,956301312,268435456,234881024,0,1694498816,1224736768,654311424,0,1224736768,1442840576,536870912,33554432,0,1392508928,956301312,704643072,1795162112,1157627904,654311424,1677721600,1275068416,1073741824,1224736768,721420288,1409286144,1107296256,1325400064,1258291200,1174405120,1275068416,1224736768,1660944384,503316480,1577058304,1610612736,1694498816,1241513984,1543503872,520093696,838860800,1711276032,956301312,704643072,1845493760,1224736768,654311424,218103808,637534208,1442840576,956301312,805306368,100663296,251658240,671088640,1409286144,1325400064,0,536870912,1308622848,1006632960,0,1023410176,1375731712,520093696,83886080,1325400064,1308622848,268435456,503316480,1342177280,1006632960,50331648,301989888,150994944,1040187392,1610612736,1426063360,1207959552,0,1426063360,1207959552,67108864,788529152,1929379840,117440512,0,117440512,0,285212672,0,419430400,1610612736,1493172224,620756992,67108864,352321536,1660944384,822083584,134217728,83886080,989855744,1358954496,520093696,1174405120,1124073472,301989888,1140850688,1258291200,905969664,1358954496,889192448,1207959552,1644167168,671088640,1660944384,570425344,1526726656,1560281088,922746880,1627389952,1711276032,956301312,419430400,369098752,603979776,1694498816,889192448,738197504,1224736768,201326592,922746880,1174405120,1946157056,1040187392,788529152,150994944,0,1040187392,1157627904,687865856,167772160,436207616,1325400064,1442840576,1275068416,134217728,889192448,1459617792,1006632960,117440512,469762048,1124073472,402653184,0,989855744,1677721600,402653184,855638016,1056964608,536870912,0,352321536,1862270976,1526726656,1124073472,1342177280,1241513984,503316480,1644167168,1459617792,0,1392508928,570425344,0,134217728,369098752,0,587202560,1711276032,1140850688,486539264,0,905969664,1375731712,771751936,0,469762048,1023410176,855638016,503316480,939524096,1442840576,50331648,1325400064,1325400064,788529152,1577058304,1056964608,1006632960,1644167168,268435456,1325400064,838860800,922746880,1828716544,687865856,1040187392,1476395008,318767104,16777216,1375731712,1493172224,1577058304,1778384896,1962934272,1660944384,1325400064,1560281088,352321536,469762048,402653184,335544320,1409286144,1509949440,838860800,134217728,452984832,1056964608,1593835520,452984832,318767104,754974720,1593835520,822083584,0,1191182336,318767104,939524096,452984832,83886080,872415232,385875968,671088640,939524096,301989888,117440512,1426063360,620756992,83886080,536870912,1358954496,1241513984,973078528,1476395008,1560281088,201326592,1291845632,1107296256,1090519040,50331648,0,33554432,16777216,0,134217728,973078528,1459617792,0,536870912,1006632960,1224736768,1358954496,0,268435456,1023410176,1476395008,16777216,301989888,1056964608,469762048,1040187392,905969664,1191182336,1291845632,1207959552,671088640,1509949440,1157627904,1124073472,1459617792,671088640,1275068416,1107296256,1191182336,1610612736,1124073472,973078528,1627389952,1358954496,1476395008,1509949440,436207616,671088640,1358954496,1174405120,1358954496,1275068416,1761607680,620756992,201326592,117440512,671088640,1426063360,1308622848,335544320,0,134217728,855638016,1258291200,167772160,587202560,1358954496,754974720,503316480,301989888,234881024,1157627904,469762048,201326592,1090519040,234881024,352321536,704643072,654311424,520093696,33554432,251658240,570425344,1040187392,1157627904,1577058304,0,1660944384,1627389952,0,738197504,1560281088,1174405120,83886080,0,0,218103808,1660944384,1375731712,486539264,33554432,1124073472,1694498816,805306368,100663296,251658240,973078528,1392508928,184549376,117440512,503316480,989855744,33554432,1308622848,1073741824,486539264,1543503872,939524096,1543503872,1493172224,385875968,1543503872,989855744,1224736768,1459617792,1342177280,1241513984,671088640,1459617792,1476395008,486539264,838860800,1325400064,989855744,1493172224,1157627904,1207959552,922746880,301989888,486539264,0,805306368,1392508928,553648128,385875968,369098752,1325400064,1224736768,822083584,402653184,0,754974720,1023410176,50331648,687865856,1862270976,469762048,167772160,788529152,67108864,419430400,251658240,352321536,335544320,0,67108864,520093696,117440512,0,536870912,1140850688,184549376,704643072,1694498816,1291845632,1442840576,1056964608,754974720,218103808,1224736768,2046820352,83886080,100663296,0,822083584,1644167168,637534208,234881024,1140850688,989855744,922746880,150994944,0,1006632960,1157627904,1476395008,167772160,788529152,788529152,50331648,1258291200,1375731712,838860800,1879048192,1124073472,905969664,1711276032,150994944,1560281088,939524096,1174405120,1644167168,1392508928,1375731712,520093696,1157627904,1627389952,1140850688,1291845632,1593835520,1526726656,1560281088,1577058304,1258291200,1224736768,1493172224,1409286144,1090519040,1124073472,16777216,50331648,1006632960,1392508928,184549376,134217728,486539264,1107296256,1644167168,1258291200,234881024,956301312,1023410176,167772160,889192448,2030043136,134217728,1107296256,486539264,201326592,855638016,0,855638016,1056964608,218103808,637534208,0,654311424,0,1627389952,1291845632,704643072,100663296,1560281088,0,150994944,1761607680,654311424,117440512,1073741824,1157627904,0,184549376,637534208,0,1090519040,1375731712,989855744,1291845632,0,822083584,436207616,1023410176,1124073472,0,402653184,620756992,251658240,100663296,1761607680,520093696,1275068416,1459617792,352321536,1610612736,687865856,1543503872,855638016,1124073472,1291845632,1107296256,1509949440,1509949440,1056964608,1694498816,419430400,905969664,1291845632,1191182336,1241513984,1207959552,570425344,872415232,1459617792,654311424,369098752,1174405120,1258291200,1325400064,436207616,50331648,788529152,1342177280,553648128,100663296,1358954496,1056964608,1543503872,1191182336,150994944,1476395008,1191182336,100663296,1459617792,1325400064,436207616,973078528,671088640,536870912,352321536,436207616,771751936,721420288,0,1006632960,1358954496,570425344,889192448,1275068416,503316480,16777216,1862270976,939524096,301989888,1258291200,1761607680,385875968,553648128,939524096,100663296,234881024,0,654311424,939524096,1342177280,1493172224,218103808,318767104,1744830464,520093696,486539264,0,637534208,1325400064,553648128,0,1124073472,1392508928,0,1560281088,603979776,1207959552,1157627904,738197504,1325400064,587202560,1660944384,1191182336,1342177280,1140850688,956301312,1811939328,452984832,872415232,1660944384,503316480,1342177280,1543503872,1409286144,1543503872,1711276032,1023410176,687865856,1593835520,788529152,654311424,822083584,1358954496,1140850688,0,486539264,1174405120,1040187392,838860800,452984832,201326592,1224736768,822083584,285212672,1291845632,1157627904,100663296,1392508928,419430400,301989888,889192448,50331648,587202560,150994944,671088640,1375731712,134217728,452984832,989855744,1358954496,1090519040,1426063360,1107296256,268435456,1442840576,2013265920,1006632960,16777216,503316480,1728053248,436207616,0,33554432,285212672,419430400,1459617792,738197504,872415232,352321536,587202560,872415232,1006632960,721420288,50331648,0,788529152,1073741824,0,1291845632,1459617792,335544320,1426063360,1375731712,872415232,1174405120,956301312,1660944384,1040187392,1409286144,905969664,872415232,1342177280,1107296256,1493172224,1207959552,1526726656,1207959552,1342177280,1677721600,1040187392,536870912,1627389952,1644167168,1627389952,1560281088,1426063360,1174405120,1275068416,1157627904,184549376,721420288,654311424,1040187392,67108864,872415232,721420288,369098752,1593835520,973078528,520093696,1644167168,369098752,369098752,1795162112,369098752,754974720,1090519040,301989888,805306368,201326592,805306368,1241513984,33554432,1090519040,973078528,805306368,1090519040,1207959552,973078528,1275068416,1191182336,1392508928,1308622848,1375731712,1442840576,352321536,134217728,1644167168,1258291200,16777216,50331648,0,1409286144,1627389952,620756992,0,1023410176,637534208,1358954496,520093696,335544320,738197504,1342177280,1442840576,167772160,83886080,1174405120,1107296256,268435456,1375731712,352321536,1543503872,872415232,1358954496,1174405120,1442840576,1157627904,1392508928,1174405120,1526726656,1392508928,1509949440,1442840576,654311424,335544320,872415232,1593835520,1090519040,1358954496,1610612736,1275068416,1728053248,1811939328,452984832,889192448,1409286144,939524096,1493172224,587202560,939524096,1040187392,1023410176,50331648,1275068416,67108864,956301312,1845493760,671088640,1644167168,1358954496,16777216,1744830464,838860800,436207616,1375731712,0,83886080,1509949440,0,687865856,704643072,402653184,1124073472,452984832,1174405120,1392508928,486539264,1124073472,419430400,1375731712,805306368,1392508928,704643072,1593835520,721420288,939524096,1191182336,83886080,0,402653184,922746880,905969664,687865856,721420288,671088640,1224736768,268435456,0,587202560,1174405120,1207959552,1107296256,0,1191182336,1392508928,33554432,1493172224,939524096,973078528,1275068416,989855744,1560281088,671088640,1258291200,889192448,1006632960,1526726656,1476395008,1275068416,1543503872,1593835520,1275068416,1140850688,1275068416,369098752,1275068416,1224736768,822083584,1862270976,1275068416,117440512,385875968,1157627904,721420288,1006632960,1409286144,1543503872,419430400,671088640,1140850688,721420288,1459617792,1526726656,0,1291845632,1157627904,234881024,1526726656,822083584,67108864,1392508928,889192448,738197504,1107296256,33554432,1493172224,218103808,285212672,1392508928,0,654311424,1358954496,452984832,1426063360,1593835520,67108864,369098752,1308622848,1291845632,1409286144,956301312,1358954496,1207959552,33554432,301989888,0,16777216,335544320,0,301989888,637534208,1056964608,771751936,301989888,872415232,1325400064,1459617792,671088640,100663296,838860800,402653184,503316480,687865856,889192448,1090519040,855638016,1291845632,1090519040,1660944384,805306368,1325400064,1325400064,822083584,1828716544,1090519040,1493172224,1526726656,1291845632,1644167168,1056964608,1795162112,1023410176,1426063360,1644167168,788529152,922746880,872415232,486539264,905969664,1694498816,1493172224,1744830464,1006632960,0,687865856,1476395008,1124073472,822083584,1040187392,587202560,1493172224,1409286144,1325400064,1728053248,486539264,1795162112,218103808,1241513984,50331648,1342177280,402653184,452984832,100663296,671088640,1157627904,100663296,1140850688,1023410176,855638016,1124073472,671088640,805306368,1711276032,603979776,956301312,1207959552,1006632960,1308622848,570425344,1375731712,1476395008,637534208,67108864,67108864,117440512,83886080,0,1426063360,1459617792,872415232,117440512,805306368,1308622848,1207959552,855638016,50331648,822083584,570425344,536870912,1442840576,285212672,1543503872,788529152,1258291200,939524096,2013265920,1107296256,1191182336,1442840576,1426063360,1644167168,1476395008,1409286144,1543503872,1291845632,1627389952,1258291200,1476395008,838860800,1174405120,1879048192,671088640,1342177280,1409286144,301989888,889192448,1308622848,1174405120,1241513984,1006632960,2063597568,1006632960,738197504,1426063360,1493172224,654311424,134217728,838860800,620756992,1275068416,1241513984,1845493760,905969664,788529152,738197504,1023410176,503316480,1660944384,553648128,0,1107296256,16777216,1426063360,167772160,520093696,1862270976,0,268435456,1224736768,1107296256,1627389952,1409286144,654311424,1644167168,553648128,1526726656,1862270976,1023410176,0,436207616,83886080,0,0,0,603979776,1426063360,973078528,16777216,1107296256,1006632960,1258291200,318767104,150994944,973078528,973078528,0,922746880,1090519040,1207959552,1375731712,1375731712,1241513984,1342177280,1140850688,1476395008,1392508928,1258291200,1526726656,1493172224,1090519040,1577058304,1593835520,1459617792,1543503872,1476395008,1560281088,419430400,1577058304,1325400064,436207616,1392508928,201326592,1040187392,1543503872,754974720,738197504,285212672,167772160,738197504,1325400064,1308622848,1107296256,1006632960,1308622848,1191182336,1392508928,771751936,1526726656,1157627904,486539264,1258291200,1409286144,989855744,1442840576,1140850688,838860800,1543503872,100663296,1140850688,687865856,0,939524096,385875968,922746880,369098752,16777216,1090519040,234881024,436207616,1207959552,335544320,1610612736,1627389952,1962934272,385875968,184549376,301989888,402653184,553648128,50331648,117440512,201326592,1476395008,1157627904,0,1459617792,1207959552,1157627904,419430400,0,620756992,805306368,251658240,0,1291845632,16777216,1409286144,1392508928,989855744,419430400,1493172224,1526726656,1325400064,1509949440,1560281088,1392508928,1610612736,1728053248,1577058304,1241513984,1644167168,1442840576,1627389952,922746880,1476395008,1459617792,402653184,1711276032,1124073472,536870912,721420288,1056964608,268435456,1342177280,1828716544,1040187392,654311424,1023410176,1107296256,1342177280,905969664,1610612736,1207959552,1426063360,1174405120,1040187392,1593835520,889192448,1476395008,956301312,1409286144,1124073472,1308622848,452984832,1241513984,335544320,939524096,1375731712,83886080,1325400064,301989888,939524096,1409286144,318767104,1023410176,452984832,503316480,1342177280,83886080,520093696,1275068416,1677721600,956301312,436207616,838860800,301989888,1056964608,134217728,0,1560281088,1040187392,167772160,872415232,1174405120,1140850688,872415232,201326592,620756992,889192448,201326592,402653184,1056964608,1728053248,16777216,1174405120,1509949440,553648128,1610612736,1828716544,452984832,1526726656,1174405120,1493172224,1811939328,1442840576,1241513984,1526726656,1644167168,1543503872,1375731712,1409286144,1073741824,1761607680,570425344,1023410176,1073741824,520093696,1342177280,822083584,83886080,1241513984,1375731712,1426063360,1358954496,1509949440,469762048,1090519040,218103808,1241513984,301989888,1509949440,1627389952,1459617792,1275068416,1174405120,1090519040,1157627904,1342177280,1392508928,570425344,1476395008,1006632960,1073741824,637534208,469762048,1577058304,503316480,1207959552,1090519040,805306368,1191182336,436207616,838860800,1258291200,1107296256,1660944384,855638016,1426063360,1375731712,33554432,100663296,0,520093696,620756992,1426063360,0,167772160,1140850688,268435456,100663296,1409286144,805306368,1308622848,301989888,805306368,1107296256,704643072,0,721420288,989855744,234881024,1191182336,1241513984,1040187392,1023410176,1308622848,1224736768,1224736768,1241513984,1090519040,1744830464,1358954496,1476395008,1610612736,1392508928,1476395008,1409286144,1560281088,1459617792,1426063360,771751936,973078528,1107296256,721420288,771751936,1325400064,402653184,1241513984,939524096,369098752,1124073472,1577058304,1459617792,486539264,939524096,553648128,1073741824,704643072,100663296,973078528,1845493760,771751936,1694498816,989855744,1090519040,1526726656,1258291200,1241513984,1358954496,1040187392,452984832,486539264,956301312,167772160,889192448,419430400,1694498816,301989888,889192448,620756992,285212672,1291845632,1392508928,1124073472,1526726656,1677721600,872415232,721420288,150994944,335544320,100663296,0,771751936,0,0,436207616,134217728,1308622848,704643072,1476395008,201326592,1358954496,1459617792,956301312,469762048,855638016,1342177280,738197504,503316480,1258291200,1006632960,1006632960,1426063360,1241513984,1191182336,1358954496,922746880,1090519040,1711276032,1778384896,1342177280,1694498816,1509949440,1744830464,1543503872,1375731712,1526726656,1509949440,788529152,1090519040,1560281088,771751936,671088640,754974720,1241513984,1107296256,1291845632,570425344,1207959552,1006632960,1107296256,889192448,939524096,922746880,939524096,1509949440,234881024,1459617792,150994944,1526726656,0,1124073472,268435456,1124073472,1543503872,1140850688,1073741824,603979776,1056964608,553648128,838860800,553648128,822083584,452984832,872415232,1006632960,973078528,1073741824,452984832,838860800,1409286144,872415232,1509949440,1459617792,989855744,486539264,738197504,637534208,452984832,385875968,0,167772160,100663296,218103808,872415232,1023410176,1476395008,1610612736,1023410176,486539264,1392508928,369098752,1107296256,671088640,1308622848,0,1509949440,1275068416,1426063360,1325400064,1493172224,956301312,1241513984,1392508928,1275068416,1610612736,1493172224,1577058304,1342177280,1509949440,1375731712,1694498816,1543503872,1459617792,1325400064,1040187392,889192448,1140850688,1543503872,905969664,1275068416,889192448,989855744,1375731712,1090519040,285212672,1140850688,1409286144,1308622848,1577058304,738197504,1040187392,486539264,1375731712,167772160,1358954496,33554432,1845493760,50331648,1358954496,1090519040,1174405120,1375731712,1241513984,452984832,1023410176,1090519040,989855744,1006632960,1593835520,419430400,1275068416,218103808,1375731712,167772160,335544320,754974720,419430400,1325400064,1358954496,771751936,1426063360,1107296256,536870912,989855744,553648128,335544320,1140850688,67108864,0,83886080,268435456,620756992,1040187392,335544320,1744830464,939524096,1392508928,721420288,1241513984,1023410176,1174405120,285212672,587202560,1358954496,1509949440,1409286144,1224736768,1358954496,1090519040,1509949440,1191182336,1728053248,1476395008,1711276032,1459617792,1577058304,1308622848,1493172224,1577058304,1560281088,1778384896,1224736768,1207959552,1224736768,1224736768,1476395008,1124073472,1409286144,771751936,1275068416,369098752,1040187392,1040187392,1308622848,872415232,1476395008,939524096,721420288,788529152,570425344,1325400064,184549376,1426063360,536870912,1157627904,335544320,1392508928,1124073472,1224736768,1493172224,1493172224,637534208,1275068416,536870912,1140850688,469762048,1140850688,201326592,1392508928,402653184,1375731712,1090519040,285212672,671088640,973078528,1140850688,1677721600,687865856,1358954496,939524096,620756992,318767104,553648128,117440512,587202560,553648128,285212672,0,838860800,1107296256,184549376,1191182336,1191182336,1308622848,956301312,1241513984,1006632960,1040187392,1174405120,117440512,1694498816,1291845632,1308622848,1325400064,1107296256,1308622848,1358954496,1426063360,1291845632,1308622848,1442840576,1560281088,1392508928,1610612736,1442840576,1610612736,1560281088,1560281088,1442840576,1342177280,1627389952,1342177280,1325400064,1426063360,822083584,1358954496,788529152,1040187392,436207616,1224736768,1224736768,1258291200,1207959552,1174405120,1392508928,687865856,1056964608,536870912,1358954496,754974720,1124073472,436207616,1426063360,956301312,1442840576,1342177280,1207959552,1493172224,1258291200,1023410176,1409286144,335544320,1543503872,570425344,1258291200,989855744,1560281088,1124073472,452984832,1962934272,402653184,469762048,1291845632,1040187392,1744830464,637534208,1157627904,771751936,587202560,704643072,285212672,1073741824,184549376,150994944,50331648,33554432,402653184,285212672,637534208,1845493760,973078528,486539264,1090519040,1342177280,805306368,1543503872,1191182336,1174405120,1459617792,1694498816,1476395008,1056964608,1275068416,1392508928,1392508928,1157627904,1258291200,1392508928,1577058304,1459617792,1375731712,1593835520,1543503872,1644167168,1493172224,1577058304,1191182336,1493172224,1543503872,1342177280,1543503872,1811939328,771751936,1207959552,1140850688,872415232,620756992,1006632960,822083584,1342177280,1023410176,1140850688,1157627904,872415232,654311424,788529152,889192448,134217728,855638016,1140850688,1526726656,587202560,1174405120,1275068416,1124073472,1191182336,1660944384,1342177280,1493172224,1023410176,1493172224,1224736768,503316480,704643072,788529152,1006632960,100663296,1543503872,117440512,603979776,1258291200,201326592,1577058304,1023410176,419430400,1006632960,1409286144,671088640,822083584,1241513984,301989888,100663296,16777216,67108864,33554432,268435456,1660944384,1476395008,1040187392,0,1191182336,1207959552,1392508928,905969664,1241513984,1358954496,1375731712,1660944384,1157627904,134217728,1040187392,1258291200,1627389952,1107296256,805306368,1560281088,1291845632,1577058304,1426063360,1560281088,1526726656,1543503872,1426063360,1560281088,1241513984,1459617792,1241513984,1593835520,1275068416,1275068416,1006632960,889192448,1140850688,1157627904,671088640,1040187392,587202560,1476395008,1375731712,1056964608,1375731712,788529152,1056964608,436207616,1493172224,620756992,1358954496,201326592,1392508928,553648128,1610612736,1056964608,1056964608,1375731712,1711276032,1375731712,1241513984,1426063360,1258291200,1879048192,218103808,536870912,469762048,1392508928,687865856,1174405120,721420288,939524096,956301312,1107296256,1375731712,1342177280,1275068416,1140850688,771751936,889192448,788529152,2013265920,0,150994944,0,50331648,0,369098752,905969664,771751936,16777216,838860800,1325400064,822083584,335544320,1476395008,1342177280,1426063360,486539264,1509949440,1610612736,1090519040,922746880,1694498816,1140850688,1560281088,1275068416,1342177280,1677721600,1241513984,1442840576,1509949440,1526726656,1459617792,1476395008,1560281088,1375731712,1207959552,1610612736,1107296256,1358954496,1157627904,1040187392,889192448,1375731712,939524096,1056964608,1224736768,973078528,1275068416,872415232,1543503872,1224736768,1124073472,989855744,671088640,1157627904,687865856,1342177280,905969664,1526726656,402653184,1174405120,1392508928,939524096,1124073472,1174405120,1459617792,452984832,1560281088,184549376,1023410176,838860800,1090519040,1308622848,1627389952,268435456,956301312,1442840576,0,905969664,1224736768,654311424,1728053248,553648128,603979776,956301312,855638016,1157627904,1459617792,452984832,0,100663296,100663296,218103808,1040187392,1006632960,0,838860800,1090519040,855638016,100663296,872415232,1660944384,1493172224,1325400064,1107296256,1325400064,1392508928,1224736768,1577058304,1358954496,1325400064,1509949440,1711276032,1761607680,1442840576,1291845632,1358954496,1509949440,1577058304,1442840576,1593835520,1577058304,1258291200,1023410176,1610612736,822083584,1728053248,1040187392,1241513984,1073741824,1207959552,989855744,1258291200,1677721600,855638016,1426063360,654311424,1392508928,1107296256,1342177280,1375731712,1358954496,1191182336,687865856,1476395008,805306368,1090519040,671088640,1442840576,738197504,520093696,1358954496,1174405120,1426063360,637534208,1476395008,939524096,889192448,1308622848,788529152,536870912,1308622848,0,2097152000,1157627904,989855744,1224736768,1258291200,905969664,905969664,553648128,805306368,1392508928,637534208,553648128,251658240,771751936,134217728,0,0,620756992,855638016,469762048,788529152,1023410176,1241513984,1006632960,218103808,1660944384,1191182336,1493172224,67108864,805306368,1644167168,1073741824,1459617792,1358954496,1124073472,1593835520,1426063360,1493172224,1459617792,1207959552,1459617792,1191182336,1543503872,1644167168,1426063360,1627389952,1627389952,889192448,1174405120,1493172224,637534208,1694498816,889192448,939524096,939524096,1493172224,1157627904,1291845632,1291845632,1392508928,1459617792,1459617792,1375731712,939524096,1207959552,1224736768,1174405120,838860800,687865856,939524096,754974720,1174405120,872415232,973078528,1426063360,1660944384,1476395008,822083584,1107296256,1157627904,1124073472,1258291200,1140850688,1862270976,1107296256,1627389952,754974720,1409286144,1577058304,1694498816,1677721600,1157627904,1275068416,1644167168,822083584,1157627904,637534208,654311424,973078528,369098752,234881024,1744830464,0,201326592,16777216,1862270976,905969664,83886080,1174405120,1342177280,1291845632,1761607680,1107296256,1342177280,1426063360,1291845632,603979776,1610612736,1476395008,956301312,1593835520,1006632960,1040187392,1677721600,1442840576,1392508928,1577058304,1157627904,1358954496,1073741824,1577058304,1677721600,1392508928,1593835520,1660944384,570425344,1476395008,1207959552,1107296256,1509949440,872415232,1442840576,1174405120,1610612736,1207959552,1157627904,1375731712,1140850688,1258291200,1509949440,1375731712,1107296256,1056964608,1157627904,1426063360,1174405120,201326592,1476395008,805306368,1409286144,1140850688,1442840576,1174405120,1174405120,1778384896,671088640,838860800,1056964608,251658240,1560281088,0,1191182336,352321536,150994944,1526726656,1476395008,1526726656,1644167168,637534208,1560281088,1023410176,1392508928,570425344,0,671088640,335544320,1174405120,889192448,117440512,2113929216,0,33554432,0,83886080,0,838860800,1660944384,1560281088,1073741824,1442840576,1375731712,1476395008,1342177280,1090519040,1560281088,1862270976,436207616,1543503872,1660944384,738197504,1577058304,1275068416,1392508928,1593835520,1056964608,1224736768,1258291200,1392508928,1426063360,1711276032,1526726656,1241513984,1577058304,83886080,1778384896,1291845632,1375731712,1946157056,1073741824,1191182336,956301312,1191182336,1342177280,1560281088,1073741824,1426063360,1577058304,1207959552,1174405120,956301312,1140850688,905969664,1526726656,1325400064,536870912,1325400064,436207616,1191182336,671088640,1258291200,1543503872,1644167168,1862270976,1275068416,939524096,1644167168,721420288,1744830464,503316480,1275068416,1442840576,385875968,1577058304,889192448,536870912,1459617792,67108864,1660944384,822083584,1560281088,738197504,822083584,1610612736,956301312,1124073472,369098752,754974720,1644167168,16777216,0,83886080,16777216,452984832,1140850688,1509949440,1023410176,0,1275068416,1291845632,1291845632,1342177280,1124073472,1560281088,1023410176,285212672,1660944384,1291845632,1392508928,889192448,620756992,1728053248,1660944384,905969664,1124073472,1124073472,1241513984,1509949440,1761607680,1660944384,1728053248,1929379840,0,2013265920,1241513984,1090519040,1610612736,587202560,1006632960,956301312,1459617792,1342177280,1694498816,822083584,1392508928,1459617792,1409286144,788529152,838860800,1224736768,587202560,1107296256,1090519040,956301312,1577058304,369098752,1275068416,855638016,1207959552,1291845632,1577058304,1476395008,1409286144,1090519040,1577058304,1174405120,1526726656,1040187392,1392508928,1426063360,687865856,1442840576,1828716544,1241513984,1325400064,587202560,1140850688,738197504,855638016,184549376,956301312,1073741824,956301312,1006632960,436207616,822083584,352321536,0,67108864,0,134217728,721420288,1358954496,1543503872,620756992,1375731712,1459617792,1593835520,33554432,268435456,1409286144,1375731712,0,1493172224,1862270976,285212672,1392508928,855638016,1073741824,754974720,1493172224,1224736768,1560281088,956301312,1224736768,1577058304,1677721600,1040187392,1224736768,1610612736,0,1828716544,1224736768,687865856,1912602624,771751936,989855744,1207959552,1140850688,1241513984,1509949440,1258291200,1493172224,1493172224,1207959552,1207959552,1174405120,1224736768,738197504,1308622848,1023410176,1073741824,1493172224,754974720,1526726656,805306368,1056964608,1040187392,1207959552,1778384896,1543503872,369098752,1476395008,1291845632,1610612736,1056964608,1946157056,1056964608,956301312,1711276032,1828716544,620756992,33554432,1560281088,1509949440,1409286144,1442840576,939524096,67108864,1207959552,1241513984,0,989855744,1426063360,0,50331648,117440512,0,0,1795162112,1711276032,855638016,1090519040,1694498816,1560281088,184549376,788529152,1342177280,1845493760,704643072,654311424,1728053248,1124073472,603979776,1577058304,822083584,1291845632,922746880,1577058304,1308622848,1241513984,1509949440,1375731712,1174405120,1476395008,1442840576,1476395008,1375731712,687865856,1946157056,1090519040,956301312,1560281088,1392508928,1258291200,1006632960,1409286144,956301312,1375731712,1442840576,1157627904,1644167168,1191182336,1375731712,1291845632,1174405120,486539264,989855744,872415232,1375731712,1543503872,671088640,1040187392,805306368,1157627904,1107296256,1056964608,905969664,1325400064,1174405120,1275068416,1660944384,1509949440,1459617792,1761607680,1107296256,1459617792,1275068416,1728053248,503316480,973078528,1560281088,1291845632,1442840576,1275068416,1107296256,1258291200,1224736768,754974720,352321536,1241513984,1778384896,33554432,0,16777216,67108864,268435456,2080374784,1442840576,385875968,1593835520,989855744,1207959552,603979776,1291845632,1560281088,1560281088,620756992,1241513984,1795162112,67108864,1577058304,822083584,637534208,1392508928,788529152,1543503872,1375731712,1610612736,1207959552,1728053248,1610612736,1392508928,1644167168,1543503872,1694498816,1358954496,1191182336,1476395008,1157627904,1627389952,1073741824,1023410176,1459617792,1879048192,1241513984,1325400064,1543503872,1023410176,1577058304,1342177280,1325400064,1375731712,922746880,1056964608,1124073472,1006632960,922746880,1442840576,754974720,1073741824,1073741824,922746880,922746880,872415232,1258291200,1107296256,1409286144,1140850688,1275068416,1476395008,1291845632,1375731712,1442840576,1325400064,1677721600,1828716544,0,1560281088,1677721600,1426063360,1677721600,1023410176,1107296256,738197504,721420288,1627389952,0,1040187392,1090519040,922746880,0,0,33554432,0,167772160,637534208,1023410176,1711276032,1560281088,553648128,1090519040,1157627904,1560281088,536870912,1040187392,1912602624,1191182336,268435456,1744830464,452984832,1308622848,687865856,1107296256,1308622848,1644167168,1392508928,939524096,1426063360,1476395008,1174405120,1845493760,1358954496,1375731712,1342177280,1828716544,1543503872,637534208,1694498816,1711276032,1560281088,1375731712,1241513984,1224736768,1275068416,1610612736,973078528,1644167168,1258291200,1409286144,1174405120,754974720,1040187392,1174405120,1442840576,754974720,1493172224,1006632960,1409286144,1056964608,771751936,1174405120,503316480,1291845632,855638016,1023410176,486539264,1560281088,536870912,1795162112,1174405120,1409286144,1493172224,1526726656,721420288,637534208,1845493760,1392508928,1811939328,1426063360,1728053248,1644167168,1023410176,1107296256,956301312,1056964608,922746880,889192448,1291845632,33554432,0,117440512,50331648,100663296,922746880,1124073472,1258291200,1442840576,973078528,973078528,1476395008,285212672,318767104,1056964608,1409286144,486539264,1342177280,1476395008,905969664,1979711488,1073741824,1207959552,1476395008,1509949440,1157627904,738197504,1543503872,1325400064,1442840576,1660944384,1627389952,2030043136,1442840576,1476395008,1526726656,905969664,1744830464,1224736768,553648128,1476395008,1073741824,1275068416,1258291200,1191182336,855638016,1744830464,1207959552,1275068416,687865856,956301312,922746880,905969664,1107296256,754974720,805306368,603979776,1476395008,1493172224,469762048,1426063360,134217728,1577058304,855638016,1275068416,1174405120,1224736768,989855744,922746880,1241513984,1174405120,1711276032,1593835520,0,1912602624,1459617792,1879048192,1526726656,1560281088,1207959552,989855744,1056964608,1040187392,1241513984,889192448,989855744,1224736768,1526726656,167772160,16777216,50331648,0,889192448,1610612736,1207959552,905969664,503316480,822083584,1711276032,721420288,855638016,872415232,1610612736,788529152,838860800,1476395008,452984832,889192448,1409286144,1241513984,1560281088,1291845632,1375731712,1023410176,822083584,1191182336,603979776,1845493760,1577058304,1543503872,1778384896,1426063360,1811939328,1644167168,1627389952,520093696,1761607680,721420288,1056964608,1694498816,1644167168,1090519040,1056964608,1426063360,1392508928,1275068416,1409286144,922746880,1040187392,1442840576,1409286144,956301312,1023410176,587202560,1224736768,1677721600,889192448,754974720,1241513984,419430400,1358954496,553648128,1476395008,671088640,1627389952,838860800,771751936,1761607680,1140850688,1728053248,1191182336,50331648,1811939328,1560281088,1577058304,1459617792,1610612736,1174405120,1358954496,1593835520,973078528,1442840576,1342177280,738197504,1409286144,1056964608,117440512,0,33554432,150994944,1291845632,1644167168,1577058304,436207616,838860800,1006632960,922746880,838860800,1056964608,1291845632,1979711488,385875968,1258291200,1459617792,620756992,536870912,1207959552,402653184,1694498816,805306368,1778384896,922746880,587202560,1174405120,687865856,1442840576,1660944384,1560281088,1509949440,1593835520,1073741824,1509949440,1493172224,905969664,1593835520,1258291200,352321536,1660944384,1291845632,1308622848,671088640,1291845632,1728053248,1543503872,1124073472,905969664,822083584,1577058304,1157627904,973078528,1090519040,201326592,1677721600,520093696,0,536870912,1493172224,167772160,1811939328,704643072,1241513984,922746880,1442840576,872415232,788529152,1644167168,1073741824,1442840576,1476395008,1375731712,1610612736,1593835520,1459617792,1694498816,1627389952,1459617792,1728053248,1308622848,1375731712,1308622848,2013265920,1342177280,1308622848,352321536,67108864,83886080,0,50331648,2046820352,1610612736,889192448,687865856,1157627904,1342177280,721420288,738197504,855638016,1459617792,1291845632,805306368,1308622848,654311424,1291845632,1224736768,1694498816,16777216,1577058304,570425344,1694498816,788529152,419430400,1845493760,1241513984,1325400064,1493172224,1207959552,1879048192,1409286144,1593835520,1610612736,1761607680,1291845632,0,1392508928,251658240,1140850688,1627389952,1040187392,1006632960,1627389952,1207959552,1275068416,1442840576,855638016,1107296256,1476395008,1308622848,1157627904,1258291200,83886080,1275068416,1660944384,1509949440,369098752,1342177280,536870912,1040187392,838860800,1694498816,838860800,989855744,1174405120,536870912,1426063360,1560281088,1610612736,1459617792,939524096,1711276032,1677721600,1660944384,1073741824,1291845632,1459617792,1677721600,1811939328,1442840576,352321536,301989888,637534208,620756992,905969664,0,100663296,0,0,1879048192,1342177280,436207616,1342177280,1073741824,1140850688,570425344,922746880,1526726656,1023410176,1157627904,1056964608,1610612736,738197504,1459617792,1476395008,1124073472,721420288,1426063360,1107296256,1644167168,838860800,201326592,1644167168,1509949440,1509949440,1375731712,1694498816,1375731712,1493172224,1526726656,1560281088,1476395008,1610612736,385875968,1358954496,1862270976,1426063360,1593835520,1426063360,771751936,1660944384,1509949440,620756992,1191182336,1056964608,1577058304,1006632960,1660944384,1342177280,1023410176,771751936,1291845632,654311424,1493172224,553648128,1291845632,251658240,1207959552,654311424,1275068416,603979776,0,1560281088,587202560,1744830464,989855744,1325400064,1526726656,1073741824,1610612736,1644167168,1660944384,1358954496,1476395008,1593835520,1627389952,1577058304,1459617792,1241513984,1107296256,1358954496,1124073472,1006632960,201326592,16777216,0,117440512,0,301989888,1627389952,1644167168,1426063360,603979776,1157627904,1275068416,234881024,738197504,1342177280,1107296256,1291845632,1157627904,1241513984,1291845632,1174405120,1275068416,1090519040,989855744,1577058304,1761607680,553648128,1476395008,1795162112,1308622848,1560281088,1526726656,1325400064,1577058304,1744830464,1224736768,1795162112,1409286144,1107296256,419430400,1543503872,1308622848,1426063360,1023410176,1140850688,1090519040,1627389952,1107296256,1275068416,1493172224,1325400064,1073741824,1644167168,1308622848,0,1627389952,956301312,721420288,1493172224,553648128,1308622848,301989888,1258291200,469762048,1426063360,1073741824,0,1275068416,754974720,956301312,1560281088,1476395008,1526726656,1308622848,1543503872,1526726656,1493172224,1560281088,1560281088,1526726656,1493172224,1442840576,1811939328,352321536,620756992,1090519040,721420288,419430400,0,67108864,100663296,16777216,234881024,0,1224736768,1342177280,956301312,822083584,973078528,1325400064,788529152,1476395008,1593835520,1291845632,1006632960,905969664,1258291200,520093696,1660944384,369098752,1744830464,1358954496,939524096,1694498816,352321536,1342177280,1476395008,1358954496,1644167168,1426063360,1644167168,1358954496,1560281088,1660944384,1459617792,1493172224,1627389952,754974720,1023410176,1040187392,1560281088,1426063360,973078528,1358954496,1006632960,922746880,973078528,1392508928,1375731712,469762048,805306368,1358954496,33554432,1275068416,436207616,956301312,1140850688,637534208,1442840576,50331648,1224736768,1073741824,1174405120,1761607680,687865856,1610612736,721420288,822083584,1560281088,1241513984,1644167168,1040187392,1711276032,1442840576,1509949440,1426063360,1476395008,1509949440,1392508928,1543503872,1593835520,1493172224,1677721600,1761607680,1627389952,704643072,67108864,0,67108864,0,0,889192448,419430400,1191182336,637534208,754974720,1543503872,1056964608,1308622848,1023410176,687865856,1392508928,1660944384,956301312,1107296256,838860800,1996488704,0,1207959552,1694498816,33554432,1258291200,587202560,1409286144,1375731712,1577058304,1107296256,1392508928,1056964608,1610612736,1560281088,1291845632,1275068416,788529152,1207959552,1107296256,1728053248,1409286144,1224736768,973078528,822083584,1023410176,889192448,503316480,1375731712,721420288,1459617792,1224736768,1375731712,1056964608,16777216,1728053248,83886080,1426063360,419430400,1241513984,754974720,402653184,1509949440,1191182336,1358954496,1375731712,1006632960,1308622848,1157627904,1140850688,1442840576,1241513984,1610612736,1241513984,1207959552,1543503872,1459617792,1610612736,1392508928,1442840576,1610612736,1560281088,1375731712,1644167168,1560281088,1207959552,1107296256,184549376,33554432,0,83886080,16777216,16777216,1258291200,1090519040,754974720,973078528,1358954496,1157627904,1375731712,721420288,1560281088,738197504,1191182336,1157627904,1023410176,1157627904,1090519040,1862270976,1140850688,754974720,1811939328,251658240,1224736768,1023410176,1006632960,1610612736,1610612736,1476395008,1459617792,1124073472,1526726656,1476395008,1459617792,1778384896,0,1191182336,1526726656,1124073472,1358954496,1778384896,1426063360,1342177280,1056964608,436207616,318767104,788529152,1308622848,318767104,889192448,1962934272,335544320,922746880,1426063360,0,1476395008,268435456,1325400064,671088640,754974720,1593835520,1006632960,1409286144,1744830464,1006632960,1090519040,1241513984,1090519040,1459617792,973078528,1778384896,1275068416,1577058304,1610612736,1157627904,1459617792,1241513984,1325400064,1677721600,1644167168,1560281088,1493172224,1157627904,1275068416,201326592,0,0,184549376,83886080,83886080,0,201326592,620756992,973078528,1191182336,1610612736,1610612736,1023410176,1140850688,1140850688,989855744,1526726656,1207959552,1258291200,805306368,855638016,1191182336,1560281088,1644167168,1761607680,570425344,822083584,1543503872,973078528,1509949440,1426063360,1258291200,1107296256,1493172224,1174405120,1577058304,1677721600,1308622848,1593835520,1526726656,1660944384,1409286144,1660944384,1174405120,889192448,1459617792,1174405120,889192448,419430400,1107296256,654311424,989855744,1124073472,352321536,100663296,1090519040,603979776,872415232,1392508928,150994944,1543503872,520093696,939524096,1040187392,1090519040,905969664,1593835520,1442840576,654311424,1509949440,1342177280,1644167168,1493172224,1409286144,1509949440,1040187392,1476395008,1040187392,973078528,1493172224,1644167168,1308622848,1509949440,922746880,1409286144,1291845632,1694498816,671088640,16777216,100663296,0,33554432,0,150994944,0,1073741824,1124073472,1207959552,1912602624,1342177280,1107296256,1392508928,805306368,989855744,1526726656,1140850688,1358954496,838860800,1157627904,1660944384,1140850688,1291845632,1459617792,1275068416,1442840576,1795162112,268435456,1040187392,1543503872,1593835520,1459617792,1560281088,1593835520,1258291200,1761607680,1509949440,1644167168,1493172224,1493172224,1040187392,1426063360,1224736768,1191182336,1090519040,1392508928,1459617792,1056964608,1409286144,973078528,822083584,1124073472,385875968,1040187392,1493172224,117440512,1241513984,872415232,738197504,1593835520,536870912,1325400064,620756992,1325400064,1191182336,1107296256,1627389952,201326592,1442840576,1191182336,1358954496,1325400064,1543503872,1593835520,1023410176,1442840576,1358954496,1610612736,1526726656,1090519040,402653184,1593835520,1459617792,1358954496,1644167168,1895825408,754974720,100663296,0,67108864,0,0,67108864,0,520093696,1577058304,1694498816,1694498816,1275068416,1677721600,1442840576,1342177280,1191182336,1124073472,687865856,1493172224,721420288,369098752,973078528,1124073472,1006632960,1795162112,1459617792,1191182336,1627389952,1577058304,1342177280,1845493760,1526726656,1526726656,1358954496,1107296256,1593835520,1610612736,1442840576,1023410176,1677721600,838860800,1174405120,1526726656,486539264,1325400064,1140850688,1040187392,1811939328,922746880,1191182336,1073741824,1275068416,1459617792,1023410176,822083584,620756992,570425344,1442840576,33554432,1476395008,738197504,838860800,1241513984,570425344,1291845632,1241513984,1124073472,1207959552,587202560,1207959552,738197504,1157627904,1308622848,1090519040,1644167168,1442840576,1577058304,1728053248,956301312,1426063360,2030043136,1040187392,1509949440,1677721600,1056964608,1543503872,1493172224,1191182336,0,0,0,50331648,50331648,33554432,285212672,520093696,973078528,1275068416,1174405120,1325400064,1358954496,1627389952,805306368,922746880,1040187392,939524096,1778384896,956301312,1040187392,1090519040,1392508928,1191182336,1476395008,1426063360,1040187392,419430400,1241513984,1694498816,1610612736,1644167168,1409286144,1476395008,1191182336,1543503872,1476395008,1409286144,0,1627389952,1392508928,587202560,1124073472,1275068416,889192448,704643072,1375731712,771751936,973078528,1694498816,805306368,1476395008,1174405120,1308622848,788529152,251658240,1627389952,1174405120,754974720,905969664,503316480,855638016,1275068416,721420288,1275068416,1040187392,1207959552,1543503872,805306368,1476395008,603979776,1442840576,1358954496,1526726656,1627389952,1258291200,1023410176,1509949440,1509949440,620756992,1375731712,1224736768,1241513984,1493172224,788529152,1174405120,1442840576,922746880,0,117440512,184549376,0,0,16777216,150994944,1174405120,335544320,1275068416,922746880,1828716544,1627389952,1291845632,1744830464,1157627904,1107296256,805306368,1627389952,1191182336,939524096,1442840576,1157627904,1375731712,1275068416,1409286144,1308622848,1258291200,1409286144,889192448,520093696,956301312,1627389952,1543503872,1275068416,1828716544,1493172224,1560281088,1593835520,1191182336,1392508928,1124073472,402653184,1157627904,1191182336,1409286144,956301312,603979776,1291845632,402653184,587202560,1140850688,1207959552,771751936,218103808,1493172224,1174405120,33554432,1174405120,721420288,1174405120,671088640,1006632960,771751936,1493172224,1258291200,1207959552,1476395008,436207616,721420288,1660944384,1426063360,1409286144,1157627904,989855744,1862270976,1426063360,1744830464,1392508928,1191182336,1275068416,1761607680,1358954496,1593835520,1275068416,1392508928,2046820352,1207959552,0,0,0,134217728,67108864,0,268435456,771751936,1073741824,1174405120,1023410176,1291845632,1342177280,1174405120,1476395008,1459617792,1426063360,838860800,1258291200,1275068416,1325400064,1493172224,1040187392,1560281088,1124073472,1291845632,1258291200,1694498816,1392508928,1140850688,0,1442840576,1593835520,1509949440,1174405120,1627389952,1627389952,1493172224,1342177280,1728053248,1358954496,1090519040,1140850688,1040187392,1207959552,1207959552,553648128,922746880,1291845632,1006632960,939524096,1107296256,1442840576,620756992,637534208,1124073472,0,402653184,1325400064,754974720,1224736768,956301312,738197504,805306368,1241513984,1157627904,922746880,1090519040,1006632960,654311424,1593835520,855638016,1493172224,1308622848,939524096,1459617792,1476395008,1342177280,1577058304,1358954496,1459617792,1593835520,1157627904,1577058304,1426063360,922746880,1744830464,251658240,0,184549376,0,0,50331648,0,150994944,872415232,1124073472,1560281088,1627389952,1392508928,1392508928,1275068416,1056964608,1040187392,1073741824,1593835520,50331648,352321536,1409286144,1107296256,1291845632,1426063360,1040187392,1610612736,1476395008,1426063360,1610612736,1493172224,1442840576,1308622848,1392508928,1895825408,1577058304,1811939328,1543503872,1442840576,1660944384,1191182336,1107296256,218103808,771751936,1040187392,1040187392,1056964608,167772160,1241513984,1610612736,1258291200,1241513984,1459617792,1358954496,1476395008,1325400064,771751936,0,1442840576,234881024,0,1526726656,1778384896,654311424,1241513984,1090519040,1073741824,1224736768,1644167168,1224736768,771751936,1593835520,939524096,1157627904,1493172224,889192448,889192448,1577058304,1191182336,1593835520,1476395008,822083584,1811939328,1224736768,1241513984,1711276032,1006632960,1543503872,0,67108864,0,0,16777216,33554432,0,184549376,419430400,553648128,771751936,1409286144,1174405120,1325400064,1174405120,1275068416,1023410176,956301312,1358954496,654311424,67108864,872415232,1375731712,1677721600,1241513984,1224736768,1593835520,1358954496,1644167168,1711276032,1778384896,1577058304,1610612736,1358954496,1426063360,922746880,134217728,1895825408,1778384896,1308622848,1577058304,1375731712,1509949440,520093696,1258291200,1174405120,1811939328,1308622848,1056964608,973078528,637534208,956301312,1073741824,1157627904,536870912,452984832,754974720,1845493760,1409286144,50331648,218103808,1728053248,1224736768,50331648,1241513984,956301312,973078528,1291845632,1056964608,1526726656,16777216,1728053248,1476395008,1375731712,1761607680,1140850688,1392508928,1375731712,1291845632,1493172224,1509949440,905969664,687865856,1711276032,1241513984,1744830464,1107296256,0,67108864,117440512,33554432,0,218103808,0,33554432,16777216,83886080,754974720,754974720,1207959552,1543503872,1241513984,1140850688,1275068416,1157627904,1191182336,1442840576,771751936,838860800,1090519040,1291845632,1426063360,1577058304,1258291200,1375731712,1560281088,1660944384,1358954496,1426063360,1593835520,1509949440,1711276032,1526726656,1593835520,369098752,1610612736,1375731712,1442840576,1560281088,989855744,1073741824,1426063360,1224736768,1056964608,905969664,1509949440,1459617792,1090519040,1006632960,889192448,956301312,436207616,788529152,1140850688,1409286144,1140850688,419430400,637534208,1728053248,1442840576,285212672,251658240,1493172224,973078528,939524096,1174405120,0,1056964608,67108864,436207616,1593835520,570425344,1224736768,1593835520,1073741824,1224736768,1291845632,989855744,956301312,1325400064,1023410176,1577058304,1040187392,1476395008,1946157056,0,67108864,0,16777216,83886080,0,16777216,50331648,0,50331648,503316480,1627389952,1073741824,1828716544,1174405120,905969664,1426063360,855638016,1627389952,1744830464,704643072,352321536,1828716544,989855744,1056964608,1073741824,1224736768,1644167168,1325400064,1375731712,1543503872,1157627904,1711276032,1392508928,1795162112,1493172224,1493172224,1677721600,1694498816,1660944384,1526726656,1174405120,939524096,889192448,1040187392,1426063360,1526726656,973078528,1241513984,1056964608,1426063360,1073741824,1459617792,1073741824,1560281088,1375731712,1694498816,1107296256,721420288,1023410176,721420288,1157627904,1090519040,1308622848,1056964608,939524096,1241513984,1660944384,1644167168,16777216,1811939328,536870912,469762048,1728053248,536870912,1056964608,1409286144,385875968,889192448,1342177280,1006632960,1526726656,1610612736,1526726656,1325400064,1342177280,1593835520,1912602624,16777216,0,50331648,0,33554432,0,50331648,83886080,33554432,16777216,0,251658240,956301312,503316480,1375731712,1073741824,805306368,922746880,973078528,1577058304,536870912,352321536,771751936,1811939328,1073741824,520093696,989855744,1442840576,1526726656,1325400064,1660944384,1493172224,1308622848,1258291200,1358954496,1660944384,1476395008,1342177280,1174405120,1610612736,1728053248,922746880,1426063360,1191182336,1426063360,872415232,687865856,989855744,855638016,1291845632,822083584,1593835520,1275068416,1191182336,905969664,1509949440,973078528,654311424,1124073472,1275068416,922746880,620756992,1040187392,1660944384,1291845632,1526726656,1610612736,1191182336,1291845632,939524096,1426063360,1845493760,838860800,1459617792,1543503872,1040187392,1879048192,1124073472,721420288,1174405120,754974720,150994944,1023410176,1392508928,973078528,1157627904,234881024,167772160,50331648,150994944,0,0,0,67108864,0,0,117440512,50331648,369098752,771751936,369098752,1207959552,1275068416,1224736768,1241513984,1375731712,989855744,939524096,469762048,570425344,335544320,1040187392,1560281088,1073741824,587202560,1107296256,1375731712,1593835520,1107296256,1795162112,1493172224,1174405120,1459617792,1543503872,1224736768,939524096,1593835520,1459617792,1476395008,1660944384,1392508928,939524096,1308622848,1090519040,1191182336,956301312,939524096,1593835520,1308622848,1157627904,1560281088,1207959552,335544320,285212672,956301312,1358954496,1577058304,402653184,1107296256,1577058304,1073741824,822083584,1509949440,738197504,1124073472,1006632960,1325400064,1476395008,1157627904,1124073472,1761607680,1644167168,1577058304,1157627904,1342177280,1660944384,989855744,1761607680,1593835520,889192448,1124073472,654311424,771751936,1644167168,1174405120,134217728,83886080,0,50331648,83886080,0,50331648,117440512,67108864,16777216,0,0,167772160,1308622848,1342177280,1090519040,1090519040,1241513984,1224736768,1157627904,872415232,486539264,570425344,1023410176,1006632960,889192448,1392508928,1358954496,1124073472,1409286144,1660944384,1677721600,1342177280,1426063360,1845493760,956301312,1627389952,1879048192,1191182336,1509949440,1593835520,1073741824,1677721600,1442840576,1358954496,939524096,956301312,1207959552,1157627904,1275068416,1241513984,1157627904,1157627904,905969664,1660944384,654311424,1090519040,1040187392,1308622848,570425344,83886080,1275068416,1426063360,620756992,654311424,1224736768,1560281088,1308622848,939524096,1459617792,1426063360,1593835520,1191182336,1778384896,1442840576,1073741824,1426063360,1325400064,1140850688,1476395008,1358954496,1610612736,1409286144,1644167168,1711276032,788529152,671088640,1409286144,0,0,134217728,0,0,234881024,0,0,0,134217728,0,167772160,67108864,251658240,1912602624,788529152,1275068416,1040187392,1476395008,1392508928,1996488704,603979776,301989888,1174405120,1124073472,603979776,754974720,1207959552,1241513984,1375731712,1241513984,1358954496,1191182336,1325400064,1124073472,1778384896,1409286144,1409286144,1577058304,1577058304,1308622848,1224736768,1090519040,654311424,939524096,1056964608,738197504,419430400,1207959552,1157627904,1191182336,671088640,1442840576,1224736768,1107296256,1744830464,922746880,1744830464,1593835520,385875968,704643072,1426063360,1392508928,1426063360,1493172224,1342177280,1291845632,1207959552,1577058304,1426063360,788529152,1577058304,1677721600,1157627904,1258291200,1560281088,1358954496,1140850688,1308622848,1543503872,1543503872,1392508928,1610612736,1577058304,1392508928,1375731712,922746880,771751936,83886080,0,67108864,117440512,0,0,16777216,0,134217728,0,0,0,402653184,318767104,1996488704,1560281088,1526726656,1291845632,251658240,1124073472,1543503872,1040187392,117440512,369098752,1795162112,1308622848,822083584,1509949440,1241513984,1442840576,1342177280,1593835520,1694498816,1174405120,805306368,1543503872,1895825408,1509949440,1560281088,1392508928,1677721600,1828716544,1459617792,1275068416,1107296256,1040187392,1291845632,889192448,1342177280,1442840576,721420288,671088640,1275068416,872415232,1392508928,1308622848,905969664,1358954496,1023410176,1526726656,1342177280,1526726656,1073741824,1610612736,1023410176,838860800,889192448,754974720,1040187392,1509949440,1526726656,1157627904,1325400064,1593835520,1241513984,1073741824,1392508928,1660944384,1107296256,1677721600,1426063360,1476395008,1224736768,1526726656,1392508928,1409286144,1828716544,1224736768,117440512,100663296,150994944,0,117440512,16777216,0,100663296,0,0,100663296,184549376,0,150994944,1124073472,570425344,1392508928,1476395008,989855744,536870912,1241513984,1728053248,1761607680,822083584,1023410176,1895825408,1392508928,1476395008,1325400064,1358954496,1275068416,1040187392,1526726656,1728053248,1325400064,1056964608,1275068416,1660944384,1358954496,1493172224,1577058304,1342177280,1224736768,1056964608,1426063360,1493172224,1325400064,1476395008,1073741824,905969664,1459617792,1325400064,1291845632,1157627904,637534208,1325400064,1224736768,1610612736,1526726656,1241513984,1291845632,1191182336,1526726656,1409286144,889192448,1006632960,1174405120,603979776,1560281088,838860800,822083584,1375731712,1560281088,1308622848,1040187392,1358954496,1090519040,1224736768,1459617792,838860800,1174405120,1157627904,1056964608,1593835520,1593835520,1375731712,1577058304,822083584,0,83886080,0,0,83886080,0,167772160,16777216,117440512,0,67108864,0,83886080,318767104,1241513984,956301312,1140850688,1073741824,1174405120,788529152,1140850688,1828716544,1543503872,1694498816,1375731712,1627389952,1660944384,1711276032,738197504,1459617792,1526726656,1543503872,1409286144,738197504,1375731712,1140850688,1526726656,1627389952,1493172224,1694498816,1711276032,1140850688,1090519040,1191182336,1040187392,1157627904,1140850688,939524096,1107296256,1593835520,1493172224,973078528,805306368,1828716544,1610612736,1107296256,1493172224,1392508928,1543503872,1426063360,1157627904,1342177280,1593835520,1140850688,1593835520,889192448,1258291200,1358954496,1023410176,973078528,838860800,1107296256,989855744,1543503872,1442840576,1090519040,1040187392,1056964608,1660944384,1291845632,1241513984,1493172224,1694498816,1543503872,1526726656,1040187392,2097152000,1090519040,0,33554432,83886080,0,0,33554432,0,0,0,0,50331648,100663296,0,100663296,33554432,1140850688,436207616,1325400064,1157627904,1023410176,1543503872,721420288,1157627904,1627389952,1342177280,1627389952,1526726656,1509949440,1459617792,1023410176,1426063360,1627389952,1392508928,872415232,1191182336,1560281088,1728053248,1509949440,1442840576,1543503872,1644167168,1593835520,1744830464,1207959552,1342177280,1275068416,956301312,1325400064,1224736768,1073741824,1342177280,1023410176,1459617792,905969664,1291845632,1124073472,1509949440,1107296256,1224736768,1090519040,1325400064,1291845632,1275068416,1308622848,1442840576,1023410176,1291845632,1258291200,1543503872,1627389952,922746880,1107296256,1258291200,1140850688,1056964608,1325400064,1509949440,654311424,704643072,1375731712,989855744,1509949440,1174405120,1375731712,1291845632,603979776,402653184,67108864,67108864,50331648,16777216,16777216,0,16777216,16777216,0,0,67108864,33554432,0,184549376,335544320,150994944,301989888,1224736768,1577058304,1459617792,1744830464,1258291200,805306368,1140850688,1476395008,1761607680,1023410176,1509949440,889192448,1224736768,1577058304,1660944384,1392508928,1644167168,1493172224,1224736768,939524096,1392508928,1526726656,1107296256,1358954496,1526726656,1174405120,1241513984,1275068416,1476395008,1526726656,1711276032,1644167168,1174405120,1224736768,1157627904,1174405120,1090519040,1526726656,1241513984,1275068416,1040187392,1241513984,1107296256,1459617792,1694498816,1409286144,1426063360,788529152,922746880,805306368,889192448,1325400064,1493172224,335544320,704643072,1560281088,771751936,1207959552,1493172224,872415232,822083584,1291845632,218103808,805306368,1241513984,1124073472,1509949440,1342177280,1811939328,1056964608,0,50331648,50331648,33554432,16777216,0,0,16777216,16777216,0,67108864,33554432,0,218103808,0,1191182336,419430400,234881024,922746880,1711276032,1728053248,1493172224,1610612736,1392508928,1241513984,1207959552,989855744,1426063360,1660944384,1644167168,922746880,1409286144,1677721600,1291845632,1056964608,1375731712,1828716544,1325400064,1258291200,1677721600,1711276032,1728053248,1862270976,1342177280,1207959552,1409286144,1375731712,1308622848,1577058304,1442840576,1275068416,1677721600,1644167168,1241513984,1107296256,1493172224,1023410176,1392508928,1140850688,1191182336,1409286144,1577058304,1124073472,1224736768,1174405120,1342177280,855638016,1358954496,1090519040,1207959552,922746880,1325400064,1392508928,1073741824,872415232,654311424,838860800,1040187392,1124073472,1107296256,1325400064,1056964608,1409286144,1610612736,1426063360,1140850688,1258291200,2063597568,352321536,33554432,33554432,16777216,16777216,0,0,0,16777216,83886080,0,0,16777216,0,50331648,520093696,419430400,989855744,1291845632,1207959552,1392508928,1543503872,1660944384,402653184,1258291200,1107296256,1258291200,1426063360,1107296256,1509949440,1509949440,989855744,1426063360,1778384896,1090519040,973078528,1325400064,1174405120,1275068416,1711276032,1644167168,1476395008,1375731712,1577058304,1795162112,1593835520,1509949440,1543503872,1090519040,922746880,1073741824,1493172224,822083584,1342177280,1392508928,1375731712,1409286144,1241513984,922746880,1325400064,1308622848,1224736768,1358954496,1040187392,1124073472,1593835520,1258291200,1207959552,1040187392,1207959552,1224736768,1090519040,939524096,1241513984,1174405120,922746880,1073741824,1459617792,889192448,1342177280,1040187392,1442840576,1040187392,1291845632,1275068416,1879048192,0,587202560,1157627904,16777216,16777216,0,0,0,0,0,0,83886080,0,0,0,0,50331648,0,285212672,654311424,1258291200,1006632960,1358954496,1073741824,1526726656,973078528,603979776,1493172224,1375731712,1157627904,1694498816,788529152,1090519040,1375731712,1493172224,1426063360,1459617792,1392508928,1342177280,1308622848,1426063360,1711276032,1644167168,1493172224,1728053248,1392508928,1224736768,1493172224,1442840576,1409286144,1543503872,1241513984,1291845632,1577058304,1241513984,671088640,1442840576,1543503872,1426063360,251658240,989855744,1711276032,905969664,436207616,1090519040,1140850688,1056964608,855638016,1308622848,385875968,805306368,1493172224,1375731712,1543503872,1124073472,1056964608,1275068416,1124073472,1207959552,1174405120,1409286144,822083584,1342177280,1325400064,1241513984,973078528,1476395008,1426063360,1509949440,0,0,0,0,0,0,0,0,0,0,0,83886080,16777216,0,201326592,0,67108864,134217728,67108864,587202560,754974720,1577058304,1459617792,1124073472,1090519040,1207959552,838860800,1476395008,1342177280,1560281088,1342177280,956301312,1325400064,1493172224,1543503872,1694498816,1392508928,1107296256,1241513984,1140850688,1358954496,1677721600,1778384896,1593835520,1644167168,1795162112,1426063360,1426063360,1526726656,1140850688,1124073472,1610612736,1593835520,771751936,1191182336,889192448,1090519040,956301312,1409286144,1140850688,1207959552,1409286144,1526726656,1040187392,1207959552,1258291200,1157627904,1107296256,1426063360,1426063360,1426063360,1308622848,1342177280,1140850688,1207959552,1509949440,1325400064,1191182336,1174405120,973078528,1224736768,1358954496,1375731712,1308622848,1493172224,1342177280,1157627904,2113929216,872415232,268435456,0,16777216,16777216,16777216,16777216,0,0,0,33554432,0,100663296,0,0,201326592,0,0,67108864,738197504,1006632960,1308622848,1476395008,1191182336,603979776,1056964608,1275068416,1023410176,771751936,1409286144,1493172224,1140850688,1040187392,1426063360,1375731712,1543503872,1191182336,1056964608,1744830464,1811939328,1660944384,1526726656,1644167168,1476395008,1342177280,1744830464,1577058304,1610612736,1627389952,1593835520,1342177280,1392508928,1107296256,905969664,1342177280,1375731712,1426063360,1258291200,1442840576,1358954496,1627389952,1342177280,1476395008,1593835520,1275068416,1308622848,1476395008,1577058304,956301312,1191182336,1023410176,1174405120,1124073472,1174405120,1157627904,1375731712,1342177280,1476395008,1275068416,1358954496,1325400064,1426063360,1442840576,1325400064,1426063360,1644167168,0,301989888,117440512,0,16777216,16777216,33554432,16777216,16777216,0,0,0,50331648,0,33554432,0,251658240,0,318767104,16777216,16777216,687865856,654311424,1140850688,1409286144,1459617792,553648128,738197504,1660944384,1610612736,1241513984,1174405120,1073741824,1157627904,1543503872,1459617792,1426063360,1627389952,1426063360,1241513984,1509949440,1191182336,1291845632,1644167168,1560281088,1493172224,1040187392,1476395008,1627389952,1543503872,1325400064,1728053248,1644167168,1375731712,1811939328,1459617792,1191182336,1107296256,1224736768,1426063360,1140850688,1677721600,1426063360,1560281088,1342177280,1442840576,1325400064,1241513984,1174405120,1241513984,989855744,1073741824,1509949440,1526726656,1593835520,1241513984,1224736768,1224736768,905969664,1073741824,1258291200,922746880,1392508928,1023410176,1308622848,1258291200,973078528,1392508928,2113929216,301989888,33554432,150994944,33554432,33554432,33554432,33554432,16777216,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,16777216,50331648,335544320,872415232,1543503872,603979776,1375731712,1040187392,637534208,1308622848,1275068416,1627389952,1795162112,1409286144,939524096,1325400064,1610612736,1627389952,1275068416,1090519040,1442840576,1593835520,1258291200,1241513984,1526726656,1610612736,1644167168,1526726656,1644167168,1694498816,1342177280,1610612736,1426063360,1308622848,1526726656,1560281088,1677721600,1358954496,1191182336,1258291200,1593835520,1241513984,1342177280,1459617792,989855744,1342177280,1258291200,1526726656,1476395008,1308622848,1174405120,1526726656,1140850688,1207959552,1207959552,1342177280,1275068416,1476395008,1409286144,1308622848,1392508928,1308622848,1191182336,1325400064,1258291200,1258291200,1392508928,1375731712,1056964608,1023410176,2130706432,536870912,33554432,33554432,33554432,33554432,16777216,0,0,0,0,0,0,16777216,16777216,33554432,33554432,33554432,33554432,0,0,150994944,1124073472,956301312,838860800,553648128,905969664,1191182336,687865856,1325400064,1073741824,1560281088,1291845632,1543503872,1560281088,1577058304,1493172224,1241513984,1409286144,1476395008,1593835520,1342177280,1342177280,1275068416,1577058304,1291845632,1560281088,1610612736,1728053248,1543503872,1426063360,1291845632,1342177280,1325400064,1409286144,1023410176,1258291200,1862270976,1593835520,1342177280,1778384896,1442840576,1493172224,822083584,1426063360,1191182336,1157627904,1342177280,1459617792,1325400064,1224736768,1275068416,1241513984,1124073472,1023410176,1174405120,1308622848,1308622848,1258291200,1291845632,1275068416,872415232,1258291200,1191182336,1073741824,1426063360,1275068416,0,83886080,33554432,234881024,16777216,16777216,33554432,16777216,0,0,0,0,0,0,16777216,16777216,33554432,50331648,50331648,50331648,50331648,33554432,100663296,1107296256,469762048,335544320,0,83886080,855638016,1258291200,1157627904,1409286144,989855744,956301312,1241513984,1476395008,1526726656,1677721600,1325400064,1409286144,1660944384,721420288,1191182336,2046820352,1761607680,1124073472,1577058304,1577058304,1610612736,1811939328,1560281088,1778384896,1560281088,1174405120,1912602624,1577058304,1006632960,1241513984,1258291200,1358954496,1224736768,956301312,973078528,1207959552,1140850688,1107296256,1124073472,1140850688,754974720,1224736768,956301312,1207959552,1375731712,1342177280,1073741824,973078528,1107296256,939524096,1308622848,1241513984,1207959552,1258291200,973078528,1107296256,1476395008,1241513984,1409286144,1509949440,1677721600,234881024,0,67108864,0,0,16777216,0,0,0,0,0,0,0,0,16777216,16777216,33554432,33554432,33554432,50331648,0,0,1241513984,1191182336,1124073472,570425344,251658240,939524096,1459617792,1241513984,1644167168,1577058304,1241513984,1577058304,1426063360,1627389952,1325400064,1073741824,1560281088,1442840576,1358954496,1342177280,1325400064,1560281088,1728053248,1644167168,1224736768,1509949440,1459617792,1493172224,1526726656,1627389952,1358954496,1325400064,1241513984,1358954496,1426063360,1660944384,1610612736,1560281088,1442840576,1258291200,1426063360,1325400064,1392508928,1191182336,1124073472,1275068416,1459617792,1207959552,1140850688,1342177280,1442840576,1543503872,1593835520,1493172224,1291845632,1258291200,1375731712,1375731712,1023410176,1392508928,939524096,905969664,1241513984,570425344,83886080,1493172224,0,117440512,33554432,0,0,0,0,0,0,0,16777216,16777216,0,0,0,0,0,0,0,0,201326592,33554432,0,771751936,872415232,939524096,637534208,1325400064,1459617792,1291845632,1426063360,1191182336,1224736768,1090519040,1291845632,1509949440,1124073472,1543503872,1056964608,1275068416,1140850688,1275068416,1577058304,1426063360,1207959552,1493172224,1509949440,1191182336,1627389952,1459617792,1543503872,1644167168,1627389952,1275068416,989855744,1124073472,1224736768,1593835520,1258291200,1207959552,1342177280,1308622848,1358954496,1409286144,1342177280,1291845632,1543503872,1308622848,1157627904,1426063360,1157627904,1426063360,1409286144,1459617792,1275068416,1224736768,922746880,1476395008,1207959552,1342177280,1476395008,805306368,1124073472,1442840576,1459617792,1577058304,503316480,0,100663296,0,117440512,0,0,0,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,67108864,0,0,0,117440512,0,553648128,1308622848,1375731712,1342177280,1325400064,1308622848,1375731712,1107296256,1107296256,872415232,1107296256,503316480,922746880,1929379840,1526726656,1107296256,1627389952,1610612736,1593835520,1476395008,1040187392,1593835520,1811939328,1325400064,1493172224,1811939328,1593835520,1493172224,1795162112,1660944384,1358954496,1442840576,1593835520,1426063360,1191182336,1275068416,922746880,1493172224,1040187392,1174405120,838860800,1392508928,1375731712,1006632960,1258291200,922746880,1191182336,1325400064,1426063360,1241513984,1090519040,1124073472,805306368,1107296256,754974720,973078528,1207959552,1342177280,838860800,1107296256,721420288,2046820352,0,83886080,150994944,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,201326592,0,33554432,33554432,251658240,1325400064,1761607680,1325400064,1409286144,536870912,620756992,889192448,956301312,1375731712,1275068416,1291845632,1644167168,1711276032,805306368,1442840576,1040187392,1828716544,1493172224,1560281088,1342177280,1426063360,1325400064,1526726656,1392508928,1677721600,1526726656,1224736768,1627389952,1577058304,1392508928,1526726656,1241513984,1342177280,1291845632,1493172224,1308622848,1325400064,1392508928,1627389952,1342177280,1409286144,1509949440,1442840576,1426063360,1358954496,1526726656,1392508928,1358954496,1325400064,1275068416,1191182336,1660944384,1124073472,1040187392,1342177280,922746880,1040187392,1056964608,67108864,1543503872,150994944,0,0,100663296,16777216,16777216,33554432,16777216,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,50331648,0,218103808,872415232,939524096,1610612736,1442840576,1476395008,1526726656,1224736768,738197504,939524096,805306368,1526726656,1526726656,1627389952,1577058304,1426063360,1224736768,1275068416,1409286144,1325400064,1476395008,1409286144,1509949440,1526726656,1644167168,1543503872,1577058304,1493172224,1409286144,1694498816,1929379840,1358954496,1577058304,1090519040,872415232,1258291200,1476395008,1073741824,1241513984,1644167168,1476395008,956301312,1509949440,939524096,1140850688,738197504,1107296256,1073741824,1476395008,1677721600,1442840576,1308622848,1258291200,1493172224,1207959552,1509949440,1241513984,1258291200,1140850688,117440512,0,117440512,50331648,0,0,33554432,33554432,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,33554432,33554432,872415232,1728053248,1593835520,1241513984,1593835520,754974720,905969664,956301312,1409286144,1107296256,1157627904,1426063360,1207959552,1442840576,1140850688,1577058304,1409286144,1090519040,1543503872,1124073472,1275068416,1375731712,1325400064,1392508928,1459617792,1493172224,1644167168,1644167168,1509949440,1459617792,1476395008,1711276032,1711276032,1828716544,1509949440,1124073472,1409286144,1207959552,1560281088,1493172224,1476395008,1660944384,1124073472,1442840576,1560281088,1509949440,1224736768,1174405120,1107296256,889192448,1442840576,1107296256,939524096,889192448,889192448,1308622848,771751936,1459617792,1828716544,134217728,50331648,0,33554432,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,50331648,50331648,33554432,16777216,352321536,1056964608,939524096,637534208,469762048,16777216,671088640,1879048192,973078528,989855744,1711276032,1224736768,1207959552,1258291200,1207959552,1342177280,1711276032,50331648,1442840576,956301312,1040187392,1140850688,1207959552,1476395008,1560281088,1207959552,1409286144,1660944384,1509949440,1795162112,905969664,989855744,1174405120,1392508928,1023410176,1275068416,1006632960,1040187392,889192448,1409286144,1090519040,1174405120,1124073472,788529152,889192448,1308622848,1325400064,1493172224,1459617792,1375731712,1124073472,1291845632,1493172224,1191182336,1207959552,1610612736,1258291200,1694498816,1073741824,33554432,0,67108864,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,50331648,33554432,33554432,184549376,0,0,1207959552,570425344,1040187392,905969664,301989888,1107296256,335544320,469762048,1174405120,872415232,754974720,1056964608,1493172224,1342177280,1207959552,1107296256,1358954496,1073741824,1275068416,1426063360,1409286144,1258291200,1493172224,1761607680,1056964608,1543503872,1493172224,1207959552,1711276032,1275068416,1308622848,1207959552,1207959552,1006632960,1476395008,1107296256,1191182336,1291845632,956301312,1107296256,989855744,939524096,1191182336,1207959552,1241513984,1308622848,1577058304,1694498816,1291845632,1224736768,855638016,1392508928,1224736768,805306368,117440512,486539264,50331648,67108864,0,100663296,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,16777216,0,251658240,805306368,352321536,721420288,1342177280,1224736768,520093696,973078528,301989888,838860800,754974720,1409286144,989855744,1174405120,1375731712,1577058304,1476395008,1845493760,1207959552,1090519040,1275068416,1342177280,1107296256,1124073472,1275068416,1375731712,1728053248,1627389952,1023410176,1677721600,1526726656,1509949440,1694498816,1543503872,1660944384,973078528,1459617792,1073741824,1275068416,1073741824,1426063360,1560281088,1610612736,1409286144,1560281088,973078528,973078528,1560281088,704643072,1157627904,989855744,251658240,570425344,218103808,184549376,0,16777216,83886080,0,16777216,150994944,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,16777216,67108864,184549376,1560281088,905969664,771751936,1509949440,973078528,1375731712,905969664,536870912,1157627904,520093696,1459617792,939524096,1593835520,1107296256,704643072,1107296256,973078528,1191182336,1694498816,1677721600,1023410176,956301312,973078528,1207959552,1627389952,1493172224,1157627904,1291845632,1543503872,1476395008,1358954496,1275068416,1275068416,1241513984,1207959552,1191182336,1107296256,956301312,922746880,1275068416,1258291200,1325400064,1174405120,1593835520,1426063360,1291845632,1627389952,905969664,1258291200,1107296256,754974720,318767104,771751936,436207616,436207616,0,0,134217728,0,50331648,0,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,16777216,0,33554432,67108864,469762048,352321536,1392508928,855638016,218103808,889192448,1140850688,1677721600,1275068416,1006632960,1224736768,1040187392,1191182336,822083584,1543503872,1526726656,1291845632,1124073472,1258291200,1325400064,805306368,1056964608,1459617792,1056964608,1140850688,1459617792,1207959552,1191182336,1577058304,1761607680,1476395008,1241513984,1140850688,1174405120,1392508928,1325400064,1325400064,1258291200,838860800,1174405120,973078528,754974720,1107296256,1275068416,1107296256,1040187392,1073741824,1258291200,1392508928,1325400064,905969664,939524096,1157627904,1543503872,1140850688,134217728,83886080,0,0,0,134217728,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,50331648,150994944,0,33554432,234881024,520093696,16777216,301989888,469762048,939524096,369098752,721420288,1040187392,1392508928,654311424,570425344,1174405120,1493172224,1342177280,1660944384,1157627904,1358954496,1677721600,1426063360,687865856,1493172224,1560281088,1224736768,1090519040,1090519040,1577058304,1610612736,1509949440,1560281088,1728053248,1728053248,1459617792,1241513984,956301312,1392508928,1056964608,1442840576,1493172224,1224736768,1426063360,1140850688,452984832,620756992,687865856,721420288,167772160,0,301989888,16777216,301989888,0,0,0,0,134217728,0,100663296,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,33554432,184549376,0,50331648,33554432,33554432,587202560,1426063360,1124073472,352321536,872415232,603979776,1157627904,1593835520,1392508928,1543503872,1392508928,1426063360,1442840576,1375731712,1442840576,1023410176,1275068416,721420288,1358954496,520093696,1107296256,1342177280,805306368,704643072,1493172224,1124073472,1493172224,1124073472,1526726656,1241513984,1509949440,1107296256,671088640,1040187392,1560281088,1023410176,1090519040,1342177280,1409286144,1979711488,1476395008,1610612736,1610612736,1291845632,1107296256,503316480,167772160,134217728,50331648,50331648,83886080,0,150994944,0,83886080,0,0,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,33554432,16777216,16777216,33554432,33554432,50331648,67108864,67108864,67108864,369098752,16777216,1409286144,335544320,570425344,603979776,956301312,956301312,1308622848,1493172224,1509949440,1258291200,1224736768,1308622848,771751936,754974720,1124073472,721420288,1358954496,973078528,1258291200,1224736768,1660944384,1509949440,1711276032,1426063360,1577058304,1358954496,1258291200,1509949440,788529152,1241513984,570425344,251658240,1358954496,486539264,352321536,654311424,905969664,1241513984,1409286144,1459617792,754974720,486539264,637534208,100663296,134217728,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,33554432,16777216,16777216,16777216,33554432,50331648,50331648,50331648,50331648,150994944,67108864,419430400,0,134217728,201326592,922746880,805306368,1442840576,1711276032,1207959552,1375731712,1509949440,150994944,587202560,1056964608,905969664,1006632960,1610612736,1426063360,1291845632,1090519040,1509949440,1342177280,1426063360,1577058304,1409286144,1929379840,1275068416,1610612736,1577058304,973078528,1426063360,922746880,1577058304,1073741824,855638016,822083584,553648128,0,33554432,83886080,134217728,100663296,251658240,134217728,83886080,0,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,16777216,16777216,16777216,16777216,33554432,33554432,33554432,33554432,0,184549376,0,150994944,117440512,16777216,335544320,0,1811939328,1660944384,973078528,855638016,1392508928,385875968,352321536,1090519040,335544320,973078528,134217728,922746880,1073741824,1241513984,1342177280,1342177280,1342177280,1358954496,1275068416,1493172224,1543503872,1677721600,1358954496,1040187392,822083584,1845493760,1358954496,1962934272,1811939328,1275068416,1006632960,1006632960,1174405120,268435456,218103808,100663296,50331648,117440512,67108864,117440512,33554432,33554432,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,83886080,0,100663296,33554432,167772160,33554432,16777216,0,419430400,117440512,419430400,318767104,922746880,67108864,1174405120,754974720,956301312,687865856,1291845632,520093696,905969664,1493172224,1543503872,1493172224,1543503872,1627389952,1526726656,1543503872,1291845632,1308622848,352321536,805306368,318767104,989855744,855638016,402653184,385875968,1040187392,771751936,1107296256,134217728,33554432,0,0,0,0,50331648,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,0,0,0,0,0,0,0,0,16777216,0,0,0,0,134217728,0,184549376,301989888,520093696,402653184,33554432,285212672,201326592,570425344,1107296256,1056964608,788529152,1409286144,536870912,754974720,1375731712,1711276032,1291845632,1610612736,1560281088,1442840576,1593835520,1325400064,1711276032,1358954496,1660944384,1157627904,956301312,1342177280,553648128,352321536,50331648,150994944,0,16777216,67108864,117440512,67108864,16777216,83886080,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100663296,0,67108864,67108864,0,0,16777216,50331648,268435456,16777216,67108864,83886080,134217728,201326592,218103808,352321536,654311424,1224736768,1090519040,2063597568,1493172224,1476395008,1711276032,1442840576,1241513984,1610612736,1073741824,1476395008,1308622848,167772160,771751936,1358954496,2013265920,1711276032,2080374784,1476395008,436207616,100663296,0,0,251658240,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,0,0,0,0,167772160,67108864,83886080,100663296,285212672,16777216,167772160,318767104,385875968,721420288,939524096,1426063360,1325400064,1124073472,1124073472,1426063360,1811939328,1476395008,1442840576,1677721600,1191182336,1358954496,637534208,939524096,385875968,0,50331648,0,83886080,536870912,687865856,83886080,0,100663296,50331648,83886080,0,83886080,134217728,67108864,0,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,100663296,33554432,16777216,67108864,16777216,50331648,201326592,637534208,704643072,855638016,1593835520,1845493760,1442840576,1728053248,1509949440,1426063360,1627389952,1325400064,1744830464,1258291200,939524096,1140850688,1090519040,1191182336,134217728,469762048,838860800,402653184,301989888,0,134217728,0,0,117440512,0,16777216,83886080,16777216,67108864,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,50331648,0,0,100663296,201326592,671088640,436207616,973078528,536870912,704643072,1459617792,1392508928,1409286144,1291845632,1107296256,1476395008,1207959552,587202560,855638016,889192448,419430400,251658240,201326592,1426063360,285212672,0,150994944,83886080,83886080,0,0,83886080,50331648,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,67108864,0,0,33554432,16777216,335544320,33554432,33554432,50331648,536870912,872415232,0,234881024,335544320,1258291200,721420288,1677721600,1392508928,838860800,83886080,0,167772160,117440512,150994944,0,50331648,83886080,0,0,16777216,0,67108864,50331648,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        ]);
        private var shimonData02:Vector.<uint> = Vector.<uint>([
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,0,16777216,50331648,0,0,33554432,0,67108864,83886080,0,0,0,33554432,16777216,16777216,50331648,0,33554432,0,50331648,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,16777216,0,16777216,67108864,0,0,0,0,134217728,83886080,16777216,0,33554432,0,0,83886080,0,83886080,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,0,16777216,83886080,67108864,285212672,167772160,0,0,0,67108864,0,50331648,16777216,0,50331648,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,33554432,16777216,134217728,0,16777216,100663296,16777216,0,0,50331648,0,67108864,83886080,0,33554432,0,33554432,83886080,50331648,16777216,16777216,0,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,0,0,16777216,33554432,134217728,251658240,234881024,117440512,67108864,218103808,150994944,385875968,83886080,33554432,0,0,0,0,50331648,50331648,67108864,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,134217728,134217728,0,0,218103808,268435456,33554432,33554432,0,117440512,335544320,671088640,251658240,134217728,117440512,50331648,33554432,0,0,0,50331648,16777216,33554432,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,50331648,0,0,0,0,67108864,352321536,452984832,268435456,587202560,436207616,201326592,67108864,0,0,33554432,318767104,134217728,184549376,117440512,150994944,0,50331648,0,67108864,33554432,33554432,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,67108864,134217728,167772160,486539264,234881024,117440512,150994944,117440512,50331648,16777216,0,100663296,234881024,67108864,503316480,838860800,1207959552,503316480,0,134217728,352321536,452984832,570425344,301989888,201326592,0,0,33554432,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83886080,0,67108864,16777216,50331648,201326592,50331648,83886080,67108864,33554432,16777216,117440512,536870912,738197504,989855744,620756992,654311424,620756992,83886080,0,67108864,50331648,956301312,1258291200,1006632960,939524096,436207616,67108864,50331648,50331648,67108864,16777216,16777216,100663296,100663296,16777216,0,67108864,83886080,33554432,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218103808,0,0,33554432,1325400064,1124073472,956301312,671088640,301989888,0,167772160,33554432,0,50331648,16777216,33554432,469762048,939524096,687865856,452984832,771751936,637534208,385875968,0,687865856,570425344,452984832,335544320,318767104,251658240,117440512,50331648,100663296,67108864,33554432,67108864,33554432,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,184549376,0,150994944,67108864,100663296,100663296,369098752,201326592,402653184,318767104,486539264,385875968,721420288,385875968,654311424,301989888,385875968,620756992,385875968,587202560,838860800,1224736768,603979776,536870912,889192448,0,100663296,301989888,234881024,234881024,771751936,285212672,0,100663296,385875968,201326592,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117440512,0,0,184549376,1711276032,1677721600,1560281088,1560281088,1073741824,251658240,117440512,67108864,369098752,218103808,654311424,620756992,620756992,1107296256,436207616,939524096,704643072,83886080,939524096,520093696,452984832,150994944,1291845632,570425344,335544320,134217728,33554432,117440512,67108864,671088640,754974720,268435456,33554432,67108864,67108864,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,16777216,134217728,201326592,1795162112,603979776,0,0,0,0,100663296,536870912,285212672,654311424,570425344,570425344,553648128,0,150994944,520093696,754974720,167772160,654311424,1744830464,1124073472,587202560,0,83886080,83886080,318767104,318767104,201326592,150994944,234881024,150994944,67108864,117440512,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,0,436207616,1291845632,520093696,654311424,721420288,822083584,268435456,117440512,402653184,1308622848,1224736768,1140850688,956301312,1493172224,1610612736,1442840576,1509949440,1207959552,1241513984,452984832,285212672,33554432,352321536,687865856,268435456,318767104,318767104,318767104,33554432,201326592,33554432,234881024,268435456,83886080,50331648,201326592,201326592,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,100663296,385875968,335544320,184549376,754974720,855638016,150994944,33554432,0,0,268435456,503316480,889192448,855638016,587202560,587202560,452984832,369098752,771751936,419430400,687865856,1056964608,1056964608,335544320,654311424,872415232,1124073472,620756992,335544320,251658240,0,100663296,134217728,33554432,301989888,587202560,419430400,167772160,83886080,33554432,50331648,33554432,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,0,0,721420288,989855744,2130706432,1358954496,436207616,201326592,50331648,989855744,1660944384,1560281088,1073741824,905969664,704643072,1174405120,1006632960,603979776,1241513984,1358954496,1006632960,956301312,939524096,402653184,301989888,184549376,419430400,1107296256,872415232,1291845632,1140850688,452984832,318767104,0,0,67108864,16777216,201326592,285212672,16777216,67108864,50331648,33554432,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,0,0,0,83886080,50331648,33554432,184549376,436207616,671088640,973078528,486539264,218103808,0,218103808,318767104,0,654311424,1056964608,1375731712,1392508928,1174405120,1258291200,1040187392,704643072,218103808,570425344,335544320,989855744,1711276032,1577058304,1073741824,1090519040,838860800,335544320,150994944,369098752,587202560,402653184,117440512,285212672,268435456,167772160,134217728,0,16777216,0,50331648,83886080,33554432,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,16777216,0,33554432,33554432,100663296,0,67108864,0,402653184,654311424,671088640,889192448,352321536,150994944,570425344,1191182336,1459617792,570425344,0,905969664,838860800,905969664,838860800,822083584,1241513984,1476395008,1107296256,1358954496,335544320,687865856,335544320,671088640,855638016,738197504,1258291200,1056964608,1325400064,855638016,352321536,150994944,0,268435456,218103808,251658240,201326592,251658240,100663296,117440512,67108864,0,0,0,50331648,67108864,0,0,0,0,0,0,0,0,50331648,50331648,100663296,0,16777216,16777216,184549376,201326592,285212672,150994944,822083584,1258291200,704643072,469762048,0,50331648,33554432,67108864,637534208,872415232,436207616,754974720,973078528,1660944384,1442840576,1392508928,989855744,973078528,1090519040,704643072,1392508928,939524096,1291845632,838860800,385875968,402653184,369098752,620756992,570425344,771751936,1140850688,1157627904,503316480,486539264,150994944,184549376,134217728,117440512,150994944,184549376,184549376,134217728,83886080,50331648,16777216,0,0,0,0,0,0,0,0,0,0,16777216,0,0,0,83886080,117440512,201326592,167772160,117440512,167772160,184549376,184549376,402653184,838860800,771751936,1140850688,1023410176,939524096,905969664,520093696,788529152,922746880,822083584,687865856,1174405120,1409286144,1543503872,1241513984,872415232,1275068416,1207959552,721420288,352321536,369098752,838860800,1090519040,1056964608,1207959552,352321536,134217728,318767104,201326592,536870912,352321536,134217728,33554432,335544320,134217728,167772160,201326592,201326592,167772160,100663296,16777216,0,16777216,16777216,0,0,0,0,0,0,0,50331648,0,67108864,100663296,318767104,67108864,67108864,671088640,385875968,167772160,385875968,369098752,16777216,150994944,503316480,167772160,301989888,939524096,1476395008,1459617792,1526726656,1342177280,1392508928,1308622848,1325400064,1526726656,1627389952,1459617792,1660944384,973078528,1157627904,1191182336,889192448,1325400064,637534208,16777216,385875968,889192448,1375731712,419430400,855638016,822083584,201326592,67108864,385875968,285212672,167772160,184549376,150994944,100663296,100663296,100663296,83886080,67108864,67108864,16777216,16777216,16777216,0,0,0,0,0,0,134217728,0,50331648,33554432,218103808,33554432,167772160,67108864,167772160,167772160,201326592,0,352321536,67108864,637534208,1275068416,1677721600,1409286144,1560281088,1526726656,1258291200,1308622848,1090519040,989855744,1191182336,1275068416,1124073472,1476395008,1073741824,1476395008,1459617792,1040187392,1426063360,1140850688,1426063360,1325400064,1308622848,671088640,285212672,687865856,369098752,469762048,469762048,570425344,452984832,184549376,385875968,285212672,218103808,167772160,167772160,167772160,100663296,33554432,0,16777216,16777216,16777216,16777216,0,0,0,0,0,16777216,0,0,117440512,117440512,50331648,134217728,637534208,218103808,150994944,570425344,335544320,553648128,134217728,620756992,1056964608,1610612736,754974720,1107296256,1543503872,1157627904,1543503872,1409286144,1442840576,1459617792,1509949440,1375731712,1560281088,1308622848,1493172224,1056964608,973078528,1694498816,1426063360,503316480,587202560,939524096,1358954496,1358954496,989855744,520093696,201326592,301989888,301989888,335544320,134217728,50331648,268435456,218103808,201326592,251658240,268435456,167772160,33554432,0,16777216,16777216,16777216,16777216,16777216,0,0,0,67108864,0,16777216,33554432,771751936,603979776,318767104,0,369098752,150994944,117440512,419430400,100663296,67108864,352321536,486539264,520093696,1224736768,1040187392,1207959552,1677721600,1291845632,1140850688,1442840576,1358954496,1342177280,1392508928,1275068416,1409286144,1224736768,1795162112,1006632960,889192448,1694498816,1275068416,1610612736,1241513984,922746880,922746880,234881024,419430400,352321536,33554432,419430400,402653184,687865856,520093696,67108864,167772160,67108864,33554432,100663296,184549376,184549376,167772160,167772160,16777216,16777216,16777216,16777216,16777216,0,0,0,0,33554432,83886080,0,50331648,184549376,100663296,134217728,788529152,486539264,83886080,100663296,452984832,1023410176,2046820352,1660944384,1728053248,1660944384,1778384896,1493172224,1593835520,1493172224,1392508928,1124073472,1191182336,1577058304,1526726656,1342177280,1040187392,671088640,620756992,469762048,956301312,855638016,486539264,805306368,1006632960,1375731712,1912602624,1325400064,1442840576,1140850688,771751936,16777216,67108864,184549376,452984832,318767104,503316480,486539264,385875968,67108864,117440512,0,50331648,218103808,16777216,16777216,16777216,0,0,16777216,16777216,16777216,67108864,0,67108864,134217728,234881024,268435456,1241513984,419430400,83886080,117440512,16777216,33554432,150994944,754974720,201326592,0,150994944,352321536,1241513984,1375731712,1375731712,1593835520,1509949440,1358954496,1224736768,1291845632,1375731712,1459617792,1543503872,1325400064,1442840576,1526726656,1358954496,1308622848,1543503872,1426063360,922746880,503316480,452984832,855638016,939524096,1811939328,1795162112,1845493760,603979776,419430400,285212672,167772160,0,184549376,385875968,234881024,285212672,150994944,83886080,0,50331648,50331648,33554432,16777216,0,0,0,0,33554432,0,0,369098752,553648128,436207616,251658240,0,201326592,201326592,335544320,687865856,671088640,1476395008,1107296256,1610612736,1543503872,1191182336,2013265920,1845493760,1577058304,1426063360,1442840576,1493172224,1493172224,1308622848,1744830464,1711276032,1459617792,1509949440,1593835520,1140850688,1291845632,905969664,1006632960,1056964608,1392508928,1593835520,939524096,352321536,603979776,301989888,503316480,654311424,989855744,889192448,1073741824,486539264,251658240,201326592,167772160,0,0,33554432,251658240,251658240,50331648,50331648,33554432,16777216,0,0,0,0,0,251658240,50331648,33554432,0,167772160,301989888,335544320,117440512,0,218103808,1023410176,587202560,452984832,452984832,536870912,536870912,50331648,603979776,671088640,1191182336,1358954496,1543503872,1459617792,1409286144,1577058304,1543503872,1241513984,1291845632,1526726656,1291845632,1325400064,1375731712,1040187392,1140850688,1526726656,1291845632,905969664,1409286144,1493172224,1308622848,553648128,838860800,603979776,184549376,117440512,285212672,738197504,738197504,469762048,436207616,436207616,218103808,0,16777216,33554432,33554432,16777216,16777216,16777216,16777216,16777216,16777216,16777216,0,0,33554432,0,1023410176,1073741824,0,150994944,33554432,167772160,419430400,1392508928,1224736768,1107296256,1174405120,805306368,1174405120,1459617792,1275068416,1476395008,1375731712,1644167168,1409286144,1325400064,1442840576,1358954496,1459617792,1694498816,1560281088,1677721600,1241513984,1275068416,1342177280,1644167168,1275068416,905969664,1207959552,1426063360,1275068416,0,855638016,452984832,973078528,1728053248,1509949440,1342177280,201326592,0,184549376,100663296,318767104,620756992,503316480,285212672,117440512,16777216,33554432,33554432,16777216,16777216,16777216,16777216,16777216,33554432,50331648,67108864,184549376,872415232,620756992,0,201326592,285212672,536870912,1006632960,973078528,1107296256,1107296256,1677721600,1577058304,1476395008,1660944384,1476395008,1073741824,687865856,1090519040,788529152,1325400064,1593835520,1677721600,1879048192,1375731712,1308622848,1560281088,1543503872,1040187392,1476395008,654311424,1090519040,1140850688,452984832,1107296256,1627389952,1426063360,1107296256,553648128,352321536,134217728,83886080,620756992,822083584,1291845632,1325400064,268435456,218103808,134217728,134217728,83886080,285212672,318767104,268435456,67108864,50331648,50331648,33554432,16777216,0,0,0,0,0,117440512,788529152,855638016,1560281088,1459617792,1426063360,838860800,553648128,385875968,553648128,1325400064,1879048192,1224736768,486539264,1023410176,1073741824,587202560,1493172224,1241513984,1610612736,1157627904,1459617792,1275068416,1476395008,1442840576,1325400064,1291845632,1207959552,1342177280,1442840576,1174405120,956301312,1509949440,973078528,1241513984,1493172224,1174405120,1308622848,721420288,1828716544,1912602624,1526726656,1090519040,620756992,771751936,1023410176,822083584,805306368,469762048,251658240,100663296,201326592,50331648,0,67108864,67108864,50331648,33554432,16777216,0,0,0,16777216,469762048,1795162112,2080374784,1644167168,1778384896,1828716544,1895825408,1090519040,905969664,1543503872,1308622848,939524096,184549376,637534208,654311424,1040187392,1526726656,1761607680,1560281088,771751936,973078528,1040187392,1308622848,1476395008,1526726656,1560281088,1308622848,1107296256,503316480,1124073472,1627389952,1174405120,352321536,1090519040,687865856,587202560,1107296256,1107296256,687865856,486539264,1107296256,889192448,503316480,671088640,553648128,167772160,385875968,100663296,251658240,201326592,419430400,486539264,486539264,167772160,167772160,33554432,33554432,33554432,16777216,16777216,33554432,33554432,33554432,0,889192448,1509949440,956301312,1660944384,1426063360,1442840576,1526726656,1828716544,1828716544,1124073472,0,654311424,1409286144,1610612736,1627389952,1560281088,117440512,167772160,956301312,788529152,956301312,1929379840,1493172224,1275068416,1610612736,1476395008,1442840576,1442840576,1426063360,1375731712,1224736768,1375731712,1191182336,1275068416,1291845632,1040187392,956301312,1996488704,1811939328,1241513984,1509949440,1275068416,1426063360,1493172224,1140850688,1610612736,1610612736,1040187392,754974720,167772160,0,184549376,167772160,50331648,335544320,150994944,100663296,50331648,0,0,0,0,0,83886080,0,419430400,1224736768,1509949440,1493172224,1627389952,1392508928,369098752,771751936,1476395008,1778384896,1426063360,1275068416,855638016,436207616,0,687865856,1342177280,1241513984,1258291200,905969664,905969664,1459617792,1694498816,1509949440,1426063360,1241513984,1207959552,1442840576,1325400064,1241513984,1560281088,973078528,1090519040,1426063360,218103808,0,301989888,754974720,218103808,134217728,553648128,385875968,184549376,587202560,973078528,1023410176,1174405120,956301312,973078528,687865856,184549376,67108864,67108864,0,50331648,134217728,184549376,150994944,50331648,0,16777216,83886080,0,1140850688,2130706432,1644167168,1711276032,1577058304,1660944384,1224736768,905969664,1392508928,1660944384,1677721600,939524096,620756992,771751936,1157627904,1275068416,771751936,721420288,301989888,134217728,402653184,738197504,1040187392,1258291200,1677721600,1644167168,1140850688,721420288,1375731712,1509949440,1224736768,1375731712,1056964608,1275068416,1308622848,956301312,1040187392,1023410176,1375731712,1258291200,1375731712,1308622848,1191182336,805306368,452984832,419430400,402653184,201326592,100663296,587202560,738197504,335544320,251658240,352321536,335544320,268435456,184549376,83886080,0,0,0,0,0,150994944,134217728,1056964608,1677721600,1426063360,1577058304,1526726656,1627389952,1845493760,1627389952,1426063360,1325400064,1325400064,1409286144,1761607680,1392508928,218103808,268435456,603979776,1124073472,1140850688,687865856,385875968,100663296,822083584,1593835520,1140850688,1711276032,1493172224,889192448,1342177280,687865856,1140850688,1660944384,385875968,536870912,570425344,1056964608,436207616,335544320,436207616,704643072,436207616,1056964608,1459617792,1392508928,1677721600,1644167168,1241513984,805306368,335544320,0,67108864,167772160,83886080,402653184,452984832,285212672,100663296,16777216,33554432,67108864,50331648,0,0,218103808,1174405120,1728053248,1728053248,1593835520,1744830464,1543503872,1375731712,1493172224,1526726656,1610612736,1577058304,671088640,486539264,553648128,1140850688,1811939328,738197504,184549376,67108864,134217728,956301312,1056964608,721420288,1694498816,1660944384,1577058304,1056964608,1325400064,1291845632,1358954496,1560281088,1442840576,1308622848,1291845632,1241513984,1644167168,285212672,1459617792,1728053248,1241513984,905969664,738197504,251658240,0,201326592,100663296,620756992,1056964608,1258291200,872415232,620756992,251658240,0,201326592,117440512,150994944,167772160,134217728,67108864,16777216,16777216,16777216,301989888,1845493760,1627389952,1610612736,0,318767104,1174405120,1358954496,1610612736,1258291200,1325400064,1342177280,989855744,1342177280,1660944384,1006632960,637534208,587202560,117440512,1308622848,1493172224,721420288,771751936,234881024,637534208,1744830464,1493172224,1526726656,1560281088,1375731712,1711276032,922746880,620756992,771751936,603979776,134217728,402653184,973078528,1174405120,1191182336,1056964608,1560281088,1627389952,1375731712,1627389952,2013265920,2113929216,1375731712,452984832,0,318767104,637534208,788529152,805306368,620756992,939524096,100663296,83886080,83886080,50331648,16777216,0,0,0,385875968,1308622848,285212672,285212672,1090519040,1627389952,1627389952,1543503872,1744830464,1056964608,1241513984,1593835520,1610612736,1023410176,671088640,536870912,822083584,1107296256,973078528,1040187392,402653184,50331648,285212672,201326592,167772160,1610612736,1543503872,1694498816,553648128,1577058304,1409286144,838860800,939524096,1090519040,1207959552,1023410176,402653184,234881024,419430400,687865856,167772160,352321536,486539264,536870912,788529152,352321536,1040187392,1610612736,1761607680,637534208,587202560,536870912,117440512,67108864,100663296,436207616,335544320,218103808,100663296,50331648,67108864,83886080,50331648,16777216,0,234881024,973078528,1761607680,1912602624,822083584,419430400,1426063360,1728053248,1459617792,1593835520,721420288,989855744,838860800,1409286144,1694498816,1694498816,436207616,285212672,603979776,352321536,922746880,973078528,469762048,117440512,117440512,1828716544,1610612736,1543503872,1325400064,1660944384,1543503872,1627389952,1409286144,1509949440,637534208,1258291200,1392508928,1543503872,1207959552,1258291200,704643072,1442840576,1023410176,1325400064,1275068416,637534208,134217728,251658240,167772160,922746880,939524096,570425344,637534208,369098752,234881024,33554432,83886080,134217728,100663296,0,0,0,16777216,33554432,1342177280,1811939328,1090519040,117440512,100663296,989855744,1593835520,1627389952,1543503872,117440512,805306368,1895825408,1795162112,989855744,134217728,285212672,973078528,335544320,905969664,318767104,318767104,0,452984832,385875968,788529152,1577058304,1308622848,1224736768,1056964608,1325400064,553648128,620756992,1761607680,771751936,117440512,1308622848,1258291200,218103808,0,251658240,687865856,1308622848,201326592,402653184,1090519040,1811939328,1962934272,1509949440,553648128,0,67108864,100663296,436207616,184549376,419430400,402653184,369098752,117440512,67108864,0,83886080,16777216,33554432,251658240,520093696,16777216,33554432,1224736768,1879048192,1543503872,805306368,1761607680,1392508928,1543503872,1476395008,1040187392,0,150994944,1375731712,1711276032,587202560,385875968,33554432,486539264,234881024,922746880,503316480,520093696,1509949440,1409286144,956301312,301989888,1593835520,1627389952,1627389952,1442840576,1224736768,1593835520,1476395008,1375731712,1157627904,989855744,805306368,285212672,167772160,218103808,1056964608,1627389952,788529152,67108864,150994944,587202560,469762048,1006632960,1543503872,671088640,285212672,50331648,67108864,67108864,268435456,285212672,218103808,67108864,0,0,0,33554432,16777216,905969664,1778384896,1493172224,335544320,83886080,16777216,1493172224,1627389952,1728053248,419430400,218103808,1644167168,2097152000,1493172224,436207616,16777216,704643072,956301312,1795162112,402653184,402653184,469762048,117440512,335544320,1191182336,1728053248,1744830464,1409286144,1040187392,1660944384,1711276032,1677721600,1308622848,1174405120,1509949440,822083584,771751936,905969664,805306368,1509949440,771751936,452984832,553648128,1157627904,1761607680,1275068416,385875968,234881024,0,285212672,503316480,956301312,771751936,369098752,251658240,218103808,67108864,0,184549376,184549376,100663296,83886080,16777216,1291845632,1191182336,486539264,1258291200,922746880,587202560,1073741824,1610612736,1577058304,1459617792,1459617792,1610612736,721420288,167772160,83886080,1056964608,956301312,721420288,536870912,637534208,150994944,486539264,754974720,1174405120,1157627904,1056964608,1023410176,771751936,922746880,838860800,1560281088,1409286144,1409286144,1073741824,1241513984,1459617792,587202560,637534208,1375731712,1107296256,1308622848,419430400,754974720,1426063360,1174405120,1392508928,1090519040,788529152,889192448,570425344,687865856,352321536,16777216,100663296,469762048,318767104,402653184,369098752,134217728,218103808,0,0,0,251658240,301989888,83886080,83886080,1174405120,905969664,285212672,167772160,687865856,1862270976,1526726656,1107296256,184549376,1107296256,1778384896,1526726656,905969664,335544320,0,201326592,1157627904,603979776,872415232,637534208,117440512,436207616,285212672,973078528,1191182336,1811939328,1375731712,1258291200,1224736768,1409286144,1677721600,1174405120,1107296256,1493172224,956301312,1342177280,1610612736,1375731712,1006632960,1207959552,1056964608,1224736768,1509949440,520093696,285212672,251658240,134217728,251658240,33554432,218103808,419430400,83886080,33554432,100663296,184549376,67108864,218103808,50331648,83886080,134217728,33554432,285212672,721420288,603979776,687865856,452984832,352321536,402653184,385875968,687865856,486539264,1526726656,1644167168,1694498816,738197504,50331648,234881024,838860800,1174405120,620756992,754974720,0,503316480,369098752,822083584,1275068416,1124073472,788529152,822083584,50331648,385875968,1543503872,1342177280,1577058304,1476395008,1409286144,1577058304,1392508928,67108864,83886080,1459617792,822083584,402653184,1191182336,1325400064,1577058304,1459617792,1258291200,1023410176,805306368,654311424,721420288,385875968,0,16777216,285212672,352321536,167772160,83886080,33554432,100663296,33554432,0,0,33554432,486539264,637534208,50331648,50331648,503316480,721420288,822083584,67108864,1040187392,1761607680,1191182336,687865856,218103808,1174405120,1392508928,1560281088,402653184,50331648,234881024,553648128,905969664,1040187392,671088640,452984832,50331648,452984832,754974720,637534208,1560281088,2080374784,1426063360,1224736768,1677721600,1291845632,1409286144,1325400064,1191182336,1174405120,1056964608,1308622848,905969664,637534208,553648128,134217728,754974720,922746880,452984832,100663296,268435456,268435456,402653184,872415232,788529152,234881024,100663296,67108864,67108864,234881024,352321536,67108864,0,33554432,0,100663296,83886080,385875968,637534208,587202560,285212672,285212672,1023410176,251658240,1761607680,973078528,1090519040,1191182336,1476395008,1056964608,687865856,452984832,486539264,620756992,738197504,889192448,905969664,83886080,570425344,587202560,822083584,1090519040,805306368,402653184,721420288,922746880,1644167168,1291845632,1560281088,1358954496,1426063360,1224736768,335544320,201326592,771751936,1073741824,1140850688,1593835520,1761607680,1627389952,1157627904,1073741824,939524096,973078528,637534208,536870912,218103808,33554432,134217728,268435456,536870912,385875968,117440512,50331648,184549376,0,33554432,100663296,0,67108864,201326592,771751936,822083584,33554432,117440512,721420288,1140850688,33554432,973078528,1509949440,1442840576,1627389952,100663296,251658240,805306368,1543503872,889192448,469762048,83886080,0,771751936,822083584,956301312,469762048,0,436207616,218103808,536870912,637534208,1560281088,1879048192,1358954496,1442840576,1526726656,1644167168,1845493760,1476395008,738197504,1677721600,1224736768,402653184,369098752,0,754974720,1560281088,1660944384,805306368,234881024,0,285212672,318767104,352321536,754974720,218103808,50331648,486539264,436207616,251658240,0,167772160,0,0,0,0,100663296,50331648,33554432,872415232,1409286144,268435456,134217728,889192448,637534208,989855744,1543503872,1476395008,1476395008,1711276032,704643072,721420288,0,486539264,838860800,1241513984,1610612736,620756992,788529152,939524096,1476395008,1308622848,620756992,620756992,369098752,167772160,754974720,1744830464,1358954496,1056964608,0,335544320,1459617792,620756992,553648128,905969664,1459617792,1996488704,2046820352,1006632960,167772160,0,1023410176,1409286144,1509949440,268435456,33554432,117440512,469762048,771751936,452984832,0,134217728,520093696,67108864,385875968,0,117440512,33554432,234881024,0,201326592,1056964608,83886080,570425344,184549376,771751936,553648128,536870912,1191182336,1375731712,1442840576,201326592,369098752,369098752,520093696,1090519040,1459617792,402653184,402653184,1191182336,956301312,1560281088,520093696,285212672,469762048,318767104,704643072,117440512,536870912,1442840576,1862270976,1342177280,1610612736,1124073472,1409286144,1862270976,973078528,738197504,83886080,117440512,973078528,1191182336,1124073472,1694498816,1526726656,486539264,33554432,285212672,452984832,603979776,184549376,67108864,0,486539264,1040187392,0,419430400,452984832,0,150994944,0,0,16777216,0,167772160,201326592,0,301989888,687865856,318767104,318767104,218103808,503316480,637534208,620756992,1040187392,1325400064,637534208,268435456,268435456,587202560,939524096,1107296256,855638016,771751936,939524096,520093696,486539264,771751936,872415232,587202560,1023410176,1174405120,671088640,1124073472,1442840576,1761607680,1577058304,1258291200,889192448,1275068416,1677721600,1006632960,1509949440,1979711488,1006632960,905969664,536870912,989855744,1392508928,1241513984,805306368,335544320,218103808,83886080,570425344,805306368,167772160,67108864,486539264,352321536,0,285212672,0,0,33554432,0,50331648,16777216,50331648,486539264,33554432,218103808,520093696,184549376,50331648,251658240,939524096,1140850688,486539264,0,469762048,1375731712,973078528,989855744,704643072,268435456,402653184,1174405120,872415232,654311424,352321536,436207616,805306368,369098752,301989888,436207616,486539264,1107296256,1610612736,1375731712,1526726656,1677721600,989855744,1157627904,1040187392,536870912,100663296,436207616,1056964608,1560281088,1577058304,989855744,150994944,285212672,335544320,822083584,402653184,0,268435456,973078528,1107296256,16777216,0,553648128,184549376,16777216,50331648,83886080,0,50331648,67108864,0,16777216,100663296,335544320,0,234881024,301989888,201326592,352321536,16777216,419430400,922746880,1291845632,1358954496,1073741824,0,67108864,251658240,956301312,872415232,805306368,1358954496,1224736768,385875968,83886080,218103808,637534208,620756992,1006632960,922746880,1308622848,1711276032,1409286144,1358954496,1426063360,771751936,671088640,939524096,1325400064,1660944384,1744830464,1124073472,301989888,620756992,1358954496,1744830464,1224736768,369098752,0,436207616,872415232,318767104,16777216,50331648,671088640,553648128,0,402653184,335544320,50331648,0,0,0,33554432,67108864,0,587202560,603979776,184549376,218103808,268435456,83886080,553648128,1258291200,855638016,989855744,301989888,167772160,385875968,754974720,1543503872,385875968,956301312,1224736768,587202560,1325400064,1258291200,1023410176,721420288,838860800,369098752,369098752,419430400,268435456,436207616,1342177280,1627389952,1660944384,1610612736,1140850688,570425344,469762048,285212672,201326592,754974720,1358954496,1728053248,1023410176,587202560,301989888,486539264,1140850688,1275068416,167772160,0,973078528,503316480,234881024,83886080,301989888,419430400,0,469762048,285212672,0,117440512,16777216,33554432,0,218103808,117440512,150994944,402653184,134217728,251658240,570425344,788529152,402653184,419430400,1040187392,1140850688,1577058304,905969664,301989888,1006632960,150994944,687865856,956301312,402653184,872415232,1358954496,1040187392,503316480,218103808,704643072,805306368,905969664,452984832,805306368,1509949440,1526726656,1593835520,1291845632,1073741824,1358954496,1862270976,1593835520,1409286144,1308622848,939524096,671088640,738197504,1308622848,1375731712,671088640,503316480,251658240,1358954496,754974720,83886080,251658240,788529152,218103808,50331648,452984832,520093696,0,167772160,50331648,0,0,67108864,33554432,16777216,486539264,754974720,369098752,117440512,553648128,184549376,100663296,1073741824,1107296256,620756992,570425344,402653184,838860800,620756992,738197504,486539264,553648128,687865856,1124073472,1459617792,503316480,553648128,1023410176,738197504,553648128,150994944,285212672,385875968,436207616,1543503872,1560281088,1375731712,1375731712,1476395008,1275068416,1610612736,1006632960,436207616,385875968,1409286144,1828716544,1157627904,0,822083584,184549376,889192448,419430400,218103808,754974720,570425344,50331648,134217728,939524096,637534208,0,721420288,352321536,0,16777216,33554432,83886080,0,67108864,100663296,536870912,285212672,150994944,100663296,0,301989888,436207616,570425344,150994944,553648128,1828716544,838860800,0,184549376,1124073472,855638016,553648128,805306368,1140850688,788529152,1157627904,1526726656,1090519040,536870912,603979776,704643072,1526726656,989855744,570425344,738197504,1476395008,1308622848,838860800,486539264,1459617792,1711276032,1811939328,1728053248,1409286144,452984832,335544320,1509949440,905969664,536870912,1107296256,0,721420288,1392508928,150994944,218103808,872415232,352321536,50331648,771751936,184549376,50331648,285212672,67108864,50331648,0,50331648,100663296,16777216,117440512,100663296,520093696,570425344,33554432,251658240,687865856,251658240,0,1526726656,301989888,385875968,167772160,1023410176,1191182336,436207616,117440512,369098752,822083584,1090519040,1291845632,1174405120,989855744,1526726656,1258291200,486539264,285212672,0,788529152,553648128,872415232,1593835520,1543503872,1409286144,1375731712,1795162112,201326592,301989888,1124073472,1191182336,1929379840,1040187392,33554432,1207959552,754974720,469762048,1157627904,268435456,704643072,503316480,587202560,167772160,452984832,285212672,33554432,469762048,419430400,50331648,184549376,0,50331648,0,50331648,0,100663296,268435456,671088640,33554432,268435456,0,134217728,33554432,67108864,603979776,184549376,201326592,704643072,486539264,436207616,536870912,738197504,738197504,637534208,671088640,973078528,1409286144,1560281088,989855744,805306368,754974720,1107296256,1442840576,1006632960,553648128,1291845632,251658240,1174405120,989855744,1342177280,1476395008,1442840576,1543503872,1140850688,402653184,603979776,1124073472,1358954496,385875968,939524096,620756992,201326592,956301312,671088640,318767104,1207959552,754974720,167772160,335544320,369098752,134217728,469762048,654311424,0,0,83886080,167772160,16777216,0,184549376,50331648,352321536,1392508928,754974720,16777216,16777216,67108864,33554432,201326592,402653184,385875968,285212672,1006632960,838860800,1694498816,704643072,218103808,520093696,771751936,704643072,352321536,301989888,1258291200,1392508928,1526726656,905969664,520093696,436207616,486539264,1258291200,1560281088,1660944384,1006632960,1140850688,1778384896,939524096,536870912,1073741824,1593835520,1241513984,369098752,838860800,1728053248,0,905969664,822083584,184549376,1124073472,503316480,134217728,520093696,301989888,100663296,503316480,335544320,67108864,603979776,268435456,201326592,0,0,67108864,100663296,520093696,50331648,788529152,2063597568,285212672,520093696,167772160,100663296,0,486539264,0,536870912,654311424,771751936,687865856,973078528,1191182336,469762048,637534208,989855744,855638016,1056964608,1291845632,1375731712,536870912,16777216,536870912,872415232,1157627904,805306368,150994944,1040187392,436207616,83886080,1593835520,469762048,1191182336,1526726656,1392508928,671088640,704643072,1728053248,402653184,352321536,1073741824,0,721420288,1191182336,0,889192448,1040187392,0,436207616,402653184,0,570425344,620756992,0,637534208,285212672,0,16777216,16777216,50331648,83886080,369098752,704643072,301989888,956301312,788529152,0,184549376,654311424,67108864,150994944,905969664,553648128,939524096,318767104,201326592,1577058304,536870912,134217728,738197504,1308622848,637534208,67108864,0,687865856,956301312,1006632960,452984832,318767104,603979776,520093696,1040187392,1677721600,1526726656,1577058304,1308622848,1090519040,436207616,721420288,1778384896,922746880,218103808,1442840576,687865856,134217728,1107296256,285212672,872415232,1040187392,134217728,603979776,1023410176,301989888,369098752,285212672,100663296,855638016,100663296,251658240,100663296,134217728,33554432,0,0,620756992,1157627904,0,469762048,2063597568,251658240,285212672,402653184,100663296,570425344,402653184,251658240,1073741824,469762048,889192448,1006632960,184549376,553648128,553648128,0,469762048,754974720,637534208,1241513984,419430400,570425344,469762048,754974720,788529152,553648128,771751936,654311424,1375731712,1006632960,637534208,1627389952,1660944384,1476395008,822083584,704643072,637534208,1191182336,603979776,922746880,654311424,184549376,956301312,352321536,587202560,1056964608,251658240,268435456,385875968,83886080,402653184,285212672,150994944,402653184,50331648,50331648,0,0,33554432,16777216,251658240,788529152,0,855638016,620756992,419430400,520093696,335544320,268435456,536870912,234881024,486539264,0,1124073472,939524096,452984832,654311424,452984832,301989888,335544320,587202560,956301312,922746880,520093696,285212672,855638016,1107296256,486539264,553648128,536870912,905969664,1023410176,1006632960,1291845632,1325400064,1627389952,1677721600,1207959552,671088640,1442840576,805306368,436207616,1275068416,218103808,1040187392,1006632960,167772160,1056964608,352321536,167772160,570425344,218103808,218103808,184549376,385875968,520093696,218103808,184549376,469762048,0,83886080,0,67108864,0,0,1761607680,268435456,385875968,603979776,419430400,318767104,369098752,369098752,100663296,654311424,150994944,419430400,939524096,117440512,721420288,620756992,0,553648128,335544320,335544320,973078528,218103808,637534208,637534208,419430400,469762048,1426063360,889192448,855638016,922746880,117440512,1023410176,872415232,352321536,1610612736,1275068416,922746880,1040187392,1426063360,1291845632,1124073472,50331648,1308622848,268435456,805306368,1207959552,50331648,838860800,754974720,0,922746880,117440512,335544320,201326592,268435456,385875968,100663296,268435456,117440512,16777216,0,83886080,100663296,1375731712,369098752,201326592,117440512,167772160,0,100663296,503316480,67108864,268435456,469762048,570425344,553648128,520093696,922746880,301989888,218103808,503316480,956301312,251658240,922746880,704643072,671088640,503316480,0,419430400,1409286144,637534208,268435456,301989888,989855744,1392508928,1677721600,1593835520,1442840576,687865856,1476395008,1426063360,1375731712,1644167168,1174405120,520093696,1191182336,16777216,973078528,201326592,721420288,1174405120,134217728,603979776,838860800,0,654311424,352321536,167772160,251658240,402653184,234881024,0,100663296,0,0,33554432,0,922746880,419430400,318767104,553648128,520093696,402653184,939524096,67108864,419430400,234881024,184549376,771751936,335544320,922746880,536870912,268435456,402653184,838860800,0,721420288,771751936,419430400,922746880,704643072,889192448,754974720,788529152,251658240,1593835520,1040187392,436207616,1073741824,1593835520,1493172224,1426063360,1728053248,234881024,1291845632,1795162112,587202560,1392508928,268435456,1023410176,1241513984,134217728,1711276032,385875968,469762048,1124073472,218103808,268435456,687865856,0,553648128,402653184,335544320,201326592,721420288,234881024,150994944,0,0,0,50331648,218103808,2046820352,452984832,570425344,301989888,536870912,536870912,553648128,771751936,335544320,872415232,419430400,889192448,234881024,570425344,855638016,436207616,536870912,570425344,1056964608,738197504,721420288,503316480,1073741824,385875968,587202560,419430400,436207616,822083584,1107296256,1107296256,922746880,956301312,1560281088,1358954496,1174405120,1342177280,570425344,973078528,1140850688,738197504,1258291200,0,1040187392,452984832,452984832,1493172224,603979776,268435456,1157627904,352321536,369098752,1006632960,67108864,285212672,469762048,100663296,234881024,33554432,0,67108864,117440512,0,0,0,704643072,50331648,536870912,67108864,637534208,301989888,939524096,301989888,738197504,1157627904,704643072,637534208,603979776,956301312,587202560,1006632960,218103808,687865856,268435456,419430400,805306368,1056964608,117440512,838860800,570425344,905969664,1560281088,1392508928,1761607680,1308622848,1560281088,1459617792,1342177280,1409286144,1409286144,1526726656,1761607680,956301312,704643072,905969664,318767104,1342177280,33554432,1308622848,704643072,419430400,1627389952,419430400,402653184,1476395008,318767104,385875968,436207616,218103808,100663296,234881024,134217728,637534208,318767104,0,0,0,50331648,16777216,167772160,721420288,872415232,419430400,0,1023410176,452984832,587202560,369098752,419430400,1560281088,1191182336,671088640,1258291200,654311424,838860800,687865856,553648128,671088640,671088640,872415232,1023410176,1107296256,1426063360,1660944384,1459617792,1912602624,1375731712,771751936,520093696,1862270976,1224736768,1627389952,1409286144,1426063360,1140850688,620756992,1728053248,134217728,1124073472,553648128,620756992,738197504,0,1375731712,318767104,268435456,1828716544,184549376,620756992,1174405120,150994944,369098752,234881024,67108864,385875968,184549376,352321536,234881024,0,16777216,0,33554432,0,0,738197504,318767104,234881024,603979776,905969664,285212672,922746880,654311424,1040187392,1006632960,956301312,268435456,889192448,687865856,754974720,721420288,167772160,654311424,1056964608,1509949440,1811939328,1023410176,771751936,1744830464,1577058304,1140850688,1174405120,1560281088,1593835520,1543503872,1073741824,1040187392,1409286144,1174405120,1610612736,872415232,855638016,1342177280,100663296,1124073472,603979776,704643072,822083584,201326592,1526726656,201326592,486539264,1291845632,167772160,838860800,436207616,268435456,419430400,234881024,402653184,553648128,0,0,0,0,0,0,16777216,100663296,184549376,184549376,134217728,1056964608,654311424,570425344,1023410176,1409286144,318767104,1124073472,553648128,469762048,385875968,973078528,671088640,570425344,1342177280,486539264,956301312,1073741824,1728053248,301989888,1140850688,1543503872,1744830464,1140850688,1459617792,1761607680,1275068416,922746880,1627389952,654311424,1325400064,1308622848,486539264,1560281088,251658240,973078528,1124073472,536870912,1174405120,0,1560281088,1056964608,2063597568,1224736768,0,1224736768,218103808,704643072,419430400,536870912,100663296,603979776,67108864,251658240,218103808,0,83886080,0,16777216,0,0,33554432,100663296,83886080,16777216,1040187392,268435456,805306368,1107296256,1426063360,922746880,905969664,754974720,436207616,1006632960,1241513984,1157627904,989855744,1929379840,922746880,1291845632,520093696,1593835520,234881024,1711276032,1795162112,1308622848,1358954496,1224736768,1241513984,1392508928,486539264,1828716544,1543503872,1426063360,1560281088,486539264,1426063360,1342177280,268435456,1409286144,436207616,956301312,889192448,553648128,1509949440,603979776,1660944384,553648128,1124073472,1040187392,167772160,486539264,905969664,167772160,352321536,587202560,150994944,184549376,67108864,0,16777216,16777216,0,0,0,33554432,0,0,922746880,0,1124073472,889192448,989855744,922746880,587202560,1023410176,268435456,1577058304,956301312,1912602624,1694498816,1593835520,1056964608,1358954496,838860800,1073741824,436207616,1845493760,1526726656,1476395008,1241513984,1459617792,1426063360,1694498816,1207959552,1493172224,1627389952,536870912,452984832,1627389952,1308622848,1174405120,1056964608,318767104,1375731712,0,1409286144,1493172224,1694498816,687865856,419430400,1845493760,16777216,1056964608,369098752,469762048,419430400,503316480,134217728,134217728,0,0,67108864,0,0,0,0,0,16777216,33554432,16777216,0,1124073472,251658240,1140850688,536870912,1308622848,738197504,1006632960,805306368,1040187392,1325400064,1157627904,687865856,1476395008,1207959552,503316480,1593835520,1711276032,1040187392,1124073472,1728053248,1694498816,1006632960,1308622848,1342177280,1375731712,1291845632,452984832,1023410176,268435456,671088640,335544320,1426063360,1107296256,1107296256,1308622848,134217728,939524096,603979776,234881024,1577058304,1191182336,1258291200,251658240,1761607680,452984832,654311424,536870912,570425344,402653184,369098752,352321536,520093696,553648128,0,201326592,50331648,0,0,0,16777216,33554432,33554432,16777216,16777216,234881024,486539264,620756992,587202560,1442840576,419430400,1493172224,687865856,1291845632,33554432,1593835520,1124073472,1879048192,1241513984,1073741824,1056964608,1476395008,419430400,1375731712,1392508928,1476395008,469762048,838860800,922746880,905969664,922746880,637534208,1308622848,385875968,922746880,201326592,1241513984,872415232,1073741824,503316480,1056964608,335544320,1107296256,150994944,1224736768,1090519040,1291845632,469762048,1711276032,335544320,469762048,385875968,201326592,385875968,469762048,184549376,150994944,822083584,0,0,0,16777216,0,0,16777216,16777216,0,0,16777216,67108864,738197504,838860800,1073741824,436207616,922746880,301989888,822083584,587202560,469762048,1560281088,1258291200,1644167168,1308622848,754974720,855638016,1577058304,67108864,1493172224,822083584,1509949440,570425344,838860800,1023410176,654311424,1006632960,301989888,1828716544,1056964608,1476395008,0,1191182336,469762048,1342177280,0,1795162112,352321536,1107296256,822083584,1107296256,1207959552,1090519040,771751936,754974720,922746880,184549376,486539264,285212672,587202560,469762048,268435456,184549376,16777216,50331648,218103808,0,16777216,0,0,16777216,16777216,0,0,16777216,0,1040187392,251658240,1308622848,570425344,1459617792,654311424,1275068416,218103808,2097152000,1459617792,1577058304,1308622848,905969664,1174405120,352321536,1778384896,167772160,1342177280,184549376,1526726656,385875968,905969664,838860800,553648128,973078528,385875968,1761607680,1543503872,1426063360,1258291200,1073741824,318767104,1593835520,469762048,1056964608,956301312,905969664,1006632960,0,838860800,0,805306368,50331648,822083584,234881024,436207616,167772160,268435456,637534208,150994944,318767104,83886080,0,0,100663296,0,0,0,33554432,50331648,16777216,16777216,67108864,67108864,369098752,788529152,654311424,771751936,1207959552,268435456,1207959552,285212672,1459617792,973078528,1174405120,1610612736,419430400,855638016,637534208,1442840576,33554432,1241513984,603979776,889192448,1409286144,218103808,1174405120,989855744,822083584,520093696,1358954496,1577058304,1275068416,855638016,654311424,318767104,1258291200,536870912,520093696,1157627904,520093696,1191182336,218103808,1040187392,536870912,889192448,83886080,872415232,436207616,352321536,268435456,184549376,1073741824,268435456,50331648,16777216,100663296,16777216,0,0,0,0,0,0,0,0,0,83886080,0,637534208,385875968,1291845632,503316480,855638016,1174405120,1426063360,1325400064,1291845632,1124073472,1560281088,620756992,754974720,603979776,1895825408,251658240,1140850688,1023410176,704643072,1694498816,0,1325400064,1476395008,687865856,1358954496,1241513984,1358954496,1459617792,1560281088,1224736768,268435456,1124073472,738197504,587202560,1140850688,201326592,1258291200,318767104,1140850688,452984832,973078528,50331648,1090519040,436207616,218103808,469762048,134217728,419430400,268435456,16777216,83886080,33554432,0,50331648,0,0,0,0,0,0,0,0,0,50331648,285212672,218103808,1358954496,167772160,1140850688,100663296,1526726656,1711276032,1258291200,1023410176,1325400064,905969664,671088640,704643072,1140850688,1056964608,251658240,1207959552,402653184,1291845632,939524096,956301312,1258291200,838860800,1241513984,1140850688,1023410176,1392508928,1275068416,1493172224,402653184,1107296256,0,1140850688,1157627904,167772160,1459617792,0,956301312,234881024,1644167168,0,822083584,285212672,268435456,301989888,100663296,469762048,385875968,33554432,0,33554432,0,33554432,0,0,0,0,0,0,0,0,83886080,0,117440512,520093696,1258291200,117440512,1090519040,251658240,1426063360,1241513984,1426063360,805306368,838860800,1073741824,889192448,620756992,754974720,1275068416,603979776,1056964608,520093696,1593835520,1140850688,1308622848,1325400064,1006632960,905969664,553648128,1124073472,1728053248,1342177280,1056964608,1157627904,1241513984,721420288,1140850688,536870912,889192448,1543503872,369098752,671088640,33554432,1828716544,16777216,486539264,0,419430400,268435456,184549376,318767104,268435456,33554432,0,0,16777216,0,0,0,0,0,0,0,0,0,33554432,0,369098752,486539264,855638016,301989888,905969664,436207616,520093696,771751936,1476395008,1275068416,905969664,889192448,1023410176,469762048,1056964608,536870912,1426063360,721420288,838860800,1157627904,1224736768,1342177280,1157627904,1526726656,822083584,1426063360,419430400,855638016,1593835520,1174405120,1358954496,520093696,234881024,1174405120,687865856,1442840576,1207959552,1325400064,838860800,67108864,1090519040,134217728,771751936,201326592,553648128,16777216,369098752,83886080,0,67108864,16777216,0,0,0,0,0,0,0,0,0,0,0,50331648,0,0,570425344,1056964608,469762048,654311424,838860800,520093696,754974720,1409286144,1308622848,1660944384,0,872415232,771751936,1090519040,503316480,1560281088,402653184,1392508928,922746880,922746880,1375731712,1174405120,1023410176,570425344,754974720,822083584,721420288,905969664,1744830464,1593835520,1073741824,1073741824,536870912,989855744,1325400064,1157627904,1291845632,939524096,268435456,788529152,167772160,989855744,218103808,385875968,0,352321536,0,0,83886080,33554432,16777216,67108864,16777216,0,0,0,0,0,0,0,0,0,201326592,50331648,301989888,150994944,956301312,134217728,704643072,100663296,570425344,620756992,1140850688,721420288,1409286144,1006632960,1241513984,721420288,889192448,822083584,1325400064,1191182336,1275068416,1325400064,1090519040,956301312,956301312,436207616,452984832,989855744,1342177280,150994944,1744830464,788529152,1342177280,1241513984,0,788529152,956301312,1358954496,1107296256,956301312,402653184,687865856,0,822083584,67108864,184549376,134217728,100663296,33554432,67108864,33554432,0,0,100663296,16777216,0,0,0,0,0,0,0,0,0,0,0,503316480,134217728,1207959552,285212672,1526726656,687865856,285212672,352321536,1308622848,587202560,1811939328,285212672,1056964608,150994944,1593835520,184549376,1308622848,1140850688,872415232,1560281088,889192448,1325400064,1275068416,721420288,788529152,1023410176,922746880,939524096,553648128,822083584,1191182336,100663296,1174405120,1241513984,872415232,1040187392,1157627904,1174405120,671088640,352321536,67108864,989855744,251658240,167772160,0,0,16777216,67108864,0,0,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,201326592,301989888,234881024,218103808,654311424,553648128,1207959552,620756992,687865856,369098752,1644167168,587202560,1040187392,654311424,1124073472,1073741824,318767104,939524096,268435456,1509949440,939524096,1107296256,1191182336,822083584,503316480,637534208,754974720,570425344,620756992,1124073472,1056964608,1040187392,1124073472,1023410176,1275068416,1140850688,1308622848,1023410176,1224736768,620756992,1157627904,1291845632,150994944,150994944,33554432,83886080,0,0,50331648,67108864,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,83886080,268435456,318767104,352321536,738197504,83886080,788529152,905969664,402653184,721420288,1476395008,1107296256,771751936,1660944384,1107296256,1342177280,1308622848,1191182336,1224736768,1493172224,603979776,469762048,1191182336,788529152,687865856,671088640,385875968,402653184,1174405120,1056964608,1325400064,1090519040,956301312,973078528,1291845632,1291845632,973078528,939524096,1023410176,167772160,1459617792,134217728,285212672,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,16777216,184549376,285212672,285212672,570425344,385875968,285212672,503316480,419430400,889192448,1560281088,1677721600,536870912,1375731712,1560281088,1006632960,1509949440,469762048,872415232,1442840576,1325400064,1157627904,956301312,822083584,503316480,822083584,1040187392,1090519040,536870912,654311424,1291845632,1275068416,1073741824,973078528,922746880,1728053248,872415232,1073741824,637534208,553648128,637534208,33554432,167772160,0,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,67108864,0,67108864,201326592,201326592,419430400,385875968,318767104,738197504,855638016,1509949440,1744830464,1291845632,1174405120,603979776,1392508928,1409286144,1308622848,1090519040,989855744,1358954496,1157627904,268435456,234881024,1056964608,956301312,637534208,301989888,603979776,285212672,1308622848,1308622848,822083584,1811939328,1426063360,771751936,1409286144,587202560,1207959552,603979776,889192448,167772160,67108864,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,67108864,0,0,83886080,117440512,419430400,419430400,520093696,134217728,536870912,0,1308622848,1442840576,1728053248,1124073472,973078528,1677721600,1107296256,889192448,939524096,1207959552,1207959552,1140850688,1157627904,956301312,469762048,335544320,520093696,973078528,889192448,738197504,1459617792,1342177280,788529152,805306368,956301312,67108864,838860800,50331648,0,83886080,0,0,0,67108864,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,0,0,50331648,469762048,251658240,1023410176,553648128,469762048,687865856,721420288,1828716544,771751936,1627389952,167772160,369098752,654311424,1275068416,620756992,251658240,1275068416,1006632960,1342177280,973078528,620756992,603979776,318767104,469762048,369098752,620756992,1728053248,872415232,822083584,1275068416,771751936,1140850688,1140850688,83886080,184549376,16777216,167772160,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,16777216,0,0,419430400,603979776,671088640,201326592,805306368,402653184,100663296,1140850688,939524096,671088640,1509949440,1543503872,872415232,939524096,1325400064,1207959552,1056964608,687865856,687865856,671088640,587202560,872415232,301989888,419430400,318767104,822083584,419430400,872415232,1392508928,553648128,838860800,1124073472,0,117440512,16777216,16777216,33554432,0,0,0,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,16777216,0,218103808,385875968,100663296,0,234881024,503316480,520093696,721420288,1996488704,1593835520,1191182336,771751936,1644167168,469762048,570425344,939524096,771751936,1124073472,1308622848,1258291200,419430400,452984832,385875968,218103808,117440512,50331648,956301312,570425344,0,822083584,2113929216,452984832,16777216,117440512,0,67108864,0,0,0,33554432,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,33554432,67108864,0,16777216,0,50331648,201326592,671088640,905969664,2113929216,1627389952,1224736768,1560281088,1526726656,1224736768,1224736768,1426063360,989855744,1140850688,402653184,738197504,973078528,855638016,419430400,654311424,973078528,50331648,436207616,805306368,1291845632,0,16777216,268435456,0,100663296,117440512,0,33554432,0,50331648,0,0,134217728,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,50331648,16777216,419430400,402653184,1744830464,1090519040,1056964608,385875968,1275068416,1291845632,1342177280,637534208,503316480,301989888,654311424,1107296256,1241513984,520093696,251658240,201326592,469762048,167772160,369098752,218103808,167772160,83886080,33554432,0,0,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,100663296,50331648,872415232,419430400,318767104,402653184,805306368,486539264,520093696,251658240,268435456,0,0,0,150994944,16777216,134217728,268435456,385875968,33554432,33554432,83886080,67108864,33554432,0,0,0,16777216,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,33554432,0,0,184549376,67108864,0,16777216,218103808,0,0,16777216,134217728,16777216,0,0,33554432,0,0,83886080,117440512,16777216,16777216,0,0,0,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        ]);
        private var shimonData03:Vector.<uint> = Vector.<uint>([
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,0,67108864,100663296,0,0,0,0,33554432,33554432,0,0,16777216,0,16777216,0,0,33554432,0,0,33554432,0,0,33554432,50331648,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117440512,0,0,50331648,0,0,0,0,50331648,16777216,0,0,0,0,0,16777216,0,0,0,0,50331648,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,100663296,0,0,83886080,0,0,0,50331648,50331648,0,0,0,0,16777216,33554432,16777216,33554432,16777216,33554432,134217728,33554432,0,33554432,67108864,33554432,50331648,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117440512,33554432,0,16777216,33554432,0,0,33554432,16777216,33554432,67108864,83886080,50331648,16777216,33554432,50331648,50331648,0,0,33554432,33554432,0,0,50331648,0,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83886080,0,0,67108864,100663296,33554432,67108864,167772160,100663296,33554432,16777216,16777216,16777216,33554432,50331648,0,50331648,50331648,33554432,117440512,167772160,167772160,184549376,201326592,67108864,0,0,0,0,67108864,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,234881024,335544320,184549376,50331648,100663296,50331648,16777216,33554432,83886080,117440512,83886080,33554432,16777216,100663296,150994944,83886080,16777216,67108864,67108864,0,0,33554432,0,33554432,50331648,0,0,0,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100663296,33554432,167772160,369098752,285212672,83886080,33554432,67108864,16777216,16777216,50331648,117440512,167772160,117440512,33554432,0,150994944,33554432,0,33554432,469762048,687865856,486539264,218103808,150994944,184549376,318767104,385875968,318767104,251658240,184549376,83886080,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,0,67108864,50331648,0,134217728,436207616,520093696,335544320,201326592,67108864,0,0,0,33554432,67108864,0,117440512,167772160,83886080,67108864,50331648,33554432,67108864,33554432,16777216,83886080,83886080,16777216,16777216,67108864,33554432,33554432,33554432,33554432,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,0,0,0,16777216,16777216,16777216,0,83886080,83886080,973078528,788529152,738197504,436207616,402653184,33554432,83886080,83886080,67108864,134217728,251658240,234881024,150994944,469762048,369098752,167772160,268435456,184549376,301989888,201326592,218103808,67108864,167772160,268435456,301989888,402653184,234881024,335544320,402653184,436207616,150994944,67108864,83886080,0,134217728,0,134217728,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,184549376,318767104,587202560,251658240,16777216,335544320,33554432,0,100663296,100663296,50331648,0,0,83886080,100663296,33554432,0,0,0,150994944,134217728,218103808,83886080,83886080,50331648,167772160,50331648,150994944,402653184,16777216,402653184,100663296,234881024,218103808,234881024,301989888,150994944,100663296,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,0,16777216,50331648,0,67108864,83886080,167772160,33554432,117440512,285212672,335544320,385875968,385875968,318767104,234881024,234881024,285212672,268435456,218103808,385875968,335544320,234881024,268435456,184549376,201326592,150994944,184549376,150994944,50331648,201326592,33554432,0,0,0,16777216,50331648,134217728,117440512,83886080,16777216,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,16777216,0,0,16777216,67108864,100663296,285212672,0,335544320,117440512,285212672,318767104,167772160,83886080,100663296,83886080,50331648,67108864,100663296,83886080,16777216,134217728,67108864,0,16777216,50331648,167772160,335544320,486539264,486539264,134217728,268435456,436207616,402653184,1006632960,234881024,167772160,184549376,218103808,100663296,0,0,0,50331648,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,33554432,0,0,0,50331648,117440512,822083584,520093696,436207616,452984832,167772160,369098752,0,67108864,16777216,33554432,16777216,0,33554432,83886080,100663296,100663296,201326592,167772160,150994944,67108864,16777216,0,0,67108864,67108864,150994944,100663296,318767104,167772160,503316480,419430400,520093696,218103808,184549376,201326592,201326592,67108864,335544320,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,33554432,33554432,50331648,100663296,134217728,385875968,16777216,33554432,16777216,83886080,16777216,201326592,385875968,301989888,268435456,218103808,184549376,201326592,268435456,335544320,385875968,184549376,167772160,234881024,201326592,234881024,150994944,251658240,301989888,352321536,67108864,117440512,0,117440512,67108864,0,50331648,218103808,167772160,268435456,385875968,285212672,654311424,67108864,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,67108864,83886080,100663296,83886080,83886080,67108864,0,184549376,83886080,0,150994944,268435456,754974720,419430400,83886080,67108864,33554432,16777216,16777216,33554432,67108864,117440512,67108864,0,83886080,0,100663296,33554432,184549376,251658240,452984832,268435456,905969664,402653184,872415232,402653184,0,150994944,33554432,0,0,33554432,0,201326592,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,67108864,100663296,150994944,150994944,100663296,16777216,0,83886080,0,83886080,251658240,184549376,251658240,0,0,16777216,33554432,67108864,100663296,83886080,33554432,16777216,16777216,50331648,0,100663296,0,100663296,0,50331648,50331648,83886080,67108864,134217728,251658240,1124073472,637534208,452984832,318767104,369098752,318767104,184549376,167772160,134217728,33554432,83886080,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,117440512,67108864,0,33554432,0,50331648,50331648,16777216,67108864,83886080,100663296,100663296,50331648,50331648,134217728,251658240,100663296,201326592,268435456,570425344,201326592,620756992,0,335544320,184549376,587202560,721420288,218103808,956301312,369098752,234881024,100663296,134217728,301989888,134217728,0,167772160,117440512,50331648,318767104,419430400,50331648,301989888,301989888,134217728,134217728,419430400,167772160,117440512,83886080,0,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,33554432,33554432,50331648,67108864,83886080,50331648,0,201326592,0,234881024,33554432,352321536,167772160,50331648,16777216,16777216,16777216,16777216,33554432,134217728,218103808,0,33554432,167772160,83886080,268435456,0,134217728,134217728,335544320,0,335544320,335544320,553648128,436207616,452984832,150994944,587202560,452984832,268435456,452984832,704643072,352321536,0,16777216,0,67108864,83886080,16777216,33554432,0,0,0,0,50331648,33554432,0,33554432,0,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,50331648,67108864,16777216,83886080,117440512,218103808,16777216,83886080,0,0,67108864,33554432,33554432,100663296,134217728,117440512,83886080,83886080,100663296,134217728,0,16777216,0,16777216,0,16777216,16777216,33554432,0,0,16777216,0,83886080,167772160,33554432,251658240,318767104,503316480,838860800,788529152,570425344,587202560,301989888,352321536,100663296,0,100663296,150994944,50331648,100663296,33554432,67108864,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,50331648,184549376,184549376,268435456,251658240,201326592,201326592,251658240,184549376,234881024,167772160,134217728,167772160,218103808,184549376,117440512,67108864,301989888,184549376,352321536,234881024,436207616,620756992,587202560,805306368,184549376,956301312,704643072,754974720,402653184,0,150994944,100663296,67108864,0,0,50331648,134217728,0,16777216,520093696,436207616,318767104,335544320,218103808,218103808,268435456,285212672,0,251658240,285212672,201326592,83886080,50331648,0,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,50331648,67108864,67108864,218103808,83886080,117440512,0,67108864,100663296,352321536,318767104,184549376,67108864,0,0,50331648,67108864,67108864,67108864,117440512,117440512,318767104,67108864,134217728,134217728,184549376,402653184,520093696,1409286144,721420288,234881024,620756992,385875968,771751936,1660944384,620756992,838860800,687865856,385875968,369098752,402653184,201326592,0,67108864,83886080,385875968,285212672,335544320,201326592,234881024,0,83886080,218103808,234881024,134217728,33554432,0,0,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,50331648,67108864,67108864,83886080,0,0,0,33554432,83886080,100663296,0,16777216,0,0,83886080,167772160,184549376,150994944,134217728,33554432,184549376,0,0,83886080,0,83886080,0,167772160,0,50331648,0,50331648,16777216,184549376,536870912,184549376,234881024,318767104,536870912,738197504,704643072,570425344,536870912,134217728,167772160,67108864,0,251658240,218103808,184549376,150994944,0,0,0,33554432,134217728,100663296,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,67108864,0,301989888,318767104,637534208,469762048,419430400,50331648,83886080,117440512,201326592,335544320,385875968,352321536,318767104,285212672,218103808,251658240,234881024,218103808,922746880,654311424,1140850688,805306368,268435456,201326592,67108864,201326592,503316480,285212672,218103808,218103808,0,67108864,33554432,0,0,335544320,553648128,570425344,301989888,318767104,100663296,134217728,50331648,184549376,100663296,201326592,150994944,100663296,16777216,83886080,268435456,268435456,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,33554432,33554432,218103808,0,687865856,335544320,822083584,234881024,100663296,83886080,50331648,33554432,50331648,67108864,83886080,150994944,234881024,83886080,285212672,201326592,318767104,184549376,452984832,385875968,587202560,1174405120,1325400064,402653184,503316480,469762048,234881024,822083584,486539264,973078528,855638016,721420288,587202560,369098752,134217728,0,0,134217728,419430400,822083584,1224736768,184549376,167772160,33554432,16777216,150994944,251658240,234881024,134217728,33554432,0,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,0,16777216,67108864,83886080,117440512,167772160,251658240,184549376,201326592,184549376,50331648,0,50331648,67108864,0,83886080,83886080,83886080,318767104,0,201326592,33554432,100663296,33554432,0,16777216,0,100663296,50331648,16777216,100663296,0,0,167772160,184549376,369098752,117440512,0,83886080,402653184,587202560,671088640,687865856,905969664,587202560,301989888,50331648,0,587202560,318767104,503316480,352321536,452984832,0,50331648,0,402653184,1023410176,352321536,83886080,0,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,33554432,100663296,100663296,50331648,50331648,83886080,0,0,0,16777216,150994944,335544320,301989888,33554432,369098752,201326592,486539264,402653184,352321536,352321536,402653184,553648128,671088640,134217728,167772160,335544320,1560281088,1577058304,1291845632,1140850688,1140850688,218103808,100663296,83886080,0,822083584,905969664,872415232,150994944,0,0,234881024,50331648,83886080,318767104,1124073472,452984832,184549376,33554432,50331648,218103808,369098752,419430400,301989888,184549376,184549376,0,117440512,973078528,872415232,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,0,16777216,67108864,100663296,83886080,33554432,33554432,83886080,134217728,100663296,134217728,251658240,469762048,671088640,553648128,234881024,301989888,16777216,0,150994944,83886080,67108864,50331648,0,16777216,0,150994944,0,201326592,150994944,268435456,704643072,570425344,234881024,1023410176,1358954496,16777216,0,234881024,150994944,285212672,1241513984,1124073472,754974720,100663296,33554432,0,33554432,520093696,318767104,218103808,369098752,0,0,301989888,0,822083584,520093696,167772160,0,352321536,83886080,16777216,150994944,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,33554432,50331648,67108864,83886080,117440512,150994944,201326592,16777216,0,50331648,33554432,16777216,33554432,16777216,67108864,0,369098752,201326592,100663296,285212672,436207616,1174405120,771751936,67108864,251658240,520093696,637534208,536870912,369098752,33554432,150994944,0,0,402653184,973078528,1124073472,452984832,268435456,0,134217728,33554432,822083584,1442840576,1023410176,452984832,67108864,0,117440512,134217728,687865856,687865856,16777216,83886080,83886080,436207616,318767104,520093696,201326592,50331648,0,134217728,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,50331648,16777216,0,33554432,100663296,150994944,150994944,134217728,184549376,50331648,50331648,67108864,0,16777216,218103808,385875968,570425344,671088640,369098752,687865856,1241513984,671088640,654311424,402653184,218103808,0,654311424,1308622848,1744830464,1174405120,1342177280,1023410176,1090519040,822083584,905969664,251658240,234881024,570425344,570425344,754974720,1979711488,1207959552,0,50331648,486539264,553648128,587202560,805306368,402653184,167772160,0,402653184,268435456,318767104,805306368,234881024,100663296,167772160,167772160,150994944,285212672,150994944,67108864,134217728,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,33554432,33554432,50331648,83886080,150994944,184549376,100663296,0,0,16777216,134217728,150994944,117440512,201326592,268435456,201326592,167772160,134217728,134217728,0,352321536,0,0,150994944,83886080,134217728,50331648,16777216,67108864,0,16777216,251658240,822083584,1476395008,1426063360,1224736768,838860800,16777216,134217728,268435456,771751936,1728053248,1358954496,838860800,0,50331648,0,117440512,553648128,855638016,218103808,201326592,0,150994944,452984832,352321536,520093696,318767104,0,83886080,587202560,738197504,201326592,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,50331648,33554432,67108864,67108864,83886080,117440512,134217728,67108864,0,100663296,134217728,184549376,150994944,50331648,50331648,50331648,0,16777216,67108864,50331648,100663296,184549376,0,285212672,268435456,536870912,822083584,738197504,973078528,654311424,1023410176,0,50331648,33554432,150994944,16777216,1140850688,1493172224,1392508928,1459617792,754974720,83886080,0,117440512,989855744,1577058304,1426063360,570425344,16777216,285212672,201326592,268435456,905969664,268435456,0,134217728,184549376,335544320,553648128,469762048,67108864,0,503316480,721420288,251658240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,50331648,33554432,67108864,67108864,33554432,33554432,83886080,67108864,33554432,268435456,67108864,0,16777216,0,67108864,419430400,721420288,1124073472,385875968,402653184,603979776,889192448,1426063360,1291845632,973078528,1140850688,687865856,1191182336,1627389952,1275068416,1476395008,452984832,989855744,1124073472,838860800,335544320,33554432,335544320,1509949440,939524096,1073741824,1476395008,553648128,285212672,83886080,956301312,989855744,1241513984,1140850688,251658240,117440512,83886080,184549376,402653184,369098752,486539264,0,16777216,0,419430400,704643072,352321536,201326592,301989888,218103808,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,33554432,0,0,117440512,150994944,117440512,50331648,33554432,100663296,167772160,150994944,83886080,50331648,0,50331648,0,167772160,335544320,704643072,570425344,201326592,167772160,117440512,788529152,905969664,134217728,50331648,318767104,0,100663296,0,100663296,150994944,0,234881024,285212672,603979776,1006632960,889192448,805306368,939524096,503316480,822083584,0,603979776,1275068416,1124073472,603979776,603979776,0,184549376,771751936,889192448,805306368,436207616,268435456,50331648,100663296,234881024,369098752,838860800,352321536,67108864,419430400,251658240,603979776,402653184,0,0,0,16777216,0,16777216,0,0,0,0,0,0,0,0,50331648,0,0,83886080,134217728,167772160,100663296,0,0,83886080,201326592,201326592,50331648,0,0,100663296,83886080,134217728,201326592,134217728,83886080,369098752,150994944,184549376,369098752,603979776,134217728,0,201326592,134217728,268435456,553648128,687865856,1006632960,603979776,671088640,469762048,100663296,285212672,0,0,285212672,335544320,1040187392,1140850688,1761607680,1275068416,855638016,50331648,0,872415232,1476395008,1191182336,1056964608,16777216,0,251658240,973078528,973078528,973078528,369098752,0,134217728,268435456,452984832,0,0,369098752,184549376,486539264,1358954496,184549376,0,0,0,67108864,0,0,0,0,0,0,0,0,33554432,0,50331648,100663296,67108864,100663296,117440512,50331648,117440512,100663296,100663296,67108864,33554432,0,33554432,100663296,218103808,67108864,167772160,167772160,134217728,268435456,167772160,838860800,301989888,100663296,167772160,721420288,754974720,889192448,1241513984,637534208,721420288,1375731712,889192448,1140850688,1426063360,1291845632,1677721600,1325400064,570425344,369098752,0,587202560,503316480,1509949440,1375731712,1107296256,1275068416,436207616,0,50331648,553648128,1090519040,486539264,721420288,0,167772160,117440512,671088640,587202560,452984832,117440512,100663296,301989888,369098752,771751936,268435456,0,989855744,1476395008,1342177280,83886080,201326592,67108864,0,0,0,0,0,0,0,0,0,0,16777216,117440512,117440512,33554432,33554432,134217728,150994944,150994944,50331648,0,50331648,117440512,117440512,67108864,16777216,184549376,33554432,0,201326592,469762048,469762048,0,50331648,452984832,704643072,671088640,754974720,687865856,385875968,335544320,335544320,301989888,251658240,402653184,1124073472,1308622848,1073741824,587202560,754974720,1006632960,637534208,1342177280,771751936,318767104,201326592,167772160,536870912,1275068416,1308622848,1358954496,905969664,0,0,402653184,1342177280,1241513984,1140850688,0,100663296,251658240,469762048,603979776,117440512,0,385875968,1191182336,872415232,134217728,184549376,721420288,1358954496,285212672,0,0,33554432,0,0,0,0,0,0,0,0,0,0,83886080,167772160,150994944,134217728,100663296,0,0,50331648,201326592,251658240,167772160,50331648,16777216,50331648,0,436207616,251658240,184549376,167772160,285212672,369098752,436207616,738197504,100663296,0,16777216,16777216,201326592,117440512,0,872415232,536870912,889192448,1207959552,905969664,1073741824,83886080,83886080,134217728,218103808,1224736768,1577058304,1224736768,1392508928,0,0,738197504,1107296256,1207959552,1090519040,1509949440,1342177280,50331648,0,150994944,1056964608,1442840576,234881024,0,687865856,570425344,318767104,268435456,0,134217728,503316480,838860800,201326592,16777216,150994944,1543503872,234881024,0,150994944,0,0,0,0,0,0,0,0,0,16777216,117440512,150994944,83886080,67108864,100663296,67108864,67108864,184549376,285212672,251658240,117440512,16777216,83886080,218103808,335544320,553648128,184549376,419430400,436207616,285212672,251658240,134217728,134217728,117440512,301989888,335544320,687865856,822083584,570425344,1040187392,1207959552,1073741824,1073741824,1207959552,939524096,1577058304,1358954496,1258291200,1207959552,402653184,100663296,134217728,452984832,1140850688,1073741824,1543503872,838860800,16777216,218103808,1124073472,1241513984,1258291200,1241513984,687865856,50331648,318767104,1040187392,1124073472,570425344,0,50331648,1006632960,486539264,956301312,0,50331648,1174405120,1107296256,1358954496,134217728,100663296,0,0,33554432,0,0,0,0,0,0,0,0,33554432,33554432,100663296,100663296,0,50331648,184549376,234881024,234881024,167772160,83886080,67108864,67108864,83886080,150994944,218103808,134217728,83886080,0,201326592,150994944,33554432,201326592,436207616,268435456,436207616,318767104,218103808,671088640,486539264,67108864,620756992,184549376,100663296,0,620756992,570425344,184549376,402653184,620756992,1342177280,1258291200,1191182336,1140850688,150994944,16777216,16777216,385875968,1476395008,1426063360,889192448,469762048,0,369098752,1358954496,822083584,1006632960,83886080,117440512,301989888,922746880,1291845632,117440512,0,117440512,671088640,973078528,184549376,0,822083584,1560281088,1040187392,0,67108864,134217728,0,0,0,0,0,0,0,0,0,33554432,0,0,83886080,184549376,268435456,251658240,134217728,0,0,0,33554432,83886080,67108864,33554432,16777216,83886080,201326592,285212672,369098752,268435456,469762048,369098752,251658240,167772160,83886080,50331648,100663296,33554432,0,83886080,352321536,654311424,1107296256,1073741824,1258291200,1258291200,436207616,503316480,369098752,150994944,83886080,989855744,922746880,1124073472,1140850688,1023410176,33554432,100663296,603979776,1224736768,1375731712,1107296256,352321536,67108864,671088640,1090519040,1174405120,922746880,234881024,0,805306368,620756992,771751936,234881024,671088640,754974720,771751936,452984832,50331648,620756992,1694498816,1342177280,50331648,0,117440512,0,0,0,0,0,0,0,0,83886080,0,0,167772160,234881024,117440512,0,0,134217728,167772160,134217728,16777216,0,83886080,167772160,184549376,318767104,100663296,33554432,167772160,167772160,16777216,0,117440512,385875968,335544320,654311424,419430400,1090519040,1207959552,1107296256,520093696,671088640,889192448,738197504,1056964608,956301312,1291845632,1090519040,1744830464,1325400064,385875968,50331648,285212672,486539264,520093696,1509949440,1577058304,1107296256,536870912,234881024,1107296256,1509949440,1627389952,469762048,654311424,0,318767104,822083584,1073741824,738197504,100663296,201326592,771751936,905969664,1677721600,553648128,1174405120,754974720,822083584,536870912,1442840576,754974720,201326592,0,50331648,0,0,0,0,0,0,0,0,16777216,100663296,201326592,184549376,67108864,16777216,67108864,184549376,150994944,0,0,16777216,184549376,218103808,150994944,83886080,117440512,100663296,134217728,201326592,167772160,117440512,234881024,419430400,184549376,369098752,419430400,469762048,234881024,100663296,0,134217728,285212672,50331648,134217728,50331648,251658240,234881024,419430400,754974720,1493172224,2113929216,1291845632,452984832,1157627904,134217728,0,721420288,1140850688,1191182336,1207959552,234881024,100663296,973078528,1174405120,855638016,570425344,16777216,503316480,1073741824,771751936,1124073472,268435456,201326592,536870912,889192448,234881024,50331648,855638016,1325400064,1560281088,838860800,150994944,268435456,0,0,0,0,0,0,0,0,0,0,83886080,134217728,117440512,67108864,67108864,134217728,134217728,83886080,0,50331648,134217728,167772160,117440512,50331648,16777216,33554432,301989888,385875968,301989888,117440512,167772160,419430400,486539264,352321536,50331648,251658240,16777216,0,402653184,754974720,989855744,1694498816,1795162112,1191182336,788529152,1107296256,738197504,436207616,754974720,0,0,0,452984832,754974720,1493172224,1207959552,1375731712,687865856,117440512,738197504,1526726656,1342177280,872415232,184549376,0,771751936,1140850688,1224736768,0,100663296,402653184,1191182336,587202560,335544320,0,637534208,939524096,419430400,218103808,402653184,1191182336,822083584,83886080,100663296,0,67108864,0,0,0,0,0,0,0,0,117440512,50331648,0,0,117440512,201326592,100663296,0,117440512,167772160,117440512,0,0,83886080,285212672,402653184,251658240,83886080,100663296,318767104,419430400,285212672,117440512,50331648,285212672,0,754974720,1258291200,1476395008,1207959552,1375731712,1409286144,1073741824,1325400064,1526726656,1459617792,1157627904,1207959552,1191182336,1644167168,1174405120,922746880,536870912,0,218103808,167772160,956301312,1358954496,1140850688,218103808,671088640,520093696,1342177280,1056964608,788529152,184549376,486539264,1191182336,1006632960,1224736768,0,33554432,1140850688,587202560,503316480,301989888,419430400,671088640,805306368,16777216,1023410176,1258291200,989855744,301989888,0,150994944,0,0,0,0,0,0,0,0,16777216,33554432,83886080,100663296,50331648,0,33554432,117440512,318767104,150994944,50331648,117440512,268435456,335544320,268435456,201326592,33554432,285212672,436207616,352321536,201326592,201326592,335544320,452984832,503316480,620756992,671088640,218103808,0,0,67108864,50331648,0,0,0,0,285212672,285212672,452984832,234881024,486539264,1308622848,1509949440,1224736768,1090519040,385875968,201326592,603979776,1023410176,1090519040,1124073472,285212672,16777216,1056964608,1073741824,486539264,520093696,218103808,117440512,973078528,905969664,671088640,67108864,100663296,738197504,285212672,570425344,889192448,654311424,1241513984,234881024,150994944,1207959552,973078528,67108864,117440512,0,0,0,0,0,0,0,0,50331648,83886080,134217728,117440512,16777216,0,83886080,285212672,100663296,67108864,218103808,469762048,419430400,134217728,33554432,167772160,520093696,402653184,134217728,0,251658240,620756992,536870912,184549376,201326592,0,0,83886080,905969664,1140850688,1342177280,1509949440,1845493760,1744830464,1509949440,1040187392,1291845632,1090519040,0,117440512,251658240,16777216,0,218103808,553648128,1056964608,1157627904,771751936,285212672,704643072,1593835520,1191182336,603979776,100663296,134217728,637534208,1140850688,989855744,285212672,33554432,469762048,1409286144,503316480,469762048,318767104,1224736768,654311424,385875968,469762048,301989888,553648128,100663296,83886080,1006632960,33554432,0,0,0,0,0,0,0,0,0,83886080,83886080,67108864,33554432,33554432,83886080,150994944,184549376,16777216,100663296,218103808,218103808,100663296,33554432,251658240,520093696,83886080,100663296,251658240,402653184,251658240,16777216,67108864,318767104,536870912,587202560,1610612736,1509949440,1224736768,939524096,1493172224,1426063360,1325400064,1040187392,1056964608,1577058304,1392508928,1426063360,1526726656,1409286144,872415232,1191182336,922746880,352321536,402653184,150994944,117440512,587202560,1358954496,50331648,67108864,872415232,805306368,1258291200,771751936,301989888,956301312,905969664,637534208,503316480,218103808,369098752,654311424,1107296256,318767104,301989888,50331648,1056964608,352321536,167772160,1140850688,1124073472,0,335544320,0,0,0,0,0,0,0,0,0,0,0,50331648,67108864,0,16777216,134217728,150994944,50331648,369098752,385875968,201326592,67108864,218103808,452984832,285212672,0,16777216,570425344,738197504,335544320,150994944,503316480,805306368,788529152,553648128,503316480,0,0,301989888,218103808,67108864,1174405120,1174405120,83886080,117440512,117440512,16777216,0,973078528,989855744,989855744,117440512,285212672,687865856,1073741824,973078528,704643072,0,872415232,754974720,788529152,234881024,83886080,1040187392,1107296256,721420288,33554432,33554432,754974720,822083584,838860800,587202560,788529152,251658240,268435456,1174405120,536870912,318767104,402653184,0,33554432,1526726656,1207959552,0,67108864,33554432,0,0,33554432,16777216,0,0,0,16777216,67108864,285212672,100663296,0,167772160,100663296,0,268435456,369098752,150994944,50331648,268435456,536870912,301989888,33554432,335544320,469762048,352321536,201326592,83886080,553648128,754974720,234881024,83886080,0,301989888,838860800,1308622848,1593835520,1426063360,1979711488,1593835520,1879048192,1509949440,1627389952,1543503872,1040187392,318767104,687865856,301989888,738197504,738197504,687865856,419430400,0,251658240,738197504,956301312,167772160,402653184,1308622848,687865856,872415232,117440512,318767104,285212672,939524096,872415232,0,301989888,922746880,419430400,520093696,989855744,436207616,1258291200,402653184,469762048,469762048,620756992,134217728,637534208,1157627904,1040187392,0,0,0,0,0,0,0,0,16777216,33554432,268435456,67108864,50331648,150994944,100663296,50331648,184549376,352321536,50331648,218103808,134217728,402653184,234881024,167772160,654311424,335544320,318767104,0,201326592,301989888,570425344,0,234881024,1090519040,1191182336,1023410176,704643072,503316480,486539264,150994944,201326592,956301312,234881024,520093696,1174405120,1140850688,469762048,1426063360,1627389952,922746880,671088640,67108864,67108864,738197504,1124073472,603979776,268435456,385875968,1107296256,268435456,16777216,822083584,1308622848,1291845632,50331648,184549376,234881024,318767104,1677721600,285212672,553648128,1073741824,721420288,150994944,587202560,402653184,352321536,201326592,33554432,905969664,1241513984,251658240,335544320,1241513984,16777216,150994944,0,0,0,0,0,16777216,50331648,67108864,67108864,67108864,134217728,150994944,100663296,184549376,234881024,100663296,268435456,134217728,352321536,285212672,0,335544320,637534208,16777216,100663296,352321536,150994944,218103808,0,318767104,687865856,754974720,402653184,0,100663296,1073741824,1308622848,1392508928,1191182336,1459617792,1543503872,1610612736,1493172224,520093696,0,134217728,486539264,922746880,805306368,872415232,687865856,134217728,268435456,234881024,553648128,822083584,570425344,838860800,956301312,50331648,0,872415232,1459617792,1040187392,570425344,167772160,671088640,1157627904,671088640,0,503316480,369098752,167772160,16777216,855638016,872415232,218103808,419430400,335544320,1224736768,570425344,318767104,0,0,16777216,0,0,0,16777216,33554432,67108864,83886080,0,184549376,117440512,33554432,234881024,251658240,67108864,33554432,301989888,318767104,167772160,100663296,436207616,385875968,0,301989888,335544320,33554432,150994944,251658240,838860800,687865856,0,234881024,637534208,1308622848,1224736768,1409286144,1241513984,1258291200,1191182336,1124073472,1073741824,1224736768,1124073472,1191182336,956301312,1174405120,1140850688,704643072,251658240,419430400,889192448,822083584,956301312,352321536,553648128,872415232,603979776,251658240,1157627904,1409286144,419430400,134217728,83886080,1107296256,1291845632,1006632960,0,0,922746880,1023410176,0,838860800,452984832,553648128,100663296,318767104,553648128,150994944,33554432,1694498816,1728053248,285212672,67108864,0,16777216,16777216,0,0,0,16777216,50331648,50331648,201326592,100663296,0,100663296,268435456,117440512,33554432,285212672,83886080,184549376,100663296,570425344,503316480,50331648,385875968,570425344,251658240,218103808,285212672,469762048,452984832,218103808,872415232,1442840576,989855744,654311424,452984832,922746880,1056964608,939524096,1191182336,1459617792,1090519040,1174405120,1090519040,67108864,0,117440512,939524096,922746880,1056964608,234881024,117440512,184549376,922746880,738197504,654311424,117440512,1023410176,738197504,134217728,587202560,956301312,1476395008,352321536,335544320,385875968,1124073472,1392508928,587202560,67108864,369098752,402653184,67108864,0,268435456,603979776,0,201326592,234881024,0,469762048,1308622848,805306368,33554432,67108864,0,0,0,0,0,16777216,16777216,16777216,184549376,0,50331648,218103808,83886080,150994944,285212672,150994944,83886080,285212672,620756992,553648128,16777216,201326592,637534208,150994944,33554432,436207616,50331648,268435456,620756992,1224736768,1509949440,671088640,184549376,218103808,1325400064,1644167168,1476395008,1476395008,1392508928,1241513984,1124073472,1291845632,1241513984,1006632960,1023410176,1157627904,184549376,234881024,1056964608,1056964608,1275068416,536870912,335544320,285212672,922746880,805306368,83886080,738197504,1023410176,134217728,285212672,1090519040,1023410176,1174405120,754974720,285212672,486539264,1241513984,1023410176,134217728,184549376,671088640,520093696,218103808,452984832,570425344,0,33554432,855638016,251658240,167772160,67108864,16777216,16777216,0,0,0,0,16777216,50331648,33554432,33554432,0,33554432,234881024,167772160,0,301989888,436207616,0,184549376,754974720,620756992,0,268435456,486539264,33554432,100663296,201326592,150994944,419430400,83886080,1526726656,989855744,134217728,620756992,1493172224,1476395008,1493172224,1073741824,1157627904,721420288,251658240,939524096,822083584,402653184,855638016,402653184,872415232,1442840576,1275068416,721420288,553648128,469762048,956301312,1023410176,1006632960,402653184,738197504,1140850688,1258291200,83886080,436207616,385875968,402653184,1258291200,268435456,654311424,1308622848,1342177280,218103808,50331648,469762048,1073741824,486539264,67108864,83886080,436207616,100663296,134217728,218103808,134217728,0,1023410176,150994944,0,201326592,50331648,0,0,0,16777216,67108864,100663296,83886080,67108864,83886080,251658240,218103808,67108864,134217728,301989888,301989888,201326592,469762048,369098752,0,385875968,587202560,150994944,218103808,486539264,0,452984832,671088640,989855744,1124073472,251658240,973078528,1493172224,1157627904,1040187392,671088640,956301312,1627389952,1509949440,1224736768,1426063360,1275068416,1224736768,1174405120,184549376,385875968,251658240,721420288,788529152,754974720,872415232,771751936,452984832,1124073472,1275068416,989855744,352321536,1073741824,1090519040,201326592,922746880,771751936,822083584,805306368,469762048,855638016,1140850688,1610612736,1056964608,117440512,1073741824,1040187392,603979776,150994944,553648128,536870912,0,0,301989888,251658240,0,234881024,620756992,0,0,0,67108864,0,0,150994944,83886080,0,50331648,134217728,369098752,0,0,285212672,301989888,0,352321536,385875968,50331648,134217728,671088640,33554432,318767104,620756992,100663296,486539264,469762048,436207616,1207959552,536870912,1174405120,1593835520,1056964608,738197504,1073741824,1375731712,1526726656,1157627904,1291845632,788529152,385875968,520093696,134217728,905969664,939524096,1224736768,1358954496,570425344,150994944,620756992,637534208,1023410176,738197504,402653184,788529152,989855744,1006632960,503316480,553648128,469762048,570425344,1124073472,520093696,452984832,855638016,788529152,83886080,587202560,1174405120,1191182336,285212672,385875968,721420288,587202560,134217728,603979776,0,16777216,620756992,402653184,100663296,687865856,1795162112,419430400,83886080,16777216,0,33554432,0,1207959552,402653184,83886080,33554432,50331648,134217728,50331648,234881024,452984832,83886080,352321536,385875968,100663296,150994944,553648128,117440512,234881024,587202560,134217728,318767104,587202560,184549376,1325400064,587202560,922746880,1157627904,352321536,469762048,1543503872,1392508928,1358954496,1426063360,989855744,1090519040,503316480,654311424,1275068416,503316480,352321536,553648128,184549376,1124073472,1207959552,771751936,419430400,587202560,385875968,1275068416,1224736768,721420288,67108864,973078528,1107296256,1124073472,436207616,369098752,1107296256,905969664,318767104,67108864,654311424,1442840576,603979776,0,1107296256,1392508928,83886080,352321536,452984832,167772160,184549376,167772160,822083584,0,452984832,1090519040,318767104,117440512,117440512,0,0,83886080,50331648,16777216,167772160,0,16777216,738197504,134217728,0,134217728,201326592,0,33554432,654311424,335544320,67108864,687865856,83886080,117440512,536870912,117440512,184549376,369098752,50331648,771751936,1174405120,872415232,1526726656,201326592,1409286144,1275068416,1023410176,788529152,1325400064,1291845632,1610612736,1392508928,721420288,587202560,1224736768,1325400064,1409286144,1040187392,771751936,419430400,100663296,989855744,1090519040,1040187392,184549376,587202560,1107296256,872415232,1090519040,620756992,637534208,671088640,855638016,1023410176,100663296,671088640,922746880,922746880,83886080,1124073472,1593835520,704643072,285212672,956301312,1258291200,67108864,318767104,570425344,100663296,67108864,570425344,201326592,385875968,1459617792,1375731712,0,117440512,0,83886080,0,0,0,67108864,83886080,218103808,50331648,33554432,83886080,402653184,134217728,0,587202560,318767104,184549376,503316480,385875968,67108864,536870912,150994944,150994944,352321536,201326592,603979776,922746880,469762048,1207959552,402653184,1040187392,1426063360,788529152,1207959552,1107296256,1426063360,1308622848,721420288,855638016,452984832,100663296,822083584,838860800,922746880,1140850688,1342177280,1157627904,1375731712,369098752,285212672,1056964608,1258291200,1140850688,167772160,419430400,1275068416,1056964608,822083584,33554432,771751936,822083584,838860800,486539264,503316480,1275068416,838860800,385875968,1174405120,1073741824,335544320,654311424,1375731712,419430400,50331648,452984832,16777216,117440512,587202560,268435456,419430400,369098752,1426063360,654311424,0,0,83886080,0,67108864,0,0,100663296,301989888,83886080,117440512,385875968,184549376,0,369098752,637534208,0,385875968,436207616,134217728,352321536,603979776,0,385875968,536870912,201326592,704643072,385875968,1056964608,822083584,1056964608,1241513984,352321536,1627389952,1241513984,570425344,1224736768,1426063360,1442840576,1358954496,1761607680,771751936,1224736768,989855744,335544320,0,419430400,1073741824,1426063360,1644167168,536870912,100663296,822083584,1224736768,1006632960,553648128,251658240,973078528,973078528,1140850688,184549376,536870912,771751936,872415232,771751936,218103808,704643072,654311424,150994944,1073741824,1040187392,402653184,285212672,318767104,201326592,117440512,134217728,486539264,67108864,771751936,486539264,167772160,1241513984,1358954496,0,0,0,33554432,0,50331648,234881024,184549376,0,0,553648128,150994944,0,167772160,486539264,117440512,268435456,536870912,184549376,234881024,536870912,0,385875968,620756992,0,1006632960,520093696,805306368,989855744,385875968,1107296256,687865856,1224736768,1040187392,452984832,1040187392,1073741824,1543503872,1543503872,654311424,251658240,704643072,1140850688,1426063360,1207959552,1291845632,1107296256,201326592,553648128,620756992,1174405120,1040187392,973078528,419430400,939524096,1073741824,1073741824,704643072,553648128,1358954496,1056964608,922746880,989855744,570425344,738197504,1140850688,0,1140850688,603979776,402653184,822083584,452984832,83886080,671088640,318767104,117440512,184549376,419430400,352321536,100663296,1291845632,855638016,0,1610612736,1275068416,150994944,16777216,16777216,150994944,0,419430400,0,16777216,218103808,469762048,0,285212672,838860800,452984832,100663296,687865856,251658240,83886080,738197504,0,184549376,838860800,218103808,285212672,973078528,654311424,1241513984,218103808,1107296256,687865856,1107296256,1056964608,1459617792,1442840576,1124073472,1392508928,1442840576,1090519040,536870912,822083584,788529152,704643072,402653184,369098752,335544320,788529152,1006632960,1174405120,738197504,486539264,1140850688,1174405120,1174405120,0,0,687865856,1207959552,268435456,218103808,1493172224,1342177280,285212672,671088640,385875968,822083584,536870912,184549376,1207959552,520093696,318767104,1124073472,603979776,117440512,150994944,0,117440512,536870912,520093696,83886080,385875968,1392508928,771751936,268435456,251658240,285212672,16777216,0,0,184549376,0,150994944,117440512,318767104,33554432,100663296,520093696,620756992,0,268435456,436207616,83886080,385875968,385875968,117440512,1056964608,436207616,369098752,989855744,117440512,1275068416,402653184,1140850688,1006632960,1090519040,1174405120,436207616,1375731712,1308622848,1358954496,1358954496,1090519040,989855744,1224736768,1124073472,1006632960,905969664,1308622848,939524096,1023410176,369098752,587202560,905969664,1308622848,1090519040,201326592,452984832,1023410176,989855744,1241513984,402653184,419430400,1308622848,905969664,301989888,1124073472,1275068416,301989888,1258291200,352321536,956301312,603979776,83886080,536870912,50331648,0,134217728,67108864,0,318767104,436207616,0,436207616,419430400,0,1258291200,1577058304,83886080,369098752,1207959552,33554432,0,100663296,167772160,0,318767104,218103808,369098752,16777216,134217728,704643072,167772160,83886080,285212672,167772160,234881024,503316480,83886080,721420288,620756992,100663296,587202560,150994944,922746880,956301312,889192448,1358954496,503316480,1459617792,553648128,1291845632,1241513984,1593835520,1375731712,973078528,1124073472,1157627904,301989888,16777216,654311424,671088640,486539264,1073741824,872415232,872415232,536870912,117440512,754974720,1258291200,1275068416,16777216,469762048,1342177280,1040187392,1241513984,872415232,536870912,1056964608,603979776,301989888,1358954496,620756992,1224736768,989855744,939524096,1627389952,218103808,654311424,603979776,301989888,1040187392,134217728,0,83886080,520093696,301989888,301989888,50331648,603979776,150994944,318767104,1392508928,50331648,285212672,0,234881024,0,16777216,402653184,452984832,419430400,0,83886080,738197504,318767104,0,402653184,352321536,50331648,570425344,436207616,83886080,754974720,0,402653184,570425344,369098752,905969664,486539264,1107296256,754974720,1140850688,570425344,1140850688,1207959552,822083584,1476395008,1207959552,1291845632,1509949440,218103808,989855744,1560281088,553648128,889192448,889192448,1023410176,452984832,603979776,872415232,1107296256,301989888,587202560,1291845632,1241513984,738197504,939524096,335544320,889192448,1241513984,301989888,973078528,1275068416,553648128,553648128,1577058304,352321536,1073741824,1358954496,167772160,889192448,201326592,603979776,637534208,0,973078528,738197504,100663296,335544320,536870912,100663296,0,201326592,83886080,0,1560281088,1174405120,33554432,33554432,33554432,33554432,0,1006632960,352321536,0,134217728,603979776,285212672,100663296,234881024,285212672,134217728,100663296,620756992,83886080,553648128,285212672,335544320,721420288,352321536,855638016,654311424,1191182336,637534208,939524096,1308622848,1426063360,889192448,805306368,1308622848,1342177280,1325400064,1392508928,822083584,1174405120,1308622848,956301312,1056964608,1040187392,1258291200,1275068416,872415232,452984832,503316480,1426063360,1224736768,889192448,167772160,1392508928,1241513984,905969664,1291845632,436207616,989855744,1090519040,520093696,1040187392,1241513984,301989888,1107296256,704643072,318767104,587202560,67108864,1275068416,671088640,486539264,956301312,33554432,1073741824,201326592,553648128,754974720,922746880,301989888,100663296,1308622848,1761607680,486539264,218103808,1241513984,318767104,0,16777216,134217728,687865856,805306368,16777216,83886080,469762048,335544320,134217728,16777216,738197504,603979776,67108864,805306368,553648128,150994944,587202560,83886080,939524096,318767104,570425344,939524096,956301312,1442840576,553648128,1090519040,1056964608,1090519040,771751936,1124073472,1392508928,1124073472,1426063360,1174405120,402653184,989855744,536870912,1056964608,1023410176,335544320,285212672,654311424,922746880,721420288,922746880,637534208,1258291200,989855744,469762048,973078528,1006632960,956301312,1107296256,1291845632,687865856,1375731712,1090519040,134217728,1560281088,1191182336,738197504,989855744,285212672,620756992,1006632960,771751936,1073741824,251658240,1157627904,754974720,503316480,704643072,587202560,603979776,721420288,201326592,117440512,134217728,1778384896,1459617792,83886080,234881024,905969664,117440512,0,838860800,402653184,0,0,939524096,553648128,0,0,436207616,771751936,16777216,335544320,738197504,0,570425344,150994944,520093696,452984832,0,973078528,671088640,1526726656,402653184,1409286144,1241513984,1140850688,1442840576,1258291200,1409286144,1056964608,1375731712,889192448,905969664,1040187392,218103808,956301312,1358954496,704643072,939524096,1124073472,251658240,738197504,738197504,788529152,956301312,704643072,905969664,1157627904,587202560,1207959552,1006632960,285212672,1040187392,1258291200,939524096,1174405120,352321536,503316480,1409286144,754974720,939524096,989855744,167772160,1107296256,285212672,1124073472,788529152,436207616,939524096,301989888,603979776,637534208,67108864,452984832,268435456,822083584,167772160,1258291200,1224736768,1426063360,0,1543503872,0,100663296,1124073472,50331648,100663296,436207616,486539264,0,50331648,838860800,184549376,318767104,251658240,369098752,268435456,301989888,419430400,369098752,587202560,50331648,553648128,587202560,855638016,1107296256,855638016,1375731712,889192448,1308622848,889192448,1224736768,1375731712,1392508928,1342177280,452984832,1207959552,436207616,1073741824,889192448,536870912,637534208,1258291200,1006632960,1040187392,838860800,469762048,553648128,1073741824,1577058304,922746880,687865856,1442840576,520093696,1090519040,687865856,1040187392,1207959552,520093696,905969664,671088640,754974720,587202560,1291845632,603979776,822083584,318767104,1140850688,973078528,419430400,1157627904,234881024,1308622848,1275068416,268435456,1291845632,872415232,150994944,67108864,620756992,838860800,234881024,1207959552,1644167168,33554432,0,117440512,771751936,0,134217728,134217728,402653184,16777216,100663296,520093696,251658240,67108864,0,218103808,469762048,167772160,620756992,201326592,754974720,268435456,520093696,905969664,369098752,1040187392,704643072,1493172224,1224736768,1526726656,838860800,1476395008,1073741824,1342177280,1442840576,1157627904,1459617792,1107296256,889192448,989855744,788529152,822083584,1040187392,855638016,939524096,1157627904,1493172224,1275068416,671088640,973078528,1358954496,1073741824,687865856,1342177280,922746880,1006632960,989855744,1207959552,1325400064,637534208,1040187392,1056964608,1224736768,1140850688,1207959552,905969664,218103808,738197504,503316480,1342177280,150994944,922746880,956301312,469762048,603979776,436207616,469762048,1258291200,0,385875968,738197504,754974720,1040187392,603979776,1241513984,1426063360,117440512,184549376,117440512,134217728,486539264,889192448,419430400,67108864,83886080,922746880,67108864,352321536,134217728,570425344,469762048,452984832,251658240,536870912,469762048,234881024,973078528,234881024,956301312,721420288,1241513984,1526726656,1090519040,1241513984,1006632960,1258291200,905969664,1308622848,973078528,1241513984,855638016,687865856,1023410176,989855744,805306368,1308622848,654311424,452984832,1090519040,218103808,687865856,1207959552,1107296256,1342177280,1207959552,771751936,1308622848,1526726656,1291845632,1358954496,1258291200,1241513984,889192448,1291845632,1258291200,922746880,1157627904,922746880,788529152,1845493760,301989888,1090519040,419430400,570425344,1056964608,637534208,922746880,134217728,201326592,1040187392,469762048,1006632960,301989888,520093696,536870912,0,1761607680,1275068416,922746880,520093696,838860800,0,33554432,402653184,1191182336,335544320,117440512,520093696,603979776,385875968,117440512,486539264,134217728,654311424,268435456,419430400,251658240,352321536,16777216,1157627904,620756992,268435456,1275068416,469762048,1459617792,721420288,1275068416,855638016,1023410176,1392508928,1325400064,1124073472,1090519040,956301312,402653184,1124073472,973078528,150994944,1006632960,1308622848,117440512,1140850688,989855744,687865856,973078528,704643072,1174405120,1124073472,1174405120,738197504,1442840576,738197504,922746880,1073741824,1291845632,956301312,1325400064,1308622848,973078528,1409286144,1325400064,1275068416,385875968,1409286144,973078528,721420288,973078528,167772160,1207959552,285212672,1107296256,637534208,100663296,335544320,0,218103808,452984832,503316480,704643072,553648128,1291845632,1426063360,268435456,402653184,1157627904,0,0,301989888,335544320,83886080,201326592,922746880,436207616,0,1258291200,352321536,184549376,754974720,0,33554432,620756992,167772160,603979776,385875968,402653184,603979776,1107296256,1090519040,1459617792,721420288,1308622848,805306368,1191182336,1073741824,1375731712,805306368,1124073472,1124073472,150994944,704643072,369098752,855638016,973078528,184549376,385875968,1107296256,1157627904,1392508928,1140850688,1073741824,956301312,956301312,1207959552,922746880,620756992,1107296256,1056964608,1476395008,1644167168,1157627904,1476395008,1375731712,1275068416,905969664,1124073472,1207959552,637534208,1040187392,1358954496,553648128,1124073472,385875968,1073741824,436207616,1107296256,1342177280,419430400,1140850688,486539264,0,251658240,0,905969664,989855744,1442840576,1191182336,335544320,402653184,973078528,0,67108864,167772160,0,301989888,452984832,738197504,0,301989888,603979776,83886080,671088640,201326592,251658240,469762048,369098752,201326592,704643072,167772160,620756992,989855744,419430400,1509949440,536870912,1023410176,1241513984,1275068416,1258291200,1409286144,1409286144,1191182336,1476395008,587202560,1073741824,1241513984,285212672,1224736768,872415232,754974720,989855744,1023410176,436207616,989855744,1275068416,1375731712,536870912,989855744,201326592,1124073472,469762048,536870912,771751936,1006632960,1191182336,855638016,1291845632,838860800,1157627904,1342177280,1342177280,1006632960,738197504,1073741824,754974720,1056964608,402653184,1073741824,385875968,1308622848,419430400,1308622848,553648128,1023410176,1929379840,419430400,889192448,0,385875968,385875968,570425344,301989888,318767104,553648128,251658240,0,184549376,0,301989888,738197504,603979776,167772160,0,671088640,83886080,218103808,838860800,0,385875968,419430400,167772160,704643072,385875968,1040187392,1157627904,1023410176,822083584,1073741824,285212672,1124073472,1073741824,1191182336,1358954496,1191182336,1224736768,1207959552,1191182336,587202560,1174405120,1073741824,436207616,1157627904,452984832,1409286144,838860800,738197504,687865856,1308622848,503316480,1056964608,822083584,922746880,536870912,1090519040,1124073472,301989888,1191182336,855638016,1426063360,587202560,1275068416,1258291200,1392508928,1157627904,1191182336,1241513984,1073741824,1056964608,1040187392,1124073472,536870912,1023410176,218103808,1157627904,754974720,1140850688,805306368,369098752,1409286144,671088640,889192448,1409286144,402653184,587202560,637534208,0,167772160,754974720,33554432,16777216,16777216,33554432,704643072,603979776,369098752,201326592,536870912,452984832,218103808,301989888,469762048,369098752,452984832,318767104,218103808,469762048,402653184,1023410176,788529152,1023410176,754974720,1392508928,603979776,1442840576,1174405120,1459617792,1593835520,1358954496,1090519040,1426063360,721420288,1040187392,654311424,1040187392,603979776,838860800,486539264,1275068416,452984832,603979776,905969664,1090519040,855638016,1392508928,620756992,805306368,905969664,570425344,939524096,167772160,973078528,385875968,1509949440,536870912,1325400064,1258291200,1392508928,1040187392,1375731712,889192448,1308622848,1124073472,1308622848,1056964608,1476395008,402653184,838860800,520093696,1241513984,939524096,1140850688,503316480,1442840576,1526726656,369098752,587202560,838860800,889192448,1124073472,234881024,0,352321536,0,16777216,0,419430400,788529152,150994944,67108864,654311424,822083584,134217728,184549376,553648128,83886080,486539264,603979776,251658240,385875968,268435456,452984832,872415232,704643072,620756992,1258291200,1795162112,1207959552,1224736768,1023410176,1459617792,1476395008,1375731712,1023410176,1526726656,486539264,956301312,738197504,1291845632,922746880,721420288,922746880,1258291200,654311424,1140850688,805306368,1207959552,402653184,889192448,922746880,704643072,855638016,503316480,922746880,150994944,587202560,150994944,1006632960,1157627904,1409286144,1157627904,1157627904,1224736768,1140850688,318767104,939524096,1291845632,1291845632,654311424,1308622848,352321536,939524096,117440512,1023410176,402653184,838860800,402653184,654311424,1241513984,385875968,872415232,553648128,352321536,721420288,855638016,419430400,201326592,0,0,0,687865856,587202560,0,201326592,838860800,587202560,50331648,469762048,754974720,184549376,436207616,268435456,0,570425344,33554432,989855744,369098752,1224736768,83886080,1308622848,1325400064,1207959552,838860800,1224736768,1023410176,1560281088,754974720,1442840576,1207959552,788529152,838860800,738197504,754974720,1056964608,721420288,939524096,922746880,855638016,1191182336,1073741824,1409286144,553648128,1409286144,704643072,486539264,1023410176,369098752,1056964608,184549376,620756992,385875968,671088640,1140850688,1107296256,1224736768,1090519040,1107296256,1073741824,1375731712,1107296256,805306368,1157627904,654311424,1157627904,1157627904,989855744,469762048,1241513984,939524096,771751936,570425344,1174405120,1191182336,1140850688,436207616,620756992,469762048,889192448,838860800,1073741824,50331648,0,0,385875968,637534208,285212672,100663296,587202560,721420288,352321536,419430400,369098752,83886080,687865856,469762048,83886080,721420288,318767104,402653184,1207959552,1191182336,956301312,620756992,1140850688,452984832,1392508928,788529152,1375731712,956301312,1241513984,352321536,1375731712,838860800,872415232,855638016,939524096,922746880,1124073472,352321536,872415232,536870912,956301312,1275068416,721420288,1677721600,234881024,956301312,687865856,721420288,754974720,134217728,905969664,100663296,469762048,318767104,822083584,402653184,1040187392,1442840576,1241513984,1056964608,1006632960,1090519040,1358954496,1090519040,1342177280,1207959552,788529152,1291845632,704643072,1124073472,184549376,1258291200,469762048,1006632960,654311424,1073741824,1375731712,83886080,721420288,402653184,0,1090519040,1660944384,0,134217728,33554432,419430400,218103808,0,520093696,553648128,452984832,352321536,805306368,234881024,117440512,721420288,301989888,150994944,335544320,83886080,419430400,1375731712,1073741824,1342177280,1073741824,1174405120,570425344,1358954496,956301312,1174405120,1275068416,1241513984,989855744,1358954496,117440512,939524096,436207616,1107296256,973078528,754974720,436207616,671088640,570425344,1040187392,973078528,620756992,1224736768,637534208,1107296256,754974720,1174405120,637534208,201326592,1392508928,285212672,738197504,251658240,553648128,520093696,1023410176,1442840576,1476395008,1140850688,1241513984,1392508928,738197504,1073741824,1358954496,1107296256,503316480,1174405120,738197504,1342177280,452984832,872415232,201326592,1124073472,1090519040,167772160,1442840576,234881024,251658240,486539264,234881024,704643072,1929379840,1610612736,33554432,0,251658240,0,201326592,1258291200,520093696,301989888,436207616,436207616,167772160,452984832,771751936,201326592,452984832,301989888,167772160,872415232,352321536,1207959552,872415232,1157627904,1207959552,1509949440,1392508928,1308622848,1358954496,1207959552,1560281088,1358954496,1224736768,838860800,1023410176,385875968,939524096,520093696,1056964608,671088640,822083584,301989888,1258291200,1174405120,553648128,1191182336,603979776,1224736768,620756992,956301312,1023410176,469762048,905969664,469762048,721420288,738197504,402653184,150994944,1174405120,1073741824,1157627904,1543503872,754974720,1056964608,268435456,1090519040,419430400,1241513984,956301312,1493172224,1124073472,1459617792,788529152,1006632960,452984832,855638016,1627389952,939524096,1577058304,1207959552,436207616,369098752,822083584,855638016,1660944384,1644167168,301989888,150994944,318767104,167772160,1191182336,956301312,318767104,318767104,738197504,520093696,134217728,503316480,654311424,167772160,553648128,134217728,603979776,771751936,754974720,1124073472,721420288,1090519040,1392508928,889192448,1358954496,1207959552,1426063360,1426063360,989855744,1291845632,1073741824,872415232,1140850688,486539264,1040187392,285212672,973078528,620756992,956301312,251658240,1174405120,1308622848,503316480,1191182336,671088640,1476395008,704643072,889192448,1207959552,385875968,1224736768,318767104,620756992,805306368,687865856,369098752,1107296256,1442840576,1258291200,1375731712,637534208,956301312,620756992,1056964608,822083584,671088640,1107296256,671088640,989855744,855638016,50331648,1040187392,1174405120,369098752,1761607680,1090519040,1023410176,1459617792,285212672,234881024,385875968,234881024,1694498816,1593835520,469762048,33554432,0,587202560,989855744,352321536,0,771751936,973078528,654311424,335544320,436207616,335544320,352321536,536870912,83886080,838860800,637534208,973078528,1124073472,822083584,838860800,1140850688,905969664,1073741824,1459617792,1207959552,1224736768,251658240,1342177280,1107296256,855638016,973078528,536870912,989855744,352321536,939524096,788529152,1275068416,754974720,1241513984,1241513984,503316480,1107296256,570425344,1140850688,452984832,905969664,1157627904,754974720,788529152,16777216,872415232,335544320,738197504,872415232,922746880,956301312,486539264,1291845632,1174405120,452984832,687865856,520093696,1174405120,452984832,1426063360,587202560,1275068416,1426063360,369098752,838860800,956301312,1174405120,922746880,973078528,486539264,1509949440,67108864,234881024,369098752,637534208,452984832,201326592,134217728,0,83886080,687865856,268435456,83886080,285212672,905969664,620756992,369098752,620756992,503316480,134217728,654311424,520093696,268435456,721420288,536870912,1426063360,1040187392,1308622848,805306368,1174405120,1241513984,922746880,1409286144,889192448,1241513984,469762048,1241513984,335544320,989855744,1140850688,687865856,939524096,503316480,1258291200,956301312,1409286144,989855744,1006632960,1191182336,738197504,1308622848,1056964608,973078528,150994944,687865856,536870912,721420288,620756992,318767104,520093696,301989888,822083584,486539264,889192448,553648128,469762048,1509949440,905969664,687865856,1040187392,16777216,1342177280,134217728,989855744,805306368,251658240,1258291200,838860800,956301312,1476395008,1761607680,486539264,1392508928,469762048,1124073472,335544320,419430400,671088640,1006632960,0,536870912,268435456,50331648,201326592,603979776,150994944,33554432,788529152,805306368,50331648,335544320,637534208,385875968,218103808,822083584,251658240,436207616,754974720,469762048,1660944384,771751936,335544320,654311424,385875968,1090519040,1124073472,1358954496,788529152,1291845632,251658240,1358954496,469762048,872415232,1073741824,570425344,939524096,486539264,1124073472,570425344,1241513984,855638016,503316480,822083584,536870912,956301312,1241513984,1040187392,603979776,956301312,469762048,687865856,805306368,654311424,1006632960,201326592,788529152,503316480,754974720,1140850688,687865856,1426063360,989855744,671088640,1459617792,536870912,1342177280,419430400,989855744,1325400064,0,1191182336,419430400,436207616,922746880,671088640,855638016,1023410176,1073741824,150994944,385875968,218103808,184549376,301989888,100663296,1795162112,788529152,0,50331648,436207616,0,385875968,587202560,704643072,83886080,687865856,536870912,201326592,419430400,738197504,50331648,536870912,637534208,486539264,1342177280,822083584,822083584,704643072,671088640,1174405120,1124073472,1241513984,1090519040,1644167168,167772160,1358954496,587202560,822083584,1174405120,167772160,687865856,369098752,754974720,520093696,1124073472,973078528,553648128,1107296256,973078528,889192448,939524096,553648128,805306368,788529152,251658240,771751936,939524096,503316480,1409286144,536870912,671088640,436207616,1124073472,620756992,1006632960,989855744,1073741824,553648128,1124073472,520093696,1040187392,1291845632,1258291200,1409286144,654311424,1627389952,1023410176,520093696,452984832,301989888,1174405120,503316480,1946157056,201326592,704643072,469762048,318767104,503316480,100663296,1224736768,922746880,201326592,704643072,83886080,67108864,654311424,570425344,134217728,520093696,889192448,536870912,218103808,536870912,536870912,167772160,654311424,184549376,1358954496,1073741824,855638016,184549376,687865856,503316480,1308622848,1157627904,1526726656,1124073472,1107296256,268435456,1358954496,352321536,1124073472,788529152,251658240,570425344,520093696,889192448,1140850688,1006632960,989855744,805306368,687865856,1258291200,1358954496,1140850688,553648128,1207959552,822083584,352321536,889192448,385875968,872415232,1073741824,268435456,838860800,922746880,1040187392,654311424,1291845632,905969664,1157627904,603979776,1056964608,1191182336,570425344,738197504,570425344,1107296256,738197504,1056964608,1577058304,218103808,83886080,134217728,385875968,251658240,1023410176,0,889192448,738197504,201326592,184549376,805306368,83886080,67108864,100663296,117440512,0,268435456,620756992,771751936,184549376,620756992,687865856,402653184,301989888,452984832,301989888,536870912,520093696,218103808,1207959552,1073741824,989855744,100663296,989855744,553648128,1241513984,771751936,1258291200,855638016,1308622848,452984832,1644167168,805306368,436207616,822083584,301989888,805306368,1040187392,520093696,1073741824,1526726656,1174405120,1107296256,1207959552,1258291200,553648128,1073741824,1509949440,805306368,1006632960,436207616,855638016,738197504,838860800,1124073472,301989888,956301312,771751936,1207959552,889192448,738197504,838860800,1207959552,905969664,704643072,973078528,1275068416,1426063360,83886080,1140850688,889192448,1040187392,1828716544,251658240,973078528,738197504,1241513984,553648128,553648128,33554432,201326592,1258291200,83886080,100663296,1358954496,0,134217728,83886080,0,234881024,335544320,503316480,33554432,83886080,620756992,603979776,184549376,385875968,570425344,184549376,452984832,587202560,352321536,1174405120,721420288,1140850688,150994944,1073741824,771751936,1107296256,922746880,1140850688,620756992,1157627904,704643072,1358954496,1224736768,234881024,939524096,469762048,587202560,872415232,1291845632,1426063360,1006632960,486539264,1107296256,1241513984,721420288,1107296256,956301312,1560281088,1040187392,771751936,704643072,905969664,956301312,620756992,721420288,335544320,754974720,922746880,1258291200,1090519040,704643072,469762048,536870912,838860800,100663296,1090519040,369098752,1023410176,704643072,721420288,1476395008,1191182336,1241513984,0,1409286144,1023410176,1258291200,1174405120,285212672,1174405120,452984832,1224736768,0,167772160,1828716544,1795162112,0,16777216,0,436207616,654311424,603979776,0,268435456,587202560,318767104,318767104,570425344,352321536,369098752,654311424,117440512,469762048,704643072,436207616,671088640,369098752,805306368,922746880,956301312,939524096,687865856,536870912,1241513984,1157627904,1476395008,1593835520,335544320,503316480,805306368,285212672,486539264,738197504,1241513984,956301312,134217728,956301312,1073741824,922746880,1073741824,1241513984,1107296256,822083584,486539264,620756992,1744830464,1207959552,452984832,754974720,301989888,788529152,1107296256,855638016,889192448,436207616,503316480,318767104,855638016,83886080,1660944384,553648128,654311424,1308622848,201326592,1342177280,687865856,402653184,150994944,1660944384,1409286144,1241513984,620756992,637534208,939524096,754974720,1526726656,117440512,637534208,1409286144,2030043136,0,100663296,67108864,167772160,436207616,67108864,50331648,553648128,671088640,0,385875968,486539264,0,603979776,1023410176,117440512,922746880,419430400,469762048,469762048,402653184,939524096,687865856,1308622848,754974720,973078528,939524096,1191182336,905969664,1140850688,855638016,872415232,671088640,687865856,520093696,352321536,1124073472,1174405120,1241513984,1107296256,872415232,822083584,1023410176,1124073472,973078528,905969664,436207616,788529152,687865856,1342177280,1006632960,369098752,654311424,352321536,1426063360,1275068416,654311424,956301312,318767104,939524096,570425344,738197504,402653184,1644167168,973078528,587202560,1493172224,234881024,1308622848,671088640,184549376,1124073472,1560281088,1291845632,1442840576,1207959552,1073741824,738197504,603979776,1660944384,0,738197504,1526726656,1744830464,218103808,0,318767104,352321536,469762048,50331648,369098752,503316480,184549376,402653184,771751936,385875968,218103808,553648128,536870912,234881024,855638016,268435456,738197504,134217728,637534208,503316480,788529152,1224736768,486539264,838860800,956301312,1342177280,1157627904,1325400064,369098752,838860800,285212672,687865856,486539264,855638016,1593835520,503316480,1157627904,1224736768,838860800,771751936,805306368,1224736768,637534208,738197504,1056964608,1073741824,1275068416,1426063360,788529152,469762048,771751936,905969664,855638016,67108864,603979776,1157627904,251658240,956301312,553648128,587202560,469762048,1090519040,855638016,503316480,1375731712,251658240,1073741824,654311424,134217728,1560281088,1409286144,1593835520,1493172224,1023410176,671088640,1224736768,201326592,1023410176,318767104,671088640,1442840576,1157627904,16777216,201326592,469762048,301989888,67108864,234881024,570425344,503316480,50331648,184549376,704643072,0,520093696,771751936,150994944,520093696,956301312,218103808,436207616,268435456,251658240,352321536,721420288,1157627904,285212672,905969664,989855744,1375731712,1107296256,1241513984,855638016,889192448,16777216,855638016,234881024,50331648,1073741824,1006632960,134217728,788529152,1174405120,922746880,855638016,973078528,570425344,570425344,1291845632,805306368,1224736768,1291845632,771751936,956301312,301989888,855638016,838860800,654311424,620756992,1124073472,318767104,838860800,486539264,671088640,385875968,771751936,922746880,218103808,1577058304,402653184,855638016,503316480,402653184,1459617792,1358954496,1308622848,1426063360,251658240,788529152,1660944384,67108864,587202560,301989888,1375731712,1325400064,1073741824,0,0,150994944,67108864,0,721420288,704643072,167772160,0,486539264,553648128,0,654311424,671088640,150994944,503316480,587202560,385875968,503316480,301989888,452984832,184549376,1073741824,1107296256,402653184,905969664,989855744,1325400064,1207959552,1224736768,1241513984,1073741824,369098752,335544320,301989888,486539264,67108864,1275068416,989855744,973078528,1140850688,1241513984,1157627904,1224736768,855638016,1191182336,956301312,838860800,1207959552,1157627904,603979776,973078528,285212672,788529152,587202560,1476395008,637534208,1090519040,587202560,939524096,620756992,788529152,503316480,369098752,989855744,83886080,1744830464,754974720,1291845632,788529152,822083584,1275068416,1325400064,1107296256,1509949440,822083584,536870912,1140850688,218103808,905969664,369098752,1392508928,1392508928,1577058304,0,0,134217728,0,117440512,822083584,620756992,0,520093696,1124073472,83886080,234881024,654311424,134217728,536870912,872415232,369098752,620756992,637534208,436207616,486539264,318767104,973078528,1157627904,301989888,872415232,872415232,1241513984,1560281088,1258291200,822083584,1124073472,1275068416,536870912,419430400,603979776,503316480,822083584,788529152,687865856,1023410176,587202560,654311424,721420288,889192448,889192448,553648128,201326592,1090519040,285212672,587202560,805306368,318767104,704643072,268435456,1509949440,385875968,905969664,520093696,822083584,620756992,771751936,855638016,0,973078528,234881024,1325400064,402653184,1291845632,620756992,436207616,905969664,1325400064,1056964608,553648128,939524096,570425344,1224736768,1342177280,436207616,520093696,1157627904,1174405120,1526726656,50331648,100663296,100663296,0,369098752,788529152,0,67108864,721420288,335544320,184549376,922746880,385875968,520093696,738197504,1006632960,520093696,855638016,587202560,1560281088,704643072,536870912,1157627904,1241513984,436207616,1291845632,855638016,1358954496,1509949440,1275068416,1577058304,1056964608,1040187392,738197504,301989888,637534208,922746880,100663296,855638016,956301312,1124073472,956301312,553648128,671088640,1073741824,1023410176,939524096,855638016,671088640,201326592,1090519040,872415232,520093696,872415232,218103808,1241513984,469762048,1476395008,301989888,905969664,318767104,922746880,1409286144,100663296,1124073472,268435456,889192448,671088640,1157627904,1342177280,587202560,822083584,1207959552,1291845632,1241513984,1308622848,33554432,1040187392,1056964608,251658240,167772160,1191182336,1207959552,1442840576,134217728,0,134217728,603979776,520093696,570425344,0,570425344,771751936,67108864,134217728,587202560,83886080,704643072,385875968,754974720,469762048,520093696,671088640,1358954496,788529152,654311424,1040187392,1409286144,687865856,771751936,1224736768,1459617792,1258291200,1409286144,1275068416,1023410176,738197504,838860800,402653184,905969664,603979776,1023410176,671088640,1023410176,1124073472,671088640,973078528,1291845632,956301312,570425344,1224736768,788529152,536870912,469762048,1224736768,486539264,1090519040,1006632960,503316480,1275068416,637534208,1358954496,33554432,1006632960,1375731712,1224736768,1442840576,150994944,1174405120,721420288,536870912,1157627904,1409286144,989855744,536870912,1241513984,1157627904,1207959552,1392508928,1308622848,452984832,369098752,738197504,301989888,822083584,788529152,419430400,603979776,0,0,83886080,822083584,704643072,268435456,0,721420288,687865856,33554432,503316480,520093696,134217728,1107296256,285212672,637534208,369098752,335544320,738197504,889192448,671088640,1040187392,654311424,419430400,771751936,1006632960,1291845632,922746880,1560281088,50331648,1124073472,989855744,822083584,587202560,771751936,67108864,520093696,1224736768,855638016,620756992,251658240,922746880,1207959552,1124073472,956301312,1224736768,805306368,352321536,637534208,620756992,1124073472,553648128,1543503872,486539264,855638016,838860800,939524096,1342177280,318767104,1107296256,1056964608,1409286144,1241513984,469762048,1056964608,486539264,738197504,1157627904,822083584,1157627904,436207616,1241513984,905969664,1258291200,436207616,922746880,922746880,268435456,1157627904,553648128,1040187392,352321536,285212672,620756992,167772160,117440512,33554432,452984832,553648128,33554432,352321536,637534208,352321536,0,654311424,184549376,234881024,973078528,352321536,654311424,402653184,419430400,788529152,905969664,100663296,1073741824,889192448,486539264,1207959552,385875968,1409286144,1476395008,1258291200,738197504,1107296256,1342177280,369098752,671088640,855638016,587202560,285212672,620756992,1073741824,872415232,1090519040,805306368,469762048,838860800,1258291200,436207616,754974720,335544320,469762048,939524096,1073741824,1375731712,1157627904,335544320,989855744,385875968,1124073472,1023410176,855638016,922746880,1124073472,1224736768,1258291200,721420288,637534208,805306368,603979776,1308622848,436207616,1124073472,50331648,973078528,1207959552,989855744,1006632960,889192448,1157627904,50331648,822083584,553648128,1493172224,251658240,67108864,100663296,0,16777216,33554432,134217728,134217728,117440512,855638016,587202560,16777216,436207616,687865856,0,536870912,486539264,318767104,452984832,419430400,520093696,654311424,352321536,1207959552,654311424,1107296256,117440512,1090519040,704643072,1426063360,1023410176,1090519040,1258291200,771751936,1191182336,922746880,201326592,805306368,939524096,1207959552,687865856,1090519040,939524096,889192448,922746880,687865856,671088640,1291845632,956301312,872415232,1426063360,469762048,100663296,889192448,1275068416,1140850688,671088640,1207959552,536870912,1509949440,889192448,771751936,603979776,1224736768,872415232,637534208,922746880,301989888,855638016,939524096,1308622848,419430400,1895825408,603979776,1040187392,486539264,805306368,1358954496,16777216,1325400064,419430400,855638016,1056964608,201326592,369098752,167772160,0,167772160,0,0,50331648,50331648,486539264,805306368,251658240,33554432,771751936,503316480,16777216,1107296256,352321536,436207616,251658240,469762048,369098752,738197504,385875968,654311424,520093696,1107296256,1157627904,1392508928,1124073472,1207959552,1526726656,469762048,1258291200,838860800,956301312,989855744,738197504,184549376,721420288,754974720,671088640,822083584,469762048,402653184,922746880,1023410176,452984832,1174405120,1023410176,1191182336,771751936,603979776,687865856,1694498816,536870912,603979776,1258291200,939524096,671088640,1224736768,1342177280,1124073472,486539264,788529152,956301312,436207616,1090519040,335544320,788529152,1056964608,1543503872,285212672,1375731712,620756992,754974720,989855744,218103808,1325400064,452984832,956301312,939524096,50331648,754974720,620756992,469762048,452984832,0,33554432,50331648,0,83886080,318767104,637534208,587202560,0,402653184,520093696,50331648,234881024,1157627904,251658240,620756992,285212672,603979776,402653184,637534208,352321536,503316480,738197504,905969664,822083584,754974720,1275068416,1258291200,1577058304,587202560,1124073472,1157627904,603979776,1157627904,805306368,754974720,83886080,1140850688,838860800,587202560,553648128,687865856,536870912,1090519040,805306368,1124073472,788529152,838860800,1124073472,452984832,687865856,754974720,1409286144,1442840576,1358954496,352321536,1560281088,671088640,1174405120,1207959552,134217728,637534208,855638016,771751936,671088640,33554432,1308622848,150994944,1442840576,771751936,939524096,1023410176,134217728,1224736768,1409286144,973078528,687865856,134217728,805306368,134217728,788529152,956301312,201326592,889192448,251658240,100663296,0,100663296,184549376,503316480,452984832,704643072,0,754974720,637534208,100663296,637534208,905969664,16777216,587202560,268435456,570425344,637534208,452984832,771751936,503316480,788529152,1241513984,939524096,100663296,536870912,1191182336,1140850688,1509949440,234881024,1392508928,1291845632,301989888,838860800,1124073472,352321536,1342177280,1543503872,436207616,570425344,620756992,503316480,905969664,486539264,956301312,1090519040,1644167168,1207959552,754974720,704643072,570425344,872415232,973078528,1006632960,1107296256,1056964608,671088640,1409286144,956301312,520093696,889192448,1157627904,939524096,1040187392,369098752,1157627904,1291845632,1040187392,822083584,1040187392,1191182336,402653184,1090519040,603979776,922746880,973078528,385875968,721420288,436207616,369098752,536870912,268435456,822083584,0,0,67108864,0,150994944,452984832,268435456,50331648,268435456,654311424,218103808,0,771751936,352321536,402653184,637534208,134217728,469762048,872415232,553648128,285212672,385875968,1073741824,1174405120,1157627904,1107296256,1325400064,1040187392,0,1241513984,1207959552,486539264,1610612736,1291845632,469762048,771751936,469762048,553648128,1426063360,1375731712,452984832,754974720,704643072,788529152,1174405120,721420288,771751936,1040187392,687865856,838860800,1191182336,805306368,1174405120,1073741824,251658240,1459617792,1023410176,956301312,1342177280,1207959552,385875968,721420288,922746880,1174405120,1627389952,150994944,1107296256,1124073472,1191182336,1207959552,570425344,1040187392,1258291200,889192448,822083584,587202560,855638016,0,838860800,620756992,83886080,285212672,1409286144,167772160,0,50331648,0,33554432,100663296,117440512,100663296,218103808,637534208,1090519040,436207616,268435456,905969664,352321536,301989888,301989888,285212672,738197504,1342177280,939524096,536870912,771751936,654311424,771751936,1056964608,889192448,1895825408,1342177280,100663296,268435456,1509949440,1191182336,805306368,939524096,788529152,285212672,385875968,939524096,1191182336,1409286144,771751936,603979776,301989888,587202560,335544320,889192448,1107296256,855638016,805306368,1040187392,1040187392,1090519040,620756992,822083584,1124073472,1426063360,134217728,1090519040,1610612736,1207959552,520093696,738197504,452984832,872415232,1694498816,117440512,889192448,956301312,570425344,1056964608,1224736768,1241513984,1090519040,654311424,973078528,620756992,1191182336,352321536,771751936,989855744,184549376,385875968,1107296256,117440512,0,33554432,67108864,50331648,0,0,184549376,218103808,117440512,100663296,0,889192448,536870912,134217728,385875968,771751936,268435456,704643072,1040187392,822083584,754974720,486539264,654311424,1224736768,1191182336,1073741824,1526726656,1459617792,1409286144,637534208,1291845632,1241513984,738197504,822083584,603979776,889192448,251658240,1207959552,1593835520,1224736768,536870912,805306368,721420288,603979776,1090519040,721420288,989855744,704643072,234881024,922746880,989855744,838860800,654311424,1006632960,905969664,1275068416,721420288,1291845632,1207959552,452984832,687865856,1107296256,922746880,1275068416,1644167168,1157627904,301989888,1191182336,587202560,1392508928,1258291200,1224736768,1006632960,436207616,1174405120,1124073472,1325400064,1409286144,100663296,520093696,788529152,0,620756992,33554432,0,33554432,83886080,0,0,50331648,100663296,134217728,167772160,134217728,536870912,436207616,268435456,889192448,369098752,671088640,637534208,285212672,1090519040,402653184,218103808,369098752,905969664,1073741824,1258291200,201326592,1191182336,1207959552,1392508928,1040187392,805306368,1308622848,1224736768,50331648,838860800,1056964608,956301312,402653184,939524096,1291845632,1174405120,603979776,553648128,1241513984,989855744,1459617792,1157627904,771751936,838860800,905969664,1291845632,1124073472,721420288,738197504,1023410176,1409286144,1191182336,1258291200,1392508928,1426063360,1207959552,1207959552,1140850688,1006632960,1174405120,1140850688,419430400,1157627904,570425344,1409286144,1358954496,956301312,1073741824,167772160,838860800,1107296256,754974720,838860800,67108864,536870912,1157627904,520093696,201326592,0,16777216,16777216,0,67108864,570425344,687865856,251658240,184549376,452984832,452984832,587202560,805306368,570425344,536870912,671088640,201326592,318767104,251658240,50331648,335544320,788529152,285212672,905969664,1275068416,1107296256,1241513984,1224736768,1560281088,1006632960,1174405120,201326592,1056964608,1392508928,335544320,251658240,1191182336,1308622848,1157627904,553648128,637534208,1392508928,620756992,805306368,570425344,956301312,922746880,956301312,721420288,905969664,872415232,1073741824,973078528,553648128,452984832,1224736768,1073741824,989855744,1241513984,1493172224,1090519040,1308622848,1308622848,1358954496,973078528,587202560,1728053248,0,1426063360,671088640,1241513984,805306368,1056964608,1308622848,872415232,989855744,1107296256,67108864,134217728,553648128,301989888,1459617792,872415232,0,0,50331648,16777216,0,0,268435456,268435456,50331648,385875968,754974720,587202560,503316480,872415232,989855744,754974720,603979776,587202560,922746880,469762048,0,285212672,385875968,520093696,486539264,1006632960,1224736768,1207959552,1275068416,1191182336,1509949440,1375731712,1644167168,1291845632,1660944384,0,1006632960,1140850688,1040187392,1275068416,1124073472,989855744,855638016,1224736768,1140850688,939524096,1040187392,1140850688,620756992,939524096,989855744,889192448,1090519040,788529152,855638016,721420288,1056964608,872415232,1342177280,1459617792,1107296256,1224736768,1275068416,1409286144,1325400064,1157627904,1358954496,1560281088,369098752,1325400064,1107296256,0,1224736768,469762048,1157627904,889192448,620756992,1107296256,167772160,704643072,822083584,251658240,1358954496,1073741824,0,50331648,67108864,50331648,33554432,0,0,33554432,218103808,419430400,301989888,0,452984832,251658240,603979776,1023410176,469762048,570425344,771751936,570425344,251658240,134217728,285212672,637534208,637534208,1056964608,687865856,1325400064,1174405120,1375731712,1241513984,1409286144,1426063360,1610612736,1560281088,117440512,838860800,1140850688,1358954496,1291845632,1459617792,1040187392,1442840576,1056964608,704643072,687865856,1124073472,1174405120,1124073472,1107296256,1275068416,1006632960,1241513984,822083584,738197504,503316480,654311424,754974720,1140850688,1056964608,1308622848,1040187392,1275068416,1426063360,1241513984,1358954496,1509949440,1476395008,1090519040,1426063360,1308622848,234881024,1157627904,0,50331648,721420288,285212672,973078528,1174405120,687865856,805306368,872415232,100663296,671088640,33554432,16777216,33554432,67108864,0,83886080,0,0,285212672,369098752,452984832,788529152,654311424,822083584,973078528,721420288,788529152,486539264,385875968,721420288,486539264,318767104,318767104,268435456,469762048,1392508928,989855744,100663296,754974720,1509949440,1291845632,738197504,1543503872,1325400064,1409286144,0,536870912,1124073472,922746880,1207959552,704643072,1493172224,1358954496,1375731712,1241513984,620756992,855638016,1174405120,1241513984,1291845632,1040187392,1426063360,1308622848,603979776,989855744,1073741824,419430400,671088640,1375731712,1207959552,855638016,1191182336,1275068416,1426063360,1342177280,1426063360,1442840576,603979776,1308622848,1694498816,1308622848,654311424,1040187392,1258291200,452984832,553648128,0,16777216,1140850688,16777216,771751936,1392508928,587202560,0,16777216,0,0,67108864,0,16777216,50331648,83886080,134217728,184549376,234881024,268435456,671088640,838860800,704643072,536870912,721420288,285212672,553648128,503316480,218103808,167772160,385875968,419430400,402653184,1107296256,1593835520,956301312,436207616,872415232,1644167168,654311424,587202560,1291845632,1627389952,0,754974720,1124073472,1040187392,1258291200,956301312,1073741824,1124073472,1191182336,1191182336,1073741824,1442840576,956301312,1426063360,1342177280,1040187392,1124073472,1191182336,754974720,1342177280,1308622848,687865856,1124073472,1509949440,956301312,1006632960,989855744,1224736768,1090519040,1174405120,1409286144,1275068416,1073741824,1392508928,1258291200,1409286144,822083584,922746880,1275068416,452984832,1191182336,838860800,218103808,1191182336,0,117440512,335544320,1711276032,385875968,0,16777216,16777216,16777216,0,0,0,16777216,33554432,67108864,67108864,67108864,218103808,83886080,218103808,352321536,738197504,704643072,520093696,687865856,620756992,16777216,385875968,620756992,603979776,1258291200,973078528,1224736768,1090519040,1459617792,1526726656,1358954496,1526726656,1107296256,1073741824,318767104,805306368,1157627904,1258291200,1325400064,1342177280,1124073472,1207959552,1174405120,1107296256,1140850688,872415232,536870912,771751936,1241513984,1140850688,1140850688,989855744,788529152,1358954496,905969664,989855744,318767104,671088640,889192448,1073741824,1191182336,1275068416,721420288,1258291200,1174405120,1207959552,1275068416,1124073472,805306368,1140850688,838860800,218103808,1124073472,822083584,889192448,1174405120,503316480,1761607680,1157627904,536870912,218103808,1174405120,0,0,16777216,16777216,16777216,0,0,0,0,117440512,268435456,385875968,452984832,335544320,620756992,369098752,536870912,503316480,251658240,520093696,687865856,771751936,268435456,452984832,536870912,402653184,1241513984,570425344,1056964608,1224736768,1392508928,687865856,1358954496,1191182336,989855744,1191182336,117440512,117440512,939524096,536870912,1207959552,1308622848,1275068416,1291845632,905969664,1140850688,1308622848,385875968,939524096,1006632960,1258291200,1358954496,1090519040,1207959552,1073741824,1073741824,989855744,838860800,1157627904,1241513984,1174405120,1811939328,1325400064,587202560,1392508928,1442840576,889192448,1073741824,1442840576,1140850688,1107296256,352321536,1090519040,570425344,973078528,1023410176,369098752,771751936,587202560,822083584,1543503872,1711276032,503316480,520093696,150994944,0,16777216,16777216,16777216,50331648,16777216,0,16777216,100663296,201326592,285212672,318767104,301989888,956301312,620756992,687865856,637534208,369098752,889192448,805306368,939524096,603979776,385875968,671088640,771751936,1644167168,1191182336,855638016,1342177280,989855744,939524096,234881024,1241513984,1627389952,1392508928,587202560,0,1006632960,654311424,1241513984,1191182336,1409286144,1107296256,738197504,1325400064,1308622848,1090519040,1056964608,1174405120,822083584,1342177280,1258291200,1107296256,1543503872,1543503872,1577058304,1493172224,1224736768,687865856,822083584,1140850688,1426063360,1073741824,1157627904,1157627904,318767104,738197504,1392508928,1493172224,1006632960,1023410176,855638016,1040187392,335544320,620756992,822083584,637534208,1325400064,16777216,1073741824,1342177280,1610612736,1140850688,0,0,0,0,0,0,0,16777216,67108864,117440512,117440512,83886080,50331648,0,234881024,536870912,436207616,771751936,704643072,754974720,704643072,503316480,50331648,201326592,721420288,671088640,1174405120,1375731712,973078528,1107296256,1409286144,1476395008,1358954496,1409286144,1560281088,1275068416,721420288,0,738197504,1325400064,1291845632,1358954496,1375731712,1157627904,1308622848,989855744,939524096,838860800,721420288,184549376,1124073472,956301312,1342177280,922746880,1157627904,838860800,771751936,738197504,973078528,721420288,637534208,1157627904,922746880,1124073472,922746880,553648128,738197504,1207959552,1157627904,1224736768,1023410176,1157627904,1392508928,1006632960,805306368,184549376,788529152,570425344,1476395008,805306368,167772160,905969664,1459617792,1778384896,16777216,0,0,0,0,0,0,0,33554432,100663296,184549376,251658240,301989888,788529152,436207616,301989888,318767104,973078528,788529152,654311424,419430400,905969664,0,536870912,687865856,402653184,939524096,1426063360,1241513984,872415232,570425344,1241513984,1207959552,1342177280,1509949440,1392508928,788529152,134217728,939524096,1157627904,1459617792,1308622848,838860800,939524096,1056964608,704643072,654311424,989855744,788529152,905969664,1006632960,1392508928,1124073472,1090519040,1291845632,1291845632,1174405120,553648128,1124073472,1358954496,855638016,251658240,503316480,251658240,1224736768,1056964608,922746880,1140850688,1107296256,1023410176,1711276032,1375731712,1073741824,570425344,754974720,452984832,1342177280,150994944,973078528,1224736768,822083584,0,0,0,0,0,0,0,0,67108864,33554432,0,0,0,16777216,167772160,268435456,301989888,587202560,637534208,587202560,520093696,33554432,385875968,704643072,1677721600,234881024,469762048,469762048,503316480,1308622848,1409286144,889192448,1409286144,1342177280,352321536,318767104,1174405120,1459617792,1191182336,671088640,0,721420288,687865856,1325400064,1258291200,1023410176,1224736768,1107296256,385875968,587202560,805306368,989855744,838860800,570425344,1174405120,788529152,1342177280,1090519040,1023410176,989855744,1426063360,973078528,1124073472,1107296256,805306368,1325400064,1275068416,1392508928,687865856,16777216,1174405120,1124073472,855638016,1577058304,1426063360,1073741824,503316480,1174405120,385875968,1291845632,486539264,335544320,1291845632,1677721600,570425344,0,16777216,50331648,0,0,0,0,0,0,33554432,33554432,16777216,16777216,83886080,150994944,0,150994944,754974720,822083584,956301312,989855744,402653184,570425344,1543503872,251658240,419430400,771751936,822083584,1291845632,1308622848,838860800,1073741824,1140850688,1392508928,704643072,1392508928,1207959552,1275068416,1140850688,0,201326592,1191182336,838860800,1174405120,1409286144,1224736768,1275068416,754974720,234881024,268435456,50331648,201326592,1275068416,1342177280,1073741824,1090519040,1023410176,872415232,1241513984,687865856,570425344,754974720,973078528,838860800,939524096,973078528,1090519040,989855744,1241513984,872415232,1040187392,352321536,939524096,1577058304,1325400064,570425344,0,905969664,1107296256,1459617792,587202560,234881024,1342177280,1912602624,570425344,33554432,16777216,0,0,0,0,16777216,16777216,16777216,50331648,83886080,134217728,184549376,218103808,83886080,167772160,167772160,553648128,754974720,872415232,1107296256,788529152,671088640,167772160,251658240,486539264,1006632960,1409286144,1157627904,1207959552,956301312,939524096,1090519040,1392508928,1174405120,1526726656,1509949440,1644167168,16777216,1023410176,654311424,553648128,788529152,486539264,1207959552,469762048,369098752,486539264,620756992,83886080,201326592,1241513984,704643072,637534208,134217728,1023410176,1392508928,822083584,167772160,268435456,1040187392,587202560,754974720,1140850688,486539264,788529152,1090519040,989855744,704643072,1157627904,822083584,1056964608,1291845632,1291845632,1073741824,754974720,570425344,587202560,1358954496,939524096,50331648,0,0,0,33554432,16777216,0,0,0,0,0,0,0,16777216,67108864,117440512,167772160,201326592,150994944,503316480,637534208,268435456,0,301989888,771751936,989855744,721420288,352321536,67108864,385875968,704643072,1191182336,771751936,905969664,1224736768,1459617792,1409286144,1493172224,1358954496,1275068416,1358954496,369098752,402653184,486539264,1107296256,1610612736,1191182336,268435456,436207616,0,318767104,503316480,536870912,117440512,587202560,402653184,973078528,905969664,738197504,503316480,1124073472,771751936,587202560,1056964608,721420288,469762048,973078528,520093696,117440512,503316480,134217728,503316480,1174405120,1040187392,989855744,889192448,637534208,738197504,637534208,687865856,620756992,201326592,603979776,1291845632,1157627904,251658240,83886080,0,0,0,0,0,0,0,0,0,0,0,16777216,67108864,100663296,117440512,201326592,587202560,838860800,335544320,184549376,436207616,167772160,0,1174405120,268435456,201326592,704643072,486539264,1090519040,1107296256,536870912,1107296256,1325400064,1358954496,1509949440,1426063360,1543503872,1375731712,436207616,553648128,251658240,1358954496,1577058304,956301312,1426063360,1224736768,520093696,620756992,1409286144,117440512,0,268435456,620756992,1023410176,1207959552,1140850688,1124073472,771751936,620756992,989855744,1073741824,620756992,754974720,419430400,1073741824,603979776,369098752,620756992,419430400,301989888,486539264,1174405120,805306368,452984832,452984832,234881024,1040187392,1124073472,671088640,0,352321536,251658240,67108864,134217728,0,83886080,0,0,0,0,0,16777216,0,0,0,0,0,16777216,33554432,150994944,469762048,587202560,184549376,268435456,671088640,637534208,704643072,1090519040,83886080,0,738197504,1241513984,1040187392,1191182336,1174405120,1006632960,1308622848,0,788529152,1375731712,1493172224,905969664,570425344,268435456,503316480,167772160,671088640,721420288,956301312,1191182336,855638016,1325400064,1526726656,1275068416,33554432,234881024,0,637534208,50331648,201326592,939524096,117440512,201326592,503316480,251658240,234881024,285212672,553648128,251658240,419430400,369098752,385875968,536870912,687865856,503316480,704643072,268435456,1342177280,1157627904,889192448,520093696,771751936,671088640,889192448,989855744,0,83886080,100663296,0,0,33554432,0,0,0,0,16777216,16777216,0,0,0,0,0,0,33554432,318767104,419430400,385875968,469762048,520093696,603979776,788529152,587202560,285212672,33554432,469762048,1090519040,905969664,1224736768,1207959552,1107296256,1509949440,687865856,1090519040,1442840576,1644167168,0,536870912,1459617792,587202560,771751936,1073741824,570425344,0,150994944,167772160,436207616,1426063360,1207959552,0,167772160,855638016,1191182336,167772160,637534208,738197504,587202560,603979776,520093696,838860800,939524096,805306368,721420288,0,318767104,150994944,134217728,352321536,721420288,1375731712,570425344,67108864,419430400,587202560,1056964608,1258291200,1090519040,100663296,503316480,1258291200,503316480,201326592,0,16777216,0,67108864,0,0,0,0,0,0,0,0,0,0,16777216,33554432,218103808,150994944,100663296,234881024,369098752,369098752,436207616,603979776,369098752,587202560,251658240,536870912,587202560,754974720,1275068416,989855744,1107296256,1006632960,956301312,1426063360,1325400064,1593835520,704643072,0,1207959552,0,704643072,1476395008,1375731712,553648128,1660944384,1442840576,838860800,352321536,50331648,0,16777216,150994944,1174405120,150994944,603979776,402653184,335544320,251658240,167772160,486539264,637534208,637534208,1107296256,738197504,1275068416,687865856,268435456,134217728,0,251658240,436207616,687865856,318767104,150994944,402653184,603979776,939524096,184549376,167772160,0,184549376,100663296,0,117440512,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,385875968,318767104,570425344,486539264,285212672,251658240,134217728,285212672,335544320,553648128,0,637534208,1157627904,637534208,973078528,1375731712,1275068416,369098752,1090519040,1174405120,822083584,1375731712,1157627904,671088640,1275068416,50331648,0,335544320,956301312,301989888,335544320,1073741824,1023410176,889192448,402653184,33554432,83886080,0,922746880,0,0,285212672,83886080,150994944,218103808,16777216,285212672,167772160,520093696,503316480,805306368,469762048,520093696,671088640,301989888,251658240,0,134217728,469762048,318767104,956301312,0,285212672,520093696,1325400064,452984832,16777216,117440512,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,452984832,301989888,251658240,570425344,335544320,419430400,486539264,385875968,50331648,620756992,1124073472,637534208,1241513984,738197504,1426063360,738197504,671088640,973078528,1409286144,1174405120,486539264,553648128,2030043136,1157627904,83886080,520093696,335544320,268435456,234881024,167772160,1124073472,1207959552,721420288,67108864,100663296,855638016,1509949440,67108864,150994944,352321536,436207616,436207616,419430400,469762048,989855744,603979776,553648128,436207616,553648128,469762048,234881024,251658240,654311424,1140850688,704643072,469762048,0,67108864,603979776,805306368,0,436207616,436207616,1409286144,150994944,33554432,50331648,33554432,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,50331648,0,83886080,318767104,285212672,352321536,486539264,251658240,436207616,486539264,16777216,721420288,922746880,822083584,754974720,0,1140850688,402653184,1107296256,184549376,905969664,1291845632,469762048,100663296,503316480,1040187392,385875968,1342177280,318767104,117440512,352321536,553648128,50331648,33554432,503316480,0,0,402653184,939524096,16777216,251658240,150994944,201326592,385875968,520093696,553648128,452984832,285212672,436207616,100663296,452984832,150994944,150994944,234881024,301989888,100663296,184549376,83886080,553648128,570425344,234881024,889192448,1207959552,268435456,67108864,50331648,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,16777216,16777216,100663296,50331648,184549376,385875968,150994944,117440512,251658240,0,905969664,587202560,687865856,956301312,1006632960,721420288,536870912,1124073472,50331648,469762048,1660944384,855638016,469762048,1191182336,301989888,33554432,486539264,285212672,218103808,134217728,268435456,285212672,50331648,167772160,83886080,83886080,67108864,234881024,0,16777216,100663296,117440512,50331648,33554432,83886080,117440512,117440512,100663296,285212672,218103808,0,0,0,251658240,100663296,83886080,0,150994944,150994944,0,83886080,419430400,218103808,67108864,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,117440512,100663296,83886080,33554432,234881024,452984832,234881024,436207616,352321536,83886080,754974720,587202560,973078528,419430400,872415232,654311424,1191182336,1677721600,352321536,1224736768,1258291200,0,587202560,1711276032,822083584,536870912,184549376,67108864,201326592,117440512,16777216,167772160,218103808,0,33554432,50331648,134217728,0,0,251658240,402653184,335544320,268435456,402653184,452984832,285212672,184549376,218103808,419430400,1174405120,167772160,301989888,0,16777216,184549376,184549376,50331648,16777216,83886080,50331648,0,0,117440512,50331648,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,67108864,83886080,33554432,117440512,301989888,150994944,285212672,218103808,83886080,603979776,822083584,704643072,33554432,1124073472,587202560,587202560,1459617792,620756992,687865856,1375731712,234881024,50331648,150994944,1660944384,721420288,1006632960,184549376,100663296,134217728,352321536,0,234881024,0,0,0,318767104,117440512,16777216,67108864,184549376,67108864,83886080,385875968,402653184,167772160,100663296,536870912,603979776,352321536,201326592,83886080,201326592,117440512,50331648,117440512,100663296,50331648,83886080,150994944,100663296,0,0,50331648,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,100663296,67108864,0,117440512,100663296,369098752,872415232,570425344,603979776,855638016,469762048,956301312,1342177280,117440512,419430400,352321536,452984832,50331648,1493172224,318767104,1459617792,150994944,50331648,855638016,553648128,218103808,117440512,251658240,251658240,83886080,50331648,0,33554432,16777216,150994944,83886080,16777216,184549376,268435456,117440512,0,0,0,0,268435456,117440512,117440512,150994944,301989888,0,50331648,83886080,33554432,33554432,33554432,50331648,0,0,0,67108864,33554432,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,33554432,0,100663296,134217728,50331648,184549376,268435456,251658240,33554432,603979776,67108864,369098752,687865856,989855744,1073741824,788529152,1056964608,1409286144,201326592,33554432,268435456,117440512,1040187392,687865856,721420288,50331648,0,134217728,100663296,0,100663296,167772160,16777216,50331648,67108864,0,50331648,117440512,0,50331648,134217728,134217728,150994944,167772160,201326592,486539264,989855744,1426063360,503316480,738197504,117440512,184549376,67108864,100663296,0,150994944,0,0,50331648,0,33554432,117440512,50331648,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,50331648,167772160,218103808,251658240,184549376,50331648,603979776,754974720,0,536870912,587202560,721420288,469762048,805306368,1006632960,184549376,369098752,0,520093696,352321536,989855744,452984832,83886080,33554432,0,0,100663296,50331648,100663296,67108864,16777216,0,117440512,150994944,50331648,134217728,100663296,67108864,67108864,67108864,33554432,117440512,251658240,117440512,184549376,33554432,201326592,0,0,100663296,50331648,83886080,0,0,0,83886080,83886080,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134217728,16777216,0,67108864,50331648,100663296,50331648,0,134217728,117440512,318767104,905969664,922746880,218103808,570425344,16777216,16777216,637534208,1124073472,134217728,771751936,436207616,150994944,50331648,771751936,117440512,150994944,0,67108864,117440512,0,0,100663296,0,16777216,0,83886080,0,184549376,117440512,67108864,50331648,16777216,0,33554432,67108864,0,16777216,16777216,67108864,0,33554432,201326592,0,33554432,0,184549376,100663296,0,0,16777216,0,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,0,0,33554432,0,16777216,503316480,1090519040,570425344,0,83886080,201326592,1375731712,687865856,419430400,973078528,50331648,0,0,385875968,184549376,234881024,150994944,1694498816,771751936,503316480,0,33554432,134217728,0,83886080,0,83886080,83886080,67108864,50331648,33554432,16777216,0,0,67108864,67108864,67108864,67108864,67108864,67108864,67108864,67108864,167772160,150994944,134217728,100663296,83886080,50331648,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,67108864,50331648,117440512,251658240,1459617792,553648128,67108864,0,503316480,134217728,251658240,1342177280,83886080,285212672,234881024,117440512,16777216,0,167772160,1476395008,1593835520,1191182336,268435456,0,0,0,100663296,83886080,16777216,16777216,16777216,33554432,33554432,33554432,50331648,50331648,33554432,33554432,33554432,16777216,16777216,0,0,0,67108864,67108864,50331648,50331648,50331648,33554432,33554432,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,33554432,83886080,16777216,0,218103808,100663296,83886080,100663296,167772160,0,117440512,1275068416,989855744,369098752,385875968,620756992,486539264,0,0,150994944,1140850688,218103808,0,117440512,16777216,0,0,0,0,0,0,16777216,33554432,33554432,50331648,50331648,67108864,50331648,50331648,33554432,16777216,16777216,0,0,0,0,0,16777216,16777216,16777216,33554432,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,50331648,0,0,50331648,83886080,33554432,0,67108864,100663296,134217728,234881024,268435456,134217728,620756992,369098752,117440512,251658240,369098752,201326592,117440512,452984832,117440512,0,0,83886080,33554432,67108864,134217728,0,50331648,0,0,0,0,0,16777216,16777216,16777216,67108864,67108864,67108864,50331648,50331648,33554432,33554432,33554432,16777216,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,67108864,33554432,0,0,0,0,33554432,0,0,167772160,402653184,553648128,805306368,33554432,83886080,0,352321536,419430400,16777216,285212672,973078528,1526726656,201326592,0,0,0,0,0,0,16777216,16777216,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,0,0,16777216,50331648,16777216,0,0,0,16777216,134217728,16777216,50331648,0,150994944,419430400,0,234881024,0,167772160,100663296,33554432,0,67108864,167772160,117440512,134217728,0,67108864,150994944,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,0,0,0,0,16777216,33554432,67108864,117440512,0,0,0,100663296,0,50331648,50331648,83886080,0,0,318767104,0,0,50331648,184549376,150994944,0,0,67108864,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,67108864,16777216,0,0,0,0,0,0,16777216,50331648,0,0,83886080,16777216,0,83886080,16777216,33554432,0,117440512,0,0,0,83886080,50331648,0,16777216,0,0,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        ]);
        private var shimonData04:Vector.<uint> = Vector.<uint>([
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100663296,33554432,16777216,33554432,0,16777216,0,0,50331648,0,33554432,16777216,0,83886080,0,16777216,67108864,0,67108864,33554432,0,16777216,0,0,0,16777216,0,0,0,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,16777216,16777216,0,16777216,16777216,16777216,16777216,16777216,0,16777216,16777216,0,117440512,33554432,33554432,0,0,0,117440512,0,33554432,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100663296,117440512,16777216,16777216,67108864,117440512,0,0,50331648,0,234881024,134217728,100663296,117440512,0,0,134217728,0,150994944,0,50331648,100663296,452984832,167772160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,33554432,0,67108864,0,33554432,0,0,0,251658240,503316480,285212672,0,939524096,1124073472,335544320,67108864,184549376,0,33554432,16777216,16777216,50331648,50331648,33554432,0,0,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117440512,67108864,0,16777216,16777216,218103808,0,134217728,100663296,0,469762048,452984832,754974720,1543503872,1023410176,234881024,201326592,67108864,67108864,67108864,536870912,838860800,318767104,218103808,100663296,134217728,184549376,184549376,100663296,0,0,33554432,0,0,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,100663296,117440512,0,184549376,100663296,520093696,989855744,2130706432,1358954496,335544320,520093696,218103808,0,150994944,33554432,285212672,469762048,16777216,822083584,620756992,0,117440512,134217728,150994944,201326592,218103808,117440512,0,0,33554432,0,0,0,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,218103808,0,0,251658240,536870912,973078528,469762048,503316480,0,16777216,16777216,0,201326592,822083584,1023410176,1006632960,838860800,1258291200,1526726656,150994944,335544320,1107296256,905969664,419430400,184549376,134217728,134217728,167772160,134217728,33554432,16777216,67108864,100663296,83886080,33554432,0,0,0,16777216,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117440512,369098752,486539264,167772160,218103808,0,33554432,134217728,335544320,402653184,872415232,1107296256,855638016,603979776,100663296,117440512,0,67108864,33554432,771751936,1627389952,788529152,184549376,268435456,150994944,100663296,167772160,184549376,150994944,117440512,150994944,251658240,201326592,117440512,33554432,0,0,16777216,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,0,0,33554432,0,100663296,0,134217728,637534208,184549376,134217728,0,251658240,201326592,788529152,889192448,1056964608,1124073472,1308622848,503316480,486539264,603979776,83886080,134217728,335544320,218103808,805306368,788529152,872415232,385875968,167772160,16777216,117440512,0,134217728,150994944,150994944,16777216,201326592,268435456,117440512,67108864,33554432,50331648,33554432,0,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,33554432,33554432,16777216,67108864,100663296,301989888,33554432,0,134217728,16777216,0,536870912,738197504,419430400,150994944,117440512,150994944,117440512,100663296,0,570425344,687865856,234881024,1023410176,872415232,1761607680,1694498816,1090519040,855638016,1442840576,1375731712,1627389952,1107296256,452984832,285212672,385875968,553648128,352321536,318767104,251658240,83886080,100663296,134217728,167772160,117440512,33554432,16777216,33554432,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,16777216,0,0,33554432,335544320,134217728,0,83886080,150994944,352321536,872415232,268435456,33554432,100663296,184549376,117440512,0,251658240,385875968,1241513984,452984832,637534208,721420288,335544320,369098752,553648128,503316480,889192448,973078528,721420288,318767104,268435456,0,0,134217728,201326592,0,0,16777216,83886080,117440512,167772160,184549376,117440512,16777216,0,33554432,33554432,16777216,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,16777216,67108864,0,0,150994944,117440512,117440512,0,83886080,0,0,0,268435456,117440512,268435456,268435456,838860800,872415232,603979776,486539264,738197504,838860800,603979776,486539264,721420288,1409286144,1124073472,1509949440,1325400064,1241513984,419430400,872415232,687865856,402653184,218103808,134217728,83886080,117440512,0,0,0,33554432,50331648,67108864,83886080,117440512,150994944,0,0,0,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,50331648,218103808,117440512,33554432,16777216,0,67108864,100663296,0,436207616,469762048,436207616,1157627904,771751936,402653184,335544320,134217728,0,385875968,687865856,1006632960,33554432,469762048,117440512,939524096,654311424,201326592,536870912,1526726656,1577058304,1308622848,687865856,754974720,469762048,318767104,218103808,234881024,335544320,268435456,184549376,150994944,117440512,83886080,83886080,83886080,50331648,16777216,16777216,0,0,0,16777216,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,100663296,16777216,134217728,33554432,67108864,33554432,33554432,134217728,117440512,251658240,520093696,788529152,771751936,1224736768,134217728,100663296,0,234881024,100663296,503316480,419430400,234881024,100663296,268435456,134217728,872415232,620756992,704643072,620756992,1241513984,671088640,67108864,0,100663296,0,83886080,50331648,0,83886080,134217728,251658240,234881024,201326592,184549376,201326592,184549376,100663296,0,100663296,50331648,0,16777216,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,67108864,0,117440512,0,50331648,117440512,201326592,251658240,0,150994944,520093696,687865856,0,201326592,83886080,369098752,939524096,1006632960,486539264,1191182336,939524096,1174405120,1744830464,1946157056,1056964608,1879048192,2130706432,1996488704,1509949440,1644167168,1711276032,1157627904,1207959552,1073741824,301989888,184549376,167772160,150994944,67108864,0,16777216,50331648,83886080,117440512,201326592,268435456,285212672,234881024,134217728,67108864,0,16777216,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,67108864,335544320,83886080,150994944,201326592,268435456,234881024,83886080,50331648,0,33554432,201326592,436207616,872415232,1040187392,989855744,620756992,822083584,117440512,620756992,603979776,33554432,0,0,318767104,134217728,167772160,486539264,570425344,587202560,469762048,1073741824,1258291200,536870912,234881024,100663296,218103808,285212672,100663296,150994944,150994944,100663296,16777216,0,50331648,83886080,67108864,100663296,16777216,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83886080,0,0,67108864,16777216,0,0,0,419430400,1090519040,520093696,33554432,83886080,117440512,0,150994944,83886080,150994944,234881024,335544320,1023410176,369098752,16777216,0,0,0,100663296,167772160,83886080,0,251658240,134217728,67108864,469762048,738197504,234881024,0,50331648,0,0,0,0,150994944,184549376,117440512,150994944,285212672,570425344,469762048,385875968,268435456,117440512,83886080,117440512,83886080,0,201326592,587202560,83886080,100663296,0,50331648,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,16777216,0,0,0,385875968,1023410176,1660944384,1409286144,268435456,201326592,67108864,184549376,117440512,385875968,469762048,50331648,201326592,251658240,369098752,268435456,33554432,503316480,989855744,1342177280,1426063360,1526726656,1627389952,1040187392,1342177280,1677721600,1811939328,1761607680,1828716544,1593835520,1358954496,1157627904,788529152,1442840576,956301312,486539264,50331648,0,16777216,16777216,0,0,100663296,117440512,117440512,83886080,67108864,50331648,67108864,100663296,150994944,0,553648128,402653184,0,16777216,0,67108864,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,83886080,301989888,989855744,1811939328,1157627904,352321536,117440512,0,16777216,335544320,352321536,1023410176,352321536,520093696,654311424,218103808,83886080,234881024,536870912,1023410176,1140850688,1610612736,1275068416,1493172224,1392508928,587202560,1023410176,1023410176,503316480,1040187392,1358954496,1476395008,671088640,1442840576,1291845632,1660944384,654311424,419430400,268435456,268435456,301989888,251658240,167772160,134217728,50331648,117440512,50331648,0,33554432,0,0,83886080,67108864,83886080,0,0,67108864,0,50331648,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,33554432,16777216,83886080,234881024,503316480,738197504,0,16777216,452984832,469762048,486539264,234881024,603979776,687865856,301989888,150994944,0,83886080,16777216,268435456,536870912,536870912,0,0,16777216,67108864,0,0,0,33554432,0,67108864,0,0,50331648,0,50331648,50331648,67108864,83886080,134217728,134217728,100663296,100663296,218103808,385875968,335544320,436207616,301989888,201326592,301989888,201326592,33554432,117440512,33554432,134217728,33554432,0,117440512,0,0,67108864,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,33554432,67108864,100663296,67108864,50331648,50331648,16777216,150994944,285212672,268435456,402653184,620756992,352321536,150994944,335544320,419430400,486539264,335544320,939524096,838860800,989855744,1426063360,738197504,838860800,905969664,1191182336,1090519040,1090519040,1107296256,1828716544,1526726656,1509949440,1828716544,1627389952,1409286144,1023410176,989855744,1174405120,922746880,301989888,218103808,117440512,16777216,0,0,16777216,83886080,167772160,301989888,218103808,234881024,419430400,285212672,33554432,33554432,0,167772160,251658240,788529152,318767104,0,150994944,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,16777216,134217728,50331648,100663296,486539264,872415232,1056964608,201326592,318767104,218103808,385875968,285212672,201326592,654311424,704643072,318767104,285212672,553648128,268435456,0,1174405120,1258291200,1275068416,1728053248,1409286144,1744830464,1056964608,1459617792,1711276032,1493172224,1728053248,1560281088,2030043136,1157627904,1140850688,1459617792,1711276032,469762048,268435456,268435456,251658240,234881024,234881024,234881024,201326592,150994944,50331648,67108864,0,0,150994944,150994944,50331648,67108864,100663296,0,251658240,536870912,234881024,872415232,50331648,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100663296,0,67108864,134217728,0,0,452984832,889192448,855638016,150994944,134217728,301989888,150994944,0,486539264,234881024,0,0,201326592,0,0,67108864,452984832,100663296,134217728,0,587202560,0,184549376,0,0,0,0,100663296,0,0,83886080,536870912,184549376,83886080,16777216,83886080,117440512,83886080,134217728,251658240,385875968,436207616,285212672,218103808,100663296,33554432,67108864,100663296,150994944,184549376,117440512,234881024,0,0,201326592,939524096,637534208,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,50331648,251658240,285212672,67108864,0,33554432,0,33554432,0,0,402653184,369098752,1174405120,721420288,419430400,436207616,369098752,805306368,889192448,1224736768,1593835520,1308622848,1426063360,771751936,1476395008,1056964608,973078528,1593835520,889192448,1426063360,1392508928,671088640,939524096,436207616,1224736768,1308622848,1593835520,1040187392,268435456,100663296,117440512,117440512,83886080,100663296,167772160,150994944,67108864,234881024,218103808,234881024,218103808,100663296,50331648,50331648,0,318767104,352321536,369098752,234881024,83886080,218103808,1157627904,285212672,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83886080,67108864,486539264,201326592,0,0,83886080,16777216,520093696,1073741824,1308622848,1694498816,1291845632,1711276032,738197504,603979776,520093696,1107296256,520093696,788529152,788529152,1291845632,1157627904,1174405120,1090519040,1426063360,1627389952,1627389952,1493172224,1023410176,1140850688,1040187392,1375731712,1241513984,1744830464,1509949440,268435456,1778384896,436207616,67108864,100663296,83886080,83886080,150994944,268435456,318767104,184549376,16777216,67108864,100663296,150994944,268435456,301989888,251658240,134217728,50331648,33554432,167772160,301989888,469762048,134217728,16777216,16777216,16777216,50331648,16777216,50331648,0,33554432,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,0,67108864,167772160,419430400,268435456,352321536,855638016,1610612736,1711276032,1644167168,503316480,268435456,0,0,318767104,0,0,268435456,570425344,67108864,83886080,503316480,16777216,16777216,0,0,0,520093696,838860800,117440512,268435456,83886080,16777216,939524096,1644167168,822083584,0,0,83886080,167772160,184549376,167772160,201326592,218103808,201326592,117440512,150994944,234881024,100663296,201326592,469762048,385875968,268435456,268435456,150994944,67108864,67108864,1056964608,788529152,452984832,0,0,0,83886080,0,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100663296,117440512,0,0,134217728,100663296,301989888,100663296,67108864,1124073472,1207959552,1593835520,503316480,0,167772160,251658240,385875968,855638016,973078528,1526726656,1308622848,1241513984,553648128,1392508928,922746880,1426063360,1610612736,1056964608,1207959552,1459617792,1442840576,1761607680,1358954496,452984832,1677721600,1207959552,1040187392,1224736768,184549376,369098752,251658240,268435456,218103808,83886080,0,50331648,201326592,318767104,369098752,251658240,201326592,0,0,234881024,167772160,150994944,520093696,754974720,67108864,50331648,0,956301312,754974720,1224736768,117440512,16777216,33554432,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,0,83886080,16777216,83886080,150994944,33554432,83886080,33554432,50331648,184549376,33554432,134217728,402653184,603979776,1308622848,1174405120,1090519040,939524096,1694498816,1677721600,1157627904,1107296256,1124073472,738197504,620756992,553648128,603979776,553648128,570425344,402653184,452984832,973078528,503316480,754974720,1426063360,1426063360,1660944384,1392508928,234881024,100663296,167772160,201326592,234881024,268435456,268435456,218103808,134217728,50331648,167772160,251658240,419430400,637534208,469762048,83886080,16777216,117440512,301989888,1124073472,117440512,452984832,352321536,16777216,201326592,486539264,436207616,50331648,0,33554432,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,0,0,67108864,83886080,83886080,83886080,0,117440512,318767104,520093696,637534208,1073741824,637534208,989855744,822083584,1291845632,385875968,536870912,83886080,0,0,654311424,822083584,872415232,973078528,50331648,150994944,754974720,352321536,335544320,754974720,436207616,335544320,16777216,1442840576,1560281088,1207959552,1493172224,889192448,234881024,83886080,83886080,134217728,251658240,335544320,318767104,201326592,83886080,0,33554432,117440512,838860800,1006632960,469762048,318767104,134217728,0,117440512,218103808,201326592,939524096,318767104,0,603979776,335544320,16777216,16777216,50331648,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,150994944,0,50331648,83886080,33554432,117440512,0,167772160,419430400,318767104,570425344,301989888,251658240,150994944,0,184549376,150994944,117440512,1056964608,1308622848,1224736768,1308622848,1744830464,1090519040,1207959552,1493172224,1308622848,1979711488,2113929216,1358954496,1056964608,1895825408,1325400064,1761607680,1342177280,1644167168,1711276032,1493172224,452984832,436207616,318767104,218103808,134217728,83886080,83886080,100663296,150994944,201326592,419430400,285212672,0,33554432,150994944,134217728,520093696,570425344,436207616,67108864,50331648,268435456,637534208,989855744,637534208,0,16777216,0,117440512,33554432,0,67108864,67108864,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,67108864,0,33554432,318767104,167772160,201326592,150994944,251658240,234881024,50331648,117440512,0,738197504,637534208,1157627904,1392508928,1660944384,1426063360,1543503872,1275068416,1023410176,1375731712,1392508928,1157627904,721420288,1358954496,1493172224,1056964608,251658240,0,33554432,201326592,1157627904,1358954496,1090519040,1761607680,1207959552,1560281088,788529152,0,234881024,201326592,201326592,234881024,218103808,134217728,50331648,33554432,0,218103808,520093696,452984832,234881024,117440512,134217728,201326592,486539264,83886080,620756992,167772160,0,402653184,754974720,352321536,201326592,0,83886080,50331648,0,33554432,67108864,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,0,83886080,218103808,704643072,352321536,117440512,167772160,83886080,0,184549376,352321536,1140850688,2046820352,1191182336,1426063360,1526726656,905969664,385875968,570425344,335544320,620756992,285212672,16777216,738197504,805306368,1157627904,1543503872,1275068416,637534208,805306368,754974720,805306368,2080374784,922746880,1174405120,1375731712,1493172224,1778384896,721420288,201326592,100663296,16777216,33554432,184549376,318767104,335544320,268435456,218103808,234881024,0,83886080,100663296,452984832,771751936,218103808,16777216,0,369098752,201326592,520093696,671088640,0,436207616,738197504,721420288,50331648,0,83886080,16777216,0,0,0,0,0,0,0,16777216,16777216,16777216,0,0,0,16777216,16777216,16777216,16777216,16777216,33554432,16777216,117440512,117440512,33554432,117440512,150994944,0,117440512,620756992,654311424,989855744,1073741824,251658240,637534208,16777216,301989888,1056964608,251658240,1124073472,939524096,1056964608,1157627904,1627389952,1493172224,1509949440,1325400064,1291845632,1677721600,1577058304,1476395008,1442840576,1476395008,1593835520,1677721600,1442840576,1560281088,100663296,134217728,234881024,150994944,100663296,150994944,100663296,117440512,201326592,167772160,234881024,268435456,218103808,285212672,33554432,100663296,335544320,603979776,385875968,301989888,0,704643072,620756992,419430400,570425344,33554432,100663296,268435456,100663296,0,0,16777216,50331648,50331648,0,0,0,0,0,16777216,16777216,16777216,50331648,50331648,16777216,0,0,50331648,83886080,50331648,234881024,67108864,33554432,16777216,0,0,167772160,184549376,536870912,671088640,721420288,452984832,0,0,503316480,1627389952,1392508928,1191182336,1560281088,1493172224,1526726656,1140850688,1224736768,1375731712,1275068416,822083584,520093696,503316480,1040187392,855638016,973078528,1275068416,1291845632,1409286144,1291845632,1459617792,1895825408,704643072,0,184549376,301989888,134217728,150994944,167772160,184549376,134217728,0,33554432,167772160,587202560,536870912,620756992,301989888,134217728,0,419430400,553648128,335544320,0,352321536,167772160,922746880,1224736768,301989888,0,67108864,134217728,83886080,16777216,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,33554432,0,0,0,67108864,67108864,16777216,0,0,0,150994944,167772160,201326592,352321536,452984832,352321536,234881024,33554432,0,352321536,1610612736,1677721600,1191182336,83886080,788529152,1442840576,1023410176,318767104,234881024,738197504,1291845632,989855744,218103808,520093696,956301312,570425344,0,721420288,1509949440,1526726656,1526726656,1291845632,1526726656,1811939328,1291845632,637534208,218103808,167772160,0,83886080,184549376,234881024,167772160,100663296,268435456,67108864,33554432,234881024,452984832,553648128,385875968,201326592,16777216,134217728,570425344,721420288,704643072,0,436207616,1325400064,1241513984,67108864,50331648,67108864,67108864,33554432,0,0,0,0,0,0,0,16777216,16777216,16777216,0,0,50331648,100663296,100663296,67108864,33554432,33554432,33554432,50331648,167772160,268435456,234881024,150994944,117440512,134217728,0,201326592,788529152,1560281088,1728053248,889192448,301989888,553648128,1308622848,1006632960,1174405120,553648128,905969664,1509949440,1392508928,1442840576,1275068416,1560281088,1459617792,956301312,1342177280,1694498816,1493172224,1526726656,1761607680,1593835520,1409286144,268435456,805306368,704643072,134217728,436207616,268435456,117440512,134217728,67108864,0,50331648,184549376,503316480,503316480,218103808,234881024,67108864,369098752,721420288,1040187392,654311424,67108864,268435456,251658240,520093696,587202560,201326592,603979776,587202560,687865856,268435456,0,0,33554432,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,117440512,251658240,218103808,83886080,67108864,167772160,134217728,184549376,134217728,33554432,0,33554432,50331648,50331648,637534208,754974720,1426063360,1006632960,201326592,285212672,889192448,1778384896,939524096,469762048,218103808,1224736768,1660944384,1426063360,1677721600,1191182336,1476395008,1073741824,1191182336,872415232,1375731712,1493172224,1090519040,1476395008,1509949440,1610612736,1694498816,1291845632,1560281088,436207616,0,117440512,285212672,285212672,369098752,268435456,150994944,117440512,33554432,117440512,167772160,570425344,385875968,234881024,16777216,218103808,369098752,838860800,1090519040,134217728,167772160,234881024,654311424,369098752,0,436207616,838860800,503316480,150994944,16777216,16777216,16777216,0,0,0,0,0,0,16777216,16777216,16777216,67108864,33554432,117440512,234881024,201326592,83886080,100663296,234881024,0,33554432,0,0,100663296,301989888,402653184,469762048,788529152,855638016,167772160,0,369098752,1090519040,620756992,33554432,0,1241513984,1291845632,1124073472,1275068416,1157627904,570425344,486539264,956301312,1426063360,486539264,1862270976,503316480,905969664,1476395008,1241513984,1426063360,754974720,1174405120,1291845632,1241513984,1023410176,402653184,603979776,184549376,167772160,268435456,268435456,352321536,452984832,369098752,369098752,100663296,167772160,369098752,671088640,536870912,167772160,33554432,285212672,268435456,637534208,318767104,117440512,134217728,687865856,872415232,0,285212672,402653184,352321536,100663296,0,0,33554432,0,0,0,0,0,16777216,16777216,16777216,0,33554432,100663296,134217728,167772160,167772160,134217728,100663296,0,100663296,100663296,150994944,335544320,369098752,318767104,352321536,134217728,0,0,1090519040,1006632960,402653184,738197504,1275068416,1761607680,754974720,603979776,436207616,687865856,671088640,1375731712,973078528,1358954496,1241513984,1392508928,1107296256,1358954496,1627389952,1459617792,1224736768,1593835520,1241513984,201326592,0,0,452984832,671088640,1325400064,369098752,167772160,100663296,16777216,100663296,385875968,620756992,922746880,469762048,0,134217728,251658240,486539264,335544320,419430400,83886080,167772160,318767104,520093696,318767104,33554432,301989888,905969664,1442840576,218103808,251658240,201326592,50331648,0,0,16777216,0,0,0,0,0,16777216,16777216,16777216,0,67108864,134217728,134217728,201326592,301989888,184549376,0,150994944,184549376,167772160,251658240,369098752,184549376,0,0,100663296,671088640,1459617792,889192448,1157627904,1442840576,1174405120,721420288,251658240,0,872415232,1258291200,1241513984,1459617792,989855744,1308622848,1006632960,1107296256,1543503872,1073741824,1107296256,1157627904,1258291200,1174405120,1174405120,1358954496,1543503872,1342177280,234881024,134217728,0,16777216,385875968,301989888,402653184,352321536,150994944,16777216,67108864,369098752,335544320,704643072,436207616,67108864,0,369098752,402653184,419430400,0,369098752,838860800,436207616,503316480,0,83886080,654311424,822083584,318767104,0,0,83886080,16777216,0,0,0,0,0,0,16777216,16777216,16777216,33554432,16777216,16777216,33554432,0,0,100663296,218103808,117440512,83886080,117440512,335544320,100663296,167772160,452984832,889192448,1828716544,654311424,184549376,50331648,620756992,184549376,0,603979776,469762048,1090519040,1375731712,1409286144,1493172224,536870912,318767104,1090519040,922746880,922746880,822083584,1509949440,1375731712,1241513984,1191182336,1275068416,16777216,201326592,738197504,771751936,603979776,369098752,486539264,335544320,16777216,218103808,67108864,318767104,285212672,268435456,285212672,301989888,0,83886080,771751936,1107296256,687865856,83886080,33554432,788529152,687865856,134217728,268435456,570425344,922746880,503316480,201326592,402653184,1090519040,352321536,150994944,16777216,16777216,0,16777216,0,0,0,0,0,16777216,16777216,16777216,0,33554432,0,0,0,184549376,218103808,117440512,0,0,67108864,150994944,100663296,285212672,452984832,520093696,0,167772160,167772160,385875968,1107296256,855638016,1543503872,1375731712,754974720,956301312,889192448,536870912,201326592,419430400,419430400,1207959552,1157627904,872415232,1258291200,1056964608,1258291200,1006632960,1224736768,1426063360,1342177280,704643072,83886080,0,318767104,150994944,201326592,486539264,939524096,603979776,167772160,184549376,268435456,419430400,486539264,469762048,218103808,0,100663296,788529152,520093696,553648128,234881024,0,218103808,536870912,385875968,0,50331648,570425344,1124073472,402653184,117440512,419430400,553648128,117440512,100663296,0,0,0,0,0,0,0,16777216,16777216,16777216,0,50331648,83886080,50331648,100663296,184549376,117440512,0,167772160,201326592,385875968,385875968,234881024,33554432,50331648,50331648,234881024,671088640,973078528,872415232,436207616,603979776,402653184,33554432,16777216,738197504,771751936,1493172224,1207959552,1107296256,1157627904,704643072,855638016,1224736768,738197504,587202560,1258291200,838860800,1040187392,1291845632,905969664,822083584,872415232,1023410176,956301312,201326592,0,385875968,385875968,268435456,402653184,251658240,0,0,100663296,318767104,385875968,486539264,318767104,67108864,285212672,117440512,603979776,687865856,33554432,0,134217728,587202560,268435456,620756992,1174405120,587202560,201326592,100663296,318767104,150994944,33554432,0,33554432,0,0,0,0,0,16777216,16777216,16777216,16777216,33554432,117440512,184549376,134217728,16777216,33554432,150994944,117440512,201326592,486539264,369098752,234881024,100663296,520093696,805306368,905969664,536870912,167772160,0,452984832,1191182336,83886080,620756992,1342177280,1241513984,1392508928,1040187392,721420288,922746880,771751936,536870912,922746880,1325400064,570425344,788529152,1258291200,922746880,1291845632,1258291200,637534208,251658240,301989888,570425344,570425344,452984832,452984832,385875968,587202560,33554432,150994944,117440512,268435456,318767104,201326592,0,0,704643072,570425344,553648128,184549376,50331648,67108864,620756992,352321536,218103808,0,754974720,704643072,637534208,134217728,654311424,738197504,67108864,50331648,33554432,0,0,67108864,0,0,0,0,0,16777216,16777216,16777216,83886080,50331648,50331648,83886080,33554432,16777216,167772160,385875968,268435456,33554432,33554432,33554432,318767104,452984832,704643072,671088640,0,0,738197504,1157627904,1409286144,385875968,184549376,1157627904,1056964608,704643072,402653184,0,285212672,1073741824,1325400064,1258291200,1241513984,1392508928,1157627904,989855744,1476395008,1107296256,1157627904,1409286144,805306368,620756992,553648128,419430400,67108864,83886080,352321536,469762048,1023410176,335544320,218103808,16777216,134217728,335544320,419430400,301989888,352321536,234881024,0,385875968,285212672,805306368,201326592,0,301989888,402653184,268435456,436207616,117440512,620756992,469762048,100663296,318767104,503316480,503316480,33554432,67108864,50331648,0,0,0,0,0,0,16777216,16777216,16777216,0,16777216,33554432,0,33554432,117440512,150994944,100663296,0,0,402653184,905969664,889192448,352321536,67108864,0,67108864,1325400064,1509949440,201326592,100663296,570425344,973078528,369098752,234881024,335544320,654311424,1107296256,1174405120,1157627904,805306368,788529152,1140850688,1040187392,922746880,1325400064,1107296256,989855744,922746880,553648128,436207616,771751936,822083584,805306368,637534208,369098752,134217728,318767104,486539264,419430400,503316480,251658240,0,0,218103808,318767104,436207616,352321536,251658240,0,0,503316480,503316480,603979776,0,486539264,251658240,285212672,318767104,268435456,721420288,268435456,0,419430400,805306368,285212672,0,0,33554432,0,0,0,0,0,16777216,16777216,16777216,0,16777216,83886080,100663296,117440512,100663296,33554432,0,234881024,385875968,671088640,738197504,234881024,33554432,536870912,1291845632,1308622848,822083584,0,134217728,1224736768,1090519040,150994944,352321536,838860800,1241513984,1140850688,1509949440,939524096,50331648,553648128,419430400,1090519040,486539264,603979776,1694498816,620756992,1056964608,1392508928,0,83886080,402653184,301989888,251658240,201326592,335544320,385875968,704643072,419430400,385875968,218103808,318767104,469762048,587202560,385875968,16777216,251658240,419430400,100663296,268435456,251658240,553648128,184549376,318767104,452984832,369098752,117440512,620756992,335544320,0,469762048,486539264,285212672,117440512,503316480,335544320,0,0,83886080,0,0,0,0,0,16777216,16777216,16777216,33554432,33554432,117440512,201326592,134217728,0,67108864,268435456,570425344,654311424,352321536,33554432,0,671088640,889192448,704643072,268435456,268435456,939524096,905969664,301989888,0,704643072,1241513984,1224736768,486539264,721420288,0,369098752,1023410176,1325400064,989855744,1157627904,939524096,1157627904,1191182336,1258291200,1627389952,1509949440,1124073472,989855744,1006632960,838860800,620756992,201326592,385875968,268435456,0,369098752,536870912,167772160,134217728,117440512,369098752,520093696,469762048,167772160,0,150994944,402653184,486539264,184549376,637534208,486539264,33554432,620756992,184549376,452984832,335544320,268435456,0,301989888,587202560,318767104,234881024,50331648,201326592,83886080,0,0,0,0,0,0,16777216,16777216,33554432,0,167772160,0,0,117440512,16777216,134217728,251658240,570425344,134217728,16777216,134217728,922746880,872415232,788529152,0,369098752,1174405120,855638016,50331648,134217728,1107296256,855638016,486539264,285212672,1392508928,1107296256,973078528,1526726656,1140850688,1073741824,905969664,1023410176,1358954496,838860800,1174405120,1073741824,771751936,570425344,570425344,922746880,872415232,402653184,452984832,939524096,838860800,956301312,704643072,335544320,285212672,687865856,301989888,134217728,184549376,620756992,436207616,654311424,318767104,184549376,0,201326592,436207616,184549376,1023410176,889192448,922746880,536870912,50331648,201326592,570425344,402653184,33554432,251658240,671088640,637534208,0,100663296,100663296,0,0,0,0,0,0,16777216,16777216,33554432,100663296,0,83886080,402653184,100663296,33554432,436207616,385875968,234881024,33554432,385875968,1006632960,754974720,0,167772160,805306368,1342177280,486539264,0,520093696,1140850688,1023410176,788529152,738197504,889192448,1325400064,1308622848,1040187392,1090519040,1157627904,855638016,0,503316480,1761607680,1442840576,1325400064,905969664,520093696,0,738197504,872415232,1006632960,1107296256,503316480,503316480,0,150994944,704643072,721420288,385875968,587202560,369098752,520093696,335544320,385875968,0,0,402653184,184549376,436207616,268435456,654311424,805306368,251658240,469762048,1140850688,771751936,33554432,234881024,0,369098752,419430400,150994944,318767104,637534208,520093696,0,0,16777216,0,0,0,0,0,16777216,16777216,33554432,50331648,50331648,268435456,301989888,0,218103808,486539264,16777216,16777216,301989888,1275068416,654311424,167772160,318767104,989855744,1325400064,520093696,218103808,754974720,939524096,805306368,369098752,1241513984,1308622848,1023410176,738197504,419430400,335544320,754974720,1124073472,922746880,1056964608,1107296256,1040187392,989855744,1291845632,1409286144,1962934272,1392508928,855638016,905969664,687865856,150994944,436207616,905969664,754974720,956301312,117440512,452984832,687865856,603979776,0,385875968,704643072,939524096,587202560,1023410176,0,16777216,218103808,771751936,301989888,0,1207959552,436207616,201326592,285212672,939524096,503316480,100663296,318767104,218103808,587202560,100663296,503316480,771751936,335544320,0,167772160,0,0,0,0,0,16777216,16777216,33554432,33554432,352321536,251658240,16777216,167772160,369098752,218103808,0,201326592,956301312,251658240,83886080,33554432,1040187392,1224736768,352321536,117440512,805306368,889192448,486539264,553648128,1258291200,553648128,1124073472,503316480,922746880,1409286144,1442840576,1191182336,1224736768,805306368,721420288,1509949440,1358954496,1224736768,1308622848,1426063360,234881024,0,1291845632,1224736768,1258291200,939524096,419430400,33554432,352321536,234881024,905969664,520093696,234881024,503316480,671088640,268435456,0,553648128,855638016,385875968,369098752,301989888,83886080,83886080,905969664,318767104,33554432,939524096,671088640,100663296,234881024,301989888,486539264,0,268435456,654311424,469762048,67108864,587202560,117440512,67108864,0,0,0,0,0,0,16777216,16777216,33554432,134217728,234881024,100663296,150994944,385875968,184549376,117440512,671088640,1191182336,553648128,150994944,503316480,1191182336,1207959552,16777216,167772160,771751936,1056964608,318767104,385875968,1023410176,905969664,939524096,335544320,939524096,1526726656,1073741824,553648128,620756992,956301312,855638016,956301312,1174405120,1325400064,1358954496,1174405120,1358954496,1040187392,973078528,788529152,1358954496,570425344,587202560,1174405120,889192448,1006632960,486539264,402653184,872415232,654311424,184549376,419430400,570425344,536870912,234881024,50331648,570425344,855638016,889192448,436207616,251658240,0,704643072,687865856,0,83886080,754974720,486539264,16777216,234881024,268435456,0,301989888,603979776,436207616,67108864,50331648,0,100663296,0,0,0,0,0,16777216,16777216,33554432,117440512,0,150994944,301989888,134217728,0,335544320,1090519040,520093696,0,889192448,872415232,1023410176,0,150994944,754974720,922746880,83886080,637534208,1291845632,385875968,486539264,922746880,1174405120,1358954496,503316480,335544320,1258291200,1275068416,1006632960,1258291200,1224736768,1073741824,1308622848,1107296256,1107296256,989855744,989855744,1090519040,1308622848,1124073472,1191182336,771751936,83886080,436207616,1426063360,1409286144,671088640,251658240,1023410176,704643072,452984832,520093696,1056964608,1224736768,1124073472,385875968,117440512,0,369098752,721420288,570425344,0,251658240,1090519040,452984832,0,301989888,520093696,0,0,436207616,100663296,369098752,301989888,402653184,0,67108864,67108864,0,0,0,0,0,16777216,16777216,33554432,83886080,0,251658240,150994944,0,285212672,603979776,637534208,0,335544320,1258291200,654311424,0,251658240,721420288,973078528,150994944,738197504,1023410176,486539264,436207616,1124073472,1325400064,1140850688,905969664,1342177280,1157627904,872415232,1056964608,1342177280,1392508928,704643072,1140850688,1207959552,1107296256,1291845632,1157627904,788529152,318767104,822083584,218103808,838860800,889192448,1174405120,553648128,117440512,1224736768,754974720,989855744,452984832,671088640,1056964608,301989888,33554432,754974720,620756992,1207959552,989855744,570425344,100663296,184549376,419430400,1056964608,285212672,0,704643072,385875968,33554432,134217728,352321536,33554432,67108864,134217728,0,201326592,150994944,117440512,0,16777216,0,0,0,0,0,16777216,16777216,33554432,218103808,117440512,184549376,0,184549376,805306368,687865856,134217728,436207616,1358954496,486539264,67108864,654311424,822083584,838860800,0,654311424,1191182336,436207616,889192448,1006632960,1224736768,620756992,1174405120,1275068416,1241513984,754974720,520093696,1174405120,1375731712,1325400064,1073741824,1107296256,1107296256,1308622848,905969664,973078528,1358954496,1342177280,1627389952,805306368,150994944,335544320,1107296256,1241513984,1191182336,486539264,0,1073741824,1140850688,889192448,570425344,822083584,838860800,1224736768,805306368,251658240,788529152,654311424,687865856,385875968,0,989855744,1426063360,721420288,0,687865856,402653184,0,67108864,402653184,167772160,67108864,167772160,301989888,0,0,117440512,16777216,0,0,0,50331648,33554432,0,0,83886080,335544320,33554432,0,134217728,352321536,385875968,0,486539264,1342177280,603979776,83886080,620756992,1107296256,822083584,117440512,452984832,1207959552,0,419430400,1476395008,318767104,0,671088640,1325400064,1090519040,1174405120,1040187392,1124073472,1023410176,1174405120,1157627904,1157627904,687865856,1241513984,1124073472,922746880,1258291200,939524096,805306368,1140850688,1258291200,822083584,754974720,520093696,369098752,1191182336,1375731712,1056964608,754974720,973078528,1577058304,922746880,754974720,1056964608,402653184,1275068416,939524096,385875968,134217728,520093696,469762048,536870912,67108864,436207616,1241513984,436207616,100663296,771751936,0,100663296,520093696,385875968,83886080,150994944,570425344,385875968,50331648,0,33554432,16777216,0,0,16777216,16777216,16777216,33554432,83886080,0,16777216,117440512,402653184,201326592,0,16777216,1023410176,889192448,50331648,436207616,1006632960,905969664,150994944,587202560,1157627904,352321536,570425344,805306368,469762048,1056964608,687865856,1275068416,1124073472,1325400064,989855744,1375731712,872415232,822083584,587202560,1124073472,1140850688,1476395008,1224736768,1191182336,1073741824,1056964608,1006632960,838860800,184549376,100663296,973078528,905969664,1073741824,754974720,419430400,335544320,905969664,1174405120,754974720,872415232,687865856,150994944,1191182336,1157627904,838860800,704643072,469762048,452984832,268435456,50331648,1409286144,1174405120,16777216,922746880,721420288,268435456,301989888,234881024,352321536,67108864,251658240,50331648,100663296,671088640,419430400,134217728,167772160,67108864,33554432,33554432,16777216,0,16777216,67108864,83886080,67108864,0,201326592,335544320,654311424,0,67108864,721420288,1241513984,268435456,620756992,1124073472,738197504,33554432,436207616,838860800,620756992,436207616,956301312,570425344,922746880,754974720,1207959552,1056964608,1174405120,1258291200,855638016,805306368,486539264,1426063360,1375731712,1023410176,1056964608,1040187392,838860800,805306368,335544320,637534208,1090519040,1258291200,1275068416,1157627904,469762048,385875968,855638016,1023410176,838860800,905969664,251658240,285212672,1275068416,1258291200,754974720,67108864,721420288,1342177280,1006632960,251658240,100663296,419430400,335544320,352321536,234881024,1442840576,1191182336,285212672,654311424,1241513984,0,234881024,352321536,167772160,184549376,402653184,452984832,0,503316480,251658240,100663296,0,0,33554432,16777216,0,16777216,100663296,100663296,16777216,16777216,754974720,167772160,67108864,50331648,520093696,805306368,788529152,0,1275068416,1056964608,33554432,201326592,1040187392,587202560,419430400,872415232,570425344,704643072,956301312,603979776,805306368,973078528,1224736768,1124073472,369098752,889192448,956301312,922746880,754974720,822083584,1426063360,603979776,687865856,1275068416,452984832,872415232,1073741824,285212672,872415232,1056964608,973078528,754974720,486539264,134217728,838860800,939524096,1124073472,1107296256,402653184,1056964608,1224736768,1224736768,469762048,117440512,1375731712,1157627904,654311424,352321536,469762048,805306368,587202560,385875968,1358954496,1006632960,50331648,905969664,184549376,33554432,687865856,83886080,301989888,134217728,234881024,369098752,318767104,1560281088,369098752,83886080,0,16777216,16777216,0,33554432,100663296,83886080,0,234881024,587202560,0,67108864,150994944,620756992,654311424,33554432,536870912,973078528,268435456,167772160,1157627904,536870912,352321536,1006632960,654311424,704643072,1023410176,452984832,1124073472,1006632960,1526726656,1157627904,721420288,587202560,1526726656,788529152,536870912,889192448,1140850688,989855744,1023410176,1124073472,889192448,1107296256,1476395008,1006632960,1275068416,754974720,469762048,738197504,1207959552,956301312,1090519040,402653184,150994944,620756992,1375731712,1509949440,754974720,0,889192448,1342177280,721420288,436207616,503316480,1224736768,436207616,50331648,285212672,1224736768,973078528,889192448,1493172224,570425344,33554432,16777216,419430400,50331648,671088640,167772160,67108864,318767104,486539264,83886080,452984832,1275068416,0,0,0,16777216,16777216,50331648,83886080,67108864,33554432,83886080,419430400,0,150994944,587202560,318767104,0,184549376,1342177280,452984832,0,855638016,771751936,268435456,922746880,654311424,452984832,905969664,335544320,771751936,1023410176,1325400064,1157627904,704643072,687865856,855638016,1543503872,1258291200,905969664,1073741824,939524096,1358954496,704643072,369098752,771751936,1056964608,1426063360,1224736768,1493172224,1224736768,1191182336,687865856,335544320,1090519040,1442840576,1375731712,889192448,201326592,905969664,1124073472,1543503872,1073741824,100663296,620756992,905969664,973078528,469762048,318767104,654311424,369098752,402653184,1476395008,771751936,0,939524096,989855744,218103808,67108864,234881024,486539264,184549376,520093696,385875968,100663296,385875968,251658240,201326592,738197504,0,0,0,0,33554432,33554432,33554432,67108864,100663296,67108864,0,150994944,268435456,218103808,0,50331648,671088640,855638016,201326592,553648128,872415232,150994944,939524096,1157627904,285212672,1040187392,788529152,452984832,1140850688,1124073472,1224736768,822083584,905969664,1157627904,1056964608,1258291200,1107296256,553648128,1308622848,1174405120,1140850688,1174405120,1040187392,1191182336,1073741824,1191182336,620756992,889192448,989855744,1023410176,1207959552,738197504,50331648,553648128,1023410176,1660944384,1409286144,553648128,1090519040,1006632960,1526726656,1006632960,754974720,738197504,603979776,989855744,385875968,134217728,905969664,536870912,788529152,671088640,637534208,520093696,452984832,301989888,218103808,603979776,520093696,117440512,469762048,738197504,268435456,218103808,436207616,1006632960,50331648,100663296,50331648,0,0,33554432,33554432,0,67108864,184549376,167772160,0,419430400,83886080,0,33554432,469762048,1342177280,100663296,201326592,1291845632,419430400,704643072,1258291200,234881024,704643072,905969664,335544320,855638016,419430400,889192448,889192448,570425344,1258291200,1006632960,1191182336,1140850688,570425344,1073741824,1459617792,1140850688,1140850688,1191182336,1073741824,1107296256,1107296256,1325400064,671088640,973078528,788529152,402653184,553648128,1023410176,1006632960,805306368,218103808,16777216,570425344,1358954496,1090519040,369098752,620756992,1090519040,754974720,318767104,838860800,218103808,419430400,520093696,436207616,905969664,486539264,285212672,285212672,201326592,33554432,402653184,436207616,16777216,570425344,436207616,134217728,335544320,553648128,234881024,150994944,1308622848,452984832,67108864,0,0,16777216,50331648,0,117440512,184549376,0,0,0,335544320,0,33554432,570425344,587202560,318767104,385875968,1157627904,503316480,83886080,1073741824,603979776,553648128,1006632960,402653184,754974720,1006632960,704643072,1157627904,939524096,1224736768,754974720,1056964608,905969664,1409286144,1275068416,889192448,1241513984,1442840576,385875968,83886080,838860800,1392508928,1258291200,520093696,754974720,1056964608,1358954496,1056964608,553648128,637534208,1124073472,1090519040,1023410176,167772160,452984832,553648128,1023410176,1258291200,184549376,536870912,1325400064,671088640,536870912,1040187392,83886080,1023410176,268435456,0,838860800,67108864,100663296,335544320,16777216,0,318767104,352321536,33554432,503316480,167772160,50331648,553648128,436207616,100663296,805306368,704643072,201326592,0,16777216,0,0,33554432,16777216,16777216,100663296,218103808,150994944,16777216,117440512,452984832,603979776,318767104,67108864,704643072,805306368,285212672,771751936,1073741824,0,1023410176,1090519040,436207616,889192448,671088640,1459617792,1224736768,1258291200,939524096,687865856,788529152,738197504,1174405120,939524096,956301312,1107296256,905969664,587202560,1426063360,1023410176,1107296256,1191182336,805306368,587202560,704643072,855638016,1023410176,1275068416,989855744,452984832,268435456,385875968,1711276032,1610612736,1191182336,402653184,822083584,1191182336,553648128,419430400,1308622848,469762048,939524096,503316480,855638016,704643072,100663296,1073741824,855638016,251658240,318767104,637534208,100663296,721420288,285212672,402653184,0,251658240,335544320,0,469762048,469762048,0,754974720,318767104,0,67108864,0,0,83886080,0,0,234881024,201326592,167772160,0,335544320,486539264,419430400,0,167772160,855638016,335544320,369098752,1140850688,301989888,486539264,1124073472,570425344,805306368,788529152,889192448,1006632960,1358954496,1392508928,754974720,1191182336,704643072,1308622848,989855744,1560281088,956301312,922746880,788529152,1174405120,1107296256,738197504,1442840576,1107296256,771751936,1409286144,1308622848,1006632960,855638016,956301312,1442840576,872415232,637534208,520093696,1526726656,956301312,1375731712,1174405120,150994944,1291845632,1056964608,150994944,788529152,1392508928,234881024,1023410176,637534208,67108864,402653184,436207616,704643072,134217728,50331648,704643072,385875968,419430400,671088640,956301312,83886080,520093696,436207616,117440512,201326592,838860800,654311424,0,788529152,0,33554432,0,0,50331648,16777216,50331648,268435456,301989888,0,83886080,536870912,536870912,419430400,33554432,536870912,687865856,184549376,956301312,771751936,335544320,1426063360,536870912,637534208,973078528,352321536,1459617792,1040187392,1392508928,1157627904,1174405120,1056964608,1191182336,1308622848,1342177280,1124073472,1392508928,754974720,1258291200,939524096,1275068416,1140850688,1258291200,234881024,603979776,620756992,671088640,872415232,1308622848,754974720,234881024,1308622848,1258291200,1040187392,1157627904,922746880,67108864,989855744,905969664,520093696,905969664,1308622848,0,1140850688,520093696,318767104,889192448,0,788529152,402653184,805306368,553648128,301989888,520093696,419430400,117440512,1207959552,838860800,0,385875968,838860800,469762048,318767104,33554432,973078528,33554432,0,16777216,0,16777216,0,0,83886080,201326592,117440512,0,0,469762048,687865856,134217728,0,369098752,905969664,0,285212672,973078528,0,1174405120,721420288,0,1023410176,788529152,989855744,1325400064,1459617792,1392508928,956301312,1207959552,1056964608,1325400064,1426063360,1409286144,1090519040,838860800,1291845632,788529152,1006632960,1291845632,1493172224,855638016,1207959552,973078528,1191182336,905969664,855638016,905969664,1392508928,872415232,0,1577058304,956301312,687865856,1207959552,788529152,637534208,1392508928,620756992,16777216,939524096,973078528,721420288,1493172224,318767104,922746880,335544320,855638016,889192448,201326592,603979776,452984832,16777216,620756992,469762048,201326592,771751936,855638016,33554432,385875968,285212672,754974720,0,352321536,1207959552,16777216,50331648,0,33554432,33554432,0,117440512,218103808,0,167772160,419430400,117440512,0,0,520093696,1090519040,251658240,0,1140850688,738197504,201326592,1392508928,218103808,822083584,889192448,1174405120,1090519040,1224736768,1778384896,822083584,973078528,1392508928,1308622848,1275068416,1342177280,1358954496,1006632960,1124073472,788529152,570425344,1375731712,1409286144,1191182336,1275068416,469762048,738197504,1040187392,1375731712,1275068416,385875968,486539264,1325400064,436207616,721420288,1342177280,1023410176,503316480,1593835520,620756992,1291845632,1426063360,251658240,587202560,855638016,872415232,1023410176,687865856,201326592,905969664,301989888,939524096,469762048,301989888,1124073472,335544320,452984832,805306368,335544320,0,754974720,956301312,184549376,520093696,620756992,436207616,234881024,671088640,0,33554432,0,33554432,83886080,100663296,134217728,100663296,16777216,369098752,587202560,201326592,0,100663296,1275068416,1157627904,0,486539264,1392508928,301989888,771751936,654311424,520093696,1006632960,486539264,1090519040,1241513984,1375731712,1325400064,956301312,1241513984,1124073472,1358954496,1207959552,1107296256,855638016,805306368,1291845632,570425344,838860800,1090519040,1174405120,989855744,771751936,134217728,704643072,788529152,637534208,1426063360,1459617792,603979776,671088640,1040187392,1124073472,754974720,1207959552,385875968,671088640,1224736768,486539264,1124073472,536870912,570425344,570425344,1006632960,503316480,1325400064,201326592,822083584,771751936,486539264,385875968,251658240,838860800,469762048,301989888,738197504,687865856,0,1174405120,1392508928,1157627904,0,335544320,956301312,201326592,100663296,167772160,0,67108864,33554432,117440512,285212672,150994944,16777216,150994944,352321536,0,117440512,352321536,671088640,1593835520,352321536,0,1191182336,1006632960,134217728,1191182336,520093696,989855744,184549376,956301312,1090519040,1543503872,1275068416,1023410176,872415232,1157627904,1275068416,1056964608,905969664,1124073472,973078528,956301312,553648128,1107296256,1090519040,872415232,1258291200,754974720,100663296,1174405120,939524096,905969664,989855744,218103808,1056964608,1375731712,1006632960,939524096,1207959552,603979776,956301312,1476395008,704643072,1056964608,721420288,956301312,536870912,788529152,536870912,1107296256,654311424,83886080,553648128,553648128,1308622848,117440512,369098752,402653184,402653184,687865856,100663296,822083584,956301312,0,855638016,654311424,905969664,654311424,67108864,436207616,369098752,0,0,0,150994944,67108864,167772160,117440512,0,134217728,301989888,134217728,33554432,201326592,704643072,385875968,436207616,0,687865856,1191182336,167772160,922746880,520093696,788529152,687865856,553648128,1157627904,872415232,1509949440,1157627904,805306368,1056964608,989855744,905969664,939524096,805306368,956301312,1392508928,788529152,939524096,1291845632,1006632960,1191182336,922746880,436207616,1191182336,989855744,1157627904,1291845632,1275068416,905969664,536870912,1006632960,1191182336,1107296256,536870912,1342177280,905969664,1375731712,922746880,1207959552,1023410176,520093696,989855744,587202560,754974720,721420288,1174405120,285212672,872415232,469762048,704643072,704643072,520093696,805306368,0,301989888,553648128,402653184,889192448,738197504,1090519040,754974720,134217728,1124073472,369098752,167772160,436207616,436207616,0,0,150994944,268435456,100663296,50331648,335544320,419430400,234881024,0,369098752,570425344,301989888,0,251658240,0,1140850688,637534208,503316480,788529152,620756992,704643072,369098752,973078528,637534208,1107296256,1426063360,570425344,1224736768,1191182336,1392508928,1140850688,838860800,721420288,973078528,956301312,603979776,1191182336,1090519040,1342177280,1056964608,553648128,1040187392,1073741824,318767104,989855744,419430400,805306368,1023410176,1174405120,1375731712,855638016,1275068416,1023410176,1358954496,1241513984,1241513984,1174405120,654311424,922746880,1090519040,687865856,587202560,738197504,402653184,587202560,822083584,419430400,838860800,251658240,939524096,16777216,905969664,503316480,234881024,587202560,0,117440512,419430400,486539264,1342177280,956301312,973078528,637534208,0,855638016,419430400,0,50331648,251658240,352321536,0,134217728,520093696,268435456,100663296,251658240,721420288,335544320,0,251658240,553648128,167772160,1124073472,402653184,956301312,234881024,956301312,637534208,771751936,922746880,805306368,1610612736,1476395008,486539264,1258291200,1241513984,1409286144,973078528,922746880,536870912,855638016,805306368,1140850688,788529152,620756992,1207959552,385875968,939524096,1157627904,268435456,1023410176,1207959552,704643072,587202560,788529152,1241513984,1325400064,1073741824,939524096,1342177280,1157627904,1577058304,922746880,989855744,855638016,922746880,754974720,687865856,721420288,989855744,486539264,855638016,738197504,436207616,1207959552,503316480,973078528,587202560,805306368,1023410176,184549376,973078528,570425344,369098752,805306368,0,570425344,989855744,285212672,469762048,452984832,452984832,788529152,100663296,33554432,251658240,150994944,0,251658240,234881024,0,167772160,251658240,419430400,0,369098752,570425344,83886080,603979776,889192448,855638016,1090519040,838860800,637534208,620756992,1224736768,301989888,1358954496,1358954496,805306368,822083584,872415232,1191182336,989855744,889192448,1124073472,1056964608,939524096,536870912,1275068416,469762048,1107296256,1124073472,486539264,1090519040,922746880,352321536,805306368,1677721600,1375731712,1342177280,889192448,1308622848,905969664,1241513984,1107296256,1325400064,922746880,1392508928,1493172224,939524096,1241513984,603979776,687865856,905969664,637534208,671088640,872415232,805306368,150994944,687865856,553648128,838860800,335544320,1258291200,335544320,1174405120,234881024,754974720,838860800,67108864,788529152,671088640,1174405120,822083584,16777216,117440512,218103808,369098752,603979776,117440512,0,33554432,0,50331648,134217728,0,117440512,419430400,285212672,67108864,83886080,905969664,687865856,0,1090519040,603979776,503316480,1006632960,1090519040,201326592,956301312,704643072,1157627904,1795162112,1258291200,469762048,1342177280,1140850688,1241513984,620756992,1006632960,637534208,872415232,738197504,754974720,956301312,889192448,1476395008,486539264,553648128,973078528,201326592,1241513984,1426063360,1442840576,922746880,1375731712,905969664,805306368,1006632960,956301312,1191182336,335544320,1224736768,1157627904,1476395008,452984832,1073741824,536870912,872415232,402653184,1073741824,570425344,754974720,436207616,771751936,939524096,369098752,905969664,402653184,1191182336,687865856,721420288,268435456,218103808,721420288,587202560,637534208,1207959552,704643072,1157627904,268435456,0,100663296,16777216,83886080,184549376,50331648,0,0,150994944,0,16777216,553648128,419430400,67108864,0,352321536,369098752,100663296,385875968,1090519040,0,687865856,1174405120,570425344,855638016,872415232,402653184,1459617792,1342177280,654311424,872415232,922746880,1040187392,1627389952,939524096,1056964608,889192448,1107296256,620756992,1207959552,553648128,1107296256,1275068416,704643072,1090519040,687865856,1258291200,1577058304,1056964608,318767104,1023410176,838860800,1224736768,956301312,1023410176,687865856,1627389952,704643072,1258291200,1157627904,1258291200,671088640,352321536,536870912,855638016,603979776,905969664,301989888,922746880,318767104,1241513984,352321536,973078528,436207616,822083584,486539264,1107296256,201326592,587202560,369098752,469762048,838860800,0,855638016,620756992,301989888,838860800,251658240,0,134217728,50331648,0,67108864,83886080,117440512,100663296,83886080,318767104,452984832,184549376,83886080,486539264,687865856,50331648,0,872415232,738197504,67108864,905969664,570425344,452984832,1241513984,788529152,1358954496,1073741824,1308622848,872415232,788529152,654311424,1426063360,754974720,788529152,1090519040,520093696,855638016,385875968,872415232,671088640,1358954496,1275068416,1040187392,905969664,553648128,1056964608,1191182336,1207959552,587202560,1107296256,771751936,1325400064,738197504,771751936,1056964608,1023410176,1157627904,939524096,1442840576,419430400,973078528,587202560,1040187392,234881024,838860800,704643072,687865856,503316480,654311424,1040187392,218103808,1224736768,402653184,1040187392,469762048,1056964608,285212672,318767104,134217728,184549376,922746880,285212672,603979776,1073741824,67108864,218103808,905969664,251658240,201326592,33554432,134217728,0,234881024,150994944,0,452984832,637534208,50331648,0,436207616,687865856,201326592,16777216,369098752,939524096,100663296,486539264,788529152,553648128,822083584,939524096,1258291200,1375731712,1275068416,989855744,671088640,1107296256,654311424,1358954496,603979776,922746880,587202560,822083584,838860800,1191182336,771751936,1090519040,1291845632,1107296256,989855744,1140850688,385875968,1140850688,872415232,1124073472,805306368,989855744,654311424,1258291200,872415232,419430400,1342177280,570425344,1392508928,520093696,1509949440,352321536,939524096,603979776,922746880,251658240,1040187392,687865856,1358954496,369098752,603979776,754974720,788529152,570425344,721420288,872415232,889192448,721420288,654311424,167772160,352321536,570425344,704643072,637534208,16777216,1124073472,973078528,0,687865856,822083584,0,301989888,0,16777216,218103808,0,201326592,369098752,285212672,0,83886080,503316480,369098752,0,301989888,1207959552,436207616,134217728,788529152,973078528,234881024,754974720,1090519040,1157627904,1325400064,1073741824,1358954496,805306368,1107296256,1241513984,1191182336,654311424,1409286144,721420288,1107296256,822083584,989855744,687865856,1023410176,1157627904,1409286144,654311424,1040187392,654311424,1610612736,704643072,989855744,1191182336,1275068416,620756992,1174405120,1040187392,754974720,1342177280,754974720,1442840576,486539264,1744830464,520093696,1291845632,436207616,620756992,922746880,788529152,922746880,905969664,687865856,989855744,402653184,1191182336,301989888,1140850688,738197504,1275068416,452984832,1006632960,251658240,352321536,419430400,452984832,704643072,67108864,704643072,1023410176,0,620756992,956301312,0,83886080,184549376,83886080,0,16777216,553648128,553648128,50331648,16777216,469762048,872415232,201326592,335544320,671088640,754974720,0,553648128,822083584,402653184,687865856,855638016,805306368,1342177280,1241513984,1291845632,1275068416,553648128,1224736768,1023410176,872415232,671088640,805306368,788529152,654311424,637534208,1073741824,754974720,1342177280,905969664,1526726656,520093696,989855744,268435456,1342177280,671088640,1073741824,922746880,922746880,469762048,1191182336,872415232,889192448,1358954496,503316480,1275068416,905969664,1459617792,1509949440,1593835520,587202560,570425344,1023410176,671088640,654311424,889192448,771751936,1241513984,318767104,1073741824,654311424,872415232,436207616,939524096,335544320,603979776,33554432,436207616,536870912,100663296,754974720,251658240,419430400,603979776,234881024,369098752,1207959552,369098752,50331648,0,0,0,184549376,352321536,184549376,0,385875968,687865856,167772160,184549376,352321536,754974720,352321536,0,570425344,989855744,234881024,738197504,1040187392,1040187392,1207959552,905969664,1509949440,754974720,973078528,1107296256,1560281088,436207616,838860800,486539264,771751936,939524096,905969664,872415232,1157627904,1023410176,1275068416,1358954496,788529152,805306368,889192448,1409286144,452984832,1107296256,1006632960,1174405120,704643072,1124073472,788529152,989855744,1275068416,369098752,1543503872,973078528,1493172224,1627389952,1073741824,385875968,855638016,1107296256,704643072,1073741824,1023410176,922746880,838860800,838860800,469762048,536870912,805306368,1241513984,1610612736,771751936,520093696,486539264,251658240,553648128,402653184,788529152,520093696,318767104,469762048,436207616,0,956301312,721420288,0,100663296,0,167772160,352321536,16777216,0,150994944,754974720,520093696,50331648,301989888,687865856,822083584,33554432,587202560,905969664,754974720,922746880,788529152,704643072,1006632960,1258291200,1124073472,1426063360,855638016,989855744,637534208,1325400064,234881024,1006632960,738197504,872415232,1509949440,1056964608,754974720,1174405120,905969664,1191182336,1191182336,771751936,721420288,452984832,1191182336,587202560,1275068416,671088640,788529152,838860800,1577058304,872415232,956301312,1358954496,603979776,1543503872,1090519040,1593835520,1224736768,1124073472,503316480,1275068416,855638016,419430400,1124073472,503316480,855638016,352321536,989855744,16777216,1107296256,654311424,1040187392,1442840576,167772160,536870912,805306368,0,436207616,671088640,335544320,788529152,335544320,50331648,687865856,134217728,1241513984,335544320,16777216,100663296,33554432,150994944,335544320,117440512,50331648,285212672,620756992,150994944,285212672,536870912,738197504,83886080,184549376,889192448,771751936,553648128,1073741824,352321536,788529152,1409286144,956301312,1258291200,1275068416,1073741824,1224736768,1241513984,855638016,788529152,1291845632,905969664,1056964608,1191182336,1040187392,671088640,1526726656,939524096,1459617792,822083584,922746880,905969664,905969664,1426063360,788529152,1526726656,922746880,956301312,889192448,1207959552,922746880,989855744,1509949440,922746880,1174405120,1493172224,1426063360,1275068416,889192448,369098752,1157627904,805306368,704643072,1207959552,469762048,1308622848,520093696,1476395008,150994944,704643072,956301312,905969664,1040187392,385875968,587202560,687865856,100663296,503316480,553648128,67108864,1040187392,469762048,167772160,637534208,385875968,285212672,218103808,201326592,184549376,16777216,117440512,134217728,83886080,134217728,234881024,285212672,0,687865856,1006632960,570425344,50331648,822083584,1258291200,469762048,838860800,754974720,771751936,1124073472,1157627904,1056964608,1291845632,637534208,1224736768,838860800,1191182336,654311424,704643072,1224736768,771751936,1342177280,1107296256,1023410176,805306368,1526726656,1157627904,1526726656,838860800,1006632960,1056964608,553648128,1174405120,671088640,1342177280,838860800,922746880,1124073472,1342177280,788529152,1291845632,1342177280,1006632960,1442840576,1476395008,1442840576,1124073472,905969664,738197504,1124073472,822083584,905969664,989855744,486539264,872415232,436207616,687865856,939524096,637534208,1207959552,855638016,1090519040,587202560,570425344,754974720,452984832,385875968,553648128,637534208,654311424,469762048,0,855638016,889192448,33554432,0,587202560,0,0,134217728,0,33554432,100663296,117440512,100663296,117440512,771751936,553648128,218103808,603979776,754974720,939524096,469762048,671088640,1107296256,922746880,1207959552,855638016,1073741824,1392508928,1056964608,889192448,1107296256,1157627904,939524096,754974720,1073741824,838860800,1107296256,1040187392,1140850688,855638016,1509949440,687865856,1476395008,452984832,1140850688,1056964608,704643072,1275068416,721420288,1157627904,771751936,855638016,1191182336,1207959552,637534208,1476395008,1107296256,1157627904,1778384896,1191182336,1560281088,939524096,1023410176,738197504,939524096,570425344,754974720,889192448,704643072,553648128,671088640,184549376,1124073472,234881024,1023410176,0,285212672,754974720,268435456,771751936,251658240,318767104,452984832,1258291200,50331648,318767104,201326592,553648128,1459617792,0,603979776,1124073472,16777216,16777216,100663296,0,318767104,369098752,67108864,50331648,603979776,318767104,134217728,0,469762048,1090519040,654311424,754974720,1124073472,335544320,637534208,1426063360,973078528,1275068416,1124073472,1258291200,620756992,1056964608,956301312,335544320,989855744,838860800,1140850688,671088640,687865856,1258291200,1392508928,1375731712,855638016,872415232,469762048,1090519040,1442840576,754974720,1308622848,754974720,1140850688,956301312,1023410176,1258291200,1023410176,603979776,1358954496,1140850688,1509949440,1426063360,1207959552,1459617792,1291845632,1140850688,369098752,1023410176,956301312,1224736768,1241513984,872415232,620756992,1207959552,218103808,1140850688,352321536,1358954496,822083584,939524096,402653184,0,587202560,0,721420288,184549376,1442840576,67108864,402653184,436207616,234881024,1459617792,0,184549376,1023410176,83886080,33554432,0,268435456,520093696,150994944,100663296,201326592,654311424,671088640,0,486539264,939524096,905969664,486539264,721420288,905969664,50331648,1191182336,1426063360,1056964608,1426063360,654311424,1157627904,838860800,889192448,1056964608,352321536,1191182336,603979776,1191182336,738197504,822083584,788529152,838860800,1728053248,419430400,1207959552,167772160,922746880,1660944384,503316480,1107296256,922746880,704643072,973078528,905969664,1023410176,1107296256,620756992,1258291200,704643072,1392508928,1325400064,1291845632,1711276032,905969664,1140850688,402653184,1224736768,738197504,1560281088,805306368,1040187392,486539264,1358954496,335544320,1006632960,788529152,973078528,1342177280,402653184,1224736768,536870912,520093696,0,117440512,201326592,251658240,100663296,654311424,469762048,268435456,721420288,100663296,83886080,285212672,33554432,117440512,0,385875968,503316480,67108864,301989888,721420288,922746880,402653184,117440512,687865856,754974720,771751936,117440512,822083584,603979776,385875968,1392508928,1291845632,1023410176,1392508928,905969664,738197504,939524096,788529152,1006632960,452984832,939524096,486539264,889192448,352321536,855638016,939524096,956301312,1761607680,1023410176,1140850688,268435456,654311424,1157627904,637534208,1409286144,956301312,1426063360,1006632960,671088640,1023410176,939524096,922746880,1090519040,687865856,1761607680,1140850688,1426063360,1677721600,1073741824,1258291200,620756992,989855744,905969664,989855744,838860800,788529152,285212672,905969664,671088640,654311424,721420288,855638016,1073741824,352321536,1308622848,520093696,16777216,536870912,520093696,234881024,855638016,184549376,16777216,687865856,469762048,0,754974720,67108864,0,16777216,0,268435456,436207616,0,0,251658240,369098752,301989888,0,570425344,671088640,1124073472,822083584,738197504,822083584,16777216,671088640,1426063360,1375731712,1375731712,1207959552,1056964608,671088640,1442840576,671088640,956301312,570425344,838860800,637534208,1040187392,520093696,1342177280,704643072,1157627904,1543503872,855638016,838860800,721420288,704643072,1358954496,956301312,1124073472,1090519040,654311424,989855744,671088640,973078528,1459617792,1040187392,1191182336,687865856,1191182336,822083584,1426063360,1459617792,1325400064,1493172224,872415232,788529152,889192448,520093696,973078528,889192448,520093696,1040187392,704643072,855638016,1275068416,436207616,1375731712,587202560,1174405120,536870912,150994944,1275068416,0,872415232,268435456,687865856,134217728,536870912,50331648,0,1325400064,1778384896,16777216,33554432,117440512,184549376,301989888,150994944,184549376,402653184,419430400,100663296,0,973078528,838860800,721420288,520093696,637534208,738197504,150994944,855638016,1124073472,1207959552,1442840576,671088640,553648128,402653184,1073741824,687865856,973078528,520093696,738197504,419430400,822083584,419430400,1023410176,1157627904,1140850688,1409286144,754974720,687865856,973078528,704643072,1275068416,956301312,1258291200,1258291200,1073741824,1174405120,738197504,956301312,1258291200,1174405120,1224736768,1258291200,1275068416,1409286144,1644167168,1509949440,1493172224,1543503872,872415232,654311424,637534208,385875968,989855744,939524096,771751936,486539264,1140850688,301989888,1342177280,436207616,1073741824,754974720,536870912,335544320,150994944,1308622848,469762048,805306368,16777216,1006632960,117440512,1191182336,788529152,0,1157627904,2030043136,771751936,0,0,587202560,134217728,0,486539264,738197504,268435456,117440512,452984832,1090519040,469762048,419430400,335544320,654311424,318767104,486539264,1308622848,1157627904,1056964608,1409286144,939524096,620756992,637534208,805306368,805306368,1124073472,771751936,1174405120,637534208,1157627904,1157627904,1392508928,1442840576,486539264,1476395008,1308622848,822083584,973078528,1023410176,1409286144,1124073472,671088640,1593835520,1442840576,989855744,587202560,1056964608,1191182336,1140850688,637534208,1241513984,1526726656,1543503872,1375731712,1392508928,1409286144,1627389952,889192448,687865856,654311424,503316480,1107296256,788529152,922746880,285212672,1258291200,402653184,1342177280,805306368,872415232,1426063360,268435456,117440512,318767104,872415232,771751936,704643072,486539264,754974720,50331648,1140850688,1560281088,50331648,1224736768,1392508928,1577058304,0,0,301989888,33554432,50331648,285212672,536870912,167772160,0,754974720,671088640,0,687865856,620756992,905969664,16777216,771751936,1207959552,1157627904,956301312,1107296256,1224736768,570425344,754974720,721420288,721420288,889192448,704643072,1090519040,436207616,822083584,1124073472,1090519040,1778384896,620756992,1174405120,1090519040,973078528,1308622848,1342177280,1308622848,922746880,0,1325400064,1107296256,1207959552,838860800,922746880,1275068416,956301312,889192448,1224736768,1577058304,1526726656,1526726656,1426063360,1560281088,1811939328,771751936,603979776,805306368,452984832,1291845632,671088640,1207959552,301989888,889192448,738197504,956301312,989855744,452984832,1593835520,33554432,234881024,973078528,654311424,520093696,939524096,335544320,1006632960,218103808,1090519040,1509949440,50331648,1258291200,939524096,1056964608,218103808,50331648,50331648,0,822083584,721420288,234881024,0,587202560,587202560,83886080,184549376,704643072,754974720,268435456,335544320,1409286144,1174405120,1207959552,1308622848,1124073472,1157627904,352321536,788529152,654311424,905969664,671088640,788529152,1073741824,905969664,1157627904,1509949440,1476395008,1677721600,1627389952,1442840576,1040187392,520093696,788529152,922746880,922746880,1224736768,805306368,402653184,889192448,1006632960,1073741824,1023410176,1275068416,553648128,1258291200,1308622848,1577058304,1543503872,1677721600,1358954496,1375731712,1711276032,201326592,419430400,905969664,335544320,1258291200,536870912,1191182336,184549376,1426063360,503316480,536870912,1660944384,150994944,1191182336,16777216,805306368,1258291200,687865856,1040187392,754974720,16777216,1526726656,369098752,1006632960,1342177280,369098752,1711276032,1174405120,452984832,0,33554432,67108864,268435456,1040187392,218103808,67108864,318767104,704643072,553648128,83886080,402653184,1107296256,754974720,335544320,721420288,1694498816,1090519040,922746880,1476395008,1241513984,973078528,369098752,1107296256,738197504,1325400064,637534208,838860800,889192448,1191182336,1224736768,1375731712,1325400064,1526726656,1375731712,603979776,1090519040,771751936,1207959552,1006632960,167772160,1207959552,905969664,754974720,1023410176,1056964608,1325400064,939524096,671088640,822083584,1207959552,1241513984,1560281088,1241513984,1375731712,1526726656,1358954496,1593835520,0,553648128,1191182336,587202560,1275068416,503316480,973078528,385875968,1174405120,486539264,520093696,1660944384,486539264,754974720,0,1526726656,1375731712,872415232,738197504,754974720,0,1358954496,905969664,721420288,1157627904,973078528,1543503872,1795162112,369098752,33554432,50331648,33554432,218103808,872415232,0,0,385875968,486539264,16777216,268435456,553648128,939524096,167772160,335544320,805306368,771751936,251658240,1224736768,1325400064,1157627904,939524096,503316480,1073741824,922746880,939524096,637534208,637534208,620756992,905969664,1358954496,1409286144,1342177280,1577058304,1526726656,117440512,1056964608,905969664,872415232,1426063360,486539264,771751936,1040187392,889192448,1157627904,1241513984,1325400064,452984832,1107296256,1392508928,1040187392,1493172224,1325400064,1308622848,1241513984,1627389952,1207959552,1275068416,1023410176,587202560,687865856,721420288,939524096,436207616,939524096,553648128,1006632960,939524096,637534208,1275068416,721420288,1426063360,452984832,1459617792,1392508928,1207959552,486539264,1056964608,268435456,1174405120,771751936,1560281088,1174405120,905969664,1761607680,1828716544,721420288,0,0,67108864,520093696,520093696,67108864,100663296,486539264,167772160,0,838860800,1358954496,721420288,0,704643072,1325400064,83886080,973078528,1375731712,1241513984,1207959552,671088640,536870912,1275068416,436207616,989855744,587202560,1107296256,872415232,922746880,1358954496,1493172224,1526726656,1275068416,1358954496,1056964608,570425344,1275068416,486539264,452984832,1191182336,285212672,1191182336,1040187392,1040187392,973078528,1207959552,1224736768,1191182336,1291845632,1174405120,1275068416,1224736768,1308622848,1291845632,1275068416,1493172224,1107296256,1056964608,469762048,939524096,553648128,889192448,587202560,889192448,587202560,167772160,1275068416,452984832,1493172224,654311424,1325400064,218103808,1291845632,805306368,1442840576,369098752,956301312,436207616,687865856,905969664,1493172224,0,973078528,1560281088,1677721600,721420288,33554432,16777216,150994944,520093696,150994944,50331648,251658240,452984832,50331648,436207616,654311424,603979776,369098752,503316480,822083584,822083584,419430400,754974720,1392508928,1275068416,1040187392,905969664,452984832,1241513984,603979776,1493172224,553648128,419430400,1392508928,989855744,1442840576,1241513984,1627389952,1476395008,1426063360,1174405120,754974720,1174405120,989855744,436207616,989855744,1006632960,385875968,838860800,1073741824,939524096,1224736768,1409286144,1258291200,973078528,570425344,1409286144,486539264,973078528,1073741824,1124073472,1325400064,536870912,1543503872,520093696,989855744,553648128,905969664,268435456,855638016,1325400064,100663296,1191182336,402653184,1006632960,587202560,1241513984,520093696,973078528,687865856,1040187392,1124073472,570425344,805306368,150994944,1023410176,1509949440,0,1291845632,1728053248,1258291200,251658240,83886080,83886080,117440512,184549376,167772160,50331648,436207616,167772160,50331648,671088640,939524096,134217728,150994944,822083584,922746880,469762048,1442840576,1409286144,1409286144,1140850688,989855744,905969664,721420288,1409286144,1124073472,1124073472,704643072,486539264,1392508928,1409286144,1291845632,1543503872,1442840576,1694498816,1056964608,1157627904,1140850688,1056964608,1006632960,721420288,419430400,1140850688,1325400064,1056964608,855638016,1090519040,671088640,1040187392,1124073472,738197504,1224736768,1073741824,620756992,1124073472,939524096,1191182336,1258291200,989855744,1895825408,1174405120,1560281088,234881024,1040187392,570425344,754974720,1325400064,603979776,1224736768,503316480,637534208,889192448,1409286144,738197504,855638016,922746880,754974720,1258291200,436207616,1442840576,486539264,486539264,1426063360,251658240,1694498816,1644167168,838860800,134217728,234881024,0,33554432,16777216,335544320,251658240,553648128,16777216,50331648,620756992,889192448,0,385875968,805306368,671088640,704643072,1224736768,1140850688,1207959552,1040187392,1124073472,1174405120,1006632960,956301312,1509949440,1275068416,1073741824,721420288,1207959552,1526726656,1191182336,1526726656,1459617792,1325400064,1325400064,1459617792,922746880,553648128,1308622848,1006632960,318767104,704643072,1224736768,1073741824,754974720,1157627904,805306368,1224736768,1342177280,1325400064,1124073472,1325400064,1375731712,1258291200,922746880,1275068416,1006632960,1040187392,1291845632,1056964608,1442840576,117440512,1275068416,989855744,1241513984,1593835520,603979776,1140850688,771751936,1090519040,553648128,771751936,1174405120,687865856,1056964608,587202560,1442840576,402653184,1191182336,788529152,587202560,1308622848,1124073472,1728053248,704643072,1056964608,838860800,0,0,16777216,67108864,285212672,335544320,419430400,184549376,285212672,587202560,33554432,0,1275068416,973078528,268435456,1207959552,637534208,1107296256,251658240,1023410176,788529152,754974720,587202560,1358954496,1593835520,1325400064,1023410176,838860800,1157627904,1409286144,1342177280,1241513984,1610612736,1459617792,1275068416,889192448,1207959552,654311424,553648128,956301312,1375731712,872415232,218103808,738197504,973078528,1090519040,1174405120,1325400064,1191182336,1090519040,1392508928,1090519040,1157627904,1442840576,620756992,1275068416,536870912,1610612736,1224736768,1241513984,1392508928,587202560,1241513984,671088640,1107296256,1291845632,973078528,1224736768,536870912,788529152,956301312,520093696,1325400064,301989888,1342177280,318767104,1291845632,587202560,385875968,1174405120,822083584,1191182336,1342177280,1090519040,872415232,234881024,905969664,150994944,33554432,50331648,83886080,268435456,251658240,100663296,335544320,654311424,251658240,0,822083584,1660944384,637534208,402653184,1409286144,721420288,1258291200,385875968,1073741824,436207616,1342177280,855638016,1325400064,1006632960,503316480,788529152,1509949440,1140850688,1493172224,1358954496,1577058304,1476395008,1258291200,1258291200,1073741824,1073741824,989855744,0,822083584,1325400064,855638016,1006632960,939524096,973078528,872415232,822083584,989855744,671088640,1174405120,1191182336,1107296256,973078528,671088640,1207959552,1124073472,520093696,1509949440,553648128,1207959552,1241513984,553648128,922746880,805306368,805306368,687865856,973078528,637534208,956301312,872415232,1426063360,402653184,1593835520,167772160,1207959552,654311424,268435456,1140850688,369098752,1325400064,704643072,251658240,1358954496,738197504,1342177280,100663296,335544320,201326592,0,16777216,16777216,503316480,251658240,0,268435456,872415232,67108864,100663296,1056964608,889192448,0,671088640,620756992,486539264,1291845632,922746880,1040187392,553648128,1191182336,1157627904,1308622848,1006632960,1124073472,1140850688,1207959552,1409286144,1375731712,1342177280,1577058304,1342177280,1442840576,1509949440,1174405120,1174405120,1543503872,1040187392,0,436207616,754974720,687865856,1124073472,989855744,553648128,1140850688,1207959552,1090519040,1493172224,1258291200,1140850688,536870912,704643072,1224736768,1006632960,838860800,1124073472,637534208,1191182336,704643072,671088640,822083584,905969664,1191182336,637534208,1258291200,251658240,1140850688,922746880,1325400064,402653184,1476395008,301989888,536870912,1140850688,352321536,1258291200,603979776,150994944,1526726656,0,1375731712,1677721600,1828716544,1006632960,16777216,0,50331648,0,117440512,50331648,16777216,0,771751936,553648128,67108864,452984832,1090519040,83886080,201326592,771751936,503316480,385875968,989855744,486539264,1140850688,520093696,1375731712,1191182336,1375731712,1140850688,1426063360,1442840576,1358954496,1660944384,1342177280,1560281088,1526726656,1442840576,1342177280,1308622848,1493172224,1476395008,1392508928,1426063360,1056964608,1073741824,1006632960,587202560,1006632960,1073741824,654311424,1023410176,1409286144,1056964608,1526726656,1224736768,1040187392,922746880,939524096,989855744,520093696,1006632960,805306368,486539264,1157627904,939524096,855638016,671088640,973078528,1040187392,838860800,889192448,285212672,956301312,419430400,1224736768,1358954496,1459617792,1023410176,201326592,1593835520,553648128,822083584,1677721600,16777216,1694498816,620756992,1073741824,1325400064,704643072,1744830464,0,0,0,0,67108864,83886080,167772160,218103808,620756992,150994944,301989888,1442840576,754974720,218103808,587202560,1476395008,117440512,1006632960,788529152,369098752,1006632960,436207616,1426063360,1006632960,1056964608,1073741824,1392508928,1291845632,1426063360,1207959552,1476395008,1543503872,1509949440,1459617792,1560281088,1426063360,1107296256,1375731712,318767104,1006632960,973078528,1040187392,1073741824,872415232,738197504,671088640,721420288,1174405120,1207959552,1124073472,1023410176,1275068416,1828716544,1308622848,1275068416,989855744,671088640,1191182336,603979776,922746880,553648128,1006632960,872415232,838860800,905969664,738197504,1191182336,536870912,486539264,1392508928,452984832,1426063360,1174405120,520093696,1073741824,234881024,1644167168,587202560,486539264,1996488704,436207616,671088640,1593835520,33554432,1006632960,536870912,1761607680,83886080,16777216,67108864,83886080,0,33554432,100663296,150994944,318767104,33554432,956301312,1358954496,369098752,335544320,771751936,956301312,301989888,1073741824,754974720,1006632960,704643072,603979776,1073741824,738197504,1040187392,1157627904,1224736768,1543503872,1241513984,1224736768,1375731712,1258291200,1275068416,1191182336,1258291200,1459617792,1509949440,1526726656,251658240,150994944,956301312,452984832,587202560,989855744,1140850688,1040187392,956301312,1056964608,905969664,1107296256,1090519040,1560281088,1073741824,1224736768,872415232,570425344,838860800,905969664,654311424,1275068416,671088640,973078528,1207959552,805306368,1325400064,939524096,1006632960,1140850688,385875968,1191182336,838860800,1593835520,805306368,385875968,1258291200,167772160,1224736768,939524096,134217728,1375731712,754974720,520093696,2130706432,905969664,1392508928,1879048192,1224736768,0,50331648,0,0,16777216,436207616,402653184,234881024,218103808,335544320,721420288,939524096,117440512,822083584,1056964608,385875968,671088640,1610612736,620756992,637534208,1342177280,234881024,889192448,738197504,1073741824,1426063360,1291845632,1358954496,1493172224,1291845632,1241513984,1442840576,1275068416,1610612736,1191182336,1140850688,1258291200,1107296256,1358954496,570425344,956301312,1191182336,654311424,704643072,956301312,1006632960,1090519040,1191182336,1191182336,1207959552,1342177280,1207959552,1124073472,1308622848,620756992,1224736768,1090519040,134217728,1040187392,973078528,788529152,1308622848,1107296256,687865856,1073741824,1023410176,1258291200,1107296256,587202560,788529152,620756992,520093696,1358954496,201326592,1476395008,1191182336,1107296256,1258291200,369098752,1040187392,1291845632,251658240,1342177280,1157627904,939524096,1895825408,654311424,100663296,83886080,67108864,117440512,0,167772160,16777216,0,150994944,620756992,369098752,150994944,486539264,805306368,1140850688,167772160,1006632960,1308622848,369098752,553648128,1560281088,687865856,872415232,620756992,956301312,1174405120,1275068416,1207959552,1207959552,1073741824,1191182336,905969664,1577058304,1509949440,1442840576,1174405120,1493172224,1342177280,805306368,1291845632,671088640,754974720,1073741824,989855744,1207959552,956301312,989855744,721420288,838860800,1023410176,1342177280,1358954496,1308622848,956301312,1157627904,1006632960,520093696,452984832,1442840576,67108864,1174405120,1358954496,1392508928,889192448,1275068416,1275068416,1409286144,1358954496,754974720,486539264,1342177280,184549376,1308622848,1358954496,1308622848,1627389952,301989888,1174405120,1442840576,1308622848,1660944384,184549376,553648128,2113929216,251658240,1627389952,67108864,0,0,0,50331648,0,83886080,0,50331648,50331648,251658240,117440512,301989888,922746880,1124073472,218103808,671088640,872415232,1291845632,369098752,1023410176,1090519040,1476395008,1073741824,754974720,1291845632,1342177280,1526726656,1157627904,1409286144,1291845632,1258291200,1392508928,1426063360,1426063360,1342177280,1409286144,1157627904,1325400064,0,1258291200,1275068416,905969664,872415232,872415232,973078528,872415232,1358954496,1073741824,872415232,1056964608,788529152,855638016,1241513984,1442840576,1258291200,1040187392,1207959552,1157627904,1090519040,67108864,1073741824,1258291200,486539264,1409286144,1342177280,1358954496,1291845632,1342177280,1644167168,50331648,1358954496,704643072,1275068416,1409286144,973078528,1593835520,436207616,1191182336,1610612736,268435456,822083584,1157627904,167772160,1610612736,838860800,150994944,50331648,67108864,0,16777216,0,0,33554432,50331648,285212672,436207616,603979776,603979776,687865856,671088640,603979776,1157627904,1677721600,1224736768,1509949440,1426063360,1342177280,1459617792,1023410176,1090519040,704643072,905969664,1140850688,1124073472,1342177280,1124073472,1442840576,1291845632,1560281088,1476395008,1308622848,1224736768,1543503872,788529152,1342177280,1375731712,1207959552,1056964608,1040187392,889192448,1073741824,1191182336,1073741824,1040187392,1040187392,1006632960,1291845632,905969664,1174405120,1476395008,704643072,536870912,1207959552,956301312,1090519040,1207959552,889192448,1358954496,1107296256,587202560,1426063360,1526726656,1241513984,1124073472,117440512,1442840576,0,1342177280,654311424,721420288,1543503872,1392508928,1627389952,1191182336,654311424,1476395008,520093696,83886080,1040187392,318767104,1811939328,1795162112,352321536,0,0,16777216,67108864,0,117440512,268435456,234881024,218103808,268435456,452984832,520093696,452984832,687865856,1040187392,1291845632,1107296256,1358954496,1493172224,1258291200,1191182336,838860800,369098752,805306368,788529152,973078528,1224736768,1291845632,1560281088,1493172224,1191182336,1325400064,1526726656,1409286144,1358954496,1207959552,1140850688,1426063360,1174405120,1342177280,1258291200,1006632960,771751936,1157627904,973078528,1040187392,1241513984,872415232,1375731712,1291845632,989855744,905969664,1258291200,1392508928,939524096,1493172224,1040187392,1056964608,1140850688,1174405120,1140850688,805306368,1325400064,1174405120,1409286144,1375731712,1157627904,1543503872,1275068416,1644167168,620756992,419430400,1308622848,0,1006632960,553648128,687865856,1627389952,419430400,1660944384,1493172224,184549376,1392508928,1358954496,1593835520,2013265920,587202560,50331648,150994944,0,50331648,0,251658240,150994944,16777216,50331648,385875968,587202560,318767104,335544320,1040187392,922746880,1442840576,1342177280,1023410176,1375731712,1157627904,1191182336,318767104,117440512,922746880,1258291200,1241513984,1409286144,1241513984,1191182336,1493172224,1291845632,1358954496,1677721600,1409286144,1409286144,1543503872,1442840576,1509949440,1476395008,1241513984,1426063360,1543503872,587202560,754974720,1157627904,1073741824,1174405120,838860800,1275068416,1056964608,1241513984,1023410176,1291845632,1191182336,1459617792,1442840576,1107296256,1291845632,1258291200,1006632960,1040187392,469762048,1174405120,1140850688,1358954496,1275068416,1006632960,1191182336,1526726656,1526726656,1124073472,486539264,1677721600,100663296,838860800,872415232,184549376,855638016,67108864,503316480,1325400064,1124073472,16777216,1660944384,469762048,1258291200,150994944,83886080,0,0,0,83886080,0,0,33554432,0,738197504,1040187392,822083584,620756992,922746880,822083584,1023410176,1241513984,1476395008,973078528,620756992,1174405120,1258291200,369098752,1056964608,1056964608,1207959552,1358954496,1291845632,1358954496,1593835520,1426063360,1358954496,1509949440,1392508928,1459617792,1409286144,1358954496,1543503872,1476395008,1644167168,1275068416,1291845632,1040187392,1140850688,1275068416,1107296256,1308622848,1140850688,1207959552,1207959552,1375731712,1241513984,1174405120,1224736768,1241513984,939524096,1157627904,1023410176,1207959552,503316480,754974720,855638016,1124073472,1006632960,1392508928,1241513984,1426063360,1023410176,1358954496,1224736768,1459617792,721420288,1308622848,989855744,1207959552,1962934272,1006632960,989855744,788529152,0,603979776,889192448,0,1358954496,939524096,0,218103808,0,0,184549376,0,167772160,0,83886080,536870912,369098752,620756992,637534208,385875968,452984832,671088640,788529152,1040187392,771751936,889192448,1157627904,1174405120,1140850688,1191182336,620756992,1308622848,1241513984,1006632960,1392508928,1409286144,1325400064,1258291200,1275068416,1392508928,1442840576,1308622848,1140850688,1577058304,1426063360,1056964608,1174405120,1509949440,1426063360,1006632960,1291845632,1124073472,1107296256,973078528,1191182336,1191182336,1006632960,1040187392,1023410176,1241513984,1157627904,1174405120,1023410176,1107296256,1157627904,1342177280,654311424,503316480,1056964608,922746880,1124073472,1207959552,1375731712,1526726656,1459617792,1560281088,1644167168,587202560,33554432,1191182336,771751936,1577058304,402653184,1560281088,1241513984,1493172224,1543503872,1124073472,822083584,637534208,50331648,369098752,1560281088,1023410176,0,0,50331648,0,50331648,0,0,83886080,503316480,419430400,100663296,0,0,385875968,1073741824,637534208,352321536,738197504,889192448,1023410176,973078528,1157627904,1459617792,0,1107296256,1157627904,1476395008,1308622848,1258291200,1342177280,1291845632,1409286144,1392508928,1291845632,1409286144,1392508928,1342177280,1258291200,1509949440,1157627904,1577058304,1241513984,1157627904,1258291200,1509949440,1325400064,1124073472,1124073472,1107296256,1224736768,1224736768,1191182336,1174405120,1174405120,1241513984,1056964608,1191182336,1191182336,1409286144,301989888,721420288,1191182336,805306368,1023410176,1325400064,1207959552,1325400064,1023410176,1191182336,1342177280,1342177280,1342177280,452984832,1107296256,1409286144,419430400,1140850688,1560281088,1358954496,1543503872,1593835520,771751936,1409286144,1476395008,134217728,285212672,100663296,0,67108864,0,16777216,67108864,0,50331648,0,0,83886080,402653184,603979776,721420288,1207959552,1560281088,1124073472,922746880,1241513984,905969664,721420288,671088640,905969664,905969664,16777216,973078528,1241513984,1476395008,1308622848,1191182336,1342177280,1275068416,1459617792,1442840576,1308622848,1509949440,1493172224,1392508928,1325400064,1560281088,1593835520,1308622848,1560281088,1409286144,1325400064,1073741824,939524096,1040187392,1224736768,1124073472,1258291200,838860800,704643072,939524096,889192448,1174405120,1291845632,889192448,1442840576,1157627904,989855744,855638016,956301312,1006632960,1040187392,1342177280,1291845632,1056964608,1090519040,1140850688,1543503872,1308622848,1073741824,956301312,771751936,805306368,1426063360,822083584,1509949440,1560281088,1459617792,1426063360,1140850688,0,1728053248,989855744,1006632960,855638016,0,150994944,0,0,33554432,33554432,16777216,83886080,0,83886080,1073741824,1308622848,452984832,654311424,469762048,1191182336,1493172224,956301312,486539264,754974720,520093696,1358954496,1107296256,620756992,503316480,1291845632,1258291200,1442840576,1426063360,1409286144,1241513984,1392508928,1459617792,1358954496,1375731712,1207959552,1761607680,1241513984,1459617792,1224736768,1375731712,1375731712,1627389952,1207959552,1426063360,1056964608,956301312,1207959552,1040187392,1174405120,1040187392,1140850688,1006632960,889192448,1090519040,1426063360,1224736768,1308622848,1124073472,1358954496,1090519040,1023410176,805306368,1056964608,1409286144,1375731712,1442840576,1493172224,1224736768,1291845632,1291845632,1342177280,1124073472,822083584,486539264,1375731712,1308622848,788529152,1040187392,1509949440,939524096,1325400064,100663296,889192448,1526726656,671088640,318767104,0,67108864,16777216,117440512,0,16777216,0,83886080,268435456,268435456,956301312,1090519040,201326592,0,100663296,1056964608,822083584,956301312,1291845632,1174405120,1325400064,1124073472,1107296256,469762048,1073741824,1207959552,1157627904,1342177280,1375731712,1476395008,1476395008,1493172224,1409286144,1325400064,1358954496,1325400064,1342177280,1375731712,1191182336,1124073472,1174405120,1275068416,1291845632,1191182336,1375731712,1241513984,1090519040,1426063360,1325400064,1140850688,1358954496,1157627904,1174405120,1224736768,1224736768,1291845632,1526726656,989855744,989855744,973078528,1258291200,1174405120,587202560,1090519040,1409286144,1291845632,1526726656,1207959552,1191182336,536870912,1241513984,1056964608,587202560,1140850688,503316480,1174405120,1577058304,603979776,1107296256,1207959552,771751936,1509949440,1107296256,1006632960,1694498816,2130706432,0,100663296,33554432,0,50331648,33554432,0,33554432,0,285212672,369098752,503316480,855638016,838860800,704643072,939524096,1241513984,754974720,1174405120,1140850688,1023410176,922746880,973078528,1291845632,33554432,838860800,1426063360,1308622848,1090519040,1207959552,1157627904,1157627904,1241513984,1426063360,1560281088,1442840576,1275068416,1308622848,1476395008,788529152,402653184,1207959552,1375731712,1426063360,1325400064,939524096,1157627904,973078528,1207959552,1207959552,855638016,1392508928,754974720,738197504,1040187392,1258291200,922746880,1073741824,1174405120,771751936,1107296256,1325400064,1140850688,1040187392,1358954496,1426063360,1358954496,1006632960,704643072,1040187392,1526726656,1090519040,1157627904,805306368,587202560,1174405120,1845493760,1442840576,1426063360,1660944384,1694498816,117440512,385875968,1660944384,536870912,587202560,2046820352,301989888,0,50331648,0,0,0,100663296,16777216,0,83886080,0,33554432,553648128,754974720,1056964608,922746880,1392508928,1124073472,1543503872,704643072,654311424,956301312,1174405120,1040187392,0,771751936,1073741824,1325400064,1308622848,1191182336,989855744,1426063360,1560281088,1358954496,1325400064,1308622848,1426063360,1509949440,1493172224,1358954496,520093696,1375731712,1409286144,1560281088,1409286144,1358954496,989855744,1140850688,1174405120,1023410176,1157627904,1325400064,1056964608,922746880,1006632960,1392508928,1073741824,1124073472,1308622848,1476395008,1174405120,1207959552,721420288,805306368,671088640,721420288,318767104,1023410176,1577058304,1023410176,855638016,1627389952,956301312,1073741824,939524096,1006632960,1593835520,603979776,570425344,1325400064,1308622848,1040187392,301989888,1291845632,1459617792,0,251658240,0,0,83886080,0,0,0,0,0,0,150994944,452984832,0,150994944,251658240,872415232,570425344,1275068416,1426063360,1308622848,1090519040,1258291200,1174405120,704643072,956301312,570425344,973078528,1224736768,1392508928,1342177280,1375731712,1174405120,1224736768,1526726656,1375731712,973078528,1207959552,1157627904,1493172224,1442840576,1258291200,822083584,1207959552,1409286144,1325400064,1392508928,1375731712,1006632960,1073741824,1509949440,939524096,1124073472,1207959552,956301312,956301312,1157627904,1073741824,1409286144,989855744,1291845632,1124073472,1627389952,822083584,218103808,1325400064,1090519040,1275068416,1258291200,1409286144,1006632960,956301312,1056964608,1342177280,301989888,419430400,1442840576,1056964608,1140850688,1325400064,771751936,1828716544,1644167168,1409286144,1207959552,855638016,1979711488,905969664,0,33554432,234881024,0,0,67108864,0,0,67108864,83886080,201326592,1056964608,369098752,805306368,922746880,1275068416,33554432,402653184,687865856,1224736768,1056964608,1442840576,1291845632,872415232,905969664,369098752,872415232,1560281088,1275068416,1157627904,1174405120,1224736768,1275068416,1291845632,1291845632,1174405120,1442840576,1107296256,1442840576,1375731712,1409286144,553648128,922746880,1291845632,1426063360,1308622848,1107296256,1207959552,1023410176,587202560,1090519040,1392508928,620756992,318767104,872415232,1040187392,973078528,838860800,1140850688,1258291200,973078528,1006632960,687865856,1174405120,989855744,1308622848,1191182336,1476395008,1056964608,1375731712,1677721600,1073741824,1157627904,1124073472,134217728,1056964608,1476395008,1375731712,1426063360,1728053248,1342177280,1711276032,1644167168,1778384896,0,754974720,2130706432,671088640,0,16777216,16777216,16777216,0,0,33554432,100663296,0,0,671088640,234881024,805306368,1191182336,989855744,1140850688,1275068416,1560281088,956301312,352321536,1124073472,738197504,1090519040,1275068416,0,251658240,1308622848,1140850688,1258291200,1392508928,1023410176,1358954496,1392508928,1426063360,1191182336,1174405120,1375731712,1375731712,922746880,1342177280,1056964608,1375731712,1191182336,1207959552,1342177280,1157627904,922746880,1174405120,738197504,922746880,1040187392,0,0,721420288,1056964608,905969664,486539264,738197504,1258291200,1157627904,1090519040,855638016,855638016,956301312,754974720,1526726656,956301312,1258291200,989855744,973078528,939524096,1107296256,1124073472,922746880,754974720,67108864,1560281088,1241513984,1426063360,1845493760,1375731712,570425344,1744830464,922746880,0,469762048,637534208,100663296,0,117440512,100663296,50331648,0,0,0,16777216,117440512,486539264,352321536,671088640,1409286144,771751936,1040187392,1426063360,1308622848,1342177280,620756992,1476395008,889192448,939524096,1325400064,150994944,352321536,1526726656,1409286144,1275068416,1207959552,1241513984,1509949440,1157627904,1090519040,1207959552,1241513984,1258291200,1325400064,1040187392,1258291200,1543503872,1426063360,1459617792,1174405120,1426063360,754974720,1157627904,922746880,1023410176,922746880,1577058304,301989888,520093696,704643072,486539264,369098752,251658240,687865856,973078528,771751936,469762048,469762048,855638016,1157627904,989855744,1325400064,1325400064,1073741824,1409286144,1241513984,1476395008,1358954496,1207959552,1308622848,1056964608,1124073472,1560281088,1660944384,1157627904,1275068416,1493172224,436207616,1694498816,1811939328,1291845632,100663296,16777216,0,150994944,50331648,0,117440512,83886080,50331648,0,0,50331648,0,50331648,150994944,50331648,67108864,1090519040,1157627904,1358954496,1107296256,1056964608,973078528,1040187392,1241513984,1610612736,369098752,335544320,1308622848,1291845632,1426063360,1258291200,1207959552,1023410176,1241513984,1090519040,771751936,1006632960,1275068416,1275068416,1342177280,1392508928,1358954496,1258291200,1526726656,1459617792,1392508928,1056964608,1174405120,67108864,721420288,1073741824,822083584,0,637534208,671088640,687865856,1140850688,939524096,1174405120,889192448,889192448,788529152,1241513984,989855744,822083584,1140850688,1442840576,1342177280,1275068416,1409286144,1308622848,1124073472,1526726656,1090519040,1308622848,1375731712,1241513984,1241513984,1459617792,1543503872,1493172224,1493172224,1728053248,520093696,637534208,2097152000,1241513984,33554432,0,134217728,0,0,0,0,0,0,0,0,0,167772160,301989888,100663296,0,469762048,973078528,1090519040,872415232,956301312,973078528,1224736768,1207959552,1207959552,285212672,167772160,1207959552,1056964608,1124073472,1275068416,1392508928,1073741824,1207959552,973078528,889192448,872415232,889192448,1207959552,1191182336,1325400064,1543503872,1610612736,1207959552,1308622848,1409286144,1577058304,1442840576,905969664,872415232,788529152,436207616,33554432,0,503316480,671088640,620756992,469762048,771751936,956301312,855638016,973078528,1140850688,1342177280,822083584,1107296256,1728053248,687865856,822083584,1493172224,1442840576,1241513984,1174405120,1241513984,1308622848,1124073472,1476395008,1610612736,1476395008,1442840576,1711276032,1509949440,1610612736,1241513984,268435456,889192448,100663296,0,150994944,16777216,0,117440512,0,33554432,0,33554432,0,16777216,50331648,50331648,67108864,0,201326592,1107296256,973078528,872415232,452984832,838860800,1107296256,1241513984,738197504,1124073472,905969664,67108864,1107296256,1342177280,1342177280,1241513984,1073741824,1023410176,1358954496,1224736768,1258291200,788529152,1073741824,1157627904,1409286144,1174405120,1627389952,1342177280,1258291200,1308622848,1543503872,738197504,822083584,738197504,822083584,1308622848,1476395008,234881024,234881024,805306368,754974720,922746880,100663296,1073741824,553648128,838860800,1056964608,1174405120,905969664,1224736768,1157627904,1526726656,872415232,1191182336,1526726656,889192448,905969664,1090519040,1308622848,1107296256,1342177280,1442840576,1493172224,1694498816,1157627904,1241513984,1610612736,1543503872,1761607680,1879048192,822083584,0,16777216,0,83886080,16777216,0,117440512,0,0,0,0,0,16777216,67108864,100663296,50331648,251658240,620756992,1207959552,939524096,1157627904,822083584,150994944,771751936,1224736768,956301312,905969664,436207616,1073741824,1056964608,1073741824,1325400064,1191182336,788529152,1191182336,1325400064,603979776,687865856,1241513984,1459617792,1660944384,1560281088,1476395008,1409286144,1090519040,1325400064,1526726656,939524096,520093696,1224736768,805306368,335544320,503316480,167772160,285212672,1090519040,1006632960,553648128,503316480,1442840576,805306368,1056964608,771751936,1157627904,1090519040,855638016,1426063360,1241513984,1426063360,721420288,1023410176,1023410176,788529152,1342177280,620756992,1660944384,1493172224,1442840576,1191182336,1493172224,570425344,0,1845493760,1375731712,855638016,1996488704,1191182336,0,0,0,0,0,0,0,16777216,16777216,0,0,0,0,33554432,50331648,33554432,83886080,570425344,1191182336,822083584,805306368,1006632960,1191182336,637534208,855638016,1207959552,335544320,587202560,1140850688,1090519040,1308622848,838860800,805306368,1006632960,1258291200,939524096,1107296256,1174405120,1124073472,1325400064,1157627904,1409286144,1442840576,1207959552,0,1275068416,1476395008,1509949440,1476395008,1409286144,989855744,1023410176,587202560,0,16777216,0,1543503872,285212672,0,838860800,318767104,838860800,50331648,738197504,587202560,1593835520,1476395008,922746880,1325400064,1442840576,989855744,1140850688,1056964608,1040187392,1426063360,1207959552,1409286144,1577058304,1375731712,1325400064,1409286144,1593835520,1677721600,1660944384,1593835520,1090519040,0,0,0,0,0,0,0,0,16777216,16777216,0,0,0,0,16777216,50331648,0,16777216,134217728,285212672,503316480,1124073472,1174405120,654311424,855638016,1291845632,1342177280,134217728,67108864,1375731712,1107296256,1325400064,1107296256,486539264,956301312,1291845632,771751936,1241513984,1040187392,1191182336,1107296256,1610612736,1308622848,1291845632,1107296256,0,1358954496,1795162112,1040187392,1107296256,973078528,973078528,1342177280,1526726656,268435456,285212672,973078528,1560281088,301989888,285212672,872415232,687865856,1124073472,973078528,1275068416,1140850688,1744830464,939524096,1375731712,1174405120,570425344,1241513984,1409286144,436207616,1073741824,1526726656,1493172224,1526726656,1543503872,1660944384,1660944384,1325400064,1744830464,1476395008,1291845632,1946157056,1828716544,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,67108864,50331648,100663296,318767104,201326592,16777216,100663296,251658240,285212672,687865856,452984832,973078528,1073741824,33554432,1275068416,1291845632,989855744,771751936,788529152,721420288,1191182336,1040187392,1258291200,1291845632,905969664,1291845632,1644167168,1191182336,1493172224,1442840576,754974720,1811939328,1459617792,570425344,1006632960,117440512,0,486539264,855638016,67108864,150994944,905969664,1140850688,922746880,872415232,1006632960,788529152,721420288,889192448,738197504,1442840576,1023410176,637534208,1241513984,1157627904,1090519040,1140850688,738197504,855638016,1090519040,218103808,754974720,33554432,738197504,721420288,436207616,134217728,1744830464,1560281088,1241513984,100663296,100663296,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,50331648,218103808,0,117440512,301989888,285212672,150994944,268435456,771751936,922746880,872415232,1476395008,352321536,134217728,956301312,1056964608,452984832,973078528,905969664,1107296256,1140850688,1191182336,1476395008,1342177280,1124073472,973078528,1275068416,1275068416,1258291200,1325400064,369098752,1342177280,1660944384,704643072,872415232,1744830464,838860800,0,369098752,0,0,603979776,973078528,201326592,16777216,520093696,33554432,385875968,671088640,1241513984,1157627904,989855744,805306368,822083584,1207959552,1174405120,1308622848,1342177280,1157627904,1392508928,1140850688,771751936,134217728,1073741824,1090519040,620756992,352321536,536870912,1811939328,2130706432,721420288,0,0,0,0,0,0,0,0,0,0,16777216,16777216,0,0,0,0,16777216,0,16777216,201326592,150994944,67108864,100663296,33554432,436207616,671088640,939524096,838860800,268435456,0,1375731712,419430400,1023410176,738197504,603979776,1107296256,1006632960,905969664,1107296256,939524096,905969664,1325400064,654311424,1023410176,1308622848,872415232,637534208,1442840576,1258291200,1258291200,100663296,402653184,1493172224,956301312,1224736768,503316480,251658240,889192448,822083584,0,67108864,1124073472,654311424,1291845632,1694498816,1375731712,1342177280,671088640,738197504,1157627904,1543503872,1476395008,1023410176,855638016,1392508928,1140850688,687865856,956301312,1023410176,1040187392,1526726656,1660944384,1493172224,184549376,0,1358954496,2130706432,218103808,16777216,0,0,0,0,0,0,0,0,0,16777216,0,0,0,0,0,16777216,0,50331648,251658240,268435456,369098752,150994944,721420288,234881024,218103808,1140850688,301989888,318767104,1191182336,822083584,318767104,201326592,1090519040,922746880,1006632960,1090519040,1073741824,1073741824,637534208,1157627904,989855744,1174405120,1258291200,1342177280,1392508928,1442840576,1409286144,1627389952,1476395008,570425344,33554432,637534208,1426063360,0,234881024,335544320,654311424,285212672,83886080,1224736768,1107296256,1224736768,1660944384,1291845632,654311424,234881024,1090519040,1358954496,1258291200,771751936,553648128,603979776,1090519040,352321536,150994944,637534208,33554432,771751936,1006632960,352321536,1358954496,1526726656,201326592,0,402653184,603979776,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,33554432,33554432,0,16777216,0,301989888,167772160,855638016,956301312,855638016,771751936,0,436207616,721420288,771751936,905969664,889192448,956301312,754974720,335544320,754974720,1040187392,0,1040187392,1358954496,922746880,771751936,335544320,1560281088,1426063360,1577058304,1610612736,637534208,1409286144,1442840576,67108864,536870912,33554432,0,117440512,184549376,1140850688,486539264,352321536,1962934272,1174405120,50331648,385875968,402653184,1157627904,0,805306368,822083584,570425344,721420288,905969664,855638016,1023410176,889192448,570425344,1409286144,1207959552,1459617792,872415232,218103808,1426063360,1946157056,1828716544,100663296,0,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,33554432,0,0,117440512,67108864,100663296,570425344,922746880,822083584,1073741824,0,452984832,1409286144,436207616,989855744,1191182336,1140850688,1040187392,956301312,1023410176,1325400064,0,385875968,318767104,553648128,1291845632,1476395008,1543503872,872415232,788529152,1761607680,486539264,268435456,1879048192,1577058304,805306368,201326592,0,83886080,503316480,0,0,637534208,1442840576,1241513984,922746880,1207959552,654311424,352321536,771751936,1191182336,939524096,1040187392,1157627904,587202560,1191182336,436207616,436207616,1493172224,1761607680,1426063360,1191182336,1526726656,1191182336,1593835520,1426063360,1862270976,1711276032,0,16777216,134217728,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,100663296,83886080,150994944,50331648,33554432,469762048,419430400,1207959552,922746880,0,369098752,671088640,469762048,838860800,134217728,1056964608,704643072,570425344,1207959552,1476395008,184549376,603979776,436207616,0,889192448,1392508928,1258291200,922746880,637534208,1509949440,637534208,0,469762048,1174405120,486539264,369098752,369098752,16777216,771751936,1073741824,150994944,100663296,0,184549376,738197504,922746880,369098752,452984832,436207616,587202560,704643072,1090519040,67108864,0,167772160,956301312,201326592,301989888,1124073472,385875968,1275068416,1140850688,956301312,1543503872,1929379840,905969664,1895825408,1811939328,0,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,50331648,100663296,33554432,83886080,134217728,285212672,788529152,973078528,369098752,0,150994944,469762048,301989888,671088640,620756992,469762048,536870912,134217728,50331648,570425344,1090519040,251658240,234881024,486539264,603979776,67108864,603979776,1291845632,1526726656,1694498816,1442840576,1677721600,1140850688,536870912,50331648,16777216,0,167772160,16777216,218103808,754974720,0,956301312,318767104,201326592,67108864,318767104,0,0,33554432,1241513984,469762048,318767104,0,218103808,1241513984,1660944384,234881024,603979776,1023410176,369098752,973078528,0,520093696,1442840576,905969664,67108864,301989888,16777216,100663296,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,16777216,33554432,0,33554432,201326592,452984832,939524096,956301312,654311424,1090519040,452984832,402653184,301989888,167772160,721420288,822083584,805306368,452984832,0,0,150994944,234881024,503316480,452984832,805306368,1644167168,1459617792,805306368,536870912,352321536,771751936,956301312,1207959552,1744830464,1342177280,150994944,352321536,67108864,83886080,0,0,16777216,268435456,637534208,654311424,637534208,637534208,352321536,419430400,654311424,1258291200,419430400,369098752,218103808,905969664,1040187392,1073741824,1845493760,1291845632,1358954496,1241513984,1073741824,570425344,989855744,67108864,0,0,0,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,16777216,50331648,117440512,184549376,402653184,570425344,1056964608,721420288,587202560,553648128,0,520093696,83886080,134217728,1493172224,754974720,184549376,587202560,117440512,16777216,16777216,0,100663296,1526726656,1392508928,1493172224,1493172224,385875968,1006632960,1174405120,0,0,201326592,0,385875968,16777216,402653184,184549376,201326592,184549376,150994944,16777216,419430400,50331648,167772160,0,0,0,67108864,16777216,0,16777216,50331648,285212672,587202560,721420288,905969664,1459617792,1275068416,687865856,905969664,1358954496,301989888,16777216,117440512,117440512,16777216,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,50331648,0,0,16777216,0,0,33554432,0,436207616,1056964608,989855744,318767104,503316480,318767104,0,285212672,1275068416,805306368,553648128,452984832,251658240,67108864,0,117440512,570425344,822083584,754974720,1526726656,2030043136,1543503872,1560281088,1392508928,1275068416,16777216,0,150994944,117440512,33554432,16777216,16777216,318767104,637534208,704643072,234881024,134217728,234881024,704643072,83886080,704643072,0,335544320,922746880,671088640,1191182336,1006632960,838860800,134217728,0,1426063360,184549376,838860800,989855744,1476395008,654311424,352321536,0,0,100663296,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,0,33554432,0,0,50331648,16777216,50331648,0,150994944,0,0,402653184,167772160,201326592,788529152,218103808,520093696,100663296,134217728,838860800,301989888,738197504,536870912,0,620756992,369098752,486539264,33554432,234881024,738197504,1694498816,419430400,855638016,1795162112,1241513984,134217728,67108864,402653184,167772160,83886080,83886080,16777216,134217728,0,83886080,184549376,268435456,0,603979776,922746880,33554432,704643072,922746880,402653184,603979776,570425344,1140850688,1979711488,1056964608,1191182336,771751936,788529152,587202560,16777216,0,83886080,184549376,0,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,0,0,117440512,117440512,117440512,67108864,117440512,201326592,50331648,16777216,16777216,16777216,620756992,385875968,335544320,536870912,0,234881024,50331648,100663296,33554432,67108864,1124073472,704643072,1056964608,452984832,83886080,0,1694498816,251658240,805306368,1694498816,150994944,0,234881024,805306368,352321536,100663296,16777216,201326592,50331648,184549376,33554432,67108864,0,117440512,33554432,33554432,0,0,50331648,67108864,0,33554432,0,167772160,0,1275068416,1946157056,2013265920,603979776,0,134217728,0,50331648,117440512,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,50331648,67108864,16777216,167772160,16777216,218103808,486539264,16777216,385875968,50331648,134217728,33554432,973078528,637534208,67108864,234881024,201326592,0,67108864,436207616,285212672,738197504,1560281088,1543503872,1593835520,1476395008,1056964608,1073741824,234881024,201326592,0,67108864,134217728,50331648,33554432,16777216,0,16777216,50331648,83886080,100663296,100663296,83886080,0,67108864,234881024,134217728,50331648,100663296,83886080,83886080,67108864,0,0,0,117440512,134217728,67108864,33554432,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,33554432,50331648,67108864,134217728,150994944,117440512,704643072,1224736768,1107296256,452984832,0,939524096,486539264,973078528,1325400064,150994944,654311424,419430400,16777216,369098752,0,0,218103808,1426063360,1342177280,301989888,1610612736,1811939328,805306368,855638016,184549376,0,117440512,50331648,0,0,0,0,16777216,33554432,33554432,16777216,16777216,1090519040,1207959552,335544320,50331648,318767104,369098752,234881024,251658240,234881024,150994944,33554432,16777216,67108864,50331648,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,0,0,16777216,16777216,33554432,0,0,0,167772160,0,268435456,0,0,134217728,33554432,0,1090519040,0,134217728,134217728,0,0,385875968,117440512,201326592,872415232,1040187392,687865856,0,1308622848,318767104,33554432,939524096,536870912,83886080,167772160,0,33554432,33554432,16777216,33554432,33554432,33554432,16777216,0,100663296,0,0,16777216,0,0,50331648,83886080,134217728,167772160,117440512,33554432,0,33554432,33554432,0,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,0,0,0,0,0,16777216,100663296,33554432,100663296,0,0,0,50331648,67108864,134217728,0,201326592,0,201326592,0,150994944,218103808,117440512,0,117440512,0,872415232,50331648,301989888,1056964608,1342177280,83886080,33554432,0,33554432,0,0,134217728,67108864,67108864,67108864,67108864,83886080,67108864,50331648,16777216,721420288,100663296,0,117440512,83886080,33554432,67108864,16777216,0,0,33554432,0,0,16777216,50331648,50331648,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,0,0,0,0,0,0,150994944,16777216,1879048192,1241513984,973078528,0,201326592,0,0,16777216,0,0,67108864,16777216,184549376,117440512,0,0,117440512,218103808,0,201326592,0,1711276032,1811939328,0,0,234881024,50331648,0,16777216,83886080,16777216,16777216,16777216,33554432,50331648,33554432,16777216,0,385875968,520093696,201326592,0,67108864,218103808,100663296,33554432,0,16777216,50331648,16777216,0,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,486539264,1593835520,1744830464,1291845632,0,671088640,134217728,134217728,0,117440512,67108864,50331648,117440512,0,33554432,50331648,100663296,234881024,33554432,637534208,0,520093696,1644167168,234881024,117440512,0,33554432,0,100663296,0,33554432,0,0,0,0,16777216,16777216,16777216,0,0,0,0,0,134217728,167772160,150994944,201326592,0,33554432,50331648,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117440512,0,2063597568,1778384896,0,536870912,754974720,16777216,50331648,0,0,50331648,16777216,0,100663296,83886080,0,352321536,100663296,419430400,1375731712,1006632960,1241513984,1207959552,553648128,587202560,452984832,33554432,0,0,50331648,0,16777216,0,0,0,16777216,16777216,16777216,16777216,50331648,0,184549376,218103808,0,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,721420288,150994944,50331648,117440512,67108864,117440512,0,100663296,0,0,0,50331648,0,83886080,16777216,301989888,16777216,234881024,16777216,1979711488,989855744,0,301989888,1358954496,2130706432,721420288,687865856,201326592,16777216,50331648,16777216,0,0,0,0,0,0,0,0,67108864,0,0,67108864,83886080,0,33554432,16777216,0,0,0,16777216,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,33554432,33554432,50331648,0,0,0,0,0,0,0,0,33554432,117440512,0,67108864,117440512,771751936,385875968,117440512,100663296,50331648,905969664,486539264,251658240,369098752,0,67108864,0,33554432,50331648,33554432,0,0,0,16777216,16777216,16777216,16777216,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,33554432,33554432,33554432,0,0,0,0,0,0,0,0,33554432,16777216,184549376,50331648,67108864,201326592,0,0,33554432,0,234881024,0,0,117440512,83886080,33554432,33554432,50331648,67108864,50331648,16777216,0,16777216,33554432,16777216,16777216,16777216,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,33554432,33554432,0,0,0,0,0,0,0,0,134217728,0,0,100663296,0,1828716544,67108864,83886080,83886080,50331648,16777216,0,33554432,50331648,234881024,0,33554432,50331648,67108864,50331648,16777216,0,16777216,33554432,16777216,16777216,16777216,16777216,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,0,0,0,0,0,0,0,0,16777216,67108864,637534208,436207616,352321536,2046820352,301989888,50331648,0,67108864,67108864,50331648,100663296,0,134217728,0,16777216,16777216,33554432,16777216,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,285212672,0,0,0,67108864,16777216,0,0,50331648,0,83886080,16777216,67108864,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150994944,150994944,0,0,0,67108864,0,67108864,0,251658240,234881024,67108864,83886080,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        ]);
        private var shimonData05:Vector.<uint> = Vector.<uint>([
            16777216,16777216,0,0,0,16777216,16777216,16777216,83886080,83886080,50331648,33554432,16777216,67108864,150994944,218103808,100663296,285212672,167772160,100663296,0,33554432,150994944,486539264,503316480,788529152,872415232,201326592,0,67108864,50331648,0,33554432,100663296,50331648,0,0,117440512,0,234881024,134217728,251658240,134217728,234881024,33554432,50331648,150994944,0,150994944,100663296,83886080,67108864,167772160,117440512,0,16777216,150994944,134217728,0,50331648,150994944,33554432,33554432,16777216,100663296,67108864,33554432,50331648,83886080,83886080,33554432,0,16777216,16777216,16777216,16777216,16777216,16777216,0,0,0,16777216,16777216,33554432,100663296,100663296,83886080,67108864,50331648,50331648,67108864,67108864,0,67108864,50331648,0,184549376,301989888,150994944,452984832,234881024,50331648,0,0,134217728,385875968,520093696,33554432,520093696,654311424,0,1107296256,939524096,0,218103808,0,100663296,16777216,218103808,167772160,16777216,16777216,218103808,83886080,67108864,50331648,134217728,0,0,150994944,167772160,150994944,100663296,150994944,50331648,100663296,83886080,0,50331648,100663296,67108864,33554432,33554432,117440512,117440512,33554432,0,33554432,16777216,16777216,16777216,16777216,16777216,16777216,0,0,16777216,16777216,33554432,33554432,0,0,83886080,150994944,167772160,117440512,33554432,0,318767104,167772160,67108864,318767104,83886080,50331648,67108864,50331648,369098752,419430400,1174405120,1442840576,939524096,469762048,385875968,234881024,973078528,1728053248,1593835520,1778384896,1744830464,2013265920,956301312,201326592,234881024,0,0,67108864,0,0,184549376,33554432,234881024,0,50331648,117440512,83886080,134217728,100663296,83886080,201326592,134217728,0,83886080,184549376,117440512,67108864,0,167772160,67108864,33554432,83886080,67108864,0,50331648,167772160,16777216,16777216,16777216,16777216,16777216,16777216,0,16777216,16777216,16777216,33554432,33554432,100663296,67108864,0,0,0,33554432,150994944,234881024,0,16777216,83886080,234881024,134217728,100663296,1090519040,1744830464,1761607680,1828716544,2046820352,570425344,167772160,16777216,520093696,0,0,805306368,0,905969664,704643072,973078528,939524096,838860800,754974720,654311424,1879048192,134217728,234881024,167772160,0,0,0,150994944,318767104,150994944,33554432,150994944,117440512,67108864,301989888,318767104,201326592,117440512,0,0,285212672,369098752,150994944,83886080,33554432,33554432,33554432,16777216,50331648,100663296,0,0,0,0,16777216,16777216,16777216,16777216,16777216,33554432,50331648,50331648,0,16777216,167772160,234881024,201326592,100663296,16777216,0,0,251658240,570425344,0,1174405120,2080374784,2130706432,1728053248,1912602624,1728053248,0,0,385875968,1811939328,1795162112,687865856,1946157056,1325400064,1308622848,1476395008,637534208,704643072,184549376,335544320,0,0,0,0,603979776,754974720,385875968,268435456,134217728,134217728,167772160,234881024,452984832,385875968,33554432,33554432,50331648,50331648,67108864,234881024,301989888,301989888,234881024,0,16777216,50331648,67108864,50331648,67108864,83886080,16777216,0,0,0,0,0,16777216,0,16777216,16777216,16777216,33554432,50331648,50331648,117440512,100663296,67108864,16777216,0,50331648,134217728,218103808,234881024,402653184,0,1207959552,1862270976,922746880,503316480,33554432,0,469762048,1392508928,1677721600,1660944384,1711276032,1409286144,1811939328,1140850688,1593835520,1610612736,1375731712,1811939328,1728053248,1862270976,1845493760,1577058304,1660944384,1728053248,956301312,570425344,0,402653184,1660944384,1124073472,587202560,50331648,0,100663296,251658240,167772160,301989888,117440512,184549376,201326592,150994944,0,0,251658240,150994944,117440512,117440512,83886080,33554432,50331648,117440512,150994944,134217728,0,0,0,0,0,0,16777216,16777216,33554432,33554432,50331648,67108864,100663296,67108864,33554432,50331648,83886080,134217728,134217728,134217728,218103808,67108864,1291845632,1862270976,0,50331648,452984832,469762048,1124073472,1526726656,1325400064,1962934272,1644167168,838860800,922746880,385875968,1426063360,50331648,1409286144,637534208,0,100663296,436207616,1241513984,771751936,1056964608,1107296256,1543503872,2030043136,1946157056,1140850688,234881024,889192448,721420288,671088640,301989888,0,167772160,167772160,0,301989888,251658240,234881024,251658240,167772160,285212672,419430400,117440512,201326592,117440512,100663296,150994944,117440512,100663296,234881024,452984832,0,0,0,0,0,0,16777216,16777216,33554432,50331648,50331648,67108864,201326592,117440512,50331648,50331648,117440512,134217728,67108864,0,0,1895825408,1459617792,0,134217728,1157627904,2030043136,1509949440,2013265920,838860800,83886080,301989888,184549376,251658240,503316480,570425344,1543503872,1258291200,1795162112,1694498816,1442840576,1358954496,1593835520,1660944384,1375731712,402653184,905969664,268435456,973078528,1375731712,1660944384,1862270976,1358954496,100663296,67108864,620756992,385875968,100663296,150994944,201326592,33554432,83886080,167772160,201326592,83886080,251658240,503316480,285212672,33554432,0,134217728,369098752,318767104,83886080,167772160,469762048,0,0,0,0,16777216,0,33554432,0,83886080,100663296,0,150994944,0,167772160,33554432,301989888,67108864,0,201326592,369098752,218103808,234881024,50331648,503316480,1795162112,1795162112,570425344,50331648,0,50331648,1107296256,1308622848,1342177280,1627389952,1660944384,1761607680,1577058304,1610612736,1358954496,1526726656,1577058304,1811939328,1996488704,1627389952,1694498816,1744830464,1996488704,1610612736,1174405120,1677721600,1342177280,1275068416,1459617792,1644167168,1543503872,285212672,0,33554432,67108864,184549376,234881024,268435456,0,251658240,335544320,167772160,553648128,452984832,520093696,687865856,218103808,67108864,184549376,234881024,721420288,16777216,50331648,33554432,0,0,16777216,0,33554432,0,33554432,50331648,0,134217728,33554432,117440512,100663296,67108864,0,184549376,335544320,16777216,0,117440512,1224736768,1275068416,553648128,0,973078528,1073741824,1258291200,2097152000,1610612736,1392508928,956301312,1493172224,1795162112,1644167168,1577058304,1291845632,402653184,587202560,1660944384,1644167168,1526726656,1577058304,1543503872,1996488704,771751936,1258291200,1644167168,1442840576,1191182336,771751936,654311424,1040187392,1358954496,1358954496,503316480,318767104,134217728,0,234881024,318767104,436207616,0,0,352321536,352321536,184549376,0,218103808,301989888,218103808,150994944,67108864,402653184,117440512,67108864,50331648,16777216,16777216,0,33554432,16777216,33554432,0,0,134217728,83886080,285212672,150994944,33554432,33554432,234881024,150994944,134217728,0,1006632960,1442840576,620756992,150994944,369098752,1677721600,2030043136,1644167168,905969664,855638016,67108864,704643072,704643072,1543503872,1392508928,1677721600,1644167168,1577058304,1862270976,1610612736,1342177280,1778384896,1627389952,754974720,553648128,1476395008,1677721600,1593835520,1543503872,1761607680,1610612736,1610612736,1409286144,788529152,16777216,285212672,637534208,486539264,335544320,100663296,50331648,0,0,419430400,385875968,16777216,67108864,335544320,1191182336,268435456,0,50331648,218103808,0,0,33554432,83886080,50331648,16777216,0,0,50331648,0,67108864,0,16777216,218103808,0,0,184549376,83886080,503316480,1006632960,0,452984832,1778384896,1845493760,268435456,0,1207959552,1677721600,1526726656,33554432,234881024,838860800,1275068416,1509949440,1895825408,1778384896,1459617792,2030043136,1526726656,1660944384,1426063360,1660944384,1610612736,1342177280,1610612736,1660944384,1660944384,721420288,0,1140850688,889192448,1560281088,1526726656,1694498816,889192448,1493172224,1845493760,503316480,184549376,234881024,385875968,1040187392,704643072,369098752,335544320,100663296,0,520093696,1392508928,771751936,50331648,352321536,117440512,218103808,150994944,16777216,184549376,268435456,0,50331648,33554432,0,0,0,33554432,0,83886080,50331648,83886080,234881024,0,83886080,0,150994944,721420288,704643072,369098752,1677721600,1879048192,201326592,822083584,1493172224,1610612736,1073741824,0,1241513984,1778384896,1644167168,1593835520,704643072,553648128,352321536,1442840576,1996488704,1593835520,1711276032,1744830464,1811939328,989855744,1241513984,754974720,956301312,1124073472,1644167168,2046820352,1828716544,1140850688,1694498816,1929379840,1291845632,1509949440,1711276032,1392508928,1325400064,2080374784,1275068416,1124073472,0,0,0,167772160,1207959552,1560281088,100663296,268435456,1660944384,2046820352,83886080,83886080,33554432,83886080,16777216,16777216,117440512,150994944,50331648,33554432,0,0,16777216,16777216,0,67108864,83886080,117440512,150994944,16777216,33554432,352321536,301989888,0,234881024,1023410176,1744830464,83886080,553648128,1694498816,1946157056,587202560,67108864,1577058304,2046820352,1342177280,0,385875968,1426063360,973078528,1409286144,1426063360,1493172224,1543503872,1375731712,1879048192,1224736768,1795162112,1744830464,1560281088,1342177280,285212672,301989888,251658240,1107296256,1627389952,1979711488,1258291200,1677721600,1392508928,1711276032,1358954496,83886080,1426063360,1526726656,1291845632,1711276032,1593835520,436207616,0,251658240,1224736768,1744830464,1073741824,0,1509949440,1962934272,503316480,100663296,872415232,603979776,0,33554432,486539264,67108864,50331648,16777216,16777216,16777216,0,33554432,16777216,83886080,100663296,50331648,167772160,251658240,285212672,0,268435456,1073741824,251658240,50331648,771751936,2063597568,1040187392,0,889192448,1761607680,1895825408,318767104,268435456,1291845632,1593835520,1476395008,1493172224,1895825408,1778384896,1879048192,1476395008,1644167168,1677721600,1979711488,83886080,989855744,1728053248,1509949440,1644167168,1610612736,922746880,33554432,1174405120,1493172224,1476395008,1811939328,0,1224736768,1543503872,1090519040,1593835520,1577058304,335544320,1191182336,1677721600,1593835520,1912602624,436207616,184549376,1124073472,1694498816,922746880,218103808,1627389952,754974720,0,301989888,1325400064,1291845632,67108864,0,67108864,50331648,16777216,16777216,33554432,16777216,83886080,0,50331648,83886080,0,285212672,301989888,0,385875968,402653184,201326592,100663296,452984832,838860800,838860800,234881024,1375731712,1828716544,1375731712,318767104,1308622848,1543503872,1862270976,1476395008,1392508928,1929379840,1509949440,1610612736,1526726656,1694498816,1577058304,1728053248,1308622848,1124073472,1409286144,536870912,0,553648128,1811939328,1795162112,1476395008,1677721600,889192448,1610612736,1543503872,1728053248,1358954496,1543503872,1644167168,1493172224,1660944384,1711276032,1610612736,771751936,402653184,1426063360,1526726656,1694498816,67108864,167772160,1744830464,1174405120,1291845632,486539264,905969664,503316480,0,1560281088,1560281088,201326592,67108864,33554432,0,0,0,100663296,0,218103808,0,100663296,301989888,285212672,16777216,352321536,503316480,520093696,0,654311424,1073741824,234881024,301989888,1694498816,2013265920,520093696,1241513984,1560281088,1560281088,1040187392,771751936,1543503872,1560281088,1392508928,1627389952,1795162112,1275068416,1610612736,1392508928,1660944384,1426063360,1711276032,1493172224,1879048192,822083584,1191182336,1543503872,1577058304,973078528,1543503872,1442840576,1761607680,1358954496,1426063360,1509949440,1862270976,1442840576,1476395008,1660944384,1056964608,1023410176,1778384896,1325400064,637534208,1442840576,1409286144,1778384896,738197504,721420288,1879048192,1879048192,0,637534208,1644167168,436207616,738197504,1040187392,1593835520,0,100663296,67108864,16777216,16777216,167772160,50331648,16777216,234881024,285212672,268435456,83886080,268435456,1006632960,385875968,0,838860800,1291845632,117440512,671088640,1845493760,436207616,0,352321536,2097152000,1258291200,318767104,536870912,1610612736,1493172224,1761607680,1694498816,1828716544,419430400,1342177280,1493172224,1627389952,1593835520,1610612736,1224736768,1409286144,1526726656,1040187392,1509949440,1644167168,1275068416,1392508928,1258291200,1744830464,1509949440,1795162112,1392508928,1593835520,1090519040,1426063360,1593835520,1509949440,1526726656,301989888,285212672,1694498816,1291845632,1845493760,1761607680,1526726656,1694498816,570425344,234881024,1409286144,0,1090519040,1560281088,1442840576,1593835520,0,1929379840,956301312,100663296,0,134217728,50331648,16777216,134217728,16777216,150994944,352321536,117440512,134217728,956301312,1056964608,33554432,637534208,1023410176,16777216,301989888,1174405120,33554432,687865856,922746880,1644167168,1627389952,369098752,1828716544,1862270976,1946157056,1191182336,1040187392,1660944384,1526726656,1795162112,1325400064,1728053248,1543503872,1660944384,1325400064,1560281088,1728053248,939524096,486539264,67108864,1090519040,1509949440,1560281088,1459617792,1560281088,1040187392,1895825408,1811939328,1677721600,1677721600,1392508928,83886080,1191182336,1409286144,2063597568,905969664,1493172224,1795162112,1442840576,1526726656,1660944384,1493172224,1593835520,905969664,0,134217728,1962934272,1409286144,1610612736,1526726656,301989888,452984832,973078528,0,0,16777216,83886080,16777216,134217728,33554432,100663296,268435456,0,788529152,989855744,0,687865856,1224736768,83886080,318767104,1325400064,150994944,788529152,1392508928,905969664,1124073472,268435456,1275068416,1308622848,1660944384,570425344,805306368,1577058304,1694498816,1811939328,1577058304,1728053248,1644167168,788529152,654311424,1375731712,1644167168,1325400064,1308622848,1744830464,905969664,989855744,1258291200,687865856,1325400064,1795162112,1728053248,1459617792,1644167168,1275068416,1358954496,1694498816,1258291200,1291845632,1711276032,1358954496,1862270976,1560281088,637534208,1593835520,1476395008,1778384896,1744830464,1627389952,1912602624,150994944,620756992,1895825408,1493172224,1610612736,1761607680,1895825408,16777216,218103808,0,218103808,0,0,100663296,16777216,33554432,318767104,100663296,419430400,1224736768,201326592,0,1426063360,134217728,184549376,1543503872,637534208,486539264,1509949440,369098752,1157627904,520093696,1409286144,1258291200,1140850688,855638016,1191182336,1660944384,1795162112,1493172224,1811939328,1308622848,989855744,1593835520,1241513984,1426063360,1879048192,738197504,150994944,2013265920,1325400064,1610612736,1224736768,1241513984,822083584,520093696,922746880,1828716544,1342177280,1459617792,1342177280,1677721600,1711276032,1644167168,1476395008,1342177280,1358954496,520093696,989855744,1593835520,1795162112,1711276032,1442840576,1560281088,1644167168,1660944384,1761607680,1795162112,1644167168,1006632960,905969664,1375731712,1392508928,1442840576,50331648,0,117440512,0,0,33554432,16777216,167772160,234881024,0,1124073472,671088640,0,1375731712,251658240,268435456,939524096,889192448,50331648,1644167168,352321536,771751936,1090519040,436207616,1275068416,620756992,855638016,1392508928,1459617792,771751936,1308622848,1744830464,1275068416,1258291200,1862270976,1325400064,905969664,1593835520,939524096,1560281088,1694498816,1358954496,654311424,1207959552,1006632960,1358954496,1509949440,1644167168,1107296256,1694498816,1862270976,1711276032,1375731712,1442840576,1174405120,1627389952,1627389952,1828716544,1845493760,1107296256,939524096,1560281088,1291845632,1845493760,1593835520,1811939328,1593835520,536870912,1728053248,1258291200,1375731712,1577058304,1560281088,1291845632,33554432,469762048,922746880,268435456,0,184549376,100663296,0,117440512,218103808,16777216,369098752,1040187392,184549376,838860800,956301312,134217728,1073741824,1241513984,0,1442840576,620756992,150994944,1275068416,419430400,1409286144,553648128,520093696,1509949440,1358954496,1073741824,234881024,1493172224,1744830464,1224736768,1744830464,1224736768,436207616,1040187392,788529152,1426063360,1124073472,1711276032,1526726656,1845493760,1811939328,872415232,620756992,989855744,2080374784,1744830464,1744830464,1644167168,1342177280,1694498816,1610612736,1761607680,1711276032,1157627904,1275068416,1644167168,1593835520,1728053248,1929379840,1879048192,1493172224,452984832,1325400064,1845493760,0,50331648,1811939328,1862270976,1157627904,1392508928,1828716544,754974720,16777216,771751936,452984832,0,100663296,0,150994944,167772160,0,83886080,1056964608,268435456,469762048,1375731712,83886080,788529152,1778384896,50331648,855638016,1224736768,100663296,1459617792,721420288,939524096,1358954496,503316480,1778384896,1342177280,922746880,1493172224,1627389952,1862270976,1493172224,1409286144,1375731712,1560281088,1409286144,1711276032,1358954496,939524096,905969664,1392508928,1694498816,1358954496,1627389952,1962934272,1375731712,1711276032,486539264,33554432,1342177280,1577058304,1845493760,1660944384,872415232,1627389952,1476395008,771751936,671088640,1627389952,872415232,1493172224,1644167168,1207959552,1694498816,1577058304,1711276032,1895825408,1828716544,1493172224,1526726656,1459617792,1660944384,0,1224736768,1862270976,268435456,0,654311424,50331648,33554432,0,16777216,67108864,50331648,1006632960,687865856,0,1627389952,452984832,486539264,1375731712,721420288,167772160,1711276032,335544320,1157627904,855638016,201326592,1375731712,603979776,1325400064,1828716544,1140850688,1627389952,1241513984,671088640,1627389952,1543503872,1593835520,1694498816,1493172224,1543503872,1845493760,1694498816,1644167168,1778384896,1593835520,1627389952,1442840576,1358954496,1795162112,1409286144,1677721600,1224736768,1174405120,1644167168,1291845632,1325400064,1543503872,1929379840,1660944384,1375731712,1560281088,1610612736,1593835520,1744830464,1778384896,1677721600,1627389952,1442840576,1660944384,1476395008,1728053248,1560281088,1610612736,1811939328,1358954496,1342177280,805306368,1476395008,1694498816,2097152000,369098752,0,0,50331648,201326592,100663296,0,486539264,1191182336,0,1073741824,1509949440,50331648,1409286144,905969664,0,1543503872,872415232,687865856,1426063360,67108864,1593835520,1023410176,1006632960,1862270976,989855744,1711276032,1694498816,1325400064,1577058304,1828716544,1392508928,1509949440,1509949440,620756992,1660944384,1476395008,1191182336,1493172224,1325400064,1124073472,973078528,1879048192,1392508928,1627389952,1459617792,1308622848,1610612736,1694498816,1577058304,1627389952,1509949440,1744830464,1375731712,1627389952,318767104,1275068416,1929379840,1761607680,1677721600,1308622848,822083584,1543503872,1610612736,1744830464,1728053248,1509949440,1275068416,1543503872,1426063360,1560281088,1593835520,1476395008,1375731712,1660944384,1207959552,1342177280,50331648,33554432,33554432,0,83886080,0,704643072,167772160,83886080,1342177280,0,687865856,1308622848,16777216,922746880,1509949440,0,1291845632,603979776,838860800,1593835520,771751936,2013265920,1291845632,1543503872,1711276032,1375731712,1593835520,1644167168,1459617792,1728053248,1728053248,1308622848,1828716544,1459617792,1493172224,1828716544,1191182336,1543503872,1426063360,318767104,889192448,1694498816,1644167168,1560281088,1090519040,1610612736,1811939328,1426063360,1660944384,1560281088,1543503872,1258291200,1761607680,1509949440,83886080,1459617792,1744830464,1778384896,1509949440,1644167168,1476395008,1375731712,1744830464,1409286144,1509949440,1728053248,1459617792,1476395008,1140850688,486539264,1644167168,1761607680,1778384896,1056964608,838860800,1291845632,0,0,50331648,0,1140850688,989855744,0,704643072,872415232,0,1358954496,671088640,754974720,1509949440,1006632960,989855744,1610612736,754974720,1459617792,1107296256,1526726656,1493172224,1342177280,1660944384,452984832,1627389952,1610612736,1442840576,1912602624,1325400064,1728053248,1627389952,1224736768,1694498816,1845493760,1140850688,1627389952,1325400064,1409286144,1375731712,1392508928,1509949440,1828716544,1744830464,1476395008,1577058304,1761607680,1660944384,1593835520,1610612736,1442840576,1744830464,989855744,1358954496,1577058304,1325400064,1744830464,1912602624,1509949440,1476395008,1929379840,1660944384,1677721600,1593835520,1342177280,1459617792,1677721600,1744830464,1493172224,0,218103808,1275068416,1627389952,1191182336,67108864,1862270976,0,0,117440512,0,771751936,167772160,67108864,1191182336,117440512,654311424,1493172224,201326592,1610612736,838860800,301989888,1845493760,385875968,1258291200,1308622848,721420288,1593835520,1275068416,1610612736,1560281088,1224736768,1744830464,1711276032,1660944384,1644167168,1711276032,1325400064,1275068416,1375731712,1241513984,1140850688,1577058304,1644167168,1140850688,1409286144,1577058304,1593835520,1711276032,1560281088,1560281088,1577058304,1493172224,1610612736,1644167168,1392508928,1509949440,1526726656,1442840576,134217728,1325400064,1442840576,1392508928,1660944384,1459617792,1996488704,1543503872,1543503872,1409286144,1677721600,1778384896,1392508928,1325400064,1560281088,1442840576,1711276032,738197504,687865856,1526726656,1107296256,1174405120,318767104,301989888,0,0,0,503316480,251658240,0,520093696,620756992,0,1560281088,553648128,738197504,1543503872,0,1644167168,989855744,771751936,1728053248,469762048,1660944384,1476395008,1660944384,1610612736,1442840576,1845493760,2013265920,1560281088,1811939328,1459617792,1526726656,1593835520,1291845632,1560281088,1375731712,1325400064,1342177280,1258291200,1442840576,1409286144,1610612736,1140850688,1526726656,1660944384,1677721600,1593835520,1660944384,1660944384,1560281088,1593835520,1694498816,1627389952,1476395008,1375731712,1375731712,1308622848,1342177280,1577058304,1627389952,1241513984,1711276032,1543503872,1711276032,1845493760,1442840576,1644167168,1962934272,1610612736,1224736768,1342177280,1325400064,1325400064,1124073472,469762048,1392508928,1795162112,167772160,150994944,67108864,285212672,251658240,0,402653184,1392508928,0,637534208,1409286144,83886080,1593835520,872415232,939524096,1426063360,520093696,1795162112,754974720,1157627904,1761607680,1543503872,1509949440,1711276032,1560281088,1610612736,1291845632,1375731712,1627389952,1744830464,1426063360,1627389952,1191182336,1459617792,1442840576,1090519040,1224736768,1258291200,1442840576,1694498816,1207959552,1811939328,1493172224,1728053248,1644167168,1543503872,1610612736,1459617792,1358954496,1493172224,1577058304,1593835520,1375731712,1577058304,1291845632,1509949440,1761607680,1493172224,1543503872,1862270976,1509949440,1610612736,1593835520,1426063360,1543503872,1291845632,738197504,1577058304,905969664,536870912,1778384896,1577058304,1459617792,1358954496,1325400064,838860800,33554432,0,301989888,0,16777216,0,1023410176,822083584,16777216,1493172224,956301312,134217728,1476395008,352321536,1610612736,1124073472,1174405120,1442840576,889192448,1912602624,989855744,1845493760,1828716544,1560281088,1778384896,1660944384,1358954496,1711276032,1308622848,1610612736,1778384896,1509949440,1711276032,1677721600,1107296256,1795162112,1509949440,1157627904,1275068416,1728053248,1560281088,1627389952,1409286144,1728053248,1577058304,1795162112,1644167168,1459617792,1526726656,1409286144,1409286144,1493172224,1560281088,1224736768,1677721600,1426063360,1644167168,1342177280,1593835520,1207959552,1694498816,1325400064,1342177280,1459617792,1442840576,1207959552,100663296,1392508928,1711276032,0,822083584,285212672,754974720,1526726656,1577058304,1073741824,436207616,16777216,0,0,301989888,67108864,738197504,0,654311424,1644167168,335544320,1207959552,570425344,1224736768,1811939328,1073741824,1543503872,822083584,1207959552,1258291200,1358954496,1761607680,1929379840,1560281088,1543503872,1660944384,1577058304,1711276032,1660944384,1811939328,1627389952,1711276032,1711276032,1291845632,1207959552,1124073472,1509949440,1325400064,1493172224,1140850688,1291845632,1577058304,1509949440,1660944384,1660944384,1577058304,1593835520,1660944384,1560281088,1493172224,1644167168,1426063360,1728053248,1610612736,1644167168,1493172224,1392508928,1660944384,1426063360,1073741824,2046820352,1577058304,301989888,838860800,520093696,1560281088,1191182336,754974720,1912602624,1375731712,1593835520,419430400,637534208,1493172224,553648128,0,0,83886080,0,0,587202560,1577058304,956301312,218103808,1577058304,1107296256,268435456,1392508928,419430400,1560281088,1040187392,1543503872,1342177280,1191182336,1744830464,1207959552,1627389952,1845493760,1375731712,1493172224,1493172224,1509949440,1191182336,1358954496,1895825408,1593835520,1593835520,1593835520,1275068416,1476395008,1577058304,1090519040,1358954496,1308622848,1426063360,1593835520,1744830464,1728053248,1778384896,1778384896,1744830464,1560281088,1526726656,1627389952,1577058304,1560281088,1728053248,1577058304,1644167168,1493172224,1358954496,1811939328,1677721600,1392508928,1610612736,1493172224,1392508928,1761607680,469762048,738197504,771751936,1442840576,1207959552,1442840576,1275068416,1677721600,1560281088,1711276032,1275068416,1442840576,1577058304,385875968,184549376,50331648,0,83886080,872415232,704643072,50331648,402653184,1795162112,436207616,1375731712,1140850688,1543503872,838860800,1459617792,1845493760,184549376,1342177280,1442840576,1476395008,1577058304,1509949440,1392508928,1493172224,1610612736,1509949440,1325400064,1711276032,1660944384,1358954496,1728053248,1409286144,1291845632,1879048192,1308622848,1308622848,1224736768,1493172224,1459617792,1291845632,1493172224,1627389952,1610612736,1677721600,1493172224,1543503872,1644167168,1543503872,1560281088,1660944384,1577058304,1795162112,1342177280,1610612736,1660944384,1543503872,1627389952,1795162112,1560281088,1778384896,1358954496,822083584,905969664,603979776,1660944384,1711276032,1476395008,2030043136,1375731712,1543503872,939524096,889192448,1493172224,1627389952,1409286144,603979776,486539264,50331648,33554432,738197504,67108864,117440512,369098752,503316480,1191182336,973078528,1543503872,1140850688,1426063360,1124073472,1744830464,738197504,1191182336,1929379840,1644167168,1660944384,1509949440,1442840576,1778384896,1107296256,1358954496,1426063360,1610612736,1493172224,1325400064,1610612736,1442840576,1409286144,1644167168,1157627904,1392508928,956301312,1107296256,1358954496,1543503872,1392508928,1711276032,1761607680,1577058304,1610612736,1627389952,1627389952,1660944384,1694498816,1627389952,1577058304,1627389952,1426063360,1811939328,1426063360,1442840576,1577058304,1493172224,1610612736,1593835520,1627389952,1979711488,536870912,939524096,553648128,922746880,1644167168,922746880,1560281088,1509949440,1644167168,1526726656,687865856,1476395008,1308622848,134217728,436207616,536870912,50331648,50331648,67108864,67108864,872415232,33554432,1426063360,973078528,1224736768,1946157056,1493172224,1560281088,1442840576,1660944384,989855744,1744830464,1627389952,1560281088,1409286144,1241513984,1207959552,1090519040,1073741824,1358954496,1560281088,1325400064,1409286144,1811939328,1224736768,1509949440,1543503872,1375731712,1543503872,1358954496,201326592,1509949440,1526726656,1694498816,1442840576,1459617792,1325400064,1694498816,1577058304,1879048192,1610612736,1442840576,1711276032,1526726656,1325400064,1711276032,1392508928,2030043136,1325400064,1392508928,1711276032,1660944384,1442840576,1694498816,1426063360,1744830464,1493172224,603979776,1392508928,67108864,1694498816,0,788529152,1610612736,1375731712,1493172224,1509949440,1476395008,1811939328,1056964608,0,301989888,16777216,50331648,134217728,671088640,1124073472,0,1107296256,285212672,1392508928,1593835520,1275068416,838860800,1409286144,1862270976,1409286144,1526726656,1275068416,1644167168,1258291200,1207959552,1241513984,385875968,1509949440,1174405120,1325400064,905969664,771751936,1577058304,671088640,1660944384,1224736768,536870912,1325400064,50331648,587202560,1325400064,771751936,1174405120,1224736768,1660944384,1526726656,1509949440,1526726656,1543503872,1627389952,1644167168,1543503872,1526726656,1560281088,1526726656,1711276032,1375731712,1543503872,1828716544,1325400064,1577058304,1660944384,1644167168,1644167168,1493172224,1308622848,922746880,771751936,1006632960,1744830464,822083584,989855744,1677721600,738197504,1375731712,1409286144,201326592,1543503872,922746880,0,83886080,50331648,134217728,0,1291845632,167772160,234881024,1577058304,167772160,1308622848,1644167168,788529152,1459617792,1526726656,1560281088,1342177280,1224736768,1124073472,1593835520,385875968,922746880,1241513984,721420288,1644167168,1258291200,1426063360,1577058304,1493172224,1728053248,1694498816,1442840576,805306368,1040187392,1040187392,1107296256,1392508928,1375731712,1056964608,1342177280,905969664,1375731712,1459617792,1258291200,1509949440,1358954496,1660944384,1862270976,1627389952,1677721600,1778384896,1459617792,1627389952,1325400064,1610612736,1694498816,1392508928,1375731712,1560281088,1543503872,1308622848,1040187392,1526726656,1358954496,1258291200,1140850688,1358954496,1090519040,1056964608,1912602624,587202560,771751936,1879048192,335544320,536870912,1426063360,603979776,100663296,33554432,67108864,704643072,587202560,33554432,1308622848,1476395008,33554432,1929379840,1006632960,704643072,1442840576,1677721600,1694498816,1358954496,989855744,1107296256,1073741824,520093696,1191182336,1157627904,1291845632,1342177280,1627389952,1207959552,1174405120,1560281088,1006632960,1711276032,1543503872,620756992,1509949440,1392508928,1073741824,1040187392,1140850688,1375731712,1660944384,1258291200,1375731712,1174405120,1157627904,1375731712,1627389952,1442840576,1375731712,1728053248,1610612736,1325400064,1493172224,1795162112,1778384896,1627389952,1577058304,1828716544,1560281088,1845493760,1426063360,1526726656,1224736768,1040187392,1275068416,1761607680,939524096,989855744,989855744,318767104,553648128,1577058304,184549376,1409286144,1526726656,402653184,738197504,1124073472,100663296,0,0,1124073472,16777216,117440512,1761607680,285212672,788529152,1845493760,1241513984,1577058304,1392508928,1543503872,1509949440,1426063360,419430400,1459617792,889192448,671088640,1224736768,771751936,1174405120,1241513984,1459617792,1627389952,1291845632,1509949440,1325400064,1778384896,1560281088,1493172224,1476395008,520093696,771751936,1241513984,1392508928,1560281088,1392508928,1577058304,1459617792,1493172224,1828716544,1476395008,1660944384,1610612736,1694498816,1543503872,1711276032,1526726656,1778384896,1694498816,1342177280,1828716544,1526726656,1342177280,1744830464,1560281088,1442840576,1493172224,1375731712,1040187392,1023410176,1509949440,1258291200,1308622848,1107296256,1023410176,335544320,1778384896,1442840576,805306368,1627389952,536870912,268435456,805306368,83886080,201326592,33554432,620756992,0,1543503872,1660944384,520093696,1728053248,1174405120,1879048192,1224736768,1778384896,1426063360,1560281088,1711276032,33554432,1291845632,989855744,1174405120,1358954496,1191182336,1795162112,1476395008,1174405120,1073741824,1610612736,1476395008,1224736768,1593835520,1744830464,1426063360,1258291200,318767104,1342177280,872415232,939524096,1375731712,1174405120,1526726656,1593835520,1157627904,1358954496,1694498816,1560281088,1660944384,1493172224,1207959552,1610612736,1509949440,1526726656,1040187392,1660944384,1711276032,1895825408,1610612736,1509949440,1660944384,1241513984,1140850688,201326592,771751936,1275068416,1224736768,1191182336,973078528,620756992,1409286144,201326592,754974720,402653184,134217728,1610612736,838860800,285212672,721420288,33554432,0,50331648,134217728,654311424,2130706432,721420288,150994944,1694498816,1140850688,1342177280,1526726656,1358954496,1577058304,1711276032,469762048,654311424,1509949440,1224736768,1342177280,1107296256,1258291200,1493172224,1526726656,1409286144,721420288,1358954496,1845493760,1627389952,1560281088,1610612736,1258291200,1342177280,50331648,1107296256,671088640,1073741824,1224736768,1157627904,1476395008,1526726656,1509949440,1526726656,1409286144,1929379840,1577058304,1258291200,1493172224,1543503872,1207959552,1694498816,1392508928,1660944384,1560281088,1392508928,1610612736,1728053248,1140850688,419430400,1308622848,385875968,520093696,1828716544,1426063360,989855744,905969664,721420288,1560281088,352321536,1426063360,352321536,1493172224,1509949440,939524096,0,704643072,301989888,16777216,50331648,0,1493172224,1811939328,0,1174405120,1627389952,855638016,1593835520,1811939328,1577058304,1694498816,1191182336,620756992,973078528,1560281088,1325400064,1358954496,1728053248,1342177280,1207959552,1342177280,939524096,1191182336,1426063360,1409286144,1543503872,1577058304,1509949440,1191182336,1442840576,318767104,1526726656,771751936,1124073472,1509949440,1308622848,1459617792,1677721600,1392508928,1409286144,1476395008,1358954496,1409286144,1694498816,771751936,1056964608,1660944384,1426063360,1644167168,1426063360,1660944384,1660944384,1560281088,1761607680,1828716544,654311424,956301312,905969664,754974720,1543503872,1728053248,1476395008,1845493760,620756992,1560281088,1124073472,1560281088,50331648,1023410176,1107296256,486539264,771751936,318767104,402653184,134217728,33554432,721420288,1895825408,503316480,251658240,1929379840,1493172224,1342177280,1593835520,1392508928,1375731712,1358954496,855638016,1241513984,1140850688,1107296256,1426063360,1241513984,1275068416,1342177280,1291845632,1593835520,1694498816,1375731712,1862270976,1677721600,1509949440,1526726656,1644167168,1375731712,1140850688,167772160,1426063360,1224736768,1694498816,1275068416,1493172224,1509949440,1358954496,1627389952,973078528,1258291200,1610612736,1644167168,1811939328,1073741824,1426063360,1291845632,1291845632,1677721600,1627389952,1828716544,1577058304,1509949440,1392508928,553648128,838860800,285212672,1275068416,0,1409286144,268435456,0,1509949440,520093696,1124073472,436207616,536870912,771751936,973078528,889192448,0,2097152000,0,150994944,16777216,67108864,1174405120,1593835520,117440512,1409286144,1476395008,1023410176,1828716544,1442840576,1375731712,1275068416,1275068416,973078528,1140850688,1224736768,1409286144,1694498816,1224736768,1526726656,1509949440,1744830464,1543503872,1560281088,1107296256,1577058304,1711276032,1358954496,1325400064,1560281088,1459617792,1191182336,520093696,1358954496,1493172224,1493172224,1442840576,1509949440,1275068416,1442840576,1593835520,1207959552,989855744,1476395008,1677721600,1476395008,1157627904,1744830464,805306368,939524096,1694498816,1610612736,1644167168,1426063360,1711276032,1778384896,0,1426063360,234881024,1258291200,738197504,1174405120,1358954496,452984832,1879048192,687865856,855638016,134217728,251658240,520093696,603979776,838860800,285212672,1912602624,553648128,150994944,0,100663296,1191182336,536870912,318767104,1895825408,1744830464,1828716544,1409286144,1308622848,1191182336,1476395008,989855744,419430400,1140850688,301989888,1375731712,1409286144,1677721600,1375731712,1342177280,1275068416,1358954496,1660944384,1174405120,1560281088,1476395008,1593835520,1610612736,1577058304,1107296256,1140850688,989855744,1426063360,1073741824,1157627904,1392508928,1862270976,1375731712,1358954496,1593835520,1073741824,1426063360,1577058304,1610612736,1342177280,1207959552,1627389952,1124073472,1174405120,1677721600,1526726656,1442840576,1728053248,1459617792,1459617792,620756992,1073741824,1073741824,654311424,1392508928,1124073472,1342177280,822083584,520093696,1426063360,721420288,318767104,117440512,503316480,234881024,369098752,0,939524096,1023410176,201326592,33554432,50331648,167772160,117440512,1124073472,1879048192,721420288,1207959552,1543503872,989855744,1140850688,989855744,989855744,771751936,1191182336,671088640,1023410176,1694498816,1426063360,1308622848,1258291200,1342177280,1493172224,771751936,1191182336,1409286144,1577058304,1694498816,1509949440,1543503872,1006632960,1342177280,1342177280,1426063360,1409286144,989855744,1543503872,1879048192,1358954496,1593835520,1409286144,1023410176,1476395008,1660944384,1560281088,1744830464,1660944384,1258291200,1291845632,1090519040,1593835520,1627389952,1577058304,1241513984,1728053248,1744830464,738197504,587202560,1308622848,570425344,989855744,1358954496,838860800,704643072,486539264,1442840576,67108864,654311424,687865856,956301312,989855744,754974720,486539264,1040187392,704643072,0,67108864,0,0,268435456,1996488704,1744830464,0,1493172224,1442840576,1073741824,838860800,1040187392,1140850688,1493172224,872415232,1073741824,1107296256,1073741824,1023410176,1358954496,1140850688,1224736768,1291845632,469762048,1409286144,956301312,1409286144,1627389952,1275068416,1476395008,905969664,1476395008,973078528,1241513984,1275068416,1392508928,1342177280,1426063360,1627389952,1409286144,1442840576,1258291200,1761607680,1778384896,1610612736,1459617792,1660944384,1157627904,1342177280,1207959552,1459617792,1660944384,1744830464,1409286144,1543503872,1375731712,1174405120,570425344,1342177280,436207616,1124073472,1040187392,503316480,1224736768,134217728,1358954496,150994944,637534208,1509949440,687865856,956301312,637534208,1040187392,335544320,2013265920,150994944,167772160,16777216,0,822083584,1694498816,889192448,419430400,1526726656,788529152,1090519040,1291845632,1241513984,1325400064,1291845632,1375731712,822083584,100663296,1526726656,1442840576,1577058304,721420288,1308622848,1140850688,822083584,1224736768,436207616,1577058304,1828716544,1761607680,1476395008,704643072,1358954496,1409286144,1392508928,1191182336,1325400064,1358954496,1426063360,1627389952,1459617792,1543503872,1459617792,1342177280,1325400064,2030043136,1577058304,1627389952,1543503872,1140850688,905969664,1711276032,1577058304,1711276032,1409286144,855638016,1006632960,1610612736,285212672,1191182336,687865856,1107296256,1207959552,0,922746880,603979776,452984832,16777216,1275068416,1442840576,1610612736,822083584,620756992,771751936,335544320,1459617792,134217728,0,150994944,33554432,1308622848,1627389952,117440512,1023410176,1610612736,0,1610612736,687865856,1174405120,1224736768,1107296256,973078528,1174405120,1644167168,1258291200,1728053248,1325400064,805306368,1593835520,1308622848,939524096,1442840576,335544320,1392508928,1459617792,1577058304,1392508928,889192448,973078528,1224736768,1543503872,1308622848,1426063360,1476395008,1459617792,1627389952,1543503872,1711276032,1744830464,1392508928,1761607680,1644167168,1291845632,1560281088,1459617792,1291845632,1107296256,1610612736,1577058304,1610612736,1275068416,620756992,1124073472,1023410176,419430400,922746880,939524096,0,1627389952,150994944,603979776,1174405120,16777216,956301312,1627389952,1493172224,1207959552,1426063360,486539264,1342177280,0,570425344,889192448,100663296,0,0,2113929216,1509949440,0,1342177280,1493172224,218103808,1409286144,754974720,1493172224,956301312,1308622848,1291845632,1073741824,1409286144,1426063360,1560281088,1493172224,1426063360,1627389952,1459617792,1291845632,1526726656,218103808,1426063360,1828716544,1694498816,1358954496,1325400064,1291845632,1224736768,1526726656,1409286144,1442840576,1442840576,1325400064,1459617792,1409286144,1593835520,1694498816,1543503872,1711276032,1258291200,1660944384,1509949440,1409286144,1459617792,788529152,1426063360,1627389952,1526726656,1979711488,301989888,788529152,822083584,771751936,469762048,1325400064,117440512,1409286144,620756992,385875968,1040187392,0,822083584,1325400064,1593835520,1493172224,771751936,117440512,1711276032,167772160,687865856,822083584,0,117440512,167772160,2013265920,318767104,603979776,1879048192,419430400,771751936,1056964608,704643072,1325400064,637534208,1342177280,469762048,671088640,1610612736,1509949440,1191182336,1325400064,704643072,855638016,1375731712,1577058304,1291845632,1241513984,1476395008,1526726656,1241513984,1459617792,1493172224,1241513984,1090519040,1677721600,1509949440,1493172224,1493172224,1342177280,1476395008,1426063360,1493172224,1560281088,1358954496,1526726656,1426063360,1593835520,1610612736,1811939328,754974720,805306368,1811939328,1459617792,1627389952,1744830464,352321536,1224736768,352321536,1174405120,419430400,1476395008,67108864,1124073472,1660944384,0,1140850688,33554432,1811939328,1560281088,1291845632,1241513984,0,16777216,1409286144,402653184,536870912,1442840576,570425344,16777216,0,1090519040,0,1291845632,1509949440,16777216,1375731712,889192448,922746880,620756992,989855744,1174405120,469762048,1073741824,402653184,1375731712,1677721600,1308622848,956301312,973078528,1275068416,1493172224,1593835520,1526726656,1241513984,1577058304,1526726656,1593835520,1258291200,1593835520,1627389952,1426063360,1577058304,1526726656,1610612736,1493172224,1644167168,1577058304,1509949440,1543503872,1660944384,1375731712,1694498816,1577058304,1191182336,1795162112,1040187392,1191182336,1795162112,1358954496,1375731712,1493172224,637534208,1174405120,738197504,939524096,352321536,1308622848,587202560,536870912,1526726656,721420288,1493172224,0,1275068416,1560281088,1644167168,671088640,1023410176,83886080,956301312,1392508928,671088640,285212672,67108864,184549376,50331648,0,268435456,1795162112,838860800,33554432,1291845632,872415232,1459617792,805306368,754974720,637534208,503316480,1107296256,939524096,1677721600,402653184,1660944384,1073741824,553648128,1644167168,1644167168,1308622848,1358954496,1493172224,1543503872,1543503872,1811939328,1392508928,1426063360,1509949440,1375731712,1476395008,1426063360,1543503872,1409286144,1577058304,1560281088,1493172224,1560281088,1610612736,1627389952,1593835520,1509949440,1577058304,1543503872,1224736768,1493172224,1308622848,1442840576,1677721600,1275068416,822083584,1006632960,385875968,1157627904,469762048,1157627904,855638016,704643072,1459617792,268435456,1543503872,335544320,855638016,1778384896,1392508928,436207616,1207959552,536870912,251658240,1543503872,704643072,150994944,150994944,0,167772160,0,771751936,1728053248,134217728,285212672,1342177280,83886080,1442840576,570425344,754974720,855638016,553648128,754974720,1493172224,1241513984,721420288,1476395008,570425344,1040187392,1325400064,1459617792,1426063360,1577058304,1476395008,1610612736,1375731712,1526726656,1543503872,1593835520,1728053248,1795162112,1543503872,1442840576,1560281088,1358954496,1526726656,1577058304,1577058304,1711276032,1728053248,1325400064,1459617792,1526726656,1761607680,1291845632,1291845632,1442840576,1728053248,1426063360,1442840576,1610612736,704643072,855638016,771751936,754974720,603979776,637534208,1140850688,234881024,1694498816,0,1560281088,603979776,587202560,1509949440,1006632960,1174405120,771751936,1342177280,167772160,788529152,1392508928,0,16777216,100663296,0,150994944,1879048192,654311424,50331648,1442840576,1157627904,419430400,1241513984,671088640,1442840576,788529152,956301312,754974720,973078528,1157627904,419430400,1291845632,1023410176,1275068416,1140850688,1610612736,1191182336,1627389952,1409286144,1694498816,1577058304,1442840576,1627389952,1593835520,1392508928,1426063360,1526726656,1593835520,1593835520,1610612736,1560281088,1644167168,1442840576,1543503872,1493172224,1476395008,1577058304,1560281088,1577058304,1426063360,1610612736,1459617792,1375731712,1560281088,1610612736,1426063360,654311424,1056964608,419430400,1241513984,855638016,0,1644167168,201326592,1375731712,503316480,1241513984,687865856,536870912,1124073472,889192448,1560281088,335544320,1023410176,654311424,385875968,1107296256,469762048,67108864,67108864,50331648,671088640,1811939328,0,503316480,1543503872,167772160,738197504,1459617792,369098752,1509949440,603979776,905969664,1157627904,922746880,1593835520,771751936,1224736768,889192448,805306368,1426063360,1660944384,1342177280,1493172224,1325400064,1174405120,1392508928,1476395008,1593835520,1476395008,1610612736,1526726656,1442840576,1476395008,1509949440,1543503872,1442840576,1577058304,1392508928,1392508928,1375731712,1593835520,1476395008,1526726656,1862270976,1358954496,1241513984,1610612736,704643072,1409286144,402653184,1174405120,637534208,1140850688,268435456,822083584,1392508928,301989888,1375731712,788529152,788529152,822083584,973078528,905969664,654311424,1543503872,1509949440,1476395008,587202560,536870912,1107296256,117440512,687865856,520093696,33554432,0,67108864,268435456,922746880,167772160,385875968,1426063360,33554432,1174405120,872415232,117440512,1493172224,536870912,788529152,1459617792,1174405120,1543503872,603979776,1023410176,1862270976,1593835520,1073741824,1409286144,1811939328,1040187392,1291845632,1442840576,1694498816,1325400064,1426063360,1526726656,1744830464,1358954496,1610612736,1627389952,1694498816,1728053248,1627389952,1845493760,1694498816,1627389952,1828716544,1325400064,1509949440,1694498816,1241513984,1056964608,1509949440,1325400064,1157627904,1375731712,1090519040,1677721600,436207616,1056964608,1224736768,956301312,1677721600,587202560,1342177280,788529152,704643072,889192448,771751936,1442840576,0,1308622848,1493172224,1040187392,503316480,436207616,570425344,335544320,318767104,553648128,134217728,134217728,0,402653184,201326592,0,1174405120,654311424,0,1627389952,754974720,1056964608,1644167168,1090519040,1375731712,1509949440,1409286144,1409286144,570425344,687865856,1325400064,1593835520,905969664,1023410176,1426063360,1375731712,1308622848,1493172224,1476395008,1358954496,1644167168,1526726656,1543503872,1761607680,1509949440,1493172224,1543503872,1543503872,1426063360,1677721600,1560281088,1459617792,1291845632,1610612736,1476395008,1409286144,1593835520,1459617792,1308622848,1308622848,570425344,1560281088,369098752,1426063360,855638016,1157627904,1258291200,1224736768,1308622848,922746880,587202560,671088640,419430400,1375731712,100663296,1644167168,469762048,1073741824,1090519040,0,1006632960,234881024,553648128,889192448,16777216,83886080,0,0,100663296,134217728,0,671088640,822083584,369098752,654311424,1476395008,939524096,1107296256,1224736768,1711276032,1275068416,1140850688,1744830464,1073741824,1342177280,1006632960,1157627904,1560281088,1140850688,1291845632,1543503872,1610612736,1258291200,1526726656,1275068416,1224736768,1476395008,1778384896,1610612736,1644167168,1627389952,1610612736,1577058304,1509949440,1375731712,1593835520,1459617792,1426063360,1409286144,1543503872,1577058304,1610612736,1509949440,1593835520,1493172224,956301312,1140850688,1241513984,1157627904,1426063360,788529152,1342177280,1392508928,1526726656,1442840576,1224736768,301989888,520093696,436207616,1795162112,285212672,1660944384,788529152,100663296,1459617792,452984832,805306368,754974720,134217728,1006632960,520093696,16777216,67108864,134217728,0,50331648,0,905969664,83886080,989855744,704643072,1375731712,520093696,1610612736,939524096,1459617792,1610612736,1543503872,1476395008,1275068416,1358954496,1459617792,1426063360,1207959552,1459617792,1375731712,1308622848,1207959552,1811939328,1241513984,989855744,1610612736,1593835520,1610612736,1426063360,1577058304,1560281088,1593835520,1509949440,1442840576,1392508928,1526726656,1375731712,1509949440,1610612736,1677721600,1476395008,1493172224,1426063360,1358954496,1124073472,855638016,1728053248,754974720,1073741824,1375731712,1442840576,822083584,1073741824,1073741824,687865856,721420288,251658240,1090519040,285212672,1761607680,402653184,805306368,1644167168,167772160,1543503872,1325400064,117440512,402653184,469762048,285212672,788529152,0,67108864,50331648,0,50331648,167772160,251658240,33554432,1392508928,419430400,1174405120,234881024,1509949440,922746880,1426063360,1023410176,1493172224,1308622848,754974720,1543503872,872415232,1174405120,1291845632,1493172224,1224736768,1509949440,1224736768,1375731712,1325400064,1241513984,1442840576,1442840576,1761607680,1677721600,1493172224,1543503872,1660944384,1543503872,1493172224,1543503872,1577058304,1358954496,1660944384,1207959552,1610612736,1375731712,1493172224,1627389952,1392508928,1006632960,1140850688,1493172224,838860800,1744830464,1056964608,587202560,1291845632,1442840576,1493172224,905969664,385875968,503316480,738197504,167772160,1124073472,1207959552,671088640,1744830464,352321536,704643072,1828716544,134217728,1258291200,872415232,167772160,503316480,16777216,67108864,50331648,0,33554432,33554432,67108864,33554432,1862270976,385875968,1308622848,100663296,922746880,671088640,1593835520,285212672,1006632960,1409286144,536870912,1006632960,1124073472,1358954496,1258291200,1560281088,1174405120,1241513984,1426063360,889192448,1459617792,1442840576,1174405120,1358954496,1577058304,1493172224,1476395008,1543503872,1711276032,1560281088,1509949440,1577058304,1493172224,1174405120,1577058304,1375731712,1761607680,1509949440,1509949440,1476395008,1426063360,1325400064,1543503872,1375731712,0,1744830464,1677721600,1124073472,687865856,788529152,285212672,939524096,385875968,268435456,956301312,184549376,1275068416,1258291200,201326592,1677721600,1023410176,251658240,1040187392,268435456,167772160,754974720,50331648,0,0,50331648,100663296,67108864,16777216,83886080,0,218103808,1476395008,67108864,1157627904,536870912,1191182336,637534208,2113929216,1291845632,1140850688,989855744,922746880,771751936,1358954496,1426063360,1526726656,1409286144,1342177280,1073741824,1677721600,1107296256,1392508928,1140850688,1207959552,1375731712,1509949440,1509949440,1593835520,1610612736,1493172224,1627389952,1509949440,1090519040,1107296256,1358954496,1308622848,1241513984,1291845632,1342177280,1325400064,1358954496,1577058304,1711276032,1660944384,822083584,704643072,1761607680,1140850688,973078528,721420288,1191182336,285212672,1191182336,469762048,805306368,687865856,1191182336,1140850688,1157627904,520093696,721420288,1610612736,251658240,973078528,1325400064,218103808,587202560,838860800,16777216,16777216,16777216,0,0,16777216,201326592,83886080,83886080,486539264,0,1342177280,234881024,1140850688,117440512,1426063360,1375731712,838860800,872415232,771751936,721420288,1056964608,1073741824,1124073472,1191182336,1342177280,1426063360,1207959552,553648128,1308622848,1241513984,1291845632,1358954496,1392508928,1191182336,1560281088,1509949440,1459617792,1509949440,1392508928,1660944384,1124073472,1124073472,1375731712,1744830464,1409286144,1207959552,1325400064,1476395008,1493172224,1308622848,1124073472,687865856,1526726656,1493172224,1493172224,889192448,603979776,754974720,754974720,1056964608,754974720,1476395008,16777216,1342177280,201326592,1023410176,1006632960,1073741824,1526726656,805306368,16777216,1946157056,587202560,234881024,486539264,33554432,16777216,16777216,16777216,16777216,16777216,100663296,83886080,201326592,0,234881024,1207959552,402653184,687865856,201326592,1090519040,1258291200,1275068416,1291845632,1140850688,1090519040,1073741824,1291845632,738197504,1224736768,1006632960,1191182336,788529152,520093696,1426063360,1258291200,1191182336,973078528,1140850688,1224736768,1191182336,1258291200,1275068416,1174405120,922746880,1459617792,1493172224,1526726656,1426063360,1342177280,1308622848,1275068416,1325400064,1476395008,1593835520,1526726656,1358954496,1090519040,1409286144,1459617792,1308622848,1660944384,520093696,973078528,402653184,771751936,1442840576,1560281088,83886080,889192448,1073741824,939524096,1308622848,1744830464,1023410176,1342177280,0,889192448,1509949440,0,67108864,33554432,33554432,33554432,16777216,83886080,16777216,0,0,285212672,100663296,536870912,889192448,553648128,738197504,234881024,184549376,603979776,989855744,872415232,1140850688,1191182336,603979776,1241513984,1157627904,721420288,956301312,1459617792,1426063360,1241513984,1442840576,1291845632,1342177280,956301312,1073741824,1560281088,1124073472,1342177280,872415232,1006632960,1056964608,520093696,1241513984,1778384896,1174405120,1358954496,1308622848,1375731712,1577058304,1560281088,1342177280,1358954496,1644167168,1644167168,1157627904,1325400064,1476395008,1090519040,973078528,1073741824,587202560,1124073472,1526726656,1526726656,671088640,83886080,1023410176,654311424,1845493760,855638016,704643072,1761607680,520093696,570425344,1694498816,134217728,285212672,33554432,16777216,16777216,16777216,0,0,50331648,0,100663296,150994944,520093696,872415232,134217728,637534208,788529152,436207616,905969664,738197504,956301312,536870912,771751936,1124073472,788529152,1325400064,83886080,905969664,1056964608,1610612736,1627389952,1207959552,1459617792,1409286144,1157627904,1056964608,1258291200,1291845632,738197504,1358954496,1157627904,704643072,520093696,1090519040,1207959552,1241513984,1325400064,1275068416,1191182336,1342177280,1560281088,1526726656,1409286144,1459617792,1258291200,1291845632,1291845632,1509949440,1073741824,184549376,1627389952,536870912,1090519040,654311424,436207616,1174405120,218103808,1291845632,452984832,167772160,1258291200,603979776,872415232,1459617792,0,1459617792,1627389952,0,16777216,0,0,0,67108864,0,83886080,100663296,0,83886080,285212672,889192448,0,637534208,1241513984,0,1308622848,838860800,822083584,1090519040,1459617792,721420288,1023410176,1509949440,1073741824,0,1040187392,1006632960,1543503872,1409286144,1711276032,989855744,956301312,1090519040,721420288,1258291200,1006632960,1207959552,1191182336,905969664,922746880,1056964608,1224736768,1258291200,1275068416,1191182336,1023410176,1207959552,1593835520,1627389952,1442840576,1409286144,1375731712,1694498816,1493172224,1392508928,1660944384,1442840576,1090519040,939524096,1660944384,1107296256,100663296,1325400064,0,1040187392,1157627904,134217728,1644167168,419430400,0,1124073472,67108864,0,1107296256,671088640,0,0,0,0,150994944,0,33554432,100663296,0,117440512,117440512,654311424,251658240,251658240,1677721600,318767104,1090519040,973078528,872415232,1040187392,1040187392,1157627904,1073741824,1392508928,1308622848,973078528,1409286144,1006632960,1342177280,1677721600,1207959552,721420288,872415232,1207959552,922746880,1107296256,1526726656,1157627904,956301312,1275068416,1493172224,1006632960,855638016,1392508928,1526726656,1342177280,1241513984,1526726656,1627389952,1191182336,1023410176,1459617792,1795162112,1140850688,1241513984,1358954496,1124073472,1644167168,1375731712,704643072,1375731712,905969664,771751936,1526726656,989855744,385875968,1107296256,16777216,1207959552,1459617792,184549376,872415232,352321536,184549376,0,33554432,0,0,0,0,33554432,0,33554432,50331648,0,100663296,33554432,352321536,469762048,150994944,1191182336,452984832,486539264,620756992,939524096,838860800,1291845632,721420288,754974720,1191182336,1124073472,1258291200,1174405120,1207959552,939524096,1224736768,0,771751936,1040187392,1124073472,1342177280,989855744,822083584,1308622848,1207959552,1291845632,1157627904,1426063360,1157627904,1207959552,788529152,1509949440,1610612736,1258291200,1291845632,1543503872,1560281088,1509949440,1157627904,1459617792,1694498816,1157627904,1442840576,1174405120,1023410176,1258291200,1258291200,939524096,1174405120,671088640,1207959552,620756992,1728053248,905969664,738197504,1459617792,1107296256,1845493760,1828716544,872415232,822083584,620756992,16777216,16777216,16777216,16777216,50331648,16777216,83886080,33554432,0,134217728,352321536,218103808,369098752,268435456,234881024,67108864,671088640,218103808,536870912,1056964608,1241513984,1157627904,1107296256,1358954496,989855744,989855744,1056964608,1811939328,1476395008,1358954496,1040187392,989855744,1409286144,1107296256,872415232,855638016,1358954496,1107296256,1442840576,956301312,838860800,805306368,1090519040,1392508928,1056964608,1627389952,1493172224,1040187392,1459617792,1493172224,1358954496,805306368,1291845632,1409286144,1426063360,805306368,1644167168,1157627904,872415232,1241513984,385875968,1426063360,1509949440,402653184,469762048,1476395008,922746880,1258291200,0,1174405120,1476395008,1107296256,503316480,1056964608,0,369098752,0,0,0,0,67108864,16777216,100663296,83886080,0,117440512,301989888,201326592,251658240,134217728,100663296,117440512,855638016,570425344,268435456,671088640,822083584,1375731712,1291845632,1560281088,1275068416,1459617792,1291845632,1191182336,1191182336,1207959552,1375731712,1157627904,788529152,1241513984,771751936,838860800,1224736768,1040187392,1073741824,822083584,671088640,956301312,1610612736,1241513984,1191182336,1342177280,1325400064,1291845632,1476395008,1107296256,1258291200,1392508928,1174405120,1442840576,1124073472,1157627904,1526726656,1275068416,1174405120,771751936,1056964608,1677721600,1610612736,1811939328,1811939328,570425344,687865856,1593835520,1006632960,134217728,1342177280,1577058304,234881024,738197504,973078528,0,0,0,0,0,50331648,16777216,50331648,100663296,16777216,67108864,184549376,150994944,167772160,100663296,234881024,0,536870912,889192448,419430400,1023410176,1610612736,1258291200,922746880,838860800,1392508928,1476395008,1476395008,1375731712,1056964608,1509949440,603979776,1191182336,1140850688,922746880,989855744,1056964608,1090519040,989855744,1207959552,1224736768,1358954496,1358954496,1124073472,939524096,1224736768,1358954496,1543503872,1224736768,1442840576,1191182336,1493172224,1342177280,704643072,1459617792,1291845632,1006632960,855638016,956301312,1224736768,855638016,838860800,872415232,1543503872,1476395008,1291845632,1056964608,536870912,218103808,1895825408,939524096,117440512,486539264,1107296256,352321536,1526726656,16777216,0,0,0,0,67108864,16777216,16777216,83886080,16777216,16777216,117440512,150994944,117440512,654311424,335544320,268435456,503316480,503316480,754974720,469762048,1023410176,956301312,301989888,939524096,1342177280,1392508928,536870912,1157627904,754974720,1090519040,0,234881024,905969664,1073741824,1258291200,1375731712,1358954496,1811939328,1895825408,1711276032,1241513984,1241513984,1493172224,1056964608,1728053248,1224736768,1207959552,1174405120,1392508928,1056964608,1275068416,1258291200,1392508928,1056964608,1107296256,1006632960,1291845632,1241513984,1140850688,1593835520,788529152,1392508928,1207959552,1694498816,1526726656,1610612736,1090519040,654311424,419430400,1224736768,939524096,117440512,1040187392,335544320,50331648,0,0,0,0,0,100663296,33554432,33554432,100663296,50331648,50331648,134217728,234881024,201326592,0,234881024,0,234881024,553648128,536870912,134217728,587202560,553648128,771751936,1056964608,318767104,1157627904,1073741824,654311424,671088640,788529152,16777216,1040187392,1375731712,1224736768,1191182336,1258291200,1426063360,1090519040,1006632960,721420288,1325400064,1442840576,704643072,1593835520,1090519040,1090519040,905969664,1409286144,1056964608,1543503872,1241513984,1191182336,1358954496,1073741824,1090519040,1056964608,1560281088,1728053248,805306368,973078528,536870912,436207616,83886080,1476395008,989855744,1107296256,1392508928,1593835520,318767104,0,1526726656,419430400,1006632960,318767104,0,117440512,0,0,0,0,67108864,33554432,33554432,50331648,33554432,33554432,100663296,201326592,956301312,369098752,301989888,100663296,201326592,335544320,503316480,184549376,822083584,704643072,369098752,872415232,1107296256,654311424,1140850688,721420288,754974720,822083584,838860800,50331648,1560281088,1358954496,1728053248,1543503872,1090519040,1174405120,1325400064,1090519040,1275068416,1207959552,905969664,1258291200,1207959552,1124073472,1526726656,1593835520,1593835520,1426063360,1493172224,1526726656,1375731712,805306368,587202560,1241513984,687865856,973078528,771751936,973078528,637534208,1157627904,1124073472,1241513984,1593835520,1543503872,201326592,939524096,1560281088,369098752,33554432,654311424,654311424,671088640,0,50331648,0,0,0,0,33554432,50331648,33554432,33554432,16777216,16777216,33554432,100663296,385875968,50331648,369098752,150994944,167772160,486539264,218103808,335544320,939524096,536870912,620756992,285212672,268435456,1358954496,620756992,721420288,738197504,1241513984,251658240,83886080,1207959552,788529152,838860800,939524096,1040187392,855638016,1308622848,1191182336,1644167168,1375731712,872415232,1660944384,1291845632,1711276032,1308622848,1174405120,436207616,1358954496,1040187392,1040187392,587202560,1493172224,771751936,1090519040,939524096,1090519040,536870912,905969664,1308622848,1107296256,1275068416,1845493760,872415232,687865856,1207959552,671088640,486539264,838860800,150994944,134217728,285212672,587202560,0,83886080,0,0,0,0,16777216,83886080,67108864,16777216,50331648,33554432,0,50331648,0,452984832,268435456,318767104,352321536,536870912,402653184,234881024,469762048,771751936,452984832,771751936,335544320,318767104,654311424,788529152,520093696,369098752,754974720,0,1174405120,872415232,838860800,1040187392,1107296256,1006632960,1409286144,1258291200,1258291200,855638016,905969664,1107296256,1442840576,1275068416,1224736768,1040187392,1090519040,1291845632,1140850688,1073741824,1375731712,1358954496,1342177280,1459617792,100663296,134217728,436207616,352321536,486539264,1056964608,0,1275068416,1107296256,0,922746880,973078528,1006632960,1073741824,805306368,385875968,0,0,251658240,0,0,0,0,0,0,0,0,0,0,0,0,0,100663296,201326592,134217728,33554432,318767104,352321536,402653184,167772160,419430400,419430400,822083584,251658240,150994944,469762048,603979776,704643072,838860800,352321536,436207616,67108864,536870912,1124073472,1140850688,1509949440,1459617792,1275068416,1761607680,1191182336,1191182336,637534208,1006632960,1056964608,1291845632,1241513984,1375731712,1140850688,1442840576,1241513984,1459617792,1593835520,1543503872,1392508928,1191182336,587202560,1140850688,1191182336,973078528,536870912,1140850688,1342177280,855638016,1124073472,1845493760,1610612736,301989888,0,520093696,738197504,503316480,1006632960,83886080,167772160,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,251658240,218103808,50331648,184549376,369098752,486539264,218103808,16777216,352321536,603979776,956301312,603979776,738197504,301989888,721420288,654311424,503316480,738197504,553648128,1224736768,1207959552,1140850688,1073741824,1157627904,1610612736,1157627904,1157627904,1526726656,1358954496,1342177280,1392508928,1426063360,1409286144,855638016,721420288,1325400064,1409286144,1124073472,1023410176,872415232,1056964608,872415232,704643072,905969664,754974720,637534208,838860800,1358954496,1291845632,1191182336,1358954496,1526726656,922746880,1258291200,805306368,50331648,117440512,285212672,973078528,184549376,184549376,0,50331648,0,0,0,0,0,0,0,0,0,0,0,0,117440512,385875968,352321536,268435456,134217728,301989888,436207616,285212672,251658240,436207616,184549376,436207616,687865856,905969664,587202560,771751936,251658240,570425344,1392508928,67108864,285212672,587202560,738197504,1174405120,1124073472,1124073472,1056964608,1040187392,1342177280,1140850688,1593835520,1325400064,1140850688,721420288,1241513984,1442840576,1124073472,436207616,1191182336,1358954496,805306368,1140850688,956301312,838860800,33554432,1023410176,419430400,167772160,1543503872,1493172224,1006632960,134217728,620756992,335544320,905969664,1644167168,1224736768,285212672,352321536,201326592,218103808,0,100663296,16777216,0,0,0,0,0,0,0,0,0,0,0,0,16777216,117440512,150994944,385875968,117440512,218103808,419430400,452984832,117440512,436207616,301989888,335544320,553648128,603979776,654311424,637534208,654311424,0,704643072,117440512,503316480,973078528,1023410176,1140850688,1157627904,1174405120,1275068416,1140850688,1157627904,989855744,1124073472,1660944384,1644167168,1157627904,1610612736,1577058304,922746880,335544320,1124073472,822083584,436207616,83886080,754974720,352321536,285212672,1090519040,1375731712,1795162112,1526726656,1308622848,1728053248,1191182336,301989888,251658240,352321536,100663296,620756992,218103808,1660944384,100663296,0,0,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,335544320,16777216,134217728,385875968,369098752,285212672,385875968,134217728,452984832,268435456,419430400,637534208,738197504,1006632960,603979776,788529152,671088640,335544320,905969664,1644167168,889192448,973078528,419430400,771751936,536870912,1275068416,973078528,1308622848,1157627904,788529152,1308622848,905969664,1241513984,1476395008,1660944384,1140850688,1073741824,587202560,637534208,1174405120,822083584,1526726656,1291845632,905969664,855638016,1493172224,1526726656,1124073472,1056964608,771751936,721420288,654311424,201326592,50331648,150994944,1207959552,452984832,50331648,167772160,134217728,50331648,0,0,0,0,0,0,0,0,0,0,0,0,50331648,83886080,268435456,352321536,50331648,335544320,704643072,419430400,201326592,234881024,201326592,385875968,469762048,620756992,855638016,620756992,436207616,654311424,335544320,620756992,973078528,889192448,721420288,1275068416,939524096,738197504,721420288,1056964608,939524096,1056964608,1392508928,687865856,201326592,603979776,1107296256,1342177280,369098752,654311424,687865856,452984832,385875968,587202560,419430400,872415232,721420288,33554432,100663296,419430400,503316480,67108864,0,0,369098752,587202560,704643072,620756992,352321536,67108864,369098752,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,251658240,268435456,67108864,419430400,989855744,654311424,335544320,469762048,436207616,150994944,285212672,436207616,872415232,956301312,922746880,402653184,603979776,553648128,167772160,771751936,738197504,922746880,620756992,1224736768,1325400064,771751936,1107296256,385875968,771751936,721420288,134217728,721420288,1140850688,671088640,335544320,721420288,939524096,1174405120,1342177280,1107296256,855638016,771751936,570425344,402653184,1056964608,721420288,1174405120,687865856,1006632960,452984832,268435456,83886080,0,184549376,67108864,167772160,1325400064,134217728,0,251658240,0,150994944,0,0,0,0,0,0,0,0,0,0,0,0,83886080,0,134217728,117440512,0,0,637534208,369098752,536870912,603979776,234881024,620756992,587202560,671088640,218103808,536870912,1040187392,570425344,452984832,754974720,771751936,956301312,620756992,587202560,452984832,218103808,520093696,117440512,1258291200,922746880,989855744,754974720,1275068416,520093696,654311424,1157627904,905969664,1191182336,838860800,956301312,1140850688,671088640,637534208,973078528,671088640,788529152,872415232,1358954496,1090519040,1157627904,956301312,771751936,1040187392,889192448,738197504,771751936,385875968,318767104,0,0,50331648,0,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,318767104,268435456,0,50331648,167772160,67108864,553648128,654311424,419430400,536870912,587202560,436207616,754974720,687865856,100663296,184549376,520093696,671088640,671088640,637534208,738197504,520093696,654311424,671088640,771751936,503316480,855638016,570425344,452984832,117440512,939524096,973078528,1090519040,587202560,973078528,989855744,973078528,402653184,402653184,100663296,486539264,553648128,905969664,687865856,1392508928,838860800,1191182336,587202560,855638016,1040187392,16777216,889192448,150994944,184549376,117440512,50331648,33554432,50331648,50331648,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,83886080,83886080,335544320,318767104,83886080,184549376,268435456,503316480,452984832,167772160,1140850688,788529152,251658240,855638016,603979776,503316480,1207959552,872415232,318767104,385875968,285212672,33554432,469762048,838860800,905969664,536870912,855638016,704643072,637534208,687865856,503316480,738197504,1241513984,922746880,1040187392,721420288,889192448,939524096,754974720,973078528,838860800,805306368,570425344,687865856,805306368,1509949440,1275068416,1241513984,486539264,184549376,0,234881024,520093696,0,100663296,117440512,100663296,83886080,67108864,50331648,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134217728,134217728,16777216,83886080,117440512,419430400,738197504,570425344,503316480,402653184,150994944,536870912,520093696,385875968,1040187392,1040187392,1157627904,956301312,771751936,436207616,201326592,486539264,553648128,201326592,570425344,822083584,587202560,687865856,738197504,318767104,989855744,671088640,620756992,922746880,822083584,436207616,704643072,67108864,536870912,587202560,285212672,872415232,83886080,738197504,822083584,536870912,352321536,889192448,1056964608,956301312,654311424,973078528,805306368,67108864,83886080,100663296,83886080,50331648,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,50331648,16777216,50331648,50331648,16777216,33554432,33554432,0,67108864,570425344,301989888,1241513984,503316480,150994944,822083584,1761607680,1493172224,201326592,301989888,603979776,654311424,469762048,452984832,201326592,0,335544320,469762048,520093696,369098752,268435456,134217728,0,0,520093696,335544320,33554432,218103808,201326592,301989888,201326592,134217728,0,452984832,788529152,553648128,1426063360,1224736768,1308622848,989855744,1627389952,704643072,134217728,16777216,117440512,0,67108864,67108864,67108864,50331648,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,50331648,33554432,0,0,50331648,16777216,0,50331648,0,67108864,0,889192448,486539264,469762048,83886080,218103808,654311424,218103808,469762048,218103808,218103808,469762048,486539264,436207616,671088640,419430400,0,419430400,469762048,503316480,973078528,50331648,184549376,637534208,385875968,0,150994944,587202560,687865856,285212672,805306368,671088640,1124073472,654311424,805306368,1459617792,1006632960,402653184,1174405120,335544320,50331648,50331648,201326592,620756992,251658240,100663296,50331648,0,0,16777216,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,0,0,201326592,520093696,436207616,402653184,520093696,553648128,671088640,100663296,33554432,469762048,50331648,385875968,570425344,452984832,285212672,83886080,83886080,50331648,268435456,335544320,67108864,201326592,922746880,335544320,50331648,721420288,520093696,419430400,419430400,150994944,335544320,402653184,385875968,0,1056964608,637534208,16777216,956301312,201326592,50331648,50331648,536870912,301989888,486539264,486539264,100663296,301989888,301989888,100663296,33554432,0,0,0,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,67108864,0,0,67108864,0,50331648,16777216,83886080,654311424,1493172224,1375731712,738197504,335544320,1056964608,905969664,603979776,218103808,402653184,218103808,184549376,486539264,301989888,385875968,285212672,251658240,369098752,134217728,33554432,436207616,0,50331648,0,234881024,620756992,436207616,637534208,922746880,536870912,0,436207616,100663296,0,117440512,201326592,268435456,805306368,553648128,50331648,268435456,352321536,268435456,16777216,134217728,134217728,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,0,67108864,0,0,16777216,0,16777216,0,83886080,117440512,0,0,100663296,50331648,50331648,0,654311424,469762048,352321536,570425344,150994944,16777216,385875968,318767104,352321536,117440512,100663296,587202560,486539264,201326592,654311424,872415232,0,234881024,218103808,0,587202560,553648128,587202560,436207616,620756992,218103808,318767104,385875968,285212672,67108864,134217728,0,251658240,0,117440512,0,150994944,268435456,0,0,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,50331648,50331648,67108864,83886080,100663296,100663296,117440512,16777216,150994944,0,134217728,285212672,268435456,369098752,50331648,0,67108864,184549376,50331648,83886080,335544320,520093696,687865856,1040187392,687865856,721420288,838860800,318767104,318767104,0,83886080,150994944,0,16777216,50331648,33554432,234881024,318767104,50331648,150994944,67108864,33554432,83886080,83886080,33554432,16777216,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,33554432,33554432,50331648,50331648,67108864,67108864,201326592,16777216,150994944,268435456,251658240,385875968,134217728,184549376,50331648,100663296,83886080,83886080,100663296,100663296,285212672,0,117440512,0,251658240,218103808,369098752,251658240,335544320,201326592,50331648,83886080,100663296,67108864,218103808,301989888,67108864,117440512,50331648,33554432,67108864,83886080,16777216,16777216,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,33554432,33554432,33554432,50331648,50331648,50331648,50331648,33554432,150994944,16777216,83886080,150994944,150994944,301989888,150994944,335544320,117440512,83886080,100663296,167772160,218103808,184549376,301989888,503316480,671088640,150994944,251658240,0,117440512,385875968,0,150994944,50331648,83886080,83886080,16777216,117440512,184549376,16777216,83886080,16777216,0,50331648,50331648,16777216,16777216,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,33554432,33554432,33554432,33554432,33554432,33554432,33554432,0,83886080,0,16777216,83886080,83886080,184549376,83886080,100663296,33554432,33554432,0,83886080,301989888,251658240,201326592,402653184,922746880,150994944,0,83886080,100663296,184549376,134217728,83886080,33554432,50331648,33554432,0,16777216,67108864,0,50331648,0,0,16777216,33554432,16777216,16777216,33554432,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,50331648,0,33554432,100663296,117440512,134217728,50331648,0,0,67108864,0,67108864,218103808,83886080,16777216,0,100663296,16777216,67108864,0,83886080,251658240,33554432,50331648,33554432,50331648,33554432,0,16777216,50331648,16777216,16777216,0,0,0,16777216,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,16777216,0,16777216,83886080,100663296,67108864,16777216,167772160,0,50331648,83886080,117440512,167772160,167772160,318767104,67108864,301989888,201326592,33554432,83886080,16777216,0,0,0,16777216,16777216,16777216,0,0,16777216,33554432,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,16777216,16777216,16777216,16777216,16777216,16777216,16777216,0,0,0,0,16777216,33554432,0,16777216,117440512,0,0,0,33554432,117440512,167772160,352321536,201326592,67108864,150994944,100663296,0,0,117440512,16777216,0,0,0,0,0,0,0,0,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,0,0,0,0,50331648,0,16777216,117440512,33554432,33554432,117440512,0,0,0,16777216,0,16777216,0,0,117440512,0,0,16777216,0,0,16777216,0,0,0,16777216,16777216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        ]);
    }
}