/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fYwm
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.setInterval;
    import starling.core.Starling;
    
    /**
     * ...
     * @author jaiko
     */
    public class Main extends Sprite 
    {
        private var maruList:Array;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var viewManager:ViewManager = ViewManager.getInstance();
            addChild(viewManager);
        }
        
        
    }
    
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
import starling.core.Starling;

/**
 * ...
 * @author jaiko
 */
class ViewManager extends Sprite 
{
    private static var _gravityTheta:Number;
    //
    private static var _instance:ViewManager;
    private static var g:Graphics;;
    private static var cx:Number;
    private static var cy:Number;
    private static var tf:TextField;
    private static var backGround:Sprite;
    //public var starling:Starling;
    public function ViewManager(block:SingletonBlock) 
    {
        if (stage) init();
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    public static function getInstance():ViewManager
    {
        if (_instance == null)
        {
            _instance = new ViewManager(new SingletonBlock());
        }
        return _instance;            
    }
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        //
        layout();
    }
    
    private function layout():void 
    {
        _gravityTheta = 2 * Math.PI * Math.random();;
        g = this.graphics;
        cx = stage.stageWidth * 0.5;
        cy = stage.stageHeight * 0.5;
        
        /*
        starling = new Starling(StarlingManager, stage, null, null);
        starling.enableErrorChecking = true;
        starling.start();
        */
        var maruManager:MaruManager = new MaruManager();
        addChild(maruManager);
        

        backGround = new Sprite();
        addChild(backGround)
        var g_back:Graphics;
        g_back = backGround.graphics;
        g_back.beginFill(0xFFFFFF,0.8);
        g_back.drawRect(0, 0, 200, 20)
        tf = new TextField();
        addChild(tf);

        tf.height = 20;
        //
        stage.addEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelListener);
    }
    
    private function mouseWheelListener(e:MouseEvent):void 
    {
        //trace(e.delta);
        
        _gravityTheta += e.delta * 0.1;
    }
    public static function enterFrameListener(event:Event = null):void
    {
        
        //tf.text = String(StarlingManager(_instance.starling.root).squareNumber);
        tf.text = String(MaruManager.squareNumber);
        backGround.width = tf.textWidth+5;
        
        _gravityTheta += 0.01;
        if (_gravityTheta > 2 * Math.PI)
        {
            _gravityTheta -= 2 * Math.PI;
        }
        else if ( _gravityTheta < 0)
        {
            _gravityTheta += 2 * Math.PI;
        }
        
        var _x:Number;
        var _y:Number;
        _x = cx + 20 * Math.cos(_gravityTheta);
        _y = cy + 20 * Math.sin(_gravityTheta);
        g.clear();
        g.lineStyle(2, 0xFF0000);
        g.drawCircle(cx, cy, 20);
        g.moveTo(cx, cy);
        g.lineTo(_x, _y);
    }
    
    static public function get gravityTheta():Number 
    {
        return _gravityTheta;
    }
}

class SingletonBlock {
    
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.utils.clearInterval;
import flash.utils.setInterval;
/**
 * ...
 * @author jaiko
 */
class MaruManager extends Sprite
{
    private var maruList:Array;
    private static var _squareNumber:Number = 100;
    private var id:uint;
    public function MaruManager() 
    {
        if (stage) init();
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    private function init(event:Event = null):void
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        //
        layout();
    }
    
    private function layout():void 
    {
        var i:uint;
        var n:uint;
        var maru:Maru;
        //
        maruList = [];
        n = _squareNumber;
        for (i = 0; i < n; i++)
        {
            maru = addMaru();
            maru.x = stage.stageWidth * Math.random();
            maru.y = stage.stageHeight * Math.random();
        }
        
        stage.addEventListener(MouseEvent.MOUSE_DOWN , mouseDownListener);
        addEventListener(Event.ENTER_FRAME, enterFrameListener);
    }
    private function addClosure():void
    {
        var i:uint;
        var n:uint;
        var maru:Maru;
        n = 4 + Math.floor(7 * Math.random());
        for (i = 0; i < n; i++)
        {
            maru = addMaru();
            maru.x = stage.mouseX;
            maru.y = stage.mouseY;
        }
    }
    private function mouseDownListener(e:MouseEvent):void 
    {
        id = setInterval(addClosure, 1);
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
    }
    
    private function mouseUpListener(e:MouseEvent):void 
    {
        clearInterval(id);
        stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
    }
    
    private function enterFrameListener(e:Event):void 
    {
        var maru:Maru;
        var i:uint;
        var n:uint;
        n = maruList.length;
        for (i = 0; i < n; i++)
        {
            maru = maruList[i];
            maru.enterFrameListener();
        }
        //
        ViewManager.enterFrameListener();
    }
    private function addMaru():Maru
    {
        var maru:Maru = new Maru();
        addChild(maru);
        maruList.push(maru);
        
        _squareNumber = this.numChildren;
        return maru;
    }
    
    static public function get squareNumber():Number 
    {
        return _squareNumber;
    }
    
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;

/**
 * ...
 * @author jaiko
 */
class Maru extends Sprite 
{
    private const LENGTH:Number = 5;
    private const SPEED:Number = 10;
    
    private var vx:Number;
    private var vy:Number;     
    
    public function Maru() 
    {
        if (stage) init();
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        //
        layout();
        
    }
    
    private function layout():void 
    {
        var g:Graphics = this.graphics;
        g.beginFill(0);
        g.drawRect(LENGTH * -0.5, LENGTH * -0.5, LENGTH, LENGTH);
        
        var theta:Number = Math.random() * 2 * Math.PI;
        vx = SPEED * Math.cos(theta);
        vy = SPEED * Math.sin(theta);

        //addEventListener(Event.ENTER_FRAME, enterFrameListener);
    }
    
    public function enterFrameListener(e:Event = null):void 
    {
        
        var ax:Number = 1 * Math.cos(ViewManager.gravityTheta);
        var ay:Number = 1 * Math.sin(ViewManager.gravityTheta);
        vx += ax- 0.01*vx;
        vy += ay- 0.01*vy;
        this.x += vx;
        this.y += vy;
        
        if (this.x < 0) {
            vx *= -1;
            this.x =0
        }
        else if (this.x > stage.stageWidth)
        {
            vx *= -1;
            this.x = stage.stageWidth;
        }
        if (this.y < 0) {
            vy *= -1;
            this.y = 0;
        }
        else if (this.y > stage.stageHeight)
        {
            vy *= -1;
            this.y = stage.stageHeight;
        }
    }
    
}
