/**
 * Copyright vasari ( http://wonderfl.net/user/vasari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fYsR
 */

// forked from yonatan's Plasmountains
package {
    import flash.display.*;
    import flash.geom.*;
    import flash.utils.*;
    import net.hires.debug.Stats;

    [SWF(width=465,height=465,frameRate=30,backgroundColor=0x88aaff)]
    public class FlashTest extends Sprite {
        private static const SIZE:int = 32;
        private static const HEIGHTMAP_OCTAVES:int = 6;

        private var vertices:Vector.<Number> = new Vector.<Number>(SIZE*SIZE*3, true);
        private var projected:Vector.<Number> = new Vector.<Number>(0, false);
        private var uvtData:Vector.<Number> = new Vector.<Number>(SIZE*SIZE*3, true);
        private var heightMap:BitmapData = new BitmapData(SIZE, SIZE, false);
        private var heightMapVector:Vector.<uint>;
        private var indices:Vector.<int> = new Vector.<int>(0, false);
        private var tmpBmd1:BitmapData = new BitmapData(SIZE, SIZE);
        private var texture:BitmapData = new BitmapData(SIZE, SIZE);
        private var projection:PerspectiveProjection = new PerspectiveProjection();
        private var viewport:Shape = new Shape();

        private var stats:Sprite = new Sprite;
        
        public function FlashTest() {
            viewport.x = viewport.y = 465 / 2;
            addChild(viewport);
            projection.fieldOfView = 20;

            stats.addChild(new Bitmap(heightMap));
            stats.addChild(new Bitmap(tmpBmd1)).y=SIZE*1.1;
            stats.addChild(new Bitmap(texture)).y=SIZE*2.2;
            stats.addChild(new Stats()).x=400;
            addChild(stats).visible = false;

            addEventListener("enterFrame", loop);
            stage.addEventListener("click", function(e:*):void { stats.visible = !stats.visible; });
        }

        private var offset:Number = 0;

        private function loop(e:*):void {
            var offsets:Array = [];

            for(var i:uint = 0; i < HEIGHTMAP_OCTAVES; i++) {
                offsets.push(new Point(0, offset/(i+1)));
            }
            offset = -getTimer()/100;
            
            heightMap.perlinNoise(SIZE, SIZE, HEIGHTMAP_OCTAVES, 0, true, false, 
                BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE, true,
                offsets);
            texture.perlinNoise(SIZE, SIZE, HEIGHTMAP_OCTAVES, 0, false, false,
                BitmapDataChannel.RED | BitmapDataChannel.GREEN | BitmapDataChannel.BLUE, false,
                offsets);

            tmpBmd1.draw(heightMap)
            tmpBmd1.draw(heightMap, null, null, "screen");
            texture.draw(tmpBmd1, null, null, "multiply");

            heightMapVector = heightMap.getVector(heightMap.rect);
            
            // generate vertices, uvtdata and indices
            i = 0;
            var ii:uint = 0; // indices index
            for(var y:int = 0; y < SIZE; y++) {
                for(var x:int = 0; x < SIZE; x++) {
                    var i1:uint = y*SIZE+x;

                    vertices[i]  = -(x*2-SIZE);
                    uvtData[i++] = x/SIZE;
                    vertices[i]  = ((heightMapVector[i1] & 0xFF) - 0x80) / 0x80 * SIZE;
                    uvtData[i++] = y/SIZE;
                    vertices[i]  = y*2-SIZE;
                    uvtData[i++] = 0;

                    if(x < SIZE-1 && y < SIZE-1) {
                        var i2:uint = i1+SIZE;
                        
                        indices[ii++]=i1;
                        indices[ii++]=i1+1;
                        indices[ii++]=i2;
                        indices[ii++]=i1+1;
                        indices[ii++]=i2+1;
                        indices[ii++]=i2;
                    }
                }
            }
            
            // project
            var m:Matrix3D = new Matrix3D;
            m.appendScale(.6,.4,.6);
            m.appendRotation(38, Vector3D.Z_AXIS);
            m.appendTranslation(0,-SIZE/8,-SIZE*2.3);
            m.append(projection.toMatrix3D());
            Utils3D.projectVectors(m, vertices, projected, uvtData);

            viewport.graphics.clear();
            //viewport.graphics.lineStyle(1, 0, 0.25);
            viewport.graphics.beginBitmapFill(texture, null, false, true);
            viewport.graphics.drawTriangles(projected, indices, uvtData);
            viewport.graphics.endFill();
        }
    }
}