/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fYIy
 */

// forked from sakusan393's Louis Vuitton Facade
package  {
    
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * 青木淳氏のルイヴィトンのファサードパターンっぽく
     */
    public class LouisVuittonFacade extends Sprite {
        
        private var _w:int = 465;
        private var _h:int = 465;
        private var _wall0:Sprite;
        private var _wall1:Sprite;
        private var _count:Number = 0;
        private var _offsetZ:int = -18;
        
        public function LouisVuittonFacade():void {
            var wall0Bmd:BitmapData = createBmd(8, 8, 0xFFffffff);
            var wall1Bmd:BitmapData = createBmd(8, 8, 0xff000000);
            _wall0 = createWall(_w*3, _h*3, wall0Bmd,-_w*1.5,-_h*1.5);
            _wall1 = createWall(_w*3, _h*3, wall1Bmd,-_w*1.5,-_h*1.5);
            addChild(_wall0).z = _offsetZ;
            addChild(_wall1);
            _wall0.x = _wall1.x = _wall0.y = _wall1.y = _w / 2;
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.CLICK, function():void { _offsetZ = Math.random() * 50; trace(_offsetZ) } );
        }
        
        
        private function enterFrameHandler(e:Event):void{
            _count += 0.01;
            _wall0.x = Math.sin(_count/2) * 100 + _w / 2;
            _wall1.x = Math.sin(_count/2) * 50 + _w / 2;
            _wall0.z = (1 - Math.sin(_count)) * 20 + _offsetZ;
            _wall1.z = (1 - Math.sin(_count)) * 20;
            _wall0.rotationY = _wall1.rotationY = Math.sin(_count/1) * 20;
        }
        private function createBmd(w:int, h:int, color:int):BitmapData{
            var bmd:BitmapData = new BitmapData(w, h, true, 0x00000000);
            for (var i:int = 0; i < w; i++){
                for (var ii:int = 0; ii < w; ii++){
                    if ((i < int(w/2) && ii > int(w/2-1)) || (i > int(w/2-1) && ii < int(w/2))){
                        bmd.setPixel32(ii, i, color);
                    }
                }
            }
            return bmd;
        }
        private function createWall(w:int, h:int, bmd:BitmapData, x:int = 0, y:int = 0 ):Sprite{
            var sp:Sprite = new Sprite();
            sp.graphics.beginBitmapFill(bmd);
            sp.graphics.drawRect(x, y, w, h);
            sp.graphics.endFill();
            return sp;
        }
    }
    
}