/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fYIq
 */

// forked from siouxcitizen's forked from: 円グラフとスライドバー
// forked from Nyarineko's 円グラフとスライドバー
// forked from nengafl's nengafl
//
//前回ソースからうさんくさい感じのFacebook連携機能を作成しました
//
//平成23年度予算を(単位：億円)で表示してます
//「FBシェア」ボタン押下でFacebookにパイチャート編集データを投稿します
//パイチャート編集データを「私の平成23年度の予算削減案」といった感じで、FacebookにGETクエリ付きURLとして投稿(シェア)します
//Facebookに投稿されたURLをクリックすると表示用の画面に移動します
//↑スライドバーに値が反映できないといったところなどがまだ中途半端です。。。
//
//最初はツイッターで簡単にできる機能と考えていましたが、文字制限などでできなかったので、
//いろいろ抜け道的な？機能を集めて実装していたらこのような形になりました。。。
//まだ予算データ処理・表示あたりのバグとか残ってそうな気も。。。
//
//以下のソースを参考にさせて頂きました
//URL、パス、FlashVers、クエリの取得をします。
//http://wonderfl.net/c/aAmk/
//flashでソーシャルボタンの実装 on wonderfl build flash online
//http://wonderfl.net/c/ferr
package
{
    import flash.display.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    import flash.utils.escapeMultiByte;
    import flash.text.TextField;

    public class Main extends Sprite {
    
        public var chart:PieChart3D;
        
        private var slider1Min:Number = 0;
        private var slider1Max:Number = 287079; //社会保障
        private var slider2Min:Number = 0;
        private var slider2Max:Number = 167845; //地方交付税交付金
        private var slider3Min:Number = 0;
        private var slider3Max:Number = 55100;  //文教及び科学振興
        private var slider4Min:Number = 0;
        private var slider4Max:Number = 49743;  //公共事業
        private var slider5Min:Number = 0;
        private var slider5Max:Number = 47752;  //防衛
        private var slider6Min:Number = 0;
        private var slider6Max:Number = 101106; //その他
        private var slider7Min:Number = 0;
        private var slider7Max:Number = 115903; //債務償還日
        private var slider8Min:Number = 0;
        private var slider8Max:Number = 99588;  //利払費等

        public var RAD:Number = 130;
        
        private var slider1:slider = new slider("A",180, 20, slider1Max, slider1Min, stage); //社会保障
        private var slider2:slider = new slider("B",180, 20, slider2Max, slider2Min, stage); //地方交付税交付金
        private var slider3:slider = new slider("C",180, 20, slider3Max, slider3Min, stage); //文教及び科学振興
        private var slider4:slider = new slider("D",180, 20, slider4Max, slider4Min, stage); //公共事業
        private var slider5:slider = new slider("E",180, 20, slider5Max, slider5Min, stage); //防衛
        private var slider6:slider = new slider("F",180, 20, slider6Max, slider6Min, stage); //その他
        private var slider7:slider = new slider("G",180, 20, slider7Max, slider7Min, stage); //債務償還日
        private var slider8:slider = new slider("H",180, 20, slider8Max, slider8Min, stage); //利払費等

        private var _tweetBtn : CustomButton;    //「FBシェア」ボタン
        private var _isDefaultParam : Boolean = true;    //デフォルトのスライドバー設定か(GETクエリが存在しないか)
        private var _sliderPositionList : Array = new Array(); //GETクエリから取り出した値をsliderの値として設定する

        public function Main(){
            checkAccessURL();
            stage.scaleMode = "noScale";
            
            addChild(slider1); //社会保障
            slider1.addEventListener(slider.SLIDE, calc);
            slider1.x = 40;
            slider1.y = 20;
            
            addChild(slider2); //地方交付税交付金
            slider2.addEventListener(slider.SLIDE, calc);
            slider2.x = 40;
            slider2.y = 45;
            
            addChild(slider3); //文教及び科学振興
            slider3.addEventListener(slider.SLIDE, calc);
            slider3.x = 40;
            slider3.y = 70;
            
            addChild(slider4); //公共事業
            slider4.addEventListener(slider.SLIDE, calc);
            slider4.x = 40;
            slider4.y = 95;
            
            addChild(slider5); //防衛
            slider5.addEventListener(slider.SLIDE, calc);
            slider5.x = 260;
            slider5.y = 20;

            addChild(slider6); //その他
            slider6.addEventListener(slider.SLIDE, calc);
            slider6.x = 260;
            slider6.y = 45;

            addChild(slider7); //債務償還日
            slider7.addEventListener(slider.SLIDE, calc);
            slider7.x = 260;
            slider7.y = 70;

            addChild(slider8); //利払費等
            slider8.addEventListener(slider.SLIDE, calc);
            slider8.x = 260;
            slider8.y = 95;

            slider1.scalePosition = 1.0; //社会保障
            slider2.scalePosition = 1.0; //地方交付税交付金
            slider3.scalePosition = 1.0; //文教及び科学振興
            slider4.scalePosition = 1.0; //公共事業
            slider5.scalePosition = 1.0; //防衛
            slider6.scalePosition = 1.0; //その他
            slider7.scalePosition = 1.0; //債務償還日
            slider8.scalePosition = 1.0; //利払費等

            chart = new PieChart3D();
            chart.x = 465 / 2;
            chart.y = 280;
            chart.pieRadius = RAD;
            if (_isDefaultParam) { //URLのGETクエリに値がセットされていない場合(デフォルト値設定)
                chart.addData( new PieChartData( "社会保障", slider1.position ) );
                chart.addData( new PieChartData( "地方交付税交付金等", slider2.position ) );
                chart.addData( new PieChartData( "文教及び科学振興", slider3.position ) );
                chart.addData( new PieChartData( "公共事業", slider4.position ) );
                chart.addData( new PieChartData( "防衛", slider5.position ) );
                chart.addData( new PieChartData( "その他", slider6.position ) );
                chart.addData( new PieChartData( "債務償還費", slider7.position ) );
                chart.addData( new PieChartData( "利払費等", slider8.position ) );
            } else { //URLのGETクエリに値がセットされて渡されてきた場合(必要の場合は最小値と最大値の範囲内に修正)
                chart.addData( new PieChartData( "社会保障", 
                ((_sliderPositionList[0]<slider1Min || _sliderPositionList[0]>slider1Max ) ? slider1Max:_sliderPositionList[0])
                ));
                chart.addData( new PieChartData( "地方交付税交付金等", 
                ((_sliderPositionList[1]<slider2Min || _sliderPositionList[1]>slider2Max ) ? slider2Max:_sliderPositionList[1])
                ));
                chart.addData( new PieChartData( "文教及び科学振興", 
                ((_sliderPositionList[2]<slider3Min || _sliderPositionList[2]>slider3Max ) ? slider3Max:_sliderPositionList[2])
                ));
                chart.addData( new PieChartData( "公共事業", 
                ((_sliderPositionList[3]<slider4Min || _sliderPositionList[3]>slider4Max ) ? slider4Max:_sliderPositionList[3])
                ));
                chart.addData( new PieChartData( "防衛", 
                ((_sliderPositionList[4]<slider5Min || _sliderPositionList[4]>slider5Max ) ? slider5Max:_sliderPositionList[4])
                ));
                chart.addData( new PieChartData( "その他", 
                ((_sliderPositionList[5]<slider6Min || _sliderPositionList[5]>slider6Max ) ? slider6Max:_sliderPositionList[5])
                ));
                chart.addData( new PieChartData( "債務償還費", 
                ((_sliderPositionList[6]<slider7Min || _sliderPositionList[6]>slider7Max ) ? slider7Max:_sliderPositionList[6])
                ));
                chart.addData( new PieChartData( "利払費等", 
                ((_sliderPositionList[7]<slider8Min || _sliderPositionList[7]>slider8Max ) ? slider8Max:_sliderPositionList[7])
                ));
            }
            chart.startDraw();
            addChild(chart);

            //「FBシェア」ボタン表示
            _tweetBtn = new CustomButton("FBシェア");
            _tweetBtn.x = 5;
            _tweetBtn.y = 400;
            _tweetBtn.addEventListener(MouseEvent.MOUSE_DOWN,onTweetBtnDown);
            addChild(_tweetBtn);
        }
        
        private function calc(e:Event = null):void {
            if(!(slider1.position == 0 && slider2.position == 0 && slider3.position == 0 && slider4.position == 0
                 && slider5.position == 0 && slider6.position == 0 && slider7.position == 0 && slider8.position == 0)){
                removeChild(chart);
                chart = new PieChart3D();
                chart.x = 465 / 2;
                chart.y = 280;
                chart.pieRadius = RAD;
                chart.addData( new PieChartData( "社会保障", slider1.position ) );
                chart.addData( new PieChartData( "地方交付税交付金等", slider2.position ) );
                chart.addData( new PieChartData( "文教及び科学振興", slider3.position ) );
                chart.addData( new PieChartData( "公共事業", slider4.position ) );
                chart.addData( new PieChartData( "防衛", slider5.position ) );
                chart.addData( new PieChartData( "その他", slider6.position ) );
                chart.addData( new PieChartData( "債務償還費", slider7.position ) );
                chart.addData( new PieChartData( "利払費等", slider8.position ) );
                chart.startDraw();
                addChild(chart);
            }
        }
        /**-----------------------------------------------------
         * アクセスしてきたURLのチェックを行う。
         * ----------------------------------------------------- */
        private function checkAccessURL():void {

            var queryString : String = stage.loaderInfo.parameters.getquery;
            //GETクエリが存在する場合
            var urlString : String = stage.loaderInfo.url;
            //addText("アクセス元URLは：　" + stage.loaderInfo.url);
            queryString = urlString.slice(urlString.search("A="), urlString.length);
            //addText("クエリは：　" + queryString, 0, 50);

            if (queryString != null) { //GETクエリから取り出した値をsliderの値として設定する
                 var queryList : Array = queryString.split("&"); //「&」で切り分けてGETクエリを取り出す

                 if (queryList.length != 8 ) {  //パラメータの数がおかしいのでデフォルト設定
                     _isDefaultParam = true;
                     //addText("クエリ数がおかしい", 0, 75);
                     return;
                 }

                 for (var i : int = 0; i < queryList.length; i++) { //クエリ毎の処理を行う
                     var queryUnit : String = queryList[i];
                     var query : String = queryUnit.substr(2, (queryUnit.length-2)); //　例：「A=287079」→「287079」
                     //var query : String = queryUnit.substring(2, (queryUnit.length-1)); //　例：「A=287079」→「287079」

                     if (query == null || isNaN(new Number(query))) { //クエリの値が存在しない場合やNumber型でない場合は0を設定
                         _sliderPositionList.push(new Number(0));
                         //addText("クエリ" + i + "は：" + query, 0, 75+20*i);
                     } else {
                         _sliderPositionList.push(new Number(query)); //GETクエリから取り出した値をsliderの値として設定する
                         //addText("クエリ" + i + "は：" + query, 0, 75+20*i);
                     }
                     
                     _isDefaultParam = false;
                 }
            } else { //GETクエリが存在しない場合
                //GETクエリが存在しないのでデフォルト設定
                _isDefaultParam = true;
            }
            
        }
        /**-----------------------------------------------------
         * 「ツイート」ボタン処理を行う。
         * ----------------------------------------------------- */
        private function onTweetBtnDown(e:MouseEvent):void {
            //var postMessage:String = "私の平成23年度の予算削減案:"; 
            //stage.loaderInfo.url 　または　stage.loaderInfo.loaderURL　よりURLを取得する？(どちらも同じ機能？)
            var post:String = stage.loaderInfo.url  
                            + "&" + "A=" + slider1.position
                            + "&" + "B=" + slider2.position
                            + "&" + "C=" + slider3.position
                            + "&" + "D=" + slider4.position
                            + "&" + "E=" + slider5.position
                            + "&" + "F=" + slider6.position
                            + "&" + "G=" + slider7.position
                            + "&" + "H=" + slider8.position;
            //navigateToURL(new URLRequest("http://twitter.com/home?status=" + escapeMultiByte(post)), "_blank");
            navigateToURL(new URLRequest("http://www.facebook.com/sharer.php?u=" + escapeMultiByte(post)), "_blank");
        }
        /**-----------------------------------------------------
         * デバッグ用
         * ----------------------------------------------------- */
        private function addText(text:String, x:int = 0, y:int = 0):void {
            var textField:TextField = new TextField();
            textField.text = text;
            textField.width = stage.stageWidth;
            textField.height = stage.stageHeight;
            textField.multiline = true;
            textField.wordWrap = true;
            textField.x = x;
            textField.y = y;
            this.addChild(textField);
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Matrix;
class PieChart3D extends Sprite {
    
    private static const PI2:Number = 0.01746;
    
    public static var S:int = 1;
    public static var V:int = 1;
    
    public var data:Array;
    public var sum:Number;
    
    // グラフの半径
    public var pieRadius:Number;
    // グラフの高さ
    public var pieHeight:Number = 20;
    // グラフの傾き
    public var pieGradientAngle:Number = 80;
    
    private var _currentIndex:Number;
    private var _currentAngle:Number;
    
    private var _pies:Array;
    
    public function get numData():int { return data.length; }
    
    public function PieChart3D():void {
        data = [];
    }
    
    public function addData(data:PieChartData):PieChartData {
        this.data.push(data);
        return data;
    }
    
    public function getDataAt(index:int):PieChartData {
        return data[index] as PieChartData;
    }
    
    public function getPieAt(index:int):Sprite {
        return _pies[index] as Sprite;
    }
    
    public function startDraw():void {
        while (numChildren) { removeChildAt(numChildren-1); }
        // 初期設定
        _pies = [];
        _initialize();
        _currentAngle = 
        _currentIndex = 0;
        _draw();
    }
    
    private function _draw():void {
        _currentAngle++;
        var pie:Sprite = getPieAt(_currentIndex);
        if (!pie) { return; }
        pie.graphics.clear();
        
        var d:PieChartData = getDataAt(_currentIndex);
        if ( _currentAngle > d.endAngle) { _currentAngle = d.endAngle; }
        var a:Number, b:Number;
        var kh:Number = pieGradientAngle / 90;
        
        var ang:Number, sep:Number, sepang:Number, r:Number, rs:Number, re:Number,rt:Number, i:int;
        
        // 外壁
        if (_currentAngle > 90 && ((d.startAngle < 180 && d.endAngle >= 90) || (d.endAngle >= 90 && d.startAngle < 270))) {
            var colors:Array = [d.color1, d.color2];
            var alphas:Array = [100, 100];
            var ratios:Array = [0, 0xFF];
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(pieRadius * 2, pieRadius * 2, 0, pieRadius, pieRadius * kh);
            pie.graphics.beginGradientFill("linear", colors, alphas, ratios, matrix);
            var startAngle:Number = Math.max(d.startAngle, 90);
            var endAngle:Number = Math.min(_currentAngle, 270);
            ang = endAngle - startAngle;
            sep = Math.ceil(ang / 30);
            sepang = ang / sep;
            r = pieRadius / Math.cos(sepang / 2 * PI2);
            pie.graphics.moveTo(_getX(startAngle) * pieRadius, _getY(startAngle) * pieRadius * kh);
            for ( i = 0; i < sep; i++ ) {
                pie.graphics.lineTo(_getX(startAngle + sepang * i) * pieRadius, _getY(startAngle + sepang * i) * pieRadius * kh + pieHeight);
                pie.graphics.curveTo(_getX(startAngle + sepang * i + sepang / 2) * r, _getY(startAngle + sepang * i + sepang / 2) * r * kh + pieHeight, _getX(startAngle + sepang * (i + 1)) * pieRadius, _getY(startAngle + sepang * (i + 1)) * pieRadius * kh + pieHeight);
                pie.graphics.lineTo(0, 0);
            }
            pie.graphics.lineTo(_getX(endAngle) * pieRadius, _getY(endAngle) * pieRadius * kh + pieHeight);
            pie.graphics.lineTo(_getX(endAngle) * pieRadius, _getY(endAngle) * pieRadius * kh);
            pie.graphics.endFill();
        }
        
        // 上面
        ang = _currentAngle - d.startAngle;
        sep = Math.ceil(ang / 30);
        sepang = ang / sep;
        r = pieRadius / Math.cos(sepang / 2 * PI2);
        pie.graphics.beginFill(d.color);
        for (i = 0; i < sep; i++) {
            pie.graphics.moveTo(0, 0);
            pie.graphics.lineTo(_getX(d.startAngle + sepang * i) * pieRadius, _getY(d.startAngle + sepang * i) * pieRadius * kh);
            pie.graphics.curveTo(_getX(d.startAngle + sepang * i + sepang / 2) * r, _getY(d.startAngle + sepang * i + sepang / 2) * r * kh, _getX(d.startAngle + sepang * (i + 1)) * pieRadius, _getY(d.startAngle + sepang * (i + 1)) * pieRadius * kh);
            pie.graphics.lineTo(0, 0);
        }
        pie.graphics.endFill();
        
        if(Math.floor(_currentAngle) == (Math.floor(d.startAngle + (d.endAngle-d.startAngle)/2))){
            trace(_currentAngle);
            rs = (pieRadius - 5) / Math.cos(sepang / 2 * PI2);
            re = (pieRadius + 30) / Math.cos(sepang / 2 * PI2);
            rt = (pieRadius + 40) / Math.cos(sepang / 2 * PI2);
            var pie2:Sprite = new Sprite();
            pie2.graphics.lineStyle (1,0x000000,1,true,"none","none","miter");
            pie2.graphics.moveTo(_getX(d.startAngle + sepang * i + sepang / 2) * rs, _getY(d.startAngle + sepang * i + sepang / 2) * rs * kh);
            pie2.graphics.lineTo(_getX(d.startAngle + sepang * i + sepang / 2) * re, _getY(d.startAngle + sepang * i + sepang / 2) * re * kh);
            
            
            var txt:TextField = new TextField();
            txt.defaultTextFormat = new TextFormat(null, null, 0x000000);
            txt.text = d.name + "：" + d.value.toString();
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.selectable = false;
            txt.x = _getX(d.startAngle + sepang * i + sepang / 2) * rt - 7;
            txt.y = _getY(d.startAngle + sepang * i + sepang / 2) * rt * kh - 7;
            
            pie2.graphics.beginFill(0xFFFFFF, 1);
            pie2.graphics.drawRoundRect(txt.x - 1, txt.y - 1, txt.width +2, txt.height, 10);
            pie2.graphics.endFill();
            
            addChild(pie2);
            addChild(txt);
        }
        
        if (_currentAngle >= d.endAngle) {
            _currentIndex++;
            if (_currentIndex >= numData) {
                //
            }else{
                _draw();
            }
        }else{
            _draw();
        }
    }
    
    private function _getX(angle:Number):Number { return Math.cos((angle - 90) * PI2); }
    private function _getY(angle:Number):Number { return Math.sin((angle - 90) * PI2); }
    
    private function _initialize():void {
        // 合計
        sum = 0;
        data.forEach(function(item:*, index:int, arr:Array):void { sum += item.value; } );
        // 多い順にソート
        //data.sortOn("value", Array.DESCENDING | Array.NUMERIC);
        var angle:Number = 0;
        var swapArr:Array = [];
        for (var i:int = 0, l:int = numData; i < l; i++)  {
            var d:PieChartData = data[i];
            // 角度
            d.startAngle = angle;
            d.endAngle = angle + d.value / sum * 360;
            var argAngle:Number = (d.endAngle - d.startAngle) / 2 + d.startAngle
            swapArr.push({ index:i, lebel:argAngle > 180 ? 360 - argAngle : argAngle });
            // 色
            var c:int = d.color = angle2RGB(i * 360 / l);
            var r1:int = Math.max(0, ((c >> 16) - 0x22));
            var r2:int = Math.max(0, ((c >> 16) - 0x44));
            c %= 0x10000;
            var g1:int = Math.max(0, ((c >> 8) - 0x22));
            var g2:int = Math.max(0, ((c >> 8) - 0x44));
            c %= 0x100;
            var b1:int = Math.max(0, (c - 0x22));
            var b2:int = Math.max(0, (c - 0x44));
            d.color1 = r1 << 16 | g1 << 8 | b1;
            d.color2 = r2 << 16 | g2 << 8 | b2;
            angle = d.endAngle;
        }
        // 表示順のZソートして Sprite 作成
        swapArr.sortOn("lebel", Array.NUMERIC);
        swapArr.forEach(function(item:*, index:int, arr:Array):void {
            var pie:Sprite = new Sprite();
            addChild(pie);
            _pies[item["index"]] = pie;
        });
    }
    
    private function angle2RGB(angle:Number):uint {
        if ( angle < 0 ) { angle += 360; }
        angle %= 360;
        var h:int = Math.floor( angle / 60 );
        var f:Number = angle / 60 - h;
        var min:int = 0;
        var max:int = 0xFF;
        var u:int = min + ( f * max );
        var d:int = max - ( f * max );
        var r:int, g:int, b:int;
        switch (h) {
            case 0 : { r = max; g = u;   b = min; break; }
            case 1 : { r = d;   g = max; b = min; break; }
            case 2 : { r = min; g = max; b = u;   break; }
            case 3 : { r = min; g = d;   b = max; break; }
            case 4 : { r = u;   g = min; b = max; break; }
            case 5 : { r = max; g = min; b = d;   break; }
        }
        return r << 16 | g << 8 | b;
    }
    
}

class PieChartData {
    public var name:String;
    public var value:Number;
    public var color:int;
    public var color1:int;
    public var color2:int;
    public var startAngle:Number;
    public var endAngle:Number;
    public var lebel:int;
    
    public function PieChartData(name:String, value:Number) {
        this.name = name;
        this.value = value;
    }
}


import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.geom.Rectangle;
internal class slider extends Sprite {
    
    public static const SLIDE:String = "slide";
    
    private var _drag:Boolean = false;
    private var _rollOverFlag:Boolean = false;
    
    private var _w:Number;
    private var _h:Number;
    
    private var _position:Number;
    private var _scalePosition:Number;
    private var _positionMax:Number;
    private var _positionMin:Number;
    
    private    var sliderA:Sprite = new Sprite();
    private var sliderB:Sprite = new Sprite();
    private var toolTip:Sprite = new Sprite();
    private var toolTipBG:Sprite = new Sprite();
    private var toolTipTxt:TextField = new TextField();
    
    public function slider(slide:String, w:Number, h:Number, max:Number, min:Number, dObj:DisplayObject) {
        _w = w;
        _h = h;
        _positionMax = max;
        _positionMin = min;
        
        //スライダーの溝を描画
        sliderA.graphics.lineStyle(2, 0x555555);
        sliderA.graphics.moveTo(0, _h / 2);
        sliderA.graphics.lineTo(_w, _h / 2);
        
        addChild(sliderA);
        
        var txt:TextField = new TextField();
        txt.defaultTextFormat = new TextFormat(null, null, 0x333333);
        txt.text = slide;
        txt.autoSize = TextFieldAutoSize.LEFT;
        txt.selectable = false;
        txt.x = -25;
        txt.y = 0;
        addChild(txt);
        
        //パラメータの最大値最小値を書いておく
        var txt1:TextField = new TextField();
        txt1.defaultTextFormat = new TextFormat(null, null, 0xAAAAAA);
        txt1.text = _positionMax.toString();
        txt1.autoSize = TextFieldAutoSize.LEFT;
        txt1.selectable = false;
        txt1.x = _w - txt1.width / 2;
        txt1.y = _h / 2;
        addChild(txt1);
        
        var txt2:TextField = new TextField();
        txt2.defaultTextFormat = new TextFormat(null, null, 0xAAAAAA);
        txt2.text = _positionMin.toString();
        txt2.autoSize = TextFieldAutoSize.LEFT;
        txt2.selectable = false;
        txt2.x = -txt1.width / 2;
        txt2.y = _h / 2;
        addChild(txt2);
        
        //スライダーのツマミを描画
        sliderB.graphics.beginFill(0x000000);
        sliderB.graphics.drawRoundRect(-5, 0, 10, h, 5);
        sliderB.graphics.endFill();
        sliderB.buttonMode = true;
        
        addChild(sliderB);
        
        //ツールチップを描画
        var tf:TextFormat = new TextFormat();
        tf.color = 0xFFFFFF;
        tf.leftMargin = 5;
        tf.rightMargin = 5;
        toolTipTxt.defaultTextFormat = tf;
        toolTipTxt.autoSize = TextFieldAutoSize.LEFT;
        toolTipTxt.selectable = false;
        
        toolTip.addChild(toolTipBG);
        toolTip.addChild(toolTipTxt);
        addChild(toolTip);
        toolTip.visible = false;
        
        //addEventListener
        sliderB.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownHandler);
        dObj.addEventListener(MouseEvent.MOUSE_UP, onMouseUpHandler);
        dObj.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMoveHandler);
        sliderB.addEventListener(MouseEvent.MOUSE_OVER, onMouseOverHandler);
        sliderB.addEventListener(MouseEvent.MOUSE_OUT, onMouseOutHandler);
        
        _scalePosition = this.scalePosition;
        _position = this.position;
    }
    private function onMouseMoveHandler(e:MouseEvent = null):void 
    {        
        if (_drag) {
            _scalePosition = this.scalePosition;
            _position = this.position;
            dispatchEvent(new Event(SLIDE));
        }
        
        if (_rollOverFlag) showPosition(new Point(e.stageX, e.stageY));
    }
    private function onMouseDownHandler(e:MouseEvent):void 
    {
        _drag = true;
        e.target.startDrag(false,new Rectangle(0,0,_w,0));
    }
    private function onMouseUpHandler(e:MouseEvent):void 
    {
        _drag = false;
        _rollOverFlag = false;
        toolTip.visible = false;
        sliderB.stopDrag();
    }
    private function onMouseOverHandler(e:MouseEvent):void 
    {
        _rollOverFlag = true;
        toolTip.visible = true;
        
        showPosition(new Point(e.stageX, e.stageY));
    }
    private function showPosition(arg1:Point):void 
    {
        var pt:Point = globalToLocal(arg1);
        
        toolTip.x = pt.x + 15;
        toolTip.y = pt.y;
        
        toolTipTxt.text = "value = " + _position;
        toolTipBG.graphics.clear();
        toolTipBG.graphics.beginFill(0x000000, .5);
        toolTipBG.graphics.drawRoundRect(0, -5, toolTipTxt.width, toolTipTxt.height+10, 10);
        toolTipBG.graphics.endFill();
    }
    private function onMouseOutHandler(e:MouseEvent):void 
    {
        if (!_drag) {
            _rollOverFlag = false;
            toolTip.visible = false;
        }
    }
    //get/set
    public function get position():Number {
        _scalePosition = this.scalePosition;
        return Math.floor((_positionMax - _positionMin) * _scalePosition + _positionMin);
    }
    public function set position(pos:Number):void {
        _position = pos;
        _scalePosition = (_position - _positionMin) / (_positionMax - _positionMin);
        sliderB.x = _w * _scalePosition;
    }
    public function get scalePosition():Number {
        _scalePosition = sliderB.x / _w;
        return _scalePosition;
    }
    public function set scalePosition(posScale:Number):void {
        _scalePosition = posScale;
        _position = (_positionMax - _positionMin) * _scalePosition + _positionMin;
        sliderB.x = _w * _scalePosition;
    }
}

import flash.display.*;
import flash.system.*;
import flash.text.*;

/**-----------------------------------------------------
 * カスタムボタン。
 * ----------------------------------------------------- */
class CustomButton extends SimpleButton {
    private var btnName : String = "";//ボタン名
    private var btnNo : int = 0;//ボタン番号
    /**-----------------------------------------------------
     * コンストラクタ。
     * ----------------------------------------------------- */
    public function CustomButton(label:String="",no:int=0) {
        btnName = label;
        btnNo = no;
        //状態
        //upState = makeSprite(label,0x00FF00);
        upState = makeSprite(label,0x99DDFF);
        overState = upState;
        downState = makeSprite(label,0x0000FF);
        hitTestState = upState;
    }
    public function getBtnName():String {
        return btnName;
    }
    public function getBtnNo():int {
        return btnNo;
    }
    /**-----------------------------------------------------
     * ボタン用スプライト作成。
     * ----------------------------------------------------- */
    private function makeSprite(text:String,color:uint):Sprite{
        //ボタン用ラベル作成
        var label : TextField = new TextField();
        label.text = text;
        label.autoSize = TextFieldAutoSize.CENTER;
        label.selectable = false;
        //ボタン用スプライト作成
        var sp:Sprite = new Sprite();
        sp.graphics.beginFill(color);
        sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
        sp.graphics.endFill();
        sp.alpha = 0.8;            
        sp.addChild(label);
        //ラベル用フォーマット設定
        var format:TextFormat=new TextFormat();
        format.font = "Courier New";
        format.bold = true;
        format.size = 13;
        label.setTextFormat(format);
        return sp;
    }
}