/**
 * Copyright sw_lucchini ( http://wonderfl.net/user/sw_lucchini )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fXv6
 */

// forked from sw_lucchini's forked from: [PV3D] Field of Blur
// forked from clockmaker's [PV3D] Field of Blur
/**
* Papervision3Dで被写界深度
* 参照： http://clockmaker.jp/blog/2008/07/pv3d_gw_blur/
*/
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	
	import caurina.transitions.Tweener;
	
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*
	import org.papervision3d.core.effects.view.ReflectionView;
	
        [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#000000")]
	
	public class Main extends ReflectionView 
	{	
		// const vars
		static private const OBJ_LENGTH   :int = 20;
		static private const CIRCLE_RANGE :int = 500;
		
		// 3d vars
		private var list :Array = []
		private var wrap :DisplayObject3D;
		
		private var num:int;
		private var rot:Number;

		/**
		 * Constructor
		 */
		public function Main()
		{
			//camera
			camera.x         = 0;
			camera.y         = 0;
			camera.z         = 1000;
			camera.rotationX = 5;
			
			surfaceHeight = -100;
			viewportReflection.alpha = 0.7;
			viewportReflection.filters = [new BlurFilter(8, 8, 3)];
			
			// wrap
			wrap = new DisplayObject3D();
			scene.addChild(wrap);
			
			for (var i:int = 0; i < OBJ_LENGTH; i++)
			{
				var rot:Number = 360 * i / OBJ_LENGTH ;
				
				var m:ColorMaterial = new ColorMaterial(0x0066CC);
				m.doubleSided = true;
				
				var o:Plane = new Plane(m, 100, 100);
				o.x = CIRCLE_RANGE * Math.sin(rot * Math.PI / 180);
				o.y = 0;
				o.z = CIRCLE_RANGE * Math.cos(rot * Math.PI / 180);
				o.rotationY = rot;
				o.useOwnContainer = true; //ココ重要
				
                                // 配列に追加　＆　wrapの子供にする
				list.push(wrap.addChild(o));
			}
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyHandler);
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function KeyHandler(e:KeyboardEvent):void
		{
			switch(e.keyCode){
				case 37:
				rot = ++num * 360 / OBJ_LENGTH;
				Tweener.addTween(wrap,{
					rotationY:  rot,
					time:	    1,
					transition: "liner"
				});
				break;
				case 39:
				rot = --num * 360 / OBJ_LENGTH;
				Tweener.addTween(wrap,{
					rotationY:  rot,
					time:	    1,
					transition: "liner"
				});
				break;
			}
		}
		
        // loop
		private function loop(event:Event):void
		{
			singleRender();
                        
                        // 被写界深度
			for (var i:int = 0; i < list.length; i++)
			{
				var o:DisplayObject3D = list[i] as DisplayObject3D;
				var blur:Number = Math.ceil((CIRCLE_RANGE - o.sceneZ) / 50); 
				o.filters = [new BlurFilter(blur, blur, 2)];
			}
		}
	}
}