/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fXt6
 */

package {
    import flash.display.Sprite;
    import flash.filters.*;
    import flash.text.*;
    import flash.geom.*;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    public class Shadow extends Sprite {
        private static const TEXT : String = "('A`)";
        private var _bmdshadow : BitmapData;
        private var _ct : int = 0;
        private var _seed : int = getTimer();
        
        private var _gray : BitmapData;
        
        private var _perlin : BitmapData;
        private var _bmd : BitmapData;
        
        public function Shadow() {
            // write as3 code here..
            _bmd = drawText(TEXT);
            var bmp : Bitmap = new Bitmap(_bmd);
            bmp.x = 50;
            addChild(bmp);
            
            _gray = new BitmapData(_bmd.width, _bmd.height, true);
            _gray.draw(_bmd, new Matrix(1, 0, 0, -1, 0, _bmd.height));
            _gray.threshold(_gray, _gray.rect, new Point(0, 0), "<=", 0x000000, 0xff999999, 0xffffff, true);
            _gray.threshold(_gray, _gray.rect, new Point(0, 0), "==", 0xffffffff, 0x00ffffff, 0xffffffff, true);
            
            _bmdshadow = new BitmapData(_bmd.width, _bmd.height, true);
            var bmpshadow : Bitmap = new Bitmap(_bmdshadow);
            bmpshadow.x = 50;
            bmpshadow.y = _bmd.height - 17;
            bmpshadow.rotationX = -30;
            bmpshadow.rotationY = 0;
            addChild(bmpshadow);
            
            _perlin = new BitmapData(_bmd.width, _bmd.height, false);
//            var bmpperlin : Bitmap = new Bitmap(perlin);
//            addChild(bmpperlin);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e : Event) : void
        {
            _ct++;
            _perlin.perlinNoise(_bmd.width, _bmd.height, 2, _seed, true, false, 7, false, [new Point(6 * _ct, -6 * _ct)]);
            var dmf : DisplacementMapFilter = new DisplacementMapFilter(_perlin, null, 1, 2, 50, 50, "clamp");
            _bmdshadow.copyPixels(_gray, _gray.rect, new Point(0, 0));
/*
            _bmdshadow.lock();
            _bmdshadow.fillRect(_bmdshadow.rect, 0xffffffff);
            _bmdshadow.applyFilter(_gray, new Rectangle(0, 0, _gray.width, _gray.height), new Point(0, 0), dmf);
            _bmdshadow.unlock();
            */
        }
        
        private function drawText(text : String) : BitmapData
        {
            var tf : TextField = new TextField();
            tf.defaultTextFormat = new TextFormat("arial", 100);
            tf.autoSize = "left";
            tf.appendText(text);
//            addChild(tf);
            var recter : BitmapData = new BitmapData(tf.width * 2, tf.height * 2, true);
//            recter.draw(tf);
            recter.draw(tf, new Matrix(2, 0, 0, 2, -2, -2));
            
            var rect : Rectangle = recter.getColorBoundsRect(0xffffff, 0x000000, false);
            var ret : BitmapData = new BitmapData(rect.width, rect.height, true);
            ret.draw(recter, new Matrix(1, 0, 0, 1, -rect.x, -rect.y));
                
            recter.dispose();
            return ret;
        }
    }
}