/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fWOa
 */

/**
 * Copyright matsu4512 ( http://wonderfl.net/user/matsu4512 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ftGu
 */

/*
Full Screenで見ると見やすいかと思います。
3D酔いには注意！
*/

package {
	import __AS3__.vec.Vector;
	
	import com.bit101.components.Label;
	
	import flash.events.Event;
	import flash.filters.*;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	
	import frocessing.color.ColorHSV;
	
	import org.papervision3d.cameras.*;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
	public class Sound3D extends BasicView
	{
		//カメラが追う球
		private var sphere:Sphere;
		private var do3d:DisplayObject3D;
		//描く線
		private var line:Lines3D;
		//ここを変更すると描かれる線が変わる
		private const A:Number = 10.0, B:Number = 25.0, C:Number = 8.0/3.0, D:Number = 0.01;
		//向かう座標
		private var xx:Number, yy:Number, zz:Number;
		//HSV->RGB変換用の変数
		private var hsv:ColorHSV;
		private var glow:GlowFilter;
		//Planeを格納するためのVector
		private var particles:Vector.<Plane>;
		
		private var mySound:Sound;
		
		//Loadig表示
		private var _loading:Label;
		
		public function Sound3D()
		{
			super(465, 465, true, false, CameraType.SPRING);
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_loading = new Label(this, 466/2, 466/2, "Loading...");
			
			/*..............sound..................*/
			//サウンドの作成
			mySound = new Sound();
			mySound.load(new URLRequest("http://swimmingbird.heteml.jp/as3/1004/sound1/data/digitallove.mp3"));
        	mySound.addEventListener(Event.COMPLETE, init);
		}
		
		public function init(e:Event):void {
			removeChild(_loading);
			Wonderfl.capture_delay( 30 );
			//初期化
			hsv = new ColorHSV(0, 1, 1);
			glow = new GlowFilter(0, 1, 8, 8, 2);
			particles = new Vector.<Plane>();
			xx = yy = zz = 1;
			
			//球の生成
			sphere = new Sphere(new ColorMaterial(0xffffff), 3);
			sphere.x = sphere.y = sphere.z = 1;
			scene.addChild(sphere);
			//カメラが追いかけるポイントを作成
			do3d = new DisplayObject3D();
			do3d.x = do3d.y = do3d.z = 1;
			scene.addChild(do3d);
			//フィルターを有効にする
			sphere.useOwnContainer = true;
			sphere.filters = [new BlurFilter(8,8,4), glow];
			//カメラが追うものをポイントに設定
			camera.target = do3d;
			//各パラメータの設定
			SpringCamera3D(camera).mass = 20;
			SpringCamera3D(camera).damping = 30;
			SpringCamera3D(camera).stiffness = 1;
			
			line = new Lines3D(null);
			scene.addChild(line);
			startRendering();
			
			/*..............sound..................*/
            var channel:SoundChannel = new SoundChannel();
            channel = mySound.play();
            var trans:SoundTransform = channel.soundTransform;
            trans.volume = 0.3;
            channel.soundTransform = trans;
			addEventListener(Event.ENTER_FRAME, onFrame);
		}
		
		private var isHigh:int = 0;
		private function onFrame(event:Event):void{
			/*..............sound..................*/
			var bytes:ByteArray = new ByteArray();
			
			try{
		        SoundMixer.computeSpectrum(bytes, false, 0);
		    }
		    catch(e:SecurityError){
		        trace(e.toString());
		    }

            bytes.position = 0;
            var rf:Number;
			var count:int = 0;
            for (var q:int = 0; bytes.bytesAvailable >= 4; q++) {
				rf = bytes.readFloat();
				var t:Number = Math.abs(rf);
				if (t >= 0.18 && q >256) {
					count ++;
				}
				if (count >= 120) {
					isHigh = 1;
				} else {
					isHigh = 0;
				}
			}
			//from
			var preX:Number = sphere.x;
			var preY:Number = sphere.y;
			var preZ:Number = sphere.z;
			//進む距離
			var dx:Number, dy:Number, dz:Number;
			dx = A*(yy-xx);
			dy = xx * (B - zz) - yy;
			dz = xx * yy - C * zz;
			//to
			xx += D*dx;
			yy += D*dy;
			zz += D*dz;
			
			sphere.x = xx*10;
			sphere.y = yy*2+count/10;
			sphere.z = zz*10;
			do3d.x = xx*10;
			do3d.y = yy*2;
			do3d.z = zz*10;
			
			//線を描画
			line.addNewLine(2, preX, preY, preZ, sphere.x, sphere.y, sphere.z);
			
			//HSV->RGBの変換
			var color:uint = hsv.toRGB().value;
			//glowフィルターの色変更
			glow.color = color;
			//線の色を変更
			(line.lines[line.lines.length-1] as Line3D).material = new LineMaterial(color);
			
			//球から出るパーティクルの生成
			for(var j:int = 0; j < 3; j++){
				var mat:ColorMaterial = new ColorMaterial(color);
				mat.doubleSided = true;
				var p:Plane = new Plane(mat, 1, 1);
				p.x = sphere.x;
				p.y = sphere.y;
				p.z = sphere.z;
				p.useOwnContainer = true;
				p.filters = [new BlurFilter(4,4,2)];
				p.extra = {vx:Math.random()*6-3, vy:Math.random()*6-3, vz:Math.random()*6-3};
				scene.addChild(p);
				particles.push(p);
			}
			var i:int = particles.length;
			//パーティクルの管理
			while(i--){
				p = particles[i];
				p.x += p.extra.vx;
				p.y += p.extra.vy;
				p.z += p.extra.vz;
				p.material.fillAlpha -= 0.05;
				if(p.material.fillAlpha <= 0){
					particles.splice(i,1);
					scene.removeChild(p);
				}
			}
			
			i = line.lines.length;
			//線を徐々に透明にしていく
			while(i--){
				var l:Line3D = line.lines[i];
				l.material.lineAlpha -= 0.001;
				if(l.material.lineAlpha <= 0)
					line.removeLine(l);
			}
			
			hsv.h += 0.1;
			hsv.h += count;
		}
	}
}