/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fWD4
 */

// forked from Nyarineko's ImageSelectCursor
package
{
    import flash.display.*;
    import flash.net.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.ui.*;
    import flash.system.*;
    import flash.utils.*;
    
    [SWF(width = "465", height = "465", backgroundColor = "0x999999", frameRate = "30")]
    public class Main extends Sprite {
        private var obj:Sprite;
        private var _container:Sprite;//選択中カーソル
        private var cursor:Cursor;//マウスカーソル(オーバー)
        
        private var line:Shape;//点線カーソル
        private var slant:Sprite;//ポインタ四隅
        private var cross:Sprite;//ポインタ縦横
        private var center:Shape;//ポインタ中心
        
        private var selectFlg:Boolean = false;//選択中フラグ

        
        public function Main():void {
            obj = new Sprite();
            drawObjectOff();
            obj.buttonMode = true;
            obj.x = 232;
            obj.y = 232;
            addChild(obj);
            obj.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            obj.addEventListener(MouseEvent.MOUSE_UP,onUp);
            obj.addEventListener(MouseEvent.ROLL_OVER,onOver);
            obj.addEventListener(MouseEvent.ROLL_OUT,onOut);
            stage.addEventListener(MouseEvent.CLICK,onClick);
            
            //選択カーソル
            _container = new Sprite();
            _container.x = obj.x;
            _container.y = obj.y;
            _container.visible = false;
            _container.mouseEnabled = false;
            _container.mouseChildren = true;
            addChild(_container);
            
            //点線カーソル
            line = new Shape();
            _container.addChild(line);
            
            //ポインタ四隅
            slant = new Sprite();
            slant.addEventListener(MouseEvent.MOUSE_OVER,onMarkerOver);
            slant.addEventListener(MouseEvent.MOUSE_OUT,onMarkerOut);
            slant.addEventListener(MouseEvent.MOUSE_DOWN,onMarkerDown);
            _container.addChild(slant);
            
            //ポインタ縦横
            cross = new Sprite();
            cross.addEventListener(MouseEvent.MOUSE_OVER,onMarkerOver);
            cross.addEventListener(MouseEvent.MOUSE_OUT,onMarkerOut);
            cross.addEventListener(MouseEvent.MOUSE_DOWN,onMarkerDown);
            _container.addChild(cross);
            
            stage.addEventListener(MouseEvent.MOUSE_UP,onMarkerUp);
            
            //ポインタ中心
            center = new Shape();
            _container.addChild(center);
            
            //ポインタカーソル
            cursor = new Cursor();
            cursor.visible = false;
            addChild(cursor);
            
            drawMarker(obj);
        }
        
        //ドラッグ開始
        private function onDown(evt:MouseEvent):void {
            obj.alpha = 0.5;
            _container.visible = true;
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            obj.startDrag(false,new Rectangle(0,0,465,465));
        }
        
        //ドラッグ終了
        private function onUp(evt:MouseEvent):void {
            obj.alpha = 1;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            obj.stopDrag();
        }
        
        //ドラッグ中
        private function onMove(evt:MouseEvent):void {
            _container.x = obj.x;
            _container.y = obj.y;
        }
        
        //オーバー
        private function onOver(evt:MouseEvent):void {
            drawObjectOn();
        }
        
        //アウト
        private function onOut(evt:MouseEvent):void {
            if(!selectFlg) drawObjectOff();
        }
        
        //クリック
        private function onClick(evt:MouseEvent):void {
            if(evt.target != obj && evt.target != _container && evt.target.parent != _container){
                _container.visible = false;
                selectFlg = false;
                onOut(null);
            }else{
                _container.visible = true;
                selectFlg = true;
            }
        }
        
        private function drawObjectOn():void {
            obj.graphics.clear();
            obj.graphics.lineStyle(2,0xFFFFFF,1,true,LineScaleMode.NONE);
            obj.graphics.beginFill(0x336699);
            obj.graphics.drawCircle(0,0,50);
            obj.graphics.endFill();
        }
        
        private function drawObjectOff():void {
            obj.graphics.clear();
            obj.graphics.beginFill(0x336699);
            obj.graphics.drawCircle(0,0,50);
            obj.graphics.endFill();
        }
        
        private function drawMarker(obj:DisplayObject):void {
            //点線横
            var bmdx:BitmapData = new BitmapData(4,1,true);
            bmdx.setPixel32(0,0,0xFF000000);
            bmdx.setPixel32(1,0,0xFF000000);
            bmdx.setPixel32(2,0,0);
            bmdx.setPixel32(3,0,0);
            
            //点線縦
            var bmdy:BitmapData = new BitmapData(1,4);
            bmdy.setPixel32(0,0,0xFF000000);
            bmdy.setPixel32(0,1,0xFF000000);
            bmdy.setPixel32(0,2,0);
            bmdy.setPixel32(0,3,0);
            
            //点線カーソル
            line.graphics.clear();
            line.graphics.beginBitmapFill(bmdx);
            line.graphics.drawRect(-obj.width/2,-obj.height/2,obj.width,1);
            line.graphics.drawRect(-obj.width/2,obj.height/2,obj.width,1);
            line.graphics.endFill();
            line.graphics.beginBitmapFill(bmdy);
            line.graphics.drawRect(-obj.width/2,-obj.height/2,1,obj.height);
            line.graphics.drawRect(obj.width/2,-obj.height/2,1,obj.height);
            line.graphics.endFill();
            
            //ポインタ四隅
            var size:uint = 6;
            slant.graphics.clear();
            slant.graphics.lineStyle(2,0xFFFFFF,1,true,LineScaleMode.NONE,CapsStyle.SQUARE);
            slant.graphics.beginFill(0x000000);
            slant.graphics.drawRect(-obj.width/2-size/2,-obj.height/2-size/2,size,size);
            slant.graphics.drawRect(obj.width/2-size/2,-obj.height/2-size/2,size,size);
            slant.graphics.drawRect(obj.width/2-size/2,obj.height/2-size/2,size,size);
            slant.graphics.drawRect(-obj.width/2-size/2,obj.height/2-size/2,size,size);
            slant.graphics.endFill();
            
            //ポインタ縦横
            cross.graphics.clear();
            cross.graphics.lineStyle(2,0xFFFFFF,1,true,LineScaleMode.NONE,CapsStyle.SQUARE);
            cross.graphics.beginFill(0x000000);
            cross.graphics.drawRect(-size/2,-obj.height/2-size/2,size,size);
            cross.graphics.drawRect(obj.width/2-size/2,-size/2,size,size);
            cross.graphics.drawRect(-size/2,obj.height/2-size/2,size,size);
            cross.graphics.drawRect(-obj.width/2-size/2,-size/2,size,size);
            cross.graphics.endFill();
            
            //ポインタ中心
            center.graphics.clear();
            center.graphics.lineStyle(2,0xFFFFFF,1,true,LineScaleMode.NONE,CapsStyle.SQUARE);
            center.graphics.beginFill(0x000000);
            center.graphics.drawCircle(0,0,size/2);
            center.graphics.endFill();
        }
        
        //マーカーオーバー
        private function onMarkerOver(evt:MouseEvent):void {
            //カーソルをチェンジ
            Mouse.hide();
            cursor.visible = true;
            stage.addEventListener(Event.ENTER_FRAME,onCursorFrame);
        }
        
        //マーカーアウト
        private function onMarkerOut(evt:MouseEvent):void {
            //カーソルをチェンジ
            Mouse.show();
            cursor.visible = false;
            stage.removeEventListener(Event.ENTER_FRAME,onCursorFrame);
        }
        
        //マーカーダウン
        private function onMarkerDown(evt:MouseEvent):void {
            //カーソルをチェンジ
            Mouse.hide();
            cursor.visible = true;
            slant.removeEventListener(MouseEvent.MOUSE_OUT,onMarkerOut);
            cross.removeEventListener(MouseEvent.MOUSE_OUT,onMarkerOut);
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onSizeChange);
        }
        
        //マーカーアップ
        private function onMarkerUp(evt:MouseEvent):void {
            //カーソルをチェンジ
            Mouse.show();
            cursor.visible = false;
            slant.addEventListener(MouseEvent.MOUSE_OUT,onMarkerOut);
            cross.addEventListener(MouseEvent.MOUSE_OUT,onMarkerOut);
            //カーソルをチェンジ
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,onSizeChange);
        }
        
        //サイズ変更
        private function onSizeChange(evt:MouseEvent):void {
            var a:Number = Math.abs(obj.x - mouseX)*2;
            var b:Number = Math.abs(obj.y - mouseY)*2;
            var ab:Number = (a > b)?a:b;
            obj.width = (ab > 30)?ab:30;
            obj.height = (ab > 30)?ab:30;
            drawMarker(obj);
        }
        
        //フレーム処理
        private function onCursorFrame(evt:Event):void {
            cursor.x = mouseX;
            cursor.y = mouseY;
            var P1:Point = new Point(_container.x,_container.y);
            var P2:Point = new Point(mouseX,mouseY);
            var vector:Point = P2.subtract(P1);
            var angle:Number = Math.atan2(vector.y,vector.x) * 180/Math.PI
            cursor.rotation = Math.round((angle + 90)/45) * 45;
        }
    }
}

//マウスカーソル
import flash.display.*;
class Cursor extends Shape
{
    public function Cursor():void
    {
        drawCursor();
    }
    private function drawCursor():void
    {
        graphics.lineStyle(1,0xFFFFFF,1,true,LineScaleMode.NONE,CapsStyle.SQUARE);
        graphics.beginFill(0x000000);
        graphics.moveTo(0,-8);
        graphics.lineTo(4,-4);
        graphics.lineTo(1,-4);
        graphics.lineTo(1,4);
        graphics.lineTo(4,4);
        graphics.lineTo(0,8);
        graphics.lineTo(-4,4);
        graphics.lineTo(-1,4);
        graphics.lineTo(-1,-4);
        graphics.lineTo(-4,-4);
        graphics.lineTo(0,-8);
        graphics.endFill();
    }
}