/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fVr7
 */

package
{
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    
    public class Instance extends Sprite
    {
        public static const WIDTH :Number = 465;
        public static const HEIGHT :Number = 465;
        
        private var _particleEnum :Array;
        private var _rectangle :Rectangle;
        private var _canvas :BitmapData;

        public function Instance()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            _particleEnum = [];
            _canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
        }
        
        private function _init() :void
        {
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.9);
            graphics.drawRect  (0, 0, (WIDTH - 1), (HEIGHT - 1));
        }
    
        private function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(new Bitmap(_canvas));
            
            _init();
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        var bReady :Boolean = false;  
        
        private function onEnterFrame($e:Event) :void
        {
            initParticle();
            
            if (bReady)
            {
                update();
            }

        }

        private function initParticle() :void
        {
            for (var i:Number = 0; i < 200; i++)
            {
                var $p :Particle = new Particle();
                var $a :Number = (Math.random() * (Math.PI / 2));
            
                $p.x = Math.random() * 465;
                $p.y = Math.random() * 465;
                $p.vX = (Math.cos($a) * 10);
                $p.vY = (Math.sin($a) * 10);
            
                _particleEnum.push($p);  
                
                if (i == 199)
                {bReady = true}
            }
        }
        
        private function update() :void
        {
            for (var i:Number = 0; i < 200; i++)
            {
                var $p :Particle = _particleEnum[i];
                
                _canvas.lock();
                
                $p.x += $p.vX;
                $p.y += $p.vY;
                _canvas.setPixel32($p.x, $p.y, $p.c);
                
                if (($p.x > stage.stageWidth || $p.x < 0) || ($p.y < 0 || $p.y > stage.stageHeight) || Math.abs($p.vX) < .01 || Math.abs($p.vY) < .01)
                {
                    _particleEnum.splice(i, 1);
                }
            }

            _canvas.lock();
        }
    }
}

class Particle
{
    public var x :Number = 0;
    public var y :Number = 0;
    public var vX :Number = 0;
    public var vY :Number = 0;
    public var c :uint = 0xFF000000;
    
    public function Particle() {}
}
