/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fVkf
 */

// forked from otoyasumi's 細かすぎて伝わらないハマリどころ〜TextField.getTextFormat()編〜
/**
 * 上のテキストフィールドになにか文字が入っていないと、
 * getTextFormat()の戻り値（Object）のプロパティがnullで返ってきてしまう。
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.Font;

	public class TestText extends Sprite {
		private var form_title:TextField;
		private var form_field:TextField;
		private var log_title:TextField;
		private var log_field:TextField;
				
		public function TestText() {
			
			/*
			 * テキスト入力フィールドを生成
			 */
			form_title = new TextField();
			form_title.text = "INPUT:"
			addChild(form_title);
			
			form_field = new TextField;
			form_field.x = 45;
			form_field.width = 300;
			form_field.height = 40;
			form_field.maxChars = 15;
			form_field.type = "input";
			form_field.border = true;
			form_field.text = "ここの文字を削除してみてください";
			addChild(form_field);
			
			
			var fonts:Array = Font.enumerateFonts(true);
			form_field.setTextFormat(new TextFormat(Font(fonts[Math.floor(Math.random()*fonts.length)]).fontName, 12, 0xff0000), 0, 8);
			form_field.setTextFormat(new TextFormat(Font(fonts[Math.floor(Math.random()*fonts.length)]).fontName, 14, 0x006600), 8, form_field.length);
			
			
			form_field.addEventListener(TextEvent.TEXT_INPUT, changeText);
			form_field.addEventListener(Event.CHANGE, changeText);
			//deleteキー入力時のイベントはTextEventでは取得できないためEvent.CHANGEでも取得する
			
			var description:TextField = new TextField();
			description.x = 40;
			description.y = 50;
			description.width = 400;
			description.height = 60;
			description.text = "上のTextFieldのgetTextFormat()の戻り値（Object）の中から、";
			description.appendText("\n試しに、align, font, sizeの三つのプロパティを出力してみた。");
			description.appendText("\n\n何も入力されていない状態だと、各パラメータはnullとなる");
			addChild(description);
			
			/*
			 * trace出力フィールド
			 */
			log_title = new TextField();
			log_title.text = "  LOG:"
			log_title.y = 90;
			addChild(log_title);
			
			log_field = new TextField;
			log_field.x = 45;
			log_field.y = 90;
			log_field.width = 300
			log_field.height = 160;
			log_field.border = true;
			addChild(log_field);
			
			
			stage.focus = form_field;
			
			changeText();
		}
		
		
		private function changeText(e:Event = null):void {
			log_field.text = "form_field.getTextFormat().align = " + String(form_field.getTextFormat().align);
			log_field.appendText( "\nform_field.getTextFormat().color = " + String(form_field.getTextFormat().color) );
			log_field.appendText( "\nform_field.getTextFormat().font = " + String(form_field.getTextFormat().font) );
			log_field.appendText( "\nform_field.getTextFormat().size = " + String(form_field.getTextFormat().size) );
			
			log_field.appendText( "\n\nform_field.defaultTextFormat.align = " + String(form_field.defaultTextFormat.align) );
			log_field.appendText( "\nform_field.defaultTextFormat.color = " + String(form_field.defaultTextFormat.color) );
			log_field.appendText( "\nform_field.defaultTextFormat.font = " + String(form_field.defaultTextFormat.font) );
			log_field.appendText( "\nform_field.defaultTextFormat.size = " + String(form_field.defaultTextFormat.size) );
		}
	}
}