/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fUvZ
 */

package  
{
	import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    /**
     * ...
     * @author lizhi http://game-develop.net/
     */
    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=60)]
    public class Bezier2 extends Sprite
    {
        private var s:Sprite = new Sprite;
        private var t:Number = 0;
        private var currentBezier:BezierLine;
        public function Bezier2() 
        {
            var c:int = 5;
            var ps:Array = [];
            while (c-->0) {
                ps.push(new Point(stage.stageWidth * Math.random(), stage.stageHeight * Math.random()));
            }
            var beziers:Array = [];
            for (var i:int = 0; i < ps.length;i++ ) {
                var p1:Point = ps[i];
                var prep:Point = ps[(i - 1+ps.length) % ps.length];
                var nextp:Point = ps[(i + 1) % ps.length];
                var p2:Point = new Point(p1.x / 2 + nextp.x / 2, p1.y / 2 + nextp.y / 2);
                var p0:Point = new Point(p1.x / 2 + prep.x / 2, p1.y / 2 + prep.y / 2);
                var bezierLine:BezierLine = new BezierLine;
                bezierLine.p0 = p0;
                bezierLine.p1 = p1;
                bezierLine.p2 = p2;
                beziers.push(bezierLine);
            }
            
			var bps:Array = [];
            for (i = 0; i < beziers.length;i++ ) {
                bezierLine = beziers[i];
                bezierLine.next = beziers[(i + 1) % beziers.length];
                bezierLine.pre = beziers[(i - 1+beziers.length) % beziers.length];
                graphics.moveTo(bezierLine.p0.x, bezierLine.p0.y);
                graphics.curveTo(bezierLine.p1.x, bezierLine.p1.y, bezierLine.p2.x, bezierLine.p2.y);
				
				for (var j:Number = 0; j < .95;j+=.2 ) {
					var p:Vector3D = b(j, bezierLine.p0, bezierLine.p1, bezierLine.p2);
					bps.push(p);
				}
            }
			
			var vert:Vector.<Number> = new Vector.<Number>;
			var uv:Vector.<Number> = new Vector.<Number>;
			var ins:Vector.<int> = new Vector.<int>;
			
            graphics.lineStyle(0);
			for (i = 0; i< bps.length;i++ ) {
				p = bps[i];
				var np:Vector3D = bps[i + 1];
				if (np == null) {
					np = bps[0];
					ins.push(i * 2, i * 2 + 1, 0, 0, i * 2 + 1, 1);
				}else {
					ins.push(i * 2, i * 2 + 1, i * 2 + 2,i*2+2,i*2+1,i*2+3);
				}
				var dp:Vector3D = np.subtract(p);
				var lp:Vector3D = dp.crossProduct(Vector3D.Z_AXIS);
				lp.normalize();
				lp.scaleBy(20);
				var v:Vector3D = p.add(lp);
				vert.push(v.x, v.y/*, v.z*/);
				graphics.drawCircle(v.x, v.y, 2);
				v = p.subtract(lp);
				vert.push(v.x, v.y/*, v.z*/);
				
				graphics.drawCircle(v.x, v.y, 2);
				uv.push(i/bps.length, 0);
				uv.push(i / bps.length, 1);
			}
			var bmd:BitmapData = new BitmapData(1000, 100);
			createXorMap(bmd);
            graphics.lineStyle();
			graphics.beginBitmapFill(bmd,null,true,true);
			graphics.drawTriangles(vert, ins,uv);
            
            addChild(s);
            s.graphics.lineStyle(0, 0xff0000);
            s.graphics.moveTo(7, 0);
            s.graphics.lineTo( -7, 5);
            s.graphics.lineTo( -7, -5);
            s.graphics.lineTo(7, 0);
            currentBezier = beziers[0];
            addEventListener(Event.ENTER_FRAME, update);
        }
		
		public static function createXorMap(b:BitmapData):void {
			for (var i:int = 0; i < b.height; i++){
				for (var k:int = 0; k < b.width; k++){
					b.setPixel(k,i, (i^k)<<16 | (i ^ k) << 8 | (i^k));
				}
			}
		}
        
        private function update(e:Event):void 
        {
            var speed:Number;
            if (mouseX > stage.stageWidth / 2) {
                speed = 0.01;
            }else {
                speed = -0.01;
            }
            t += speed;
            
            if (t > 1) {
                t = 0;
                currentBezier = currentBezier.next;
            }
            if (t<0) {
                t = 1;
                currentBezier = currentBezier.pre;
            }
            var p:Vector3D = b(t, currentBezier.p0, currentBezier.p1, currentBezier.p2);
            s.x = p.x;
            s.y = p.y;
            s.rotation = p.z * 180 / Math.PI+(speed<0?180:0);
        }
        
        //point x,y tangent z
        private function b(t1:Number, p0:Point, p1:Point, p2:Point):Vector3D
        {
            var t0:Number = 1 - t1;
            var q0x:Number = t0 * p0.x + t1 * p1.x;
            var q0y:Number = t0 * p0.y + t1 * p1.y;
            var q1x:Number = t0 * p1.x + t1 * p2.x;
            var q1y:Number = t0 * p1.y + t1 * p2.y;
            return new Vector3D(t0 * q0x + t1 * q1x, t0 * q0y + t1 * q1y, Math.atan2(q1y - q0y, q1x - q0x));
        }
        
    }

}
import flash.geom.Point;
class BezierLine {
    public var next:BezierLine;
    public var pre:BezierLine;
    public var p0:Point;
    public var p1:Point;
    public var p2:Point;
}