/**
 * Copyright esimov ( http://wonderfl.net/user/esimov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fTwC
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Shader;
    import flash.display.ShaderJob;
    import flash.display.Loader;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import mx.utils.*;
    
    import com.bit101.components.Panel;
    import com.bit101.components.Style;
    import com.bit101.components.Window;
    import com.bit101.components.HUISlider;
    import com.bit101.components.Label;
    import com.bit101.components.HUISlider;
    
    /*
    * @author esimov
    */
    
    [SWF (background = 0x00, width = "465", height = "465")]

    public class Flower extends Sprite
    {
        private var _imageURL:String;
        private var _shaderJob:ShaderJob;
        private var _imageLoader:Loader;
        private var _bmpData:BitmapData;
        private var _bmp:Bitmap;
        private var _dec64:Base64Decoder;
            
        private var _shader:Shader;
        private var _window:Window;
        private var _red:HUISlider;
        private var _green:HUISlider
        private var _blue:HUISlider;
        
        private var _xOff:HUISlider;
        private var _yOff:HUISlider;
        
        private var dec64:String = "";
        private var time:Number = 0;        
        private const WIDTH:Number = stage.stageWidth;
        private const HEIGTH:Number = stage.stageHeight;
        
        public function Flower():void
        {
            initStage();
        }
        
        private function initStage():void
        {
            if (stage) init(null);
            else
            {
                throw new Error("Stage not active");
                addEventListener(Event.ADDED_TO_STAGE, init);
            }
        }
        
        private function init(event:*):void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = "medium";
            stage.frameRate = 60;
                        
            dec64 += "pQEAAACkBgBGbG93ZXKgDG5hbWVzcGFjZQBTaW1vIEVuZHJlAKAMdmVuZG9yAHNpbW9lbmRy";
            dec64 += "ZS53b3JkcHJlc3MuY29tAKAIdmVyc2lvbgABAKEBAgAADF9PdXRDb29yZAChAgQBAA9kc3QA";
            dec64 += "oQEBAAACb2Zmc2V0WACiAW1pblZhbHVlAD+AAACiAW1heFZhbHVlAEEgAAChAQEAAAFvZmZz";
            dec64 += "ZXRZAKIBbWluVmFsdWUAAAAAAKIBZGVmYXVsdFZhbHVlAEAAAACiAW1heFZhbHVlAEGgAACh";
            dec64 += "AQICAAxyZXNvbHV0aW9uAKICbWluVmFsdWUAQ+YAAEPmAACiAmRlZmF1bHRWYWx1ZQBESAAA";
            dec64 += "RBYAAKICbWF4VmFsdWUARIAAAERAAACiDGRlc2NyaXB0aW9uAGRlZmluZSB0aGUgc2NyZWVu";
            dec64 += "IHJlc29sdXRpb24AoQEBAgACdGltZQCiAW1pblZhbHVlAAAAAACiAWRlZmF1bHRWYWx1ZQAA";
            dec64 += "AAAAogFtYXhWYWx1ZQBEegAAogxkZXNjcmlwdGlvbgBhZGp1c3QgdGltZQChAQECAAFyZWQA";
            dec64 += "ogFtaW5WYWx1ZQAAAAAAogFkZWZhdWx0VmFsdWUAP0zMzaIBbWF4VmFsdWUAP4AAAKEBAQMA";
            dec64 += "CGdyZWVuAKIBbWluVmFsdWUAAAAAAKIBZGVmYXVsdFZhbHVlAD8AAACiAW1heFZhbHVlAD+A";
            dec64 += "AAChAQEDAARibHVlAKIBbWluVmFsdWUAAAAAAKIBZGVmYXVsdFZhbHVlAD3MzM2iAW1heFZh";
            dec64 += "bHVlAD+AAAAyAwAgQEfILTIDABC/gAAAMgQAgEAAAAAdBABhBAAAAAMEAGEAABAABAUAwQIA";
            dec64 += "UAADBQDBBABgAB0EAMEDAPAAAQQAwQUAEAAdBAAxBAAQAB0DABAEAMAABgMAEAQAgAAdBACA";
            dec64 += "AwDAADIDABBAAAAAHQQAQAQAgAAHBABAAwDAADIDABBAAAAAHQUAgAQAwAAHBQCAAwDAAB0D";
            dec64 += "ABAEAEAAAQMAEAUAAAAWBABAAwDAADIDABA/TMzNHQUAgAQAQAADBQCAAwDAAB0DABAFAAAA";
            dec64 += "HQQAQAMAgAADBABAAgCAAB0FAIADAMAAAwUAgAAAwAAdBQBABABAAAIFAEAFAAAADQQAQAUA";
            dec64 += "QAAdBQCABABAADIEAEA/AAAAMgUAQD8AAAAyBQAgQUAAAB0FABAFAIAAAwUAEAQAAAAyBQAg";
            dec64 += "QOAAAB0GAIAFAAAAAwYAgAUAgAAdBQAgBQDAAAIFACAGAAAAMgUAEEBAAAAdBgCAAwDAAAMG";
            dec64 += "AIAFAMAAMgUAED9mZmYEBgBABQDAAAMGAEAGAAAAHQUAEAYAQAADBQAQAACAAB0GAIAFAIAA";
            dec64 += "AQYAgAUAwAANBQAgBgAAAB0FABAFAEAAAwUAEAUAgAAdBQBABABAAAEFAEAFAMAAHQQAQAUA";
            dec64 += "QAAyBQBAPoAAADIFACA/QAAAMgUAED+AAAAdBgCABQDAAAMGAIADAMAAHQUAEAQAQAAHBQAQ";
            dec64 += "BgAAAB0GAIAFAIAAAwYAgAUAwAAyBQAgPzMzMzIFABA+mZmaHQYAQAUAwAADBgBABQAAAB0F";
            dec64 += "ABAFAIAAAQUAEAYAQAAdBQAgBgAAAAMFACAFAMAAHQUAEAUAQAABBQAQBQCAAB0FAEAFAMAA";
            dec64 += "HQUAEAUAQAACBQAQAwDAAB0FACAFAMAAMgUAEAAAAAAqBQAQBQCAAB0BgIAAgAAAMgUAID8Z";
            dec64 += "mZoyBQAQAAAAADMGAIABgAAABQCAAAUAwAAdBQAgBgAAADIFABA/gAAABAYAgAUAQAADBgCA";
            dec64 += "AwDAAB0GAEAFAMAAAgYAQAYAAAAWBQAQBgBAAB0GAIAFAIAAAwYAgAUAwAAdBQAQBgAAAAMF";
            dec64 += "ABADAMAAMgYAgECAAAAdBgBABQDAAAMGAEAGAAAAHQUAEAYAQAAyBgCAP6AAADIGAEA+gAAA";
            dec64 += "MgYAIEFAAAAdBgAQBgCAAAMGABAEAAAAMgYAIEDgAAAdBwCABQAAAAMHAIAGAIAAHQYAIAYA";
            dec64 += "wAACBgAgBwAAADIGABBAgAAAHQcAgAMAwAADBwCABgDAAB0GABAGAIAAAQYAEAcAAAAyBgAg";
            dec64 += "QAAAAAQHAIAGAIAAAwcAgAYAwAANBgAgBwAAAB0GABAGAEAAAwYAEAYAgAAdBgBABgAAAAEG";
            dec64 += "AEAGAMAAAwUAEAYAQAAyBgCAP4AAADIGAEA+szMzMgYAID8AAAAyBgAQPwAAADIHAIBB8AAA";
            dec64 += "HQcAQAMAwAADBwBABwAAAAwHAIAHAEAAHQcAQAYAwAADBwBABwAAAB0GABAGAIAAAQYAEAcA";
            dec64 += "QAAdBgAgBgBAAAMGACAGAMAAMgYAQD8AAAAyBgAQPwAAADIHAIBBQAAAHQcAQAcAAAADBwBA";
            dec64 += "BAAAADIHAIBA4AAAHQcAIAUAAAADBwAgBwAAAB0HAIAHAEAAAgcAgAcAgAAyBwBAQQAAAB0H";
            dec64 += "ACADAMAAAwcAIAcAQAAdBwBABwAAAAEHAEAHAIAADQcAgAcAQAAdBwBABgDAAAMHAEAHAAAA";
            dec64 += "HQYAEAYAQAABBgAQBwBAAB0GAEAGAIAAAwYAQAYAwAAdBgAgBgAAAAIGACAGAEAAAwUAEAYA";
            dec64 += "gAAdBwCABQBAAAMHAIACAMAAHQcAQAUAwAACBwBABwAAADIHAIA+zMzNHQcAIAMAwAADBwAg";
            dec64 += "BwAAADIHAIA/mZmaHQcAEAcAAAACBwAQAwDAAB0HAIAHAIAAAwcAgAcAwAAdBwAgBwBAAAEH";
            dec64 += "ACAHAAAAHQYAgAcAgAAdBwCABABAAAMHAIADAAAAHQcAQAUAwAACBwBABwAAADIHAIA+TMzN";
            dec64 += "HQcAIAMAwAADBwAgBwAAAB0HAIAHAEAAAQcAgAcAgAAyBwBAPrMzMx0HACAHAEAAAwcAIAQA";
            dec64 += "QAAyBwBAP5mZmh0HABAHAEAAAgcAEAMAwAAdBwBABwCAAAMHAEAHAMAAHQcAIAcAAAABBwAg";
            dec64 += "BwBAAB0GAEAHAIAAHQcAgAQAQAADBwCAAwDAAB0HAEAFAMAAAgcAQAcAAAAdBwCAAwBAAAMH";
            dec64 += "AIAEAEAAMgcAID+ZmZodBwAQBwCAAAIHABADAMAAHQcAIAcAAAADBwAgBwDAAB0HAIAHAEAA";
            dec64 += "AQcAgAcAgAAdBgAgBwAAADIHAIA/gAAAHQYAEAcAAAAdBwDzBgAbAB0GAIAHAMAAHQYAQAcA";
            dec64 += "AAAdBgAgBwBAAB0GABAHAIAAHQEA8wYAbAA=";

            _bmpData = new BitmapData(WIDTH, HEIGTH, false, 0x00);
            _bmp = new Bitmap(_bmpData);
            _bmp.smoothing = false;
            _bmp.filters = [new BlurFilter(2,2)];
            addChild(_bmp);
            
            controlPanel();
            
            _dec64 = new Base64Decoder;
            _dec64.decode(dec64);
            _shader = new Shader(_dec64.drain());
            
            _shader.data.resolution.value = [WIDTH, HEIGTH];
            _shader.data.offsetX.value = [_xOff.value];
            _shader.data.offsetY.value = [_yOff.value];
            _shader.data.red.value = [_red.value];
            _shader.data.green.value = [_green.value];
            _shader.data.blue.value = [_blue.value];
            
            addEventListener(Event.ENTER_FRAME, loop);
            
        }
                
        private function controlPanel():void
        {        
            _window = new Window(this, WIDTH - 100, 0, "Effect adjuster");
            _window.draggable = true;
            _window.hasMinimizeButton = true;
            _window.width = 120;
            _window.height = 130;
            addChild(_window);
            
            var redLabel:Label = new Label(_window, 1, 30, "R: ");
            var greenLabel:Label = new Label(_window, 1, 50, "G: ");
            var blueLabel:Label = new Label(_window, 1, 70, "B: ");
            var xOffLabel:Label = new Label(_window, 1, 90, "X: ");
            var yOffLabel:Label = new Label(_window, 1, 110, "Y: ");
            
            _xOff = new HUISlider(_window, 8, 90,null);
            _xOff.width = _window.width;
            _xOff.setSliderParams(0.0, 10.0, 0.0);
            _xOff.tick = 0.01;
            _yOff = new HUISlider(_window, 8, 110,null);
            _yOff.width = _window.width;
            _yOff.tick = 0.01;
            _yOff.setSliderParams(0.0, 20.0, 2.0);
            
            _red = new HUISlider(_window, 8, 30,null);
            _red.width = _window.width;
            _red.tick = 0.01;
            _red.setSliderParams(0.0, 5.0, 0.8);
            _green = new HUISlider(_window, 8, 50,null);
            _green.width = _window.width;
            _green.tick = 0.01;
            _green.setSliderParams(0.0, 5.0, 0.5);
            _blue = new HUISlider(_window, 8, 70,null);
            _blue.width = _window.width;
            _blue.tick = 0.01;
            _blue.setSliderParams(0.0, 5.0, 0.1);
        }
        
        private function loop(event:Event):void
        {
            _shaderJob = new ShaderJob(_shader, _bmpData);
            _shaderJob.start();
            
            time += 0.008;
            _shader.data.time.value = [time];
            _shader.data.offsetX.value = [_xOff.value];
            _shader.data.offsetY.value = [_yOff.value];
            _shader.data.red.value = [_red.value];
            _shader.data.green.value = [_green.value];
            _shader.data.blue.value = [_blue.value];
        }
    }
}

/***********************
 * Pixelbender Shader
***********************/

/* Credits goes to Inigo Quilez
 * http://www.iquilezles.org/apps/shadertoy/
 */

/*<languageVersion : 1.0;>

kernel Flower
<   namespace : "Simo Endre";
    vendor : "simoendre.wordpress.com";
    version : 1;
>
{
    input image4 src;
    output pixel4 dst;
    
    parameter float offsetX
    <
        minValue : float(1.0);
        maxValue : float(10.0);
    >;
    
    parameter float offsetY
    <
        minValue : float(0.0);
        defaultValue : float(2.0);
        maxValue : float(20.0);
    >;
    
    parameter float2 resolution
    <
        minValue : float2(460.0, 460.0);
        defaultValue : float2(800.0, 600.0);
        maxValue : float2(1024.0, 768.0);
        description : "define the screen resolution";
    >;
    
    parameter float time
    <
        minValue : float(0.0);
        defaultValue : float(0.0);
        maxValue : float(1000.0);
        description : "adjust time";
    >;
    
    parameter float red
    <
        minValue : float(0.0);
        defaultValue : float(0.8);
        maxValue : float(1.0);
    >;
    
    parameter float green
    <
        minValue : float(0.0);
        defaultValue : float(0.5);
        maxValue : float(1.0);
    >;
    
    parameter float blue
    <
        minValue : float(0.0);
        defaultValue : float(0.1);
        maxValue : float(1.0);
    >;
    
    void evaluatePixel()
    {
        float pi = 3.1215927;
        float2 pos = -1.0 + 2.0 * outCoord().xy / resolution.y;
        float a = atan(pos.y, pos.x);
        float r = sqrt(pow(pos.x, 2.0) + pow(pos.y, 2.0)) * 0.8;
        float w = cos(pi*time - r*offsetY);
        float u = 0.5+0.5*cos(12.0*a-w*7.0+(r*3.0/0.9*offsetX));
        float v = 0.25+0.75*pow(u,1.0*r)*(0.7+0.3*w);
        
        float t = float(v-r) > 0.0 ? 0.6 : 0.0;
        
        float color = t * sqrt(1.0-r/v)*r*4.0;
        color *= 1.25+0.25*cos((12.0*a-w*7.0+r*4.0)/2.0);
        color *= 1.0-0.35*(0.5+0.5*sin(r*30.0))*(0.5+0.5*cos(12.0*a-w*7.0+r*8.0));
        float4 c = float4(color-v*red+r*0.4*(1.2-r),color-u*green+r*0.2+0.35*u*(1.2-r),color-u*r+blue*u*(1.2-r), 1.0);
        
        dst.argb = float4(c.a, c.r, c.g, c.b);
    }
}*/
