/**
 * Copyright yo0_0oy ( http://wonderfl.net/user/yo0_0oy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fTbA
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.ui.Keyboard;

    [SWF(width=450, height=600, backgroundColor=0x000000)]

	public class DrawTest extends Sprite {

	private var _circle:Sprite;
	private var _bitmapData:BitmapData;

	public function DrawTest() {
		createBitmap();
		createCircle();
		stage.addEventListener(KeyboardEvent.KEY_DOWN, onStageKeyDown);
	}

	private function createBitmap():void {
		_bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
		var bitmap:Bitmap = new Bitmap(_bitmapData);
		addChild(bitmap);
	}


	private function createCircle():void {
		_circle = new Sprite();
		_circle.graphics.beginFill(0xFF0000);
		_circle.graphics.drawCircle(0, 0, 25);
		_circle.graphics.endFill();
		addChild(_circle);
		_circle.x = stage.mouseX;
		_circle.y = stage.mouseY;
		_circle.startDrag();
	}

	private function onStageKeyDown(event:KeyboardEvent):void {
		if (event.keyCode == Keyboard.SPACE) {
			_bitmapData.draw(stage);
			// added in step 2, this enables the scaling down of a smaller copy of the stage image data
				var matrix:Matrix = new Matrix();
				matrix.scale(.5, .5);
			// added in step 3, this moves the smaller copy to the lower right corner of the bitmap
				matrix.translate(300, 200);
			// added in step 4, this inverts the colors of the smaller copy
				var transform:ColorTransform = new ColorTransform(-1, -1, -1, 1, 255, 255, 255);
				_bitmapData.draw(stage, matrix, transform);
			// transform the current color of the circle
		            transform = new ColorTransform();
			transform.color = Math.random()*0xFFFFFF;
			_circle.transform.colorTransform = transform;
		}
	}
 }
}