/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fTZK
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.geom.Matrix;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.materials.WireframeMaterial;
    import frocessing.color.ColorHSV;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]
    public class FlashTest extends Sprite {
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        private var pixels:Pixels;
        private var layer:BitmapEffectLayer;
        private var sphere:Sphere;
        private static var radius:uint = 500;
        private var angle:Number = 90;
        private var degree:Number = 0;
        private static var depression:uint = 30;
        private static var radian:Number = Math.PI/180;
        private var map:BitmapData;
        private var colors:Array;
        private var loader:Loader;
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var filePath:String = "c/c8/c884/c884711ef4cc697cacadf6f890330377f029e524";
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0,0,465,465);
            graphics.endFill();
            
            scene = new Scene3D();
            camera = new Camera3D();
            viewport = new Viewport3D(0,0,true,false);
            renderer = new BasicRenderEngine();
            setup();
            load();
        }
        private function load():void {
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
            loader.load(new URLRequest(basePath + filePath), new LoaderContext(true));
            map = new BitmapData(200,100,false,0xff000000);
        }
        private function complete(evt:Event):void {
            var content:Bitmap = Bitmap(evt.target.content);
            var matrix:Matrix = new Matrix();
            matrix.scale(200/content.width, 100/content.height);
            map.draw(content.bitmapData,matrix);
            initialize();
            addChild(viewport);
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
        }
        private function setup():void {
            camera.x = 0;
            camera.y = 0;
            camera.z = radius;
            camera.zoom = 25;
            camera.focus = 20;
            camera.target = DisplayObject3D.ZERO;
        }
        private function initialize():void {
            layer = new BitmapEffectLayer(viewport, 465, 465, true, 0x00000000, BitmapClearMode.CLEAR_PRE);
            viewport.containerSprite.addLayer(layer);
            pixels = new Pixels(layer);
            scene.addChild(pixels);
            var hsv:ColorHSV = new ColorHSV();
            colors = new Array();
            colors.push(0xffffff);
            for(var y:uint = 0; y < 100; y++) {
               for(var x:uint = 0; x < 200; x++) {
                   var rgb:uint = map.getPixel(199-x,y); 
                   hsv.value = rgb;
                   if(rgb > 0xbbbbbb && (y < 20 || y > 80)) {
                       hsv.value = 0xffffff;
                   } else {
                       if(hsv.h > 180, hsv.h < 220 ) {
                           hsv.h = 200;
                       } else {
                           hsv.h = 160;
                       }
                       hsv.s = 1;
                       hsv.v = 1;
                   }
                   colors.push(hsv.value);
               }
            }
            colors.push(0xffffff);
            colors.reverse();
            var material:WireframeMaterial = new WireframeMaterial(0xffffff,1,0);
            sphere = new Sphere(material, 160, 200 , 101);
            var max:uint = sphere.geometry.vertices.length;
            for(var n:uint = 0; n < max; n++) {
                var color:uint = 0xff << 24 | colors[n];
                var vertex:Vertex3D = sphere.geometry.vertices[n];
                pixels.addPixel3D(new Pixel3D(color, vertex.x, vertex.y, vertex.z));
            }
        }
        private function render(evt:Event):void {
            angle++;
            degree += 2;
            var dip:Number = depression*Math.sin(degree*radian);
            camera.x = radius*Math.cos(angle*radian)*Math.cos(dip*radian);
            camera.y = radius*Math.sin(dip*radian);
            camera.z = radius*Math.sin(angle*radian)*Math.cos(dip*radian);
            layer.fillCanvas(0x00000000);
            renderer.renderScene(scene, camera, viewport);
        }
    }
}