/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fTMs
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.text.*;

	public class BitmapDrawerDocument extends Sprite {
		private var _canvas:BitmapData;
		private var _color:uint;
		private var _maxSize:Number = 5;
		private var _density:Number = 40;

		public function BitmapDrawerDocument() {
			init();
		}

		private function init():void {
			var tex:TextField = new TextField  ;
			addChild(tex);
			tex.width = 450;
			tex.x = tex.y = 10;
			tex.multiline = true;
			tex.text = 
			'ビットマップAPIを利用したドローアプリケーションのサンプルです。\n' + 
			'マウスダウン毎にランダムに色と散布サイズを割り当てています。';
			// ビットマップを描画するためのキャンバスとなるデータを作成し、ステージに配置
			_canvas = new BitmapData(stage.stageWidth,stage.stageHeight,true,0x00000000);
			addChild(new Bitmap(_canvas));
			// マウスダウンおよびマウスアップにイベントを割り当て
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
		}
		private function mouseDownHandler($event:MouseEvent):void {
			_color = Math.random() * 0xffffff + 0xff000000;
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}

		private function enterFrameHandler($event:Event):void {
			for (var i:uint = 0; i < _density; i++) {
				// ランダムにラジアン値(0から2πまでの範囲)を生成し、
				// _maxSizeを限界値としてランダムに半径を生成します。
				// xPosはサイン値(-1から1)で変調させた値に半径を与える事によって求めます。
				var angle:Number = Math.random() * (2 * Math.PI);
				var radius:Number = Math.random() * _maxSize;
				var xPos:Number = mouseX + Math.sin(angle) * radius;
				var yPos:Number = mouseY + Math.cos(angle) * radius;
				_canvas.setPixel32(xPos|0, yPos|0, _color);
			}			
		}

		private function mouseUpHandler($event:MouseEvent):void {
			removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
	}
}