/**
 * Copyright nekomura ( http://wonderfl.net/user/nekomura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fTI0
 */

package {

	import flash.display.*;
	import flash.events.*;
    import flash.text.*;
    import flash.ui.*;
    import flash.utils.*;
	import caurina.transitions.Tweener;
	
	[SWF(width = "465", height = "465", frameRate = "24", backgroundColor = "#000000")]

	public class code5 extends Sprite {
	
		private var _fighter:Sprite = new Sprite();
		private var _enemy:Sprite = new Sprite();
		private var _boost:Sprite = new Sprite();

		private var _fighterBarrier:Number;
		private var _barrierPoint:Array = new Array();
		private var _enemyPos:Number;
		private	var _enemyMoveTimer:Timer = new Timer(500, 0);
		private	var _enemyMissileTimer:Timer = new Timer(250, 0);		
		private var _statusText:TextField = new TextField();
		private var _textFormat:TextFormat = new TextFormat();
		private var _boostFlag:Boolean;		
		private var i:Number;

		// コンストラクタ
		public function code5() {
			initializeHandler();
		}

		// 初期化
		private function initializeHandler():void {
			fighterCreateHandler();
			enemyCreateHandler();
			standbyHandler();
		}

		// スタンバイ
		private function standbyHandler():void {

			messageHandler("Click Start!");
			
			_boostFlag = true;
			_fighterBarrier = 3;
			_fighter.x = stage.stageWidth / 2 - 15;
			_fighter.y = 400;
			_enemyPos = stage.stageWidth / 2 - 40;


			for (i = 0; i < _fighterBarrier; i++) {
				_barrierPoint[i] = new Sprite();
				_barrierPoint[i].graphics.beginFill(0xffffff);
				_barrierPoint[i].graphics.drawRect(0, 0, 5, 10);
				_barrierPoint[i].graphics.endFill();
				_barrierPoint[i].x = 10 * i + 5;
				_barrierPoint[i].y = 450;
				addChild(_barrierPoint[i]);
			}

			stage.addEventListener(MouseEvent.CLICK, startHandler);			
		}


		// スタート
		private function startHandler(event:MouseEvent):void {
		
			removeChild(_statusText);
			stage.removeEventListener(MouseEvent.CLICK, startHandler);

			stage.addEventListener(MouseEvent.CLICK, fighterBoostHandler);
			_fighter.addEventListener(Event.ENTER_FRAME, fighterEnterFrameHandler);

	    	_enemyMoveTimer.start();	    	
	    	_enemyMissileTimer.start();	    	

	    	_enemy.addEventListener(Event.ENTER_FRAME, enemyEnterFrameHandler);
	    	_enemyMoveTimer.addEventListener(TimerEvent.TIMER, enemyMoveTimerHandler);
	    	_enemyMissileTimer.addEventListener(TimerEvent.TIMER, enemyMissileTimerHandler);
		}


		// 自機生成
		private function fighterCreateHandler():void {
			_fighter.graphics.beginFill(0xffffff);
			_fighter.graphics.drawRect(0, 0, 30, 30);
			_fighter.graphics.endFill();
			_fighter.x = stage.stageWidth / 2 - 15;
			_fighter.y = 400;
			addChild(_fighter);
		}

		// 自機コントロール
		private function fighterEnterFrameHandler(event:Event):void {
			_fighter.x += (stage.mouseX - _fighter.x) * 0.04;
			_fighter.y += 5;

			if (_fighter.x < 0) _fighter.x = 0;
			if (_fighter.x > stage.stageWidth - _fighter.width) _fighter.x = stage.stageWidth - _fighter.width;
			if (_fighter.y > stage.stageHeight - _fighter.height) _fighter.y = stage.stageHeight - _fighter.height;
			
			if (_fighter.y < _enemy.y - 50) {
				messageHandler("Goll!!!!!!");
				gameOverHandler();
			}			
		}
		
		// ブースター
		private function fighterBoostHandler(event:MouseEvent):void {
			if (_boostFlag) {
				_boostFlag = false;
				_boost.graphics.beginFill(0xff0000);
				_boost.graphics.drawRect(0, 0, 10, 15);
				_boost.graphics.endFill();
				_boost.x = _fighter.width / 2 - 5;
				_boost.y = _fighter.height;
				_fighter.addChild(_boost);
				Tweener.addTween(_fighter, { y:_fighter.y - 50, time:0.5, transition:"easeOutCirc", onComplete:function() { _boostFlag = true; _fighter.removeChild(_boost); } });
			}
		}

		// 敵生成
		private function enemyCreateHandler():void {
	    	_enemy.graphics.beginFill(0xffffff);
	    	_enemy.graphics.drawRect(0, 0, 80, 20);
	    	_enemy.graphics.endFill();
	    	_enemy.x = stage.stageWidth / 2 - 40;
	    	_enemy.y = 80;
	    	addChild(_enemy);	    	
		}

		// 敵移動先
		private function enemyMoveTimerHandler(event:TimerEvent):void {
			_enemyPos = (Math.random() * stage.stageWidth);
		}

		// 敵機動
		private function enemyEnterFrameHandler(event:Event):void {
			_enemy.x += (_enemyPos - _enemy.x) * 0.1;
			if (_enemy.hitTestObject(_fighter)) enemyHitHandler();
		}
		
		// 敵ミサイル生成
		private function enemyMissileTimerHandler(event:TimerEvent):void {
			if (Math.floor(Math.random() * 2) == 0) {
				var _missile:Sprite = new Sprite();
				_missile.graphics.beginFill(0xffffff);
				_missile.graphics.drawCircle(0, 0, (Math.random()*30) + 10);
				_missile.graphics.endFill();
				_missile.x = _enemy.x + _enemy.width / 2;
				_missile.y = _enemy.y;
				addChild(_missile);
				Tweener.addTween(_missile, { y:_missile.y - 20, time:0.25, transition:"easeOutCirc", onComplete:missileFireHandler, onCompleteParams:[_missile] });
			}
		}
		
		// 敵ミサイル発射
		private function missileFireHandler(_missile:Sprite):void {
			Tweener.addTween(_missile, { x:(Math.random()*1000)-500, y:stage.stageHeight + 50, time:(Math.random()*2)+1.5, transition:"easeInCirc", onUpdate:missileHitHandler, onUpdateParams:[_missile], onComplete:missileRemoveHandler, onCompleteParams:[_missile] });
		}

		// 敵ミサイル終末
		private function missileRemoveHandler(_missile:Sprite):void {
			removeChild(_missile);
		}
		
		// 敵ミサイルヒット
		private function missileHitHandler(_missile:Sprite):void {
			if (_missile.hitTestObject(_fighter)) {				
				Tweener.removeTweens(_missile);
				removeChild(_missile);
				enemyHitHandler();
			}
		}

		// 接触
		private function enemyHitHandler():void {
			_fighter.alpha = 0.5;
			_fighter.y += 50;
			Tweener.addTween(_fighter, { alpha:1, time:0.5, transition:"easeOutCirc" });
			
			_fighterBarrier--;
			if (_fighterBarrier >= 0) removeChild(_barrierPoint[_fighterBarrier]);
			if (_fighterBarrier <= 0) {
				messageHandler("Game Over");
				gameOverHandler();
			}
		}
				
		// ゲームオーバー
		private function gameOverHandler():void {
	    	_enemyMoveTimer.stop();
	    	_enemyMissileTimer.stop();
			stage.removeEventListener(MouseEvent.CLICK, fighterBoostHandler);
			_fighter.removeEventListener(Event.ENTER_FRAME, fighterEnterFrameHandler);
	    	_fighter.y = -500;
			//stage.addEventListener(MouseEvent.CLICK, gameResetHandler);
		}
		
		// ゲームリセット
		private function gameResetHandler(event:MouseEvent):void {
			stage.removeEventListener(MouseEvent.CLICK, gameResetHandler);
			standbyHandler();
		}
		
		// メッセージ
		private function messageHandler(message:String):void {
            _statusText.autoSize = TextFieldAutoSize.LEFT;
            _statusText.textColor = 0xffffff;
			_statusText.text = message;
            _textFormat.font = "Verdana";
            _textFormat.size = 10;
			_statusText.x = stage.stageWidth / 2 - _statusText.width / 2;
			_statusText.y = stage.stageHeight / 2;
            _statusText.defaultTextFormat = _textFormat;
            addChild(_statusText);
		}
	}
}
