/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fTCN
 */

package
{
	import away3d.cameras.TargetCamera3D;
	import away3d.containers.Scene3D;
	import away3d.containers.View3D;
	import away3d.core.base.Object3D;
	import away3d.debug.AwayStats;
	import away3d.lights.PointLight3D;
	import away3d.materials.ShadingColorMaterial;
	
	import caurina.transitions.Tweener;
	
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	import flash.geom.Vector3D;
	import flash.utils.Timer;
	import flash.utils.getTimer;
	
	import jiglib.physics.RigidBody;
	import jiglib.plugin.away3d.Away3DPhysics;
	import jiglib.plugin.away3d.Away3dMesh;
	
	public class Flash extends Sprite
	{
		public static const MAX_ITEMS:int = 30;
		public static const GROUND_SIZE:int = 5000;
		public static const GROUND_HEIGHT:int = 700;
		
		private var _scene:Scene3D;
		private var _camera:TargetCamera3D;
		private var _view:View3D;
		private var _light:PointLight3D;
		
		private var _physics:Away3DPhysics;
		private var _spheres:Vector.<RigidBody>;
		private var count:int = 0;
		
		public function Flash()
		{
			if(stage)
				init();
			else
				addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(event:Event = null):void
		{
			// いつもの
			_scene = new Scene3D();
			_camera = new TargetCamera3D({ y: 700 });
			_view = new View3D({ camera: _camera, scene: _scene, x: stage.stageWidth >> 1, y: stage.stageHeight >> 1 });
			addChild(_view);
			
			// Stats　右クリックからでも出せるから必要ないけど一応
			addChild(new AwayStats(_view));
			
			// ライト生成
			initLights();
			// 物理エンジン
			initJiglib();
			// オブジェクト生成
			initObjects();
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			var timer:Timer = new Timer(500);
			timer.addEventListener(TimerEvent.TIMER, timerHandler);
			timer.start();
		}
		
		private function initLights():void
		{
			_light = new PointLight3D();
			_scene.addLight(_light);
		}
		
		private function initJiglib():void
		{
			_physics = new Away3DPhysics(_view, 10);
		}
		
		private function initObjects():void
		{
			// 地面を作成
			var groundMat:ShadingColorMaterial = new ShadingColorMaterial(randomColor());
			
			// パーリンノイズででこぼこ作成
			var bmpData:BitmapData = new BitmapData(100, 100, true, 0);
			bmpData.lock();
			bmpData.perlinNoise(20, 20, 1, 1, true, false, 7, true);
			bmpData.applyFilter(bmpData, bmpData.rect, new Point(), new GlowFilter(0xffffff, 1, 16, 16, 5, 3, true));
			bmpData.unlock();
			
			// でこぼこ
			var ground:RigidBody = _physics.createTerrain(bmpData, { material: groundMat, width: GROUND_SIZE, height: GROUND_SIZE, segmentsW: 20, segmentsH: 20, maxHeight: GROUND_HEIGHT });
			ground.friction = 0.1;
			ground.restitution = 0.8;
			ground.y = -GROUND_HEIGHT;
			
			_spheres = new Vector.<RigidBody>();
			for(var i:int = 0; i < MAX_ITEMS; i++) {
				var size:Number = 200 * Math.random() + 20;
				var segment:uint = Math.sqrt(size) / 2;
				//　球体のテクスチャ
				var wireFrameMat:ShadingColorMaterial = new ShadingColorMaterial(randomColor());
				var rigidBody:RigidBody = _physics.createSphere({ material: wireFrameMat, radius: size, segmentsW: segment, segmentsH: segment-1 });
				rigidBody.restitution = 0.5;
				rigidBody.friction = 0.5;
				rigidBody.moveTo(new Vector3D(GROUND_SIZE / 2 * (Math.random() - 0.5), 1000, GROUND_SIZE / 2 * (Math.random() - 0.5)));
				_spheres[i] = rigidBody;
			}
		}
		
		private function randomColor():uint
		{
			return (int(Math.random() * 200 + 55) << 16) + (int(Math.random() * 200 + 55) << 8) + int(Math.random() * 200 + 55);            
		}  
		
		private function onEnterFrame(event:Event):void
		{
			// 角度に応じてカメラの位置を設定
			var msec:Number = getTimer();
			_camera.x = _light.x = 1500 * Math.sin(msec / 2000);
			_camera.z = _light.z = 1500 * Math.cos(msec / 2000);
			_camera.y = _light.y = 300 * Math.sin(msec / 2500) + 400;
			_camera.fov = 10 * Math.sin(msec / 3000) + 80;
			
			// 物理演算
			_physics.engine.integrate(0.75);
			
			// こいつ忘れてて何も表示されなかった・・・
			_view.render();
		}
		
		private function timerHandler(e:TimerEvent):void {
			var rigidBody:RigidBody = _spheres[count];
			var sphere:Object3D = (rigidBody.skin as Away3dMesh).mesh as Object3D;
			
			Tweener.addTween(sphere, {
				scaleX: 0,
				scaleY: 0,
				scaleZ: 0,
				time: 0.9,
				transition: "easeInExpo",
				onComplete: function():void {
					sphere.scaleX = sphere.scaleY = sphere.scaleZ = 1;
					var force:Number = (Math.random() - 0.5) * 200;
					rigidBody.moveTo(new Vector3D(0, 2000, 0));
					rigidBody.addBodyForce(new Vector3D(force, 0, force), new Vector3D(force, 0, force));
				}})
			
			count++;
			if(count > _spheres.length - 1)
				count = 0;
		}
	}
}