/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fSlm
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
       public var a:ColTest;
       
        public function FlashTest() {
            
            graphics.clear();
            graphics.lineStyle(2,0);
            //graphics.drawRect(0,0,32,32);
            
     
            a = new ColTest();
            addChild(a);
         
         stage.addEventListener(Event.ENTER_FRAME, onEnter);   
        }
        
        public function onEnter(e:Event):void
        {
            a.onEnter(e);
        }//onenter
        
    }
}
import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;
import flash.geom.Point;



internal class ColTest extends Sprite
{

  public var ray:RayTest;
  public var ob:ColOb;

  public function ColTest()
  {
    ray = new RayTest();
    ob = new ColOb();
    addChild(ob.debSpr);

     var w:Number = 64;
     var h:Number = 16;

    ob.addLine(new Line(-w,-h,w,-h));
    ob.addLine(new Line(-w,h,w,h));
    ob.addLine(new Line(-w,-h,-w,h));
    ob.addLine(new Line( w,-h,w,h));
    
     graphics.clear();
      graphics.lineStyle(2,0);
      graphics.drawRect(0,0,400,400);

    //stage.addEventListener(Event.ENTER_FRAME,onEnter);
  }//coltest

  public function onEnter(e:Event):void
  {
      
      graphics.clear();
      graphics.lineStyle(2,0);
      //graphics.drawRect(0,0,400,400);

    ray.start.x = 30;
    ray.start.y = 30;
    ray.end.x = mouseX; 
    ray.end.y = mouseY;

    ob.cx = 200;
    ob.cy = 200;
    ob.ori += 0.02;

    ray.test(ob);

    ray.draw(graphics);
    ob.draw(ob.debSpr);

    ob.debDraw(graphics);
    
  }//onenter


};//coltest




internal class RayTest
{
  public var start:Point = new Point();
  public var end:Point = new Point();
  public var col:Point = new Point();
  public var t:Number = 0;
  public var bColl:Boolean = false;

  public function RayTest()
  {

  }

  public function test(ob:ColOb):Boolean
  {
    t = ob.lineTest(start, end);

  
    bColl = t >= 0 && t <= 1.0;

    if (bColl)
    {
      col.x = start.x + (end.x - start.x) * t;
      col.y = start.y + (end.y - start.y) * t;
    }
    else
    {
      col.x = end.x;
      col.y = end.y;
    }

    return bColl;
  }//test

  public function draw(g:Graphics):void
  {
    g.moveTo(start.x, start.y);
    g.lineTo(col.x, col.y);
    
    g.drawCircle(col.x, col.y, 4);
  }//draw

};//test


internal class Line
{
  public var v0:Point = new Point();
  public var v1:Point = new Point();

  public function Line(sx:Number,sy:Number, ex:Number, ey:Number)
  {
    v0.x = sx;
    v0.y = sy;
    v1.x = ex;
    v1.y = ey;
  }//ctor

};//line


internal class ColOb
{
        
public var cx:Number = 0;
public var cy:Number = 0;
public var ori:Number = 0;
public var debSpr:Sprite = new Sprite();

public var vecLine:Vector.<Line> = new Vector.<Line>;

public function addLine(a:Line):void
{
  vecLine.push(a);
  
  calcMinMax();
}//addline

public var minx:Number = 0;
public var maxx:Number = 0;
public var miny:Number = 0;
public var maxy:Number = 0;

public var rad:Number = 0;

public function calcMinMax():void
{
    var i:int;
    var num:int;
    var m:Line;
    num = vecLine.length;
    
    minx = 9999999;
    miny = 9999999;
    maxy = -9999999;
    maxx = -9999999;
    
    for (i =0; i < num; i++)
    {
        m = vecLine[i];
        
        if (minx > m.v0.x) { minx = m.v0.x; }
        if (minx > m.v1.x) { minx = m.v1.x; }
        if (maxx < m.v0.x) { maxx = m.v0.x; }
        if (maxx < m.v1.x) { maxx = m.v1.x; }
        
        if (miny > m.v0.y) { miny = m.v0.y; }
        if (miny > m.v1.y) { miny = m.v1.y; }
        if (maxy < m.v0.y) { maxy = m.v0.y; }
        if (maxy < m.v1.y) { maxy = m.v1.y; }
        
    }//nexti
    
    var mag:Number;
    var dx:Number;
    var dy:Number;
    dx = maxx - minx;
    dy = maxy - miny;
    mag = Math.sqrt(dx*dx+dy*dy);
    rad = mag /2;
    
}//calcminmax

public function debDraw(g:Graphics):void
{
    g.lineStyle(1, 0x0000FF);
    g.drawRect(cx+minx,cy+miny, maxx-minx, maxy-miny);
    
    g.lineStyle(1,0xFF0000);
    g.drawCircle(cx,cy, rad);
    
    var r2:Number;
    
    r2 = rad + 16;
    
    g.lineStyle(1,0x00FF00);
    g.drawRect(cx-r2,cy-r2,r2+r2,r2+r2);
    
}//deb

public function draw(s:Sprite):void
{
  var i:int;
  var num:int;
  var m:Line;
  var g:Graphics;

  g = s.graphics;

  num = vecLine.length;

  g.clear();
  g.lineStyle(2,0);

  g.drawCircle(0,0, 4);

  for (i = 0; i < num; i++)
  {
    m = vecLine[i];
    g.moveTo(m.v0.x, m.v0.y);
    g.lineTo(m.v1.x, m.v1.y);    
  }//nexti

  s.x = cx;
  s.y = cy;
  s.rotation = ori * (180 / 3.1415);  

}//draw


public static var vs:Point = new Point();
public static var ve:Point = new Point();
public function lineTest(s:Point, e:Point):Number
{

 var ang:Number;
 var rx:Number;
 var ry:Number;


//transform line into the colob coordinate system

  ang = -ori;  

  rx = s.x - cx;
  ry = s.y - cy;

  vs.x = Math.cos(ang) * rx - Math.sin(ang) * ry;
  vs.y = Math.sin(ang) * rx + Math.cos(ang) * ry;

  rx = e.x - cx;
  ry = e.y - cy;

  ve.x = Math.cos(ang) * rx - Math.sin(ang) * ry;
  ve.y = Math.sin(ang) * rx + Math.cos(ang) * ry;

//go through all lines
  var i:int;
  var num:int;
  var smallt:Number;
  var dist:Number;
  var m:Line;
  smallt = 999;

  num = vecLine.length;

  for (i = 0; i < num; i++)
  {
    m = vecLine[i];

    dist = lineLineInter(vs, ve, m.v0, m.v1);

    if (dist < smallt)
    {
      smallt = dist;
    }
    
  }//nexti

  return smallt;
}//linetest

 public function lineLineInter(v0:Point, v1:Point, v2:Point, v3:Point):Number
         {
             var ua:Number;
             var ub:Number;
             var bot:Number;
             
             bot = ((v3.y-v2.y)*(v1.x-v0.x))-((v3.x-v2.x)*(v1.y-v0.y));
             if (bot == 0) { return 999;}
             
              ua = (((v3.x-v2.x)*(v0.y-v2.y))-((v3.y-v2.y)*(v0.x-v2.x))) / bot;
              ub = (((v1.x-v0.x)*(v0.y-v2.y))-((v1.y-v0.y)*(v0.x-v2.x))) / bot;
              if (ua > 1 || ua < 0 || ub > 1 || ub < 0) { return 999; }
              return ua;

         }//lineline
         

};//classend