/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fSVM
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	/**
	 * Main
	 * メインクラス.
	 */
	public class Main extends Sprite {
		private var ball:Ball;
		private var handles:Array;
		private var spring:Number = 0.1;
		private var friction:Number = 0.8;
		//ハンドルの数
		private var numHandles:Number = 10;
		/**
		 * コンストラクタ.
		 */
		public function Main() {
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void {
			//ボール生成
			ball = new Ball(20);
			addChild(ball);

			handles = new Array();
			//指定のハンドル数だけ繰り返す
			for (var i:uint = 0; i < numHandles; i++) {
				//ハンドル生成
				var handle:Ball = new Ball(15, 0x666666);
				//初期位置をランダムに
				handle.x = Math.random() * stage.stageWidth;
				handle.y = Math.random() * stage.stageHeight;
				//リスナー登録
				handle.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
				//表示
				addChild(handle);
				//配列に追加
				handles.push(handle);
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			addEventListener(MouseEvent.MOUSE_UP, onRelease);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void {
			//ハンドルの数だけ繰り返す
			for (var i:uint = 0; i < numHandles; i++) {
				//ハンドルの参照を設定
				var handle:Ball = handles[i] as Ball;
				var dx:Number = handle.x - ball.x;
				var dy:Number = handle.y - ball.y;
				//ボールにスプリングの加速を加える
				ball.vx += dx * spring;
				ball.vy += dy * spring;
			}
			//減速
			ball.vx *= friction;
			ball.vy *= friction;
			//ボールの座標に適応
			ball.x += ball.vx;
			ball.y += ball.vy;
			//線を描く
			graphics.clear();
			graphics.lineStyle(1);
			for (i = 0; i < numHandles; i++) {
				graphics.moveTo(ball.x, ball.y);
				graphics.lineTo(handles[i].x, handles[i].y);
			}
		}
		/**
		 * onPress.
		 */
		private function onPress(event:MouseEvent):void {
			//ドラッグ開始
			event.target.startDrag();
		}
		/**
		 * onRelease.
		 */
		private function onRelease(event:MouseEvent):void {
			//ドラッグ停止
			event.target.stopDrag();
		}
	}
}



/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}