/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fSRJ
 */

// forked from checkmate's fladdict challenge for amateurs
/**
 * Every frame you get screen caputre of the stage.
 * Generate new frame image with using last frames screen capture.
 * This is a starting point of recursive generative art.
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    public class Beginner extends Sprite {
        /**
         * Overwrite this update function.
         * Every frame the function is invoked with two bitmaps.
         * First one contains reference to the stage bitmap.
         * Second one contains static copy of stage.
         */
         
        public var canvas:BitmapData;
        public var drawHere:BitmapData;
        public var mat:Matrix;

        private const BLUR:BlurFilter = new BlurFilter(4, 4, BitmapFilterQuality.LOW);
		
        private var ballCanvas:Shape = new Shape();
        private var radian:Number = 0;

        private var ballBuideX:Number = 240;
        private var ballBuideY:Number = 240;
        private var vX:Number = 0;
        private var vY:Number = 0;
        private const SPRING:Number = 0.012;
        private const FRICTION:Number = 0.89;
		
        private var hFlg:Number = 0;
        private var cnt:int = 0;
         
        
        public function update():void{
            hFlg = -(stage.mouseX - 240) / 240;

            drawStep();
            fadeStep();
            transformStep();
            renderStep();
        }
        
        
        public function drawStep():void {
            calcPoint();
            drawBall();
            drawHere.draw(ballCanvas);
        }
        private function calcPoint():void {
            var nowX:Number = stage.mouseX;
            var nowY:Number = stage.mouseY;
            vX += (nowX - ballBuideX) * SPRING;
            vY += (nowY - ballBuideY) * SPRING;
            vX *= FRICTION;
            vY *= FRICTION;
            ballBuideX += vX;
            ballBuideY += vY;
        }
        private function drawBall():void {
            ballCanvas.graphics.clear();
            ballCanvas.graphics.beginFill(hsvToRgb(cnt += 3, 1, 1));
            ballCanvas.graphics.drawCircle(ballBuideX, ballBuideY, 50);
            ballCanvas.graphics.endFill();
        }
        private static function hsvToRgb(h:Number = 0.0, s:Number = 1.0, v:Number = 1.0):uint {
            // h : 0.0 to 360.0
            // s : 0.0 to 1.0
            // v : 0.0 to 1.0
            var r:uint = 0;
            var g:uint = 0;
            var b:uint = 0;
	
            // 各引数を許可範囲に収める
            h %= 360;
            if (h < 0)
                h += 360;
            h /= 60;
            s = Math.max(0, Math.min(s, 1.0));
            v = Math.max(0, Math.min(v, 1.0));
            v *= 0xFF;
	
            if (s == 0) {
                r = g = b = v;
            } else {
                var hi:uint = Math.floor(h % 6);
                var f:Number = h - hi;
                var p:Number = v * (1 - s);
                var q:Number = v * (1 - s * f);
                var t:Number = v * (1 - s * (1 - f));
		
                switch(hi) {
                    case 0: {
                        r = v;
                        g = t;
                        b = p;
                        break;
                    }
                    case 1: {
                        r = q;
                        g = v;
                        b = p;
                        break;
                    }
                    case 2: {
                        r = p;
                        g = v;
                        b = t;
                        break;
                    }
                    case 3: {
                        r = p;
                        g = q;
                        b = v;
                        break;
                    }
                    case 4: {
                        r = t;
                        g = p;
                        b = v;
                        break;
                    }
                    case 5: {
                        r = v;
                        g = p;
                        b = q;
                        break;
                    }
                }
            }
	
            return r << 16 | g << 8 | b;
        }
    
        
        public function transformStep():void {
            mat = new Matrix();
            mat.translate(-240,-240);
            mat.scale(1.03, 1.03);
            mat.rotate(Math.PI / 180 * hFlg);
            mat.translate(240, 240);
        }
        
        
        public function renderStep():void{
            canvas.draw(drawHere, mat);
        }
        
        
        public function fadeStep():void {
            drawHere.applyFilter(drawHere, drawHere.rect, new Point(), BLUR);
        }
        
        
        /**
         * ---------------------------------------
         * DO NOT CHANGE FOLLOWING CODES
         * DO NOT ACCESS FOLLOWING PROPERTIES DIRECTLY
         * ---------------------------------------
        */
        
       
        private var bitmap:Bitmap;
        
        
        public function Beginner() {
            canvas = new BitmapData(480,480,false,0x000000);
            bitmap = new Bitmap(canvas);
            addChild(bitmap);
            addEventListener(Event.ENTER_FRAME, _update);
        }
        
        public function _update(e:Event):void{
            if(drawHere)
                drawHere.dispose();
            drawHere = canvas.clone();
            update();
        }
    }
}
