/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fSBM
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    
    public class InvertingIn5DifferentWays extends Sprite {
        
        private var baseMap:BitmapData;
        private var mode:int = 0;
        private var totalModes:int = 5;
        
        
        public function InvertingIn5DifferentWays () {
            init();
        }
        
        private function init():void
        {
            baseMap = new BitmapData( 400, 400, false, 0 );
            baseMap.perlinNoise( 64, 64, 1, 0xbada55, false, false, 1, true );
            addChild( new Bitmap( baseMap ) );
            stage.addEventListener( KeyboardEvent.KEY_DOWN, nextMode )
        }
        
        private function nextMode( event:KeyboardEvent ):void
        {
            switch ( mode )
            {
                case 0:  
                    baseMap.colorTransform( baseMap.rect, new ColorTransform(-1, -1, -1, 1, 255, 255, 255, 0) );
                break; 
                
                case 1:
                    var tmp:BitmapData = new BitmapData( baseMap.width, baseMap.height, false, 0xffffff );
                    baseMap.draw( tmp, null, null, "difference");
                break; 
                
                case 2:  
                    baseMap.applyFilter( baseMap, baseMap.rect, baseMap.rect.topLeft,  new ColorMatrixFilter([-1,0,0,0,255, 0,-1,0,0,255,0,0,-1,0,255,0,0,0,1,0]  ) );
                break; 
                
                 case 3:  
                    baseMap.applyFilter( baseMap, baseMap.rect, baseMap.rect.topLeft,  new ConvolutionFilter(1, 1, [-1], 0, 255));
                break; 
                
                case 4:
                     var r:Array= [];
                     var g:Array= [];
                     var b:Array= [];
                     for ( var i:int = 256; --i >-1;)
                     {
                      r[255-i] = i << 16;
                      g[255-i] = i << 8;
                      b[255-i] = i;
                         
                     }
                      baseMap.paletteMap( baseMap, baseMap.rect, baseMap.rect.topLeft, r, g, b, null)
                break;
                
                
                  
            }
                
                
            
             mode = (mode+1) % totalModes;   
        }
        
    }
}