/**
 * Copyright stenpel ( http://wonderfl.net/user/stenpel )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fQik
 */

// forked from stenpel's [Tweener]拡大
package 
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import caurina.transitions.Tweener;
	import flash.media.Video;

	import flash.text.TextField;
	import flash.text.TextFormat;
	public class Main extends Sprite 
	{
		private const N:Number = 10;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			for (var i:int = 0; i < N; i++) 
			{
				var obj:Shape = new Shape();
				obj.graphics.beginFill(0);
				obj.graphics.drawCircle(0, 0, 10);
				obj.graphics.endFill();
				obj.x = stage.stageWidth * Math.random();
				obj.y = stage.stageHeight * Math.random();
				addChild(obj);
			}
			stage.addEventListener(MouseEvent.CLICK, onClickStage);
		}
		
		private function onClickStage(e:MouseEvent):void 
		{
			//trace("click stage " + this.x);
			var easeVal_x:Number = e.stageX - stage.stageWidth / 2;
			var easeVal_y:Number = e.stageY - stage.stageHeight / 2;
			var tf:TextField = new TextField();
			var format:TextFormat = new TextFormat();
			
			format.size = 10;
			format.color = 0xFF3399;
			tf.defaultTextFormat = format;
			tf.autoSize = "left";
			tf.text = "DREGS";
			tf.x = e.stageX - tf.width / 2;
			tf.y = e.stageY - tf.height / 2;
			addChild(tf);
			
			Tweener.addTween(this, { scaleX:2, scaleY:2, x: 2*(this.x-easeVal_x)-((stage.stageWidth)/2), y: 2*(this.y-easeVal_y)-((stage.stageHeight)/2), time:.8, transition:"easeNone", onComplete:afterTween});
		}
		
		private function afterTween():void {
			Tweener.addTween(this, { scaleX:1, scaleY:1, x:0, y:0, time:0.8, transition:"easeNone" } );
		}
	}
	
}