/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fQ7T
 */

// forked from sakusan393's TundereButton
package {
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.filters.BevelFilter;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import frocessing.shape.FShapeSVG;
    import jp.progression.commands.lists.LoaderList;
    import jp.progression.commands.lists.LoopList;
    import jp.progression.commands.lists.SerialList;
    import jp.progression.commands.net.LoadSound;
    import jp.progression.commands.Prop;
    import jp.progression.commands.Stop;
    import jp.progression.data.getResourceById;
    
    [SWF(width = "465", height = "465", frameRate = "30")];
    
    public class TundereButton extends Sprite {
        private var _sec:int;
        private var _shpSec:Shape;
        private var _shpMin:Shape;
        private var _shpHour:Shape;
        private var _pathCommands:Vector.<int> = Vector.<int>([1,2,2,2,2]);
        private var _dataVector:Vector.<Sprite> = new Vector.<Sprite>(17);
        private var _eyeWhiteVector:Vector.<Sprite> = new Vector.<Sprite>(2);
        private var _eyeWhitePositionXVector:Vector.<int> = Vector.<int>([53,364]);
        private var _eyeWhitePositionYVector:Vector.<int> = Vector.<int>([277,272]);
        private var _eyeBlackPositionXVector:Vector.<int> = Vector.<int>([54,363]);
        private var _eyeBlackPositionYVector:Vector.<int> = Vector.<int>([278,271]);
        private var _mayuPositionXVector:Vector.<int> = Vector.<int>([40,387]);
        private var _mayuPositionYVector:Vector.<int> = Vector.<int>([167,147]);
        private var _secCount:Number = 0;
        private var _eyeBlackVector:Vector.<Sprite> = new Vector.<Sprite>(2);
        private var _mayuVector:Vector.<Sprite> = new Vector.<Sprite>(2);
        private var _soundChannel:SoundChannel;
        private var _isMouseOver:Boolean;
        private static const TUN:String = "http://393.bz/data/tun.mp3";
        private static const DELE:String = "http://393.bz/data/dere.mp3";
        private var _tf:TextField;
        
        public function TundereButton() {
            stage.align = StageAlign.TOP_LEFT;
            
            addChild(_tf = createTF());
            loadSound();
        }
        private function createTF():TextField
        {
            var tf:TextField = new TextField();
            var tfm:TextFormat = new TextFormat("Verdana", 20, 0);
            tf.defaultTextFormat = tfm;
            tf.autoSize = "left";
            return tf;
        }
        
        private function loadSound():void
        {
            var sList:SerialList = new SerialList();
            sList.addCommand(
                new LoaderList( {
                    onProgress:function():void 
                    {
                        trace(this.percent);
                        _tf.text = "sound loading...";
                        _tf.visible = !_tf.visible;
                    }
                    ,onComplete:function():void
                    {
                        trace("comp");
                        _tf.visible = true;
                        _tf.text = "Please Turn The Volume Up";
                        initSVG();
                        
                        var timer:Timer = new Timer(100);
                        timer.addEventListener(TimerEvent.TIMER, onTimer);
                        timer.start();
                        updateView(0, 7, 0);
                    }
                }
                ,new LoadSound(new URLRequest(TundereButton.TUN))
                ,new LoadSound(new URLRequest(TundereButton.DELE))
                )
            )
            sList.execute();
            
        }
        
        private function initSVG():void
        {
            var button:Sprite =  new Sprite();
            addChild(button);
            button.addEventListener(MouseEvent.ROLL_OVER, rollOverHandler);
            button.addEventListener(MouseEvent.ROLL_OUT, rollOutHandler);
            button.addEventListener(MouseEvent.CLICK, clickHandler);
            button.buttonMode = true;
            
            var buttonContainer:Sprite = new Sprite();
            button.addChild(buttonContainer);
            var mask:Sprite = new Sprite();
            mask.graphics.beginFill(0);
            mask.graphics.drawRect(0, 110, 465, 285);
            mask.graphics.endFill();
            buttonContainer.mask = mask;
            button.addChild(mask);
            
            button.scaleX = 0.4;
            button.scaleY = 0.4;
            button.filters = [new BevelFilter(3, 45, 0xFFCCcc, 1, 0x330000, 1, 4, 4, 1, 2)];
            button.x = stage.stageWidth / 2 - button.width / 2;
            button.y = stage.stageHeight / 2 - button.height;
            
            var shapedata:FShapeSVG = new FShapeSVG(SVGData.svgXML);
            //Spriteに変換
            
            //描画データを個別にスプライトに収納
            var i:int;
            var dataLength:int = SVGData.svgXML.*.length();
             /* データ内訳
             * 0：顔色
             * 1：左目マスク
             * 2：左目枠
             * 3：左目黒（時針）
             * 4：右目マスク
             * 5：右目枠
             * 6：右目黒（時針）
             * 7：鼻
             * 8：ほほ
             * 9：髪
             * 10：左眉
             * 11：右眉
             * 12：左白目（分針)
             * 13：右白目（分針）
             * 14：右半目（秒針）
             * 15：左半目（秒針）
             * 16：右閉じ目（秒針）
             * 17：左閉じ目（秒針
             * */
            for (i = 0; i < dataLength ; i++) 
            {
                _dataVector[i] = shapedata.getChildAt(i).toSprite();
                if (i == 12 || i == 13 || i == 3 || i== 6)
                {
                }else
                {
                    buttonContainer.addChild(_dataVector[i]);
                }
            }
            
            for (i = 0; i < 2; i++) {
                //黒目の座標をオブジェクトの中心に
                _eyeBlackVector[i] = new Sprite();
                _eyeBlackVector[i].addChild(_dataVector[i * 3 + 3]);
                buttonContainer.addChildAt(_eyeBlackVector[i], 3 * i + 3);
                
                _dataVector[i * 3 + 3].x = -_eyeBlackPositionXVector[i];
                _dataVector[i * 3 + 3].y = -_eyeBlackPositionYVector[i];
                _eyeBlackVector[i].x = _eyeBlackPositionXVector[i];
                _eyeBlackVector[i].y = _eyeBlackPositionYVector[i];
                _eyeBlackVector[i].mask = _dataVector[i * 3 + 1];
                
                //白目の座標をオブジェクトの中心に
                _eyeWhiteVector[i] = new Sprite();
                _eyeWhiteVector[i].addChild(_dataVector[i+12]);
                _eyeBlackVector[i].addChild(_eyeWhiteVector[i]);
                
                _dataVector[i+12].x = -_eyeWhitePositionXVector[i];
                _dataVector[i + 12].y = -_eyeWhitePositionYVector[i];
                //眉をオブジェクトの中心に
                _mayuVector[i] = new Sprite();
                _mayuVector[i].addChild(_dataVector[i + 10]);
                buttonContainer.addChildAt(_mayuVector[i], 10);
                
                _dataVector[i+10].x = -_mayuPositionXVector[i];
                _dataVector[i + 10].y = -_mayuPositionYVector[i];
                _mayuVector[i].x = _mayuPositionXVector[i];
                _mayuVector[i].y = _mayuPositionYVector[i];    
            }
            _dataVector[7].x =80;
            _dataVector[7].scaleX = 0.6;
        }
        
        private function clickHandler(e:MouseEvent):void 
        {
            if(_soundChannel) _soundChannel.stop();
            _soundChannel = Sound(getResourceById( TundereButton.DELE ).data).play();
        }
        
        private function rollOutHandler(e:MouseEvent):void 
        {
            _isMouseOver = false;
            updateView(0, 7, 0);
        }
        
        private function rollOverHandler(e:MouseEvent):void 
        {
            _isMouseOver = true;
            updateView(0, 22, 0);
        }
        
        private function drawTrapezium($graphics:Graphics, $right:Number, $top:Number, $left:Number, $bottom:Number):void {
            $graphics.drawPath(_pathCommands, Vector.<Number>([
                $left, $bottom, -$left, $bottom, -$right, $top, $right, $top, $left, $bottom
            ]));
        }
        
        private function onTimer(e:TimerEvent):void {
            var time:Date = new Date;
            var sec:int = time.getSeconds();
            if (_sec == sec) return;
            _sec = sec;
            //瞬き処理
            //秒で瞬き
            var count:int = 0;
            if (_sec % 5 == 0) {
                count = 1;
                if(!_isMouseOver) {
                    
                    if(_soundChannel) _soundChannel.stop();
                    _soundChannel = Sound(getResourceById( TundereButton.TUN ).data).play();
                }

            }
            var sList:LoopList = new LoopList();
            sList.addCommand(
                new Prop(_dataVector[14],{visible:false})
                ,new Prop(_dataVector[15],{visible:false})
                ,new Prop(_dataVector[16],{visible:false})
                ,new Prop(_dataVector[17],{visible:false})
                ,function():void
                {
                    _dataVector[14].visible =  true;
                    _dataVector[15].visible =  true;
                }
                ,0.03
                ,function():void
                {
                    _dataVector[16].visible =  true;
                    _dataVector[17].visible =  true;
                }
                ,0.04
                ,function():void
                {
                    _dataVector[16].visible =  false;
                    _dataVector[17].visible =  false;
                }
                ,0.02
                ,function():void
                {
                    _dataVector[14].visible =  false;
                    _dataVector[15].visible =  false;
                }
                ,new Stop(count)
            )
            sList.execute();
            
        }
        
        private function updateView($hour:int, $min:int, $sec:int):void {
            var degree:Number = $min * 6;
            
            //時で黒目回転
            //→20100713変更：時で黒目の白回転
            _eyeWhiteVector[0].rotation = ($hour % 12) * 30 + $min / 2;
            _eyeWhiteVector[1].rotation = ($hour % 12) * 30 + $min / 2;
            
            
            //分で黒目の白回転
            //→20100713変更：分で黒目回転
            var rad:Number = (degree-90) * Math.PI / 180;
            _eyeBlackVector[0].x = 20*Math.cos(rad) + _eyeBlackPositionXVector[0];
            _eyeBlackVector[0].y = 20*Math.sin(rad) + _eyeBlackPositionYVector[0];
            _eyeBlackVector[1].x = 30*Math.cos(rad) + _eyeBlackPositionXVector[1];
            _eyeBlackVector[1].y = 30*Math.sin(rad) + _eyeBlackPositionYVector[1];
            
            
            //時で眉毛の角度変更
            //0度：ツン状態
            //180度：デレ状態
            //90度、270度：平常状態
            if (degree > 180) degree = 180 - degree % 180;
            var rotationL:Number = (degree -90) / 90 * -25;
            var rotationR:Number = (degree -90) / 90 * 20;
            _mayuVector[0].rotation = rotationL;
            _mayuVector[1].rotation = rotationR;
            
            //出れ状態でチークが赤くなる
            //90度：アルファ0
            //180度：アルファ1
            //270度：アルファ0
            _dataVector[8].alpha = (degree-90) / 90;
        }
    }
}
class SVGData {
    
    public static var svgXML:XML = 
                    <svg version="1.1" id="レイヤー_2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px"
                         y="0px" width="465px" height="465px" viewBox="0 0 465 465" enable-background="new 0 0 465 465">
                    <rect id="face" x="-8" y="-9" fill="#FFF2D2" width="480" height="486"/>
                    <path id="leftEyeMask" fill="#FFFFFF" d="M99.841,242.097l-28.932-19.523l-24.733-8.754l-33.158,28.942l-20.014,24.7l0.384,20.566l8.708,9.944c0,0,19.313,32.408,26.123,35.354c6.905,2.986,18.178,4.171,32.488,2.078c14.631-2.145,35.89-7.502,38.141-14.32C101.093,314.279,102.389,247.98,99.841,242.097z"/>
                    <g id="leftEye">
                        <path id="leftEyeWhite" fill="#FFFFFF" d="M99.841,242.097l-28.932-19.523l-24.733-8.754l-33.158,28.942l-20.014,24.7l0.384,20.566l8.708,9.944c0,0,19.313,32.408,26.123,35.354c6.905,2.986,18.178,4.171,32.488,2.078c14.631-2.145,35.89-7.502,38.141-14.32C101.093,314.279,102.389,247.98,99.841,242.097z"/>
                        <path id="leftEyeWaku" d="M-3.359,259.762c6.699-5.934,33.824-49.342,47.519-51.026c14.014-1.724,50.384,24.786,58.184,27.172c-14.842-3.092-11.387-2.785-15.209-5.229c8.28,8.553,10.622,10.004,14.713,13.477c-10.013-3.026-37.337-29.326-54.182-25.518c-16.417,3.71-45.833,44.991-50.062,51.091c-1.332,11.231,2.454,25.401,6.503,32.35c-5.655-2.064-8.381-8.329-10.719-14.052c-0.678-1.658-13.532-11.011-12.376-10.662c3.365,1.021,8.854,0.099,8.346-2.715c-0.548-3.029-5.361-3.265-8.261-8.063c-4.049-6.698-4.517-7.412-4.376-15.248C-17.763,257.508-8.173,264.025-3.359,259.762z"/>
                        <path id="leftEyeWakuUnder" d="M95.337,323.097c-4.277,1.612-18.097,7.101-22.877,7.813c-4.744,0.708-38.737,2.115-41.532,0.737c-2.779-1.366-7.532-5.844-9.078-5.702c-1.543,0.144-2.298-0.699,0.21,1.969c2.525,2.683,5.745,5.401,8.144,6.628c2.409,1.231,37.74,4.357,41.74,3.428c4.021-0.934,16.186-4.07,17.449-5.72C90.656,330.598,95.337,323.097,95.337,323.097z"/>
                    </g>
                    <g id="leftEyeBlack">
                        <path id="leftEyeInnerBlack" d="M19.915,278.182c0.911,27.639,16.835,50.562,35.982,50.515c19.648-0.049,34.358-24.132,32.434-53.043c-1.871-28.11-18.793-49.258-37.419-47.956C32.738,228.967,19.027,251.273,19.915,278.182z"/>
                        
                            <linearGradient id="leftEyeInnerBlackBrown_1_" gradientUnits="userSpaceOnUse" x1="1196.3145" y1="231.2275" x2="1196.5178" y2="325.0617" gradientTransform="matrix(-1 0 0 1 1250.4766 0)">
                            <stop  offset="0" style="stop-color:#8B5C00"/>
                            <stop  offset="0.247" style="stop-color:#6C4600"/>
                            <stop  offset="0.5634" style="stop-color:#4A2D00"/>
                            <stop  offset="0.8258" style="stop-color:#351E00"/>
                            <stop  offset="1" style="stop-color:#2E1900"/>
                        </linearGradient>
                        <path id="leftEyeInnerBlackBrown" fill="url(#leftEyeInnerBlackBrown_1_)" d="M22.442,278.088c0.873,25.522,15.603,46.609,33.253,46.519c18.075-0.093,31.61-22.249,29.877-48.851c-1.69-25.924-17.271-45.5-34.477-44.34C34.276,232.549,21.591,253.191,22.442,278.088z"/>
                        <path id="leftEyeInnerBlackBlack" d="M35.599,277.603c0.593,14.575,9.079,26.391,19.069,26.201c10.124-0.192,17.719-12.607,16.849-27.528c-0.856-14.705-9.621-26.03-19.466-25.494C42.333,251.311,35.015,263.234,35.599,277.603z"/>
                    </g>
                    <path id="rightEyeMask" fill="#FFFFFF" d="M293.835,229.719l40.677-20.21l37.002-9.007l51.77,36.051l31.806,30.845l-1.379,23.844l-14.363,10.232c0,0-30.791,33.09-41.114,35.201c-10.324,2.112-26.869,1.607-47.445-2.776c-20.576-4.386-49.75-12.886-52.985-20.181C294.565,306.423,290.527,235.981,293.835,229.719z"/>
                    <g id="rightEye">
                        <path id="rightEyeWhite" fill="#FFFFFF" d="M293.835,229.719l40.677-20.21l37.002-9.007l51.77,36.051l31.806,30.845l-1.379,23.844l-14.363,10.232c0,0-30.791,33.09-41.114,35.201c-10.324,2.112-26.869,1.607-47.445-2.776c-20.576-4.386-49.75-12.886-52.985-20.181C294.565,306.423,290.527,235.981,293.835,229.719z"/>
                        <path id="rightEyeWakuUnder" d="M302.589,316.25c5.837,2.23,24.923,9.817,31.585,11.238c6.661,1.421,55.834,8.006,60.014,6.964c4.179-1.041,11.414-5.155,13.764-4.767c2.348,0.389,3.517-0.412-0.35,2.104c-3.866,2.514-8.75,4.939-12.355,5.879c-3.605,0.938-54.628-1.22-60.232-2.78c-5.603-1.563-22.361-6.553-24.119-8.424C309.134,324.594,302.589,316.25,302.589,316.25z"/>
                        <path id="rightEyeWaku" d="M449.39,257.986c-10.752-7.6-53.39-60.862-74.777-63.405c-21.389-2.542-73.687,25.992-84.456,28.178c20.674-2.563,15.799-2.422,21.139-4.934c-11.404,9.021-14.617,10.473-20.159,14.018c13.822-2.673,52.693-30.948,78.106-25.757c25.41,5.189,71.55,55.933,78.233,63.482c1.787,13.181-4.782,28.949-11.444,36.273c9.086-1.569,13.683-8.337,17.679-14.601c1.164-1.825,22.819-11.177,20.864-10.899c-5.656,0.802-14.701-0.908-13.753-4.135c1.027-3.484,9.035-3.234,14.114-8.592c7.174-7.567,8.003-8.376,8.165-17.816C473.435,256.693,457.158,263.48,449.39,257.986z"/>
                    </g>
                    <g id="rightEyeBlack">
                        <ellipse id="rightEyeInnerBlack" cx="363.523" cy="270.84" rx="47.034" ry="55.072"/>
                        
                            <linearGradient id="rightEyeInnerBlackBrown_1_" gradientUnits="userSpaceOnUse" x1="363.4131" y1="219.8643" x2="363.6348" y2="322.1598">
                            <stop  offset="0" style="stop-color:#8B5C00"/>
                            <stop  offset="0.247" style="stop-color:#6C4600"/>
                            <stop  offset="0.5634" style="stop-color:#4A2D00"/>
                            <stop  offset="0.8258" style="stop-color:#351E00"/>
                            <stop  offset="1" style="stop-color:#2E1900"/>
                        </linearGradient>
                        <ellipse id="rightEyeInnerBlackBrown" fill="url(#rightEyeInnerBlackBrown_1_)" cx="363.523" cy="270.84" rx="43.403" ry="50.82"/>
                        <ellipse id="rightEyeInnerBlackBlack" cx="363.523" cy="270.84" rx="24.702" ry="28.924"/>
                    </g>
                    <g id="nose">
                        <path id="leftNose" opacity="0.44" d="M172.067,422.251c0,0,10.469-4.865,16.37-2.42c4.655-0.876,7.63-1.267,5.907-4.901c-1.723-3.634-6.826-2.734-11.725-0.724C177.721,416.216,172.067,422.251,172.067,422.251z"/>
                        <path id="rightNose" opacity="0.44" d="M132.851,422.114c0,0-4.802-3.726-7.131-2.664c-2.042-0.872-3.333-1.326-2.866-3.416c0.468-2.089,2.702-1.17,4.929,0.411C130.009,418.025,132.851,422.114,132.851,422.114z"/>
                    </g>
                    <g id="cheek">
                        <path id="rightCheek" opacity="0.37" fill="#E27676" d="M349.22,402.55c-0.593,0-1.187-0.105-1.754-0.318c-1.396-0.522-2.486-1.642-2.973-3.051c-3.387-9.813-3.782-20.525-4.164-30.887c-0.19-5.157-0.374-10.122-0.896-14.891c-14.956,9.027-27.17,24.343-37.212,36.934c-1.723,2.16-4.868,2.513-7.026,0.792c-2.159-1.722-2.514-4.868-0.792-7.026c12.006-15.054,26.947-33.787,46.813-42.961c1.388-0.642,2.994-0.612,4.357,0.08c1.364,0.691,2.337,1.97,2.64,3.47c1.53,7.578,1.824,15.537,2.108,23.234c0.275,7.478,0.54,14.648,1.846,21.286c4.393-3.971,8.066-9.128,11.894-14.499c5.092-7.146,10.356-14.536,17.831-19.688c2.059-1.42,4.849-1.1,6.532,0.747c4.849,5.318,7.558,11.998,10.178,18.459c1.426,3.517,2.804,6.913,4.467,10.009c0.361-0.488,0.731-0.989,1.105-1.496c9.099-12.331,16.17-21.146,23.25-21.146c0.106,0,0.213,0.002,0.318,0.006c7.366-0.45,11.057,6.077,13.514,10.424c0.635,1.123,1.524,2.696,2.191,3.545c0.415-0.311,1.054-0.872,1.923-1.865c1.818-2.077,4.976-2.288,7.056-0.468c2.077,1.819,2.287,4.978,0.468,7.056c-1.319,1.506-5.327,6.09-10.56,5.557c-5.043-0.518-7.562-4.973-9.783-8.903c-1.232-2.179-3.064-5.484-4.29-5.356c-0.246,0.023-0.494,0.03-0.74,0.017c-3.413,0.964-12.035,12.648-15.301,17.073c-2.487,3.371-4.452,6.034-5.953,7.571c-0.998,1.021-2.39,1.573-3.81,1.501c-1.427-0.066-2.756-0.739-3.654-1.849c-4.416-5.457-6.984-11.791-9.469-17.916c-1.716-4.232-3.363-8.296-5.501-11.729c-4.274,3.936-7.87,8.981-11.628,14.257c-5.689,7.985-11.573,16.243-20.495,21.369C350.943,402.326,350.084,402.55,349.22,402.55z"/>
                        <path id="leftCheek" opacity="0.37" fill="#E27676" d="M3.005,394.001c-0.36,0-0.724-0.039-1.089-0.12c-2.696-0.599-4.396-3.27-3.796-5.966c5.249-23.617,15.521-38.451,26.161-37.752c7.834,0.503,13.067,8.309,15.604,23.235c6.256-5.144,13.245-12.544,18.706-22.756c0.977-1.827,2.977-2.862,5.036-2.604c2.056,0.26,3.738,1.761,4.23,3.773c0.438,1.791,0.875,3.659,1.324,5.571c0.78,3.331,1.573,6.717,2.44,10.02c2.875-4.393,5.583-8.613,7.888-13.327c1.212-2.479,4.206-3.508,6.688-2.296c2.48,1.213,3.508,4.207,2.295,6.688c-2.774,5.674-5.912,10.459-9.235,15.525c-1.635,2.493-3.327,5.072-4.99,7.795c-1,1.637-2.845,2.561-4.759,2.368c-1.909-0.188-3.542-1.453-4.202-3.254c-1.751-4.775-3.174-10.078-4.427-15.202c-7.385,10.017-15.75,16.754-22.141,20.937c-1.469,0.962-3.335,1.081-4.916,0.317c-1.58-0.765-2.644-2.302-2.802-4.05c-1.657-18.301-5.993-22.674-7.381-22.763c-2.614-0.137-10.928,8.204-15.758,29.942C7.363,392.415,5.296,394.001,3.005,394.001z"/>
                    </g>
                    <g id="Hair">
                        <path id="leftHairShadow" fill="#FFD6C0" d="M120.679,23.567c0,0,0.349,7.133-52.303,60.843c-52.652,53.711-31.277,122.349-31.277,122.349S-38,140.501-51,75.501S-53-29-53-29l70.828-26.757l112.3,17.037L207-27.296C207-27.296,141.357,11.135,120.679,23.567z"/>
                        <linearGradient id="leftHair_1_" gradientUnits="userSpaceOnUse" x1="-75.3462" y1="75.501" x2="189" y2="75.501">
                            <stop  offset="0" style="stop-color:#ED1E79"/>
                            <stop  offset="1" style="stop-color:#FF7BAC"/>
                        </linearGradient>
                        <path id="leftHair" fill="url(#leftHair_1_)" d="M102.679,23.567c0,0,0.349,7.133-52.303,60.843c-52.652,53.711-31.277,122.349-31.277,122.349S-56,140.501-69,75.501S-71-29-71-29l70.828-26.757l112.3,17.037L189-27.296C189-27.296,123.357,11.135,102.679,23.567z"/>
                        <path id="rightHairShadow" fill="#FFD6C0" d="M115.669,21.862c0,0,3.378,51.064,23.275,108.781c19.896,57.716,54.845,119.251,83.359,138.923c28.514,19.669,57.879,52.109,57.879,52.109s-23.663-121.624-13.904-154.52c9.759-32.896,45.307-100.282,45.307-100.282s45.849,96.519,54.773,106.64c31.98,36.268,76.402,56.578,76.402,56.578l70.461,34.764L473.209,169.2l-2.17-69.142c0,0,13.978,45.671,28.045,68.083c14.067,22.41,86.838,57.781,106.454,66.965s42.856,17.835,13.814-36.236c-29.042-54.069,9.451-244.938,9.451-244.938l-503.512,5.67L115.669,21.862z"/>
                        <linearGradient id="rightHair_1_" gradientUnits="userSpaceOnUse" x1="94.6694" y1="123.8037" x2="612.041" y2="123.8037">
                            <stop  offset="0" style="stop-color:#FF7BAC"/>
                            <stop  offset="0.247" style="stop-color:#F95C9B"/>
                            <stop  offset="0.5634" style="stop-color:#F23A88"/>
                            <stop  offset="0.8258" style="stop-color:#EE257D"/>
                            <stop  offset="1" style="stop-color:#ED1E79"/>
                        </linearGradient>
                        <path id="rightHair" fill="url(#rightHair_1_)" d="M94.669,7.862c0,0,3.378,51.064,23.275,108.781c19.896,57.716,54.845,119.251,83.359,138.923c28.514,19.669,57.879,52.109,57.879,52.109s-23.663-121.624-13.904-154.52c9.759-32.896,45.307-100.282,45.307-100.282s45.849,96.519,54.773,106.64c31.98,36.268,76.402,56.578,76.402,56.578l70.461,34.764L452.209,155.2l-2.17-69.142c0,0,13.978,45.671,28.045,68.083c14.067,22.41,86.838,57.781,106.454,66.965s42.856,17.835,13.814-36.236c-29.042-54.069,9.451-244.938,9.451-244.938l-503.512,5.67L94.669,7.862z"/>
                    </g>
                    <path id="leftMayu" fill="#412700" d="M113.762,162.111c-11.643-10.626-45.896-17.449-55.21-17.15c-9.169,0.292-30.521,7.946-45.73,15.656c-14.93,7.568-51.481,30.038-46.314,27.952c5.204-2.102,30.139-14.066,37.488-15.797c7.433-1.752,47.929-17.86,60.913-16.347C78.209,157.975,113.762,162.111,113.762,162.111z"/>
                    <path id="rightMayu" fill="#412700" d="M269.602,142.251c16.733-12.926,68.331-22.479,82.876-22.479c14.545,0,48.869,8.951,73.761,18.397c24.893,9.446,87.302,38.475,78.186,35.716c-9.117-2.759-51.733-18.143-64.194-20.287c-12.461-2.144-77.674-21.591-98.067-19.341C321.769,136.507,269.602,142.251,269.602,142.251z"/>
                    <g id="leftEyeInnerWhite">
                        <path id="leftEyeInnerWhiteBottom" fill="#FFFFFF" d="M58.562,311.162c-0.7-3.637-5.951-6.134-5.951-6.134s2.306,2.465,1.188,6.685c-0.801,3.021-1.051,7.626,1.335,6.426C57.531,316.933,59.262,314.798,58.562,311.162z"/>
                        <path id="leftEyeInnerWhiteTop" fill="#FFFFFF" d="M46.408,248.567c-0.345,6.784,7.162,18.832,7.162,18.832s-2.352-6.234,0.84-12.375c2.318-4.46,5.046-8.967,1.682-11.134c-1.915-1.234-4.061-8.325-4.061-8.325S46.625,244.297,46.408,248.567z"/>
                    </g>
                    <g id="rightEyeInnerWhite">
                        <path id="rightEyeInnerWhiteBottom" fill="#FFFFFF" d="M371.919,311.638c-0.699-4.93-8.308-10.415-8.308-10.415s3.22,4.159,1.142,9.063c-1.492,3.523-2.311,9.321,1.389,8.799C369.84,318.561,372.619,316.57,371.919,311.638z"/>
                        <path id="rightEyeInnerWhiteTop" fill="#FFFFFF" d="M354.848,244.288c-0.038,9.447,12.151,26.133,12.151,26.133s-3.394-8.681,1.225-17.316c3.317-6.206,7.251-12.429,1.741-15.358c-3.143-1.673-6.776-13.583-6.776-13.583S354.871,238.386,354.848,244.288z"/>
                    </g>
                    <g id="rightCoverHalf_1_">
                        <polygon id="rightCoverHalfTop_2_" fill="#FFF2D2" points="292.359,192.222 288.334,255 376,255 460.334,297.667 473,262.69 442.762,230.092 367.761,185.704     "/>
                        <path id="rightEyeWaku_2_" d="M444.367,288.387c-11.336-4.063-58.61-38.26-79.898-41.403c-21.289-3.145-69.858,6.815-80.229,6.594c20.074,1.067,15.294,5.634,20.293,5.183c-10.311,2.399-13.324,2.647-18.419,3.483c13.325,0.337,48.716-6.868,74.229-2.28c25.51,4.587,75.976,29.146,83.306,32.781c3.079,5.355-1.799,10.89-7.616,13.098c8.778,0.295,12.62-1.901,15.921-3.961c0.962-0.6,21.32-2.1,19.426-2.188c-5.482-0.252-14.549-1.831-13.94-3.004c0.661-1.265,8.562-0.363,13.019-1.958c6.296-2.252,7.03-2.486,6.242-6.179C467.885,290.291,452.559,291.324,444.367,288.387z"/>
                    </g>
                    <g id="leftCoverHalf_1_">
                        <path id="leftCoverHalfTop_1_" fill="#FFF2D2" d="M47.122,195.998c3.877,0.667,57.964,42,57.964,42l5.247,25.334l-9.093,6.508c0,0-51.575-14.177-62.907-5.175s-44.945,22.362-44.945,22.362l-14.352-33.029L47.122,195.998z"/>
                        <path id="leftEyeWaku_2_" d="M-1.339,284.914c6.953-2.771,29.678-25.24,43.4-26.582c14.042-1.373,55.367,5.112,63.025,5.733c-14.641-0.581-11.212,5.383-14.905,4.552c7.846,3.15,10.111,3.641,14.023,4.886c-9.833-0.781-35.816-10.382-52.776-8.013c-16.53,2.308-47.777,20.78-52.277,23.504c-1.855,4.712,1.249,10.399,4.956,13.085c-5.537-0.589-7.957-3.054-10.018-5.313c-0.597-0.654-12.963-3.921-11.828-3.831c3.304,0.265,8.815-0.376,8.442-1.517c-0.403-1.228-5.187-1.099-7.851-2.948c-3.719-2.582-4.151-2.855-3.643-6.105C-15.583,284.658-6.336,286.905-1.339,284.914z"/>
                    </g>
                    <g id="rightCoverFull_1_">
                        <polygon id="rightCoverFullTop_1_" fill="#FFF2D2" points="280,189 288.334,310.148 386.629,330.692 466.334,285.704 479,250.856 363.78,189     "/>
                        <path id="rightCoverFullBottom_1_" d="M444.367,288.387c-6.56-2.352-28.97,8.717-47.867,19.113c-13.758,7.568-39.031,12.158-48,10.834c-21.289-3.145-53.89-9.535-64.261-9.757c20.074,1.067,15.294,5.634,20.293,5.183c-10.311,2.399-13.324,2.647-18.419,3.483c13.325,0.337,42.932,16.729,68.734,19.217c62.652,6.04,99.152-32.654,88.8-43.716c3.079,5.355-1.799,10.89-7.616,13.098c8.778,0.295,12.62-1.901,15.921-3.961c0.962-0.6,21.32-2.1,19.426-2.188c-5.482-0.252-14.549-1.831-13.94-3.004c0.661-1.265,8.562-0.363,13.019-1.958c6.296-2.252,7.03-2.486,6.242-6.179C467.885,290.291,452.559,291.324,444.367,288.387z"/>
                    </g>
                    <g id="leftCoverFull_1_">
                        <path id="leftCoverFullTop_1_" fill="#FFF2D2" d="M53.122,183.998c3.877,0.667,62.547,24.657,62.547,24.657l12.135,38.637l-23.6,76.211c0,0-71.894,9.199-89.013-5.169c-11.085-9.305-15.804-43.307-15.804-43.307l-14.352-33.029L53.122,183.998z"/>
                        <path id="leftCoverFullBottom_1_" d="M-1.339,284.914c6.953-2.771,31.415,30.007,45.839,31.336s52.928-2.806,60.586-2.185c-14.641-0.581-11.212,5.383-14.905,4.552c7.846,3.15,10.111,3.641,14.023,4.886C94.372,322.722,84.96,334.307,68,336.676c-7.97,1.112-32.346-0.541-45.94-8.763c-14.603-8.831-26.612-29.542-22.909-38.919c-1.855,4.712,1.249,10.399,4.956,13.085c-5.537-0.589-7.957-3.054-10.018-5.313c-0.597-0.654-12.963-3.921-11.828-3.831c3.304,0.265,8.815-0.376,8.442-1.517c-0.403-1.228-5.187-1.099-7.851-2.948c-3.719-2.582-4.151-2.855-3.643-6.105C-15.583,284.658-6.336,286.905-1.339,284.914z"/>
                    </g>
                    </svg>
    
}
