/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fQ1z
 */

package
{
    import com.bit101.components.Label;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
 
    public class Main extends Sprite
    {
        public static var canvas:BitmapData;
        private var ants:Vector.<Ant> = new Vector.<Ant>();
        private var scale:Number = 4.0;
        private var step:int = 0;
        private var stepLabel:Label;
        
        public function Main()
        {
            stage.frameRate = 120;
            canvas = new BitmapData(stage.stageWidth / scale, stage.stageHeight / scale, false, 0xB1C880);
            var bitmap:Bitmap = new Bitmap(canvas);
            bitmap.scaleX = bitmap.scaleY = scale;
            addChild(bitmap);
            
            ants.push(new Ant(stage.stageWidth / scale / 2, stage.stageWidth / scale / 2, 0));
            
            stepLabel = new Label(this, 350, 400);
            stepLabel.scaleX = stepLabel.scaleY = 2;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void 
        {
            for each (var ant:Ant in ants) ant.move();
            stepLabel.text = "Step " + ++step;
        }
    }
}

class Ant
{
    public static const DIRECTION:Array = [{x:0, y:-1}, {x:1, y:0}, {x:0, y:1}, {x:-1, y:0}];
    public var x:int;
    public var y:int;
    public var dir:int;
    
    public function Ant(x:int, y:int, dir:int)
    {
        this.x = x;
        this.y = y;
        this.dir = dir;
    }
    
    public function move():void
    {
        if (Main.canvas.getPixel(x, y) == 0x5E6F3B)
        {
            Main.canvas.setPixel(x, y, 0xB1C880);
            dir++;
        }
        else
        {
            Main.canvas.setPixel(x, y, 0x5E6F3B);
            dir--;
        }
        
        if (dir < 0) dir += DIRECTION.length;
        dir %= DIRECTION.length;
        
        var o:Object = DIRECTION[dir];
        x += o.x;
        y += o.y;
        
        if (x < 0) x += Main.canvas.width;
        if (y < 0) y += Main.canvas.height;
        x %= Main.canvas.width;
        y %= Main.canvas.height;
    }
}