/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fPBK
 */

// forked from fakestar0826's ReachingSegment
// forked from fakestar0826's SingleSegment
package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite 
    {
        private var segment0:Segment;
        private var segment1:Segment;
        
        public function FlashTest() {
            // write as3 code here..
            segment0 = new Segment(100, 20);
            addChild(segment0);
            segment0.x = 80;
            segment0.y = 80;
            
            segment1 = new Segment(100, 20);
            addChild(segment1);
            segment1.x = segment0.getPin().x;
            segment1.y = segment0.getPin().y;
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            var dx:Number = mouseX - segment0.x;
            var dy:Number = mouseY - segment0.y;
            var angle:Number = Math.atan2(dy, dx);
            segment0.rotation = angle * 180 / Math.PI;
            
            var w:Number = segment0.getPin().x - segment0.x;
            var h:Number = segment0.getPin().y - segment0.y;
            segment0.x = mouseX - w;
            segment0.y = mouseY - h;
            
            dx = segment0.x - segment1.x;
            dy = segment0.y - segment1.y;
            angle = Math.atan2(dy, dx);
            segment1.rotation = angle * 180 / Math.PI;
            
            w = segment1.getPin().x - segment1.x;
            h = segment1.getPin().y - segment1.y;
            segment1.x = segment0.x - w;
            segment1.y = segment0.y - h;
        }

    }
}
import flash.geom.Point;
import flash.display.Sprite;

class Segment extends Sprite
{
    private var color:uint;
    private var segmentWidth:Number;
    private var segmentHeight:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Segment(segmentWidth:Number, segmentHeight:Number, color:uint = 0xFFFFFF)
    {
        this.segmentWidth = segmentWidth;
        this.segmentHeight = segmentHeight;
        this.color = color;
        
        graphics.lineStyle(0);
        graphics.beginFill(color);
        graphics.drawRoundRect(-segmentHeight / 2, -segmentHeight / 2, segmentWidth + segmentHeight, segmentHeight, segmentHeight, segmentHeight);
        graphics.endFill();
        
        graphics.drawCircle(0, 0, 2);
        graphics.drawCircle(segmentWidth, 0, 2);
    }
    
    public function getPin():Point
    {
        var angle:Number = rotation * Math.PI / 180;
        var xPos:Number = x + Math.cos(angle) * segmentWidth;
        var yPos:Number = y + Math.sin(angle) * segmentWidth;
        
        return new Point(xPos, yPos);
    }


}
