/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fOrD
 */

// forked from cpu_t's LissajousCurve
// 関数に手を加えて、描画を続きから行えるようにした
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	
	[SWF(width = 400, height = 400, backgroundColor = 0x808080, frameRate = 60)]
    public class LissajousCurve extends Sprite {
		private var _bmpdata:BitmapData;
		private var _filter:BlurFilter;
		private var _cTransform:ColorTransform;
		private var _isMove:Boolean = true;
		
        public function LissajousCurve() {
			
			_bmpdata = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            addChild(new Bitmap(_bmpdata));
			_filter = new BlurFilter(1.05, 1.05);
			_cTransform = new ColorTransform(0.992, 0.991, 0.985);
			
			stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			stage.addEventListener(MouseEvent.MOUSE_DOWN,
			function(e:MouseEvent):void {
				if (_isMove) {
					stage.removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
					_isMove = false;
				}else {
					stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
					_isMove = true;
				}
			});
        }
		
		private var _count:Number = 0;
		private var a_lastcount:int = 0;
		private var b_lastcount:int = 0;
		private function enterFrameHandler(e:Event):void
		{
			_bmpdata.applyFilter(_bmpdata, _bmpdata.rect, _bmpdata.rect.topLeft, _filter);
			_bmpdata.colorTransform(_bmpdata.rect, _cTransform);
			a_lastcount = drawLissajousCurve(_bmpdata, 4 + Math.sin(_count) / 3, 3, 360 / 15, a_lastcount);
			b_lastcount = drawLissajousCurve(_bmpdata, 4 + Math.cos(_count) / 3, 3, 360 / 30, b_lastcount);
			_count += Math.PI / 180 / 15;
		}
		
		// リサージュ曲線を描画する
		// bmpdata:描画するBitmapData, a,b:関数の係数, count:角度の最大値（単位:度）
		private function drawLissajousCurve(bmpdata:BitmapData, a:Number, b:Number, count:int = 10000, lastcount:int = 0):int
		{
			const scale:int = stage.stageWidth / 3;
			bmpdata.lock();
			if (a > b) {
				a = a / b;
				b = 1;
			}else {
				b = b / a;
				a = 1;
			}
			var x:int, y:int;
			var sx:int = Math.floor(Math.cos(0) * scale);
			var sy:int = Math.floor(Math.sin(0) * scale);
			var i:Number = lastcount * Math.PI / 180, times:int = lastcount;
			var roopnum:int = 0;
			while (times < lastcount + count) {
				if (x == sx && y == sy) {
					i = 0;
					roopnum = times;
				}
				x = Math.floor(Math.cos(a * i) * scale) + stage.stageWidth / 2;
				y = Math.floor(Math.sin(b * i) * scale) + stage.stageHeight / 2;
				bmpdata.setPixel(x, y, 0xFFFFFF);
				bmpdata.setPixel(x+1, y, 0xFFFFFF);
				bmpdata.setPixel(x, y+1, 0xFFFFFF);
				bmpdata.setPixel(x-1, y, 0xFFFFFF);
				bmpdata.setPixel(x, y-1, 0xFFFFFF);
				i += Math.PI / 180;
				times++;
			}
			bmpdata.unlock();
			return times - roopnum;
		}
    }
}