/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fOgE
 */

/*
	wonderflでの使用を想定したものを先に出したので
	今度は普通のasファイル単体での出力用の投稿
	
	テキストエリアのスライダーがおかしな挙動しちゃうけど気にしない
	
	
	誰か真っ当なテキストエリアコンポーネントを作ってくだしあ
	
	
	ps.
	ライセンスの書き方とかわからんです。
	誰かわかりやすいサイトとかあったら教えてください。
	
	asdocも分かりません
	
	まあ、普通にMITとか言うので。
	
	
*/
package{
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.*;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.text.*;
	import flash.utils.ByteArray;
	
	[SWF(width="465", height="465", backgroundColor="0xEEEEEE")]

	public class Pbj2AS3 extends Sprite{
		
		// pbjファイルのロード ・ ASファイルの保存のボタン
		private var loadBtn:TxtBtn;
		private var saveBtn:TxtBtn;
		
		private var textArea:TxtArea;
		
		private var fileRef:FileReference;
		
		private var conv:Shader2AS;
		
		private var loaded_flg:Boolean = false;
		
		private var package_txt:TextField;
		private var checkBreak:CheckBox;
		private var checkProperty:CheckBox;
		
		public function Pbj2AS3(){
			loadBtn = new TxtBtn( this, "<a href='event:load'>load</a>" );
			saveBtn = new TxtBtn( this, "<a href='event:save'>save</a>" );
			loadBtn.addEventListener( TextEvent.LINK, onLink );
			saveBtn.addEventListener( TextEvent.LINK, onLink );
			
			textArea = new TxtArea( this, 450, 400);
			textArea.x = loadBtn.x =  (465 - textArea.width) *0.5;
			textArea.y = 40;
			saveBtn.x = loadBtn.x + loadBtn.width + 5;
			loadBtn.y = saveBtn.y = 8;
			
			var pnt:TextField = setLabel("package : ", new Point(saveBtn.x + saveBtn.width + 10,8));
			package_txt = getTextBox(new Point(pnt.x + pnt.width, 8), 120, 18);
			package_txt.addEventListener( Event.CHANGE, function(e:Event):void{
				onChange();
			});
			
			var brt:TextField = setLabel("break : ", new Point(package_txt.x + package_txt.width + 8, 8));
			checkBreak = new CheckBox( this, 16,16, false );
			checkBreak.x = brt.x + brt.width;
			checkBreak.y = 8;
			
			var ppt:TextField = setLabel("property : ", new Point(checkBreak.x + checkBreak.width + 8, 8));
			checkProperty = new CheckBox( this, 16,16, true );
			checkProperty.x = ppt.x + ppt.width;
			checkProperty.y = 8;
			
			checkBreak.addEventListener( MouseEvent.CLICK, onCheck);
			checkProperty.addEventListener( MouseEvent.CLICK, onCheck);
			
			textArea.text = "" + 
					"pbjファイルをロードしてください。\n" + 
					"ここにAS3に変換して表示されます(多分。\n" + 
					"\n";
		}
		private function load():void{
			fileRef = new FileReference();
			fileRef.addEventListener( Event.SELECT, loadSelect );
			fileRef.browse( [ new FileFilter("load pbj file", "*.pbj")] );
		}
		private function loadSelect(e:Event):void{
			fileRef.removeEventListener( Event.SELECT, loadSelect );
			fileRef.addEventListener( Event.COMPLETE, loaded );
			fileRef.load();
		}
		private function loaded(e:Event):void{
			loaded_flg = true;
			fileRef.removeEventListener( Event.COMPLETE, loaded );
			conv = new Shader2AS(fileRef.data as ByteArray, package_txt.text, checkBreak.selected, checkProperty.selected );
			textArea.text = conv.toString();
		}
		private function save():void{
			if(loaded_flg ){
				fileRef = new FileReference();
				fileRef.addEventListener( Event.SELECT, saveSelect );
				fileRef.save( textArea.text, conv.name() + ".as" );
			}
		}
		private function saveSelect( e:Event ):void{
			fileRef.removeEventListener( Event.SELECT, saveSelect );
		}
		private function onCheck( e:MouseEvent ):void{
			onChange();
		}
		private function onChange():void{
			if( loaded_flg ){
				conv.convert( package_txt.text, checkBreak.selected, checkProperty.selected );
				textArea.text = conv.toString();
			}
		}
		private function onLink(e:TextEvent):void{
			switch(e.text){
				case "load": load(); break;
				case "save": save(); break;
			}
		}
		private function setLabel(txt:String, pos:Point):TextField{
			var tf:TextField = new TextField();
			addChild(tf);
			tf.x = pos.x;
			tf.y = pos.y;
			tf.autoSize = "left";
			tf.text = txt;
			return tf;
		}
		private function getTextBox(pos:Point, width:int, height:int):TextField{
			var tf:TextField = new TextField();
			addChild(tf);
			tf.x = pos.x;
			tf.y = pos.y;
			tf.width = width;
			tf.height = height;
			tf.type = flash.text.TextFieldType.INPUT;
			tf.border = tf.background = true;
			tf.borderColor = 0;
			tf.backgroundColor = 0xCCCCCC;
			tf.text = "";
			return tf;
		}
		//
	}
}
	import flash.text.TextField;
	import flash.events.*;
	import flash.utils.ByteArray;
	import flash.display.*;
	import flash.filters.BlurFilter;
	import mx.utils.Base64Encoder;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	import org.papervision3d.core.render.sort.NullSorter;
	import jiglib.physics.BodyPair;
	
class ShaderReader{
	static public const SORT_INDEX:String = "index";
	static public const SORT_NAME:String = "name";
	
	private var sd:ShaderData;
	private var _bytes:ByteArray;
	
	private var _input:Array = [];
	private var _param:Array = [];
	
	private var _name:String = "";
	private var _namespace:String = "";
	private var _vendor:String = "";
	private var _version:String = "";
	private var _description:String = "";
	
	public function ShaderReader( bytes:ByteArray ){
		sd = new Shader( bytes ).data;
		_bytes = bytes;
		
		for( var p:String in sd){
			var d:* = sd[p];
			if(d is ShaderParameter){
				var sp:ShaderParameter = d as ShaderParameter;
				var _values:Object = {};
				for(var _d:String in sp) _values[_d] = (sp[_d]) ? sp[_d] : "";
				_param[_param.length] = {"name":p, "index":sp.indexm, "type":sp.type, "values":_values};
			}else if(d is ShaderInput){
				var si:ShaderInput = d as ShaderInput;
				_input[_input.length] = {"name":p, "index":si.index, "channels":si.channels};
			}else{
				meta(p.toLowerCase(), d);
			}
		}
	}
	private function meta( paramName:String, paramData:String):void{
		switch( paramName ){
			case "name": _name = paramData; break;
			case "namespace": _namespace = paramData; break;
			case "vendor": _vendor = paramData; break;
			case "version": _version = paramData; break;
			case "description": _description = paramData; break;
		}
	}
	
	public function get bytes():ByteArray{ return _bytes; }
	
	// metaData
	public function get name():String{ return _name; }
	public function get nameSpace():String{ return _namespace; }
	public function get vendor():String{ return _vendor; }
	public function get version():String{ return _version; }
	public function get description():String{ return _description;}
	
	public function getInputData( sort:String = "index" ):Array{
		_input.sortOn( sort , Array.CASEINSENSITIVE);
		return _input;
	}
	public function getParamData( sort:String = "index" ):Array{
		_param.sortOn( sort , Array.CASEINSENSITIVE);
		return _param;
	}
}
class Shader2AS{
	private var base:String = "" + 
			"package $PACKAGE$$BREAK${\n" + 
			"\t" + "import flash.display.Shader;\n" + 
			"\t" + "import flash.utils.ByteArray;\n" + 
			"\t" + "import mx.utils.Base64Decoder;\n" + 
			"\n" + 
			"\t" + "class $CLASS_NAME$ extends Shader$BREAK2${\n" + 
			"\t\t" + "static private var code:ByteArray;\n" + 
			"\n" + 
			"\t\t" + "// static initializer\n" + 
			"\t\t" + "{\n" + 
			"\t\t\t" + "static var dec:Base64Decoder = new Base64Decoder() ;\n" + 
			"\t\t\t" + "dec.decode(\n" + 
			"\t\t\t" + "\t\t\t\"$BASE64$\" );\n" + 
			"\t\t\t" + "code = dec.toByteArray();\n" + 
			"\t\t\t" + "dec = null;\n" +
			"\t\t" + "}\n" + 
			"\n" + 
			"\t\t" + "public function $CLASS_NAME$()$BREAK3${\n" + 
			"\t\t\t" + "super( code );\n" + 
			"\t\t" + "}\n" + 
			"\n" + 
			"$PROPERTY$" + 
			"\t}\n" + 
			"}";
	private const metaString:String = "\n" + 
			"\t\t" + "public function get $META$():String$BREAK3${\n" + 
			"\t\t\t" + "return data[ \"$META$\" ];\n" + 
			"\t\t" + "}\n";
	private const paramString:String = "\n" + 
			"\t\t" + "public function get $PARAM$():Array$BREAK3${\n" + 
			"\t\t\t" + "return data[ \"$PARAM$\" ].value;\n" + 
			"\t\t" + "}\n" + 
			"\t\t" + "public function set $PARAM$( value:Array ):void$BREAK3${\n" + 
			"\t\t\t" + "data[ \"$PARAM$\" ].value = value;\n" + 
			"\t\t" + "}\n";
	private const inputString:String = "\n" + 
			"\t\t" + "public function $INPUT$( input:*,  width:int, height:int):void$BREAK3${\n" + 
			"\t\t\t" + "data[ \"$INPUT$\" ].input = input;\n" + 
			"\t\t\t" + "data[ \"$INPUT$\" ].width = width;\n" + 
			"\t\t\t" + "data[ \"$INPUT$\" ].height = height;\n" + 
			"\t\t" + "}\n" + 
			"\t\t" + "public function get $INPUT$Channels():int$Break3${\n" + 
			"\t\t\t" + "return data[ \"$INPUT$\" ].channels;\n" + 
			"\t\t}\n"
			
	private var _property:String = "";
	private var _name:String = "";
	private var code:String;
	private var reader:ShaderReader;
	
	private var script:String = "";

	public function Shader2AS(	bytes:ByteArray , packageName:String = "",
													useBreak:Boolean = true,
													useProperty:Boolean = true ){
		//
		reader = new ShaderReader( bytes );
		_name = reader.name;
		
		var enc:Base64Encoder = new Base64Encoder();
		enc.encodeBytes( bytes );
		code = enc.toString();
		code = code.replace( /\n/g, "\" +\n\t\t\t\t\t\t\"");
		convert(packageName, useBreak, useProperty);
	}
	public function convert( packageName:String = "", useBreak:Boolean = true, useProperty:Boolean = true ):void{
		script = base.replace( /\$BASE64\$/ig, code);
		script = script.replace( /\$PACKAGE\$/ig, packageName);
		script = script.replace( /\$CLASS_NAME\$/ig, reader.name);
		if(useProperty) script = script.replace(/\$PROPERTY\$/ig, propertys( reader ) );
		else script = script.replace(/\$PROPERTY\$/ig, "");
		
		if(useBreak){
			script = script.replace(/\$BREAK\$/ig, "\n");
			script = script.replace(/\$BREAK2\$/ig, "\n\t");
			script = script.replace(/\$BREAK3\$/ig, "\n\t\t");
		}
		else{ 
			script = script.replace(/\$BREAK\$/ig, "");
			script = script.replace(/\$BREAK+[0-9]\$/ig, "");
		}
	}
	private function propertys( reader:ShaderReader ):String{
		var str:String = "";
		str += metaString.replace(/\$META\$/g, "name" );
		str += metaString.replace(/\$META\$/g, "nameSpace" );
		str += metaString.replace(/\$META\$/g, "vendor" );
		str += metaString.replace(/\$META\$/g, "version" );
		str += metaString.replace(/\$META\$/g, "description" );
		
		var arr:Array = reader.getParamData();
		for(var i:int = 0, len:int = arr.length; i<len; i++)
			str += paramString.replace(/\$PARAM\$/g, arr[i].name);
		
		arr = reader.getInputData();
		for(i=0,len=arr.length;i<len;i++)
			str += inputString.replace(/\$INPUT\$/g, arr[i].name);
		
		return str;
	}
	public function toString():String{ return script; }
	public function name():String{ return _name; }
}

//簡易的なテキストエリア
class TxtArea extends Sprite{
	
	private const SCROLL_BAR_WIDTH:int = 20;
	
	private var t:TextField;
	private var s:Shape;
	private var g:Graphics;
	private var gf:GlowFilter;
	
	private var _w:int;
	private var _h:int;
	
	private var vTickness:Number;
	
	private var vScrollBar:VScrollBar;
	
	public function get w():int{ return _w; }
	public function get h():int{ return _h; }
	
	public function TxtArea( parent:DisplayObjectContainer, width:int, height:int ){
		parent.addChild( this );
		
		gf = new GlowFilter( 0x0099FF, 0.8, 4,4 , 2, 2);
		
		addChild( (s = new Shape() ) );
		addChild( (t = new TextField() ) );
		
		_w = t.width = width;
		_h = t.height = height;
		drawFream();
		addEventListener( FocusEvent.FOCUS_IN, onFocus);
		t.addEventListener( Event.SCROLL, onScroll );
		setBar();
	}
	private function setBar():void{
		addChild( (vScrollBar = new VScrollBar(this, SCROLL_BAR_WIDTH, height) ));
	}
	public function get text():String{
		return t.text;
	}
	public function set text(value:String):void{
		t.text = value;
		checkScroll();
	}
	public function set htmlText(value:String):void{
		t.htmlText = value;
		checkScroll();
	}
	private function checkScroll():void{
		vScrollBar.thickness = vTickness =( t.height - t.height * (t.height / t.textHeight) )/ (t.maxScrollV - 1);
		
		if( t.textHeight > t.height ){
			t.width = _w - SCROLL_BAR_WIDTH;
			vScrollBar.resize( SCROLL_BAR_WIDTH, t.height, SCROLL_BAR_WIDTH, t.textHeight );
			vScrollBar.visible = true;
		}else{
			t.width = _w;
			vScrollBar.visible = false;
		}
	}
	private function onScroll( e:Event ):void{
		vScrollBar.setSliderPos(  vTickness * ( t.scrollV - 1 ) );
	}
	public function get scrollV():int{
		return t.scrollV;
	}
	public function set scrollV( value:int ):void{
		t.scrollV = (value < 1) ? 1: value;
	}
	private function onFocus( e:FocusEvent ):void{
		addEventListener(FocusEvent.FOCUS_OUT, outFocus );
		drawFream( 0xFFFFEE , 1, 0x0099FF);
		filters = [gf];
	}
	private function outFocus( e:FocusEvent ):void{
		removeEventListener(FocusEvent.FOCUS_OUT, outFocus );
		drawFream();
		filters = [];
	}
	private function drawFream( bgColor:uint = 0xFFFFFF , bold:int = 1, color:uint = 0x333333 ):void{
		g = graphics;
		g.clear();
		(bold == 0) ? g.lineStyle() : g.lineStyle( bold, color );
		g.beginFill( bgColor );
		g.drawRect( 0,0, _w, _h );
		g.endFill();
	}
}
class ScrollBar extends Sprite{
	protected var g:Graphics;
	protected var _w:int, _h:int;
	
	protected var bgColor:uint = 0xCCCCCC;
	protected var strokeColor:uint = 0x333333;
	
	protected var fieldWidth:int;
	protected var fieldHeight:int;
	
	protected var worldWidth:int;
	protected var worldHeight:int;
	
	protected var slider:Slider;
	protected var oldPoint:Point;
	
	public var thickness:Number = 0;
	
	public function ScrollBar(parent:DisplayObjectContainer, w:int, h:int){
		(slider = new Slider( this, w, h)).addEventListener( MouseEvent.MOUSE_DOWN, onSliderDown);
		
		parent.addChild( this );
		g = this.graphics;
		resize( w, h, w,h);
	}
	protected function onSliderDown(e:MouseEvent):void{
		oldPoint = new Point(slider.mouseX, slider.mouseY);
		slider.stage.addEventListener(MouseEvent.MOUSE_MOVE, onSliderMove);
		slider.stage.addEventListener(MouseEvent.MOUSE_UP, onSliderUp);
	}
	protected function onSliderMove(e:MouseEvent):void{
	}
	protected function onSliderUp(e:MouseEvent):void{
		slider.stage.removeEventListener(MouseEvent.MOUSE_MOVE, onSliderMove);
		slider.stage.removeEventListener(MouseEvent.MOUSE_UP, onSliderUp);
	}
	
	public function resize( w:int, h:int, maxWidth:int, maxHeight:int):void{
		setSize(w,h, maxWidth, maxHeight);
	}
	protected function setSize( w:int, h:int, maxWidth:int, maxHeight:int):void{
		fieldWidth = _w = w;
		fieldHeight = _h = h;
		worldWidth = maxWidth;
		worldHeight = maxHeight;
		setSliderSize();
		draw();
	}
	protected function setSliderSize():void{
		var w:int, h:int;
		w = _w *  (  fieldWidth / worldWidth );
		h =  _h * ( fieldHeight / worldHeight  );
		slider.resize(w,h);
	}
	public function setSliderPos( position:Number ):void{
	}
	private function draw():void{
		g.clear();
		g.beginFill( strokeColor );
		g.drawRect( 0,0, _w, _h);
		g.endFill();
		g.beginFill( bgColor );
		g.drawRect( 1,1, _w-2, _h-2);
		g.endFill();
	}
}
class VScrollBar extends ScrollBar{
	public function VScrollBar( parent:DisplayObjectContainer, w:int, h:int){
		super(parent, w, h );
	}
	override public function setSliderPos(position:Number):void{
		slider.y = position;
	}
	override protected function onSliderMove(e:MouseEvent):void{
		var yy:Number = mouseY - oldPoint.y;
		var __h:Number = _h - slider.height - thickness ;
		yy = (yy > __h ) ? __h  : (yy < 0) ? 0:yy;
		
		var ta:TxtArea = parent as TxtArea;
		slider.y = yy;
		ta.scrollV = yy / thickness;
	}
	override protected function setSize( w:int, h:int, maxWidth:int, maxHeight:int ):void{
		super.setSize( w,h, maxWidth, maxHeight);
		var p:TxtArea = parent as TxtArea;
		x = p.w - w;
	}
}
class SpriteUI extends Sprite{
	protected var mode:String = "none";
	protected var g:Graphics;
	protected var _w:int, _h:int;
	public function SpriteUI( parent:DisplayObjectContainer ){
		parent.addChild( this );
		g = this.graphics;
		addEventListener( MouseEvent.MOUSE_DOWN, onDown );
	}
	public function resize( w:int, h:int):void{
		setSize(w,h);
	}
	protected function setSize( w:int, h:int):void{
		_w = w;
		_h = h;
		draw();
	}
	protected function onDown( e:MouseEvent ):void{
		stage.addEventListener( MouseEvent.MOUSE_UP, onUp );
		mode = "down";
		draw();
	}
	protected function onUp( e:MouseEvent ):void{
		stage.addEventListener( MouseEvent.MOUSE_UP, onUp );
		mode = "none";
		draw();
	}
	protected function draw():void{}
}
class Slider extends SpriteUI{
	public function Slider( parent:DisplayObjectContainer , w:int, h:int){
		super( parent );
		setSize(w,h);
	}
	override protected function draw():void{
		var color:uint = (mode == "none") ? 0x999999 : 0x666666;
		g.clear();
		g.lineStyle( 0, 0x333333 );
		g.beginFill( color );
		g.drawRoundRect( 2,2, _w-5,_h-5, 3,3);
		g.endFill()
	}
}
class CheckBox extends SpriteUI{
	private var _flg:Boolean = false;
	public function CheckBox(parent:DisplayObjectContainer, w:int,h:int, select:Boolean = false){
		super(parent);
		_flg = select;
		setSize(w,h);
		addEventListener( MouseEvent.CLICK, onClick);
	}
	private function onClick(e:MouseEvent):void{
		_flg = (_flg==true) ? false :true;
		draw();
	}
	public function get selected():Boolean{ return _flg; }
	override protected function onDown(e:MouseEvent):void{}
	override protected function draw():void{
		g.clear();
		g.lineStyle( 1, 0x333333 );
		g.beginFill( 0xCCCCCC );
		g.drawCircle( _w/2, _h/2, _w/2 );
		g.endFill();
		if(_flg){
			g.beginFill( 0x666666 );
			g.drawCircle( _w/2, _h/2, _w/2 - 4 );
			g.endFill();
		}
	}
}
class TxtBtn extends TextField{
	public function TxtBtn(parent:DisplayObjectContainer, text:String, color:uint = 0xCCCCCC, bgColor:uint = 0x0){
		autoSize = "left";
		background = border = true;
		backgroundColor = bgColor;
		textColor = borderColor = color;
		htmlText = "    " + text + "    ";
		parent.addChild( this );
	}
}