/**
 * Copyright plus-tic ( http://wonderfl.net/user/plus-tic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fO8N
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Dynamics.b2World;
	//目がチカチカしないように若干ですが背景の色変えております。
	[SWF(backgroundColor="0xefefef")]
	
    public class Main extends Sprite {
		private var world:b2World;
		
        public function Main() {
			//物理演算を適用する範囲を指定
			var worldAABB:b2AABB = new b2AABB();
			//左上位置x,y(やや大きめに範囲を取る)
			worldAABB.lowerBound.Set( -100, -100);
			//右下位置x, y(やや大きめに範囲を取る)
			worldAABB.upperBound.Set(stage.stageWidth +100, stage.stageHeight +100);
			
			//重力(加速度)の設定
			var gravity:b2Vec2 = new b2Vec2(0, 10);
			//範囲と重力を適用させるために、b2Wroldのコンストラクタに値を指定
			world = new b2World(worldAABB, gravity, true);
			
			//描画
			var draw:b2DebugDraw = new b2DebugDraw();
			//Mainクラスに描画したいのでthis
			draw.m_sprite = this;
			//m_drawScale　1メートル = 何pxになるのかを比率で指定します。 
			draw.m_drawScale = 1;
            draw.m_drawFlags = b2DebugDraw.e_shapeBit;
			world.SetDebugDraw(draw);
			
			addEventListener(Event.ENTER_FRAME, onEnter);
        }
		private function onEnter(e:Event):void {
			world.Step(1 / stage.frameRate, 10);
		}
    }
}