/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fO2Y
 */

// forked from siouxcitizen's Away3D Gold Practice04 SphereとWireframeSphere表示
// forked from siouxcitizen's Away3D Gold Practice03 WireframePlane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice02 Plane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice01 Plane 1枚表示
//Away3D 4.0 Gold で複数Sphereを表示してみました
//
//以下サイトを参考にさせて頂きしました
//
//Away3D 4 Alpha - Sphere primitive
//Here is an example of the Sphere primitive from Away3D 4 (alpha)
//http://www.allforthecode.co.uk/aftc/forum/user/modules/forum/article.php?index=0&subindex=0&aid=304
//
package {
    import away3d.containers.View3D;
    import away3d.containers.Scene3D;
    import away3d.cameras.Camera3D;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.SphereGeometry;
    import away3d.primitives.PrimitiveBase;
    import away3d.lights.DirectionalLight;
    import away3d.lights.PointLight;
    import away3d.materials.lightpickers.StaticLightPicker;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;

    import flash.display.Bitmap;
    import flash.display.BitmapData;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    public class SphereSample extends Sprite {

        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _view : View3D;
        private var _scene : Scene3D;
        private var _camera : Camera3D;
        private var _sphereGeo : PrimitiveBase;
        private var _sphereMat : ColorMaterial;
        private var _pointLightSphereMat : ColorMaterial;
        private var _sphere01 : Mesh;
        private var _sphere02 : Mesh;
        private var _sphere03 : Mesh;
        private var _direcLight : DirectionalLight;
        private var _pointLight : PointLight;

        private var _capture : BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function SphereSample() {

            // wonderfl capture
            Wonderfl.disable_capture();
            //addChild(new Bitmap(_capture)) ;

            _view = new View3D();
            _scene = _view.scene;
            _camera = _view.camera;
            addChild(_view);

            _view.antiAlias = 0;
            _view.backgroundColor = 0xdddddd;

            //Sphsreその１生成・表示
            _sphereMat =  new ColorMaterial(0xff00ff, 1);
            _sphereGeo = new SphereGeometry(100, 16, 16);
            _sphere01 = new Mesh(_sphereGeo, _sphereMat);
            _sphere01.y += 250;
            _scene.addChild(_sphere01);

            //DirectionalLightでSphsreその２生成・表示
            _direcLight = new DirectionalLight();
            _direcLight.direction = new Vector3D(1, -1, 1);
            _direcLight.specular = 0.1;
            _direcLight.diffuse = 0.9;
            _direcLight.ambient = 0.1;
            _scene.addChild(_direcLight);

            var lightPicker01:StaticLightPicker = new StaticLightPicker([_direcLight]);

            _sphereMat =  new ColorMaterial(0xff00ff, 1);
            _sphereMat.lightPicker = lightPicker01;
            _sphereGeo = new SphereGeometry(100, 16, 16);
            _sphere02 = new Mesh(_sphereGeo, _sphereMat);
            _sphere02.y = 0;
            _scene.addChild(_sphere02);

            //PointLightでSphsreその３生成・表示
            _pointLight = new PointLight();
            _pointLight.diffuse = 0.9;
            _pointLight.color = 0xffffff;
            _pointLight.z = -500;
            _pointLight.y = 200;
            _scene.addChild(_pointLight);

            var lightPicker02:StaticLightPicker = new StaticLightPicker([_pointLight]);

            _pointLightSphereMat = new ColorMaterial(0xff00ff, 1);
            _pointLightSphereMat.lightPicker = lightPicker02;
            _sphereGeo = new SphereGeometry(100, 16, 16);
            _sphere03 = new Mesh(_sphereGeo, _pointLightSphereMat);
            _sphere03.y -= 250;
            _scene.addChild(_sphere03);

            _camera.y = 0;
            _camera.z = -700;

            addEventListener(Event.ENTER_FRAME, update);
                   
            addChild(new AwayStats());
        }

        private function update(event : Event) : void {

            _sphere01.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _sphere01.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _sphere02.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _sphere02.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _sphere03.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _sphere03.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _camera.lookAt(ZERO);
            _view.render();
            //_view.renderer.queueSnapshot(_capture);
        }
    }
}