/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fMtz
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import net.wonderfl.utils.FontLoader;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    public class Main extends Sprite {
        public static const FONT:String = "Bebas";
        public static const EMBED:Boolean = true;
        public function Main() {
            
            var fontLoader:FontLoader = new FontLoader();
            fontLoader.addEventListener(Event.COMPLETE, init);
            fontLoader.load(Main.FONT);
  
            
        }
        private function init(e:Event=null):void{
            var _flashBody:Sprite = new Sprite();
            _flashBody.graphics.beginFill(0x000000);
            _flashBody.graphics.drawRect(-10, -10, 485, 485);
            _flashBody.graphics.endFill();
            addChild(_flashBody);
            _flashBody.addEventListener(MouseEvent.CLICK, onKey);
            
            //stage.addEventListener(MouseEvent.CLICK,onKey);
            //new ScoreIndicator(stage,0,0,"test");
        }

        private function onKey(e:MouseEvent):void{
            var pt:int = Math.random()*9999;
            new ScoreIndicator(stage,160,300,pt.toString()+"   hit",0xff0000,0xaa0000);
            //new ScoreIndicator(stage,300,300,"hit");
        }

    }
}

// -----------------------------------------------------------------------------------------
// ScoreIndicator
// -----------------------------------------------------------------------------------------
//package {
    import flash.display.*;
    import flash.events.Event;
    import flash.text.TextField;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    //public
    class ScoreIndicator extends Sprite {
        private var _chars:Vector.<TextField>;
        private var _charIndex:int;
        private var _numCompleted:int;
        //private var color1:uint = 0x0000ff;
        private var color1:uint = 0xffffff;
        //private var color2:uint = 0x00007f;
        private var color2:uint = 0xaaaaff;
        private var _size:Number;
        
        public function ScoreIndicator(parent:DisplayObjectContainer, centerX:int, bottomY:int, text:String,
                            c1:uint=0xffffff,c2:uint=0xaaaaff,size:Number=50) {
            parent.addChild(this);
            this.mouseEnabled = false;
            x = centerX;
            y = bottomY;
            _size = size;
            
            _chars = new Vector.<TextField>();
            _charIndex = 0;
            _numCompleted = 0;
            
            splitText(text);//文字列を文字に分割
            alignChars();
            playTween();
            
            addEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
        }
        
        //文字列分割
        private function splitText(text:String):void {
            //this.scaleX = 2;
            //this.scaleY = 2;
            // 文字のスタイルを設定する
            var builder:TextBuilder = new TextBuilder();
            builder.autoCorrect(false).autoSize().bold();
            
            //カラー設定
            //var dmg : Number = Number(text);
            //var c : uint = 256 * (1 - dmg / 10000);
            //builder.font(Main.FONT, Main.EMBED).fontColor(color1 | c<<8 | c).fontSize(50);
            builder.font(Main.FONT, Main.EMBED).fontColor(color1).fontSize(_size);
//            builder.textBorder(true, 0x404040, 2, 4);
            //var d : uint = c / 2;
            //builder.textBorder(true, color2 | d<<8 | d, 10, 20);
            builder.textBorder(true, color2, 10, (_size/6));
           
            for (var i:int = 0; i < text.length; i++) {
                _chars.push(builder.build(text.charAt(i)));
            }
        }
        
        private function alignChars():void {
            var i:int, charsWidth:Number = 0;
            
            for (i = 0; i < _chars.length; i++) {
                charsWidth += _chars[i].textWidth;
            }
            
            if(_chars[0]){
                _chars[0].x = -int(charsWidth / 2);
                _chars[0].y = -_chars[0].textHeight;
            }
            
            for (i = 1; i < _chars.length; i++) {
                _chars[i].x = _chars[i - 1].x + _chars[i - 1].textWidth;
                _chars[i].y = -_chars[i].textHeight;
            }
        }
        
        //モーショントゥイーン
        private function playTween(event:Event = null):void {
            if (event) { removeEventListener(Event.ENTER_FRAME, playTween); }
            
            var char:TextField = _chars[_charIndex++];
            addChild(char);
            
            // 各文字に適用するトゥーイン
            var tween:ITween = BetweenAS3.bezierTo(char, { y: char.y }, { $y: -(char.textHeight * 2) }, 0.3, Sine.easeInOut);
            tween.onComplete = tweenCompleteHandler;
            tween.play();
            
            if (_charIndex < _chars.length) {
                addEventListener(Event.ENTER_FRAME, playTween);
            }
        }
        
        //
        private function tweenCompleteHandler():void {
            _numCompleted++;
        }
        
        private function checkEveryTweenCompleted(event:Event):void {
            if (_numCompleted == _chars.length) {
                removeEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
                BetweenAS3.serial(
                    BetweenAS3.to(this, { alpha: 0 }, 2.3, Quint.easeInOut),
                    BetweenAS3.removeFromParent(this)
                ).play();
            }
        }
    }
//}

// -----------------------------------------------------------------------------------------
// TextBuilder
// -----------------------------------------------------------------------------------------
//package {
    import flash.filters.GlowFilter;
    import flash.text.*;
    
    //public
    class TextBuilder {
        public static const ALIGN_LEFT:String = "left";
        public static const ALIGN_RIGHT:String = "right";
        public static const ALIGN_CENTER:String = "center";
        
        private var _posX:Number;
        private var _posY:Number;
        
        private var _width:Number;
        private var _height:Number;
        
        private var _background:Boolean;
        private var _backgroundColor:uint;
        
        private var _border:Boolean;
        private var _borderColor:uint;
        
        private var _fontName:String;
        private var _embedFonts:Boolean;
        private var _advancedAntiAlias:Boolean;
        
        private var _fontSize:int;
        private var _fontColor:uint;
        private var _bold:Boolean;
        
        private var _textBorder:Boolean;
        private var _textBorderColor:uint;
        private var _textBorderBlur:Number;
        private var _textBorderStrength:Number;
        
        private var _align:String;
        private var _autoSizeEnabled:Boolean;
        private var _autoCorrectPositionY:Boolean;
        private var _wordWrap:Boolean;
        
        public function TextBuilder() {
            clear();
        }
        
        public function clear():TextBuilder {
            _posX = 0;
            _posY = 0;
            _width = 100;
            _height = 100;
            _background = false;
            _backgroundColor = 0xffffff;
            _border = false;
            _borderColor = 0x000000;
            _fontName = "Arial";
            _embedFonts = false;
            _advancedAntiAlias = false;
            _fontSize = 12;
            _fontColor = 0x000000;
            _bold = false;
            _textBorder = false;
            _textBorderColor = 0xffff00;
            _textBorderBlur = 4;
            _textBorderStrength = 2;
            _align = TextBuilder.ALIGN_LEFT;
            _autoSizeEnabled = false;
            _autoCorrectPositionY = true;
            _wordWrap = false;
            return this;
        }
        
        public function position(x:Number, y:Number):TextBuilder {
            _posX = x;
            _posY = y;
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _width = width;
            _height = height;
            return this;
        }
        
        public function background(enabled:Boolean, color:uint = 0xffffff):TextBuilder {
            _background = enabled;
            _backgroundColor = color;
            return this;
        }
        
        public function border(enabled:Boolean, color:uint = 0x000000):TextBuilder {
            _border = enabled;
            _borderColor = color;
            return this;
        }
        
        public function font(name:String, embed:Boolean = false, advancedAntiAlias:Boolean = false):TextBuilder {
            _fontName = name;
            _embedFonts = embed;
            _advancedAntiAlias = advancedAntiAlias;
            return this;
        }
        
        public function fontSize(size:int):TextBuilder {
            _fontSize = size;
            return this;
        }
        
        public function fontColor(color:uint):TextBuilder {
            _fontColor = color;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function textBorder(enabled:Boolean, color:uint = 0xffff00, blur:Number = 4, strength:Number = 2):TextBuilder {
            _textBorder = enabled;
            _textBorderColor = color;
            _textBorderBlur = blur;
            _textBorderStrength = strength;
            return this;
        }
        
        public function align(value:String = TextBuilder.ALIGN_LEFT):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true):TextBuilder {
            _autoSizeEnabled = enabled;
            return this;
        }
        
        public function autoCorrect(positionY:Boolean = true):TextBuilder {
            _autoCorrectPositionY = positionY;
            return this;
        }
        
        public function wordWrap(enabled:Boolean = true):TextBuilder {
            _wordWrap = enabled;
            return this;
        }
        
        public function build(text:String):TextField {
            var textField:TextField = new TextField();
            
            textField.x = _posX;
            textField.y = _posY;
            textField.width = _width;
            textField.height = _height;
            
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_autoSizeEnabled) {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { textField.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { textField.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { textField.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            
            textField.embedFonts = _embedFonts;
            textField.antiAliasType = (_advancedAntiAlias ? AntiAliasType.ADVANCED : AntiAliasType.NORMAL);
            textField.defaultTextFormat = format;
            textField.text = text;
            
            if (textField.background = _background) { textField.backgroundColor = _backgroundColor; }
            if (textField.border = _border) { textField.borderColor = _borderColor; }
            if (_textBorder) { textField.filters = [new GlowFilter(_textBorderColor, 1, _textBorderBlur, _textBorderBlur, _textBorderStrength)]; }
            if (!(textField.wordWrap = _wordWrap) && _autoCorrectPositionY) { textField.y += Math.max(0, Math.ceil((_height - (textField.textHeight + 4)) / 2)); }
            textField.mouseEnabled = textField.selectable = false;
            
            return textField;
        }
        
        public function clone():TextBuilder {
            var clone:TextBuilder = new TextBuilder();
            clone._posX = _posX;
            clone._posY = _posY;
            clone._width = _width;
            clone._height = _height;
            clone._background = _background;
            clone._backgroundColor = _backgroundColor;
            clone._border = _border;
            clone._borderColor = _borderColor;
            clone._fontName = _fontName;
            clone._embedFonts = _embedFonts;
            clone._advancedAntiAlias = _advancedAntiAlias;
            clone._fontSize = _fontSize;
            clone._fontColor = _fontColor;
            clone._bold = _bold;
            clone._textBorder = _textBorder;
            clone._textBorderColor = _textBorderColor;
            clone._textBorderBlur = _textBorderBlur;
            clone._textBorderStrength = _textBorderStrength;
            clone._align = _align;
            clone._autoSizeEnabled = _autoSizeEnabled;
            clone._autoCorrectPositionY = _autoCorrectPositionY;
            clone._wordWrap = _wordWrap;
            return clone;
        }
    }
//}

