/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fMdu
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import caurina.transitions.Tweener;
	
    public class FlashTest extends Sprite {
		public var _msRatio:Number;
		public var _secRatio:Number;
		public var _minRatio:Number;
		public var _hourRatio:Number;
		
        public function FlashTest() {
			stage.frameRate = 60;
			
			var now:Date = new Date();
			_msRatio = now.milliseconds / (1000 - 1);
			_secRatio = now.seconds / (60 - 1);
			_minRatio = now.minutes / (60 - 1);
			_hourRatio = now.hours / (24 - 1);

			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			var now:Date = new Date();
			var msRatio:Number = now.milliseconds / (1000 - 1);
			var secRatio:Number = now.seconds / (60 - 1);
			var minRatio:Number = now.minutes / (60 - 1);
			var hourRatio:Number = now.hours / (24 - 1);
			
			var intp:Number = 0.5;
			_msRatio = (_msRatio * (1.0 - intp)) + (msRatio * intp);
			_secRatio = (_secRatio * (1.0 - intp)) + (secRatio * intp);
			_minRatio = (_minRatio * (1.0 - intp)) + (minRatio * intp);
			_hourRatio = (_hourRatio * (1.0 - intp)) + (hourRatio * intp);
			
			this.graphics.clear();
			
			this.graphics.beginFill(0x606060);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			var width:Number = 100;
			var height:Number = 400;
			var ellipse:Number = 12;
			
			for (var index:uint = 0; index < 4; ++index) {
				this.graphics.beginFill(0x808080);
				this.graphics.drawRoundRect(calcX(index) + 2, calcY(index) + 2, width, height, ellipse, ellipse);
				this.graphics.endFill();

				this.graphics.beginFill(0xb0b0b0);
				this.graphics.drawRoundRect(calcX(index), calcY(index), width, height, ellipse, ellipse);
				this.graphics.endFill();
			}
			
			this.graphics.beginFill(0xff8080);
			this.graphics.drawRoundRect(calcX(0), calcY(0) + (height * (1.0 - _hourRatio)), width, height * _hourRatio, ellipse, ellipse);
			this.graphics.endFill();

			this.graphics.beginFill(0x8080ff);
			this.graphics.drawRoundRect(calcX(1), calcY(1) + (height * (1.0 - _minRatio)), width, height * _minRatio, ellipse, ellipse);
			this.graphics.endFill();

			this.graphics.beginFill(0xffff40);
			this.graphics.drawRoundRect(calcX(2), calcY(2) + (height * (1.0 - _secRatio)), width, height * _secRatio, ellipse, ellipse);
			this.graphics.endFill();

			this.graphics.beginFill(0x40ff40);
			this.graphics.drawRoundRect(calcX(3), calcY(3) + (height * (1.0 - _msRatio)), width, height * _msRatio, ellipse, ellipse);
			this.graphics.endFill();
		}
		
		private function calcX(i:uint):Number {
			return 17.5 + (i * 110);
		}

		private function calcY(i:uint):Number {
			return 17.5 + (i * 10);
		}
	}
}