/**
 * Copyright Seiya.Kai ( http://wonderfl.net/user/Seiya.Kai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fMIu
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="600",height="600",frameRate="60")]
    public class Main extends Sprite
    {
        //private var WIDTH:Number = 600;
        private var HEIGHT:Number = 600;
        
        private var nextWord:String;
        private var index:int = 0;
        private var textArray:Array = new Array();
        
        public function Main()
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
            stage.addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        protected function onEnterFrame(e:Event):void
        {
            for (var i:int = 0; i < textArray.length; ) 
            {
                if(textArray[i].y > HEIGHT){
                    removeChild(textArray[i]);
                    textArray.splice(i,1);
                } else {
                    i++;
                }
            }    
        }
        
        protected function onMouseMove(e:MouseEvent):void
        {
            nextWord = String.fromCharCode(65+index);
            var tex:MyText = new MyText(nextWord);
            textArray.push(tex);
            addChild(tex);
            tex.x = e.stageX;
            tex.y = e.stageY;
            
            index++;
            
            if(index>25){
                index = 0;
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class MyText extends Sprite
{
    private var angle:Number;
    private var vY:Number = -5;
    private const G:Number = 9.8/60;
    private var vX:Number = Math.random()*10-5;
    
    public function MyText(str:String)
    {
        var tf:TextField = new TextField();
        var format:TextFormat = new TextFormat();
        
        format.size = 50;
        format.color = 0x1000000*Math.random();
        tf.defaultTextFormat = format;
        tf.text = str;
        tf.autoSize = TextFieldAutoSize.LEFT;
        
        var bmp:BitmapData = new BitmapData(tf.width,tf.height,true,0);
        var img:Bitmap = new Bitmap(bmp);
        bmp.draw(tf);
        
        addChild(img);
        img.x = -img.width / 2;
        img.y = -img.height / 2;
        
        angle = 10*Math.random()-5;
        addEventListener(Event.ENTER_FRAME,onEnterFrame);
    }
    
    private function onEnterFrame(e:Event):void
    {
        vY += G;
        this.y += vY;
        this.x += vX;
        rotation += angle;
    }
}