/**
 * Copyright OM2jpn ( http://wonderfl.net/user/OM2jpn )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fLhQ
 */

// forked from o8que's 朝青龍ゲーム
/* -------------------------------------------------------------------
 * いきおいで作ってしまった。反省はしていない。
 * 
 * [inspired by]
 * 昼青龍「朝青龍がやられたようだな・・・」:アルファルファモザイク
 * http://alfalfalfa.com/archives/384861.html
 * -------------------------------------------------------------------
 * [遊び方]
 * 真ん中のボタンをクリックして朝青龍を完成させてください。
 * （完成しても何も起きませんが、気持ちいいと思います）
 * -------------------------------------------------------------------
 * [いじりどころ]
 * SLOT_TEXTの中身を変えるだけで自分だけのスロットマシーンを作れます。
 * -------------------------------------------------------------------
 */
package {
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class MorningBlueDragon extends Sprite {
        public static const SLOT_NUM:int = 3;
        public static const SLOT_SIZE:int = 140;
        private static const SLOT_TEXT:Array = 
        [["天", "夜", "昼", "朝","空","水","懐","童","珍","点"],
         ["花", "草", "秘", "虫","古","悦","白","笑","見","香"],
         ["粉", "水", "蝶", "堂","缶","飴","錠","味","喜","夢"]];
        private var _slots:Array;
        
        public function MorningBlueDragon() {
            _slots = [];
            for (var i:int = 0; i < SLOT_NUM; i++) {
                var slot:Slot = new Slot((i * SLOT_SIZE) + 10, 10);
                slot.setText(SLOT_TEXT[i][0]);
                _slots.push(slot);
                addChild(slot);
            }
            new PushButton(this, SLOT_SIZE + 30, SLOT_SIZE + 20, "click!", clickButton);
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function clickButton(e:Event):void {
            var i:int;
            for (i = 0; i < SLOT_NUM; i++) {
                if (_slots[i].roll) {
                    _slots[i].roll = false;
                    break;
                }
            }
            if (i == SLOT_NUM) {
                for (var j:int = 0; j < SLOT_NUM; j++) {
                    _slots[j].roll = true;
                }
            }
        }
        
        private function update(e:Event):void {
            for (var i:int = 0; i < SLOT_NUM; i++) {
                if (_slots[i].roll) {
                    _slots[i].setText(SLOT_TEXT[i][Math.floor(SLOT_TEXT[i].length * Math.random())]);
                }
            }
        }
    }
}

import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class Slot extends TextField {
    public var roll:Boolean;
    
    public function Slot(posx:int, posy:int) {
        roll = false;
        x = posx; y = posy;
        width = height = MorningBlueDragon.SLOT_SIZE;
        border = true; borderColor = 0x000000;
        selectable = false;
    }
    
    public function setText(str:String):void {
        text = str;
        setTextFormat(new TextFormat(null, MorningBlueDragon.SLOT_SIZE));
    }
}