/**
 * Copyright kjfitzpat ( http://wonderfl.net/user/kjfitzpat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fK1y
 */

// forked from enok's Metaball
/*
Metaball
マウスダウンした状態でマウスを動かすと移動します。
http://processing.org/learning/topics/metaball.html
@enok00
*/
package {
    //import com.flashdynamix.utils.SWFProfiler;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.geom.Vector3D;

    [SWF(backgroundColor="0xffffff", frameRate="40", width="480", height="480")] 

    public class Trick extends Sprite { 
        //メタボールの数
        private var _numBlobs:uint = 4;
        
        //メタボールの初期ポジション
        private var _blogPx:Array = new Array(20 ,20 , 90, 90);
        private var _blogPy:Array = new Array(60, 80, 100, 120);
        
        //メタボールの速度
        private var _blogDx:Array = new Array(1, 1, -1, -1);
        private var _blogDy:Array = new Array(-1, -1, -1, -1);
        
        //ビットマップ
        private var _bmpData:BitmapData;
        
        //各ピクセルの色の関係値
        private var _vx:Array = new Array();
        private var _vy:Array = new Array();
        
        //Drag
        private var _downFlg:Boolean = false;
        
        public function Trick():void {
            //SWFProfiler.init(stage, this);
            //Wonderfl.capture_delay(13);
            Wonderfl.disable_capture();
            
            //処理速度を抑えるため
            scaleX = scaleY = 3;
            
            //ビットマップ配置
            _bmpData = new BitmapData(160, 160);
            var bitmap:Bitmap = new Bitmap(_bmpData);
            addChild(bitmap);
            
            //描画
            addEventListener(Event.ENTER_FRAME, draw);
            
            //マウス
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function():void {
                _downFlg = true;
            });
            stage.addEventListener(MouseEvent.MOUSE_UP, function():void {
                _downFlg = false;
            });
        }
        
        private function draw(e:Event = null):void {
            var x:uint, y:uint, i:uint;
            var color:uint, r:uint, g:uint, b:uint;
            
            _bmpData.lock();
            for (i = 0; i < _numBlobs; ++i) {
                //速度追加
                if(_downFlg){
                    _blogDx[i] += (int)(stage.stageWidth / 2 - stage.mouseX) * 0.0001;
                    _blogDy[i] += (int)(stage.stageHeight / 2 - stage.mouseY) * 0.0001;
                }
                
                _blogPx[i] += _blogDx[i];
                _blogPy[i] += _blogDy[i];
                
                //跳ね返り時の処理
                if (_blogPx[i] < 0) {
                    _blogDx[i] = Math.random();
                }
                if (_blogPx[i] > _bmpData.width) {
                    _blogDx[i] = -Math.random();
                }
                if (_blogPy[i] < 0) {
                    _blogDy[i] = Math.random();
                }
                if (_blogPy[i] > _bmpData.height) {
                    _blogDy[i]=-Math.random();
                }
                
                //各ピクセルとビットマップのX位置との差の累乗 -　色の係数
                _vx[i] = new Array();
                for (x = 0; x < _bmpData.width; x++) {
                    _vx[i][x] = int(Math.pow(_blogPx[i] - x, 2));
                }

                //各ピクセルとビットマップのY位置との差の累乗 -　色の係数
                _vy[i] = new Array();
                for (y = 0; y < _bmpData.height; y++) {
                    _vy[i][y] = int(Math.pow(_blogPy[i] - y, 2));
                }
            }
            
            for (y = 0; y < _bmpData.height; y++) {
                for (x = 0; x < _bmpData.width; x++) {
                    var m:int = 1;
                    for (i = 0; i < _numBlobs; i++ ) {
                        //メタボボールの色係数
                        m += (60000 * (i + 2) * 3 / _numBlobs) / (_vy[i][y] + _vx[i][x] + 1);
                    }
                    
                    //各ピクセルの色を設定
                    r = Math.min(255, (m + y)/2);
                    g = Math.min(255, (m + x));
                    b = Math.min(255, (x + m + y) / 2);
                    color = r << 16 | g << 8 | b;
                    
                    //ビットマップに設定
                    _bmpData.setPixel(x, y, color);
                }
            }
            _bmpData.unlock();
        }
    }
}
