/**
 * Copyright nijitaro ( http://wonderfl.net/user/nijitaro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fJwA
 */

// forked from nijitaro's PV3Dで星空
/**
 * 星空ムービー forked from PV3Dで星空
 *
 * [感想]
 * Planeと同様にSphereにもVideoStreamMaterialを貼れた。
 * 下の課題にあった、カメラの回転は三角関数を使うようだ。
 *
 * [課題](clear!)
 * ただxを増やしているのでカメラがどんどん離れてしまう。
 * 原点を中心にカメラを回したい。
 *
 * - ParticleMaterial
 * - ParticleField
 */
package {

	import flash.events.Event;
	
	import flash.media.Video;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	
	import flash.system.Security;
	
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.materials.VideoStreamMaterial;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.materials.special.ParticleMaterial;
    [SWF( backgroundColor = "#000010", frameRate = "50" )]

    public class Main extends BasicView
    {
		private var stars:ParticleField;
		private var sphere:Sphere;
		
		private var video:Video;
		private var nc:NetConnection;
		private var ns:NetStream;
		private var meta:Object;

		private var rot:Number = 0;
		
        public function Main ()
        {
			// 以下 ( http://wonderfl.net/code/2de1045328694bcdc80fdb0dc1cb0afe77285381 ) より
			Security.loadPolicyFile("http://hokypoky.info/crossdomain.xml");
			video = new Video(478,359);
			nc = new NetConnection();
			nc.connect(null);
			ns = new NetStream(nc);
			ns.play("http://hokypoky.info/samples/10/01/video.flv");
			
			var client:Object = new Object();
			client.onMetaData = metaDataHandler;
			ns.client = client;
			meta = new Object;
            
			video.attachNetStream(ns);
			
			// マテリアル作成
			var material:ParticleMaterial = new ParticleMaterial( 0xffffcc, 0.5 );

			// ParticleFieldにマテリアルを貼る
			stars = new ParticleField(material);

			scene.addChild(stars);

			sphere = new Sphere( new VideoStreamMaterial(video, ns, true, false), 200, 16, 16 );
			scene.addChild(sphere);
					
			// BasicViewはDisplayObject.ZERO(原点)をターゲッティングしているので、
			// 原点を中心にして廻っているような動きをしている。
			// 以下のコメントを外すと、カメラが並行移動する
			//camera.target = null;
			
			startRendering();
		}
		private function metaDataHandler (data:Object):void {
			meta = data;
        }
        override protected function onRenderTick (event :Event = null):void
        {
			// http://clockmaker.jp/blog/2009/05/papervision3d_tutorial_5/ 参照
			rot += 0.1;
			camera.x = 1000 * Math.sin(rot * Math.PI / 180)
			camera.z = 1000 * Math.cos(rot * Math.PI / 180)
			
        		// SuperクラスのonRenderTick
        		super.onRenderTick(event);
        	}
    }
}