/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fJm9
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.Bitmap;
    import flash.display.BitmapData;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	
	[SWF(framerate="30",width="480",height="480",backgroundColor="0x000000")]
	public class Practice06 extends Sprite
	{
        private var bitmap:BitmapData;
		private var blur:BlurFilter = new BlurFilter(10, 10, 2);
		private var point:Point = new Point();
		private var hour:Number;
        private var min:Number;
        private var sec:Number;
		
		public function Practice06() 
		{
			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
			stage.addChild(new Bitmap(bitmap));
			stage.addEventListener(Event.ENTER_FRAME, update);
			graphics.lineStyle(1, 0x00ffff) ;
			graphics.drawCircle(240, 240, 236);
		}
		
		private function update(e:Event):void {
			clock();
			var rad:Number = getRad(hour * 5);
			addChild(new Circle(240, 240, 5, 0x0000ff, Math.cos(rad) * 230 + 240, Math.sin(rad) * 230 + 240, 30));
			rad = getRad(min);
			addChild(new Circle(240, 240, 5, 0x00ff00, Math.cos(rad) * 230 + 240, Math.sin(rad) * 230 + 240, 30));
			rad = getRad(sec);
			addChild(new Circle(240, 240, 5, 0xff0000, Math.cos(rad) * 230 + 240, Math.sin(rad) * 230 + 240,45));
			bitmap.lock();
			bitmap.applyFilter(bitmap, bitmap.rect, point, blur)
			bitmap.draw(this);
			bitmap.unlock()
		}
		
		private function clock():void {
			var date:Date = new Date();
			hour = date.getHours();
			if (hour > 12) hour -= 12;
			min = date.getMinutes();
			sec = date.getSeconds();
		}
		
		private function getRad(m:Number):Number {
			return -(90 - m * 6)/180*Math.PI;
		}
	}

}
import flash.display.MovieClip;
import caurina.transitions.Tweener;

class Circle extends MovieClip {
	
	public function Circle(x:int, y:int, r:int, c:int,cx:int,cy:int,t:int) {
		graphics.lineStyle(2, c) ;
		graphics.beginFill(c);
		graphics.drawCircle(x, y, r);
		graphics.endFill();
		Tweener.addTween( this, { x:cx, y:cy, scaleX:0.05, scaleY:0.05, time:t, useFrames:true, transition:"easeOutExpo",onComplete:complete});
	}
	
	private function complete():void {
		this.parent.removeChild(this);
	}
}