/**
 * Copyright purebluestar ( http://wonderfl.net/user/purebluestar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fIbS
 */

package {
    import net.wonderfl.utils.FontLoader;
    import flash.system.LoaderContext;
    import flash.utils.Dictionary;
    import flash.display.LoaderInfo;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;


    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0xFFCC99")]

    public class FlashTest extends Sprite {
        // キャラクターイメージBitmapData
        private var bitmapdata_Characters:Vector.<Vector.<BitmapData>> = new Vector.<Vector.<BitmapData>>();    //  16*16ピクセル
        // 武器イメージBitmapData
        private var bitmapdata_Weapons:Vector.<BitmapData> = new Vector.<BitmapData>(32, 24);    // 32*24ピクセル
        
        
        public function FlashTest() {
            var floader:FontLoader = new FontLoader();
            floader.load("Azuki");
            floader.addEventListener(Event.COMPLETE, imgload);
        }

        private function imgload(e:Event):void {
            var url:String = "http://assets.wonderfl.net/images/related_images/a/a1/a178/a1789e286ac81942a7db4029fb56e4b46b21c8bb"
            var urlReq:URLRequest = new URLRequest(url);
            var loader:Loader = new Loader();
            var context:LoaderContext = new LoaderContext();
            context.checkPolicyFile = true;
            loader.load(urlReq,context);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, initialize);
        }

        private function initialize(e:Event):void {
            var loader:Loader = e.currentTarget.loader;
            var url_bitmapdata:BitmapData = new BitmapData(loader.width,loader.height, true, 0x00000000);
            url_bitmapdata.draw(loader);

            // BitmapData を要素とする Vector その1(キャラクター1)
            bitmapdata_Characters[0] = new Vector.<BitmapData>(16, 16);    // 16*16ピクセル
            // BitmapData を要素とする Vector その2(キャラクター2)
            bitmapdata_Characters[1] = new Vector.<BitmapData>(16, 16);    // 16*16ピクセル
            // BitmapData を要素とする Vector その3(ソウルジェム)
            bitmapdata_Characters[2] = new Vector.<BitmapData>(16, 16);    // 16*16ピクセル
            
            for (var x:int = 0; x < 3; x++) {            
                for (var y:int = 0; y < 11; y++) {
                    bitmapdata_Characters[x][y] = bitmapdata_Clip(url_bitmapdata, 16 * x, 16 * y, 16, 16);
                }
            }
            var i:int = 0;
            for ( y = 0; y < 4; y++) {            
                for ( x = 0; x < 3; x++) {
                    bitmapdata_Weapons[i] = bitmapdata_Clip(url_bitmapdata, 48+(32*x), 24*y, 32, 24);    // 32*24ピクセル
                    i++;
                }
            }

            // アイコン
            var Icon_Palette:IconPalette = new IconPalette();
            Icon_Palette.x = 325;
            Icon_Palette.y = 3;
            stage.addChild(Icon_Palette);
            var ii:int = 0;
            // キャラクターアイコン
            for ( x = 0; x < 3 ; x++) {
                for ( y = 0; y < 11 ; y++) {
                    Icon_Palette.setIconimg(bitmapdata_Resize(bitmapdata_Characters[x][y], 2, 2), bitmapdata_Characters[x][y], ii);
                    ii++;
                }
            }
            // 武器アイコン
            var point:Point = new Point();
            var rect:Rectangle = new Rectangle(0, 0, 32, 32)
            var icon_correction_x:Array = new Array(-4,  0,  0, -1, -2, -1, -2, -4, 0, 0, 0, 2);  // X軸表示補正値(アイコン)
            var icon_correction_y:Array = new Array(-3, -3, -3, -1, -2, -4, -4, -2, 1, 1, 1, 2);  // Y軸表示補正値(アイコン)
            for ( y = 0; y < 12 ; y++) {            
                var bitmapdata:BitmapData = new BitmapData(32, 32, true, 0x00000000);
                point.x = icon_correction_x[y];
                point.y = icon_correction_y[y];
                bitmapdata.copyPixels(bitmapdata_Resize(bitmapdata_Weapons[y], 1.25, 1.25), rect, point, null, null, true);    // 描画
                Icon_Palette.setIconimg(bitmapdata, bitmapdata_Weapons[y], ii);
                ii++;
            }

            // 表示部
            var main_Sprite:Sprite = new Sprite();    // 選択表示
            main_Sprite.x = Const.DSP_SPRITE_X;
            main_Sprite.y = Const.DSP_SPRITE_Y;
            main_Sprite.buttonMode = true;
            addChild(main_Sprite);
            Icon_Palette.set_mainSprite(main_Sprite);
            var sub_Sprite:Sprite = new Sprite();    // ロールオーバー
            sub_Sprite.x =  Const.DSP_SPRITE_X;
            sub_Sprite.y =  Const.DSP_SPRITE_Y;
            addChild(sub_Sprite);
            Icon_Palette.set_subSprite(sub_Sprite);
            
            Icon_Palette.configuration();
            
            // 背景
            graphics.beginFill(Const.INSIDE_BACKCOLOR);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            for ( x = 0; x < 4 ; x++) {
                for ( y = 0; y < 12 ; y++) {            
                }
            }
        }

        public function bitmapdata_Resize(src:BitmapData, hRatio:Number, vRatio:Number):BitmapData {
            var res:BitmapData = new BitmapData(Math.ceil(src.width * hRatio), Math.ceil(src.height * vRatio), true, 0x00000000);
            //第6引数(smoothing)を true とすることで、拡大・縮小されたときに画像が粗くなってしまうことを防いでいる。(ここではfalse)
            res.draw(src, new Matrix(hRatio, 0, 0, vRatio), null, null, null, false);
            return res;
        }

        public function bitmapdata_Clip(src:BitmapData, x:int, y:int, w:int, h:int):BitmapData {
            var res:BitmapData = new BitmapData(w, h, true, 0x00000000);    // 透過
            res.copyPixels(src, new Rectangle(x, y, w, h), new Point(0, 0));
            return res;
        }
    }
}


    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.CapsStyle;
    import flash.display.GradientType;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import com.bit101.components.PushButton;
    import com.bit101.components.Label;
    import com.bit101.components.*;
   
    
    class IconPalette extends Sprite {    
        public var bitmapdata_Icons:Vector.<BitmapData> = new Vector.<BitmapData>();
        public var main_Sprite:Sprite;
        public var sub_Sprite:Sprite;
        public var index:int;
        public var flip:Boolean = false;
        
        public function IconPalette() {
            with (graphics) {
                drawBackground();                       // 背景(黒グラデ)    
                beginFill(Const.OUTSIDE_BACKCOLOR);
                drawRect(140, -3, 500, 466);            // 背景・右部
                drawRect(-825, -503, 1465, 500);        // 背景・上部
                drawRect(-825, -3, 500, 466);           // 背景・左部
                drawRect(-825, 463, 1465, 500);         // 背景・下部
                beginFill(Const.BACKCOLOR);
                drawRect(-5, -3, 145, 466);             // 背景・右部アイコン
                drawRect(-325, 416, 320, 47);           // 背景・下部
                drawRect(-325, -3, 320, 4);             // 背景・上部
                drawRect(-325, 1, 3, 415);              // 背景・左部
                // 背景(小さい□)
                lineStyle(2, 0x333333);
                for ( x = 0; x < 4 ; x++) {
                    for ( y = 0; y < 12 ; y++) {            
                        drawRect(35 * x, 35 * y, 32, 32);    // XOR
                    }
                }
                endFill();
                lineStyle(2, 0x333333);
                drawRoundRect(-322, 0, 318, 417, 8, 8);    // 背景(大きい□)
            }
            
            // キャラクターアイコン
            var i:int = 0;
            for ( x = 0; x < 4 ; x++) {
                for ( y = 0; y < 11 ; y++) {
                    var sprite:Sprite = new Sprite();
                    sprite.addChild(new Bitmap(new BitmapData(32, 32, false, 0x000000)));
                    sprite.x = 35 * x;
                    sprite.y = 35 * y;
                    sprite.buttonMode = true;
                    addChild(sprite);
                    sprite.name = String(i); 
                    sprite.addEventListener(MouseEvent.CLICK, icon_clickHandler);
                    sprite.addEventListener(MouseEvent.ROLL_OVER, icon_rollOverHandler);
                    sprite.addEventListener(MouseEvent.ROLL_OUT, icon_rollOutHandler);
                    i++;
                    }
            }
            // スピア
            sprite = new Sprite();
            sprite.addChild(new Bitmap(new BitmapData(32, 32, false, 0x000000)));
            sprite.x = 35 * 3;
            sprite.y = 35 * 11;
            sprite.buttonMode = true;
            addChild(sprite);
            sprite.name = String(i); 
            sprite.addEventListener(MouseEvent.CLICK, icon_clickHandler);
            sprite.addEventListener(MouseEvent.ROLL_OVER, icon_rollOverHandler);
            sprite.addEventListener(MouseEvent.ROLL_OUT, icon_rollOutHandler);

            // ロールアウト処理用Sprite
            sprite = new Sprite();
            sprite.x = -2;
            sprite.y = -2;
            sprite.addChild(new Bitmap(new BitmapData(141, 421, true, 0x00000000)));
            sprite.addEventListener(MouseEvent.ROLL_OUT, iconpalette_rollOutHandler);
            addChildAt(sprite, 0);
            sprite = new Sprite();
            sprite.x = -2;
            sprite.y = 384;
            sprite.addChild(new Bitmap(new BitmapData(105, 35, true, 0x00000000)));
            sprite.addEventListener(MouseEvent.ROLL_OVER, iconpalette_rollOutHandler);
            addChildAt(sprite, 1);

            // フォント
            //Style.embedFonts = false;
            Style.fontName = "Azuki";
            Style.fontSize = 20; // デフォルトのサイズは8

            // 拡大/縮小ボタン
            sprite = new Sprite();
            var pushbutton:Vector.<PushButton> = new Vector.<PushButton>;
            pushbutton[0] = new PushButton(null, -322,420, "－－", min_button_clickHandler);
            pushbutton[0].width = 50;
            pushbutton[0].height = 40;
            sprite.addChild(pushbutton[0]);
            pushbutton[1] = new PushButton(null, -272,420, "－ (縮小)", down_button_clickHandler);
            pushbutton[1].width = 110;
            pushbutton[1].height = 40;
            sprite.addChild(pushbutton[1]);
            pushbutton[2] = new PushButton(null, -162,420, "＋ (拡大)", up_button_clickHandler);
            pushbutton[2].width = 110;
            pushbutton[2].height = 40;
            sprite.addChild(pushbutton[2]);
            pushbutton[3] = new PushButton(null, -52,420, "＋＋", max_button_clickHandler);
            pushbutton[3].width = 50;
            pushbutton[3].height = 40;
            sprite.addChild(pushbutton[3]);
            pushbutton[4] = new PushButton(null, -2,420, "←|→(反転)", flip_button_clickHandler);
            pushbutton[4].width = 139;
            pushbutton[4].height = 40;
            sprite.addChild(pushbutton[4]);
            sprite.addEventListener(MouseEvent.ROLL_OVER, rollOverHandler);
            sprite.addEventListener(MouseEvent.ROLL_OUT, rollOutHandler);
            addChild(sprite);
        }

        public function configuration():void {
            index = 3; //  マミさん
            draw_mainsprite(main_Sprite, bitmapdata_Icons[3], 3);    // マミさん
            var sprite:Sprite =  new Sprite();
            sprite = this.getChildByName(String(index)) as Sprite;
            sprite.graphics.beginFill(Const.SELECTED_ICON_BACKCOLOR);
            sprite.graphics.drawRect(0, 0, 32, 32);        //  マミさん背景
            }

        public function setIconimg(bmd:BitmapData, org_bmp:BitmapData, index:int):void {
            var sprite:Sprite = this.getChildByName(String(index)) as Sprite;
            var bm:Bitmap = sprite.getChildAt(0) as Bitmap;
            // アイコン用
            bm.bitmapData = bmd;
            // 表示用
            bitmapdata_Icons[index] = org_bmp;
        }

        public function set_mainSprite(sp:Sprite):void {
            main_Sprite = sp;
            main_Sprite.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            main_Sprite.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            main_Sprite.addEventListener(MouseEvent.MOUSE_OUT, mouseUpHandler);
            main_Sprite.addEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
            main_Sprite.addEventListener(MouseEvent.ROLL_OVER, rollOverHandler);
            main_Sprite.addEventListener(MouseEvent.ROLL_OUT, rollOutHandler);
        }

        public function set_subSprite(sp:Sprite):void {
            sub_Sprite = sp;
        }
        
        private function iconpalette_rollOutHandler(event:Event):void {
            main_Sprite.visible = true;
            sub_Sprite.visible = false;
        }            

        private function icon_rollOverHandler(event:Event):void {
            var sprite:Sprite = event.currentTarget as Sprite;        
            draw_mainsprite(sub_Sprite, bitmapdata_Icons[int(sprite.name)], int(sprite.name));    // 描画
            main_Sprite.visible = false;
            sub_Sprite.visible = true;
            }            

        private function icon_rollOutHandler(event:Event):void {
            if (mouseX <= 0 || mouseY <= 0 || mouseX >= 130 || mouseY >= 417 || (mouseX >= 0 && mouseX <= 105) && (mouseY >= 382)) {
                main_Sprite.visible = true;
                sub_Sprite.visible = false;
            }
        }            

           private function icon_clickHandler(event:Event):void {
            var sprite:Sprite = event.currentTarget as Sprite;
            var sp:Sprite = this.getChildByName(String(index)) as Sprite;
            sp.graphics.drawRect(0, 0, 32, 32);        //  背景変更XOR(元に戻す)
            index = int(sprite.name);        //  インデックス値
            
            sprite.graphics.beginFill(Const.SELECTED_ICON_BACKCOLOR);
            sprite.graphics.drawRect(0, 0, 32, 32);        //  背景変更
            
            main_Sprite.x = Const.DSP_SPRITE_X;        // 表示座標
            main_Sprite.y = Const.DSP_SPRITE_Y;

            draw_mainsprite(main_Sprite, bitmapdata_Icons[int(sprite.name)], int(sprite.name));    // 描画
            
            flip = false;    // 反転判別
        }
        
        private function mouseDownHandler(event:Event):void {
            main_Sprite.startDrag();
        }
        
        private function mouseUpHandler(event:Event):void {
            main_Sprite.stopDrag();
        }

        private function mouseWheelHandler(event:MouseEvent):void {
            var bitmap:Bitmap = main_Sprite.getChildAt(0) as Bitmap;  // 表示倍率取得 
            var bitmapdata:BitmapData = bitmapdata_Icons[index];
            var times:Number = times = (bitmap.width / bitmapdata.width);  //  表示倍率
            if (event.delta > 0) {
                if (times >= 50) return;    // 倍率上限
                times = times + 2;
                main_Sprite.x = main_Sprite.x - ((bitmapdata.width * times) - main_Sprite.width ) / 2;
                main_Sprite.y = main_Sprite.y - ((bitmapdata.height * times) - main_Sprite.height ) / 2;
                }else{
                if (times <= 2) return;        // 倍率下限
                times = times - 2;
                main_Sprite.x = main_Sprite.x + ((main_Sprite.width - bitmapdata.width * times)) / 2;
                main_Sprite.y = main_Sprite.y + ((main_Sprite.height - bitmapdata.height * times)) / 2;
                }
            draw_mainsprite(main_Sprite, bitmapdata_Icons[index], index, times);    // 描画
            redrawroundrect();
            if (flip) flip_button_clickHandler();
            revise_coordinate();
        }
        
        private function rollOverHandler(event:Event):void {
            redrawroundrect();
            main_Sprite.visible = true;
            sub_Sprite.visible = false;
        }            

        private function rollOutHandler(event:Event):void {
            main_Sprite.graphics.clear();
        }            

        private function min_button_clickHandler(event:Event):void {
            var bitmap:Bitmap = main_Sprite.getChildAt(0) as Bitmap;  // 表示倍率取得 
            var bitmapdata:BitmapData = bitmapdata_Icons[index];
            var times:Number = times = (bitmap.width / bitmapdata.width);  //  表示倍率
            if (times <= 2) return;        // 倍率下限
            times = 2;
            main_Sprite.x = main_Sprite.x + ((main_Sprite.width - bitmapdata.width * times)) / 2;
            main_Sprite.y = main_Sprite.y + ((main_Sprite.height - bitmapdata.height * times)) / 2;
            draw_mainsprite(main_Sprite, bitmapdata_Icons[index], index, times);    // 描画
            redrawroundrect();
            if (flip) flip_button_clickHandler();
            revise_coordinate();
        }
        
        private function down_button_clickHandler(event:Event):void {
            var bitmap:Bitmap = main_Sprite.getChildAt(0) as Bitmap;  // 表示倍率取得 
            var bitmapdata:BitmapData = bitmapdata_Icons[index];
            var times:Number = times = (bitmap.width / bitmapdata.width);  //  表示倍率
            if (times <= 2) return;        // 倍率下限
            times = times - 2;
            main_Sprite.x = main_Sprite.x + ((main_Sprite.width - bitmapdata.width * times)) / 2;
            main_Sprite.y = main_Sprite.y + ((main_Sprite.height - bitmapdata.height * times)) / 2;
            draw_mainsprite(main_Sprite, bitmapdata_Icons[index], index, times);    // 描画
            redrawroundrect();
            if (flip) flip_button_clickHandler();
            revise_coordinate();
        }            
        
        private function up_button_clickHandler(event:Event):void {
            var bitmap:Bitmap = main_Sprite.getChildAt(0) as Bitmap;  // 表示倍率取得 
            var bitmapdata:BitmapData = bitmapdata_Icons[index];
            var times:Number = times = (bitmap.width / bitmapdata.width);  //  表示倍率
            if (times >= 50) return;    // 倍率上限
            times = times + 2;
            main_Sprite.x = main_Sprite.x - ((bitmapdata.width * times) - main_Sprite.width ) / 2;
            main_Sprite.y = main_Sprite.y - ((bitmapdata.height * times) - main_Sprite.height ) / 2;
            draw_mainsprite(main_Sprite, bitmapdata_Icons[index], index, times);    // 描画
            redrawroundrect();
            if (flip) flip_button_clickHandler();
            revise_coordinate();
        }            
        
        private function max_button_clickHandler(event:Event):void {
            var bitmap:Bitmap = main_Sprite.getChildAt(0) as Bitmap;  // 表示倍率取得 
            var bitmapdata:BitmapData = bitmapdata_Icons[index];
            var times:Number = times = (bitmap.width / bitmapdata.width);  //  表示倍率
            if (times >= 50) return;    // 倍率上限
            times = 50;
            main_Sprite.x = main_Sprite.x - ((bitmapdata.width * times) - main_Sprite.width ) / 2;
            main_Sprite.y = main_Sprite.y - ((bitmapdata.height * times) - main_Sprite.height ) / 2;
            draw_mainsprite(main_Sprite, bitmapdata_Icons[index], index, times);    // 描画
            redrawroundrect();
            if (flip) flip_button_clickHandler();
            revise_coordinate();
        }

        private function flip_button_clickHandler(event:Event = null):void {
            var bitmap:Bitmap = new Bitmap();
            bitmap = main_Sprite.getChildAt(0) as Bitmap;
            var src_bitmapdata:BitmapData = bitmap.bitmapData;
            var matrix:Matrix = new Matrix();
            matrix.scale(-1, 1);            
            matrix.translate(main_Sprite.width, 0);
            var bitmapdata:BitmapData = new BitmapData(main_Sprite.width, main_Sprite.height, true, 0x00000000); 
            bitmapdata.draw(src_bitmapdata, matrix);
            bitmap.bitmapData = bitmapdata;

            if ( event != null) flip = !flip;
        }
        
        private function redrawroundrect():void {
            main_Sprite.graphics.clear();
            main_Sprite.graphics.beginFill(Const.OUTSIDE_BACKCOLOR, 0.75);
            main_Sprite.graphics.drawRoundRect(0, 0, main_Sprite.width, main_Sprite.height,12,12);
        }

        private function revise_coordinate():void {
            if ((main_Sprite.y + main_Sprite.height) < 32) main_Sprite.y = 32 - main_Sprite.height;
            if (main_Sprite.x > 288) main_Sprite.x = 288;
            if (main_Sprite.y > 387) main_Sprite.y = 387;
            if ((main_Sprite.x + main_Sprite.width) < 32) main_Sprite.x = 32 - main_Sprite.width;
        }
        
        public function draw_mainsprite(sp:Sprite, src:BitmapData, index:int, times:Number = 0):void {
            if (times == 0) {                                // times!=0の時はmouseWheelHandlerのイベント
                if (index >= 33) {                            // 武器 
                    times = Const.DSP_MAGNIFICATION_WEAPONS;
                } else {
                    times = Const.DSP_MAGNIFICATION;
                }
            }

            var point:Point = new Point(0, 0);
            var rect:Rectangle = new Rectangle(0, 0, times * src.width, times * src.height);
            var bitmapdata:BitmapData = new BitmapData(times * src.width, times * src.height, true, 0x00000000);
            var bitmap:Bitmap = new Bitmap();
            
            bitmapdata.copyPixels(bitmapdata_Resize(src, times, times), rect, point, null, null, true);

            if (sp.numChildren == 0) {        // 初めだけ
                bitmap.bitmapData = bitmapdata;
                sp.addChild(bitmap);
            } else {
                bitmap = sp.getChildAt(0) as Bitmap;
                bitmap.bitmapData = bitmapdata;
            }
        }

        public function bitmapdata_Resize(src:BitmapData, hRatio:Number, vRatio:Number):BitmapData {
            var res:BitmapData = new BitmapData(Math.ceil(src.width * hRatio), Math.ceil(src.height * vRatio), true, 0x00000000);
            //第6引数(smoothing)を true とすることで、拡大・縮小されたときに画像が粗くなってしまうことを防いでいる。(ここではfalse)
            res.draw(src, new Matrix(hRatio, 0, 0, vRatio), null, null, null, false);
            return res;
        }
        
        private function drawBackground():void {
            drawWindow(graphics, -3, -3, 143, 466);
        }

        public static function drawWindow(graphics:Graphics, x:Number, y:Number, width:Number, height:Number):void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(width, height, Math.PI / 2, x, y);
            graphics.beginGradientFill(GradientType.LINEAR, [0x555577, 0x333344], [1, 1], [0, 255], matrix);
            graphics.drawRect(x, y, width, height);
            graphics.endFill();
        }
    }

    class Const {
        public static const DSP_MAGNIFICATION:int = 18;                    // 表示倍率(キャラクター)
        public static const DSP_MAGNIFICATION_WEAPONS:int = 12;            // 表示倍率(武器)
        public static const SELECTED_ICON_BACKCOLOR:int = 0xFFFFCC;        // アイコン背景色(選択時)
        public static const BACKCOLOR:int = 0xFFCC99;                    　// 背景色
        public static const INSIDE_BACKCOLOR:int = 0xFFFFFF;            　 // 背景色(表示部)
        public static const OUTSIDE_BACKCOLOR:int = 0xFFCCCC;            　// 背景色(範囲外)
        public static const DSP_SPRITE_X:int = 16;
        public static const DSP_SPRITE_Y:int = 50;
    }

