/**
 * Copyright hiragana ( http://wonderfl.net/user/hiragana )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fIZM
 */

// forked from bradsedito's [P.2] TangentialEllipticParticles


package {
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.DisplacementMapFilter;
    [SWF(backgroundColor=0x0,frameRate=100, width="1000", height="618")]
    
    public class TangentialEllipticParticles extends Sprite 
    {
        private var Particles:Array;
        private var numParticles:uint = 100;
        public  var mY:Number = new Number( stage.mouseY );
        //public var BmD:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x131413);
        public function TangentialEllipticParticles() 
        {
              //      var cT:DisplacementMapFilter = new DisplacementMapFilter(BmD, null,0,0);

            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            Particles = new Array();
            for(var i:uint = 0; i < numParticles; i++)
            {
                var mass : Number = Math.random() * Math.random() * 10 + 1;
                var Particle:Ball = new Ball(Math.pow(mass, 1/3) * 4, 0xffffff);
                Particle.x = Math.random() * stage.stageWidth;
                Particle.y = Math.random() * stage.stageHeight;
                Particle.mass = mass;
                Particle.alpha = mass / 15 + 0.1;
                addChild(Particle);
                Particles.push(Particle);
            }          
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void{
            
            var gx : Number = 0;
            var gy : Number = 0;
            var smass : Number = 0;
        for(var i:uint = 0; i < numParticles; i++){
        var Particle:Ball = Particles[i];
        
        
///////////START       
//      var   nH:Number = new Number( 4 );  
//      var   nK:Number = new Number( 4 );  
//      var   nA:Number = new Number( 0 );  
//      var   nB:Number = new Number( 0 );  
//      var nOne:Number = new Number( 1 );  
// Equation P1       ( ((Particle.x - h)^2) / (a^2) )  
// Equation P2    +  ( ((Particle.y - k)^2) / (b^2) )   =    nOne;  
//--------------------------------------------------------------------------------------------
// Compresses to:    ( (((Particle.x-h)^2)/(a^2)) + (((Particle.y-k)^2)/(b^2)) ) = nOne;
//--------------------------------------------------------------------------------------------
// Now, instantiate into SWF:
      var   nH:Number = new Number( 4 );  
      var   nK:Number = new Number( 4 );  
      var   nA:Number = new Number( 0 );  
      var   nB:Number = new Number( 0 );  
      var nOne:Number = new Number( 1 );  
      ( ((((Particle.x+=Particle.vx)-nH)^2)/(nA^2)) + ((((Particle.y+=Particle.vy)-nK)^2)/(nB^2)) ) == 1;
///////////END      

            gx += (Particle.x - stage.stageWidth / 2) * Particle.mass;
            gy += (Particle.y - stage.stageHeight / 2) * Particle.mass;
            smass += Particle.mass;
            }
            gx /= smass;
            gy /= smass;
 //                Particle.z -=   ( (gx+gy)/2 ) ; 
           
        for(i = 0; i < numParticles; i++){
        Particle = Particles[i];
            Particle.x     -=   gx; 
            Particle.y     -=   gy;
                Particle.z -=   ( (gx+gy)/2 ) ; 
            }
            
            for(i = 0; i < numParticles - 1; i++){
                var PartA:Ball = Particles[i];
                for(var j:uint = i + 1; j < numParticles; j++){
                    var PartB:Ball = Particles[j];
                    gravitate(PartA,PartB);
                }
            }          
        }
        private function gravitate(PartA:Ball,PartB:Ball):void{
            PartA.mass = 15;
            PartB.mass = 15;
            var dx:Number = PartB.x - PartA.x;
            var dy:Number = PartB.y - PartA.y;
            var distSQ:Number = dx * dx + dy * dy;
            var dist:Number = Math.sqrt(distSQ);
            if(dist < 50)dist = 50; 
            var force:Number = PartA.mass * PartB.mass / distSQ;
            var ax:Number = force * dx / dist;
            var ay:Number = force * dy / dist;
            PartA.vx += ax / PartA.mass;
            PartA.vy += ay / PartA.mass;
            PartB.vx -= ax / PartB.mass;
            PartB.vy -= ay / PartB.mass;
        }
    }
}
//import flash.filters.DisplacementMapFilter;
import flash.geom.ColorTransform;
import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
class Ball extends Sprite{   
    public var radius:Number; 
   private var color:ColorTransform; 
   private var Ctf:ColorTransform = new ColorTransform(.9,.9,.9,.9);
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var mass:Number = 20;
    public function Ball(radius:Number=5000,color:uint=0xffffff) 
    {
        var gloww:GlowFilter = new GlowFilter(0xffffff*Math.random(),1,3,3,2,2,true);
        var blurr:BlurFilter = new BlurFilter( 6,6,2 );   
        this.blendMode = "add";
        this.scaleX = 4;
        this.scaleY = 4;
        this.radius  = radius;
        this.color   = Ctf;
        this.filters = [blurr, gloww];       
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill();
    }
}