/**
 * Copyright ben.garney ( http://wonderfl.net/user/ben.garney )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fII5
 */

// forked from tencho's MediaRSS City
// forked from Event's Simple MediaRSS Viewer
/**
 * flickrで検索した画像が広告になります。
 * 広告をクリックするとちょっと大きい画像が見れます。
 */
package  {
    import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.system.*;
    public class AdCity extends Sprite {
        private var _flickr:Flickr = new Flickr();
        private var _map:MapView = new MapView();
        private var _bg:Sprite;
        private var _sky:Sprite;
        private var _mouseOverSprite:Sprite = new Sprite();
        private var _canvas:BitmapData = new BitmapData(Display.WIDTH, Display.HEIGHT, true, 0);
        private var _loader:ImageLoader = new ImageLoader()
        private var _viewer:Viewer = new Viewer();
        private var _loading:Label;
        private var _drag:MouseDrag;
        private var _search:SearchDialog = new SearchDialog();
        private var _menu:TopMenu;
        public var easeScale:Number = 3;
        private var _mousePos:Point = new Point();
        private var _scene:int = _SCENE_SEARCH;
        
        private const _SCENE_SEARCH:int = 0;
        private const _SCENE_NORMAL:int = 1;
        private const _SCENE_ZOOM:int = 2;
        
        public function AdCity() {
            Display.stage = stage;
            stage.frameRate = 30;
            stage.quality = StageQuality.LOW;
            Style.fontSize *= 2;
            Style.LABEL_TEXT = 0xFFFFFF;
            //画面構成
            _bg = addChild(Painter.createColorRect(2000, 2000, 0)) as Sprite;
            _bg.x = (Display.WIDTH - _bg.width) / 2;
            _bg.y = (Display.HEIGHT - _bg.height) / 2;
            _sky = Painter.createColorRect(Display.WIDTH, Display.HEIGHT, 0x78B2F8);
            _sky.mouseEnabled = false;
            _sky.visible = false;
            addChild(_sky);
            _loading = new Label(this, 205, 220, "LOADING");
            _menu = new TopMenu();
            _menu.hide();
            addChild(new Bitmap(_canvas));
            addChild(_viewer);
            addChild(_mouseOverSprite);
            addChild(_search);
            addChild(_menu);
            _menu.search.addEventListener(LabelButton.EVENT_CLICK, onClickSeach);
            _menu.camera.addEventListener(Event.CHANGE, onChangeCamera);
            _search.hide();
            //hitTest用にstageに配置しておく
            addChild(_map.container);
            _map.container.visible = false;
            _mouseOverSprite.addChild(Painter.createColorRect(Display.WIDTH, Display.HEIGHT, 0, 0));
            _mouseOverSprite.buttonMode = true;
            _mouseOverSprite.mouseChildren = false;
            _mouseOverSprite.visible = false;
            
            _drag = new MouseDrag(_bg, 400, 400);
            _drag.speed.x = -0.5;
            _drag.speed.y = -0.5;
            
            //マップチップとかを読み込む
            Security.loadPolicyFile("http://www.morocoshi.net/crossdomain.xml");
            _loader.addImage("http://www.morocoshi.net/asset/wonderfl/image/mapchip.png", "mapchip");
            _loader.addImage("http://www.morocoshi.net/asset/wonderfl/image/buildings.png", "bldg");
            _loader.addImage("http://www.morocoshi.net/asset/wonderfl/image/car.png", "car");
            _loader.addImage("http://www.morocoshi.net/asset/wonderfl/image/ui.png", "ui");
            _loader.load(onLoadMaterial, onErrorMaterial);
        }
        //メニューのSEARCHボタンを押した
        private function onClickSeach(e:Event):void {
            _scene = _SCENE_SEARCH;
            _search.setSearch();
            _menu.camera.setMode(CameraSwitch.MODE_CAR);
            _menu.hide();
        }
        //カメラボタンで切り替えた
        private function onChangeCamera(e:Event):void {
            EaseMotion.goto(this, "easeScale", 3);
            EaseMotion.ease(this, "easeScale", 2, 0.2);
            _drag.position.x = _map.myCar.x;
            _drag.position.y = _map.myCar.y - 30;
        }
        //マップチップロード失敗
        private function onErrorMaterial():void {
            _loading.text = "ERROR...";
        }
        //全ての素材を読み込めた
        private function onLoadMaterial():void {
            _sky.visible = true;
            _loading.parent.removeChild(_loading);
            _viewer.init(_loader.image.ui);
            _map.init(_loader);
            onSimulateTick(null);
            _search.init("poster logo", onSearch);
            _flickr.loadLimit = 16;
            _flickr.isSkipFlash = true;
            _flickr.addEventListener(Flickr.EVENT_LOADIMAGE, onLoadImage);
            _flickr.addEventListener(Flickr.EVENT_NOIMAGE, onNoImage);
            _flickr.addEventListener(ErrorEvent.ERROR, onErrorRss);
            _flickr.addEventListener(Event.COMPLETE, onCompleteImage);
        }
        //検索実行時
        private function onSearch(tag:String):void{
            //flickrのRSSを取得
            _search.setMessage("LOADING... ");
            _flickr.load(tag);
        }
        private function onNoImage(e:Event):void {
            _search.errorMessage("NO IMAGE!");
        }
        private function onErrorRss(e:ErrorEvent):void {
            _search.errorMessage("ERROR!");
        }
        private function onLoadImage(e:Event):void {
            var per:Number = _flickr.loaded.length / _flickr.items.length * 100;
            _search.setMessage("LOADING... " + int(per) + "%");
        }
        //全てのサムネイルが読み込まれた
        private function onCompleteImage(e:Event):void {
            _scene = _SCENE_NORMAL;
            _search.hide();
            _bg.addEventListener(MouseEvent.MOUSE_DOWN, onClickStage);
            _mouseOverSprite.addEventListener(MouseEvent.MOUSE_DOWN, onClickStage);
            _menu.show();
            var count:int = -1;
            if (_flickr.items.length > 0) {
                for each(var obj:Piece in _map.piece.objects) {
                    for each(var ad:Ad in obj.ads) {
                        count = (count + 1) % _flickr.items.length;
                        ad.setItem(_flickr.items[count]);
                    }
                }
            }
            startSim();
        }
        //背景クリック時
        private function onClickStage(e:MouseEvent):void {
            switch(_scene) {
                case _SCENE_ZOOM:
                    startSim();
                    _viewer.close();
                    _menu.show();
                    _scene = _SCENE_NORMAL;
                    break;
                case _SCENE_NORMAL:
                    var ad:Ad = _map.piece.hitTest(_mousePos.x, _mousePos.y);
                    if (ad) {
                        stopSim();
                        _scene = _SCENE_ZOOM;
                        _menu.hide();
                        _mouseOverSprite.visible = false;
                        _viewer.setItem(ad.item);
                    }
                    break;
            }
        }
        public function startSim():void {
            addEventListener(Event.ENTER_FRAME, onSimulateTick);
        }
        public function stopSim():void {
            removeEventListener(Event.ENTER_FRAME, onSimulateTick);
        }
        private function onSimulateTick(e:Event):void {
            _map.piece.objects.sort(sortFunc);
            var l:int = _map.piece.objects.length;
            for (var i:int = 0; i < l; i++) {
                _map.objLayer.setChildIndex(_map.piece.objects[i], i);
            }
            _map.myCar.simulateTick();
            var ad:Ad = _map.piece.hitTest(_mousePos.x, _mousePos.y)
            _mouseOverSprite.visible = !!ad;
            for each(var c:Car in _map.cars) c.simulateTick();
            _canvas.fillRect(_canvas.rect, 0);
            var scale:Number;
            var tx:Number;
            var ty:Number;
            switch(_menu.camera.mode) {
                case CameraSwitch.MODE_CAR:
                    scale = 3;
                    tx = _map.myCar.x * scale;
                    ty = (_map.myCar.y  - 30) * scale;
                    break;
                case CameraSwitch.MODE_DRAG:
                    scale = easeScale;
                    tx = _drag.position.x * scale;
                    ty = _drag.position.y * scale;
                    break;
                case CameraSwitch.MODE_SKY:
                    scale = 0.5;
                    var pp:Point = Quarter.toScreen(_map.data.W / 2, _map.data.H / 2, 10);
                    tx = pp.x * scale;
                    ty = pp.y * scale;
                    break;
            }
            tx -= Display.CENTER.x;
            ty -= Display.CENTER.y;
            _mousePos = new Point(tx / scale + stage.mouseX / scale, ty / scale + stage.mouseY / scale);
            _canvas.draw(_map.container, new Matrix(scale, 0, 0, scale, int( -tx), int( -ty)));    
        }
        private function sortFunc(a:Piece, b:Piece):int{
            return (a.y + a.basePos.y) - (b.y + b.basePos.y);
        }
    }
}
import com.bit101.components.*;
import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.net.*;
import flash.system.*;
import flash.text.*;
import flash.ui.*;
import flash.utils.*;
/**
 * 上部メニュー
 */
class TopMenu extends Sprite {
    private var _base:Sprite;
    public var search:LabelButton;
    public var camera:CameraSwitch;
    private var _height:Number = 35;
    public function TopMenu() {
        _base = addChild(Painter.createColorRect(Display.WIDTH, _height, 0, 0.7)) as Sprite;
        search = new LabelButton(this, 8, 0, "SEARCH", 100);
        camera = new CameraSwitch(this, Display.WIDTH - 145, 0);
    }
    public function show():void {
        mouseEnabled = true;
        mouseChildren = true;
        EaseMotion.ease(this, "y", 0, 0.4);
        EaseMotion.ease(search, "alpha", 1);
        EaseMotion.ease(camera, "alpha", 1);
    }
    public function hide():void {
        mouseEnabled = false;
        mouseChildren = false;
        EaseMotion.ease(this, "y", -_height, 0.4);
        EaseMotion.ease(search, "alpha", 0);
        EaseMotion.ease(camera, "alpha", 0);
    }
}
/**
 * 検索窓
 */
class SearchDialog extends Sprite {
    private var _base:Sprite = new Sprite();
    private var _message:Label;
    private var _input:InputText;
    private var _searchLayer:Sprite = new Sprite();
    private var _searchFunc:Function;
    private var _timer:Timer = new Timer(2000, 1);
    public function SearchDialog() {
        _timer.addEventListener(TimerEvent.TIMER_COMPLETE, onTimesUp);
        addChild(_base);
        var imgBase:BitmapData = new BitmapData(170, 34, true, 0);
        var imgTri:BitmapData = new BitmapData(10, 10, true, 0);
        var i:int, px:int, py:int;
        var round:int = 3;
        for (i = 0; i < imgTri.width; i+=2) {
            imgTri.fillRect(new Rectangle(i, 0, 2, imgTri.height-i), 0xFFffffff);
        }
        for (i = 0; i < round; i++) {
            px = i * 2;
            py = (round - i -1) * 2;
            imgBase.fillRect(new Rectangle(px, py, imgBase.width - px * 2, imgBase.height - py * 2), 0xFFffffff);
        }
        var tri:Bitmap = _base.addChild(new Bitmap(imgTri)) as Bitmap;
        var base:Bitmap = _base.addChild(new Bitmap(imgBase)) as Bitmap;
        tri.y = -tri.height;
        base.y = -imgTri.height - imgBase.height;
        base.x = int( -imgBase.width / 2);
        addChild(_searchLayer);
        _input = new InputText(_searchLayer, -78, -35, "");
        new PushButton(_searchLayer, 28, -35, "SEARCH", onClickSearch).setSize(50, 16);
        _message = new Label(this, -34, -37, "");
        _message.visible = false;
        filters = [new DropShadowFilter(2, 45, 0, 0.5, 6, 6, 100, 1)];
        x = 230;
        y = 270;
    }
    public function init(text:String, onSearch:Function):void {
        _searchFunc = onSearch;
        setSearch();
        _input.text = text;
    }
    public function getKeyword():String {
        return _input.text.replace(/\s+|\/|\./g, ",");
    }
    public function setSearch():void {
        visible = true;
        EaseMotion.ease(this, "scaleX", 2, 0.6);
        EaseMotion.ease(this, "scaleY", 2, 0.6);
        _searchLayer.visible = true;
        _message.visible = false;
        stage.focus = _input.textField;
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
    }
    private function onKeyDown(e:KeyboardEvent):void {
        if (e.keyCode == Keyboard.ENTER) onClickSearch(null);
    }
    public function hide():void {
        visible = false;
        EaseMotion.goto(this, "scaleX", 0);
        EaseMotion.goto(this, "scaleY", 0);
    }
    public function errorMessage(text:String):void {
        setMessage(text);
        _timer.reset();
        _timer.start();
    }
    private function onTimesUp(e:TimerEvent):void {
        setSearch();
    }
    public function setMessage(text:String):void {
        _searchLayer.visible = false;
        _message.text = text;
        _message.visible = true;
    }
    private function onClickSearch(e:MouseEvent):void {
        stage.removeEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        if (_input.text.replace(/\s*/g, "") == "") return;
        if (_searchFunc != null)_searchFunc.apply(null, [getKeyword()]);
    }
}
/**
 * メニューのラベルボタン
 */
class LabelButton extends Label {
    static public const EVENT_CLICK:String = "onClickMe";
    private var _base:Sprite = new Sprite();
    private var _mainColor:ColorTransform = new ColorTransform();
    private var _overColor:ColorTransform = new ColorTransform();
    public function LabelButton(parent:DisplayObjectContainer, xpos:Number, ypos:Number, text:String = "", width:Number = 150) {
        super(parent, xpos, ypos, text);
        _mainColor.color = 0xFFFFFF;
        _overColor.color = 0xFFFF63;
        _base.addChild(Painter.createColorRect(width, 30, 0, 0));
        _base.addEventListener(MouseEvent.ROLL_OVER, onOver);
        _base.addEventListener(MouseEvent.ROLL_OUT, onOut);
        _base.addEventListener(MouseEvent.CLICK, onClick);
        _base.buttonMode = true;
        _base.x = -4;
        _base.y = 3;
        mouseEnabled = true;
        mouseChildren = true;
        addChildAt(_base, 0);
    }
    private function onOut(e:MouseEvent):void {
        textField.transform.colorTransform = _mainColor;
    }
    private function onOver(e:MouseEvent):void {
        textField.transform.colorTransform = _overColor;
    }
    protected function onClick(e:MouseEvent):void {
        dispatchEvent(new Event(EVENT_CLICK));
    }
}
/**
 * カメラ切り替えボタン
 */
class CameraSwitch extends LabelButton {
    static public const MODE_CAR:int = 0;
    static public const MODE_DRAG:int = 1;
    static public const MODE_SKY:int = 2;
    public var mode:int = MODE_CAR;
    public function CameraSwitch(parent:DisplayObjectContainer, xpos:Number, ypos:Number) {
        super(parent, xpos, ypos);
        updateLabel();
    }
    override protected function onClick(e:MouseEvent):void {
        setMode((mode + 1) % 3);
        dispatchEvent(new Event(Event.CHANGE));
        super.onClick(e);
    }
    public function setMode(mode:int):void {
        this.mode = mode;
        updateLabel();
    }
    private function updateLabel():void {
        text = "CAMERA: " + ["  CAR", "DRAG", "  SKY"][mode];
    }
}
/**
 * マウスドラッグ管理
 */
class MouseDrag extends EventDispatcher {
    public var position:Point = new Point();
    public var speed:Point = new Point(1, 1);
    public var clickRange:Number = 2;
    private var _sprite:DisplayObjectContainer;
    private var _isDragged:Boolean = false;
    private var _isMouseDown:Boolean = false;
    private var _savePosition:Point = new Point();
    private var _saveMousePos:Point;
    static public const EVENT_STARTDRAG:String = "onStartDrag";
    public function get isMouseDown():Boolean { return _isMouseDown; }
    public function get isDragged():Boolean { return _isDragged; }
    public function MouseDrag(target:DisplayObjectContainer, x:Number = 0, y:Number = 0) {
        position.x = x;
        position.y = y;
        _sprite = target;
        setEnabled(true);
    }
    public function setEnabled(enabled:Boolean):void {
        if (enabled) {
            _sprite.addEventListener(MouseEvent.MOUSE_DOWN, onMsDown);
        } else {
            _sprite.removeEventListener(MouseEvent.MOUSE_DOWN, onMsDown);
        }
    }
    private function onMsDown(e:MouseEvent):void {
        _isMouseDown = true;
        _isDragged = false;
        _sprite.stage.addEventListener(MouseEvent.MOUSE_UP, onMsUp);
        _sprite.stage.addEventListener(Event.MOUSE_LEAVE, onMsUp);
        _sprite.stage.addEventListener(MouseEvent.MOUSE_MOVE, onMsMove);
        _savePosition = position.clone();
        _saveMousePos = new Point(_sprite.mouseX, _sprite.mouseY);
        dispatchEvent(new MouseEvent(MouseEvent.MOUSE_DOWN));
    }
    private function onMsUp(...rest):void {
        _isMouseDown = false;
        _sprite.stage.removeEventListener(MouseEvent.MOUSE_UP, onMsUp);
        _sprite.stage.removeEventListener(Event.MOUSE_LEAVE, onMsUp);
        _sprite.stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMsMove);
        checkDrag();
        dispatchEvent(new MouseEvent(MouseEvent.MOUSE_UP));
    }
    private function onMsMove(e:MouseEvent):void {
        checkDrag();
    }
    private function checkDrag():void{
        var drag:Point = new Point(_sprite.mouseX, _sprite.mouseY).subtract(_saveMousePos);
        if (!_isDragged && drag.length > clickRange) {
            dispatchEvent(new Event(EVENT_STARTDRAG));
            _isDragged = true;
        }
        if (_isDragged) {
            position.x = _savePosition.x + drag.x * speed.x;
            position.y = _savePosition.y + drag.y * speed.y;
            dispatchEvent(new MouseEvent(MouseEvent.MOUSE_MOVE));
        }
    }
}
/**
 * 拡大画像ビューワ
 */
class Viewer extends Sprite {
    private var _viewRect:Rectangle = new Rectangle(27, 45, 411, 330);
    private var _bg:Sprite;
    private var _bmp:Bitmap
    private var _slideLayer:Sprite = new Sprite();
    private var _imageContainer:Sprite = new Sprite();
    private var _loader:ImageLoader = new ImageLoader();
    private var _title:Label;
    private var _loading:Label;
    private var _errorLabel:Label;
    public function Viewer() {
        mouseEnabled = false;
        mouseChildren = false;
    }
    /**
     * フレーム画像を渡して初期化
     * @param    bmp
     */
    public function init(bmp:BitmapData):void {
        _bg = Painter.createColorRect(Display.WIDTH, Display.HEIGHT, 0xFFFFFF);
        _bg.alpha = 0;
        _bg.visible = false;
        _bg.blendMode = BlendMode.ADD;
        addChild(_bg);
        addChild(_slideLayer);
        _loading = new Label(null, 200, 190, "LOADING");
        _slideLayer.addChild(new Bitmap(bmp));
        _slideLayer.addChild(_loading);
        _slideLayer.addChild(_imageContainer);
        _title = new Label(_slideLayer, 30, 420);
        _title.x = 30;
        _title.width = 200;
        _title.height = 50;
        _title.scrollRect = new Rectangle(0, 0, 400, 100);
        _errorLabel = new Label(_slideLayer, 130, 180, "");
        _errorLabel.visible = false;
        mask = addChild(Painter.createColorRect(Display.WIDTH, Display.HEIGHT, 0));
        EaseMotion.goto(_slideLayer, "y", 465);
    }
    public function dispose():void {
        while (_imageContainer.numChildren) _imageContainer.removeChildAt(0);
        _loader.stop();
        _loader.disposeAll();
    }
    public function setItem(item:MediaItem):void {
        dispose();
        EaseMotion.goto(_loading, "alpha", 0);
        _imageContainer.alpha = 0;
        EaseMotion.ease(_slideLayer, "y", 0, 0.4, loadImage, [item]);
        EaseMotion.ease(_bg, "alpha", 0.5, 0.25);
        _bg.visible = true;
        _title.text = item.authorName +" - "+ item.title;
    }
    private function loadImage(item:MediaItem):void{
        stage.quality = StageQuality.BEST;
        EaseMotion.ease(_loading, "alpha", 1);
        _loader.resetItem();
        _loader.addImage(item.content, "image");
        _loader.load(onLoadImage);
    }
    private function onLoadImage():void {
        if (!(_loader.image.image is BitmapData)) return;
        var img:BitmapData = _loader.image.image;
        EaseMotion.ease(_loading, "alpha", 0);
        //画像が大きすぎたらエラー
        if (img.width > 8192 || img.height > 8192 || img.width * img.height > 16777216) {
            _errorLabel.text = "ERROR: Image too large\n(" + img.width + " X " + img.height + " px)";
            _errorLabel.visible = true;
            return;
        }
        var bmp:Bitmap = new Bitmap(img, "auto", true);
        _imageContainer.addChild(bmp);
        var asp1:Number = _viewRect.width / _viewRect.height;
        var asp2:Number = bmp.width / bmp.height;
        if (asp1 < asp2) {
            bmp.width = _viewRect.width;
            bmp.height = bmp.width / asp2;
        } else {
            bmp.height = _viewRect.height;
            bmp.width = bmp.height * asp2;
        }
        bmp.x = _viewRect.x + (_viewRect.width - bmp.width) / 2;
        bmp.y = _viewRect.y + (_viewRect.height - bmp.height) / 2;
        EaseMotion.ease(_imageContainer, "alpha", 1);
        
    }
    public function close():void {
        dispose();
        stage.quality = StageQuality.LOW;
        _errorLabel.visible = false;
        EaseMotion.ease(_slideLayer, "y", 465, 0.4, function():void { } );
        EaseMotion.ease(_bg, "alpha", 0, 0.25, function():void { _bg.visible = false; } );
    }
}
/**
 * マップ上に配置するオブジェクト
 */
class Piece extends Sprite {
    public var bmp:Bitmap;
    public var image:BitmapData;
    public var w:int;
    public var h:int;
    public var materialID:int = -1;
    public var offsetX:int = 0;
    public var offsetY:int = 0;
    public var ads:Vector.<Ad> = new Vector.<Ad>();
    public var basePos:Point = new Point();
    protected var _px:Number;
    protected var _py:Number;
    protected var _pz:Number;
    public function Piece(img:BitmapData, sizeW:int = 2, sizeH:int = 2) {
        super();
        image = img;
        bmp = addChild(new Bitmap(image)) as Bitmap;
        w = sizeW;
        h = sizeH;
        var min:Number = Math.min(w, h) / 2
        basePos = (w >= h)? Quarter.toLocalScreen(w - min, h / 2, 0) : Quarter.toLocalScreen(w / 2, h - min, 0);
        bmp.x = h * -22;
        bmp.y = -bmp.height + (w + h) * 11;
    }
    public function setPosition(px:Number, py:Number, pz:Number):void {
        _px = px;
        _py = py;
        _pz = pz;
        update();
    }
    public function update():void {
        var p:Point = Quarter.toScreen(_px, _py, _pz);
        x = p.x + offsetX;
        y = p.y + offsetY;
    }
    public function addAd(px:Number, py:Number, width:Number, height:Number, skew:Number = -0.5):void {
        var ad:Ad = new Ad(width, height, skew, false);
        ad.x = bmp.x + px;
        ad.y = bmp.y + py;
        addChild(ad);
        ads.push(ad);
    }
}
/**
 * 車
 */
class Car extends Piece {
    private var _size:Rectangle = new Rectangle(0, 0, 21, 18);
    private var _carImage:BitmapData;
    private var _snapPos:Point = new Point();
    private var _map:MapView;
    /**速度*/
    public var speed:Number = 0.05;
    //現在の方向
    private var _direction:int = 0;
    //次に曲がる方向
    private var _nextDirection:int = -1;
    public var route:Array = [];
    private var _routCount:int = -1;
    public function Car(img:BitmapData, xx:int, yy:int, map:MapView) {
        _map = map;
        _carImage = img;
        super(new BitmapData(_size.width, _size.height, true, 0), 1, 1);
        _snapPos.x = xx;
        _snapPos.y = yy;
        setPosition(xx, yy, 2);
        bmp.x += 10;
        bmp.y += -15;
        basePos.x = 0;
        basePos.y = 0;
        setDirection(_direction);
    }
    //道路に沿うように調整
    private function adjustPos():void {
        if (_direction == 0) _px = _snapPos.x + 0.25;
        else if (_direction == 2) _px = _snapPos.x + 0.75;
        else if (_direction == 1) _py = _snapPos.y + 0.25;
        else if (_direction == 3) _py = _snapPos.y + 0.75;
    }
    //前方のベクトルを取得
    private function getVector(dir:int):Point {
        var px:int = [0, 1, 0, -1][dir];
        var py:int = [ -1, 0, 1, 0][dir];
        return new Point(px, py);
    }
    //前方のタイルの座標を調べる
    private function getNextPos():Point {
        return _snapPos.add(getVector(_direction));
    }
    //次にどっちに曲がるか調べる
    private function checkNextPath():void {
        var p:Point = getNextPos();
        var path:Array = [];
        //前方のタイルからマップ外に続く進路を削る
        for each(var dir:int in _map.data.roadPath[_map.toIndex(p.x, p.y)]) {
            var p2:Point = getVector(dir).add(p);
            var num:int = _map.toIndex(p2.x, p2.y);
            if (num >= 0 && num < _map.data.W * _map.data.H) path.push(dir); 
        }
        //自分と逆方向の進路を削る
        if (path.length >= 2) {
            var ngPath:int = (_direction + 2) % 4;
            var index:int = path.indexOf(ngPath);
            if (index != -1) path.splice(index, 1);
        }
        var routeDir:int = -1;
        if (route.length && path.length >= 2) {
            _routCount = (_routCount + 1) % route.length;
            routeDir = route[_routCount];
        }
        _nextDirection = (!path.length)? -1 : (routeDir != -1)? routeDir : path[Math.floor(Math.random() * path.length)];
        if (_direction == _nextDirection) _nextDirection = -1;
    }
    /**
     * 方向設定
     * @param    dir
     */
    public function setDirection(dir:int):void {
        _direction = dir;
        image.fillRect(image.rect, 0);
        image.copyPixels(_carImage, new Rectangle(_size.width * dir, 0, _size.width, _size.height), new Point(), null, null, true);
    }
    /**
     * 動かす
     */
    public function simulateTick():void {
        var vec:Point = getVector(_direction);
        var nextTile:Point = getNextPos();
        if (_nextDirection != -1) {
            if (_nextDirection == 0) {
                if (_direction == 1 && _px > nextTile.x + 0.25) nextPath();
                else if (_direction == 3 && _px < nextTile.x + 0.25) nextPath();
                else if (_direction == 2 && _py > nextTile.y + 0.25) nextPath();
            } else if (_nextDirection == 2) {
                if (_direction == 1 && _px > nextTile.x + 0.75) nextPath();
                else if (_direction == 3 && _px < nextTile.x + 0.75) nextPath();
                else if (_direction == 0 && _py < nextTile.y + 0.75) nextPath();
            } else if (_nextDirection == 1) {
                if (_direction == 0 && _py < nextTile.y + 0.25) nextPath();
                else if (_direction == 2 && _py > nextTile.y + 0.25) nextPath();
                else if (_direction == 3 && _px < nextTile.x + 0.25) nextPath();
            } else if (_nextDirection == 3) {
                if (_direction == 0 && _py < nextTile.y + 0.75) nextPath();
                else if (_direction == 2 && _py > nextTile.y + 0.75) nextPath();
                else if (_direction == 1 && _px > nextTile.x + 0.75) nextPath();
            }
        } else {
            nextPath();
        }
        _px += vec.x * speed;
        _py += vec.y * speed;
        _pz = _map.getHeight(_px, _py);
        adjustPos();
        update();
    }
    private function nextPath():void {
        _snapPos = getNextPos();
        if(_nextDirection != -1) setDirection(_nextDirection);
        adjustPos();
        checkNextPath();
    }
}
/**
 * 色変換
 */
class ColorMatrix {
    static private const _LUM_R:Number = 0.212671;
    static private const _LUM_G:Number = 0.715160;
    static private const _LUM_B:Number = 0.072169;
    /**
     * 色相変化フィルター用配列を取得
     * @param    num
     * @return
     */
    static public function getHueArray(num:Number):Array {
        var rad:Number = Math.PI * num;
        var cos:Number = Math.cos(rad);
        var sin:Number = Math.sin(rad);
        var rNum:Number = 1 - cos - sin;
        var gNum:Number = 1 - cos;
        var bNum:Number = 1 - cos + sin;
        var r1:Number = _LUM_R * rNum + cos;
        var r2:Number = _LUM_G * rNum;
        var r3:Number = _LUM_B * rNum + sin;
        var g1:Number = _LUM_R * gNum + sin * 0.143;
        var g2:Number = _LUM_G * gNum + sin * 0.140 + cos;
        var g3:Number = _LUM_B * gNum - sin * 0.283;
        var b1:Number = _LUM_R * bNum - sin;
        var b2:Number = _LUM_G * bNum;
        var b3:Number = _LUM_B * bNum + cos;
        return [r1, r2, r3, 0, 0, g1, g2, g3, 0, 0, b1, b2, b3, 0, 0, 0, 0, 0, 1, 0];
    }
}
/**
 * 広告
 */
class Ad extends Sprite{
    public var isSlideMode:Boolean = false;
    public var item:MediaItem;
    private var _mask:Sprite = new Sprite();
    private var _container:Sprite = new Sprite();
    private var _size:Rectangle = new Rectangle();
    public function Ad(width:Number, height:Number, skew:Number = -0.5, slide:Boolean = false) {
        isSlideMode = slide;
        addChild(_container);
        addChild(_mask);
        _size.width = width;
        _size.height = height;
        _mask.graphics.beginFill(0, 1);
        _mask.graphics.drawRect(0, 0, width, height);
        _mask.graphics.endFill();
        _container.mask = _mask;
        _container.blendMode = BlendMode.ADD;
        transform.matrix = new Matrix(1, skew, 0, 1);
    }
    public function setItem(item:MediaItem):void {
        this.item = item;
        while (_container.numChildren) _container.removeChildAt(0);
        var bmp:Bitmap = _container.addChild(new Bitmap(item.image, "auto")) as Bitmap;
        var asp1:Number = _size.width / _size.height;
        var asp2:Number = bmp.width / bmp.height;
        if (asp1 > asp2) {
            bmp.width = _size.width;
            bmp.height = bmp.width / asp2;
        } else {
            bmp.height = _size.height;
            bmp.width = bmp.height * asp2;
        }
        bmp.x = (_size.width - bmp.width) / 2;
        bmp.y = (_size.height - bmp.height) / 2;
    }
}
/**
 * マップデータ
 */
class MapData {
    public const W:int = 25;
    public const H:int = 25;
    /**水面の高さ*/
    public const WATER_LEVEL:int = 2;
    /**道路の最低高度*/
    public const ROAD_LEVEL:int = 3;
    public var roadPath:Vector.<Array> = new Vector.<Array>();
    /**地形の高さ*/
    public var level:Array = [
        [8,7,6,6,5,5,5,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [5,6,5,5,4,5,4,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [4,5,5,4,4,4,4,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1],
        [4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1],
        [3,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
        [1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3]
    ];
    /**地形の傾き*/
    public var slope:Array = [
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,0],
        [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,4,0],
        [0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3],
        [0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
    ];
    /**
     * 地面の種類
     * 0:地面
     * 1:道路
     * 2:草
     * 3：アスファルト
     * 4：砂
     * 5：木
     * 6：電話ボックス
     * 7：丸い植物
     * 8：排水管（斜面専用）
     */
    public var material:Array = [
        [2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,6,7,5,5,5,0,0,0],
        [2,2,2,2,2,2,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,0,0,0],
        [2,2,2,2,2,2,4,0,0,1,0,0,0,0,1,0,0,0,0,5,1,0,0,0,0],
        [2,2,2,2,2,4,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,5,8,0,0],
        [2,2,2,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0],
        [0,0,0,0,0,0,0,0,5,1,0,0,0,0,1,0,0,0,0,0,1,5,0,0,0],
        [0,0,7,1,1,1,1,1,1,1,0,0,0,0,1,5,5,5,5,7,1,5,0,0,0],
        [0,0,5,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1],
        [0,0,7,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0],
        [0,0,0,1,0,0,0,0,0,1,5,0,0,5,1,0,0,0,0,1,0,0,8,0,0],
        [0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,0,0,0,0],
        [0,0,7,0,0,6,5,5,5,1,5,0,6,5,1,5,0,0,5,1,5,0,0,0,0],
        [1,1,5,0,8,0,0,0,0,1,0,8,0,0,1,0,8,0,0,1,0,0,0,0,0],
        [0,1,5,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0],
        [0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0],
        [0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0],
        [1,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0],
        [0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0],
        [0,0,0,0,5,0,0,0,0,1,0,0,0,0,1,5,6,7,7,1,0,0,0,0,5],
        [0,0,0,0,5,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,5],
        [0,0,0,0,5,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,5],
        [0,0,0,0,5,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,3,3,3,3,5],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,5,0,0,6,5],
        [0,0,0,0,5,5,5,5,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,5,5,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2]
    ];
    public function MapData() {
        //二重配列の前後にダミーのデータを入れる
        var a:Array, i:int;
        level.unshift(level[0].concat());
        level.push(level[level.length - 1].concat());
        for each(a in level) {
            a.unshift(a[0]);
            a.push(a[a.length - 1]);
        }
        a.length = 0;
        for (i = 0; i < slope[0].length; i++) a.push(0);
        slope.unshift(a);
        slope.push(a.concat());
        for each(a in slope) {
            a.unshift(0);
            a.push(0);
        }
        material.unshift(material[0].concat());
        material.push(material[material.length - 1].concat());
        for each(a in material) {
            a.unshift(a[0]);
            a.push(a[a.length - 1]);
        }
        //
        var l:int = W * H;
        for (i = 0; i < l; i++) roadPath[i] = [];
    }
}
/**
 * オブジェクト管理
 */
class PieceMaker {
    private var _rawImage:BitmapData;
    public var image:Object = { };
    public var objects:Vector.<Piece> = new Vector.<Piece>();
    public function PieceMaker(img:BitmapData) {
        _rawImage = img;
    }
    public function hitTest(x:Number, y:Number):Ad {
        for each(var obj:Piece in objects) {
            for each(var ad:Ad in obj.ads) {
                if (ad.hitTestPoint(x, y, true)) return ad;
            }
        }
        return null;
    }
    public function newImage(x:int, y:int, width:int, height:int):BitmapData {
        var img:BitmapData = new BitmapData(width, height, true, 0);
        img.copyPixels(_rawImage, new Rectangle(x, y, width, height), new Point(), null, null, true);
        return img;
    }
    public function createPiece(name:String, x:int, y:int, width:int, height:int, sizeW:int = 2, sizeH:int = 2, matID:int = -1):Piece {
        return newPiece(name, newImage(x, y, width, height), sizeW, sizeH, matID);
    }
    public function newPiece(name:String, image:BitmapData, sizeW:int = 2, sizeH:int = 2, matID:int = -1):Piece {
        var obj:Piece = new Piece(image, sizeW, sizeH);
        obj.name = name;
        obj.materialID = matID;
        objects.push(obj);
        return obj;
    }
    public function addPiece(p:Piece):Piece {
        objects.push(p);
        return p;
    }
    public function getPiece(name:String):Piece {
        for each(var p:Piece in objects) {
            if (name == p.name) return p;
        }
        return null;
    }
    public function addChildAll(target:DisplayObjectContainer):void {
        for each(var p:Piece in objects) target.addChild(p);
    }
}
/**
 * マップ管理
 */
class MapView {
    public var container:Sprite = new Sprite();
    public var objLayer:Sprite = new Sprite();
    public var canvas:BitmapData;
    public var waterSection:BitmapData;
    public var chip:MapChip = new MapChip();
    public var data:MapData = new MapData();
    public var piece:PieceMaker;
    public var myCar:Car;
    public var cars:Vector.<Car> = new Vector.<Car>();
    public function MapView() {
        canvas = new BitmapData(1100, 865, true, 0);
        waterSection = new BitmapData(canvas.width, canvas.height, false, 0xFF000000);
        container.addChild(new Bitmap(canvas));
        container.addChild(objLayer);
    }
    private function transparent(img:BitmapData):BitmapData {
        var temp:BitmapData = new BitmapData(img.width, img.height, true, 0);
        temp.copyPixels(img, img.rect, new Point());
        temp.threshold(temp, temp.rect, new Point(), "==", 0xFF << 24 | chip.TRANSPARENT1, 0x00FFFFFF);
        temp.threshold(temp, temp.rect, new Point(), "==", 0xFF << 24 | chip.TRANSPARENT2, 0x00FFFFFF);
        return temp;
    }
    public function init(loader:ImageLoader):void {
        //マップチップ切り出し開始
        var ix:int, iy:int, i:int, k:String, img:BitmapData;
        var bmp:BitmapData = transparent(loader.image.mapchip);
        var bmp2:BitmapData = transparent(loader.image.bldg);
        var bmp3:BitmapData = transparent(loader.image.car);
        loader.image.bldg = bmp2;
        var images:Vector.<BitmapData> = new Vector.<BitmapData>();
        for (i = 0; i < 60 ; i++) {
            ix = i % 10;
            iy = int(i / 10);
            img = chip.newBitmap();
            img.copyPixels(bmp, new Rectangle(ix * chip.W, iy * chip.H, chip.W, chip.H), new Point());
            images.push(img);
        }
        //地形
        chip.terrain = images.splice(0, 15);
        //断面
        for each(k in ["L", "R"]) chip["section" + k] = images.shift();
        chip.sections = images.splice(0, 4);
        //道路
        chip.road = images.splice(0, 5);
        //歩道
        for each(k in ["TLI", "TRI", "BRI", "BLI", "TLO", "TRO", "BRO", "BLO", "T", "R", "B", "L"]) chip.sidewalk[k] = images.shift();
        //橋のフェンスと柱
        for each(k in ["PN", "PW1", "PW2", "base", "T", "R", "B", "L"]) chip.bridge[k] = images.shift();
        //白線
        for each(k in ["T", "R", "B", "L"]) chip.centerline[k] = images.shift();
        //横断歩道
        for each(k in ["X", "Y"]) chip["crosswalk" + k] = images.shift();
        for each(k in ["Grass", "Asphalt", "Sand"]) chip["ground" + k] = images.shift();
        
        chip.phoneBooth = images.shift();
        chip.grassBall = images.shift();
        images.shift();
        chip.drainpipe.B = images.shift();
        chip.drainpipe.R = images.shift();
        
        
        //オブジェクト
        piece = new PieceMaker(loader.image.bldg);
        piece.createPiece("bldg1", 0, 183, 108, 150, 2, 3, -1);
        piece.createPiece("bldg2", 230, 0, 86, 163, 2, 2, -1);
        piece.createPiece("bldg3", 0, 0, 121, 178, 3, 3, -1);
        piece.createPiece("bldg4", 121, 0, 109, 168, 2, 3, -1);
        piece.createPiece("bldg5", 316, 0, 132, 220, 4, 2, -1);
        piece.createPiece("house1", 174, 356, 174, 94, 4, 4, 2);
        piece.createPiece("house2", 0, 358, 174, 92, 4, 4, 2);
        piece.createPiece("conveni", 112, 189, 135, 84, 4, 3, 3);
        piece.createPiece("park", 110, 274, 112, 76, 4, 2, 2);
        piece.createPiece("busstopV", 255, 227, 56, 49, 1, 2, -1);
        piece.createPiece("busstopH", 319, 227, 60, 49, 2, 1, -1);
        piece.createPiece("adsignV", 383, 229, 61, 69, 1, 2, -1);
        piece.createPiece("adsignH", 444, 229, 53, 69, 2, 1, -1);
        piece.createPiece("parking", 348, 313, 152, 112, 4, 3, 3);
        piece.image.tree = piece.newImage(232, 313, 42, 37);
        
        piece.getPiece("bldg1").addAd(19, 40, 40, 34, 0.5);
        piece.getPiece("bldg1").addAd(88, 280 - 183, 20, 30, -0.5);
        piece.getPiece("bldg2").addAd(15, 16, 27, 28, 0.5);
        piece.getPiece("bldg2").addAd(44, 29, 27, 28, -0.5);
        piece.getPiece("bldg3").addAd(56, 51, 29, 61, -0.5);
        piece.getPiece("bldg3").addAd(4, 9, 31, 21, 0.5);
        piece.getPiece("bldg4").addAd(59, 66, 44, 46, -0.5);
        piece.getPiece("bldg5").addAd(327 - 316, 81, 22, 45, 0.5);
        piece.getPiece("bldg5").addAd(327 - 316, 129, 22, 45, 0.5);
        piece.getPiece("bldg5").addAd(385 - 316, 110, 40, 94, 0);
        piece.getPiece("conveni").addAd(156 - 112, 200 - 189, 22, 13, 0.5);
        piece.getPiece("adsignV").addAd(398 - 383, 248 - 229, 36, 36, -0.5);
        piece.getPiece("adsignH").addAd(454 - 444, 230 - 229, 36, 36, 0.5);
        piece.getPiece("parking").addAd(404-348, 315-313, 36, 35, 0.5);
        piece.getPiece("parking").addAd(448-348, 337-313, 36, 35, 0.5);
        
        putObject(piece.getPiece("bldg1"), 16, 7, 3);
        putObject(piece.getPiece("bldg2"), 11, 7, 3);
        putObject(piece.getPiece("bldg3"), 17, 3, 3);
        putObject(piece.getPiece("bldg4"), 0, 8, 3);
        putObject(piece.getPiece("bldg5"), 4, 7, 3);
        putObject(piece.getPiece("house2"), 10, 18, 3);
        putObject(piece.getPiece("house1"), 5, 18, 3);
        putObject(piece.getPiece("park"), 9, 23, 3);
        putObject(piece.getPiece("conveni"), 15, 20, 3);
        putObject(piece.getPiece("busstopV"), 2, 9, 3);
        putObject(piece.getPiece("busstopH"), 21, 22, 3);
        putObject(piece.getPiece("adsignV"), 13, 23, 3);
        putObject(piece.getPiece("adsignH"), 11, 9, 3);
        putObject(piece.getPiece("parking"), 20, 18, 3);
        
        drawTerrain();
        
        myCar = piece.addPiece(new Car(bmp3, 7, 22, this)) as Car;
        //myCar.route = [1,2,0,3,0,1,0,0,2,3,0,3,2];
        myCar.route = [1,2,0,0,0,0,2,3,0,3,2];
        myCar.setDirection(1);
        for (i = 0; i < 10; i++) {
            var c:Car = piece.addPiece(new Car(bmp3, i+3, 12, this)) as Car;
            c.filters = [new ColorMatrixFilter(ColorMatrix.getHueArray(Math.random() * 2 - 1))];
            cars.push(c);
        }
        piece.addChildAll(objLayer);
        
        bmp.dispose();
        bmp2.dispose();
    }
    public function putObject(obj:Piece, x:int, y:int, z:int):void {
        var ix:int, iy:int;
        obj.setPosition(x, y, z);
        if (obj.materialID == -1) return;
        for (ix = x; ix < x + obj.w; ix++) {
            for (iy = y; iy < y + obj.h; iy++) {
                setMaterial(ix, iy, obj.materialID);
            }
        }
    }
    /**
     * 地形マップを描画する
     */
    public function drawTerrain():void {
        canvas.fillRect(canvas.rect, 0);
        var ct_white1:ColorTransform = new ColorTransform();
        var ct_white2:ColorTransform = new ColorTransform();
        var ct_black:ColorTransform = new ColorTransform();
        var ct_water1:ColorTransform = new ColorTransform();
        var ct_water2:ColorTransform = new ColorTransform();
        ct_white1.color = 0xFFFFFF;
        ct_white2.color = 0x888888;
        ct_black.color = 0x000000;
        ct_water1.color = 0x1C3C82;
        ct_water2.color = 0x1F459B;//0x617DBE;
        var ix:int, iy:int, iz:int, pz:int, img:BitmapData;
        var level:int = Math.max(data.ROAD_LEVEL, data.WATER_LEVEL);
        for (ix = 0; ix < data.W; ix++) {
            for (iy = 0; iy < data.H; iy++) {
                var h:int = getLevel(ix, iy);
                //背面の水の断面を描画
                if (!ix || !iy || ix == (data.W - 1) || iy == (data.H - 1)) {
                    for (iz = 0; iz <= data.WATER_LEVEL; iz++) {
                        var txy:Point = Quarter.toScreen(ix, iy, iz).add(new Point(0, -chip.H));
                        if (!ix) paintBlock(canvas, chip.sectionR, ix, iy, iz, -20, -11, ct_water1);
                        if (!iy) paintBlock(canvas, chip.sectionL, ix, iy, iz, 20, -11, ct_water2);
                        if (ix == (data.W - 1)) paintBlock(waterSection, chip.sectionR, ix, iy, iz, 0, 0, ct_white1);
                        if (iy == (data.H - 1)) paintBlock(waterSection, chip.sectionL, ix, iy, iz, 0, 0, ct_white2);
                    }
                }
                var slope:int = 0
                //地形を描画
                for (iz = 0; iz <= h; iz++) {
                    var deep:int = 5 * Math.min(2, Math.max(0, (data.WATER_LEVEL - iz + 1)));
                    slope = (iz == h)? getSlope(ix, iy) : 0;
                    img = chip.terrain[slope + deep];
                    drawBlock(img, ix, iy, iz);
                    //地形の断面を描画
                    if (ix == (data.W - 1) && slope != 4) {
                        //右端
                        img = (slope == 0 || slope == 2)? chip.sectionR : chip.sections[slope-1];
                        drawBlock(img, ix, iy, iz);
                        paintBlock(waterSection, img, ix, iy, iz, 0, 0, ct_black);
                    }
                    if (iy == (data.H - 1) && slope != 1) {
                        //左端
                        img = (slope == 0 || slope == 3)? chip.sectionL : chip.sections[slope-1];
                        drawBlock(img, ix, iy, iz);
                        paintBlock(waterSection, img, ix, iy, iz, 0, 0, ct_black);
                    }
                }
                var h2:Number = getHeight(ix, iy);
                //道路とか
                var id:int = getMaterial(ix, iy);
                
                var isHorizon:Boolean = (slope == 0);
                //木を配置
                if (id == 5 && h2 >= data.WATER_LEVEL && slope == 0) {
                    var obj:Piece = piece.newPiece("tree", piece.image.tree, 1, 1);
                    putObject(obj, ix, iy, h2);
                }
                //
                if (id == 1) {
                    if(h2 >= level){
                        //普通に描画
                        img = chip.road[slope];
                        iz = h;
                    } else {
                        //最低レベルより下にいかないようにする
                        img = chip.road[0];
                        iz = level;
                        setLevel(ix, iy, iz);
                        setSlope(ix, iy, 0);
                        isHorizon = true;
                        //橋の支柱
                        if (!slope) {
                            for (pz = h; pz < level; pz++) {
                                var pict:BitmapData = [chip.bridge.PN, chip.bridge.PW1, chip.bridge.PW2][Math.min(2, Math.max(0, data.WATER_LEVEL - pz))];
                                drawPlane(pict, ix, iy, pz);
                            }
                        }
                        drawPlane(chip.bridge.base, ix, iy, iz, 0, 3);
                    }
                    drawBlock(img, ix, iy, iz);
                    //橋のフェンス
                    if (h2 < level) {
                        if (getMaterial(ix, iy - 1) != 1) drawPlane(chip.bridge.T, ix, iy, iz);
                        if (getMaterial(ix, iy + 1) != 1) drawPlane(chip.bridge.B, ix, iy, iz);
                        if (getMaterial(ix - 1, iy) != 1) drawPlane(chip.bridge.L, ix, iy, iz);
                        if (getMaterial(ix + 1, iy) != 1) drawPlane(chip.bridge.R, ix, iy, iz);
                    }
                }
                if (id == 2) drawBlock(chip.groundGrass, ix, iy, h2);
                if (id == 3) drawBlock(chip.groundAsphalt, ix, iy, h2);
                if (id == 4) drawBlock(chip.groundSand, ix, iy, h2);
            }
        }
        var noLine:Array = [];
        //道路の歩道と白線
        for (ix = 0; ix < data.W; ix++) {
            for (iy = 0; iy < data.H; iy++) {
                var hh:Number = getHeight(ix, iy);
                id = getMaterial(ix, iy);
                slope = getSlope(ix, iy);
                iz = getLevel(ix, iy);
                var t:Boolean = getMaterial(ix, iy - 1) == 1 && hh == getHeight(ix, iy - 1);
                var b:Boolean = getMaterial(ix, iy + 1) == 1 && hh == getHeight(ix, iy + 1);
                var l:Boolean = getMaterial(ix - 1, iy) == 1 && hh == getHeight(ix - 1, iy);
                var r:Boolean = getMaterial(ix + 1, iy) == 1 && hh == getHeight(ix + 1, iy);
                var tl:Boolean = getMaterial(ix - 1, iy - 1) == 1 && hh == getHeight(ix - 1, iy - 1);
                var tr:Boolean = getMaterial(ix + 1, iy - 1) == 1 && hh == getHeight(ix + 1, iy - 1);
                var bl:Boolean = getMaterial(ix - 1, iy + 1) == 1 && hh == getHeight(ix - 1, iy + 1);
                var br:Boolean = getMaterial(ix + 1, iy + 1) == 1 && hh == getHeight(ix + 1, iy + 1);
                
                
                
                if (id == 1) {
                    if (!slope) {
                        if (t + b + r + l >= 3 && !tl && !tr && !br && !bl) {
                            if (t) {
                                drawBlock(chip.road[0], ix, iy - 1, iz);
                                drawBlock(chip.crosswalkX, ix, iy - 1, iz);
                            }
                            if (l) {
                                drawBlock(chip.road[0], ix - 1, iy, iz);
                                drawBlock(chip.crosswalkY, ix - 1, iy, iz);
                            }
                            if (b) {
                                drawBlock(chip.crosswalkX, ix, iy + 1, iz);
                                noLine[toIndex(ix, iy + 1)] = true;
                            }
                            if (r) {
                                drawBlock(chip.crosswalkY, ix + 1, iy, iz);
                                noLine[toIndex(ix + 1, iy)] = true;
                            }
                        } else if (!noLine[toIndex(ix, iy)]) {
                            if (t) drawBlock(chip.centerline.T, ix, iy, iz);
                            if (l) drawBlock(chip.centerline.L, ix, iy, iz);
                            if (b) drawBlock(chip.centerline.B, ix, iy, iz);
                            if (r) drawBlock(chip.centerline.R, ix, iy, iz);
                        }
                        if (t) data.roadPath[toIndex(ix, iy)].push(0);
                        if (r) data.roadPath[toIndex(ix, iy)].push(1);
                        if (b) data.roadPath[toIndex(ix, iy)].push(2);
                        if (l) data.roadPath[toIndex(ix, iy)].push(3);
                    }
                } else if (!slope && iz >= level) {
                    if(t) drawBlock(chip.sidewalk.T, ix, iy, iz);
                    if(b) drawBlock(chip.sidewalk.B, ix, iy, iz);
                    if(l) drawBlock(chip.sidewalk.L, ix, iy, iz);
                    if(r) drawBlock(chip.sidewalk.R, ix, iy, iz);
                    if(t && r) drawBlock(chip.sidewalk.TRI, ix, iy, iz);
                    if(t && l) drawBlock(chip.sidewalk.TLI, ix, iy, iz);
                    if(b && r) drawBlock(chip.sidewalk.BRI, ix, iy, iz);
                    if(b && l) drawBlock(chip.sidewalk.BLI, ix, iy, iz);
                    if(!t && !r && tr) drawBlock(chip.sidewalk.TRO, ix, iy, iz);
                    if(!t && !l && tl) drawBlock(chip.sidewalk.TLO, ix, iy, iz);
                    if(!b && !r && br) drawBlock(chip.sidewalk.BRO, ix, iy, iz);
                    if(!b && !l && bl) drawBlock(chip.sidewalk.BLO, ix, iy, iz);
                }
                if (id == 6) drawPlane(chip.phoneBooth, ix, iy, h2);
                if (id == 7) drawPlane(chip.grassBall, ix, iy, h2);
                if (id == 8) {
                    if(slope == 4) drawBlock(chip.drainpipe.R, ix, iy, h);
                    if(slope == 1) drawBlock(chip.drainpipe.B, ix, iy, h);
                }
            }
        }
        //水の断面を描画
        var bmp:BitmapData = new BitmapData(canvas.width, canvas.height, true, 0xFF324856);
        bmp.copyChannel(waterSection, waterSection.rect, new Point(), BitmapDataChannel.BLUE, BitmapDataChannel.ALPHA);
        canvas.draw(bmp, new Matrix(), new ColorTransform(1, 1, 1, 1), BlendMode.MULTIPLY);
    }
    public function toIndex(x:int, y:int):int {
        return x * data.W + y;
    }
    public function getSlope(x:int, y:int):int {
        return data.slope[y + 1][x + 1];
    }
    public function getMaterial(x:int, y:int):int {
        return data.material[y + 1][x + 1];
    }
    /**
     * 斜面も考慮した高さを取得
     * @param    x
     * @param    y
     * @return
     */
    public function getHeight(x:int, y:int):Number {
        return data.level[y + 1][x + 1] - int(getSlope(x, y) != 0) * 0.5;
    }
    /**
     * 斜面を無視した高さを取得
     * @param    x
     * @param    y
     * @return
     */
    public function getLevel(x:int, y:int):int {
        return data.level[y + 1][x + 1];
    }
    public function setMaterial(x:int, y:int, id:int):void {
        data.material[y + 1][x + 1] = id;
    }
    public function setSlope(x:int, y:int, slope:int):void {
        data.slope[y + 1][x + 1] = slope;
    }
    public function setLevel(x:int, y:int, lv:int):void {
        data.level[y + 1][x + 1] = lv;
    }
    public function paintBlock(target:BitmapData, img:BitmapData, x:Number, y:Number, z:Number, offsetX:int = 0, offsetY:int = 0, ct:ColorTransform = null):void {
        paintPlane(target, img, x, y, z - 1, offsetX, offsetY - 1, ct);
    }
    public function paintPlane(target:BitmapData, img:BitmapData, x:Number, y:Number, z:Number, offsetX:int = 0, offsetY:int = 0, ct:ColorTransform = null):void {
        var p:Point = Quarter.toScreen(x, y, z);
        p.x -= 22;
        p.y += 22;
        target.draw(img, new Matrix(1, 0, 0, 1, p.x + offsetX, p.y - img.height + offsetY), ct);
    }
    public function drawBlock(img:BitmapData, x:Number, y:Number, z:Number, offsetX:int = 0, offsetY:int = 0):void {
        drawPlane(img, x, y, z - 1, offsetX, offsetY - 1);
    }
    public function drawPlane(img:BitmapData, x:Number, y:Number, z:Number, offsetX:int = 0, offsetY:int = 0):void {
        var p:Point = Quarter.toScreen(x, y, z);
        p.x -= 22;
        p.y += 22;
        canvas.copyPixels(img, img.rect, new Point(p.x + offsetX, p.y - img.height + offsetY), null, null, true); 
    }
}
class Quarter {
    /**
     * クオータービュー座標をスクリーン座標に変換する
     */
    static public function toScreen(x:Number, y:Number, z:Number):Point {
        return toLocalScreen(x, y, z).add(new Point(550, 150));
    }
    static public function toLocalScreen(x:Number, y:Number, z:Number):Point {
        return new Point(x * 22 - y * 22, x * 11 + y * 11 - z * 16);
    }
}
/**
 * マップチップ
 */
class MapChip {
    public const W:int = 42;
    public const H:int = 37;
    public const SIZE:Rectangle = new Rectangle(0, 0, W, H);
    /**透過色*/
    public const TRANSPARENT1:uint = 0x324856;
    public const TRANSPARENT2:uint = 0x182329;
    /**道路マップリスト*/
    public var road:Vector.<BitmapData>;
    /**T,B,L,R,TL,TR,BL,BR,TLI,TRI,BLI,BRI,TLO,TRO,BLO,BRO*/
    public var sidewalk:Object = { };
    /**RB(TL)*/
    public var drainpipe:Object = { };
    /**TRBL*/
    public var centerline:Object = { };
    /**TBLR*/
    public var bridge:Object = { };
    /**地形マップリスト*/
    public var terrain:Vector.<BitmapData>;
    public var crosswalkX:BitmapData;
    public var crosswalkY:BitmapData;
    /***/
    /***/
    public var groundGrass:BitmapData;
    public var groundAsphalt:BitmapData;
    public var groundSand:BitmapData;
    public var phoneBooth:BitmapData;
    public var grassBall:BitmapData;
    /**断面*/
    public var sectionL:BitmapData;
    public var sectionR:BitmapData;
    public var sections:Vector.<BitmapData>;
    public function MapChip() {
    }
    public function newBitmap(transparent:Boolean = true, color:uint = 0x000000):BitmapData {
        var bg:uint = (transparent)? 0x00 << 24 | color : 0xFF << 24 | color;
        return new BitmapData(W, H, transparent, bg);
    }
}
/**
 * 画面サイズ
 */
class Display {
    static public var stage:Stage;
    static public const WIDTH:int = 465;
    static public const HEIGHT:int = 465;
    static public const SIZE:Rectangle = new Rectangle(0, 0, WIDTH, HEIGHT);
    static public const CENTER:Point = new Point(SIZE.width / 2, SIZE.height / 2);
}
class Color {
    static public const BG:uint = 0x000000;
}
/**
 * Flickrから画像読み込み
 */
class Flickr extends EventDispatcher {
    static public const API:String = "http://api.flickr.com/services/feeds/photos_public.gne";
    static public const NS_MEDIA:String = "http://search.yahoo.com/mrss/";
    static public const NS_DC:String = "http://purl.org/dc/elements/1.1/";
    static public const NS_CC:String = "http://cyber.law.harvard.edu/rss/creativeCommonsRssModule.html";
    static public const NS_FLICKR:String = "urn:flickr:";
    /**サムネイルが読み込み完了する度に呼び出されるイベント*/
    static public const EVENT_LOADIMAGE:String = "onLoadImage";
    /**条件にマッチする画像が1つも見つからなかった時のイベント*/
    static public const EVENT_NOIMAGE:String = "onNoImage";
    /**画像を読み込む枚数*/
    public var loadLimit:int = 2;
    /**Flash以外を読み込む*/
    public var isSkipFlash:Boolean = true;
    /**全MediaItemデータ*/
    public var items:Vector.<MediaItem> = new Vector.<MediaItem>();
    /**サムネイルの読み込みが完了したMediaItemデータ*/
    public var loaded:Vector.<MediaItem> = new Vector.<MediaItem>();
    private var _stock:Vector.<MediaItem>;
    private var _rssLoader:URLLoader;
    private var _activeItem:MediaItem;
    private var _imageLoader:Loader;
    public function Flickr() {
        _rssLoader = new URLLoader();
        _imageLoader = new Loader();
    }
    /**
     * Flickrの画像を検索する
     * @param    tag
     */
    public function load(tag:String):void {
        items.length = 0;
        loaded.length = 0;
        removeEventImage();
        _rssLoader.addEventListener(Event.COMPLETE, onLoadRss);
        _rssLoader.addEventListener(IOErrorEvent.IO_ERROR, onErrorRss);
        _rssLoader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onErrorRss);
        _rssLoader.load(new URLRequest(getSearchPath(tag)));
    }
    private function onErrorRss(e:ErrorEvent):void {
        removeEventRss();
        dispatchEvent(new ErrorEvent(ErrorEvent.ERROR, false, false, e.text));
    }
    private function onLoadRss(e:Event):void {
        for each(var itm:MediaItem in items) itm.dispose();
        _stock = new Vector.<MediaItem>();
        removeEventRss();
        var xml:XML = new XML(_rssLoader.data);
        var media:Namespace = new Namespace(NS_MEDIA);
        var dc:Namespace = new Namespace(NS_DC);
        var cc:Namespace = new Namespace(NS_CC);
        var flickr:Namespace = new Namespace(NS_FLICKR);
        var tf:TextField = new TextField();
        for each(var node:XML in xml..item) {
            var item:MediaItem = new MediaItem();
            item.title = node.media::title;
            tf.htmlText = node.media::description;
            item.authorName = String(node.author).match(/.*?\((.*)\)/)[1];
            item.authorURL = node.author.@flickr::profile;
            item.descriptionHTML = node.media::description;
            item.descriptionText = tf.text;
            item.date.setDate(node.dc::date.Taken);
            item.thumbnail = node.media::thumbnail.@url;
            item.type = node.media::content.@type;
            item.content = node.media::content.@url;
            item.content_t = item.content.replace(/_[mstbo]\./, "_t.");
            item.isFlash = item.type == "application/x-shockwave-flash";
            if (!isSkipFlash || !item.isFlash) _stock.push(item);
        }
        _stock.sort(function():int { return 1 - Math.floor(Math.random() * 3) } );
        if (_stock.length > loadLimit) _stock.length = loadLimit;
        items = _stock.concat();
        if (!items.length) {
            dispatchEvent(new Event(EVENT_NOIMAGE));
        } else {
            loadNext();
        }
    }
    private function loadNext():void {
        if (!_stock.length || loaded.length >= loadLimit) {
            completeLoad();
            return;
        }
        _activeItem = _stock.shift();
        if (!_activeItem.thumbnail) {
            loadNext();
            return;
        }
        _imageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadImage);
        _imageLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onErrorImage);
        _imageLoader.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onErrorImage);
        _imageLoader.load(new URLRequest(_activeItem.thumbnail), new LoaderContext(true));
    }
    private function onErrorImage(e:ErrorEvent):void {
        removeEventImage();
        _activeItem.isLoading = false;
        _activeItem.isError = true;
        loadNext();
    }
    private function onLoadImage(e:Event):void {
        removeEventImage();
        _activeItem.isLoading = false;
        _activeItem.image = Bitmap(_imageLoader.content).bitmapData;
        loaded.push(_activeItem);
        dispatchEvent(new Event(EVENT_LOADIMAGE));
        loadNext();
    }
    private function completeLoad():void {
        _activeItem = null;
        dispatchEvent(new Event(Event.COMPLETE));
    }
    private function removeEventImage():void {
        _imageLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoadImage);
        _imageLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onErrorImage);
        _imageLoader.contentLoaderInfo.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, onErrorImage);
    }
    private function removeEventRss():void {
        _rssLoader.removeEventListener(Event.COMPLETE, onLoadRss);
        _rssLoader.removeEventListener(IOErrorEvent.IO_ERROR, onErrorRss);
        _rssLoader.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, onErrorRss);
    }
    public function getSearchPath(tag:String):String {
        return API + "?format=rss_200&tags=" + tag;
    }
}
/**
 * MediaRSSから取りだした画像データ
 */
class MediaItem {
    /**サムネイル読み込み中か*/
    public var isLoading:Boolean = true;
    /**サムネイルの読み込みに失敗したか*/
    public var isError:Boolean = false;
    /**タイトル*/
    public var title:String;
    /**作者名*/
    public var authorName:String;
    /**作者URL*/
    public var authorURL:String;
    /**投稿日時*/
    public var date:Date = new Date();
    /**説明文（HTMLテキスト）*/
    public var descriptionHTML:String;
    /**説明文（テキスト）*/
    public var descriptionText:String;
    /**サムネイルURL*/
    public var thumbnail:String;
    /**原寸画像URL*/
    public var content:String;
    public var type:String;
    public var isFlash:Boolean;
    public var content_t:String;
    /**サムネイルBitmapData*/
    public var image:BitmapData;
    public function MediaItem() {
    }
    /**
     * データを破棄
     */
    public function dispose():void {
        image.dispose();
    }
}
/**
 * 複数画像読み込み
 */
class ImageLoader {
    public var image:Object = new Object();
    private var _images:Array = new Array();
    private var _count:int;
    private var _completeFunc:Function;
    private var _errorFunc:Function;
    private var _activeLoader:Loader;
    public function ImageLoader() {
    }
    public function addImage(src:String, name:String):void {
        _images.push( { src:src, name:name } );
    }
    public function stop():void {
        if (_activeLoader) {
            _activeLoader.unloadAndStop();
            removeEvent(_activeLoader.contentLoaderInfo);
            _activeLoader = null;
        }
    }
    public function load(complete:Function, error:Function = null):void {
        _count = -1;
        _completeFunc = complete;
        _errorFunc = error;
        next();
    }
    public function resetItem():void {
        _images.length = 0;
    }
    public function disposeAll():void {
        for (var k:String in image) {
            dispose(k);
        }
    }
    public function dispose(id:String):void {
        if (image[id] is BitmapData) {
            var bmp:BitmapData = image[id];
            if (bmp) bmp.dispose();
        }
    }
    private function next():void {
        if (++_count >= _images.length) {
            if(_completeFunc != null) _completeFunc.apply(null, []);
            return;
        }
        _activeLoader = new Loader();
        _activeLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
        _activeLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onError);
        _activeLoader.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError);
        _activeLoader.load(new URLRequest(_images[_count].src), new LoaderContext(true));
    }
    private function onError(e:ErrorEvent):void {
        _activeLoader = null;
        removeEvent(e.currentTarget as LoaderInfo);
        if (_errorFunc != null) _errorFunc.apply(null, []);
    }
    private function onComplete(e:Event):void {
        _activeLoader = null;
        var info:LoaderInfo = e.currentTarget as LoaderInfo;
        removeEvent(info);
        if (info.content is Bitmap) {
            image[_images[_count].name] = Bitmap(info.content).bitmapData;
        } else {
            image[_images[_count].name] = info.content;
        }
        next();
    }
    private function removeEvent(target:LoaderInfo):void {
        target.removeEventListener(Event.COMPLETE, onComplete);
        target.removeEventListener(IOErrorEvent.IO_ERROR, onError);
        target.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, onError);
    }
}
/**
 * 簡易イージング
 */
class EaseMotion {
    private static var _sprite:Sprite = new Sprite();
    private static var _targets:Dictionary = new Dictionary();
    private static var _isInit:Boolean = false;
    public function EaseMotion() {
    }
    private static function init():void {
        if (_isInit) return;
        _isInit = true;
        _sprite.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    static private function onEnterFrame(e:Event):void {
        var p:ParamData, o:Object, k:String;
        for each(o in _targets) {
            for (k in o) {
                p = ParamData(o[k]);
                p.position += (p.to - p.position) * p.speed;
                var n:Number = p.position < p.to ? p.to - p.position : p.position - p.to;
                p.target[k] = p.position;
                if (n <= p.snap) {
                    p.target[k] = p.to;
                    if (p.completeFunc != null) p.completeFunc.apply(null, p.args);
                    delete o[k];
                }
            }
        }
    }
    static public function goto(target:Object, param:String, to:Number):void {
        var tgt:Object = _targets[target];
        if (tgt) delete tgt[param];
        target[param] = to;
    }
    /**
     * オブジェクトのプロパティを指定の数値に近付ける
     * @param    target    対象オブジェクト
     * @param    param    プロパティ名
     * @param    to    近づける値
     * @param    speed    速度(0超過～1以下)
     * @param    complete    移動しきった時に呼び出す関数
     * @param    args    関数に渡す引数
     * @param    snap    
     */
    static public function ease(target:Object, param:String, to:Number, speed:Number = NaN, complete:Function = null, args:Array = null, snap:Number = NaN):void {
        init();
        var p:ParamData;
        var tgt:Object = _targets[target];
        if (tgt) {
            p = tgt[param];
            if (p) {
                p.to = to;
                p.snap = (isNaN(snap))? (p.to - p.position) * 0.01 : snap;
                if (p.snap < 0) p.snap = -p.snap;
                if (!isNaN(speed)) p.speed = speed;
                if (p.completeFunc != null) p.completeFunc = complete;
                if (args) p.args = args;
                return;
            }
        } else {
            _targets[target] = { };
        }
        p = new ParamData();
        p.target = target;
        p.position = target[param];
        p.to = to;
        p.snap = (isNaN(snap))? (p.to - p.position) * 0.01 : snap;
        p.completeFunc = complete;
        p.args = (!args)? [] : args;
        if (p.snap < 0) p.snap = -p.snap;
        if (!isNaN(speed)) p.speed = speed;
        _targets[target][param] = p;
    }
    static public function setSpeed(target:Object, param:String, speed:Number):void {
        var pd:ParamData = getEase(target, param);
        if (pd) pd.speed = speed;
    }
    static public function getEase(target:Object, param:String):ParamData {
        if (!_targets[target]) return null;
        return _targets[target][param];
    }
}
/**
 * イージング用データ
 */
class ParamData {
    public var target:Object;
    public var position:Number = 0;
    public var to:Number = 0;
    public var speed:Number = 0.2;
    public var snap:Number = 0;
    public var args:Array = [];
    public var completeFunc:Function;
    public function ParamData() {
    }
}
class Painter {
    /**
     * べた塗りスプライト生成
     * @param    width
     * @param    height
     * @param    color
     * @param    alpha
     * @return
     */
    static public function createColorRect(width:Number, height:Number, color:uint = 0x000000, alpha:Number = 1, x:Number = 0, y:Number = 0):Sprite {
        var sp:Sprite = new Sprite();
        sp.graphics.beginFill(color, alpha);
        sp.graphics.drawRect(0, 0, width, height);
        sp.graphics.endFill();
        sp.x = x;
        sp.y = y;
        return sp;
    }
}