/**
 * Copyright okmt_masaaki ( http://wonderfl.net/user/okmt_masaaki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fHNH
 */

package {
	
	/*
		作りかけw
		okmt.masaaki
		http://twitter.com/okamotomasaaki
		http://cce-flash.tumblr.com/
		
		ニュイーんとなる部分はあんまり重要ではなくて
		プログラム末尾にinternal classとしてくっつけた
		BitmapTriangleというdrawTrianglesを使った
		Spriteを生成してくれるクラスのデモみたいな感じです。
		これによって超変形が可能に！！
		
		最適化してません。。。
		
	*/
	
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.*;
	import flash.display.*;
	import flash.system.LoaderContext;
    import flash.geom.Matrix;
    import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.geom.Point;
	import flash.text.TextField;
	import caurina.transitions.Tweener;
	
    public class DrawTrianglesTest extends Sprite {
	    	private var myRequest:URLRequest;
	    private var texture:BitmapData;
	    //表示オブジェクト２つ
	    private var sample:BitmapTriangle;
		//ヘルパー用オブジェクト
		private var pointhelper:Sprite;
		private var dumyPos:Array;
		private var targetPos:Array;
		//極座標変換用関連パラメータ
		private var r:MovieClip;
		private const rMin:Number = 0;
		private const rMax:Number = 800;
		private var theta:MovieClip;
		private const thetaMin:Number = 2;
		private const thetaMax:Number = 360 / xDiv;
	    
	    //下のxDiv,yDivパラメータが重要です。
	    private const xDiv:uint = 30;
	    private const yDiv:uint = 10;
	    private var imgWidth:uint;
	    private var imgHeight:uint;
	    //private const imgURL:String = "http://farm1.static.flickr.com/240/448246554_3648fd767e_b.jpg";
	    //private const imgURL:String = "http://farm1.static.flickr.com/22/34430486_8775d60e8d_b.jpg";
	    //private const imgURL:String = "http://farm2.static.flickr.com/1202/740325509_03af2f2dfc_b.jpg";
	     private const imgURL:String = "http://farm4.static.flickr.com/3056/2973865329_2fe43f3ab3_b.jpg";
	    //private const imgURL:String = "http://farm4.static.flickr.com/3324/3343560324_f670a3df01_b.jpg";
	    //private const imgURL:String = "http://farm4.static.flickr.com/3339/3223509093_894e540bbf_b.jpg";
	    
	    
		
		public function DrawTrianglesTest() {
			//画像の読み込みっす。
			loadImg();
		}

		private function loadImg():void
		{
			var myLoader:Loader = new Loader();
			var myURLRequest:URLRequest = new URLRequest(imgURL);
			//LoaderContextを使うと、drawできるようになる。ただしcrossdomain.xmlで許可されている場合のみ
			//これ→http://farm4.static.flickr.com/crossdomain.xml
			var myLoaderContext:LoaderContext = new LoaderContext(true);
			myLoader.load(myURLRequest , myLoaderContext);
			myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void
			{
				var myBitmap:Bitmap = e.target.content;
				imgWidth = myBitmap.width;
				imgHeight = myBitmap.height;
				texture = new BitmapData(myBitmap.width, myBitmap.height);
				texture.draw(myBitmap);
				initialize();
			});		
		}
		//初期化
		private function initialize():void
		{
			createVertics();
			createBitmapTriangles();
			createPointer();
			stageSetting();
			animation();
		}
		private function createVertics():void
		{
			dumyPos = new Array();
			targetPos = new Array();
			
			r = new MovieClip();
			r.y = rMax;
			theta = new MovieClip();
			theta.x = thetaMin;
			
			for (var j:int = 0; j <= yDiv; j++) {
				dumyPos[j] = new Vector.<Point>;
				targetPos[j] = new Vector.<Point>;
				for (var i:int = 0; i <= xDiv; i++) {
					var rtemp:Number = r.y + (yDiv - j) * texture.height / yDiv;
					var thetatemp:Number = (theta.x * i - theta.x * xDiv / 2 + 270) / 360 * Math.PI * 2;
					dumyPos[j][i] = new Point(texture.width/xDiv*i - texture.width/2,texture.height/yDiv*j - texture.height/2 + (stage.stageHeight - texture.height) / 2);
					targetPos[j][i] = new Point(texture.width / xDiv * i - texture.width / 2, texture.height / yDiv * j - texture.height / 2 );
				}
			}
			
			
		}
		
	  	private function createBitmapTriangles():void
	  	{
	  		sample = new BitmapTriangle(texture,xDiv,yDiv);
	  		sample.pointArray = dumyPos;
	  		sample.bitmapUpdate();
	  		addChild(sample);
	  	}
		private function createPointer():void
	  	{
	  		pointhelper = new Sprite();
	  		addChild(pointhelper);
			for(var j:int = 0;j<= yDiv;j++){
				for(var i:int = 0;i<= xDiv;i++){
					var mc:Pointer = new Pointer();
					pointhelper.addChild(mc);
					mc.x = targetPos[j][i].x;
					mc.y = targetPos[j][i].y;
					mc.name = "mymc" + String(i) + "_" + String(j);
					mc.setText(String(i) + "," + String(j));
					
				}	
			}
	  		
	  	}
        private function animation():void
        {
        		Tweener.addTween(r, { y:0, time:2,delay:3, transition:"easeInOutQuad",onStart:checkInUpdate } );
        		Tweener.addTween(theta, { x:thetaMax, time:2,delay:3, transition:"easeInOutQuad" } );
        }
        
		private function checkInUpdate():void
		{
        		stage.addEventListener(Event.ENTER_FRAME,update);
        }
		private function update(e:Event = null):void
		{
			var mc:Sprite;
			
			for (var j:int = 0; j <= yDiv; j++) {
				for (var i:int = 0; i <= xDiv; i++) {
					var rtemp:Number = r.y + (yDiv - j) * texture.height / yDiv;
					var thetatemp:Number = (theta.x * i - theta.x * xDiv / 2 + 270) / 360 * Math.PI * 2;
					targetPos[j][i] = new Point(Math.round(rtemp * Math.cos(thetatemp) ), Math.round( rtemp*Math.sin(thetatemp) + r.y));
					
					dumyPos[j][i].x += (targetPos[j][i].x - dumyPos[j][i].x) / 10;
					dumyPos[j][i].y += (targetPos[j][i].y - dumyPos[j][i].y) / 10;
					
					mc = pointhelper.getChildByName("mymc" + String(i) + "_" + String(j)) as Sprite;
					mc.x = dumyPos[j][i].x;
					mc.y = dumyPos[j][i].y;
					
				}
			}
			//描画
			sample.pointArray = dumyPos;
			sample.bitmapUpdate();
		}
        
        private function stageSetting():void
        {
        		stage.scaleMode = StageScaleMode.NO_SCALE;
        		stage.align = StageAlign.TOP_LEFT;
        		stage.addEventListener(Event.RESIZE,onResize);
        		onResize();
        }
        private function onResize(e:Event = null):void
        {
        		sample.x = pointhelper.x = stage.stageWidth/2;
        		sample.y = pointhelper.y = stage.stageHeight/2;
        		
        }
    }
}





//drawTrianglesを簡単に扱うためのクラス-----------------------------------------------------------------------------
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.Point;
internal class BitmapTriangle extends Sprite
{
	public var pointArray:Array;
	public var xDivision:uint = 1;
	public var yDivision:uint = 1;
	public var texture:BitmapData;
	private var xOffset:Number = 0;
	private var yOffset:Number = 0;
	
	//コンストラクタ
	public function BitmapTriangle(bmp:BitmapData, xDivision:uint , yDivision:uint , xOffset:Number = 0, yOffset:Number = 0) 
	{
		/* bmp : ソース
		 * xDivision : X方向の分割数 
		 * yDivision : Y方向の分割数
		 * xOffset :　X方向のオフセット
		 * yOffset :　Y方向のオフセット
		 */

		pointArray = new Array();
		this.xDivision = xDivision;
		this.yDivision = yDivision;
		this.xOffset = xOffset;
		this.yOffset = yOffset;
		texture = bmp;
		
		
		createCoordinate();
		bitmapUpdate();
	}
	
	//頂点の生成（初期化）
	//x軸、y軸共に分割数＋１の頂点を生成する
	private function createCoordinate():void {
		var i:uint;
		var j:uint;
		for (j = 0; j <= yDivision; j++) {
			pointArray[j] = new Vector.<Point>();
			for (i = 0; i <= xDivision; i++) {
				pointArray[j][i] = new Point(texture.width/xDivision*i,texture.height/yDivision*j);
			}
		}
	}
	
	//描画を更新するメソッド
	public function bitmapUpdate():void {
		var i:uint;
		var j:uint;
		var vertices:Vector.<Number> = new Vector.<Number>();
		var indices:Vector.<int> = new Vector.<int>();
		var uvt:Vector.<Number> = new Vector.<Number>();
		
		
		for(j = 0;j<= yDivision;j++){
			for(i = 0;i<= xDivision;i++){
				vertices.push(pointArray[j][i].x + xOffset,pointArray[j][i].y + yOffset);
				uvt.push(1/xDivision*i,1/yDivision*j);
			}	
		}
		
		for(j = 0;j< yDivision;j++){
			for(i = 0;i< xDivision;i++){
				indices.push((xDivision+1)*j+i,(xDivision+1)*j+1+i,i+(xDivision+1)*(j+1));
				indices.push((xDivision+1)*j+1+i,i+(xDivision+1)*(j+1),i+(xDivision+1)*(j+1)+1);
			}	
		}
		this.graphics.clear();
		this.graphics.beginBitmapFill(texture);
		this.graphics.drawTriangles(vertices, indices, uvt);
	}
	//座標取得
	public function getPointsArray():Array
	{
		return pointArray;
	}
}
//頂点表示用のヘルパースプライト（画面上の黒い点と頂点番号を視覚的に見えるようにしたもの）

import flash.text.TextField;
import flash.text.TextFormat;
internal class Pointer extends Sprite{
	private var mytext:TextField;
	public function Pointer(){
		this.graphics.beginFill(0xFFFFFF);
		this.graphics.drawCircle(-1,-1,2);
		this.graphics.endFill();
		mytext = new TextField();
		//mytext.autoSize = true;
		mytext.defaultTextFormat = new TextFormat(null,9,0xFFFFFF);
		addChild(mytext);
	}
	public function setText(str:String):void
	{
		mytext.text = str;
	}
}


