/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fH3l
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        	
            // write as3 code here..
        		addChild( UnionChat.initAndGetView("unionTest.myRoom") );
        }
    }
}

import flash.events.EventDispatcher;
import flash.display.DisplayObjectContainer;
import net.user1.reactor.*;
import flash.display.*;
import flash.text.*;
import flash.events.*;
import flash.ui.Keyboard;

class UnionChat extends EventDispatcher
{
	private static var _view:DisplayObjectContainer = new Sprite();
	private static var _roomName:String;
	private static var _reactor:Reactor;
	private static var _incoming:TextField;
	private static var _input:TextField;
	private static var _userList:TextField;
	private static var _room:Room;

	public static function initAndGetView(roomName:String, server:String = "tryunion.com", port:Number = 9100):DisplayObject{
		_init(roomName, server, port);
		_buildUI(_view);
		_view.y = UnionChatConst.STAGE_HEIGHT - UnionChatConst.CHAT_HEIGHT - 1;
		return _view;
	}
	private static function _init(roomName:String, server:String, port:Number):void{
		_reactor = new Reactor();
		_incoming = new TextField();
		_input = new TextField();
		_userList = new TextField();
		_roomName = roomName;
		_reactor.addEventListener(ReactorEvent.READY, onReady);
		_reactor.connect(server, port);
	}
	private static function onReady(e:ReactorEvent):void{
		_room = _reactor.getRoomManager().createRoom(_roomName);
		_room.addEventListener(RoomEvent.JOIN, onJoin);
		_room.addEventListener(RoomEvent.OCCUPANT_COUNT, onOccupantCount);
		_room.addEventListener(RoomEvent.UPDATE_CLIENT_ATTRIBUTE, onUpdateClientAttribute);
		_room.addMessageListener(UnionChatConst.CHAT_MESSAGE, onChatMessage);
		_room.join();
	}
	private static function onUpdateClientAttribute(e:RoomEvent):void{
		_updateUserList();
	}
	private static function onOccupantCount(e:RoomEvent):void{
		_updateUserList();
	}
	private static function _updateUserList():void{
		var users:String = "";
		var clients:Array = _room.getOccupants();
		var count:int = clients.length;
		for( var i:int = 0; i < count; i++ ){
			users += _getUserName(clients[i]) + "\n";
		}
		_userList.text = users;
	}
	private static function onJoin(e:RoomEvent):void{
		_incoming.appendText("room join\n");
		_input.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
	}
	private static function onKeyDown(e:KeyboardEvent):void{
		if( e.keyCode == Keyboard.ENTER ){
			if( _input.text.substr(0,1) == "/" ){
				var temp:Array = _input.text.split(" ");
				var command:String = temp[0].substr(1);
				switch( command ){
					case "nick":
						if( temp[1] != "" ){
							_reactor.self().setAttribute("nickname", temp[1]);
						}
						break;
				}

			} else {
                                if( _input.text != "" )
            				_room.sendMessage(UnionChatConst.CHAT_MESSAGE, true, null, _input.text);
			}
			_input.text = "";
		}
	}
	private static function onChatMessage(from:IClient, msg:String):void{
		//_incoming.appendText("Guest" + from.getClientID() + " : " + msg + "\n");
		_incoming.appendText(_getUserName(from) + " : " + msg + "\n");
	}

	private static function _buildUI(doc:DisplayObjectContainer):void{
		_incoming.width = UnionChatConst.CHAT_WIDTH - UnionChatConst.USERLIST_WIDTH;
		_incoming.height = UnionChatConst.CHAT_HEIGHT - 20;
		_incoming.border = true;
		_incoming.x = 1;
		_view.addChild(_incoming);
		_input.width = UnionChatConst.CHAT_WIDTH;
		_input.height = 20;
		_input.type = "input";
		_input.border = true;
		_input.x = _incoming.x;
		_input.y = UnionChatConst.CHAT_HEIGHT - 20;
		_view.addChild(_input);
		_userList.width = UnionChatConst.USERLIST_WIDTH;
		_userList.height = UnionChatConst.CHAT_HEIGHT - 20;
		_userList.border = true;
		_userList.x = _incoming.x + _incoming.width;
		_userList.y = _incoming.y;
		_view.addChild(_userList);
	}
	private static function _getUserName(client:IClient):String{
		var userName:String = client.getAttribute("nickname");
		if( userName ){
			return userName;
		} else {
			return "Guest" + client.getClientID();
		}
	}
}

class UnionChatConst
{
	public static const STAGE_WIDTH:Number = 465;
	public static const STAGE_HEIGHT:Number = 465;
	public static const CHAT_WIDTH:Number = 463; // borderを画面内に表示するために-2px
	public static const CHAT_HEIGHT:Number = 160; // 20pxは入力バーの部分
	public static const USERLIST_WIDTH:Number = 100; // CHAT_WIDTHのうち右側この幅だけユーザー一覧を表示
	public static const CHAT_MESSAGE:String = "chatMessage";
	
}