/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fH3Z
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.ui.ContextMenu;
    import idv.cjcat.stardust.twoD.handlers.DisplayObjectHandler;
    import org.libspark.betweenas3.BetweenAS3;
    
    /**
     * 2日遅れだけど。
     * 
     * @author paq
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFEFC", frameRate="60")]
    public class ForNarutoBaby extends Sprite 
    {
        //public static const IMAGE_URL:String = "../assets/letter.png";
        //public static const MASK_URL:String = "../assets/mask.png";
        public static const IMAGE_URL:String = "http://assets.wonderfl.net/images/related_images/9/93/93e8/93e8aa5ea16de648d9207adcd0bb473350f851d3";
        public static const MASK_URL:String = "http://assets.wonderfl.net/images/related_images/8/8c/8cac/8caca9455707c73e8f6d0f883795d061d99670db";
        public static const ZERO_POINT:Point = new Point(0, 0);
        public static const COLOR_FILTER:ColorMatrixFilter = new ColorMatrixFilter([
            1, 0, 0, 0, 0,
            0, 1, 0, 0, 0,
            0, 0, 1, 0, 0,
            0, 0, 0, 1.1, 1
            ]);
        
        private var _emitter:BalloonEmitter;
        private var _particleContainer:Sprite;
        
        private var _letterLoader:Loader;
        private var _maskLoader:Loader;
        private var _maskBitmap:Bitmap;
        private var _fieldBitmapData:BitmapData;
        
        private var _loadedCount:int = 0;
        private var _maxLoad:int = 0;
        private var _frame:int = 0;
        private var _transitionFrame:int = 0;
        
        /**
         * コンストラクタ
         */
        public function ForNarutoBaby() 
        {
            var naruto:* = {}
            naruto.baby = new Baby(2011/2/9);
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * @param    event
         */
        private function init(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            initStage();
            initWonderfl();
            initEventListeners();
            
            loadAssets();
            
            //addChild(new Balloon);
        }
        
        /**
         * ステージを最適な設定に変更します.
         */
        private function initStage():void 
        {
            stage.quality = StageQuality.HIGH;
            this.contextMenu = new ContextMenu();
            this.contextMenu.hideBuiltInItems();
        }
        
        /**
         * Wonderfl 向けの設定を記述します.
         */
        private function initWonderfl():void 
        {
            // キャプチャを無効にする
            Wonderfl.disable_capture();
            
            var g:Graphics = this.graphics;
            g.beginFill(0xFFFEFC);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
        
        
        /**
         * イベントハンドラーを追加します.
         */
        private function initEventListeners():void 
        {
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            addEventListener(Event.RESIZE, onResize);
        }
        
        /**
         * 必要なアセットを読み込みます.
         */
        private function loadAssets():void 
        {
            _loadedCount = 0;
            _maxLoad = 2;
            _maskBitmap = null;
            
            _letterLoader = new Loader();
            _letterLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
            _letterLoader.load(new URLRequest(IMAGE_URL), new LoaderContext(true));
            
            _maskLoader = new Loader();
            _maskLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
            _maskLoader.load(new URLRequest(MASK_URL), new LoaderContext(true));
        }
        
        /**
         * 
         */
        private function initLetter():void 
        {
            _letterLoader.content.cacheAsBitmap = true;
            _maskBitmap = Bitmap(_maskLoader.content);
            _maskBitmap.cacheAsBitmap = true;
            _letterLoader.content.mask = _maskLoader.content;
            addChild(_letterLoader.content);
            addChild(_maskBitmap);
            
            BetweenAS3.tween(_letterLoader.content, { alpha: 1 }, { alpha: 0 } ).play();
        }
        
        /**
         * Stardust エミッターを初期化します.
         */
        private function initEmitter():void 
        {
            _particleContainer = new Sprite();
            addChild(_particleContainer);
            
            _emitter = new BalloonEmitter(stage);
            _emitter.particleHandler = new DisplayObjectHandler(_particleContainer);
        }
        
        /**
         * 毎フレームの処理.
         * 
         * @param    event
         */
        private function onEnterFrame(event:Event):void 
        {
            _frame++;
            
            if (_emitter && _transitionFrame >= 10)
                _emitter.step();
                
            if (_maskBitmap && _transitionFrame < 50 && _frame % 4 == 0)
            {
                var bmpd:BitmapData = _maskBitmap.bitmapData;
                bmpd.applyFilter(bmpd, bmpd.rect, ZERO_POINT, COLOR_FILTER);
                _transitionFrame++;
            }
        }
        
        /**
         * リサイズ時の処理.
         * 
         * @param    event
         */
        private function onResize(event:Event):void 
        {
            var g:Graphics = this.graphics;
            g.beginFill(0xFFFEFC);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
        
        /**
         * Loader の読み込み完了時の処理.
         * 
         * @param    event
         */
        private function onComplete(event:Event):void 
        {
            removeEventListener(Event.COMPLETE, arguments.callee);
            _loadedCount++;
            
            if (_loadedCount >= _maxLoad)
            {
                initLetter();
                initEmitter();
            }
        }
        
    }
    
}

//--------------------------------------------------------------------------

import flash.display.Graphics;
import flash.display.GraphicsPathCommand;
import flash.display.Sprite;
import flash.display.Stage;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.clocks.SteadyClock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.Line;
import idv.cjcat.stardust.twoD.zones.SectorZone;

//--------------------------------------------------------------------------

/**
 * おめでとうございます.
 */
class Baby { function Baby(birth:Number) {}}

//--------------------------------------------------------------------------

/**
 * Balloon クラスは Sprite を継承したクラスです。 このクラスは BalloonEmitter に使用されます.
 * 
 * @see BalloonEmitter
 */
class Balloon extends Sprite
{
    /** 風船の色を格納する配列です、この中からランダムに色が選ばれます. */
    public const COLORS:Array = [0x44996F, 0xE5C10F, 0xFF6C0D, 0x44996F, 0x216273, 0xFF2F25, 0x24736B];
    
    /**
     * 新しい Balloon クラスのインスタンスを作成します.
     */
    public function Balloon() 
    {
        draw();
    }
    
    /**
     * ランダムに色を返します.
     * 
     * @return color
     */
    private function getColor():uint
    {
        return COLORS[Math.random() * COLORS.length >> 0];
    }
    
    /**
     * 風船を描画します.
     */
    protected function draw():void 
    {
        var commands:Vector.<int> = new Vector.<int>();
        var data:Vector.<Number> = new Vector.<Number>();
        
        var bodyWidth:Number = 35;
        var bodyHeight:Number = 40;
        
        var g:Graphics = this.graphics;
        g.clear();
        
        var bodyColor:uint = getColor();
        
        g.beginFill(bodyColor, 0.9);
        g.drawEllipse(0, 0, bodyWidth, bodyHeight);
        
        commands = new Vector.<int>();
        commands.push(GraphicsPathCommand.MOVE_TO, GraphicsPathCommand.LINE_TO, GraphicsPathCommand.LINE_TO);
        
        data = new Vector.<Number>();
        data.push(bodyWidth / 2, bodyHeight - bodyHeight * 0.1,
                  bodyWidth / 2 - bodyWidth * 0.2, bodyHeight + bodyHeight * 0.15,
                  bodyWidth / 2 + bodyWidth * 0.2, bodyHeight + bodyHeight * 0.15);
        
        g.drawPath(commands, data);
        
        g.endFill();
        
        g.lineStyle(1, 0x520E00, 1);
        
        commands = new Vector.<int>();
        commands.push(GraphicsPathCommand.MOVE_TO, GraphicsPathCommand.LINE_TO, GraphicsPathCommand.LINE_TO, GraphicsPathCommand.LINE_TO);
        
        data= new Vector.<Number>();
        data.push(bodyWidth / 2, bodyHeight,
                  bodyWidth / 2 + Math.random() * bodyWidth * 0.1 - Math.random() * bodyWidth * 0.1, bodyHeight+bodyHeight*0.3,
                  bodyWidth / 2 + Math.random() * bodyWidth * 0.1 - Math.random() * bodyWidth * 0.1, bodyHeight+bodyHeight*0.6,
                  bodyWidth / 2 + Math.random() * bodyWidth * 0.1 - Math.random() * bodyWidth * 0.1, bodyHeight+bodyHeight*1);
        
        g.drawPath(commands, data);
    }
    
}

//--------------------------------------------------------------------------

/**
 * BalloonEmitter クラスは、 Emitter2D を継承した、 Balloon を作成をする Stardust 用のクラスです。
 * 
 * @see Balloon
 */
class BalloonEmitter extends Emitter2D
{
    /**
     * 新しい BalloonEmitter クラスのインスタンスを作成します.
     * 
     * @param stage
     */
    public function BalloonEmitter(stage:Stage)
    {
        super(new SteadyClock(0.4));
        
        addInitializer(new Life(new UniformRandom(60, 10)));
        addInitializer(new DisplayObjectClass(Balloon));
        addInitializer(new Position(new Line(0, stage.stageHeight, stage.stageWidth, stage.stageHeight)));
        addInitializer(new Velocity(new SectorZone(0, 0, 3, 7, -70, -110)));
        addInitializer(new Scale(new UniformRandom(1, 0.1)));
        
        addAction(new Age());
        addAction(new Move());
    }
}