/**
 * Copyright marcsali ( http://wonderfl.net/user/marcsali )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fGia
 */

/*

*    3目並べ

*    先攻・後攻はランダム(先攻は黒)

*    レベル設定無し

*    勝敗クリックで再ゲーム

*/



package 

{

    import flash.display.Sprite;

    import flash.display.StageAlign;

    import flash.display.StageScaleMode;

    import flash.events.MouseEvent;

    import flash.text.TextField;

    import flash.text.TextFormat;



[SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)]



    public class TicTac extends Sprite

    {

        private var _btnList:Array = [];

        private var _strList:Array = ["Black","White"];

        private var _p:Boolean;

        

        private var winList:Array = [ ["00","01","02"],["10","11","12"],["20","21","22"],

                                        ["00","10","20"],["01","11","21"],["02","12","22"],

                                        ["00","11","22"],["02","11","20"]];

        

        private var _wFlg:Boolean;

        private var _dFlg:Boolean;

        private var _count:uint = 9;

        

        private var jt:TextField;



                private var _wSize:Number;

        

        public function TicTac()

        {

            stage.align = StageAlign.TOP_LEFT;

            stage.scaleMode = StageScaleMode.NO_SCALE;

            

            setup();

        }

        

        private function setup():void

        {

                        _wSize = 465/3-5;

            for(var y:uint=0; y<3; y++)

            {

                var Blist:Array = [];

                for(var x:uint=0; x<3; x++)

                {

                    var btn:Sprite = new Sprite();

                    Blist.push(btn);

                    btn.buttonMode = true;

                    btn.name = "none";

                    addChild(btn);

                    btn.x = x*_wSize + 10;

                    btn.y = y*_wSize + 10;

                    with(btn.graphics)

                    {

                        beginFill(0xffaaaa);

                        lineStyle(1,0xff0000);

                        drawRect(0,0,_wSize-10,_wSize-10);

                    }

                    btn.addEventListener(MouseEvent.CLICK,click);

                }

                _btnList.push(Blist);

            }

            

            jt = new TextField();

            addChild(jt);

            jt.visible = false;

            jt.selectable  = false;

            jt.addEventListener(MouseEvent.CLICK,reset);

            jt.width = 200;

            jt.height = 30;

            jt.x= stage.stageWidth/2 - jt.width/2;

            jt.y = stage.stageHeight/2 - jt.height/2;

            jt.defaultTextFormat = new TextFormat("_ゴシック",26,0xff0000,null,null,null,null,null,"center");

            

            var p:uint = Math.round(Math.random());

            if(p==0){_p = true;}

            else{_p = false;computer();}

        }

        

        private function reset(e:MouseEvent):void

        {

            for(var y:uint=0; y<3; y++)

            {

                for(var x:uint=0; x<3 ; x++)

                {

                    draw(_btnList[y][x],0xaaaaaa);

                    _btnList[y][x].name = "none";

                    _btnList[y][x].addEventListener(MouseEvent.CLICK,click);

                }

            }

            _wFlg = false;

            _dFlg  =false;

            _count = 9;

            jt.visible = false;

            

            var p:uint = Math.round(Math.random());

            if(p==0){_p = true;}

            else{_p = false;computer();}

        }

        

        private function click(e:MouseEvent=null,x:uint=0,y:uint=0):void

        {

            if(e)

            {

                _count--;

                e.currentTarget.removeEventListener(MouseEvent.CLICK,click);

                if(_p)

                {

                    e.currentTarget.name = "Black";

                    draw(e.currentTarget,0x000000);

                }

                else

                {

                    e.currentTarget.name = "White";

                    draw(e.currentTarget,0xffffff);

                }

                judge(e.currentTarget.name,true);

            }

            else

            {

                _count--;

                _btnList[x][y].removeEventListener(MouseEvent.CLICK,click);

                if(_p)

                {

                    _btnList[x][y].name = "White";

                    draw(_btnList[x][y],0xffffff);

                    judge("White");

                }

                else

                {

                    _btnList[x][y].name = "Black";

                    draw(_btnList[x][y],0x000000);

                    judge("Black");

                }

            }

        }

        

        private function draw(target:*,color:uint):void

        {

            with(target.graphics)

            {

                clear();

                beginFill(color);

                lineStyle(1,0x000000);

                drawRect(0,0,_wSize-10,_wSize-10);

            }

        }

        

        private function computer(x:int=-1,y:int=-1):void

        {

            var p:Array = AI();

            x = p[0];

            y = p[1];

            if(x<0)

            {

                x = Math.random()*3;

                y = Math.random()*3;

            }

            

            if(!_dFlg && (_btnList[x][y].name != "none"))

            {

                if(_btnList[x][y].name != "none")

                {

                    computer();

                }

            }

            else if(!_dFlg)

            {

                click(null,x,y);

            }

        }

        

        private function AI():Array

        {

            var x:int = -1;

            var y:int = -1;

            

            if(_count < 7)

            {

                for(var l:uint=0; l<8; l++)

                {

                    var a0:uint = uint(winList[l][0].substr(0,1));

                    var b0:uint = uint(winList[l][0].substr(1,1));

                    var str0:String = _btnList[a0][b0].name;

                    

                    var a1:uint = uint(winList[l][1].substr(0,1));

                    var b1:uint = uint(winList[l][1].substr(1,1));

                    var str1:String = _btnList[a1][b1].name;

                    

                    var a2:uint = uint(winList[l][2].substr(0,1));

                    var b2:uint = uint(winList[l][2].substr(1,1));

                    var str2:String = _btnList[a2][b2].name;

                    

                    if(((str0==str1) && (str2=="none"))&&(str0!=str2))

                    {

                            x = a2;

                            y = b2;

                            break;

                    }

                    else if(((str0==str2) && (str1=="none"))&&(str0!=str1))

                    {

                            x = a1;

                            y = b1;

                            break;

                    }

                    else if(((str1==str2) && (str0=="none"))&&(str0!=str1))

                    {

                            x = a0;

                            y = b0;

                            break;

                    }

                }

                if(_count==6 || _count==5)

                {

                    if(x<0)

                    {    

                        if((_btnList[2][0].name==_btnList[1][2].name)&&(_btnList[2][0].name!="none")){x=y=2;}

                        else if((_btnList[1][0].name==_btnList[0][2].name)&&(_btnList[1][0].name!="none")){x=y=0;}

                        else if((_btnList[0][1].name==_btnList[2][2].name)&&(_btnList[0][1].name!="none")){x=0;y=2;}

                        else if((_btnList[0][0].name==_btnList[2][1].name)&&(_btnList[0][0].name!="none")){x=2,y=0;}

                        else

                        {

                            var jx:Array = [0,1,1,2];

                            var jy:Array = [1,0,2,1];

                            

                            if(((_btnList[0][0].name==_btnList[1][1].name)&&(_btnList[1][1].name!="none"))||((_btnList[2][2].name==_btnList[1][1].name)&&(_btnList[1][1].name!="none")))

                            {

                                var l0:Array = [[0,2],[2,0]];

                                var s0:uint = Math.round(Math.random());

                                x = l0[s0][0]; y = l0[s0][1];    

                            }

                            else if(((_btnList[0][0].name==_btnList[2][2].name)&&(_btnList[0][0].name!="none"))||((_btnList[0][2].name==_btnList[2][0].name)&&(_btnList[0][2].name!="none")))

                            {

                                var ss0:uint = Math.round(Math.random());

                                x = jx[ss0]; y = jy[ss0];    

                            }

                            else if(((_btnList[0][2].name==_btnList[1][1].name)&&(_btnList[1][1].name!="none"))||((_btnList[2][0].name==_btnList[1][1].name)&&(_btnList[1][1].name!="none")))

                            {

                                var l1:Array = [[0,0],[2,2]];

                                var s1:uint = Math.round(Math.random());

                                x = l1[s1][0]; y = l1[s1][1];    

                            }

                            else

                            {

                                var r:uint = Math.round(Math.random()*3);

                                var r2:uint = Math.round(Math.random()*3);

                                x = jx[r];

                                y = jy[r2];

                            }

                        }

                    }

                }

            }

            else if(_count==8 || _count==9)

            {

                if(_btnList[1][1].name=="Black")

                {

                    x=y=0;

                }

                else if(_btnList[1][1].name=="none")

                {

                    x=y=1;

                }

            }

            else if(_count==7)

            {

                var jn1:Array = [0,2];

                var q:uint = Math.round(Math.random());

                var q2:uint = Math.round(Math.random());

                x = jn1[q];

                y = jn1[q2];

            }

            

            return new Array(x,y);

        }

        

        private function judge(name:String,flg:Boolean=false):void

        {

            for(var d:uint=0; d<3; d++)

            {

                if(_btnList[d][0].name != "none" && (_btnList[d][0].name == _btnList[d][1].name) && !_wFlg)

                {

                    if(_btnList[d][0].name == _btnList[d][2].name)

                    {

                        win(_btnList[d][0].name);

                        _wFlg = true;

                        

                    }

                }

                if(_btnList[0][d].name != "none" && (_btnList[0][d].name == _btnList[1][d].name) && !_wFlg)

                {

                    if(_btnList[0][d].name == _btnList[2][d].name)

                    {

                        win(_btnList[0][d].name);

                        _wFlg = true;

                    }

                }

            }

            

            if(_btnList[0][0].name != "none" && (_btnList[0][0].name == _btnList[1][1].name) && !_wFlg)

            {

                if(_btnList[1][1].name == _btnList[2][2].name)

                {

                    win(_btnList[0][0].name);

                    _wFlg = true;

                }

            }

            if(_btnList[0][2].name != "none" && (_btnList[0][2].name == _btnList[1][1].name) && !_wFlg)

            {

                if(_btnList[1][1].name == _btnList[2][0].name)

                {

                    win(_btnList[0][2].name);

                    _wFlg = true;

                }

            }

            

            if(_count == 0 && !_wFlg)

            {

                _dFlg = true;

                jt.visible = true;

                jt.text = "DRAW";

            }

            else if(flg && _count>0 && !_wFlg)

            {

                computer();

            }

        }

        

        private function win(name:String):void

        {

            jt.visible = true;

            if(_p && name=="Black"){jt.text = "YOU WIN!";}

            else if(_p && name=="White"){jt.text = "YOU LOST";}

            else if(!_p && name=="White"){jt.text = "YOU WIN!";}

            else{jt.text = "YOU LOST";}

        }

    }

}