/**
 * Copyright amane ( http://wonderfl.net/user/amane )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fG21G
 */

package  
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.ui.Mouse;

    [SWF(backgroundColor = "0x000000", frameRate = "24")]
    public class NewClass extends Sprite    {
        //メンバ変数
        private var m_iCount:int = 1000;                    //カウント
        private var m_aBall:Array;                        //Ballオブジェクト格納用配列
        private var m_nBounce:Number = -1;                    //跳返り
        private var m_nFriction:Number = 0.95;                //摩擦
        private var m_nTargetX:Number = stage.stageWidth / 2;                      //目標地点X
        private var m_nTargetY:Number = stage.stageHeight / 2;                      //目標地点Y
        private var m_oSprite:Sprite;                                            //base
        private var m_nSpring:Number = 0.001;                    //バネ
        private var m_nSpringLngth:Number = 60;                //バネの元の長さ
        private var m_nRefRight:Number = 0;                                      //壁(右)
        private var m_nRefLeft:Number = 0;                                       //壁(左)
        private var m_nRefBottom:Number = 0;                                     //壁(下)
        private var m_nRefTop:Number = 0;                                        //壁(上)
        
        
        //コンストラクタ
        public function NewClass() 
        {
            init();
        }
        
        public function init():void{
            //ウィンドウサイズに合わせる
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            //Ball作成
            m_oSprite = new Sprite();
            m_aBall = new Array();
            
            for (var i:int = 0; i < m_iCount; i++){
                var oBall:Ball = new Ball(Math.random() * 10 , Math.random() * 0xffffff);
                //randomで初期配置
                oBall.x = Math.random() * stage.stageWidth;
                oBall.y = Math.random() * stage.stageHeight;
                
                //loop処理用に配列に保持
                m_aBall.push(oBall);
                
                oBall.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
                m_oSprite.addChild(oBall);
            }
            addChild(m_oSprite);
            //イベントセット
            m_oSprite.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_UP, onRelease);
            
        }
        
        public function onEnterFrame(event:Event):void {
            
            var iCount:int;        //Target指定用の数値
            
            //バネの動き
            for (var i:int = 0; i < m_iCount; i++) {
                //跳ね返り
                Reflection(m_aBall[i]);
                
                //Dragしていない要素をSpring
                iCount = i;
                if (!m_aBall[i].drag) {
                    for (var j:int = 0; j < m_iCount - 1; j++) {
                        if (iCount == m_iCount - 1) {
                            //配列番号クリア
                            iCount = -1;
                        }
                        SpringTo(m_aBall[i], m_aBall[iCount+1]);
                        iCount+=1;
                    }
                }
            }
            
            //線描画
            graphics.clear();
            graphics.lineStyle(1, 0xffffff);
            graphics.moveTo(m_aBall[0].x, m_aBall[0].y);
            for (var k:int = 1; k < m_iCount; k++) {
                graphics.lineTo(m_aBall[k].x, m_aBall[k].y);
            }
            graphics.lineTo(m_aBall[0].x, m_aBall[0].y);
            
        }
        
        private function onPress(event:MouseEvent):void {
            
            //drag開始
            event.target.startDrag();
            for (var i:int = 0; i < m_iCount; i++) {
                if (event.target == m_aBall[i]) {
                    m_aBall[i].drag = true;
                }
            }
            
        }
        
        private function onRelease(event:MouseEvent):void {
            
            //drag終了
            for (var i:int = 0; i < m_iCount; i++) {
                m_aBall[i].stopDrag();
                m_aBall[i].drag = false;
            }
            
        }
        
        private function Reflection(oBall:Ball):void {
            
            //壁の座標
            m_nRefRight = stage.stageWidth;
            m_nRefBottom = stage.stageHeight;
            m_nRefTop = 0;
            m_nRefLeft = 0;
            
            //横方向
            if (oBall.x + oBall.radius > m_nRefRight) {
                //境界線ぴったりに移動
                oBall.x = m_nRefRight - oBall.radius;
                //進行方向を逆にセット
                oBall.vx *= m_nBounce
            }else if (oBall.x - oBall.radius < m_nRefLeft) {
                oBall.x = m_nRefLeft + oBall.radius;
                oBall.vx *= m_nBounce
            }
            //縦方向
            if (oBall.y + oBall.radius > m_nRefBottom) {
                oBall.y = m_nRefBottom - oBall.radius;
                oBall.vy *= m_nBounce
            }else if (oBall.y - oBall.radius < m_nRefTop) {
                oBall.y = m_nRefTop + oBall.radius;
                oBall.vy *= m_nBounce
            }
        }
        
        private function SpringTo(oBall_a:Ball, oBall_b:Ball):void {
            
            //到達点を求める(　oBall_bに対するoBall_aの到達点　)
            var nDistansX:Number = oBall_b.x - oBall_a.x;
            var nDistansY:Number = oBall_b.y - oBall_a.y;
            var nRadian:Number = Math.atan2(nDistansY, nDistansX);
            var nTargetX:Number = oBall_b.x - Math.cos(nRadian) * m_nSpringLngth;
            var nTargetY:Number = oBall_b.y - Math.sin(nRadian) * m_nSpringLngth;
            
            //バネ
            oBall_a.vx += (nTargetX - oBall_a.x) * m_nSpring;
            oBall_a.vy += (nTargetY - oBall_a.y) * m_nSpring;
            //摩擦
            oBall_a.vx *= m_nFriction;
            oBall_a.vy *= m_nFriction;
            //移動
            oBall_a.x += oBall_a.vx + 0.03;
            oBall_a.y += oBall_a.vy + 0.03;
            
        }
        
    }
    
}
    import flash.display.Sprite; 
    import flash.events.Event; 
    internal class Ball extends Sprite{ 
        //プロパティ 
        public var vx:Number = 0;                //速度X 
       public var vy:Number = 0;                //速度Y     
       public var radius:Number;                //半径 
        public var color:uint;                     //32 ビットの符号なし整数（intの 2 倍） 
        public var drag:Boolean;                    //Drag flg
         
        //コンストラクタ 
        public function Ball(nRadius:Number=40,uiColor:uint=0xff0000){ 
            this.radius = nRadius; 
            this.color = uiColor; 
            init(); 
        } 
         
        public function init():void{ 
            graphics.beginFill(color); 
            graphics.drawCircle(0,0,radius); 
            graphics.endFill(); 
        } 
    } 