/**
 * Copyright Nos_lkSsvOhB ( http://wonderfl.net/user/Nos_lkSsvOhB )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fEoK
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.ui.Keyboard;
    import com.bit101.components.HUISlider;
    
    /**
     * ...
     * @author Nosuke
     */
    public class Main extends Sprite
    {
        private var n:int = 5;
        private var defaultXoffset:int = 20;
        private var xoffset:int = defaultXoffset;
        private var yoffset:int = 50;
        private var pnlWid:int;
        private var pnlHei:int;
        private var xblank:int;
        private var yblank:int;
        private var temp:int;
        private var tempA:Array = new Array(2);
        private var c:int;
        private var pnlArr:Array = new Array();
        private var posiArr:Array = new Array();
        private var shlArr:Array = new Array();
        private var ansArr:Array = new Array();
        private var evenTransFlag:Boolean;
        private var clearFlag:Boolean = false;
        private var sliderNum:HUISlider;
        public var opeFlag:Boolean = false;
        private const PANEL_UP:int = 1;
        private const PANEL_DOWN:int = 2;
        private const PANEL_LEFT:int = 3;
        private const PANEL_RIGHT:int = 4;
        
        public function Main():void
        {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            sliderNum = new HUISlider(this, 40, 15, "n*n", sliderHandler);
            sliderNum.value = n;
            sliderNum.maximum = 10;
            sliderNum.minimum = 2;
            sliderNum.labelPrecision = 0;
            start();
        }
        
        private function start():void
        {
            xblank = n - 1;
            yblank = n - 1;
            if (stage.stageWidth >= stage.stageHeight)
            {
                pnlWid = int((stage.stageHeight - (defaultXoffset + yoffset)) / n);
                pnlHei = pnlWid;
                xoffset = int((stage.stageWidth - n * pnlWid) / 2);
            }
            else
            {
                pnlWid = int((stage.stageWidth - (defaultXoffset + yoffset)) / n);
                pnlHei = pnlWid;
                xoffset = int((stage.stageWidth - n * pnlWid) / 2);
            }
            c = 0;
            for (var i:int = 0; i < n; i++)
            {
                pnlArr[i] = new Array();
                posiArr[i] = new Array();
                for (var j:int = 0; j < n; j++)
                {
                    ansArr[c] = c;
                    pnlArr[i][j] = new Panel(i * n + j, xoffset + pnlWid * j, yoffset + pnlHei * i, pnlWid, pnlHei, this);
                    pnlArr[i][j].addEventListener(MouseEvent.MOUSE_DOWN, eventHandler);
                    posiArr[i][j] = i * n + j;
                    c++;
                }
            }
            pnlArr[n - 1][n - 1].xy(-pnlWid - 10, -pnlWid - 10);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, eventHandler);
            shuffleArr(posiArr);
            dispPnl(posiArr);
            opeFlag = true;
        }
        
        private function sliderHandler(e:Event):void
        {
            var postNum:int = Math.round(sliderNum.value);
            if (postNum != n)
            {
                stage.removeEventListener(KeyboardEvent.KEY_DOWN, eventHandler);
                while (this.numChildren > 1)
                {
                    this.removeChildAt(this.numChildren - 1);
                }
                if (postNum < n)
                {
                    pnlArr.splice(postNum, n - postNum);
                    posiArr.splice(postNum, n - postNum);
                    shlArr.splice(postNum * postNum, n * n - postNum * postNum);
                    ansArr.splice(postNum * postNum, n * n - postNum * postNum);
                    for (var i:int = 0; i < pnlArr.length; i++)
                    {
                        pnlArr[i].splice(postNum, n - postNum);
                        posiArr[i].splice(postNum, n - postNum);
                    }
                }
                n = postNum;
                start();
            }
        }
        
        private function eventHandler(e:Event):void
        {
            if (opeFlag)
            {
                if (e is KeyboardEvent)
                    keyDownHandler(KeyboardEvent(e));
                else if (e is MouseEvent)
                    mouseDownHandler(MouseEvent(e));
                judgeAnswer(posiArr);
                if (opeFlag == false && clearFlag == true)
                {
                    //clear operation
                    pnlArr[n - 1][n - 1].xy(xoffset + pnlWid * (n - 1), yoffset + pnlHei * (n - 1));
                    removeEvent();
                }
            }
        }
        
        private function keyDownHandler(e:KeyboardEvent):void
        {
            switch (e.keyCode)
            {
                case Keyboard.UP: 
                    if (yblank < n - 1)
                    {
                        panelMove(PANEL_UP);
                    }
                    break;
                case Keyboard.DOWN: 
                    if (yblank > 0)
                    {
                        panelMove(PANEL_DOWN);
                    }
                    break;
                case Keyboard.LEFT: 
                    if (xblank < n - 1)
                    {
                        panelMove(PANEL_LEFT);
                    }
                    break;
                case Keyboard.RIGHT: 
                    if (xblank > 0)
                    {
                        panelMove(PANEL_RIGHT);
                    }
                    break;
            }
        }
        
        private function mouseDownHandler(e:MouseEvent):void
        {
            //trace("root:" + e.target.parent.parent.name);
            for (var i:int = 0; i < n; i++)
            {
                for (var j:int = 0; j < n; j++)
                {
                    if (posiArr[i][j] == e.target.parent.insNum)
                    {
                        tempA[0] = i;
                        tempA[1] = j;
                    }
                }
            }
            i = tempA[0];
            j = tempA[1];
            //Key UP
            if (yblank + 1 == i && xblank == j)
            {
                panelMove(PANEL_UP);
            }
            //Key DOWN
            if (yblank - 1 == i && xblank == j)
            {
                panelMove(PANEL_DOWN);
            }
            //Key LEFT
            if (yblank == i && xblank + 1 == j)
            {
                panelMove(PANEL_LEFT);
            }
            //Key RIGHT
            if (yblank == i && xblank - 1 == j)
            {
                panelMove(PANEL_RIGHT);
            }
        }
        
        private function panelMove(panelOpe:int):void
        {
            switch (panelOpe)
            {
                case PANEL_UP: 
                    temp = posiArr[yblank + 1][xblank];
                    posiArr[yblank + 1][xblank] = posiArr[yblank][xblank];
                    posiArr[yblank][xblank] = temp;
                    pnlArr[int(temp / n)][temp % n].plusXY(0, -pnlHei);
                    yblank++;
                    break;
                case PANEL_DOWN: 
                    temp = posiArr[yblank - 1][xblank];
                    posiArr[yblank - 1][xblank] = posiArr[yblank][xblank];
                    posiArr[yblank][xblank] = temp;
                    pnlArr[int(temp / n)][temp % n].plusXY(0, pnlHei);
                    yblank--;
                    break;
                case PANEL_LEFT: 
                    temp = posiArr[yblank][xblank + 1];
                    posiArr[yblank][xblank + 1] = posiArr[yblank][xblank];
                    posiArr[yblank][xblank] = temp;
                    pnlArr[int(temp / n)][temp % n].plusXY(-pnlWid, 0);
                    xblank++;
                    break;
                case PANEL_RIGHT: 
                    temp = posiArr[yblank][xblank - 1];
                    posiArr[yblank][xblank - 1] = posiArr[yblank][xblank];
                    posiArr[yblank][xblank] = temp;
                    pnlArr[int(temp / n)][temp % n].plusXY(pnlWid, 0);
                    xblank--;
                    break;
            }
        }
        
        private function shuffleArr(arr:Array):void
        {
            var i:int;
            var rn:int;
            var nEVEN:int = n * n;
            for (i = 0; i < n * n; i++)
            {
                shlArr[i] = i;
            }
            if (int(n / 2) != n / 2)
                nEVEN--;
            for (i = 0; i < nEVEN; i++)
            {
                do
                {
                    rn = int(Math.random() * n * n);
                } while (rn == i);
                temp = shlArr[rn];
                shlArr[rn] = shlArr[i];
                shlArr[i] = temp;
                if (((shlArr[rn] == n * n - 1) || (shlArr[i] == n * n - 1)) && judgeEVEN(rn, i))
                    i--;
            }
            for (i = 0; i < n * n; i++)
            {
                arr[int(i / n)][i % n] = shlArr[i];
                if (shlArr[i] == n * n - 1)
                {
                    xblank = i % n;
                    yblank = int(i / n);
                }
            }
        }
        
        private function dispPnl(arr:Array):void
        {
            for (var i:int = 0; i < n; i++)
            {
                for (var j:int = 0; j < n; j++)
                {
                    temp = arr[i][j];
                    if (temp != n * n - 1)
                    {
                        pnlArr[int(temp / n)][temp % n].xy(xoffset + pnlWid * j, yoffset + pnlHei * i);
                    }
                }
            }
        }
        
        private function judgeEVEN(a:int, b:int):Boolean
        {
            if (n % 2 == 0)
            {
                evenTransFlag = (((int(a / n) % 2 == 0) && a % 2 == 0) || ((int(a / n) % 2 != 0) && a % 2 != 0)) != (((int(b / n) % 2 == 0) && b % 2 == 0) || ((int(b / n) % 2 != 0) && b % 2 != 0));
            }
            else
            {
                evenTransFlag = (a % 2 == 0) != (b % 2 == 0);
            }
            return evenTransFlag;
        }
        
        private function judgeAnswer(arr:Array):void
        {
            if (arr.toString() == ansArr.toString())
            {
                opeFlag = false;
                clearFlag = true;
            }
        }
        
        private function removeEvent():void
        {
            for (var i:int = 0; i < n; i++)
            {
                for (var j:int = 0; j < n; j++)
                {
                    pnlArr[i][j].removeEventListener(MouseEvent.MOUSE_DOWN, eventHandler);
                }
            }
            stage.removeEventListener(KeyboardEvent.KEY_DOWN, eventHandler);
        }
    }
}

import flash.display.*;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.BlurFilter;

class Panel extends Sprite
{
    private var panelDesign:PanelDesign;
    private var blur:BlurFilter = new BlurFilter();
    private var num:int;
    
    public var panelWidth:int;
    public var panelHeight:int;
    public var insNum:int;
    
    public function Panel(n:int, xpos:int, ypos:int, wid:int, hei:int, parent:Sprite)
    {
        super();
        panelWidth = wid;
        panelHeight = hei;
        insNum = n;
        num = n + 1;
        
        parent.addChild(this);
        this.x = xpos;
        this.y = ypos;
        
        panelDesign = new PanelDesign(num, this);
        this.addChild(panelDesign);
        
        var maskSp:Sprite = new Sprite();
        maskSp.graphics.lineStyle(0, 0x000000, 0);
        maskSp.graphics.beginFill(0x000000, 0);
        maskSp.graphics.moveTo(0, 0);
        maskSp.graphics.lineTo(wid, 0);
        maskSp.graphics.lineTo(wid, hei);
        maskSp.graphics.lineTo(0, hei);
        maskSp.graphics.lineTo(0, 0);
        maskSp.graphics.endFill();
        this.addChild(maskSp);
        blur.blurX = 1.2;
        blur.blurY = 1.2;
        this.filters = [blur];
    }
    
    public function plusXY(xplus:int, yplus:int):void
    {
        this.parent["opeFlag"] = false;
        this.x += xplus;
        this.y += yplus;
        this.parent["opeFlag"] = true;
    }
    
    public function xy(xpos:int, ypos:int):void
    {
        this.x = xpos;
        this.y = ypos;
    }
}

import flash.display.Sprite;
import frocessing.display.*;
import flash.filters.BlurFilter;
import flash.text.*;

class PanelDesign extends F5MovieClip2D
{
    private var stageWidth:Number;
    private var stageHeight:Number;
    private var n:int = 5;
    private var t:Number = 0;
    private var bg:F5MovieClip2D;
    private var blur:BlurFilter = new BlurFilter();
    private var num:int;
    
    public function PanelDesign(num:int, parent:Sprite, useStageEvent:Boolean = true)
    {
        super(useStageEvent);
        stageWidth = parent["panelWidth"];
        stageHeight = parent["panelHeight"];
        this.num = num;
    }
    
    public function setup():void
    {
        size(stageWidth, stageHeight);
        noStroke();
        //frame
        fill(0x2BD7D7, 1);
        rect(0, 0, stageWidth * 7 / 8, stageHeight * 7 / 8, stageWidth / 6, stageHeight / 6);
        //inner
        fill(0x29CC3E, 1);
        rect(stageWidth * 1 / 16, stageHeight * 1 / 16, stageWidth * 6 / 8, stageHeight * 6 / 8, stageWidth / 6, stageHeight / 6);
        bg = new F5MovieClip2D();
        //shadow
        bg.fill(0x000000, 1);
        bg.rect(stageWidth * 1 / 16, stageHeight * 1 / 16, stageWidth * 9 / 10, stageHeight * 9 / 10, stageWidth / 6, stageHeight / 6);
        blur.blurX = 6;
        blur.blurY = 6;
        bg.filters = [blur];
        this.addChildAt(bg, 0);
        
        var txFormat:TextFormat = new TextFormat("_sans", stageWidth * 0.7, 0x000000, true);
        var numTXT:TextField = new TextField();
        numTXT.defaultTextFormat = txFormat;
        numTXT.autoSize = "center"; //TextFieldAutoSize.CENTER;
        numTXT.x = -stageWidth * 1 / 16;
        numTXT.y = 0;
        numTXT.width = stageWidth;
        numTXT.height = stageHeight;
        numTXT.text = String(num);
        numTXT.selectable = false;
        this.addChild(numTXT);
    }
}