/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fERG
 */

// forked from k__'s Simple instrument
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    public class Main extends Sprite {
        private var xNum:uint =8;
        private var yNum:uint =8;
        private var isMouseDown:Boolean = false;
        private var gridW:Number,gridH:Number;
        private var xPos:uint = 0, yPos:uint = 0;
        private var canvas:BitmapData;
        private var canvasRect:Rectangle;
        private var oPt:Point;
        private var filter:ColorMatrixFilter;
        private var cursor:Shape;
        private const COLOR_OVER:uint = 0xff0000;
        
        

        
        public function Main() {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, h_mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, h_mouseUp);
            addEventListener(Event.ENTER_FRAME, h_enterFrame);
            
            addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xffffff)));
            canvasRect = canvas.rect;
            oPt = new Point(0,0);
            addChild(cursor = new Shape());
            cursor.alpha = 0.5;
            filter = new ColorMatrixFilter(
                                           [0.96,0,0,0,0,
                                            0,0.97,0,0,0,
                                            0,0,0.98,0,0,
                                            0,0,0,1.0,0]);
            
            gridW = stage.stageWidth / xNum;
            gridH = stage.stageHeight / yNum;
        }
        
        private function h_enterFrame(evt:Event):void {
            xPos = mouseX / gridW;
            yPos = mouseY / gridH;
            var g:Graphics = cursor.graphics;
            g.clear();
            g.beginFill(COLOR_OVER);
            g.drawRect(xPos * gridW, yPos * gridH, gridW, gridH);
            g.endFill();
            canvas.applyFilter(canvas,canvasRect,oPt,filter);
        }
        
        private function h_mouseDown(evt:MouseEvent):void {
            isMouseDown = true;
            canvas.draw(cursor);
            var s:SoundPlayer = new SoundPlayer(xPos + (yNum - yPos) * xNum,xNum, 2000);
        }
        private function h_mouseUp(evt:MouseEvent):void {
            isMouseDown = false;
        }
    }
}

import flash.events.*;
import flash.media.*;
import flash.utils.ByteArray;
class SoundPlayer extends EventDispatcher {
    private var sound:Sound;
    private var channel:SoundChannel;
    private var pitch:uint;
    private var freq:Number;
    private var div:uint;
    private var duration:uint;
    private const ATTACK:uint = 100;
    private const DECAY:uint = 1900;

    public function SoundPlayer(p:uint, di:uint, du:uint) {
        sound = new Sound();
        sound.addEventListener(SampleDataEvent.SAMPLE_DATA, h_sampleData);
        pitch = p;
        div = di;
        duration = du;
        freq = Math.pow(2, pitch / di) * 55;
        channel = sound.play();
    }
    
    private function h_sampleData(evt:SampleDataEvent):void {
        var wavelev:Number;
        var lev:Number = 1;
        var flag:Boolean;
        for (var i:uint = 0; i < 8192; i++) {
            if ((evt.position + i) < 44.1 * ATTACK) {
                lev = (evt.position + i) / (44.1 * ATTACK);
            }
            if ((evt.position + i) > 44.1 * (duration - DECAY)) {
                lev = (duration * 44.1 - (evt.position + i)) / (DECAY * 44.1);
            }
            if (evt.position + i > 44.1 * duration) {
                sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, h_sampleData);
                break;
            }
            wavelev = Math.sin((i + evt.position) * Math.PI / (44100 / freq)) / 4 * lev;
            evt.data.writeFloat(wavelev);
            evt.data.writeFloat(wavelev);
        }
    }
}